# include "Globals.h"
# include "yyGlobal.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 49 "Globals.puma"

# include "Idents.h"
# include "StringMe.h"
# include "Types.h"      /* IntrFuncRed */
# include "protocol.h"

# include "MoveCont.h"          /* CountMovement */
# include "Transfor.h"            /* ExpToVarParam */

# include "Dalib.h"                /* DALIB parameters */
# include "Expressi.h"          /* MakeConstant     */


static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Globals, routine %s failed\n", yyFunction);
 exit (1);
}

static bool FullParameters ARGS((tTree plist));
static void GlobalTestFullParams ARGS((tTree plist));
static void GlobalTestIndexes ARGS((tTree a, tTree indexlist, int n));
static void CheckIndexParam ARGS((tTree a, tTree p, tTree ptype));
static void GlobalTestConform ARGS((tTree a, tTree b));
static void GlobalTestMask ARGS((tTree a, tTree mask, tTree masktype));
void SplitGet ARGS((tTree params, int * rank, tTree * A_, tTree * B_, tTree * indexes, tTree * Mask));
void SplitSend ARGS((tTree params, int * rank, tTree * A_, tTree * B_, tTree * indexes, tTree * Mask, tTree * op));
static void SplitParams ARGS((tTree plist, int n, tTree * tail));
static void FindGetMask ARGS((tTree plist, tTree * mask));
static void FindSend ARGS((tTree plist, tTree * arr, tTree * mask, tTree * op));
void CheckGlobalGetParams ARGS((tTree parameter_list));
void CheckGlobalSendParams ARGS((tTree parameter_list));
tTree GenGlobalGet ARGS((tTree parameter_list));
tTree GenGlobalSend ARGS((tTree parameter_list));
static void GetTheIndexes ARGS((tTree indexes, int rank, tTree * last));
static void ConcatParams ARGS((tTree indexes, tTree params));
static int GenGlobalSendOp ARGS((tTree type, tIdent redfunc));
static tIdent FuncName ARGS((tTree f));

static bool FullParameters
# if defined __STDC__ | defined __cplusplus
(register tTree plist)
# else
(plist)
 register tTree plist;
# endif
{
  if (plist == NoTree) return false;
  if (plist->Kind == kBTP_LIST) {
  if (plist->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (plist->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 72 "Globals.puma"
  {
# line 73 "Globals.puma"
   if (! (FullParameters (plist->BTP_LIST.Next))) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  if (plist->BTP_LIST.Elem->Kind == kFUNC_PARAM) {
  if (plist->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 76 "Globals.puma"
   return true;

  }
  }
  }
  if (plist->Kind == kBTP_EMPTY) {
# line 80 "Globals.puma"
   return true;

  }
  return false;
}

static void GlobalTestFullParams
# if defined __STDC__ | defined __cplusplus
(register tTree plist)
# else
(plist)
 register tTree plist;
# endif
{
  if (plist == NoTree) return;
  if (plist->Kind == kBTP_LIST) {
  if (plist->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (plist->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 85 "Globals.puma"
  {
# line 87 "Globals.puma"
   GlobalTestFullParams (plist->BTP_LIST.Next);
  }
   return;

  }
  if (plist->BTP_LIST.Elem->VAR_PARAM.V->Kind == kINDEXED_VAR) {
# line 90 "Globals.puma"
  {
# line 91 "Globals.puma"
   error_protocol ("only full variables for global send/get");
# line 92 "Globals.puma"
   tree_protocol ("this parameter is wrong : ", plist->BTP_LIST.Elem->VAR_PARAM.V);
# line 93 "Globals.puma"
   GlobalTestFullParams (plist->BTP_LIST.Next);
  }
   return;

  }
  if (plist->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
# line 96 "Globals.puma"
  {
# line 97 "Globals.puma"
   error_protocol ("no parameter expressions for global send/get");
# line 98 "Globals.puma"
   tree_protocol ("this parameter is wrong : ", plist->BTP_LIST.Elem->VAR_PARAM.V);
# line 99 "Globals.puma"
   GlobalTestFullParams (plist->BTP_LIST.Next);
  }
   return;

  }
  }
  if (plist->BTP_LIST.Elem->Kind == kFUNC_PARAM) {
  if (plist->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 102 "Globals.puma"
  {
# line 104 "Globals.puma"
 if (!IntrFuncRed (plist->BTP_LIST.Elem->FUNC_PARAM.F->PROC_OBJ.Ident))
       { error_protocol ("function must be a reduction");
         tree_protocol ("function name is : ", plist->BTP_LIST.Elem);
       }

  }
   return;

  }
# line 111 "Globals.puma"
  {
# line 112 "Globals.puma"
   error_protocol ("reduction must be last parameter");
# line 113 "Globals.puma"
   tree_protocol ("reduction function is : ", plist->BTP_LIST.Elem);
# line 114 "Globals.puma"
   GlobalTestFullParams (plist->BTP_LIST.Next);
  }
   return;

  }
# line 117 "Globals.puma"
  {
# line 118 "Globals.puma"
   error_protocol ("illegal parameter for global send/get");
# line 119 "Globals.puma"
   tree_protocol ("this parameter is wrong : ", plist->BTP_LIST.Elem);
# line 120 "Globals.puma"
   GlobalTestFullParams (plist->BTP_LIST.Next);
  }
   return;

  }
  if (plist->Kind == kBTP_EMPTY) {
# line 123 "Globals.puma"
   return;

  }
# line 126 "Globals.puma"
  {
# line 127 "Globals.puma"
   error_protocol ("GlobalTestFullParams failed\n");
# line 128 "Globals.puma"
   printf ("GlobalTestFullParams failed\n");
# line 129 "Globals.puma"
   WriteTree (stdout, plist);
# line 130 "Globals.puma"
   kill_in_protocol ();
  }
   return;

;
}

static void GlobalTestIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree a, register tTree indexlist, register int n)
# else
(a, indexlist, n)
 register tTree a;
 register tTree indexlist;
 register int n;
# endif
{
  if (a == NoTree) return;
  if (indexlist == NoTree) return;
  if (equalint (n, 0)) {
# line 148 "Globals.puma"
   return;

  }
  if (indexlist->Kind == kBTP_LIST) {
  if (indexlist->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 151 "Globals.puma"
  {
# line 152 "Globals.puma"
   CheckIndexParam (a, indexlist->BTP_LIST.Elem->VAR_PARAM.V, TreeType (indexlist->BTP_LIST.Elem->VAR_PARAM.V));
# line 153 "Globals.puma"
   GlobalTestIndexes (a, indexlist->BTP_LIST.Next, n - 1);
  }
   return;

  }
  }
# line 156 "Globals.puma"
  {
# line 157 "Globals.puma"
   printf ("Test of %d indexes failed\n", n);
# line 158 "Globals.puma"
   WriteTree (stdout, a);
# line 159 "Globals.puma"
   WriteTree (stdout, indexlist);
  }
   return;

;
}

static void CheckIndexParam
# if defined __STDC__ | defined __cplusplus
(register tTree a, register tTree p, register tTree ptype)
# else
(a, p, ptype)
 register tTree a;
 register tTree p;
 register tTree ptype;
# endif
{
  if (a == NoTree) return;
  if (p == NoTree) return;
  if (ptype == NoTree) return;
  if (ptype->Kind == kINTEGER_TYPE) {
  if (equalint (ptype->INTEGER_TYPE.size, 4)) {
# line 164 "Globals.puma"
  {
# line 166 "Globals.puma"
  if (TreeRank (p) != TreeRank (a))
         { error_protocol ("rank conflict for index in global get/send");
           tree_protocol  ("this is the integer index : ", p);
           tree_protocol  ("must have same rank as : ", a);
         }

  }
   return;

  }
# line 174 "Globals.puma"
  {
# line 175 "Globals.puma"
   error_protocol ("illegal index type in global get/send");
# line 176 "Globals.puma"
   tree_protocol ("index not integer*4 : ", p);
  }
   return;

  }
# line 179 "Globals.puma"
  {
# line 180 "Globals.puma"
   error_protocol ("index vector not integer in global get/send");
# line 181 "Globals.puma"
   tree_protocol ("index vector is : ", p);
# line 182 "Globals.puma"
   tree_protocol ("this is the index type : ", ptype);
  }
   return;

;
}

static void GlobalTestConform
# if defined __STDC__ | defined __cplusplus
(register tTree a, register tTree b)
# else
(a, b)
 register tTree a;
 register tTree b;
# endif
{
  if (a == NoTree) return;
  if (b == NoTree) return;
# line 198 "Globals.puma"
 {
  tTree type_a;
  tTree type_b;
  bool ok;
  {
# line 199 "Globals.puma"

# line 200 "Globals.puma"

# line 202 "Globals.puma"

# line 204 "Globals.puma"
 type_a = TreeType (a);
     type_b = TreeType (b);
     ok     = true;

     if (TreeSize (a) != TreeSize (b))
         { error_protocol ("source and target must have same size");
           tree_protocol ("source is ", b);
           tree_protocol ("source size is ", type_a);
           tree_protocol ("target is ", a);
           tree_protocol ("target size is ", type_b);
           ok = false;
         }

      if (type_a->Kind != type_b->Kind)
         { error_protocol ("source and target must have same type");
           tree_protocol ("source is ", b);
           tree_protocol ("source type is ", type_a);
           tree_protocol ("target is ", a);
           tree_protocol ("target type is ", type_b);
           ok = false;
         }

  }
   return;
 }

;
}

static void GlobalTestMask
# if defined __STDC__ | defined __cplusplus
(register tTree a, register tTree mask, register tTree masktype)
# else
(a, mask, masktype)
 register tTree a;
 register tTree mask;
 register tTree masktype;
# endif
{
  if (a == NoTree) return;
  if (mask == NoTree) return;
  if (masktype == NoTree) return;
  if (masktype->Kind == kBOOLEAN_TYPE) {
  if (equalint (masktype->BOOLEAN_TYPE.size, 4)) {
# line 242 "Globals.puma"
  {
# line 244 "Globals.puma"
  if (TreeRank (mask) != TreeRank (a))
         { error_protocol ("rank conflict for mask in global get/send");
           tree_protocol  ("this is the mask : ", mask);
           tree_protocol  ("must have same rank as : ", a);
         }

  }
   return;

  }
# line 252 "Globals.puma"
  {
# line 253 "Globals.puma"
   error_protocol ("illegal mask type in global get/send");
# line 254 "Globals.puma"
   tree_protocol ("mask not logical*4 : ", mask);
  }
   return;

  }
# line 257 "Globals.puma"
  {
# line 258 "Globals.puma"
   error_protocol ("mask not logical in global get/send");
# line 259 "Globals.puma"
   tree_protocol ("mask is : ", mask);
# line 260 "Globals.puma"
   tree_protocol ("this is the mask type : ", masktype);
  }
   return;

;
}

void SplitGet
# if defined __STDC__ | defined __cplusplus
(register tTree params, register int * rank, register tTree * A_, register tTree * B_, register tTree * indexes, register tTree * Mask)
# else
(params, rank, A_, B_, indexes, Mask)
 register tTree params;
 register int * rank;
 register tTree * A_;
 register tTree * B_;
 register tTree * indexes;
 register tTree * Mask;
# endif
{
  if (params == NoTree) return;
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 293 "Globals.puma"
 {
  int b_rank;
  tTree tail1;
  tTree M;
  int len;
  {
# line 296 "Globals.puma"

# line 297 "Globals.puma"

# line 298 "Globals.puma"

# line 299 "Globals.puma"

# line 301 "Globals.puma"
 b_rank = TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V);
      if (TreeListLength (params->BTP_LIST.Next->BTP_LIST.Next) < b_rank)
         { error_protocol ("not enough indexes in global get");
           M = NoTree;
         }
        else
         { SplitParams (params->BTP_LIST.Next->BTP_LIST.Next, b_rank, &tail1);
           FindGetMask (tail1, &M);
         }

  }
   * rank = b_rank;
   * A_ = params->BTP_LIST.Elem->VAR_PARAM.V;
   * B_ = params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V;
   * indexes = params->BTP_LIST.Next->BTP_LIST.Next;
   * Mask = M;
   return;
 }

  }
  }
  }
  }
# line 313 "Globals.puma"
  {
# line 314 "Globals.puma"
   error_protocol ("use must be : global_get (A, B, I1, .., In [,M])");
  }
   * rank = 0;
   * A_ = NoTree;
   * B_ = NoTree;
   * indexes = NoTree;
   * Mask = NoTree;
   return;

;
}

void SplitSend
# if defined __STDC__ | defined __cplusplus
(register tTree params, register int * rank, register tTree * A_, register tTree * B_, register tTree * indexes, register tTree * Mask, register tTree * op)
# else
(params, rank, A_, B_, indexes, Mask, op)
 register tTree params;
 register int * rank;
 register tTree * A_;
 register tTree * B_;
 register tTree * indexes;
 register tTree * Mask;
 register tTree * op;
# endif
{
  if (params == NoTree) return;
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 326 "Globals.puma"
 {
  int b_rank;
  tTree tail1;
  tTree A;
  tTree M;
  tTree red_op;
  {
# line 328 "Globals.puma"

# line 329 "Globals.puma"

# line 330 "Globals.puma"

# line 331 "Globals.puma"

# line 332 "Globals.puma"

# line 334 "Globals.puma"
 b_rank = TreeRank (params->BTP_LIST.Elem->VAR_PARAM.V);
      if (TreeListLength (params->BTP_LIST.Next) < b_rank+1)
         { error_protocol ("not enough indexes in global send");
           M    = NoTree;
           A    = NoTree;
         }
        else
         { SplitParams (params->BTP_LIST.Next, b_rank, &tail1);
           FindSend (tail1, &A, &M, &red_op);
         }

  }
   * rank = b_rank;
   * A_ = A;
   * B_ = params->BTP_LIST.Elem->VAR_PARAM.V;
   * indexes = params->BTP_LIST.Next;
   * Mask = M;
   * op = red_op;
   return;
 }

  }
  }
# line 347 "Globals.puma"
  {
# line 348 "Globals.puma"
   error_protocol ("use must be : global_send (B, I1, .., In, A [,M]) [,op]");
  }
   * rank = 0;
   * A_ = NoTree;
   * B_ = NoTree;
   * indexes = NoTree;
   * Mask = NoTree;
   * op = NoTree;
   return;

;
}

static void SplitParams
# if defined __STDC__ | defined __cplusplus
(register tTree plist, register int n, register tTree * tail)
# else
(plist, n, tail)
 register tTree plist;
 register int n;
 register tTree * tail;
# endif
{
  if (plist == NoTree) return;
  if (equalint (n, 0)) {
# line 363 "Globals.puma"
   * tail = plist;
   return;

  }
  if (plist->Kind == kBTP_LIST) {
# line 366 "Globals.puma"
 {
  tTree yyV1;
  {
# line 367 "Globals.puma"
   SplitParams (plist->BTP_LIST.Next, n - 1, & yyV1);
  }
   * tail = yyV1;
   return;
 }

  }
  if (plist->Kind == kBTP_EMPTY) {
# line 370 "Globals.puma"
   * tail = plist;
   return;

  }
# line 373 "Globals.puma"
  {
# line 374 "Globals.puma"
   printf ("SplitParams failed\n");
# line 375 "Globals.puma"
   WriteTree (stdout, plist);
# line 376 "Globals.puma"
   kill_in_protocol ();
  }
   * tail = NoTree;
   return;

;
}

static void FindGetMask
# if defined __STDC__ | defined __cplusplus
(register tTree plist, register tTree * mask)
# else
(plist, mask)
 register tTree plist;
 register tTree * mask;
# endif
{
  if (plist == NoTree) return;
  if (plist->Kind == kBTP_EMPTY) {
# line 389 "Globals.puma"
   * mask = NoTree;
   return;

  }
  if (plist->Kind == kBTP_LIST) {
  if (plist->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (plist->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 392 "Globals.puma"
   * mask = plist->BTP_LIST.Elem->VAR_PARAM.V;
   return;

  }
# line 395 "Globals.puma"
  {
# line 396 "Globals.puma"
   error_protocol ("too many parameters in global get");
  }
   * mask = plist->BTP_LIST.Elem->VAR_PARAM.V;
   return;

  }
  if (plist->BTP_LIST.Elem->Kind == kFUNC_PARAM) {
# line 399 "Globals.puma"
  {
# line 400 "Globals.puma"
   error_protocol ("no reduction op allowed in global get");
  }
   * mask = NoTree;
   return;

  }
  }
;
}

static void FindSend
# if defined __STDC__ | defined __cplusplus
(register tTree plist, register tTree * arr, register tTree * mask, register tTree * op)
# else
(plist, arr, mask, op)
 register tTree plist;
 register tTree * arr;
 register tTree * mask;
 register tTree * op;
# endif
{
  if (plist == NoTree) return;
# line 413 "Globals.puma"
  {
# line 414 "Globals.puma"
   if (! (plist == NoTree)) goto yyL1;
  {
# line 415 "Globals.puma"
   error_protocol ("missing source array in global send");
  }
  }
   * arr = NoTree;
   * mask = NoTree;
   * op = NoTree;
   return;
yyL1:;

  if (plist->Kind == kBTP_LIST) {
  if (plist->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (plist->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 418 "Globals.puma"
   * arr = plist->BTP_LIST.Elem->VAR_PARAM.V;
   * mask = NoTree;
   * op = NoTree;
   return;

  }
  if (plist->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (plist->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (plist->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 421 "Globals.puma"
   * arr = plist->BTP_LIST.Elem->VAR_PARAM.V;
   * mask = plist->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V;
   * op = NoTree;
   return;

  }
  if (plist->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (plist->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem->Kind == kFUNC_PARAM) {
  if (plist->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 429 "Globals.puma"
   * arr = plist->BTP_LIST.Elem->VAR_PARAM.V;
   * mask = plist->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V;
   * op = plist->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem;
   return;

  }
  }
  }
  }
  if (plist->BTP_LIST.Next->BTP_LIST.Elem->Kind == kFUNC_PARAM) {
  if (plist->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 425 "Globals.puma"
   * arr = plist->BTP_LIST.Elem->VAR_PARAM.V;
   * mask = NoTree;
   * op = plist->BTP_LIST.Next->BTP_LIST.Elem;
   return;

  }
  }
  }
  }
  }
# line 434 "Globals.puma"
  {
# line 435 "Globals.puma"
   error_protocol ("illegal parameters in global send");
# line 436 "Globals.puma"
   print_protocol ("use must be : global_send (B, I1, .., In, A [,M]) [,op]");
  }
   * arr = NoTree;
   * mask = NoTree;
   * op = NoTree;
   return;

;
}

void CheckGlobalGetParams
# if defined __STDC__ | defined __cplusplus
(register tTree parameter_list)
# else
(parameter_list)
 register tTree parameter_list;
# endif
{
  if (parameter_list == NoTree) return;
# line 462 "Globals.puma"
  {
# line 463 "Globals.puma"
   if (! ((TreeListLength (parameter_list) < 3))) goto yyL1;
  {
# line 464 "Globals.puma"
   error_protocol ("global get requires at least 3 parameters (A,B,P,..)");
  }
  }
   return;
yyL1:;

# line 467 "Globals.puma"
  {
# line 468 "Globals.puma"
   if (! ((FullParameters (parameter_list) == false))) goto yyL2;
  {
# line 470 "Globals.puma"
   GlobalTestFullParams (parameter_list);
  }
  }
   return;
yyL2:;

# line 473 "Globals.puma"
 {
  int yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
# line 475 "Globals.puma"
   SplitGet (parameter_list, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
# line 477 "Globals.puma"

     if (TreeListLength (yyV4) >= yyV1)
        GlobalTestIndexes (yyV2, yyV4, yyV1);
     if (yyV1 > 2)
        error_protocol ("global get: rank must be <= 2");

     GlobalTestConform (yyV2, yyV3);

     if (yyV5 != NoTree)
        GlobalTestMask (yyV2, yyV5, TreeType(yyV5));

  }
   return;
 }

;
}

void CheckGlobalSendParams
# if defined __STDC__ | defined __cplusplus
(register tTree parameter_list)
# else
(parameter_list)
 register tTree parameter_list;
# endif
{
  if (parameter_list == NoTree) return;
# line 498 "Globals.puma"
  {
# line 499 "Globals.puma"
   if (! ((TreeListLength (parameter_list) < 3))) goto yyL1;
  {
# line 500 "Globals.puma"
   error_protocol ("global send requires at least 3 parameters (B,P,A,..)");
  }
  }
   return;
yyL1:;

# line 503 "Globals.puma"
  {
# line 504 "Globals.puma"
   if (! ((FullParameters (parameter_list) == false))) goto yyL2;
  {
# line 506 "Globals.puma"
   GlobalTestFullParams (parameter_list);
  }
  }
   return;
yyL2:;

# line 509 "Globals.puma"
 {
  int yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 510 "Globals.puma"
   SplitSend (parameter_list, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5, & yyV6);
# line 512 "Globals.puma"
 if (yyV2 != NoTree)
        {


          GlobalTestIndexes (yyV2, yyV4, yyV1);


          GlobalTestConform (yyV2, yyV3);

        }

     if (yyV1 > 2)
        error_protocol ("global send: rank must be <= 2");


     if (yyV5 != NoTree)
        GlobalTestMask (yyV2, yyV5, TreeType(yyV5));

  }
   return;
 }

;
}

tTree GenGlobalGet
# if defined __STDC__ | defined __cplusplus
(register tTree parameter_list)
# else
(parameter_list)
 register tTree parameter_list;
# endif
{
# line 549 "Globals.puma"
 {
  tTree params;
  tTree call;
  int yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
# line 551 "Globals.puma"

# line 552 "Globals.puma"

# line 554 "Globals.puma"
   SplitGet (parameter_list, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
# line 558 "Globals.puma"
 params = yyV4;

     params = DalibFormalSize (yyV3, params);
     params = mBTP_LIST (mVAR_PARAM (yyV3), params);
     params = DalibLocalSize (yyV2, params);
     params = DalibTreeSizeParam (yyV2, params);
     params = mBTP_LIST (mVAR_PARAM (yyV2), params);

     if (TreeDistribution (yyV3) == 1)
      { if (yyV5 == NoTree)
           call = mPROC_OBJ (MakeDalibId1 ("global_get", yyV1));
          else
           call = mPROC_OBJ (MakeDalibId1 ("global_getm", yyV1));
      }
      else
      { if (yyV5 == NoTree)
           call = mPROC_OBJ (MakeDalibId1 ("local_get", yyV1));
          else
           call = mPROC_OBJ (MakeDalibId1 ("local_getm", yyV1));
      }
     call = mACF_BASIC (mCALL_STMT (call, params));

  }
  {
   return call;
  }
 }

}

tTree GenGlobalSend
# if defined __STDC__ | defined __cplusplus
(register tTree parameter_list)
# else
(parameter_list)
 register tTree parameter_list;
# endif
{
# line 596 "Globals.puma"

tTree params, call, last_one;
int nop;

# line 601 "Globals.puma"
 {
  int yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 603 "Globals.puma"
   SplitSend (parameter_list, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5, & yyV6);
# line 607 "Globals.puma"
 if (yyV6 != NoTree)
         nop = GenGlobalSendOp (TreeType (yyV3), FuncName (yyV6));
       else
         nop = 0;

     params = mBTP_EMPTY();



     GetTheIndexes (yyV4, yyV1, &last_one);

     if (yyV5 != NoTree)
        params = mBTP_LIST (mVAR_PARAM (yyV5), params);
       else
        params = mBTP_LIST (last_one, params);

     params = DalibLocalSize (yyV2, params);
     params = DalibTreeSizeParam (yyV2, params);
     params = mBTP_LIST (mVAR_PARAM (yyV2), params);

     ConcatParams (yyV4, params);
     params = yyV4;

     params = DalibFormalSize (yyV3, params);
     params = mBTP_LIST (mVAR_PARAM (yyV3), params);

     params = mBTP_LIST (ExpToVarParam (MakeConstant (nop)), params);

     if (TreeDistribution(yyV3) == 1)
        call = mPROC_OBJ (MakeDalibId1 ("global_setm", yyV1));
      else
        call = mPROC_OBJ (MakeDalibId1 ("local_setm", yyV1));
     call = mACF_BASIC (mCALL_STMT (call, params));

  }
  {
   return call;
  }
 }

}

static void GetTheIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int rank, register tTree * last)
# else
(indexes, rank, last)
 register tTree indexes;
 register int rank;
 register tTree * last;
# endif
{
  if (indexes == NoTree) return;
  if (indexes->Kind == kBTP_LIST) {
  if (equalint (rank, 1)) {
# line 652 "Globals.puma"
  {
# line 653 "Globals.puma"
 indexes->BTP_LIST.Next = NoTree;
  }
   * last = indexes->BTP_LIST.Elem;
   return;

  }
# line 656 "Globals.puma"
 {
  tTree yyV1;
  {
# line 658 "Globals.puma"
   GetTheIndexes (indexes->BTP_LIST.Next, rank - 1, & yyV1);
  }
   * last = yyV1;
   return;
 }

  }
;
}

static void ConcatParams
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register tTree params)
# else
(indexes, params)
 register tTree indexes;
 register tTree params;
# endif
{
  if (indexes == NoTree) return;
  if (params == NoTree) return;
  if (indexes->Kind == kBTP_LIST) {
# line 663 "Globals.puma"
  {
# line 664 "Globals.puma"
   if (! ((indexes->BTP_LIST.Next == NoTree))) goto yyL1;
  {
# line 665 "Globals.puma"
 indexes->BTP_LIST.Next = params;
  }
  }
   return;
yyL1:;

# line 668 "Globals.puma"
  {
# line 669 "Globals.puma"
   ConcatParams (indexes->BTP_LIST.Next, params);
  }
   return;

  }
;
}

static int GenGlobalSendOp
# if defined __STDC__ | defined __cplusplus
(register tTree type, register tIdent redfunc)
# else
(type, redfunc)
 register tTree type;
 register tIdent redfunc;
# endif
{
  if (type->Kind == kBOOLEAN_TYPE) {
  if (equalint (type->BOOLEAN_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("ANY", 3))) {
# line 680 "Globals.puma"
   return 17;

  }
  }
  if (equalint (type->BOOLEAN_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("ALL", 3))) {
# line 682 "Globals.puma"
   return 16;

  }
  }
  if (equalint (type->BOOLEAN_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("PARITY", 6))) {
# line 684 "Globals.puma"
   return 18;

  }
  }
  }
  if (type->Kind == kINTEGER_TYPE) {
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("SUM", 3))) {
# line 686 "Globals.puma"
   return 7;

  }
  }
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("PRODUCT", 7))) {
# line 688 "Globals.puma"
   return 10;

  }
  }
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("MINVAL", 6))) {
# line 690 "Globals.puma"
   return 1;

  }
  }
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("MAXVAL", 6))) {
# line 692 "Globals.puma"
   return 4;

  }
  }
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("IALL", 4))) {
# line 694 "Globals.puma"
   return 13;

  }
  }
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("IANY", 4))) {
# line 696 "Globals.puma"
   return 14;

  }
  }
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("IPARITY", 7))) {
# line 698 "Globals.puma"
   return 15;

  }
  }
  }
  if (type->Kind == kREAL_TYPE) {
  if (equalint (type->REAL_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("SUM", 3))) {
# line 702 "Globals.puma"
   return 8;

  }
  }
  if (equalint (type->REAL_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("PRODUCT", 7))) {
# line 704 "Globals.puma"
   return 11;

  }
  }
  if (equalint (type->REAL_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("MINVAL", 6))) {
# line 706 "Globals.puma"
   return 2;

  }
  }
  if (equalint (type->REAL_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("MAXVAL", 6))) {
# line 708 "Globals.puma"
   return 5;

  }
  }
  if (equalint (type->REAL_TYPE.size, 8)) {
  if (equaltIdent (redfunc, MakeIdent ("SUM", 3))) {
# line 710 "Globals.puma"
   return 9;

  }
  }
  if (equalint (type->REAL_TYPE.size, 8)) {
  if (equaltIdent (redfunc, MakeIdent ("PRODUCT", 7))) {
# line 712 "Globals.puma"
   return 12;

  }
  }
  if (equalint (type->REAL_TYPE.size, 8)) {
  if (equaltIdent (redfunc, MakeIdent ("MINVAL", 6))) {
# line 714 "Globals.puma"
   return 3;

  }
  }
  if (equalint (type->REAL_TYPE.size, 8)) {
  if (equaltIdent (redfunc, MakeIdent ("MAXVAL", 6))) {
# line 716 "Globals.puma"
   return 6;

  }
  }
  }
# line 718 "Globals.puma"
  {
# line 719 "Globals.puma"
   error_protocol ("This reduction is not handled for global set");
# line 720 "Globals.puma"
   tree_protocol ("type is ", type);
  }
   return - 1;

}

static tIdent FuncName
# if defined __STDC__ | defined __cplusplus
(register tTree f)
# else
(f)
 register tTree f;
# endif
{
  if (f->Kind == kFUNC_PARAM) {
# line 726 "Globals.puma"
   return f->FUNC_PARAM.F->PROC_OBJ.Ident;

  }
 yyAbort ("FuncName");
}

void BeginGlobals ()
{
}

void CloseGlobals ()
{
}
