# include "NormalAr.h"
# include "yyNArray.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 29 "NormalArrays.puma"


# include "Idents.h"
# include "StringMe.h"

# include "protocol.h"

# include "Expressi.h"   /* AddConstant     */
# include "Shapes.h"        /* GetCurrentShape */

# include "Globals.h"       /* SplitSet, SplitGet */

bool has_changed;           /* required to protocol only changes */



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module NormalArrays, routine %s failed\n", yyFunction);
 exit (1);
}

void NormalArrays ARGS((tTree t));
static void NormalDeclArrays ARGS((tTree decls));
static void NormalizeDimensions ARGS((tTree indextypes));
static void NormalACFArrays ARGS((tTree t));
static void NormalStmtArrays ARGS((tTree t));
static void NormalParamArrays ARGS((tTree t));
static void NormalExpArrays ARGS((tTree t));
static void NormalAllocArrays ARGS((tTree t));
static void NormalizeAllocDimensions ARGS((tTree indextypes));
static void NormalArrayIndexes ARGS((tTree indexes, shape s, int n));
static tTree NormalizeDimExp ARGS((tTree exp, tTree lb));
static void NormalIntrSubroutine ARGS((tIdent name, tTree params));
static bool IsNormal ARGS((tTree lb));

void NormalArrays
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBODY_NODE) {
  if (t->BODY_NODE.INTERNALS->Kind == kDECL_EMPTY) {
# line 56 "NormalArrays.puma"
  {
# line 57 "NormalArrays.puma"
   NormalACFArrays (t->BODY_NODE.STATS);
# line 58 "NormalArrays.puma"
   NormalDeclArrays (t->BODY_NODE.DECLS);
# line 59 "NormalArrays.puma"
   NormalAllocArrays (t->BODY_NODE.STATS);
  }
   return;

  }
  }
;
}

static void NormalDeclArrays
# if defined __STDC__ | defined __cplusplus
(register tTree decls)
# else
(decls)
 register tTree decls;
# endif
{
  if (decls == NoTree) return;
  if (decls->Kind == kDECL_EMPTY) {
# line 70 "NormalArrays.puma"
   return;

  }
  if (decls->Kind == kDECL_LIST) {
# line 73 "NormalArrays.puma"
  {
# line 74 "NormalArrays.puma"
   NormalDeclArrays (decls->DECL_LIST.Elem);
# line 75 "NormalArrays.puma"
   NormalDeclArrays (decls->DECL_LIST.Next);
  }
   return;

  }
  if (decls->Kind == kVAR_DECL) {
  if (decls->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 78 "NormalArrays.puma"
  {
# line 80 "NormalArrays.puma"
 has_changed = false;
      NormalizeDimensions (decls->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
      if (has_changed)
         tree_protocol ("new array declaration : \n", decls);

  }
   return;

  }
  }
;
}

static void NormalizeDimensions
# if defined __STDC__ | defined __cplusplus
(register tTree indextypes)
# else
(indextypes)
 register tTree indextypes;
# endif
{
  if (indextypes == NoTree) return;
  if (indextypes->Kind == kTYPE_LIST) {
# line 95 "NormalArrays.puma"
  {
# line 96 "NormalArrays.puma"
   NormalizeDimensions (indextypes->TYPE_LIST.Elem);
# line 97 "NormalArrays.puma"
   NormalizeDimensions (indextypes->TYPE_LIST.Next);
  }
   return;

  }
  if (indextypes->Kind == kTYPE_EMPTY) {
# line 100 "NormalArrays.puma"
   return;

  }
  if (indextypes->Kind == kINDEX_TYPE) {
# line 105 "NormalArrays.puma"
 {
  bool found;
  int val;
  {
# line 107 "NormalArrays.puma"

# line 108 "NormalArrays.puma"

# line 110 "NormalArrays.puma"
 GetIntConstValue (indextypes->INDEX_TYPE.LOWER, &found, &val);
# line 112 "NormalArrays.puma"
   if (! ((found == true))) goto yyL3;
  {
# line 113 "NormalArrays.puma"
   if (! ((val == 1))) goto yyL3;
  }
  }
   return;
 }
yyL3:;

# line 117 "NormalArrays.puma"
  {
# line 118 "NormalArrays.puma"
 indextypes->INDEX_TYPE.UPPER = NormalizeDimExp (indextypes->INDEX_TYPE.UPPER, indextypes->INDEX_TYPE.LOWER);
      indextypes->INDEX_TYPE.LOWER = mCONST_EXP(mINT_CONSTANT (1));
      has_changed = true;

  }
   return;

  }
  if (indextypes->Kind == kDYNAMIC) {
# line 126 "NormalArrays.puma"
  {
# line 127 "NormalArrays.puma"
   if (! ((indextypes->DYNAMIC.Shape == NoTree))) goto yyL5;
  }
   return;
yyL5:;

# line 130 "NormalArrays.puma"
  {
# line 131 "NormalArrays.puma"
   printf ("NormalizeDimensions: expression (!= NoTree) in DYNAMIC\n");
# line 132 "NormalArrays.puma"
   kill_in_protocol ();
  }
   return;

  }
;
}

static void NormalACFArrays
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;

  switch (t->Kind) {
  case kACF_LIST:
# line 143 "NormalArrays.puma"
  {
# line 144 "NormalArrays.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 145 "NormalArrays.puma"
   NormalACFArrays (t->ACF_LIST.Elem);
# line 146 "NormalArrays.puma"
   NormalACFArrays (t->ACF_LIST.Next);
  }
   return;

  case kACF_EMPTY:
# line 149 "NormalArrays.puma"
   return;

  case kACF_DUMMY:
# line 152 "NormalArrays.puma"
   return;

  case kACF_BASIC:
# line 155 "NormalArrays.puma"
  {
# line 156 "NormalArrays.puma"
   NormalStmtArrays (t->ACF_BASIC.BASIC_STMT);
  }
   return;

  case kACF_IF:
# line 159 "NormalArrays.puma"
  {
# line 160 "NormalArrays.puma"
   NormalExpArrays (t->ACF_IF.IF_EXP);
# line 161 "NormalArrays.puma"
   NormalACFArrays (t->ACF_IF.THEN_PART);
# line 162 "NormalArrays.puma"
   NormalACFArrays (t->ACF_IF.ELSE_PART);
  }
   return;

  case kACF_WHERE:
# line 165 "NormalArrays.puma"
  {
# line 167 "NormalArrays.puma"
   NormalExpArrays (t->ACF_WHERE.WHERE_EXP);
# line 168 "NormalArrays.puma"
   NormalACFArrays (t->ACF_WHERE.TRUE_PART);
# line 169 "NormalArrays.puma"
   NormalACFArrays (t->ACF_WHERE.FALSE_PART);
  }
   return;

  case kACF_CASE:
# line 172 "NormalArrays.puma"
  {
# line 173 "NormalArrays.puma"
   NormalExpArrays (t->ACF_CASE.CASE_EXP);
# line 174 "NormalArrays.puma"
   NormalACFArrays (t->ACF_CASE.CASE_ALTS);
# line 175 "NormalArrays.puma"
   NormalACFArrays (t->ACF_CASE.CASE_OTHERWISE);
  }
   return;

  case kSELECTED_ACF_LIST:
# line 178 "NormalArrays.puma"
  {
# line 179 "NormalArrays.puma"
   NormalACFArrays (t->SELECTED_ACF_LIST.Elem);
# line 180 "NormalArrays.puma"
   NormalACFArrays (t->SELECTED_ACF_LIST.Next);
  }
   return;

  case kSELECTED_ACF_EMPTY:
# line 183 "NormalArrays.puma"
   return;

  case kSELECTED_ACF_NODE:
# line 186 "NormalArrays.puma"
  {
# line 187 "NormalArrays.puma"
   NormalExpArrays (t->SELECTED_ACF_NODE.SELECT_LIST);
# line 188 "NormalArrays.puma"
   NormalACFArrays (t->SELECTED_ACF_NODE.SELECT_ACFS);
  }
   return;

  case kACF_WHILE:
# line 191 "NormalArrays.puma"
  {
# line 192 "NormalArrays.puma"
   NormalExpArrays (t->ACF_WHILE.WHILE_EXP);
# line 193 "NormalArrays.puma"
   NormalACFArrays (t->ACF_WHILE.WHILE_BODY);
  }
   return;

  case kACF_FORALL:
# line 196 "NormalArrays.puma"
  {
# line 197 "NormalArrays.puma"
   NormalExpArrays (t->ACF_FORALL.FORALL_RANGE);
# line 198 "NormalArrays.puma"
   NormalACFArrays (t->ACF_FORALL.FORALL_BODY);
  }
   return;

  case kACF_DOLOCAL:
# line 201 "NormalArrays.puma"
  {
# line 202 "NormalArrays.puma"
   NormalExpArrays (t->ACF_DOLOCAL.DOLOCAL_RANGE);
# line 203 "NormalArrays.puma"
   NormalACFArrays (t->ACF_DOLOCAL.DOLOCAL_BODY);
  }
   return;

  case kACF_DO:
# line 206 "NormalArrays.puma"
  {
# line 207 "NormalArrays.puma"
   NormalExpArrays (t->ACF_DO.DO_RANGE);
# line 208 "NormalArrays.puma"
   NormalACFArrays (t->ACF_DO.DO_BODY);
  }
   return;

  }

# line 211 "NormalArrays.puma"
  {
# line 212 "NormalArrays.puma"
   failure_protocol ("NormalArrays", "NormalACFArrays", t);
  }
   return;

;
}

static void NormalStmtArrays
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;

  switch (t->Kind) {
  case kASSIGN_STMT:
# line 223 "NormalArrays.puma"
  {
# line 224 "NormalArrays.puma"
   NormalExpArrays (t->ASSIGN_STMT.ASSIGN_VAR);
# line 225 "NormalArrays.puma"
   NormalExpArrays (t->ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  case kFORMAT_STMT:
# line 228 "NormalArrays.puma"
   return;

  case kIO_STMT:
# line 232 "NormalArrays.puma"
  {
# line 233 "NormalArrays.puma"
   NormalParamArrays (t->IO_STMT.IO_ITEMS);
  }
   return;

  case kCALL_STMT:
# line 236 "NormalArrays.puma"
  {
# line 238 "NormalArrays.puma"
   if (! (t->CALL_STMT.CALL_ID->PROC_OBJ.Object == GetDeclEntry (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, GetIntrinsicEntries ()))) goto yyL4;
  {
# line 239 "NormalArrays.puma"
   NormalIntrSubroutine (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, t->CALL_STMT.CALL_PARAMS);
  }
  }
   return;
yyL4:;

# line 242 "NormalArrays.puma"
  {
# line 243 "NormalArrays.puma"
   NormalParamArrays (t->CALL_STMT.CALL_PARAMS);
  }
   return;

  case kREDUCE_STMT:
# line 246 "NormalArrays.puma"
  {
# line 247 "NormalArrays.puma"
   NormalParamArrays (t->REDUCE_STMT.RED_PARAMS);
  }
   return;

  case kALLOCATE_STMT:
# line 250 "NormalArrays.puma"
  {
# line 251 "NormalArrays.puma"
   NormalExpArrays (t->ALLOCATE_STMT.STAT);
# line 252 "NormalArrays.puma"
   SetAllocateShapes (t->ALLOCATE_STMT.PARAMS);
  }
   return;

  case kDEALLOCATE_STMT:
# line 255 "NormalArrays.puma"
  {
# line 256 "NormalArrays.puma"
   NormalExpArrays (t->DEALLOCATE_STMT.STAT);
# line 258 "NormalArrays.puma"
   ResetDeallocateShapes (t->DEALLOCATE_STMT.PARAMS);
  }
   return;

  case kGOTO_STMT:
# line 261 "NormalArrays.puma"
   return;

  case kCOMP_GOTO_STMT:
# line 264 "NormalArrays.puma"
  {
# line 265 "NormalArrays.puma"
   NormalExpArrays (t->COMP_GOTO_STMT.GOTO_EXP);
  }
   return;

  case kCOMP_IF_STMT:
# line 268 "NormalArrays.puma"
  {
# line 269 "NormalArrays.puma"
   NormalExpArrays (t->COMP_IF_STMT.IF_EXP);
  }
   return;

  case kSTOP_STMT:
# line 272 "NormalArrays.puma"
  {
# line 273 "NormalArrays.puma"
   NormalExpArrays (t->STOP_STMT.STOP_CONST);
  }
   return;

  case kRETURN_STMT:
# line 276 "NormalArrays.puma"
  {
# line 277 "NormalArrays.puma"
   NormalExpArrays (t->RETURN_STMT.RETURN_EXP);
  }
   return;

  }

# line 280 "NormalArrays.puma"
  {
# line 281 "NormalArrays.puma"
   failure_protocol ("NormalArrays", "NormalStmtArrays", t);
  }
   return;

;
}

static void NormalParamArrays
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBTP_LIST) {
# line 286 "NormalArrays.puma"
  {
# line 287 "NormalArrays.puma"
   NormalParamArrays (t->BTP_LIST.Elem);
# line 288 "NormalArrays.puma"
   NormalParamArrays (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->Kind == kBTP_EMPTY) {
# line 291 "NormalArrays.puma"
   return;

  }
  if (t->Kind == kVAR_PARAM) {
# line 294 "NormalArrays.puma"
  {
# line 295 "NormalArrays.puma"
   NormalExpArrays (t->VAR_PARAM.V);
  }
   return;

  }
  if (t->Kind == kFUNC_PARAM) {
# line 298 "NormalArrays.puma"
   return;

  }
  if (t->Kind == kPROC_PARAM) {
# line 301 "NormalArrays.puma"
   return;

  }
# line 304 "NormalArrays.puma"
  {
# line 305 "NormalArrays.puma"
   failure_protocol ("NormalArrays", "NormalParamArrays", t);
  }
   return;

;
}

static void NormalExpArrays
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;

  switch (t->Kind) {
  case kBTE_LIST:
# line 319 "NormalArrays.puma"
  {
# line 320 "NormalArrays.puma"
   NormalExpArrays (t->BTE_LIST.Elem);
# line 321 "NormalArrays.puma"
   NormalExpArrays (t->BTE_LIST.Next);
  }
   return;

  case kBTE_EMPTY:
# line 324 "NormalArrays.puma"
   return;

  case kDUMMY_VAR:
# line 327 "NormalArrays.puma"
   return;

  case kUSED_VAR:
# line 330 "NormalArrays.puma"
   return;

  case kLOOP_VAR:
# line 333 "NormalArrays.puma"
   return;

  case kSUBSTRING_VAR:
# line 336 "NormalArrays.puma"
  {
# line 337 "NormalArrays.puma"
   NormalExpArrays (t->SUBSTRING_VAR.IND_VAR);
# line 338 "NormalArrays.puma"
   NormalExpArrays (t->SUBSTRING_VAR.IND_EXP);
  }
   return;

  case kINDEXED_VAR:
# line 344 "NormalArrays.puma"
 {
  struct_shape s;
  {
# line 346 "NormalArrays.puma"
   NormalExpArrays (t->INDEXED_VAR.IND_EXPS);
# line 348 "NormalArrays.puma"

# line 350 "NormalArrays.puma"
 GetCurrentShape (t->INDEXED_VAR.IND_VAR, &s);
      NormalArrayIndexes (t->INDEXED_VAR.IND_EXPS, &s, 0);

  }
   return;
 }

  case kDO_VAR:
# line 355 "NormalArrays.puma"
  {
# line 356 "NormalArrays.puma"
   NormalExpArrays (t->DO_VAR.RANGE);
# line 357 "NormalArrays.puma"
   NormalExpArrays (t->DO_VAR.BODY);
  }
   return;

  case kBTV_LIST:
# line 360 "NormalArrays.puma"
  {
# line 361 "NormalArrays.puma"
   NormalExpArrays (t->BTV_LIST.Elem);
# line 362 "NormalArrays.puma"
   NormalExpArrays (t->BTV_LIST.Next);
  }
   return;

  case kBTV_EMPTY:
# line 365 "NormalArrays.puma"
   return;

  case kADDR:
# line 368 "NormalArrays.puma"
  {
# line 369 "NormalArrays.puma"
   NormalExpArrays (t->ADDR.E);
  }
   return;

  case kDUMMY_EXP:
# line 372 "NormalArrays.puma"
   return;

  case kCONST_EXP:
# line 375 "NormalArrays.puma"
   return;

  case kARRAY_EXP:
# line 378 "NormalArrays.puma"
  {
# line 379 "NormalArrays.puma"
   NormalExpArrays (t->ARRAY_EXP.ELEMENTS);
  }
   return;

  case kSLICE_EXP:
# line 382 "NormalArrays.puma"
  {
# line 383 "NormalArrays.puma"
   NormalExpArrays (t->SLICE_EXP.START);
# line 384 "NormalArrays.puma"
   NormalExpArrays (t->SLICE_EXP.STOP);
# line 385 "NormalArrays.puma"
   NormalExpArrays (t->SLICE_EXP.INC);
  }
   return;

  case kOP_EXP:
# line 388 "NormalArrays.puma"
  {
# line 390 "NormalArrays.puma"
   NormalExpArrays (t->OP_EXP.OPND1);
# line 391 "NormalArrays.puma"
   NormalExpArrays (t->OP_EXP.OPND2);
  }
   return;

  case kOP1_EXP:
# line 394 "NormalArrays.puma"
  {
# line 395 "NormalArrays.puma"
   NormalExpArrays (t->OP1_EXP.OPND);
  }
   return;

  case kVAR_EXP:
# line 398 "NormalArrays.puma"
  {
# line 399 "NormalArrays.puma"
   NormalExpArrays (t->VAR_EXP.V);
  }
   return;

  case kFUNC_CALL_EXP:
# line 402 "NormalArrays.puma"
  {
# line 404 "NormalArrays.puma"
   NormalParamArrays (t->FUNC_CALL_EXP.FUNC_PARAMS);
  }
   return;

  case kDO_EXP:
# line 407 "NormalArrays.puma"
  {
# line 408 "NormalArrays.puma"
   NormalExpArrays (t->DO_EXP.RANGE);
# line 409 "NormalArrays.puma"
   NormalExpArrays (t->DO_EXP.BODY);
  }
   return;

  case kVAR_PARAM:
# line 412 "NormalArrays.puma"
  {
# line 413 "NormalArrays.puma"
   NormalExpArrays (t->VAR_PARAM.V);
  }
   return;

  }

# line 416 "NormalArrays.puma"
  {
# line 417 "NormalArrays.puma"
   failure_protocol ("NormalArrays", "NormalExpArrays", t);
  }
   return;

;
}

static void NormalAllocArrays
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;

  switch (t->Kind) {
  case kACF_LIST:
# line 428 "NormalArrays.puma"
  {
# line 429 "NormalArrays.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 430 "NormalArrays.puma"
   NormalAllocArrays (t->ACF_LIST.Elem);
# line 431 "NormalArrays.puma"
   NormalAllocArrays (t->ACF_LIST.Next);
  }
   return;

  case kACF_EMPTY:
# line 434 "NormalArrays.puma"
   return;

  case kACF_DUMMY:
# line 437 "NormalArrays.puma"
   return;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
# line 440 "NormalArrays.puma"
  {
# line 441 "NormalArrays.puma"
 has_changed = false;
     NormalAllocArrays (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS);
     if (has_changed)
       stmt_protocol ("this is the new allocate statementn");

  }
   return;

  }
# line 448 "NormalArrays.puma"
   return;

  case kACF_IF:
# line 451 "NormalArrays.puma"
  {
# line 452 "NormalArrays.puma"
   NormalAllocArrays (t->ACF_IF.THEN_PART);
# line 453 "NormalArrays.puma"
   NormalAllocArrays (t->ACF_IF.ELSE_PART);
  }
   return;

  case kACF_WHERE:
# line 456 "NormalArrays.puma"
  {
# line 457 "NormalArrays.puma"
   NormalAllocArrays (t->ACF_WHERE.TRUE_PART);
# line 458 "NormalArrays.puma"
   NormalAllocArrays (t->ACF_WHERE.FALSE_PART);
  }
   return;

  case kACF_CASE:
# line 461 "NormalArrays.puma"
  {
# line 462 "NormalArrays.puma"
   NormalAllocArrays (t->ACF_CASE.CASE_ALTS);
# line 463 "NormalArrays.puma"
   NormalAllocArrays (t->ACF_CASE.CASE_OTHERWISE);
  }
   return;

  case kSELECTED_ACF_LIST:
# line 466 "NormalArrays.puma"
  {
# line 467 "NormalArrays.puma"
   NormalAllocArrays (t->SELECTED_ACF_LIST.Elem);
# line 468 "NormalArrays.puma"
   NormalAllocArrays (t->SELECTED_ACF_LIST.Next);
  }
   return;

  case kSELECTED_ACF_EMPTY:
# line 471 "NormalArrays.puma"
   return;

  case kSELECTED_ACF_NODE:
# line 474 "NormalArrays.puma"
  {
# line 475 "NormalArrays.puma"
   NormalAllocArrays (t->SELECTED_ACF_NODE.SELECT_ACFS);
  }
   return;

  case kACF_WHILE:
# line 478 "NormalArrays.puma"
  {
# line 479 "NormalArrays.puma"
   NormalAllocArrays (t->ACF_WHILE.WHILE_BODY);
  }
   return;

  case kACF_FORALL:
# line 482 "NormalArrays.puma"
  {
# line 483 "NormalArrays.puma"
   NormalAllocArrays (t->ACF_FORALL.FORALL_BODY);
  }
   return;

  case kACF_DOLOCAL:
# line 486 "NormalArrays.puma"
  {
# line 487 "NormalArrays.puma"
   NormalAllocArrays (t->ACF_DOLOCAL.DOLOCAL_BODY);
  }
   return;

  case kACF_DO:
# line 490 "NormalArrays.puma"
  {
# line 491 "NormalArrays.puma"
   NormalAllocArrays (t->ACF_DO.DO_BODY);
  }
   return;

  case kBTP_LIST:
# line 494 "NormalArrays.puma"
  {
# line 495 "NormalArrays.puma"
   NormalAllocArrays (t->BTP_LIST.Elem);
# line 496 "NormalArrays.puma"
   NormalAllocArrays (t->BTP_LIST.Next);
  }
   return;

  case kBTP_EMPTY:
# line 499 "NormalArrays.puma"
   return;

  case kVAR_PARAM:
  if (t->VAR_PARAM.V->Kind == kINDEXED_VAR) {
# line 502 "NormalArrays.puma"
  {
# line 503 "NormalArrays.puma"
   NormalizeAllocDimensions (t->VAR_PARAM.V->INDEXED_VAR.IND_EXPS);
  }
   return;

  }
  break;
  }

# line 506 "NormalArrays.puma"
  {
# line 507 "NormalArrays.puma"
   failure_protocol ("NormalArrays", "NormalAllocArrays", t);
  }
   return;

;
}

static void NormalizeAllocDimensions
# if defined __STDC__ | defined __cplusplus
(register tTree indextypes)
# else
(indextypes)
 register tTree indextypes;
# endif
{
  if (indextypes == NoTree) return;
  if (indextypes->Kind == kBTE_LIST) {
# line 512 "NormalArrays.puma"
  {
# line 513 "NormalArrays.puma"
   NormalizeAllocDimensions (indextypes->BTE_LIST.Elem);
# line 514 "NormalArrays.puma"
   NormalizeAllocDimensions (indextypes->BTE_LIST.Next);
  }
   return;

  }
  if (indextypes->Kind == kBTE_EMPTY) {
# line 517 "NormalArrays.puma"
   return;

  }
  if (indextypes->Kind == kSLICE_EXP) {
  if (indextypes->SLICE_EXP.START->Kind == kCONST_EXP) {
  if (indextypes->SLICE_EXP.START->CONST_EXP.C->Kind == kINT_CONSTANT) {
  if (equalint (indextypes->SLICE_EXP.START->CONST_EXP.C->INT_CONSTANT.value, 1)) {
# line 521 "NormalArrays.puma"
   return;

  }
  }
  }
# line 525 "NormalArrays.puma"
  {
# line 526 "NormalArrays.puma"
 indextypes->SLICE_EXP.STOP = NormalizeDimExp (indextypes->SLICE_EXP.STOP, indextypes->SLICE_EXP.START);
      indextypes->SLICE_EXP.START = mCONST_EXP(mINT_CONSTANT (1));
      has_changed = true;

  }
   return;

  }
;
}

static void NormalArrayIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, shape s, register int n)
# else
(indexes, s, n)
 register tTree indexes;
 shape s;
 register int n;
# endif
{
  if (indexes == NoTree) return;
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 542 "NormalArrays.puma"
  {
# line 543 "NormalArrays.puma"
 indexes->BTE_LIST.Elem->SLICE_EXP.START = NormalizeDimExp (indexes->BTE_LIST.Elem->SLICE_EXP.START, s->bounds[n][0]);
     indexes->BTE_LIST.Elem->SLICE_EXP.STOP  = NormalizeDimExp (indexes->BTE_LIST.Elem->SLICE_EXP.STOP,  s->bounds[n][0]);

# line 546 "NormalArrays.puma"
   NormalArrayIndexes (indexes->BTE_LIST.Next, s, n + 1);
  }
   return;

  }
# line 549 "NormalArrays.puma"
  {
# line 550 "NormalArrays.puma"
 indexes->BTE_LIST.Elem = NormalizeDimExp (indexes->BTE_LIST.Elem, s->bounds[n][0]);
# line 551 "NormalArrays.puma"
   NormalArrayIndexes (indexes->BTE_LIST.Next, s, n + 1);
  }
   return;

  }
  if (indexes->Kind == kBTE_EMPTY) {
# line 554 "NormalArrays.puma"
   return;

  }
# line 557 "NormalArrays.puma"
  {
# line 558 "NormalArrays.puma"
   failure_protocol ("NormalArrays", "NormalArrayIndexes", indexes);
  }
   return;

;
}

static tTree NormalizeDimExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree lb)
# else
(exp, lb)
 register tTree exp;
 register tTree lb;
# endif
{
  if (exp->Kind == kDUMMY_EXP) {
# line 569 "NormalArrays.puma"
   return exp;

  }
  if (lb->Kind == kDUMMY_EXP) {
# line 573 "NormalArrays.puma"
   return exp;

  }
# line 577 "NormalArrays.puma"
 {
  bool found;
  int val;
  {
# line 579 "NormalArrays.puma"

# line 580 "NormalArrays.puma"

# line 582 "NormalArrays.puma"
 GetIntConstValue (lb, &found, &val);
# line 583 "NormalArrays.puma"
   if (! (found == true)) goto yyL3;
  }
  {
   return AddConstant (exp, - val + 1);
  }
 }
yyL3:;

# line 587 "NormalArrays.puma"
   return AddConstant (mOP_EXP (mOP_MINUS (), exp, lb), 1);

}

static void NormalIntrSubroutine
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
# line 604 "NormalArrays.puma"

int rank;
tTree A, B, M, indexes, op;
struct_shape s;
int i;
bool ok;

  if (params == NoTree) return;
  if (equaltIdent (name, MakeIdent ("GLOBAL_GET", 10))) {
# line 612 "NormalArrays.puma"
  {
# line 614 "NormalArrays.puma"
 SplitGet (params, &rank, &A, &B, &indexes, &M);



      GetCurrentShape (B, &s);

      ok = true;
      for (i=0; i<rank; i++)
        ok = ok && IsNormal (s.bounds[i][0]);

      if (!ok)
         error_protocol ("Indirect accessed array must be normal before");

  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("GLOBAL_SEND", 11))) {
# line 629 "NormalArrays.puma"
  {
# line 631 "NormalArrays.puma"
 SplitSend (params, &rank, &A, &B, &indexes, &M, &op);



      GetCurrentShape (B, &s);

      ok = true;
      for (i=0; i<rank; i++)
        ok = ok && IsNormal (s.bounds[i][0]);

      if (!ok)
         error_protocol ("Indirect accessed array must be normal before");

  }
   return;

  }
# line 646 "NormalArrays.puma"
  {
# line 647 "NormalArrays.puma"
   NormalParamArrays (params);
  }
   return;

;
}

static bool IsNormal
# if defined __STDC__ | defined __cplusplus
(register tTree lb)
# else
(lb)
 register tTree lb;
# endif
{
  if (lb == NoTree) return false;
# line 652 "NormalArrays.puma"
 {
  int val;
  bool found;
  {
# line 654 "NormalArrays.puma"

# line 655 "NormalArrays.puma"

# line 657 "NormalArrays.puma"
   GetIntConstValue (lb, & found, & val);
# line 658 "NormalArrays.puma"
   if (! ((found == true))) goto yyL1;
  {
# line 659 "NormalArrays.puma"
   if (! ((val == 1))) goto yyL1;
  }
  }
   return true;
 }
yyL1:;

  return false;
}

void BeginNormalArrays ()
{
}

void CloseNormalArrays ()
{
}
