/* $Id: Parser.c,v 2.8 1992/07/10 09:53:09 grosch rel $ */

# define bool        char
# define true        1
# define false        0

# include "Parser.h"
# include "Errors.h"

# ifdef __cplusplus
extern "C" {
#    include "Memory.h"
#    include "DynArray.h"
#    include "Sets.h"
#    ifndef BCOPY
#       include <memory.h>
#    endif
}
# else
#    include "Memory.h"
#    include "DynArray.h"
#    include "Sets.h"
#    ifndef BCOPY
#       include <memory.h>
#    endif
# endif

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)    parameters
# else
# define ARGS(parameters)    ()
# endif

# ifdef lex_interface
#    define GetToken    yylex
     extern int yylex ();
#    ifndef AttributeDef
        typedef struct { unsigned short Line, Column; } tPosition;
        typedef struct { tPosition Position; } tScanAttribute;
        static    tScanAttribute    Attribute = {{ 0, 0 }};
#    endif
#    ifndef ErrorAttributeDef
#    define ErrorAttribute(Token, RepairAttribute)
#    endif
#    ifndef yyGetAttribute
#    define yyGetAttribute(yyAttrStackPtr, Attribute) * yyAttrStackPtr = yylval
#    endif
# else
#    include "Scanner.h"
#    ifndef yyGetAttribute
#    define yyGetAttribute(yyAttrStackPtr, Attribute) (yyAttrStackPtr)->Scan = Attribute
#    endif
# endif

# line 147 "fortran.lalr"


#include <stdio.h>
#include "Tree.h"
#include "BuildTre.h"
#include "labels.h"

int ParsePosErrors;

#define NPos(a)  NextPos(a.Scan.Position)

/*******************************************************************
*                                                                  *
*   Positioning:  (Line,Column) -> pos                                *
*                                                                  *
*******************************************************************/

FILE *PosFile;
int PosLastLine, PosLastColumn, PosLastPos;

  /*************************************************
  *  BeginPos: Source File is opened again to find *
  *            position number 1 - maxpos          *
  *************************************************/

void BeginPos (Name)
char *Name;
{ PosFile = fopen (Name,"r");
  PosLastLine = 1;
  PosLastColumn  = 0;
  PosLastPos  = 0;
}

  /**************************************************
  *  NextPos: For a position (line, col) the cor-   *
  *           responding absolut position is sought *
  **************************************************/

int NextPos (pos)
tPosition pos;
{  char c;
   
   if (IsIncluded > 0)  /* No Position for included files */
      return (PosLastPos);

   /* 
   printf ("Call of NextPos : Line = %d, Col = %d\n", pos.Line, pos.Column);
   */

   if (pos.Line < PosLastLine)
     { if (ParsePosErrors == 0)
       { printf ("NextPos : Error --- already in next line \n");
         printf ("LastPos : Line = %d, Col = %d\n", PosLastLine, PosLastColumn);
         printf ("NextPos : Line = %d, Col = %d\n", pos.Line, pos.Column);
       }
       ParsePosErrors += 1;
       return (PosLastPos);
     }

   if ((pos.Line == PosLastLine) && (PosLastColumn > pos.Column))
     { /* reset to the last col */
       return (PosLastPos + pos.Column - PosLastColumn);
     }

   while (    (PosLastLine < pos.Line)
           || ((PosLastLine == pos.Line) && (PosLastColumn < pos.Column))  )
    { c = fgetc(PosFile);
      if (c == -1)   /* eof */
         { PosLastLine = pos.Line;
           PosLastColumn  = pos.Column;
           printf ("Error: NextPos eof reached, Line = %d, Col = %d\n",
                    pos.Line, pos.Column);
         }
      else if (c == 10)
         { PosLastLine += 1;
           PosLastColumn = 0;  }
        else
         PosLastColumn  += 1;
      PosLastPos += 1;
    }
   /* printf ("Result of NextPos : %d\n", PosLastPos); */
   return (PosLastPos); 
}

void ClosePos ()
{ fclose (PosFile);
}

   /********************************************************
    *                                                      *
    *     Special error handling for internal errors       *
    *                                                      *
    ********************************************************/

void parse_error (s)
char s[];
{ printf ("Parser: Internal Error = %s\n", s);
  exit (-1);
}

   /********************************************************
    *                                                      *
    *     Special functions for abstract syntax trees      *
    *                                                      *
    ********************************************************/

typedef struct { tScanAttribute Scan;
                 int Label;
                 int Line;
                 tTree Tree;         } tParsAttribute;

tStringRef MakeIntToReal (n)
int n;

{ char number[15];
  sprintf (number, "%d.", n);
  return (PutString (number, strlen (number)));
}



# if defined lex_interface & ! defined yylvalDef
     tParsAttribute yylval;
# endif

# ifndef yyInitStackSize
#    define yyInitStackSize    100
# endif
# define yyNoState        0

# define yyFirstTerminal    0
# define yyLastTerminal        255
# define yyTableMax        2691
# define yyNTableMax        4898
# define yyFirstReadState    1
# define yyLastReadState    673
# define yyFirstReadTermState    674
# define yyLastReadTermState    845
# define yyLastReadNontermState    1167
# define yyFirstReduceState    1168
# define yyLastReduceState    1830
# define yyStartState        1
# define yyStopState        1168

# define yyFirstFinalState    yyFirstReadTermState

typedef unsigned short    yyStateRange    ;
typedef unsigned short    yySymbolRange    ;
typedef struct    { yyStateRange Check, Next; } yyTCombType ;

short xxMaxToken = yyLastTerminal;

    char *        xxTokenName    [yyLastTerminal + 1] = {
"_EndOfFile",
"Ident",
"IntConst",
"RealConst",
"DRealConst",
"StringConst",
"LABEL",
"UserOp",
0,
0,
"=",
"//",
"=>",
"(",
")",
"+",
"-",
"*",
"/",
"**",
":",
",",
0,
"[",
"]",
0,
0,
"::",
".",
"%",
"<>",
"==",
">",
">=",
"<",
"<=",
"AND",
"OR",
0,
"EQV",
"NEQV",
"TRUE",
"FALSE",
"NOT",
"XOR",
"BLOCKDATA",
"DATA",
0,
"INTRINSIC",
0,
"INTEGER",
"REAL",
"COMPLEX",
"LOGICAL",
"CHARACTER",
"DOUBLE_PRECISION",
"DOUBLE_COMPLEX",
"SAVE",
"IMPLICIT",
"EXTERNAL",
"PARAMETER",
"DIMENSION",
"COMMON",
"EQUIVALENCE",
"PROGRAM",
"RECURSIVE",
"SUBROUTINE",
"FUNCTION",
"END",
"DO",
"WHILE",
"IF",
"THEN",
"ELSE",
"ELSEIF",
"ENDDO",
"ENDIF",
"RESULT",
"ASSIGN",
"TO",
"CALL",
"CONTINUE",
"STOP",
"RETURN",
0,
"FORMAT",
"FORMAT_ARG",
"GOTO",
"ENTRY",
0,
"READ",
"WRITE",
"PRINT",
"OPEN",
"CLOSE",
"INQUIRE",
"BACKSPACE",
"ENDFILE",
"REWIND",
0,
"ALLOCATE",
"DEALLOCATE",
"WHERE",
"ENDWHERE",
"ELSEWHERE",
"SELECT",
"CASE",
"DEFAULT",
0,
"FORALL",
"INTENT",
"IN",
"OUT",
"INOUT",
"ENDFORALL",
"CYCLE",
"EXIT",
0,
0,
0,
0,
"REDUCE",
0,
0,
0,
"PROCEDURE",
"OPERATOR",
"ASSIGNMENT",
0,
0,
"TYPE",
"ENDTYPE",
"INTERFACE",
"ENDINTERFACE",
"MODULE",
0,
"CONTAINS",
"USE",
"ONLY",
0,
"ALLOCATABLE",
"OPTIONAL",
"POINTER",
"TARGET",
"PUBLIC",
"PRIVATE",
"NULLIFY",
"NAMELIST",
0,
0,
"LAYOUT",
"ALIGN",
"WITH",
"SERIAL",
"NEWS",
"SEND",
"REPLICATED",
"HOST",
0,
0,
0,
"REALIGN",
"DISTRIBUTE",
"REDISTRIBUTE",
"PROCESSORS",
"TEMPLATE",
"DYNAMIC",
0,
"ONTO",
"BLOCK",
"CYCLIC",
"NOSEQUENCE",
"SEQUENCE",
"INDEPENDENT",
"LOCAL_ACCESS",
"ON_HOME",
"NEW",
"INHERIT",
0,
0,
"PURE",
"EXTRINSIC_HPF",
"EXTRINSIC_LOCAL",
0,
0,
0,
0,
0,
0,
0,
"ERR",
"DIMENSION1",
"PARAMETER1",
"INTENT1",
"EXTERNAL1",
"INTRINSIC1",
"OPTIONAL1",
"POINTER1",
"SAVE1",
"TARGET1",
"DATA1",
"PUBLIC1",
"PRIVATE1",
"ALLOCATABLE1",
"ARRAY1",
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
"NewLine",
};
static    yyTCombType    yyTComb        [yyTableMax + 1] = {
{664, 1197},
{1, 1171},
{61, 62},
{91, 92},
{108, 729},
{110, 730},
{1, 1171},
{31, 696},
{112, 731},
{114, 732},
{66, 67},
{80, 81},
{117, 118},
{23, 24},
{10, 724},
{25, 705},
{73, 722},
{11, 1818},
{9, 1447},
{27, 13},
{27, 15},
{9, 1447},
{46, 47},
{11, 1818},
{37, 1769},
{53, 1763},
{11, 1818},
{11, 1818},
{51, 1763},
{58, 720},
{11, 1818},
{37, 1769},
{46, 1749},
{64, 65},
{68, 69},
{51, 1763},
{46, 1749},
{37, 1769},
{37, 1769},
{46, 1749},
{37, 1769},
{37, 1769},
{52, 53},
{75, 725},
{37, 1769},
{1, 1171},
{1, 1171},
{72, 1717},
{1, 1171},
{52, 57},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{60, 721},
{1, 1171},
{76, 77},
{78, 79},
{82, 726},
{83, 1191},
{84, 8},
{60, 61},
{1, 1171},
{48, 1758},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{85, 86},
{1, 1171},
{48, 1758},
{1, 1171},
{1, 1171},
{48, 1758},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{70, 1716},
{1, 1171},
{1, 1171},
{1, 1171},
{92, 692},
{93, 723},
{1, 1171},
{70, 71},
{49, 1757},
{99, 728},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{49, 1757},
{1, 1171},
{1, 1171},
{49, 1757},
{87, 88},
{87, 1818},
{96, 1829},
{1, 1171},
{87, 1818},
{96, 1829},
{90, 704},
{105, 106},
{5, 1171},
{5, 1171},
{5, 1171},
{5, 1171},
{1, 1171},
{119, 734},
{1, 1171},
{3, 4},
{1, 1171},
{120, 1320},
{1, 1171},
{1, 1171},
{90, 91},
{122, 123},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{98, 94},
{98, 95},
{1, 1171},
{1, 1171},
{3, 197},
{3, 204},
{3, 1226},
{3, 1226},
{5, 1171},
{5, 1171},
{123, 736},
{5, 1171},
{5, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{5, 1171},
{50, 1755},
{57, 1763},
{127, 740},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{50, 51},
{57, 1763},
{1, 1171},
{50, 1755},
{57, 1763},
{1, 1171},
{1, 1171},
{1, 1171},
{129, 126},
{5, 1171},
{130, 741},
{5, 1171},
{95, 96},
{95, 693},
{95, 694},
{128, 129},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{1, 1171},
{97, 98},
{97, 1453},
{16, 1813},
{131, 132},
{97, 1453},
{100, 1451},
{16, 1813},
{133, 742},
{100, 101},
{16, 1813},
{16, 1813},
{16, 1813},
{16, 1813},
{16, 1813},
{16, 1813},
{16, 1813},
{16, 1813},
{3, 658},
{16, 1813},
{16, 1813},
{102, 1445},
{134, 135},
{16, 1813},
{102, 103},
{137, 743},
{16, 1813},
{16, 1813},
{16, 1813},
{16, 1813},
{16, 1813},
{16, 1813},
{16, 1813},
{16, 1813},
{138, 744},
{16, 1813},
{16, 1813},
{54, 1764},
{140, 136},
{55, 1760},
{16, 1813},
{139, 1378},
{147, 148},
{54, 1764},
{54, 1764},
{55, 56},
{55, 1760},
{54, 1764},
{139, 140},
{55, 1760},
{54, 1764},
{1, 2},
{4, 5},
{6, 5},
{11, 1818},
{124, 1408},
{149, 150},
{152, 745},
{143, 142},
{155, 156},
{158, 159},
{145, 146},
{151, 1460},
{18, 1800},
{3, 205},
{3, 206},
{3, 207},
{18, 1800},
{37, 1769},
{151, 1460},
{18, 1800},
{18, 1800},
{18, 1800},
{159, 160},
{153, 1458},
{160, 161},
{18, 1800},
{18, 1800},
{161, 747},
{18, 1800},
{18, 1800},
{153, 154},
{162, 748},
{18, 1800},
{72, 1717},
{164, 157},
{18, 1800},
{18, 1800},
{18, 1800},
{18, 1800},
{18, 1800},
{18, 1800},
{18, 1800},
{18, 1800},
{20, 1807},
{18, 1800},
{18, 1800},
{166, 746},
{20, 1807},
{167, 168},
{18, 1800},
{20, 1807},
{20, 1807},
{20, 1807},
{20, 1807},
{20, 1807},
{20, 702},
{20, 1807},
{20, 1807},
{163, 1268},
{20, 1807},
{20, 1807},
{168, 749},
{83, 1442},
{20, 1807},
{169, 704},
{163, 164},
{20, 1807},
{20, 1807},
{20, 1807},
{20, 1807},
{20, 1807},
{20, 1807},
{20, 1807},
{20, 1807},
{175, 750},
{20, 1807},
{20, 1807},
{172, 173},
{176, 751},
{180, 181},
{20, 1807},
{22, 11},
{22, 693},
{22, 694},
{22, 695},
{70, 1716},
{136, 1173},
{157, 1271},
{136, 137},
{189, 190},
{165, 1274},
{194, 752},
{22, 12},
{136, 1173},
{157, 1271},
{196, 188},
{157, 158},
{165, 166},
{178, 1354},
{28, 1786},
{186, 180},
{193, 1350},
{22, 14},
{199, 753},
{105, 1387},
{200, 755},
{28, 1786},
{195, 196},
{193, 192},
{202, 754},
{201, 1238},
{203, 5},
{28, 1786},
{28, 1786},
{209, 210},
{28, 1786},
{28, 1786},
{201, 202},
{211, 212},
{28, 1786},
{22, 697},
{22, 698},
{28, 707},
{28, 708},
{28, 709},
{28, 710},
{28, 711},
{28, 712},
{28, 1786},
{28, 1786},
{22, 699},
{28, 1786},
{28, 1786},
{30, 1795},
{212, 213},
{214, 215},
{28, 1786},
{30, 1795},
{217, 759},
{217, 760},
{30, 1795},
{218, 761},
{220, 5},
{224, 225},
{226, 762},
{227, 228},
{30, 1795},
{30, 1795},
{229, 764},
{30, 1795},
{30, 1795},
{230, 231},
{232, 773},
{30, 1795},
{236, 157},
{237, 775},
{30, 1795},
{30, 1795},
{30, 1795},
{30, 1795},
{30, 1795},
{30, 1795},
{30, 1795},
{30, 1795},
{32, 1798},
{30, 1795},
{30, 1795},
{240, 733},
{32, 1798},
{128, 1410},
{30, 1795},
{32, 1798},
{32, 1798},
{32, 1798},
{228, 756},
{228, 757},
{228, 758},
{32, 1798},
{32, 1798},
{233, 223},
{32, 1798},
{32, 1798},
{241, 777},
{247, 778},
{32, 1798},
{233, 1325},
{248, 5},
{32, 1798},
{32, 1798},
{32, 1798},
{32, 1798},
{32, 1798},
{32, 1798},
{32, 1798},
{32, 1798},
{33, 1797},
{32, 1798},
{32, 1798},
{235, 1311},
{33, 1797},
{16, 1813},
{32, 1798},
{33, 1797},
{33, 1797},
{33, 1797},
{235, 1311},
{239, 776},
{244, 1316},
{33, 1797},
{33, 1797},
{249, 250},
{33, 1797},
{33, 1797},
{250, 1462},
{251, 1466},
{33, 1797},
{253, 254},
{239, 240},
{33, 1797},
{33, 1797},
{33, 1797},
{33, 1797},
{33, 1797},
{33, 1797},
{33, 1797},
{33, 1797},
{35, 1787},
{33, 1797},
{33, 1797},
{255, 780},
{35, 706},
{256, 257},
{33, 1797},
{35, 1787},
{242, 243},
{257, 258},
{258, 781},
{259, 5},
{245, 246},
{35, 1787},
{35, 1787},
{143, 1375},
{35, 1787},
{35, 1787},
{145, 1383},
{242, 1315},
{35, 1787},
{142, 107},
{142, 109},
{142, 111},
{142, 113},
{142, 115},
{142, 737},
{142, 738},
{264, 265},
{35, 1787},
{35, 1787},
{36, 1794},
{35, 1787},
{35, 1787},
{18, 1800},
{36, 1794},
{265, 266},
{35, 1787},
{36, 1794},
{36, 713},
{36, 714},
{252, 253},
{252, 256},
{263, 264},
{36, 1794},
{36, 1794},
{267, 1371},
{36, 1794},
{36, 1794},
{269, 270},
{271, 268},
{36, 1794},
{270, 782},
{270, 783},
{36, 1794},
{36, 1794},
{36, 1794},
{36, 1794},
{36, 1794},
{36, 1794},
{36, 1794},
{36, 1794},
{39, 1773},
{36, 1794},
{36, 1794},
{20, 1807},
{272, 273},
{41, 1777},
{36, 1794},
{39, 1773},
{303, 784},
{306, 1192},
{308, 302},
{276, 1429},
{41, 1777},
{39, 1773},
{39, 1773},
{312, 313},
{39, 1773},
{39, 1773},
{41, 1777},
{41, 1777},
{39, 1773},
{41, 1777},
{41, 1777},
{172, 1343},
{277, 278},
{41, 1777},
{281, 282},
{285, 1439},
{286, 287},
{238, 1313},
{290, 1434},
{291, 292},
{39, 1773},
{39, 1773},
{43, 1776},
{41, 1777},
{238, 239},
{41, 1777},
{41, 1777},
{142, 131},
{238, 1313},
{43, 1776},
{41, 1777},
{295, 296},
{178, 1354},
{299, 300},
{186, 1356},
{43, 1776},
{43, 1776},
{94, 11},
{43, 1776},
{43, 1776},
{94, 695},
{195, 1347},
{43, 1776},
{310, 1191},
{313, 788},
{313, 789},
{310, 306},
{28, 1786},
{94, 89},
{314, 790},
{44, 1772},
{43, 719},
{43, 1776},
{315, 1502},
{43, 1776},
{43, 1776},
{319, 320},
{44, 1772},
{45, 1771},
{43, 1776},
{315, 316},
{317, 318},
{321, 322},
{44, 1772},
{44, 1772},
{45, 1771},
{44, 1772},
{44, 1772},
{322, 323},
{214, 1512},
{44, 1772},
{45, 1771},
{45, 1771},
{324, 1544},
{45, 1771},
{45, 1771},
{94, 697},
{94, 698},
{45, 1771},
{324, 1544},
{44, 717},
{30, 1795},
{44, 1772},
{44, 1772},
{327, 794},
{328, 1549},
{329, 793},
{44, 718},
{330, 1539},
{333, 334},
{45, 715},
{45, 716},
{328, 329},
{59, 1799},
{335, 336},
{330, 331},
{252, 1480},
{59, 1799},
{336, 337},
{343, 796},
{59, 1799},
{59, 1799},
{59, 1799},
{59, 700},
{59, 701},
{346, 797},
{59, 1799},
{59, 1799},
{347, 798},
{59, 1799},
{59, 1799},
{350, 351},
{32, 1798},
{59, 1799},
{352, 353},
{357, 1530},
{59, 1799},
{59, 1799},
{59, 1799},
{59, 1799},
{59, 1799},
{59, 1799},
{59, 1799},
{59, 1799},
{62, 1818},
{59, 1799},
{59, 1799},
{174, 1361},
{62, 1818},
{358, 359},
{59, 1799},
{367, 1420},
{62, 1818},
{62, 1818},
{62, 1818},
{316, 1507},
{62, 1818},
{341, 342},
{341, 1565},
{348, 1563},
{370, 799},
{244, 1316},
{316, 1507},
{33, 1797},
{174, 175},
{341, 1565},
{348, 349},
{62, 1818},
{62, 1818},
{62, 1818},
{62, 1818},
{62, 1818},
{62, 1818},
{62, 1818},
{62, 1818},
{361, 1525},
{62, 1818},
{62, 1818},
{355, 1561},
{63, 1749},
{356, 1584},
{62, 1818},
{63, 1715},
{63, 1749},
{355, 1561},
{63, 1749},
{356, 1584},
{63, 1749},
{63, 1749},
{63, 1749},
{63, 1749},
{63, 1749},
{245, 1308},
{63, 1749},
{35, 1787},
{362, 363},
{365, 366},
{371, 372},
{372, 369},
{242, 1315},
{373, 1193},
{63, 1749},
{63, 1749},
{63, 1749},
{63, 1749},
{63, 1749},
{63, 1749},
{63, 1749},
{63, 1749},
{63, 1749},
{74, 1819},
{63, 1749},
{63, 1749},
{376, 800},
{74, 1819},
{319, 332},
{63, 1749},
{378, 375},
{74, 1819},
{74, 1819},
{74, 1819},
{74, 1819},
{74, 1819},
{263, 1364},
{74, 1819},
{36, 1794},
{267, 1371},
{377, 378},
{383, 801},
{269, 1367},
{382, 383},
{380, 381},
{384, 5},
{74, 1819},
{74, 1819},
{74, 1819},
{74, 1819},
{74, 1819},
{74, 1819},
{74, 1819},
{74, 1819},
{385, 1587},
{74, 1819},
{74, 1819},
{389, 390},
{391, 392},
{272, 1364},
{74, 1819},
{333, 338},
{101, 87},
{101, 693},
{101, 694},
{101, 695},
{276, 1429},
{388, 389},
{107, 1251},
{39, 1773},
{174, 1361},
{174, 1361},
{174, 1361},
{101, 89},
{41, 1777},
{101, 94},
{101, 95},
{392, 5},
{394, 803},
{277, 1427},
{107, 1251},
{281, 1399},
{285, 1439},
{286, 1437},
{107, 108},
{290, 1434},
{291, 1432},
{360, 1583},
{107, 1251},
{344, 345},
{344, 1567},
{325, 326},
{395, 5},
{360, 1583},
{107, 1251},
{238, 1313},
{339, 340},
{344, 1567},
{295, 1392},
{325, 1545},
{299, 1394},
{101, 697},
{101, 698},
{43, 1776},
{339, 1559},
{325, 1545},
{364, 1581},
{316, 785},
{316, 786},
{316, 787},
{339, 1559},
{397, 5},
{364, 1581},
{310, 1403},
{399, 804},
{216, 1464},
{401, 402},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{379, 1582},
{403, 5},
{405, 805},
{406, 407},
{317, 1497},
{408, 409},
{379, 1582},
{44, 1772},
{107, 1251},
{107, 1251},
{107, 1251},
{216, 217},
{410, 5},
{413, 5},
{355, 354},
{45, 1771},
{324, 1544},
{415, 416},
{417, 418},
{418, 419},
{419, 5},
{396, 1587},
{396, 1587},
{396, 1587},
{396, 1587},
{422, 807},
{174, 1361},
{174, 1361},
{174, 1361},
{174, 1361},
{174, 1361},
{174, 1361},
{174, 1361},
{174, 1361},
{174, 1361},
{174, 1361},
{174, 1361},
{174, 1361},
{174, 1361},
{174, 1361},
{424, 425},
{109, 1249},
{420, 1587},
{420, 1587},
{421, 413},
{421, 415},
{426, 427},
{421, 1728},
{427, 428},
{428, 808},
{59, 1799},
{396, 1587},
{396, 1587},
{109, 1249},
{107, 1251},
{107, 1251},
{107, 1251},
{109, 110},
{357, 1530},
{430, 431},
{434, 809},
{109, 1249},
{396, 1587},
{436, 429},
{432, 1642},
{437, 1619},
{438, 1620},
{109, 1249},
{439, 1622},
{440, 1623},
{430, 1749},
{432, 1642},
{358, 1528},
{107, 1251},
{223, 224},
{223, 763},
{223, 227},
{223, 765},
{223, 766},
{223, 767},
{223, 768},
{223, 769},
{223, 770},
{223, 771},
{396, 1587},
{445, 446},
{223, 772},
{223, 230},
{441, 806},
{448, 1615},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{433, 1643},
{361, 1525},
{441, 442},
{450, 451},
{216, 1464},
{216, 1464},
{216, 1464},
{433, 1643},
{109, 1249},
{109, 1249},
{109, 1249},
{382, 1218},
{435, 1640},
{443, 1613},
{452, 811},
{453, 454},
{456, 813},
{454, 455},
{457, 1675},
{435, 436},
{443, 444},
{362, 1523},
{365, 1554},
{371, 1422},
{449, 1191},
{457, 1675},
{107, 1251},
{107, 1251},
{107, 1251},
{373, 1414},
{339, 1559},
{388, 1713},
{449, 727},
{454, 814},
{463, 464},
{465, 466},
{470, 816},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{107, 1251},
{111, 1255},
{458, 1674},
{377, 1416},
{109, 1249},
{109, 1249},
{109, 1249},
{380, 1533},
{461, 462},
{458, 1674},
{471, 1660},
{469, 1669},
{461, 1173},
{111, 1255},
{477, 454},
{478, 1654},
{484, 485},
{111, 112},
{469, 460},
{461, 1173},
{490, 817},
{111, 1255},
{489, 484},
{109, 1249},
{383, 1217},
{486, 1686},
{492, 483},
{111, 1255},
{472, 1694},
{473, 474},
{475, 476},
{480, 481},
{486, 1686},
{460, 461},
{216, 1464},
{216, 1464},
{216, 1464},
{216, 1464},
{216, 1464},
{216, 1464},
{216, 1464},
{216, 1464},
{216, 1464},
{216, 1464},
{216, 1464},
{216, 1464},
{216, 1464},
{216, 1464},
{498, 1616},
{501, 502},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{479, 806},
{500, 704},
{503, 504},
{479, 812},
{488, 1683},
{325, 1545},
{487, 1685},
{504, 806},
{111, 1255},
{111, 1255},
{111, 1255},
{488, 489},
{505, 506},
{487, 1685},
{506, 1697},
{479, 815},
{109, 1249},
{109, 1249},
{109, 1249},
{510, 511},
{512, 820},
{513, 514},
{517, 821},
{496, 497},
{518, 519},
{496, 499},
{496, 10},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{109, 1249},
{113, 1257},
{496, 17},
{460, 463},
{515, 1635},
{520, 822},
{521, 522},
{523, 524},
{525, 1587},
{526, 1733},
{526, 527},
{515, 516},
{527, 5},
{113, 1257},
{111, 1255},
{111, 1255},
{111, 1255},
{113, 114},
{529, 823},
{530, 531},
{531, 532},
{113, 1257},
{533, 534},
{446, 1191},
{446, 1191},
{446, 1191},
{446, 1191},
{113, 1257},
{446, 1191},
{534, 5},
{535, 536},
{536, 537},
{537, 538},
{111, 1255},
{446, 1191},
{539, 824},
{446, 1191},
{446, 1191},
{541, 826},
{540, 825},
{542, 827},
{543, 5},
{544, 1587},
{544, 1587},
{446, 1191},
{540, 541},
{427, 1637},
{545, 1740},
{546, 5},
{548, 549},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{409, 806},
{549, 828},
{551, 552},
{557, 829},
{554, 704},
{446, 1191},
{446, 1191},
{446, 1191},
{113, 1257},
{113, 1257},
{113, 1257},
{554, 555},
{555, 423},
{550, 1736},
{558, 559},
{446, 1191},
{560, 555},
{562, 563},
{563, 830},
{564, 565},
{567, 831},
{568, 569},
{573, 574},
{560, 561},
{570, 1634},
{571, 1630},
{111, 1255},
{111, 1255},
{111, 1255},
{545, 546},
{575, 832},
{570, 1634},
{571, 572},
{577, 578},
{579, 833},
{580, 581},
{581, 324},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{111, 1255},
{115, 1259},
{550, 1736},
{566, 10},
{113, 1257},
{113, 1257},
{113, 1257},
{489, 465},
{583, 584},
{585, 586},
{587, 588},
{566, 1633},
{449, 1611},
{115, 116},
{584, 795},
{589, 5},
{586, 354},
{115, 121},
{460, 465},
{566, 17},
{409, 410},
{115, 1259},
{222, 1322},
{113, 1257},
{590, 591},
{594, 834},
{409, 423},
{115, 1259},
{409, 426},
{409, 810},
{409, 437},
{409, 439},
{588, 589},
{578, 791},
{588, 590},
{409, 441},
{578, 792},
{595, 5},
{409, 453},
{409, 477},
{409, 479},
{409, 482},
{409, 491},
{409, 492},
{409, 493},
{409, 494},
{409, 495},
{596, 597},
{222, 774},
{597, 598},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{484, 1173},
{472, 1694},
{473, 1692},
{475, 1658},
{480, 1656},
{486, 1686},
{409, 818},
{409, 819},
{115, 1259},
{115, 1259},
{115, 1259},
{598, 5},
{592, 1710},
{601, 602},
{605, 606},
{607, 5},
{113, 1257},
{113, 1257},
{113, 1257},
{592, 593},
{609, 835},
{614, 615},
{600, 388},
{610, 611},
{616, 5},
{618, 836},
{619, 620},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{113, 1257},
{121, 1261},
{121, 735},
{487, 1685},
{620, 703},
{500, 1617},
{586, 1561},
{599, 1749},
{621, 1243},
{599, 1749},
{599, 1749},
{622, 5},
{626, 199},
{121, 122},
{115, 1259},
{115, 1259},
{115, 1259},
{599, 600},
{624, 625},
{624, 628},
{627, 5},
{121, 1261},
{600, 551},
{610, 619},
{629, 1235},
{577, 1746},
{599, 1749},
{121, 1261},
{630, 510},
{631, 5},
{633, 634},
{635, 5},
{297, 1193},
{115, 1259},
{636, 5},
{222, 1322},
{222, 1322},
{222, 1322},
{638, 639},
{634, 837},
{643, 644},
{645, 156},
{555, 5},
{648, 1245},
{641, 642},
{646, 320},
{643, 1574},
{649, 842},
{651, 652},
{640, 236},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{640, 1311},
{297, 739},
{623, 204},
{623, 1226},
{623, 1226},
{655, 843},
{659, 5},
{647, 340},
{121, 1261},
{121, 1261},
{121, 1261},
{661, 662},
{584, 341},
{584, 344},
{663, 5},
{647, 1559},
{653, 654},
{656, 1474},
{656, 651},
{621, 622},
{665, 1171},
{647, 1559},
{657, 1470},
{657, 1470},
{662, 844},
{668, 845},
{115, 1259},
{115, 1259},
{115, 1259},
{600, 587},
{600, 596},
{669, 5},
{672, 5},
{673, 1168},
{0, 0},
{0, 0},
{0, 0},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{115, 1259},
{0, 0},
{0, 0},
{0, 0},
{121, 1261},
{121, 1261},
{121, 1261},
{667, 668},
{222, 1322},
{222, 1322},
{222, 1322},
{222, 1322},
{222, 1322},
{222, 1322},
{222, 1322},
{222, 1322},
{222, 1322},
{222, 1322},
{222, 1322},
{222, 1322},
{222, 1322},
{222, 1322},
{254, 779},
{121, 1261},
{0, 0},
{0, 0},
{254, 706},
{0, 0},
{0, 0},
{0, 0},
{254, 713},
{254, 714},
{254, 700},
{254, 701},
{254, 702},
{297, 1193},
{297, 1193},
{297, 1193},
{0, 0},
{0, 0},
{587, 1708},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{254, 707},
{254, 708},
{254, 709},
{254, 710},
{254, 711},
{254, 712},
{254, 719},
{254, 717},
{0, 0},
{254, 715},
{254, 716},
{0, 0},
{0, 0},
{254, 703},
{254, 718},
{0, 0},
{0, 0},
{386, 1196},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{623, 205},
{623, 206},
{623, 207},
{0, 0},
{0, 0},
{0, 0},
{121, 1261},
{121, 1261},
{121, 1261},
{0, 0},
{646, 332},
{653, 1477},
{653, 1477},
{0, 0},
{0, 0},
{661, 1213},
{0, 0},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{121, 1261},
{0, 0},
{630, 1224},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{633, 1222},
{647, 1559},
{0, 0},
{644, 645},
{297, 1193},
{297, 1193},
{297, 1193},
{297, 1193},
{297, 1193},
{297, 1193},
{297, 1193},
{297, 1193},
{297, 1193},
{297, 1193},
{297, 1193},
{297, 1193},
{297, 1193},
{297, 1193},
{386, 1588},
{386, 1196},
{0, 0},
{386, 1196},
{0, 0},
{386, 1588},
{386, 1588},
{386, 1588},
{386, 1588},
{0, 0},
{386, 1196},
{0, 0},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{0, 0},
{386, 1196},
{626, 1235},
{386, 1196},
{386, 1196},
{0, 0},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{0, 0},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1588},
{386, 1588},
{386, 1196},
{386, 1588},
{386, 1588},
{0, 0},
{386, 1196},
{641, 1571},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1588},
{386, 1196},
{386, 1196},
{524, 426},
{524, 810},
{524, 437},
{524, 439},
{386, 1196},
{0, 0},
{640, 1311},
{524, 441},
{634, 1221},
{0, 0},
{524, 453},
{524, 477},
{524, 479},
{524, 482},
{524, 491},
{524, 492},
{524, 493},
{524, 494},
{524, 495},
{386, 1588},
{667, 1209},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{644, 646},
{0, 0},
{0, 0},
{386, 1196},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{524, 818},
{524, 819},
{644, 647},
{0, 0},
{644, 838},
{644, 839},
{644, 840},
{0, 0},
{0, 0},
{386, 1196},
{0, 0},
{386, 1196},
{0, 0},
{0, 0},
{0, 0},
{662, 1212},
{668, 1208},
{644, 841},
{0, 0},
{0, 0},
{0, 0},
{386, 1196},
{386, 1196},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{386, 1196},
{387, 388},
{0, 0},
{387, 406},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{387, 423},
{0, 0},
{387, 426},
{387, 810},
{387, 437},
{387, 439},
{0, 0},
{387, 505},
{0, 0},
{387, 441},
{387, 507},
{0, 0},
{387, 453},
{387, 477},
{387, 479},
{387, 482},
{387, 491},
{387, 492},
{387, 493},
{387, 494},
{387, 495},
{0, 0},
{387, 513},
{387, 518},
{387, 521},
{0, 0},
{0, 0},
{387, 530},
{0, 0},
{414, 1195},
{0, 0},
{387, 551},
{0, 0},
{0, 0},
{414, 386},
{0, 0},
{0, 0},
{387, 818},
{387, 819},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{387, 562},
{0, 0},
{0, 0},
{0, 0},
{455, 1173},
{0, 0},
{0, 0},
{455, 456},
{455, 1173},
{0, 0},
{455, 1173},
{0, 0},
{455, 1173},
{455, 1173},
{455, 1173},
{455, 1173},
{455, 1173},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{387, 573},
{455, 1173},
{455, 1173},
{455, 1173},
{455, 1173},
{455, 1173},
{455, 1173},
{455, 1173},
{455, 1173},
{455, 1173},
{0, 0},
{455, 1173},
{455, 1173},
{0, 0},
{0, 0},
{387, 576},
{455, 1173},
{387, 582},
{670, 107},
{670, 109},
{670, 111},
{670, 113},
{670, 115},
{670, 737},
{670, 738},
{0, 0},
{0, 0},
{387, 587},
{387, 596},
{414, 1195},
{0, 0},
{414, 1195},
{0, 0},
{670, 204},
{670, 1226},
{670, 1226},
{414, 1587},
{0, 0},
{414, 1195},
{0, 0},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{0, 0},
{414, 1195},
{0, 0},
{414, 1195},
{414, 1195},
{0, 0},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{0, 0},
{414, 1195},
{414, 1195},
{414, 1195},
{0, 0},
{0, 0},
{414, 1195},
{0, 0},
{0, 0},
{0, 0},
{414, 1195},
{0, 0},
{414, 1195},
{414, 1195},
{414, 1195},
{0, 0},
{414, 1195},
{414, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{414, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{528, 1195},
{670, 131},
{0, 0},
{0, 0},
{0, 0},
{528, 386},
{0, 0},
{0, 0},
{0, 0},
{414, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{414, 1195},
{0, 0},
{414, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{414, 1195},
{414, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{670, 205},
{670, 206},
{670, 207},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{414, 1195},
{528, 1195},
{658, 674},
{528, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{528, 1195},
{0, 0},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{0, 0},
{528, 1195},
{0, 0},
{528, 1195},
{528, 1195},
{0, 0},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{0, 0},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1587},
{0, 0},
{528, 1195},
{0, 0},
{0, 0},
{0, 0},
{528, 1195},
{0, 0},
{528, 1195},
{528, 1195},
{528, 1195},
{0, 0},
{528, 1195},
{528, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{528, 1195},
{0, 0},
{0, 0},
{0, 0},
{553, 1749},
{0, 0},
{0, 0},
{553, 1715},
{553, 1749},
{0, 0},
{553, 1749},
{553, 1749},
{553, 1749},
{553, 1749},
{553, 1749},
{553, 1749},
{553, 1749},
{547, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{547, 386},
{0, 0},
{0, 0},
{528, 1195},
{553, 1749},
{553, 1749},
{553, 1749},
{553, 1749},
{553, 1749},
{553, 1749},
{553, 1749},
{553, 1749},
{553, 1749},
{0, 0},
{553, 1749},
{553, 1749},
{0, 0},
{0, 0},
{528, 1195},
{553, 1749},
{528, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{528, 1195},
{528, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{658, 675},
{658, 676},
{658, 677},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{528, 1195},
{547, 1587},
{547, 1195},
{0, 0},
{547, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{547, 1195},
{0, 0},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{0, 0},
{547, 1195},
{0, 0},
{547, 1195},
{547, 1195},
{0, 0},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{0, 0},
{547, 1195},
{547, 1195},
{547, 1195},
{0, 0},
{0, 0},
{547, 1195},
{0, 0},
{0, 0},
{0, 0},
{547, 1195},
{0, 0},
{547, 1195},
{547, 1195},
{547, 1195},
{0, 0},
{547, 1195},
{547, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{547, 1195},
{0, 0},
{658, 678},
{658, 679},
{658, 680},
{658, 681},
{658, 682},
{658, 683},
{658, 684},
{658, 685},
{658, 686},
{658, 687},
{658, 688},
{658, 689},
{658, 690},
{658, 691},
{556, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{556, 386},
{0, 0},
{0, 0},
{0, 0},
{547, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{611, 1713},
{611, 802},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{547, 1195},
{0, 0},
{547, 1195},
{0, 0},
{612, 1191},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{611, 1713},
{0, 0},
{547, 1195},
{547, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{612, 727},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{547, 1195},
{556, 1195},
{0, 0},
{556, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{556, 1195},
{0, 0},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{0, 0},
{556, 1195},
{0, 0},
{556, 1195},
{556, 1195},
{0, 0},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{0, 0},
{556, 1195},
{556, 1195},
{556, 1195},
{0, 0},
{0, 0},
{556, 1195},
{0, 0},
{0, 0},
{0, 0},
{556, 1195},
{0, 0},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1587},
{556, 1195},
{556, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{556, 1195},
{0, 0},
{0, 0},
{0, 0},
{611, 1713},
{611, 1713},
{611, 1713},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{612, 1191},
{612, 1191},
{612, 1191},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{556, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{556, 1195},
{0, 0},
{556, 1195},
{0, 0},
{617, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{617, 386},
{0, 0},
{0, 0},
{556, 1195},
{556, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{556, 1195},
{611, 1713},
{611, 1713},
{611, 1713},
{611, 1713},
{611, 1713},
{611, 1713},
{611, 1713},
{611, 1713},
{611, 1713},
{611, 1713},
{611, 1713},
{611, 1713},
{611, 1713},
{611, 1713},
{612, 1191},
{612, 1191},
{612, 1191},
{612, 1191},
{612, 1191},
{612, 1191},
{612, 1191},
{612, 1191},
{612, 1191},
{612, 1191},
{612, 1191},
{612, 1191},
{612, 1191},
{612, 1191},
{617, 1195},
{0, 0},
{617, 1195},
{0, 0},
{0, 0},
{0, 0},
{617, 1587},
{0, 0},
{0, 0},
{617, 1195},
{0, 0},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{0, 0},
{617, 1195},
{0, 0},
{617, 1195},
{617, 1195},
{0, 0},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{0, 0},
{617, 1195},
{617, 1195},
{617, 1195},
{0, 0},
{0, 0},
{617, 1195},
{0, 0},
{0, 0},
{0, 0},
{617, 1195},
{0, 0},
{617, 1195},
{617, 1195},
{617, 1195},
{0, 0},
{617, 1195},
{617, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{617, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{617, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{671, 1282},
{617, 1195},
{0, 0},
{617, 1195},
{0, 0},
{671, 1282},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{617, 1195},
{617, 1195},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{617, 1195},
{671, 7},
{0, 0},
{671, 104},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{671, 124},
{671, 130},
{671, 144},
{671, 147},
{671, 155},
{671, 174},
{671, 187},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{671, 1282},
{671, 1282},
{0, 0},
{671, 1282},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{671, 1282},
{0, 0},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{0, 0},
{671, 1282},
{0, 0},
{671, 1282},
{671, 1282},
{0, 0},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{0, 0},
{671, 1282},
{671, 1282},
{671, 1282},
{0, 0},
{0, 0},
{671, 1282},
{0, 0},
{0, 0},
{0, 0},
{671, 1282},
{671, 209},
{671, 1282},
{671, 1282},
{671, 1282},
{0, 0},
{671, 1282},
{671, 1282},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{671, 1282},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{671, 216},
{0, 0},
{671, 252},
{0, 0},
{0, 0},
{0, 0},
{671, 1282},
{671, 262},
{0, 0},
{0, 0},
{671, 274},
{671, 279},
{671, 283},
{671, 288},
{671, 293},
{671, 297},
{671, 1282},
{671, 301},
{0, 0},
{0, 0},
{671, 311},
{671, 319},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{671, 1282},
{671, 339},
{671, 1282},
{671, 356},
{671, 360},
{671, 364},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{671, 367},
{671, 373},
{671, 1282},
{671, 1282},
{0, 0},
{0, 0},
{671, 379},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{671, 1282},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
};
static    unsigned short    yyNComb        [yyNTableMax - yyLastTerminal] = {
3,
846,
673,
1158,
848,
6,
847,
849,
850,
851,
664,
1160,
1161,
1162,
1163,
1164,
665,
666,
850,
84,
883,
261,
117,
624,
632,
883,
125,
670,
671,
886,
127,
385,
886,
134,
46,
133,
171,
134,
905,
63,
897,
904,
889,
900,
163,
903,
1112,
636,
1114,
1115,
1116,
1117,
1118,
1119,
1120,
1121,
1122,
1123,
1124,
1125,
1126,
1127,
1128,
1129,
1130,
1131,
1132,
1133,
1134,
1135,
1136,
1137,
1138,
49,
850,
149,
170,
149,
176,
909,
198,
203,
919,
211,
171,
925,
889,
194,
177,
914,
9,
185,
912,
178,
893,
850,
893,
892,
891,
910,
9,
178,
850,
911,
141,
913,
908,
63,
143,
178,
178,
915,
195,
60,
906,
172,
16,
925,
884,
105,
218,
9,
220,
885,
105,
916,
195,
221,
850,
873,
83,
85,
229,
102,
877,
850,
138,
139,
887,
128,
46,
888,
128,
76,
924,
850,
219,
928,
208,
238,
21,
19,
31,
29,
34,
242,
16,
40,
38,
42,
930,
850,
907,
172,
78,
82,
80,
850,
1139,
1140,
1141,
1142,
1143,
1144,
1145,
879,
931,
16,
179,
49,
890,
139,
934,
923,
16,
27,
184,
208,
850,
9,
894,
145,
895,
145,
186,
182,
638,
183,
922,
643,
917,
235,
208,
850,
235,
917,
152,
153,
896,
153,
9,
850,
222,
260,
920,
921,
50,
9,
208,
208,
234,
247,
16,
200,
201,
27,
263,
189,
918,
201,
233,
929,
78,
871,
80,
956,
248,
951,
850,
271,
955,
275,
957,
16,
280,
926,
214,
267,
284,
16,
25,
882,
963,
102,
948,
935,
874,
83,
85,
850,
102,
289,
966,
294,
298,
304,
303,
309,
245,
933,
16,
245,
932,
852,
853,
26,
26,
927,
214,
285,
26,
850,
984,
852,
853,
191,
997,
878,
850,
861,
865,
27,
93,
16,
875,
876,
861,
975,
996,
852,
853,
75,
52,
854,
852,
853,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
16,
850,
50,
276,
960,
249,
999,
251,
878,
272,
861,
1001,
97,
1004,
972,
97,
952,
953,
269,
852,
853,
16,
368,
854,
370,
222,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
852,
853,
27,
16,
854,
374,
276,
852,
853,
248,
16,
854,
852,
853,
59,
860,
20,
22,
858,
23,
861,
18,
860,
20,
22,
858,
23,
861,
850,
27,
936,
259,
376,
852,
853,
960,
865,
850,
964,
286,
852,
853,
384,
16,
305,
852,
853,
58,
52,
854,
852,
853,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
852,
853,
961,
281,
854,
972,
852,
853,
290,
973,
854,
299,
958,
277,
267,
855,
20,
22,
858,
23,
861,
856,
20,
22,
858,
23,
861,
852,
853,
285,
99,
857,
937,
880,
251,
100,
881,
850,
100,
881,
290,
312,
852,
853,
193,
858,
23,
861,
980,
315,
852,
853,
308,
16,
854,
959,
277,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
850,
1019,
962,
281,
312,
350,
852,
853,
975,
308,
854,
969,
969,
37,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
852,
853,
333,
983,
854,
954,
953,
269,
974,
983,
299,
859,
28,
36,
33,
860,
20,
22,
858,
23,
861,
16,
852,
853,
27,
850,
854,
967,
291,
852,
853,
361,
397,
854,
975,
30,
33,
860,
20,
22,
858,
23,
861,
32,
860,
20,
22,
858,
23,
861,
965,
286,
983,
308,
985,
16,
949,
950,
46,
968,
291,
978,
852,
853,
48,
261,
854,
624,
632,
347,
995,
208,
348,
348,
35,
36,
33,
860,
20,
22,
858,
23,
861,
850,
970,
971,
295,
295,
307,
977,
27,
878,
357,
861,
878,
985,
861,
49,
981,
317,
314,
979,
315,
985,
985,
357,
393,
16,
255,
938,
939,
940,
941,
942,
943,
944,
945,
946,
947,
1016,
850,
396,
54,
352,
27,
1013,
348,
404,
411,
852,
853,
1010,
982,
317,
1007,
1013,
422,
414,
852,
853,
16,
310,
854,
361,
850,
420,
39,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
54,
976,
1021,
1007,
998,
1023,
16,
355,
398,
424,
400,
1024,
1010,
1025,
1000,
449,
447,
27,
993,
470,
321,
1016,
330,
1033,
54,
387,
989,
1034,
330,
650,
387,
657,
1036,
443,
63,
445,
443,
994,
1027,
1037,
450,
1005,
362,
16,
1038,
852,
853,
478,
621,
854,
27,
1047,
1048,
394,
41,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
443,
16,
452,
335,
850,
330,
986,
64,
325,
27,
1049,
1014,
377,
852,
853,
50,
503,
854,
387,
1011,
371,
1015,
377,
862,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
1063,
1074,
1073,
508,
1002,
358,
509,
1020,
1075,
70,
512,
529,
27,
990,
528,
325,
16,
1003,
358,
535,
543,
991,
992,
325,
325,
1012,
371,
544,
548,
401,
850,
852,
853,
1017,
380,
854,
27,
387,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
16,
1006,
362,
865,
1030,
1030,
1008,
365,
399,
66,
547,
1030,
852,
853,
866,
52,
854,
72,
850,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
27,
1009,
365,
387,
852,
853,
387,
55,
854,
1018,
380,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
63,
405,
16,
1030,
412,
545,
1085,
550,
395,
564,
1081,
27,
550,
395,
583,
387,
852,
853,
1089,
867,
854,
1029,
387,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
850,
1022,
64,
852,
853,
515,
868,
854,
421,
1028,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
387,
985,
387,
387,
387,
1083,
395,
387,
595,
1090,
27,
577,
983,
585,
1092,
68,
348,
850,
1093,
26,
603,
16,
604,
526,
608,
1077,
1079,
1080,
852,
853,
557,
612,
854,
73,
1021,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
74,
1094,
613,
601,
610,
617,
1021,
649,
68,
623,
16,
395,
626,
627,
1109,
629,
852,
853,
66,
850,
854,
850,
387,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
850,
387,
850,
630,
850,
27,
631,
850,
609,
1110,
635,
1111,
637,
1146,
16,
1149,
1031,
1031,
643,
869,
655,
659,
656,
1031,
618,
395,
660,
1155,
395,
656,
663,
850,
1157,
517,
640,
471,
1165,
475,
1032,
852,
853,
90,
27,
854,
480,
669,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
872,
119,
395,
1166,
592,
1167,
515,
850,
0,
395,
120,
0,
640,
1031,
0,
0,
605,
0,
0,
852,
853,
0,
566,
27,
16,
0,
515,
0,
1152,
566,
0,
1152,
0,
1088,
1035,
325,
614,
0,
0,
467,
468,
469,
850,
579,
0,
330,
151,
0,
395,
850,
395,
395,
395,
16,
0,
395,
0,
0,
0,
852,
853,
0,
0,
854,
870,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
162,
0,
898,
899,
163,
850,
901,
165,
167,
16,
850,
0,
0,
27,
556,
850,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
395,
0,
850,
0,
27,
902,
592,
0,
0,
901,
165,
167,
580,
16,
0,
0,
395,
0,
0,
852,
853,
0,
0,
854,
0,
1076,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
27,
169,
850,
567,
568,
520,
0,
1147,
641,
515,
1087,
568,
1153,
653,
16,
1154,
653,
0,
594,
496,
921,
0,
0,
0,
208,
0,
0,
0,
0,
852,
853,
852,
853,
226,
850,
898,
899,
163,
0,
901,
165,
167,
27,
0,
16,
1148,
641,
852,
853,
852,
853,
852,
853,
854,
852,
853,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
850,
0,
0,
244,
0,
0,
234,
247,
852,
853,
0,
0,
854,
27,
16,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
232,
0,
898,
899,
163,
850,
901,
165,
167,
0,
0,
0,
27,
852,
853,
16,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
1082,
237,
1091,
898,
899,
163,
0,
901,
165,
167,
575,
850,
0,
852,
853,
0,
16,
27,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
241,
0,
0,
0,
0,
0,
0,
0,
27,
120,
0,
16,
0,
0,
0,
852,
853,
0,
0,
0,
852,
853,
0,
0,
854,
852,
853,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
46,
0,
27,
0,
0,
0,
0,
0,
852,
853,
16,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
0,
850,
0,
0,
0,
0,
0,
27,
49,
0,
0,
0,
0,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
343,
0,
0,
0,
0,
0,
0,
0,
27,
852,
853,
16,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
0,
0,
0,
46,
0,
0,
0,
0,
0,
0,
0,
16,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
0,
0,
0,
0,
0,
0,
49,
0,
0,
0,
0,
0,
27,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
0,
0,
0,
0,
0,
327,
328,
988,
27,
382,
0,
0,
0,
16,
0,
0,
0,
0,
852,
853,
222,
0,
854,
0,
385,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
1112,
636,
1114,
1115,
1116,
1117,
1118,
1119,
1120,
1121,
1122,
1123,
1124,
1125,
1126,
1127,
1128,
1129,
1130,
1131,
1132,
1133,
1134,
1135,
1136,
1137,
1138,
599,
0,
0,
0,
0,
0,
0,
0,
0,
850,
0,
0,
0,
0,
0,
865,
27,
0,
0,
0,
0,
0,
0,
0,
852,
853,
0,
52,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
987,
328,
988,
346,
0,
0,
0,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
0,
0,
0,
496,
0,
0,
850,
0,
0,
0,
0,
0,
16,
0,
1107,
1108,
1139,
1140,
1141,
1142,
1143,
1144,
1145,
261,
0,
624,
632,
0,
850,
208,
0,
0,
0,
850,
0,
0,
1150,
648,
0,
0,
0,
0,
865,
0,
638,
391,
0,
643,
0,
0,
0,
852,
853,
0,
52,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
68,
0,
850,
0,
0,
0,
1107,
1108,
0,
27,
0,
0,
0,
0,
0,
261,
16,
624,
632,
0,
0,
208,
0,
0,
0,
0,
850,
0,
1151,
648,
0,
0,
0,
0,
0,
0,
0,
0,
496,
0,
0,
408,
0,
16,
0,
0,
1096,
1097,
1054,
1055,
1098,
1099,
1100,
1101,
1102,
1103,
1056,
1057,
1104,
1058,
1105,
1059,
1060,
1061,
1062,
417,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1064,
1065,
1066,
1067,
1068,
1069,
1070,
1071,
1072,
16,
27,
0,
0,
0,
403,
0,
0,
0,
0,
0,
0,
0,
0,
1106,
0,
601,
610,
0,
0,
0,
0,
0,
0,
16,
430,
0,
0,
27,
0,
852,
853,
0,
0,
0,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
0,
0,
433,
0,
0,
0,
0,
27,
1053,
1054,
1055,
0,
0,
0,
0,
0,
0,
1056,
1057,
850,
1058,
0,
1059,
1060,
1061,
1062,
501,
0,
0,
0,
0,
27,
0,
0,
0,
0,
1064,
1065,
1066,
1067,
1068,
1069,
1070,
1071,
1072,
16,
0,
0,
0,
0,
0,
0,
0,
852,
853,
0,
0,
854,
432,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
852,
853,
0,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
16,
0,
430,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
27,
0,
0,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
850,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
433,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
438,
850,
0,
0,
27,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
949,
950,
0,
0,
16,
0,
434,
435,
0,
261,
850,
624,
632,
0,
0,
208,
0,
0,
0,
0,
0,
0,
0,
0,
0,
440,
0,
0,
16,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
852,
853,
448,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
16,
0,
0,
0,
0,
27,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
850,
0,
0,
0,
0,
0,
0,
16,
0,
0,
0,
0,
27,
0,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
458,
0,
850,
0,
0,
0,
0,
0,
1156,
0,
657,
0,
0,
27,
0,
0,
0,
0,
0,
0,
0,
0,
1026,
435,
0,
0,
850,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
27,
0,
0,
0,
457,
0,
16,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
852,
853,
472,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
16,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
16,
850,
0,
0,
27,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
472,
0,
0,
852,
853,
27,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
850,
0,
0,
0,
0,
27,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
16,
0,
0,
0,
0,
0,
0,
0,
0,
0,
459,
0,
0,
0,
0,
1039,
0,
0,
0,
0,
472,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
850,
0,
0,
0,
0,
16,
0,
0,
0,
0,
0,
27,
0,
1040,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
473,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
472,
850,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
850,
0,
0,
0,
0,
0,
0,
0,
0,
0,
27,
0,
0,
0,
0,
486,
0,
0,
16,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1041,
0,
0,
0,
0,
0,
0,
472,
0,
0,
0,
473,
0,
0,
0,
850,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
16,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
16,
0,
0,
0,
487,
27,
0,
0,
0,
0,
0,
0,
0,
1042,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
473,
0,
0,
0,
0,
850,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
852,
853,
0,
27,
854,
16,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
0,
0,
0,
487,
27,
0,
0,
0,
0,
0,
0,
850,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1043,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
473,
0,
0,
0,
0,
0,
0,
0,
0,
0,
16,
0,
0,
0,
487,
27,
0,
0,
852,
853,
0,
0,
854,
0,
850,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1044,
0,
0,
0,
16,
852,
853,
0,
0,
854,
487,
473,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
27,
850,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
488,
0,
0,
16,
0,
1045,
0,
490,
0,
0,
850,
0,
0,
0,
0,
0,
487,
0,
0,
0,
0,
0,
0,
27,
0,
0,
852,
853,
0,
0,
854,
850,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
498,
0,
0,
0,
0,
0,
0,
0,
850,
0,
16,
0,
0,
0,
0,
488,
0,
0,
0,
0,
1045,
500,
1046,
27,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
852,
853,
16,
0,
854,
0,
523,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
1050,
0,
16,
0,
0,
1045,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
27,
850,
0,
0,
0,
0,
0,
0,
0,
852,
853,
16,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
525,
850,
1051,
27,
0,
0,
0,
1045,
0,
0,
533,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
27,
0,
0,
0,
852,
853,
0,
0,
854,
0,
850,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
27,
0,
0,
16,
0,
0,
0,
0,
1052,
0,
0,
0,
0,
1045,
0,
0,
0,
0,
0,
0,
0,
0,
0,
540,
0,
0,
0,
0,
0,
0,
0,
0,
0,
496,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
16,
852,
853,
0,
850,
854,
27,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
539,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
27,
850,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1078,
1054,
1055,
16,
0,
0,
0,
0,
0,
1056,
1057,
0,
1058,
0,
1059,
1060,
1061,
1062,
0,
0,
553,
0,
0,
0,
0,
0,
542,
0,
1064,
1065,
1066,
1067,
1068,
1069,
1070,
1071,
1072,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
850,
554,
0,
0,
0,
0,
0,
0,
0,
852,
853,
16,
0,
0,
27,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
553,
0,
0,
0,
0,
0,
0,
54,
0,
0,
852,
853,
16,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
0,
0,
850,
0,
0,
0,
554,
0,
0,
0,
0,
0,
0,
0,
0,
27,
0,
16,
0,
0,
0,
0,
0,
0,
558,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
570,
0,
0,
0,
0,
0,
0,
27,
16,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
16,
0,
27,
0,
0,
0,
0,
0,
0,
0,
558,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
553,
0,
0,
0,
0,
0,
0,
27,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
554,
0,
1086,
27,
0,
0,
0,
0,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
850,
0,
0,
0,
0,
0,
0,
560,
0,
16,
0,
0,
0,
0,
0,
0,
852,
853,
0,
52,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
850,
1084,
68,
0,
571,
0,
0,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
558,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
0,
0,
0,
0,
0,
68,
0,
27,
0,
0,
0,
16,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
16,
0,
0,
0,
0,
0,
0,
0,
0,
607,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
27,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
616,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1095,
633,
0,
0,
0,
0,
27,
0,
0,
0,
852,
853,
222,
0,
854,
0,
385,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
1112,
636,
1114,
1115,
1116,
1117,
1118,
1119,
1120,
1121,
1122,
1123,
1124,
1125,
1126,
1127,
1128,
1129,
1130,
1131,
1132,
1133,
1134,
1135,
1136,
1137,
1138,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
852,
853,
0,
0,
854,
0,
0,
45,
44,
43,
864,
863,
28,
36,
33,
860,
20,
22,
858,
23,
861,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1139,
1140,
1141,
1142,
1143,
1144,
1145,
0,
0,
0,
0,
0,
0,
222,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
638,
0,
0,
643,
1113,
636,
1114,
1115,
1116,
1117,
1118,
1119,
1120,
1121,
1122,
1123,
1124,
1125,
1126,
1127,
1128,
1129,
1130,
1131,
1132,
1133,
1134,
1135,
1136,
1137,
1138,
661,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
222,
0,
0,
0,
385,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1112,
636,
1114,
1115,
1116,
1117,
1118,
1119,
1120,
1121,
1122,
1123,
1124,
1125,
1126,
1127,
1128,
1129,
1130,
1131,
1132,
1133,
1134,
1135,
1136,
1137,
1138,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1139,
1140,
1141,
1142,
1143,
1144,
1145,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
638,
0,
0,
643,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1139,
1140,
1141,
1142,
1143,
1144,
1145,
0,
0,
1159,
0,
0,
0,
0,
0,
0,
664,
1160,
1161,
1162,
1163,
1164,
665,
666,
0,
0,
0,
261,
638,
624,
632,
643,
0,
670,
671,
0,
0,
385,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1112,
636,
1114,
1115,
1116,
1117,
1118,
1119,
1120,
1121,
1122,
1123,
1124,
1125,
1126,
1127,
1128,
1129,
1130,
1131,
1132,
1133,
1134,
1135,
1136,
1137,
1138,
667,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
222,
0,
0,
0,
385,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1112,
636,
1114,
1115,
1116,
1117,
1118,
1119,
1120,
1121,
1122,
1123,
1124,
1125,
1126,
1127,
1128,
1129,
1130,
1131,
1132,
1133,
1134,
1135,
1136,
1137,
1138,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1139,
1140,
1141,
1142,
1143,
1144,
1145,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
638,
0,
0,
643,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1139,
1140,
1141,
1142,
1143,
1144,
1145,
672,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
222,
0,
0,
0,
385,
0,
0,
0,
0,
0,
638,
0,
0,
643,
0,
0,
0,
0,
0,
1112,
636,
1114,
1115,
1116,
1117,
1118,
1119,
1120,
1121,
1122,
1123,
1124,
1125,
1126,
1127,
1128,
1129,
1130,
1131,
1132,
1133,
1134,
1135,
1136,
1137,
1138,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1139,
1140,
1141,
1142,
1143,
1144,
1145,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
638,
0,
0,
643,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
};
static    yyTCombType *    yyTBasePtr    [yyLastReadState + 1] = {
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [88],
& yyTComb [1],
& yyTComb [53],
& yyTComb [2],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [3],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [200],
& yyTComb [0],
& yyTComb [260],
& yyTComb [0],
& yyTComb [291],
& yyTComb [0],
& yyTComb [334],
& yyTComb [0],
& yyTComb [0],
& yyTComb [1],
& yyTComb [0],
& yyTComb [4],
& yyTComb [347],
& yyTComb [0],
& yyTComb [381],
& yyTComb [0],
& yyTComb [412],
& yyTComb [443],
& yyTComb [0],
& yyTComb [474],
& yyTComb [505],
& yyTComb [17],
& yyTComb [0],
& yyTComb [536],
& yyTComb [0],
& yyTComb [541],
& yyTComb [0],
& yyTComb [570],
& yyTComb [598],
& yyTComb [606],
& yyTComb [12],
& yyTComb [0],
& yyTComb [65],
& yyTComb [93],
& yyTComb [154],
& yyTComb [8],
& yyTComb [22],
& yyTComb [5],
& yyTComb [227],
& yyTComb [229],
& yyTComb [0],
& yyTComb [155],
& yyTComb [5],
& yyTComb [641],
& yyTComb [56],
& yyTComb [0],
& yyTComb [672],
& yyTComb [707],
& yyTComb [12],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [13],
& yyTComb [0],
& yyTComb [85],
& yyTComb [0],
& yyTComb [33],
& yyTComb [2],
& yyTComb [738],
& yyTComb [29],
& yyTComb [51],
& yyTComb [0],
& yyTComb [52],
& yyTComb [0],
& yyTComb [1],
& yyTComb [0],
& yyTComb [60],
& yyTComb [62],
& yyTComb [63],
& yyTComb [66],
& yyTComb [0],
& yyTComb [101],
& yyTComb [0],
& yyTComb [0],
& yyTComb [117],
& yyTComb [1],
& yyTComb [75],
& yyTComb [90],
& yyTComb [590],
& yyTComb [185],
& yyTComb [102],
& yyTComb [188],
& yyTComb [133],
& yyTComb [90],
& yyTComb [192],
& yyTComb [782],
& yyTComb [207],
& yyTComb [0],
& yyTComb [0],
& yyTComb [104],
& yyTComb [0],
& yyTComb [789],
& yyTComb [2],
& yyTComb [886],
& yyTComb [3],
& yyTComb [993],
& yyTComb [6],
& yyTComb [1090],
& yyTComb [7],
& yyTComb [1197],
& yyTComb [0],
& yyTComb [2],
& yyTComb [0],
& yyTComb [117],
& yyTComb [121],
& yyTComb [1294],
& yyTComb [122],
& yyTComb [144],
& yyTComb [4],
& yyTComb [0],
& yyTComb [0],
& yyTComb [152],
& yyTComb [169],
& yyTComb [165],
& yyTComb [184],
& yyTComb [195],
& yyTComb [0],
& yyTComb [198],
& yyTComb [213],
& yyTComb [0],
& yyTComb [327],
& yyTComb [228],
& yyTComb [224],
& yyTComb [231],
& yyTComb [241],
& yyTComb [0],
& yyTComb [452],
& yyTComb [241],
& yyTComb [0],
& yyTComb [244],
& yyTComb [0],
& yyTComb [233],
& yyTComb [0],
& yyTComb [250],
& yyTComb [0],
& yyTComb [252],
& yyTComb [247],
& yyTComb [264],
& yyTComb [0],
& yyTComb [250],
& yyTComb [0],
& yyTComb [328],
& yyTComb [262],
& yyTComb [257],
& yyTComb [277],
& yyTComb [258],
& yyTComb [272],
& yyTComb [299],
& yyTComb [269],
& yyTComb [331],
& yyTComb [284],
& yyTComb [283],
& yyTComb [299],
& yyTComb [312],
& yyTComb [0],
& yyTComb [0],
& yyTComb [311],
& yyTComb [0],
& yyTComb [681],
& yyTComb [311],
& yyTComb [315],
& yyTComb [0],
& yyTComb [332],
& yyTComb [0],
& yyTComb [316],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [334],
& yyTComb [0],
& yyTComb [0],
& yyTComb [323],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [342],
& yyTComb [332],
& yyTComb [341],
& yyTComb [337],
& yyTComb [0],
& yyTComb [0],
& yyTComb [344],
& yyTComb [346],
& yyTComb [351],
& yyTComb [347],
& yyTComb [111],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [356],
& yyTComb [0],
& yyTComb [359],
& yyTComb [362],
& yyTComb [0],
& yyTComb [369],
& yyTComb [0],
& yyTComb [836],
& yyTComb [192],
& yyTComb [369],
& yyTComb [0],
& yyTComb [142],
& yyTComb [0],
& yyTComb [1218],
& yyTComb [729],
& yyTComb [385],
& yyTComb [0],
& yyTComb [385],
& yyTComb [387],
& yyTComb [318],
& yyTComb [389],
& yyTComb [393],
& yyTComb [0],
& yyTComb [393],
& yyTComb [413],
& yyTComb [0],
& yyTComb [443],
& yyTComb [389],
& yyTComb [396],
& yyTComb [562],
& yyTComb [459],
& yyTComb [405],
& yyTComb [423],
& yyTComb [479],
& yyTComb [0],
& yyTComb [441],
& yyTComb [472],
& yyTComb [0],
& yyTComb [411],
& yyTComb [186],
& yyTComb [334],
& yyTComb [213],
& yyTComb [338],
& yyTComb [396],
& yyTComb [458],
& yyTComb [1416],
& yyTComb [470],
& yyTComb [473],
& yyTComb [480],
& yyTComb [477],
& yyTComb [237],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [503],
& yyTComb [371],
& yyTComb [490],
& yyTComb [0],
& yyTComb [506],
& yyTComb [0],
& yyTComb [509],
& yyTComb [389],
& yyTComb [519],
& yyTComb [526],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [533],
& yyTComb [546],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [548],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [549],
& yyTComb [550],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [552],
& yyTComb [553],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [565],
& yyTComb [0],
& yyTComb [1325],
& yyTComb [0],
& yyTComb [567],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [533],
& yyTComb [0],
& yyTComb [0],
& yyTComb [534],
& yyTComb [0],
& yyTComb [535],
& yyTComb [0],
& yyTComb [580],
& yyTComb [0],
& yyTComb [545],
& yyTComb [443],
& yyTComb [590],
& yyTComb [594],
& yyTComb [676],
& yyTComb [595],
& yyTComb [0],
& yyTComb [598],
& yyTComb [0],
& yyTComb [603],
& yyTComb [471],
& yyTComb [0],
& yyTComb [607],
& yyTComb [800],
& yyTComb [0],
& yyTComb [625],
& yyTComb [626],
& yyTComb [624],
& yyTComb [629],
& yyTComb [0],
& yyTComb [0],
& yyTComb [631],
& yyTComb [0],
& yyTComb [635],
& yyTComb [501],
& yyTComb [0],
& yyTComb [0],
& yyTComb [805],
& yyTComb [0],
& yyTComb [679],
& yyTComb [0],
& yyTComb [640],
& yyTComb [798],
& yyTComb [0],
& yyTComb [646],
& yyTComb [649],
& yyTComb [680],
& yyTComb [0],
& yyTComb [653],
& yyTComb [0],
& yyTComb [655],
& yyTComb [0],
& yyTComb [0],
& yyTComb [692],
& yyTComb [694],
& yyTComb [649],
& yyTComb [663],
& yyTComb [0],
& yyTComb [788],
& yyTComb [689],
& yyTComb [709],
& yyTComb [0],
& yyTComb [807],
& yyTComb [710],
& yyTComb [0],
& yyTComb [431],
& yyTComb [0],
& yyTComb [0],
& yyTComb [677],
& yyTComb [711],
& yyTComb [715],
& yyTComb [717],
& yyTComb [0],
& yyTComb [0],
& yyTComb [730],
& yyTComb [741],
& yyTComb [734],
& yyTComb [825],
& yyTComb [745],
& yyTComb [0],
& yyTComb [699],
& yyTComb [762],
& yyTComb [512],
& yyTComb [640],
& yyTComb [1462],
& yyTComb [1598],
& yyTComb [719],
& yyTComb [766],
& yyTComb [0],
& yyTComb [766],
& yyTComb [544],
& yyTComb [0],
& yyTComb [725],
& yyTComb [559],
& yyTComb [794],
& yyTComb [578],
& yyTComb [0],
& yyTComb [761],
& yyTComb [0],
& yyTComb [828],
& yyTComb [0],
& yyTComb [592],
& yyTComb [0],
& yyTComb [773],
& yyTComb [836],
& yyTComb [0],
& yyTComb [837],
& yyTComb [1145],
& yyTComb [603],
& yyTComb [0],
& yyTComb [0],
& yyTComb [604],
& yyTComb [1704],
& yyTComb [850],
& yyTComb [0],
& yyTComb [850],
& yyTComb [793],
& yyTComb [611],
& yyTComb [815],
& yyTComb [817],
& yyTComb [795],
& yyTComb [0],
& yyTComb [807],
& yyTComb [0],
& yyTComb [891],
& yyTComb [881],
& yyTComb [881],
& yyTComb [0],
& yyTComb [895],
& yyTComb [0],
& yyTComb [896],
& yyTComb [929],
& yyTComb [892],
& yyTComb [941],
& yyTComb [892],
& yyTComb [656],
& yyTComb [657],
& yyTComb [659],
& yyTComb [660],
& yyTComb [932],
& yyTComb [0],
& yyTComb [942],
& yyTComb [0],
& yyTComb [917],
& yyTComb [1111],
& yyTComb [0],
& yyTComb [680],
& yyTComb [954],
& yyTComb [933],
& yyTComb [0],
& yyTComb [943],
& yyTComb [945],
& yyTComb [959],
& yyTComb [1716],
& yyTComb [942],
& yyTComb [947],
& yyTComb [981],
& yyTComb [0],
& yyTComb [1025],
& yyTComb [991],
& yyTComb [0],
& yyTComb [967],
& yyTComb [0],
& yyTComb [968],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [990],
& yyTComb [965],
& yyTComb [748],
& yyTComb [1000],
& yyTComb [1001],
& yyTComb [0],
& yyTComb [1002],
& yyTComb [0],
& yyTComb [994],
& yyTComb [753],
& yyTComb [1048],
& yyTComb [1003],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [999],
& yyTComb [0],
& yyTComb [1004],
& yyTComb [1042],
& yyTComb [1040],
& yyTComb [1014],
& yyTComb [999],
& yyTComb [0],
& yyTComb [1006],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [1063],
& yyTComb [0],
& yyTComb [786],
& yyTComb [0],
& yyTComb [1044],
& yyTComb [1021],
& yyTComb [0],
& yyTComb [1031],
& yyTComb [1055],
& yyTComb [976],
& yyTComb [809],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [1056],
& yyTComb [0],
& yyTComb [1056],
& yyTComb [1058],
& yyTComb [0],
& yyTComb [1080],
& yyTComb [0],
& yyTComb [1058],
& yyTComb [1061],
& yyTComb [0],
& yyTComb [1081],
& yyTComb [1083],
& yyTComb [0],
& yyTComb [1083],
& yyTComb [1499],
& yyTComb [994],
& yyTComb [996],
& yyTComb [847],
& yyTComb [1840],
& yyTComb [1005],
& yyTComb [1003],
& yyTComb [1097],
& yyTComb [0],
& yyTComb [1098],
& yyTComb [864],
& yyTComb [1014],
& yyTComb [1108],
& yyTComb [1102],
& yyTComb [0],
& yyTComb [1111],
& yyTComb [1115],
& yyTComb [1114],
& yyTComb [1116],
& yyTComb [876],
& yyTComb [1026],
& yyTComb [1069],
& yyTComb [883],
& yyTComb [1977],
& yyTComb [1071],
& yyTComb [1043],
& yyTComb [1092],
& yyTComb [1136],
& yyTComb [0],
& yyTComb [1958],
& yyTComb [1144],
& yyTComb [1081],
& yyTComb [2113],
& yyTComb [1036],
& yyTComb [1151],
& yyTComb [0],
& yyTComb [1149],
& yyTComb [0],
& yyTComb [1151],
& yyTComb [1164],
& yyTComb [1145],
& yyTComb [0],
& yyTComb [1187],
& yyTComb [1153],
& yyTComb [1147],
& yyTComb [0],
& yyTComb [1157],
& yyTComb [1158],
& yyTComb [0],
& yyTComb [1156],
& yyTComb [0],
& yyTComb [1163],
& yyTComb [0],
& yyTComb [1167],
& yyTComb [1213],
& yyTComb [1167],
& yyTComb [1030],
& yyTComb [1166],
& yyTComb [0],
& yyTComb [1192],
& yyTComb [1194],
& yyTComb [1192],
& yyTComb [1045],
& yyTComb [1186],
& yyTComb [1055],
& yyTComb [957],
& yyTComb [1208],
& yyTComb [0],
& yyTComb [1252],
& yyTComb [0],
& yyTComb [1208],
& yyTComb [979],
& yyTComb [1223],
& yyTComb [1073],
& yyTComb [1010],
& yyTComb [1291],
& yyTComb [1207],
& yyTComb [1198],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [1258],
& yyTComb [0],
& yyTComb [1014],
& yyTComb [0],
& yyTComb [1199],
& yyTComb [1208],
& yyTComb [2127],
& yyTComb [2141],
& yyTComb [0],
& yyTComb [1265],
& yyTComb [0],
& yyTComb [1023],
& yyTComb [2277],
& yyTComb [1204],
& yyTComb [1267],
& yyTComb [1255],
& yyTComb [1234],
& yyTComb [1050],
& yyTComb [1288],
& yyTComb [1246],
& yyTComb [0],
& yyTComb [1293],
& yyTComb [1059],
& yyTComb [0],
& yyTComb [1241],
& yyTComb [1245],
& yyTComb [1068],
& yyTComb [0],
& yyTComb [1257],
& yyTComb [1332],
& yyTComb [1070],
& yyTComb [1073],
& yyTComb [0],
& yyTComb [1305],
& yyTComb [0],
& yyTComb [1330],
& yyTComb [1317],
& yyTComb [0],
& yyTComb [1313],
& yyTComb [1454],
& yyTComb [1322],
& yyTComb [1326],
& yyTComb [1345],
& yyTComb [1269],
& yyTComb [1273],
& yyTComb [0],
& yyTComb [1217],
& yyTComb [0],
& yyTComb [1346],
& yyTComb [0],
& yyTComb [1223],
& yyTComb [1235],
& yyTComb [1240],
& yyTComb [1909],
& yyTComb [1102],
& yyTComb [0],
& yyTComb [1228],
& yyTComb [1374],
& yyTComb [1110],
& yyTComb [0],
& yyTComb [1371],
& yyTComb [0],
& yyTComb [1344],
& yyTComb [1375],
& yyTComb [1127],
& yyTComb [1712],
& yyTComb [2436],
& yyTComb [1128],
& yyTComb [1384],
};
static    unsigned short*    yyNBasePtr    [yyLastReadState + 1] = {
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-255],
& yyNComb [-254],
& yyNComb [-255],
& yyNComb [-250],
& yyNComb [-252],
& yyNComb [-252],
& yyNComb [-242],
& yyNComb [-256],
& yyNComb [-226],
& yyNComb [-256],
& yyNComb [-186],
& yyNComb [-165],
& yyNComb [-120],
& yyNComb [-158],
& yyNComb [-256],
& yyNComb [-251],
& yyNComb [-256],
& yyNComb [-99],
& yyNComb [-256],
& yyNComb [-93],
& yyNComb [-72],
& yyNComb [-256],
& yyNComb [-49],
& yyNComb [-256],
& yyNComb [-22],
& yyNComb [-1],
& yyNComb [-256],
& yyNComb [21],
& yyNComb [-256],
& yyNComb [28],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [61],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [137],
& yyNComb [-256],
& yyNComb [203],
& yyNComb [-253],
& yyNComb [237],
& yyNComb [-253],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [289],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [322],
& yyNComb [-256],
& yyNComb [347],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [384],
& yyNComb [408],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [457],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [633],
& yyNComb [-256],
& yyNComb [670],
& yyNComb [-256],
& yyNComb [493],
& yyNComb [-256],
& yyNComb [553],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-221],
& yyNComb [-256],
& yyNComb [-153],
& yyNComb [-256],
& yyNComb [711],
& yyNComb [-256],
& yyNComb [-242],
& yyNComb [-125],
& yyNComb [-256],
& yyNComb [72],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [781],
& yyNComb [-256],
& yyNComb [-253],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-249],
& yyNComb [-250],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-215],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [75],
& yyNComb [-256],
& yyNComb [-132],
& yyNComb [-240],
& yyNComb [-256],
& yyNComb [-235],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-238],
& yyNComb [-256],
& yyNComb [810],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-236],
& yyNComb [-231],
& yyNComb [-230],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-228],
& yyNComb [-248],
& yyNComb [-256],
& yyNComb [-225],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-218],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-174],
& yyNComb [-256],
& yyNComb [-244],
& yyNComb [-255],
& yyNComb [-166],
& yyNComb [-256],
& yyNComb [-164],
& yyNComb [-256],
& yyNComb [-185],
& yyNComb [-256],
& yyNComb [846],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-183],
& yyNComb [-186],
& yyNComb [888],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-251],
& yyNComb [-256],
& yyNComb [929],
& yyNComb [-255],
& yyNComb [959],
& yyNComb [-251],
& yyNComb [-224],
& yyNComb [-254],
& yyNComb [-256],
& yyNComb [-176],
& yyNComb [-256],
& yyNComb [-182],
& yyNComb [-256],
& yyNComb [-167],
& yyNComb [-213],
& yyNComb [-254],
& yyNComb [-150],
& yyNComb [-182],
& yyNComb [-247],
& yyNComb [-159],
& yyNComb [-243],
& yyNComb [-151],
& yyNComb [-241],
& yyNComb [-229],
& yyNComb [-115],
& yyNComb [-256],
& yyNComb [-57],
& yyNComb [-256],
& yyNComb [128],
& yyNComb [-254],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-215],
& yyNComb [-180],
& yyNComb [-192],
& yyNComb [-60],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-55],
& yyNComb [-177],
& yyNComb [-133],
& yyNComb [-94],
& yyNComb [-79],
& yyNComb [-63],
& yyNComb [-62],
& yyNComb [-256],
& yyNComb [-254],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-175],
& yyNComb [-256],
& yyNComb [-143],
& yyNComb [-247],
& yyNComb [-216],
& yyNComb [-256],
& yyNComb [-138],
& yyNComb [-132],
& yyNComb [-69],
& yyNComb [-113],
& yyNComb [-105],
& yyNComb [-256],
& yyNComb [999],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-205],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [1067],
& yyNComb [-256],
& yyNComb [-187],
& yyNComb [-59],
& yyNComb [-180],
& yyNComb [1103],
& yyNComb [-256],
& yyNComb [-175],
& yyNComb [-172],
& yyNComb [1144],
& yyNComb [-256],
& yyNComb [-155],
& yyNComb [1031],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-56],
& yyNComb [-256],
& yyNComb [-77],
& yyNComb [-256],
& yyNComb [-5],
& yyNComb [64],
& yyNComb [-6],
& yyNComb [-256],
& yyNComb [228],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-46],
& yyNComb [314],
& yyNComb [1390],
& yyNComb [-34],
& yyNComb [-113],
& yyNComb [-21],
& yyNComb [-256],
& yyNComb [-13],
& yyNComb [-256],
& yyNComb [-23],
& yyNComb [-256],
& yyNComb [180],
& yyNComb [-256],
& yyNComb [-108],
& yyNComb [-21],
& yyNComb [-21],
& yyNComb [63],
& yyNComb [-50],
& yyNComb [-256],
& yyNComb [106],
& yyNComb [-18],
& yyNComb [64],
& yyNComb [-256],
& yyNComb [135],
& yyNComb [-14],
& yyNComb [19],
& yyNComb [-40],
& yyNComb [-256],
& yyNComb [195],
& yyNComb [-1],
& yyNComb [174],
& yyNComb [-30],
& yyNComb [-256],
& yyNComb [206],
& yyNComb [1],
& yyNComb [248],
& yyNComb [-256],
& yyNComb [249],
& yyNComb [2],
& yyNComb [74],
& yyNComb [-256],
& yyNComb [171],
& yyNComb [-101],
& yyNComb [6],
& yyNComb [-256],
& yyNComb [37],
& yyNComb [217],
& yyNComb [245],
& yyNComb [245],
& yyNComb [-99],
& yyNComb [298],
& yyNComb [316],
& yyNComb [207],
& yyNComb [-256],
& yyNComb [207],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [56],
& yyNComb [-256],
& yyNComb [241],
& yyNComb [266],
& yyNComb [267],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [318],
& yyNComb [22],
& yyNComb [-256],
& yyNComb [1216],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [1322],
& yyNComb [-256],
& yyNComb [273],
& yyNComb [359],
& yyNComb [-256],
& yyNComb [316],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [367],
& yyNComb [368],
& yyNComb [242],
& yyNComb [147],
& yyNComb [-256],
& yyNComb [1248],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [1466],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [148],
& yyNComb [-256],
& yyNComb [201],
& yyNComb [-256],
& yyNComb [-161],
& yyNComb [38],
& yyNComb [-121],
& yyNComb [356],
& yyNComb [39],
& yyNComb [-256],
& yyNComb [369],
& yyNComb [295],
& yyNComb [41],
& yyNComb [-256],
& yyNComb [407],
& yyNComb [398],
& yyNComb [-256],
& yyNComb [426],
& yyNComb [80],
& yyNComb [395],
& yyNComb [84],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [435],
& yyNComb [103],
& yyNComb [389],
& yyNComb [132],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [399],
& yyNComb [383],
& yyNComb [-256],
& yyNComb [444],
& yyNComb [126],
& yyNComb [-256],
& yyNComb [239],
& yyNComb [445],
& yyNComb [-256],
& yyNComb [1457],
& yyNComb [46],
& yyNComb [-256],
& yyNComb [1542],
& yyNComb [-256],
& yyNComb [371],
& yyNComb [450],
& yyNComb [-256],
& yyNComb [386],
& yyNComb [504],
& yyNComb [432],
& yyNComb [557],
& yyNComb [-256],
& yyNComb [425],
& yyNComb [-256],
& yyNComb [1569],
& yyNComb [392],
& yyNComb [608],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [1610],
& yyNComb [-256],
& yyNComb [1564],
& yyNComb [393],
& yyNComb [611],
& yyNComb [142],
& yyNComb [402],
& yyNComb [645],
& yyNComb [-256],
& yyNComb [1634],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [410],
& yyNComb [652],
& yyNComb [170],
& yyNComb [-256],
& yyNComb [216],
& yyNComb [-256],
& yyNComb [434],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [1717],
& yyNComb [220],
& yyNComb [-256],
& yyNComb [1773],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [1857],
& yyNComb [1881],
& yyNComb [-256],
& yyNComb [1921],
& yyNComb [-256],
& yyNComb [438],
& yyNComb [240],
& yyNComb [-256],
& yyNComb [243],
& yyNComb [-256],
& yyNComb [438],
& yyNComb [1945],
& yyNComb [-256],
& yyNComb [462],
& yyNComb [-256],
& yyNComb [273],
& yyNComb [-256],
& yyNComb [579],
& yyNComb [2020],
& yyNComb [-256],
& yyNComb [2061],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [201],
& yyNComb [636],
& yyNComb [-256],
& yyNComb [580],
& yyNComb [-256],
& yyNComb [230],
& yyNComb [-256],
& yyNComb [234],
& yyNComb [214],
& yyNComb [221],
& yyNComb [226],
& yyNComb [-256],
& yyNComb [2085],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [2168],
& yyNComb [-256],
& yyNComb [2231],
& yyNComb [235],
& yyNComb [2308],
& yyNComb [586],
& yyNComb [-256],
& yyNComb [2372],
& yyNComb [236],
& yyNComb [2419],
& yyNComb [-256],
& yyNComb [2348],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [2483],
& yyNComb [-256],
& yyNComb [237],
& yyNComb [261],
& yyNComb [2530],
& yyNComb [2579],
& yyNComb [2635],
& yyNComb [-256],
& yyNComb [2668],
& yyNComb [-256],
& yyNComb [2689],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [289],
& yyNComb [-256],
& yyNComb [307],
& yyNComb [276],
& yyNComb [277],
& yyNComb [526],
& yyNComb [516],
& yyNComb [511],
& yyNComb [-256],
& yyNComb [533],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [593],
& yyNComb [-256],
& yyNComb [763],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [783],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [2715],
& yyNComb [-256],
& yyNComb [2817],
& yyNComb [691],
& yyNComb [275],
& yyNComb [538],
& yyNComb [693],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [2787],
& yyNComb [-256],
& yyNComb [543],
& yyNComb [378],
& yyNComb [280],
& yyNComb [2850],
& yyNComb [2936],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [3002],
& yyNComb [-256],
& yyNComb [551],
& yyNComb [694],
& yyNComb [290],
& yyNComb [586],
& yyNComb [695],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [383],
& yyNComb [-256],
& yyNComb [3035],
& yyNComb [-256],
& yyNComb [442],
& yyNComb [934],
& yyNComb [698],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [3073],
& yyNComb [382],
& yyNComb [3105],
& yyNComb [-256],
& yyNComb [422],
& yyNComb [-256],
& yyNComb [779],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [3140],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [786],
& yyNComb [-256],
& yyNComb [924],
& yyNComb [-256],
& yyNComb [705],
& yyNComb [-256],
& yyNComb [706],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [695],
& yyNComb [647],
& yyNComb [-256],
& yyNComb [521],
& yyNComb [-256],
& yyNComb [464],
& yyNComb [449],
& yyNComb [-256],
& yyNComb [704],
& yyNComb [-256],
& yyNComb [761],
& yyNComb [-256],
& yyNComb [881],
& yyNComb [-256],
& yyNComb [709],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [713],
& yyNComb [-256],
& yyNComb [494],
& yyNComb [-256],
& yyNComb [464],
& yyNComb [715],
& yyNComb [728],
& yyNComb [-256],
& yyNComb [3322],
& yyNComb [719],
& yyNComb [761],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [475],
& yyNComb [743],
& yyNComb [748],
& yyNComb [-256],
& yyNComb [3359],
& yyNComb [748],
& yyNComb [777],
& yyNComb [-256],
& yyNComb [-256],
& yyNComb [3249],
& yyNComb [722],
& yyNComb [752],
& yyNComb [1544],
& yyNComb [-256],
& yyNComb [754],
& yyNComb [742],
& yyNComb [757],
& yyNComb [757],
& yyNComb [769],
& yyNComb [765],
& yyNComb [789],
& yyNComb [3495],
& yyNComb [770],
& yyNComb [-256],
& yyNComb [791],
& yyNComb [792],
& yyNComb [3649],
& yyNComb [-256],
& yyNComb [813],
& yyNComb [723],
& yyNComb [-256],
& yyNComb [851],
& yyNComb [-256],
& yyNComb [604],
& yyNComb [-186],
& yyNComb [266],
& yyNComb [242],
& yyNComb [1608],
& yyNComb [-256],
& yyNComb [660],
& yyNComb [-256],
& yyNComb [867],
& yyNComb [-256],
& yyNComb [870],
& yyNComb [-256],
& yyNComb [667],
& yyNComb [1929],
& yyNComb [800],
& yyNComb [806],
& yyNComb [3706],
& yyNComb [795],
& yyNComb [-256],
& yyNComb [812],
& yyNComb [3880],
& yyNComb [819],
& yyNComb [3937],
& yyNComb [812],
& yyNComb [-256],
& yyNComb [843],
& yyNComb [1000],
& yyNComb [4096],
& yyNComb [845],
& yyNComb [-256],
};
static    unsigned short    yyDefault    [yyLastReadState + 1] = {
0,
0,
5,
671,
658,
665,
0,
84,
84,
566,
51,
62,
620,
31,
51,
31,
566,
658,
59,
31,
0,
31,
658,
0,
620,
554,
620,
31,
35,
27,
36,
22,
59,
59,
27,
0,
0,
45,
620,
44,
620,
43,
620,
0,
0,
0,
430,
620,
554,
54,
0,
620,
0,
57,
554,
0,
57,
620,
0,
0,
554,
620,
87,
0,
90,
620,
0,
620,
90,
620,
554,
620,
554,
0,
93,
0,
0,
84,
0,
84,
0,
620,
0,
612,
658,
0,
101,
92,
98,
620,
0,
95,
0,
0,
95,
0,
92,
0,
94,
0,
0,
658,
0,
84,
658,
0,
658,
0,
0,
0,
0,
0,
0,
0,
0,
0,
658,
0,
240,
0,
554,
0,
0,
0,
373,
129,
658,
0,
0,
658,
142,
0,
658,
0,
0,
140,
0,
0,
0,
0,
658,
143,
0,
0,
658,
0,
658,
0,
658,
0,
620,
554,
0,
0,
658,
297,
236,
0,
0,
0,
0,
0,
0,
0,
0,
0,
620,
169,
620,
157,
658,
645,
0,
658,
0,
658,
0,
658,
645,
186,
658,
658,
186,
658,
186,
658,
0,
196,
658,
566,
658,
193,
658,
566,
0,
0,
0,
658,
626,
202,
0,
0,
658,
0,
623,
623,
623,
623,
623,
0,
228,
0,
0,
658,
0,
658,
131,
0,
0,
658,
0,
251,
233,
217,
0,
236,
0,
0,
0,
0,
0,
236,
0,
0,
658,
640,
166,
0,
0,
0,
620,
0,
0,
620,
90,
0,
658,
0,
0,
0,
658,
142,
658,
0,
0,
0,
0,
0,
0,
0,
657,
671,
658,
0,
658,
0,
270,
271,
658,
0,
658,
0,
0,
658,
297,
658,
645,
0,
658,
297,
658,
0,
658,
297,
658,
645,
0,
658,
297,
658,
645,
0,
658,
297,
658,
0,
658,
0,
658,
0,
658,
308,
658,
0,
658,
310,
658,
310,
0,
658,
0,
658,
0,
316,
0,
0,
0,
0,
658,
658,
578,
0,
0,
581,
658,
0,
329,
0,
0,
51,
0,
578,
581,
0,
578,
0,
0,
581,
581,
658,
584,
0,
620,
554,
0,
620,
554,
0,
0,
584,
0,
584,
0,
586,
658,
0,
658,
645,
0,
658,
658,
645,
0,
658,
658,
0,
658,
373,
372,
658,
0,
0,
658,
297,
378,
658,
0,
0,
658,
658,
0,
658,
0,
0,
0,
547,
0,
658,
611,
0,
620,
554,
0,
617,
0,
0,
544,
612,
617,
0,
658,
0,
620,
0,
617,
0,
0,
620,
554,
658,
0,
420,
421,
0,
0,
0,
620,
554,
0,
0,
414,
0,
0,
504,
0,
658,
0,
0,
436,
504,
553,
620,
554,
554,
0,
0,
620,
620,
500,
620,
500,
658,
504,
0,
504,
0,
612,
620,
500,
0,
0,
504,
0,
479,
620,
461,
620,
554,
554,
469,
479,
0,
479,
0,
504,
0,
504,
469,
469,
0,
0,
620,
90,
0,
620,
0,
620,
0,
620,
658,
0,
620,
492,
489,
455,
620,
554,
554,
0,
620,
0,
492,
0,
489,
489,
489,
0,
620,
500,
620,
0,
0,
504,
0,
0,
0,
505,
658,
629,
630,
0,
658,
0,
0,
658,
566,
658,
0,
0,
658,
0,
0,
620,
554,
555,
528,
0,
0,
0,
0,
0,
0,
620,
554,
0,
0,
0,
620,
620,
554,
554,
620,
554,
0,
547,
0,
0,
0,
0,
0,
535,
0,
620,
0,
0,
658,
0,
0,
0,
51,
0,
620,
0,
0,
0,
658,
0,
0,
0,
620,
554,
0,
658,
0,
658,
0,
658,
0,
658,
0,
0,
658,
658,
0,
0,
0,
0,
0,
0,
0,
0,
658,
566,
658,
0,
0,
0,
0,
0,
0,
0,
0,
611,
612,
658,
0,
620,
0,
617,
0,
0,
0,
0,
658,
0,
620,
0,
0,
0,
0,
27,
0,
0,
142,
0,
658,
0,
0,
658,
626,
0,
0,
671,
0,
0,
0,
0,
671,
0,
658,
0,
0,
658,
0,
0,
0,
0,
0,
623,
0,
656,
0,
658,
0,
658,
0,
0,
623,
0,
0,
671,
0,
0,
0,
3,
1,
671,
0,
0,
0,
222,
142,
0,
0,
};
static    unsigned char    yyLength    [yyLastReduceState - yyFirstReduceState + 1] = {
2,
2,
2,
0,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
1,
0,
1,
0,
1,
1,
2,
1,
1,
1,
1,
1,
2,
4,
4,
2,
1,
0,
6,
2,
1,
0,
4,
5,
2,
1,
0,
4,
2,
1,
0,
6,
0,
4,
0,
2,
2,
2,
2,
2,
3,
3,
2,
0,
2,
3,
1,
3,
1,
1,
4,
0,
3,
1,
2,
1,
1,
1,
3,
1,
3,
1,
1,
1,
3,
1,
3,
1,
6,
2,
5,
3,
4,
3,
1,
1,
1,
3,
2,
0,
5,
1,
1,
3,
2,
4,
1,
3,
1,
3,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
3,
4,
0,
3,
0,
2,
0,
2,
3,
1,
1,
1,
3,
0,
1,
2,
2,
3,
1,
1,
1,
4,
4,
4,
1,
1,
1,
1,
1,
1,
1,
1,
1,
3,
1,
3,
2,
2,
1,
3,
6,
0,
3,
4,
4,
1,
2,
0,
3,
4,
3,
2,
0,
3,
6,
0,
3,
3,
1,
3,
1,
1,
1,
1,
2,
3,
0,
3,
4,
1,
3,
1,
3,
2,
1,
3,
1,
2,
1,
3,
1,
3,
3,
1,
3,
1,
3,
1,
1,
3,
1,
3,
1,
4,
0,
3,
4,
3,
1,
1,
3,
1,
3,
1,
3,
1,
3,
1,
3,
1,
3,
1,
3,
1,
3,
1,
3,
3,
1,
3,
1,
2,
3,
1,
3,
1,
2,
3,
1,
3,
1,
2,
2,
1,
3,
4,
1,
3,
1,
5,
3,
3,
1,
3,
1,
1,
3,
3,
4,
1,
3,
3,
7,
0,
1,
0,
3,
0,
2,
2,
6,
0,
2,
1,
1,
0,
2,
3,
1,
3,
1,
0,
1,
4,
4,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
3,
1,
4,
1,
1,
1,
1,
3,
1,
1,
1,
0,
6,
1,
1,
1,
1,
3,
1,
1,
1,
1,
1,
1,
1,
1,
2,
1,
3,
1,
2,
2,
1,
3,
1,
2,
2,
1,
3,
1,
2,
6,
3,
1,
3,
1,
1,
1,
1,
1,
4,
1,
2,
1,
3,
1,
1,
2,
1,
3,
1,
2,
5,
0,
3,
0,
2,
1,
3,
1,
4,
1,
4,
1,
3,
1,
3,
2,
1,
3,
2,
2,
5,
2,
2,
1,
1,
1,
1,
2,
3,
0,
1,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
3,
0,
4,
1,
3,
6,
3,
3,
4,
1,
2,
1,
1,
2,
1,
1,
4,
4,
4,
6,
3,
5,
1,
1,
1,
1,
3,
2,
4,
5,
1,
3,
3,
1,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
3,
2,
4,
2,
4,
2,
3,
2,
2,
2,
2,
2,
2,
4,
0,
3,
3,
3,
1,
1,
3,
1,
3,
3,
3,
1,
3,
3,
1,
3,
1,
3,
1,
1,
1,
1,
1,
1,
3,
1,
2,
2,
1,
4,
1,
3,
8,
9,
10,
4,
4,
10,
3,
0,
5,
1,
3,
5,
0,
1,
1,
3,
5,
3,
4,
5,
4,
2,
2,
4,
9,
5,
9,
0,
8,
3,
5,
8,
0,
3,
10,
1,
2,
4,
3,
0,
3,
4,
4,
5,
4,
1,
4,
6,
1,
1,
1,
3,
3,
4,
1,
3,
1,
3,
1,
3,
5,
3,
0,
1,
3,
5,
3,
3,
3,
1,
1,
1,
3,
1,
1,
1,
3,
1,
1,
1,
3,
1,
1,
2,
1,
1,
3,
1,
1,
1,
1,
1,
1,
1,
3,
1,
1,
3,
2,
2,
1,
1,
1,
3,
1,
1,
1,
3,
1,
2,
1,
1,
1,
1,
3,
4,
1,
1,
1,
5,
2,
1,
1,
1,
1,
1,
1,
2,
2,
2,
};
static    yySymbolRange    yyLeftHandSide    [yyLastReduceState - yyFirstReduceState + 1] = {
546,
258,
259,
256,
256,
260,
260,
260,
260,
260,
260,
260,
260,
260,
260,
260,
260,
260,
260,
260,
260,
260,
260,
261,
261,
262,
262,
263,
263,
257,
257,
264,
264,
264,
264,
264,
265,
265,
271,
272,
272,
272,
269,
274,
274,
274,
266,
275,
276,
276,
276,
267,
279,
279,
279,
278,
280,
280,
277,
277,
277,
277,
277,
277,
268,
282,
282,
273,
273,
273,
283,
283,
284,
284,
270,
287,
287,
288,
288,
289,
289,
281,
281,
281,
281,
281,
281,
281,
281,
281,
281,
281,
281,
281,
281,
281,
281,
292,
291,
291,
294,
294,
295,
296,
296,
293,
293,
293,
298,
298,
297,
297,
285,
300,
300,
301,
301,
301,
301,
301,
306,
306,
306,
306,
306,
306,
306,
306,
306,
306,
306,
306,
306,
306,
306,
306,
306,
306,
306,
306,
328,
328,
327,
329,
329,
330,
330,
331,
331,
332,
332,
290,
290,
305,
333,
333,
333,
334,
334,
335,
335,
335,
335,
335,
335,
335,
335,
335,
335,
335,
335,
335,
336,
336,
313,
338,
338,
339,
314,
340,
340,
341,
343,
343,
311,
311,
345,
345,
346,
346,
346,
347,
344,
344,
302,
302,
348,
348,
350,
349,
349,
351,
351,
351,
351,
308,
308,
353,
353,
352,
354,
354,
355,
355,
315,
356,
356,
357,
317,
358,
358,
359,
309,
309,
360,
360,
361,
361,
362,
363,
319,
364,
364,
365,
318,
368,
368,
368,
366,
367,
321,
321,
369,
369,
370,
370,
322,
322,
371,
371,
372,
372,
323,
323,
373,
373,
374,
374,
310,
375,
375,
376,
376,
324,
377,
377,
378,
378,
320,
379,
379,
380,
380,
312,
381,
381,
382,
383,
383,
385,
385,
386,
386,
384,
384,
389,
389,
389,
389,
307,
391,
391,
392,
303,
395,
395,
393,
393,
394,
394,
396,
304,
398,
398,
400,
400,
399,
399,
401,
402,
402,
403,
397,
397,
397,
397,
404,
404,
405,
405,
405,
405,
405,
405,
405,
405,
405,
325,
415,
415,
416,
417,
417,
417,
418,
418,
419,
419,
419,
419,
316,
337,
337,
337,
420,
420,
421,
326,
326,
326,
326,
326,
326,
326,
422,
429,
429,
430,
430,
423,
431,
431,
432,
432,
428,
433,
433,
434,
424,
435,
435,
436,
436,
438,
438,
438,
437,
437,
437,
439,
439,
440,
440,
441,
441,
426,
443,
443,
444,
425,
445,
448,
448,
447,
447,
446,
446,
449,
449,
449,
449,
449,
427,
451,
451,
452,
450,
450,
453,
454,
454,
453,
455,
453,
453,
453,
453,
453,
286,
286,
286,
456,
457,
458,
458,
457,
457,
457,
457,
457,
457,
458,
458,
457,
458,
457,
458,
458,
458,
458,
476,
460,
460,
477,
477,
478,
478,
460,
459,
459,
459,
467,
467,
473,
472,
472,
474,
475,
461,
463,
465,
462,
481,
481,
480,
482,
483,
479,
479,
468,
468,
468,
484,
484,
485,
485,
485,
470,
470,
470,
470,
470,
470,
470,
470,
470,
488,
488,
486,
486,
487,
487,
487,
487,
489,
490,
491,
492,
493,
494,
495,
501,
501,
501,
501,
500,
500,
500,
502,
502,
503,
504,
505,
505,
498,
506,
506,
499,
499,
499,
497,
497,
497,
497,
496,
496,
507,
469,
508,
508,
464,
471,
471,
509,
509,
509,
511,
511,
509,
512,
513,
513,
514,
514,
509,
510,
510,
387,
388,
388,
509,
509,
515,
515,
515,
517,
517,
471,
471,
471,
518,
518,
518,
471,
471,
519,
519,
471,
520,
520,
522,
521,
521,
523,
523,
523,
523,
466,
524,
524,
466,
342,
342,
342,
526,
525,
525,
527,
527,
442,
442,
442,
516,
516,
516,
528,
528,
529,
529,
530,
530,
299,
531,
299,
532,
532,
414,
414,
533,
533,
413,
413,
534,
534,
412,
535,
535,
411,
536,
536,
410,
410,
410,
410,
410,
410,
537,
537,
409,
538,
538,
538,
538,
408,
408,
539,
539,
407,
407,
540,
540,
406,
541,
542,
541,
529,
529,
529,
529,
544,
543,
543,
543,
545,
545,
545,
543,
543,
543,
390,
390,
390,
390,
};
static    yySymbolRange    yyContinuation    [yyLastReadState + 1] = {
0,
1,
0,
1,
255,
0,
255,
1,
1,
18,
14,
7,
1,
1,
1,
1,
7,
1,
7,
1,
7,
1,
1,
13,
1,
14,
1,
1,
7,
1,
7,
1,
7,
7,
1,
7,
7,
7,
1,
7,
1,
7,
1,
7,
7,
7,
7,
1,
14,
14,
14,
1,
20,
14,
14,
14,
14,
14,
24,
7,
21,
3,
28,
10,
21,
1,
10,
1,
21,
1,
14,
1,
14,
14,
14,
14,
21,
1,
21,
1,
10,
1,
14,
255,
1,
18,
1,
18,
2,
1,
21,
3,
28,
14,
2,
2,
18,
18,
2,
18,
18,
1,
18,
1,
1,
255,
1,
1,
2,
1,
2,
1,
2,
1,
2,
1,
1,
10,
17,
14,
14,
1,
17,
14,
255,
1,
1,
18,
255,
1,
1,
13,
1,
14,
13,
1,
14,
1,
14,
14,
1,
255,
51,
255,
1,
255,
1,
13,
1,
10,
1,
14,
14,
14,
1,
13,
17,
14,
2,
20,
2,
24,
14,
14,
20,
14,
17,
20,
17,
14,
1,
13,
255,
1,
1,
18,
18,
1,
21,
255,
1,
1,
255,
1,
255,
1,
255,
13,
1,
21,
1,
14,
1,
14,
14,
255,
13,
1,
255,
14,
14,
14,
1,
255,
66,
66,
66,
66,
66,
13,
111,
14,
27,
1,
255,
1,
13,
201,
27,
1,
255,
131,
1,
192,
13,
17,
14,
13,
111,
14,
13,
17,
14,
27,
1,
10,
17,
14,
10,
2,
17,
14,
21,
1,
21,
255,
1,
27,
255,
131,
255,
131,
255,
13,
7,
14,
13,
10,
14,
255,
133,
1,
1,
255,
1,
27,
145,
21,
1,
255,
145,
12,
255,
1,
1,
1,
21,
255,
1,
1,
1,
255,
1,
1,
1,
21,
255,
1,
1,
1,
21,
255,
1,
1,
1,
255,
1,
1,
1,
255,
1,
18,
1,
18,
1,
255,
1,
255,
18,
1,
255,
1,
13,
14,
14,
14,
14,
255,
1,
152,
20,
14,
152,
17,
21,
21,
17,
14,
14,
17,
14,
20,
17,
152,
20,
14,
152,
17,
17,
21,
169,
14,
1,
14,
14,
1,
14,
14,
14,
169,
13,
169,
14,
255,
1,
21,
1,
21,
255,
1,
1,
21,
255,
1,
1,
255,
1,
255,
1,
1,
18,
255,
1,
255,
1,
1,
18,
255,
1,
1,
255,
1,
255,
255,
255,
68,
68,
82,
1,
13,
1,
14,
255,
75,
75,
255,
68,
255,
75,
75,
1,
10,
1,
255,
75,
75,
13,
1,
14,
82,
255,
73,
76,
255,
76,
13,
1,
14,
72,
255,
73,
76,
76,
2,
79,
1,
1,
255,
14,
2,
7,
1,
14,
14,
14,
14,
1,
255,
255,
255,
255,
2,
2,
14,
2,
14,
1,
1,
255,
255,
13,
2,
14,
2,
17,
10,
17,
14,
14,
14,
2,
14,
2,
10,
2,
10,
2,
14,
14,
14,
14,
255,
21,
255,
1,
255,
1,
13,
255,
2,
255,
1,
13,
1,
7,
1,
14,
14,
14,
1,
14,
13,
13,
1,
1,
1,
10,
1,
255,
1,
255,
21,
2,
21,
2,
86,
255,
1,
77,
255,
13,
1,
14,
13,
1,
14,
1,
14,
13,
1,
14,
13,
1,
14,
82,
103,
103,
255,
103,
103,
106,
13,
1,
14,
255,
106,
13,
1,
1,
14,
14,
14,
14,
255,
68,
68,
255,
68,
68,
105,
68,
13,
1,
7,
14,
255,
114,
114,
10,
20,
14,
1,
13,
1,
21,
1,
21,
14,
21,
1,
14,
14,
1,
13,
1,
14,
1,
152,
20,
14,
152,
17,
1,
13,
169,
14,
255,
255,
176,
255,
13,
1,
14,
1,
14,
255,
21,
173,
255,
10,
69,
69,
1,
1,
1,
10,
1,
255,
75,
75,
109,
1,
1,
1,
10,
1,
255,
75,
75,
13,
1,
68,
255,
66,
66,
1,
255,
255,
1,
77,
255,
255,
1,
255,
255,
255,
255,
1,
27,
1,
21,
255,
1,
27,
162,
13,
152,
21,
68,
68,
133,
125,
1,
133,
1,
133,
133,
133,
1,
255,
1,
255,
255,
255,
0,
0,
1,
255,
255,
255,
1,
1,
255,
0,
};
static    unsigned short    yyFinalToProd    [yyLastReadNontermState - yyFirstReadTermState + 1] = {
1173,
1174,
1175,
1176,
1178,
1179,
1180,
1181,
1182,
1183,
1184,
1185,
1186,
1187,
1188,
1189,
1177,
1190,
1821,
1822,
1823,
1824,
1811,
1825,
1826,
1817,
1805,
1806,
1809,
1785,
1770,
1816,
1796,
1791,
1788,
1793,
1790,
1792,
1789,
1801,
1802,
1774,
1775,
1778,
1779,
1782,
1815,
1765,
1766,
1820,
1753,
1754,
1448,
1192,
1444,
1252,
1250,
1256,
1258,
1319,
1260,
1263,
1262,
1253,
1254,
1194,
1413,
1373,
1264,
1381,
1377,
1457,
1278,
1272,
1265,
1279,
1360,
1359,
1349,
1236,
1241,
1237,
1509,
1510,
1511,
1340,
1341,
1465,
1330,
1327,
1332,
1333,
1334,
1335,
1336,
1337,
1338,
1339,
1329,
1331,
1323,
1312,
1318,
1317,
1324,
1484,
1482,
1483,
1370,
1369,
1406,
1504,
1505,
1506,
1500,
1499,
1498,
1542,
1541,
1551,
1546,
1569,
1566,
1568,
1560,
1425,
1419,
1216,
1714,
1701,
1712,
1702,
1608,
1727,
1638,
1639,
1621,
1612,
1690,
1681,
1680,
1689,
1668,
1682,
1625,
1624,
1225,
1626,
1627,
1732,
1743,
1741,
1742,
1744,
1735,
1724,
1632,
1629,
1628,
1747,
1709,
1703,
1706,
1220,
1584,
1583,
1581,
1582,
1242,
1469,
1211,
1207,
1172,
1170,
1234,
1233,
1749,
1752,
1750,
1751,
1812,
1804,
1808,
1810,
1814,
1784,
1803,
1819,
1781,
1783,
1780,
1759,
1756,
1761,
1762,
1768,
1767,
1449,
1450,
1441,
1443,
1828,
1830,
1455,
1827,
1456,
1452,
1454,
1446,
1389,
1386,
1388,
1412,
1409,
1411,
1380,
1379,
1376,
1374,
1385,
1382,
1384,
1459,
1270,
1266,
1267,
1269,
1273,
1275,
1277,
1276,
1345,
1342,
1344,
1585,
1355,
1357,
1358,
1352,
1353,
1351,
1346,
1348,
1240,
1239,
1206,
1231,
1227,
1230,
1229,
1228,
1514,
1508,
1513,
1326,
1328,
1314,
1310,
1309,
1321,
1468,
1463,
1461,
1467,
1485,
1486,
1487,
1488,
1489,
1490,
1491,
1492,
1493,
1494,
1481,
1472,
1473,
1366,
1363,
1372,
1368,
1365,
1362,
1430,
1426,
1428,
1401,
1398,
1400,
1440,
1436,
1438,
1435,
1431,
1433,
1396,
1390,
1393,
1397,
1391,
1395,
1407,
1405,
1404,
1402,
1501,
1503,
1495,
1496,
1543,
1548,
1547,
1578,
1550,
1552,
1540,
1577,
1537,
1538,
1536,
1576,
1564,
1562,
1558,
1557,
1580,
1579,
1531,
1527,
1529,
1526,
1522,
1524,
1556,
1553,
1555,
1424,
1421,
1423,
1418,
1415,
1417,
1535,
1532,
1534,
1214,
1586,
1715,
1730,
1729,
1618,
1644,
1641,
1614,
1610,
1609,
1691,
1688,
1677,
1678,
1679,
1676,
1670,
1671,
1672,
1673,
1661,
1693,
1659,
1655,
1657,
1687,
1684,
1662,
1663,
1667,
1665,
1666,
1664,
1726,
1591,
1592,
1599,
1600,
1602,
1604,
1605,
1606,
1607,
1725,
1645,
1646,
1647,
1648,
1649,
1650,
1651,
1652,
1653,
1696,
1695,
1698,
1636,
1734,
1731,
1738,
1739,
1737,
1723,
1722,
1720,
1721,
1718,
1631,
1745,
1748,
1704,
1711,
1707,
1705,
1700,
1719,
1589,
1590,
1593,
1594,
1595,
1596,
1597,
1598,
1601,
1603,
1699,
1247,
1248,
1215,
1223,
1219,
1280,
1281,
1283,
1284,
1285,
1286,
1287,
1288,
1289,
1290,
1291,
1292,
1293,
1294,
1295,
1296,
1297,
1298,
1299,
1300,
1301,
1302,
1303,
1304,
1305,
1306,
1307,
1515,
1516,
1517,
1518,
1519,
1520,
1521,
1573,
1570,
1572,
1575,
1244,
1246,
1479,
1476,
1478,
1475,
1471,
1210,
1169,
1198,
1199,
1200,
1201,
1202,
1203,
1204,
1205,
1232,
};

static    void    yyErrorRecovery        ARGS((yySymbolRange * yyTerminal, yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr));
static    void    yyComputeContinuation    ARGS((yyStateRange * yyStack, unsigned long yyStackSize, short yyStackPtr, tSet * yyContinueSet));
static    bool    yyIsContinuation    ARGS((yySymbolRange yyTerminal, yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr));
static    void    yyComputeRestartPoints    ARGS((yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr, tSet * yyRestartSet));
static    yyStateRange yyNext        ARGS((yyStateRange yyState, yySymbolRange yySymbol));
static    void    BeginParser        ();

int Parse ()
   {
      register    yyStateRange    yyState        ;
      register    long        yyTerminal    ;
      register    yyStateRange *    yyStateStackPtr ;
      register    tParsAttribute *yyAttrStackPtr    ;
      register    bool        yyIsRepairing    ;
        unsigned long    yyStateStackSize= yyInitStackSize;
        unsigned long    yyAttrStackSize = yyInitStackSize;
        yyStateRange *    yyStateStack    ;
        tParsAttribute* yyAttributeStack;
        tParsAttribute    yySynAttribute    ;    /* synthesized attribute */
      register    yyStateRange *    yyEndOfStack    ;
        int        yyErrorCount    = 0;
   
# line 154 "fortran.lalr"

#include "Tree.h"
#include <stdio.h>

char Word [256];

tTree global_objects, 
      global_groups;     /* used for COMMON, NAMELIST */



      BeginParser ();
      yyState        = yyStartState;
      yyTerminal    = GetToken ();
      MakeArray ((char * *) & yyStateStack, & yyStateStackSize, sizeof (yyStateRange));
      MakeArray ((char * *) & yyAttributeStack, & yyAttrStackSize, sizeof (tParsAttribute));
      yyEndOfStack    = & yyStateStack [yyStateStackSize];
      yyStateStackPtr    = yyStateStack;
      yyAttrStackPtr    = yyAttributeStack;
      yyIsRepairing    = false;

   ParseLoop:
      for (;;) {
     if (yyStateStackPtr >= yyEndOfStack) {
        int yyyStateStackPtr= yyStateStackPtr - yyStateStack;
        int yyyAttrStackPtr    = yyAttrStackPtr - yyAttributeStack;
        ExtendArray ((char * *) & yyStateStack, & yyStateStackSize, sizeof (yyStateRange));
        ExtendArray ((char * *) & yyAttributeStack, & yyAttrStackSize, sizeof (tParsAttribute));
        yyStateStackPtr    = yyStateStack + yyyStateStackPtr;
        yyAttrStackPtr    = yyAttributeStack + yyyAttrStackPtr;
        yyEndOfStack    = & yyStateStack [yyStateStackSize];
     }
     * yyStateStackPtr = yyState;

   TermTrans:
     for (;;) {    /* SPEC State = Next (State, Terminal); terminal transition */
        register short * yyTCombPtr;

        yyTCombPtr = (short *) (yyTBasePtr [yyState] + yyTerminal);
        if (* yyTCombPtr ++ == yyState) { yyState = * yyTCombPtr; break; }
        if ((yyState = yyDefault [yyState]) != yyNoState) goto TermTrans;

                            /* syntax error */
        if (! yyIsRepairing) {            /* report and recover */
           yySymbolRange yyyTerminal = yyTerminal;

           yyErrorCount ++;
           yyErrorRecovery (& yyyTerminal, yyStateStack, yyStateStackSize, yyStateStackPtr - yyStateStack);
           yyTerminal = yyyTerminal;
           yyIsRepairing = true;
        }
        yyState = * yyStateStackPtr;
        for (;;) {
           if (yyNext (yyState, (yySymbolRange) yyTerminal) == yyNoState) { /* repair */
          yySymbolRange        RepairToken    ;
          tScanAttribute    RepairAttribute ;
        
          RepairToken = yyContinuation [yyState];
          yyState = yyNext (yyState, RepairToken);
          if (yyState <= yyLastReadTermState) { /* read or read terminal reduce ? */
             ErrorAttribute ((int) RepairToken, & RepairAttribute);
             ErrorMessageI (yyTokenInserted, yyRepair, Attribute.Position,
            yyToken, (char *) & RepairToken);
             if (yyState >= yyFirstFinalState) {    /* avoid second push */
            yyState = yyFinalToProd [yyState - yyFirstReadTermState];
             }
             yyGetAttribute (yyAttrStackPtr ++, RepairAttribute);
             * ++ yyStateStackPtr = yyState;
          }
          if (yyState >= yyFirstFinalState) goto Final; /* final state ? */
           } else {
          yyState = yyNext (yyState, (yySymbolRange) yyTerminal);
          goto Final;
           }
        }
     }

   Final:
     if (yyState >= yyFirstFinalState) {        /* final state ? */
        if (yyState <= yyLastReadTermState) {    /* read terminal reduce ? */
           yyStateStackPtr ++;
           yyGetAttribute (yyAttrStackPtr ++, Attribute);
           yyTerminal = GetToken ();
           yyIsRepairing = false;
        }

        for (;;) {
           /* register long yyNonterminal;        /* left-hand side */
# define yyNonterminal yyState

switch (yyState) {
case 1168: /* _0000_ : fortran _EndOfFile .*/
  ReleaseArray ((char * *) & yyStateStack, & yyStateStackSize, sizeof (yyStateRange));
  ReleaseArray ((char * *) & yyAttributeStack, & yyAttrStackSize, sizeof (tParsAttribute));
  return yyErrorCount;

case 1169:
case 1158: /* fortran : CR0 program_units .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 258; {
# line 374 "fortran.lalr"
 TreeRoot = mCOMP_UNIT (yyAttrStackPtr [2-1].Tree);
       printf ("Compilation ready\n");               
} break;
case 1170:
case 847: /* CR1 : NewLine CR0 .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 259; {

} break;
case 1171: /* CR0 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 256; {

} break;
case 1172:
case 846: /* CR0 : NewLine CR0 .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 256; {

} break;
case 1173:
case 674: /* PIdent : Ident .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 390 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan;
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1174:
case 675: /* PIdent : IN .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 395 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("IN",2);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1175:
case 676: /* PIdent : OUT .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 399 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("OUT",3);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1176:
case 677: /* PIdent : INOUT .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 403 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("INOUT",5);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1177:
case 690: /* PIdent : ALLOCATABLE1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 407 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("ALLOCATABLE",11);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1178:
case 678: /* PIdent : DIMENSION1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 411 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("DIMENSION",9);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1179:
case 679: /* PIdent : PARAMETER1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 415 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("PARAMETER",9);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1180:
case 680: /* PIdent : INTENT1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 419 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("INTENT",6);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1181:
case 681: /* PIdent : EXTERNAL1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 423 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("EXTERNAL",8);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1182:
case 682: /* PIdent : INTRINSIC1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 427 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("INTRINSIC",9);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1183:
case 683: /* PIdent : OPTIONAL1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 431 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("OPTIONAL",8);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1184:
case 684: /* PIdent : POINTER1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 435 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("POINTER",7);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1185:
case 685: /* PIdent : SAVE1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 439 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("SAVE",4);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1186:
case 686: /* PIdent : TARGET1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 443 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("TARGET",6);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1187:
case 687: /* PIdent : DATA1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 447 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("DATA",4);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1188:
case 688: /* PIdent : PUBLIC1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 451 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("PUBLIC",6);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1189:
case 689: /* PIdent : PRIVATE1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 455 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("PRIVATE",7);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1190:
case 691: /* PIdent : ARRAY1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
# line 459 "fortran.lalr"
 yySynAttribute.Scan = yyAttrStackPtr [1-1].Scan; yySynAttribute.Scan.Ident = MakeIdent ("ARRAY",5);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1191: /* opt_comma : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 261; {

} break;
case 1192:
case 727: /* opt_comma : ',' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 261; {

} break;
case 1193: /* opt_dcolon : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 262; {

} break;
case 1194:
case 739: /* opt_dcolon : '::' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 262; {

} break;
case 1195: /* opt_label : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 263; {
# line 469 "fortran.lalr"
 yySynAttribute.Label = 0; 
       yySynAttribute.Line  = 0;
     
} break;
case 1196: /* opt_label : LABEL .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 263; {
# line 475 "fortran.lalr"
 yySynAttribute.Label = LabelDefine (yyAttrStackPtr [1-1].Scan.IntConst);
       yySynAttribute.Line  = yyAttrStackPtr [1-1].Scan.Position.Line;
     
} break;
case 1197: /* program_units : program_unit .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 257; {
# line 487 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, mDECL_EMPTY()); 
} break;
case 1198:
case 1159: /* program_units : program_unit program_units .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 257; {
# line 491 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [2-1].Tree); 
} break;
case 1199:
case 1160: /* program_unit : main_program .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 264; {
# line 495 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1200:
case 1161: /* program_unit : subroutine_subprogram .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 264; {
# line 499 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1201:
case 1162: /* program_unit : function_subprogram .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 264; {
# line 503 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1202:
case 1163: /* program_unit : block_data .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 264; {
# line 507 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1203:
case 1164: /* program_unit : module .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 264; {
# line 511 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1204:
case 1165: /* main_program : block CR0 .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 265; {
# line 522 "fortran.lalr"
 InitLabels();
       yySynAttribute.Tree = mPROGRAM_DECL (MakeIdent ("_main", 5), 0,
                 mDECL_EMPTY (), yyAttrStackPtr [1-1].Tree); 
} break;
case 1205:
case 1166: /* main_program : program_definition block program_token CR1 .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 265; {
# line 527 "fortran.lalr"
 yyAttrStackPtr [1-1].Tree->PROGRAM_DECL.PROGRAM_BODY = yyAttrStackPtr [2-1].Tree; 
       yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1206:
case 919: /* program_definition : PROGRAM PIdent dummy_arguments CR1 .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 271; {
# line 532 "fortran.lalr"
 InitLabels();
       yySynAttribute.Tree = mPROGRAM_DECL (yyAttrStackPtr [2-1].Scan.Ident, yyAttrStackPtr [2-1].Label, yyAttrStackPtr [3-1].Tree, NoTree); 
} break;
case 1207:
case 845: /* program_token : PROGRAM Ident .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 272; {

} break;
case 1208: /* program_token : PROGRAM .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 272; {

} break;
case 1209: /* program_token : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 272; {

} break;
case 1210:
case 1157: /* module : MODULE PIdent CR1 block module_token CR1 .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 269; {
# line 547 "fortran.lalr"
 yySynAttribute.Tree = mMODULE_DECL (yyAttrStackPtr [2-1].Scan.Ident, yyAttrStackPtr [2-1].Label, yyAttrStackPtr [4-1].Tree); 
} break;
case 1211:
case 844: /* module_token : MODULE Ident .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 274; {

} break;
case 1212: /* module_token : MODULE .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 274; {

} break;
case 1213: /* module_token : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 274; {

} break;
case 1214:
case 1019: /* subroutine_subprogram : subroutine_definition block subroutine_token CR1 .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 266; {
# line 562 "fortran.lalr"
 yyAttrStackPtr [1-1].Tree->PROC_DECL.PROC_BODY = yyAttrStackPtr [2-1].Tree; 
       yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1215:
case 1109: /* subroutine_definition : prefix SUBROUTINE PIdent dummy_arguments CR1 .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 275; {
# line 567 "fortran.lalr"
 InitLabels();
       yySynAttribute.Tree = mPROC_DECL (yyAttrStackPtr [3-1].Scan.Ident, yyAttrStackPtr [3-1].Label, 
                             yyAttrStackPtr [4-1].Tree, NoTree); 
       if (yyAttrStackPtr [1-1].Label & 16)
          yySynAttribute.Tree->PROC_DECL.IsRecursive  = true;
         else
          yySynAttribute.Tree->PROC_DECL.IsRecursive  = false;
       if (yyAttrStackPtr [1-1].Label & 8)
          yySynAttribute.Tree->PROC_DECL.IsPure       = true;
         else
          yySynAttribute.Tree->PROC_DECL.IsPure       = false;
       if (yyAttrStackPtr [1-1].Label & 3)
          yySynAttribute.Tree->PROC_DECL.HPFExtrinsic = true;
         else
          yySynAttribute.Tree->PROC_DECL.HPFExtrinsic = false;
     
} break;
case 1216:
case 801: /* subroutine_token : SUBROUTINE Ident .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 276; {

} break;
case 1217: /* subroutine_token : SUBROUTINE .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 276; {

} break;
case 1218: /* subroutine_token : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 276; {

} break;
case 1219:
case 1111: /* function_subprogram : function_definition block function_token CR1 .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 267; {
# line 597 "fortran.lalr"
 yyAttrStackPtr [1-1].Tree->FUNC_DECL.FUNC_BODY = yyAttrStackPtr [2-1].Tree; 
       yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1220:
case 837: /* function_token : FUNCTION Ident .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 279; {

} break;
case 1221: /* function_token : FUNCTION .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 279; {

} break;
case 1222: /* function_token : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 279; {

} break;
case 1223:
case 1110: /* function_definition : prefix FUNCTION PIdent dummy_arguments function_result CR1 .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 278; {
# line 607 "fortran.lalr"
 InitLabels();
       yySynAttribute.Tree = mFUNC_DECL (yyAttrStackPtr [3-1].Scan.Ident, yyAttrStackPtr [3-1].Label,  /* name, pos */
                             yyAttrStackPtr [4-1].Tree,   /* formals */
                             NoTree,    /* body is set later */
                             yyAttrStackPtr [1-1].Tree,   /* result_type */
                             yyAttrStackPtr [5-1].Label); /* result_id   */ 
       yySynAttribute.Tree->FUNC_DECL.IsRecursive  = (yyAttrStackPtr [1-1].Label & 16);
       yySynAttribute.Tree->FUNC_DECL.IsPure       = (yyAttrStackPtr [1-1].Label & 8 );
       yySynAttribute.Tree->FUNC_DECL.HPFExtrinsic = (yyAttrStackPtr [1-1].Label & 3 );
     
} break;
case 1224: /* function_result : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 280; {
# line 619 "fortran.lalr"
 yySynAttribute.Label = DefaultId (); 
} break;
case 1225:
case 820: /* function_result : RESULT '(' PIdent ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 280; {
# line 622 "fortran.lalr"
 yySynAttribute.Label = yyAttrStackPtr [3-1].Label; 
} break;
case 1226: /* prefix : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 277; {
# line 627 "fortran.lalr"
 yySynAttribute.Tree = mDUMMY_TYPE (); 
       yySynAttribute.Label = 0;      /* is nothing */    
} break;
case 1227:
case 921: /* prefix : type_spec prefix .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 277; {
# line 632 "fortran.lalr"
 yySynAttribute.Tree  = yyAttrStackPtr [1-1].Tree; 
       yySynAttribute.Label = yyAttrStackPtr [2-1].Label;
     
} break;
case 1228:
case 924: /* prefix : RECURSIVE prefix .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 277; {
# line 638 "fortran.lalr"
 yySynAttribute.Tree  = yyAttrStackPtr [2-1].Tree; 
       yySynAttribute.Label = (yyAttrStackPtr [2-1].Label | 16) ;
     
} break;
case 1229:
case 923: /* prefix : PURE prefix .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 277; {
# line 644 "fortran.lalr"
 yySynAttribute.Tree  = yyAttrStackPtr [2-1].Tree;
       yySynAttribute.Label = (yyAttrStackPtr [2-1].Label |  8);
     
} break;
case 1230:
case 922: /* prefix : EXTRINSIC_HPF prefix .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 277; {
# line 650 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree;
       yySynAttribute.Label = (yyAttrStackPtr [2-1].Label |  1);
     
} break;
case 1231:
case 920: /* prefix : EXTRINSIC_LOCAL prefix .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 277; {
# line 656 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree;
       yySynAttribute.Label = (yyAttrStackPtr [2-1].Label |  2);
     
} break;
case 1232:
case 1167: /* block_data : block_data_definition block CR1 .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 268; {
# line 668 "fortran.lalr"
 yyAttrStackPtr [1-1].Tree->BLOCK_DATA_DECL.DATA_BODY = yyAttrStackPtr [2-1].Tree; 
       yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1233:
case 849: /* block_data_definition : BLOCKDATA PIdent CR1 .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 282; {
# line 673 "fortran.lalr"
 InitLabels();
       yySynAttribute.Tree = mBLOCK_DATA_DECL (yyAttrStackPtr [2-1].Scan.Ident, yyAttrStackPtr [2-1].Label, NoTree); 
} break;
case 1234:
case 848: /* block_data_definition : BLOCKDATA CR1 .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 282; {
# line 679 "fortran.lalr"
 InitLabels();
       yySynAttribute.Tree = mBLOCK_DATA_DECL (MakeIdent("_block_data",11), 
                                   NPos(yyAttrStackPtr [1-1]), NoTree); 
} break;
case 1235: /* dummy_arguments : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 273; {
# line 689 "fortran.lalr"
 yySynAttribute.Tree = mDECL_EMPTY (); 
} break;
case 1236:
case 753: /* dummy_arguments : '(' ')' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 273; {
# line 692 "fortran.lalr"
 yySynAttribute.Tree = mDECL_EMPTY (); 
} break;
case 1237:
case 755: /* dummy_arguments : '(' unit_param_list ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 273; {
# line 695 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1238: /* unit_param_list : unit_param .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 283; {
# line 698 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree , mDECL_EMPTY ()); 
} break;
case 1239:
case 918: /* unit_param_list : unit_param ',' unit_param_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 283; {
# line 701 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1240:
case 917: /* unit_param : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 284; {
# line 704 "fortran.lalr"
 yySynAttribute.Tree = mVAR_PARAM_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, mDUMMY_TYPE ()); 
} break;
case 1241:
case 754: /* unit_param : '*' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 284; {
# line 708 "fortran.lalr"
 yySynAttribute.Tree = mRET_PARAM_DECL (DefaultId(), NPos(yyAttrStackPtr [1-1])); 
} break;
case 1242:
case 842: /* block : specification_part execution_part internal_subprogram_part END .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 270; {
# line 722 "fortran.lalr"
 yySynAttribute.Tree = mBODY_NODE (CompleteDecls (yyAttrStackPtr [1-1].Tree),  /* append DECL_EMPTY */
                             yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [3-1].Tree); 
     
} break;
case 1243: /* internal_subprogram_part : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 287; {
# line 728 "fortran.lalr"
 yySynAttribute.Tree = mDECL_EMPTY (); 
} break;
case 1244:
case 1150: /* internal_subprogram_part : CONTAINS CR1 internal_subprograms .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 287; {
# line 732 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1245: /* internal_subprograms : internal_subprogram .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 288; {
# line 736 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, mDECL_EMPTY() ); 
} break;
case 1246:
case 1151: /* internal_subprograms : internal_subprogram internal_subprograms .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 288; {
# line 740 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [2-1].Tree); 
} break;
case 1247:
case 1107: /* internal_subprogram : subroutine_subprogram .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 289; {
# line 744 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1248:
case 1108: /* internal_subprogram : function_subprogram .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 289; {
# line 748 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1249: /* type_spec : REAL .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 281; {
# line 758 "fortran.lalr"
 yySynAttribute.Tree = mREAL_TYPE (4); 
} break;
case 1250:
case 730: /* type_spec : REAL '*' IntConst .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 281; {
# line 762 "fortran.lalr"
 yySynAttribute.Tree = mREAL_TYPE (yyAttrStackPtr [3-1].Scan.IntConst); 
} break;
case 1251: /* type_spec : INTEGER .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 281; {
# line 766 "fortran.lalr"
 yySynAttribute.Tree = mINTEGER_TYPE (4); 
} break;
case 1252:
case 729: /* type_spec : INTEGER '*' IntConst .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 281; {
# line 770 "fortran.lalr"
 yySynAttribute.Tree = mINTEGER_TYPE (yyAttrStackPtr [3-1].Scan.IntConst); 
} break;
case 1253:
case 737: /* type_spec : DOUBLE_PRECISION .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 281; {
# line 774 "fortran.lalr"
 yySynAttribute.Tree = mREAL_TYPE (8); 
} break;
case 1254:
case 738: /* type_spec : DOUBLE_COMPLEX .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 281; {
# line 778 "fortran.lalr"
 yySynAttribute.Tree = mCOMPLEX_TYPE (16); 
} break;
case 1255: /* type_spec : COMPLEX .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 281; {
# line 782 "fortran.lalr"
 yySynAttribute.Tree = mCOMPLEX_TYPE (8); 
} break;
case 1256:
case 731: /* type_spec : COMPLEX '*' IntConst .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 281; {
# line 786 "fortran.lalr"
 yySynAttribute.Tree = mCOMPLEX_TYPE (yyAttrStackPtr [3-1].Scan.IntConst); 
} break;
case 1257: /* type_spec : LOGICAL .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 281; {
# line 790 "fortran.lalr"
 yySynAttribute.Tree = mBOOLEAN_TYPE (4); 
} break;
case 1258:
case 732: /* type_spec : LOGICAL '*' IntConst .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 281; {
# line 794 "fortran.lalr"
 yySynAttribute.Tree = mBOOLEAN_TYPE (yyAttrStackPtr [3-1].Scan.IntConst); 
} break;
case 1259: /* type_spec : CHARACTER .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 281; {
# line 798 "fortran.lalr"
 yySynAttribute.Tree = mSTRING_TYPE (mCONST_EXP (mINT_CONSTANT (1))); 
} break;
case 1260:
case 734: /* type_spec : CHARACTER '(' PIdent '=' type_param_value ')' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 281; {
# line 802 "fortran.lalr"
 yySynAttribute.Tree = mSTRING_TYPE (yyAttrStackPtr [5-1].Tree); 
} break;
case 1261: /* type_spec : CHARACTER '*' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 281; {
# line 806 "fortran.lalr"
 yySynAttribute.Tree = mSTRING_TYPE (mCONST_EXP (mINT_CONSTANT (-1))); 
} break;
case 1262:
case 736: /* type_spec : CHARACTER '*' '(' '*' ')' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 281; {
# line 810 "fortran.lalr"
 yySynAttribute.Tree = mSTRING_TYPE (mCONST_EXP (mINT_CONSTANT (-1))); 
} break;
case 1263:
case 735: /* type_spec : CHARACTER '*' IntConst .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 281; {
# line 814 "fortran.lalr"
 yySynAttribute.Tree = mSTRING_TYPE (mCONST_EXP (mINT_CONSTANT (yyAttrStackPtr [3-1].Scan.IntConst))); 
} break;
case 1264:
case 742: /* type_spec : TYPE '(' PIdent ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 281; {
# line 818 "fortran.lalr"
 yySynAttribute.Tree = mTYPE_OBJ (yyAttrStackPtr [3-1].Scan.Ident);
        yySynAttribute.Tree = mTYPE_ID (yySynAttribute.Tree);   
} break;
case 1265:
case 748: /* DimSpec : '(' DimIndexes ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 292; {
# line 831 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1266:
case 898: /* DimIndexes : Index_Typen .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 291; {
# line 835 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1267:
case 899: /* DimIndexes : Dyn_Specifications .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 291; {
# line 839 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1268: /* Dyn_Specifications : Dyn_Spec .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 294; {
# line 843 "fortran.lalr"
 yySynAttribute.Tree = mTYPE_LIST (yyAttrStackPtr [1-1].Tree, mTYPE_EMPTY()); 
} break;
case 1269:
case 900: /* Dyn_Specifications : Dyn_Spec ',' Dyn_Specifications .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 294; {
# line 847 "fortran.lalr"
 yySynAttribute.Tree = mTYPE_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1270:
case 897: /* Dyn_Spec : ':' Overlap .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 295; {
# line 851 "fortran.lalr"
 yySynAttribute.Tree = mDYNAMIC ();
         yySynAttribute.Tree->DYNAMIC.left_overlap = yyAttrStackPtr [2-1].Label;
         yySynAttribute.Tree->DYNAMIC.right_overlap = yyAttrStackPtr [2-1].Line;
       
} break;
case 1271: /* Overlap : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 296; {
# line 858 "fortran.lalr"
 yySynAttribute.Label = 0;
         yySynAttribute.Line  = 0;
       
} break;
case 1272:
case 747: /* Overlap : '[' IntConst ':' IntConst ']' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 296; {
# line 864 "fortran.lalr"
 yySynAttribute.Label = yyAttrStackPtr [2-1].Scan.IntConst;
         yySynAttribute.Line  = yyAttrStackPtr [4-1].Scan.IntConst;
       
} break;
case 1273:
case 901: /* Index_Typen : LastBegrenzer .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 293; {
# line 870 "fortran.lalr"
 yySynAttribute.Tree = mTYPE_LIST (yyAttrStackPtr [1-1].Tree, mTYPE_EMPTY()); 
} break;
case 1274: /* Index_Typen : Begrenzer .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 293; {
# line 874 "fortran.lalr"
 yySynAttribute.Tree = mTYPE_LIST (yyAttrStackPtr [1-1].Tree, mTYPE_EMPTY()); 
} break;
case 1275:
case 902: /* Index_Typen : Begrenzer ',' Index_Typen .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 293; {
# line 878 "fortran.lalr"
 yySynAttribute.Tree = mTYPE_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1276:
case 904: /* Begrenzer : expression Overlap .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 298; {
# line 882 "fortran.lalr"
 yySynAttribute.Tree = mINDEX_TYPE (mCONST_EXP(mINT_CONSTANT(1)), yyAttrStackPtr [1-1].Tree); 
         yySynAttribute.Tree->INDEX_TYPE.left_overlap = yyAttrStackPtr [2-1].Label;
         yySynAttribute.Tree->INDEX_TYPE.right_overlap = yyAttrStackPtr [2-1].Line;
       
} break;
case 1277:
case 903: /* Begrenzer : expression ':' expression Overlap .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 298; {
# line 889 "fortran.lalr"
 yySynAttribute.Tree = mINDEX_TYPE (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
         yySynAttribute.Tree->INDEX_TYPE.left_overlap = yyAttrStackPtr [4-1].Label;
         yySynAttribute.Tree->INDEX_TYPE.right_overlap = yyAttrStackPtr [4-1].Line;
       
} break;
case 1278:
case 746: /* LastBegrenzer : '*' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 297; {
# line 896 "fortran.lalr"
 yySynAttribute.Tree = mINDEX_TYPE (mCONST_EXP(mINT_CONSTANT(1)), mDUMMY_EXP()); 
} break;
case 1279:
case 749: /* LastBegrenzer : expression ':' '*' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 297; {
# line 900 "fortran.lalr"
 yySynAttribute.Tree = mINDEX_TYPE (yyAttrStackPtr [1-1].Tree, mDUMMY_EXP()); 
} break;
case 1280:
case 1112: /* specification_part : decl_constructs .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 285; {
# line 910 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1281:
case 1113: /* decl_constructs : declaration_construct CR1 decl_constructs .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 300; {
# line 914 "fortran.lalr"
 yySynAttribute.Tree = ConcatDecls (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1282: /* decl_constructs : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 300; {
# line 918 "fortran.lalr"
 yySynAttribute.Tree = NoTree; 
} break;
case 1283:
case 1114: /* declaration_construct : use_stmt .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 301; {
# line 922 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1284:
case 1115: /* declaration_construct : derived_type_def .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 301; {
# line 926 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1285:
case 1116: /* declaration_construct : interface_block .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 301; {
# line 930 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1286:
case 1117: /* declaration_construct : type_declaration_stmt .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 301; {
# line 934 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1287:
case 1118: /* declaration_construct : definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 301; {
# line 938 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1288:
case 1119: /* definition : parameter_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 943 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1289:
case 1120: /* definition : implicit_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 944 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1290:
case 1121: /* definition : access_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 948 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1291:
case 1122: /* definition : allocatable_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 949 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1292:
case 1123: /* definition : common_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 950 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1293:
case 1124: /* definition : data_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 951 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1294:
case 1125: /* definition : dimension_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 952 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1295:
case 1126: /* definition : equivalence_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 953 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1296:
case 1127: /* definition : external_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 954 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1297:
case 1128: /* definition : intent_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 955 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1298:
case 1129: /* definition : intrinsic_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 956 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1299:
case 1130: /* definition : namelist_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 957 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1300:
case 1131: /* definition : optional_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 958 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1301:
case 1132: /* definition : pointer_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 959 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1302:
case 1133: /* definition : save_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 960 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1303:
case 1134: /* definition : sequ_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 961 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1304:
case 1135: /* definition : nsequ_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 962 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1305:
case 1136: /* definition : target_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 963 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1306:
case 1137: /* definition : layout_definition .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 965 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1307:
case 1138: /* definition : hpf_directive .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
# line 966 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1308: /* entity_decl_list : entity_decl .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 328; {
# line 975 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1309:
case 932: /* entity_decl_list : entity_decl ',' entity_decl_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 328; {
# line 979 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1310:
case 931: /* entity_decl : PIdent opt_array_spec opt_char_length opt_init_expr .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 327; {
# line 983 "fortran.lalr"
 yySynAttribute.Tree = mDECL_EMPTY();
      if (yyAttrStackPtr [4-1].Tree != NoTree)
         yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [4-1].Tree, yySynAttribute.Tree);
      if (yyAttrStackPtr [3-1].Tree != NoTree)
         yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [3-1].Tree, yySynAttribute.Tree);
      if (yyAttrStackPtr [2-1].Tree != NoTree)
         yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [2-1].Tree, yySynAttribute.Tree);
      yySynAttribute.Tree = mENTITY_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, yySynAttribute.Tree); 
} break;
case 1311: /* opt_array_spec : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 329; {
# line 994 "fortran.lalr"
 yySynAttribute.Tree = NoTree; 
} break;
case 1312:
case 775: /* opt_array_spec : '(' DimIndexes ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 329; {
# line 998 "fortran.lalr"
 yySynAttribute.Tree = mDIMENSION_DECL (DefaultId(), 0, yyAttrStackPtr [2-1].Tree); 
} break;
case 1313: /* opt_char_length : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 330; {
# line 1002 "fortran.lalr"
 yySynAttribute.Tree = NoTree; 
} break;
case 1314:
case 930: /* opt_char_length : '*' char_length .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 330; {
# line 1006 "fortran.lalr"
 yySynAttribute.Tree = mTYPESPEC_DECL (DefaultId(), 0, mSTRING_TYPE (yyAttrStackPtr [2-1].Tree)); 
} break;
case 1315: /* opt_init_expr : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 331; {
# line 1010 "fortran.lalr"
 yySynAttribute.Tree = NoTree; 
} break;
case 1316: /* opt_init_expr : '=' expression .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 331; {
# line 1014 "fortran.lalr"
 yySynAttribute.Tree = mINIT_DATA_DECL (DefaultId(), 0, yyAttrStackPtr [2-1].Tree); 
} break;
case 1317:
case 777: /* char_length : '(' type_param_value ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 332; {
# line 1022 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1318:
case 776: /* char_length : IntConst .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 332; {
# line 1026 "fortran.lalr"
 yySynAttribute.Tree = mCONST_EXP (mINT_CONSTANT (yyAttrStackPtr [1-1].Scan.IntConst)); 
} break;
case 1319:
case 733: /* type_param_value : '*' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 290; {
# line 1030 "fortran.lalr"
 yySynAttribute.Tree = mCONST_EXP (mINT_CONSTANT (-1)); 
} break;
case 1320: /* type_param_value : expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 290; {
# line 1034 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree;   
} break;
case 1321:
case 933: /* type_declaration_stmt : type_spec optional_attributes entity_decl_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 305; {
# line 1044 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree;
       yyAttrStackPtr [1-1].Tree = mDECL_LIST (mTYPESPEC_DECL (DefaultId(), 0, yyAttrStackPtr [1-1].Tree), yyAttrStackPtr [2-1].Tree);
       /* set all Attributes to Entity Declaration Attributes */
       SetAttributes (yyAttrStackPtr [1-1].Tree, yySynAttribute.Tree); 
} break;
case 1322: /* optional_attributes : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 333; {
# line 1053 "fortran.lalr"
 yySynAttribute.Tree = NoTree;  
} break;
case 1323:
case 774: /* optional_attributes : '::' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 333; {
# line 1057 "fortran.lalr"
 yySynAttribute.Tree = NoTree;  
} break;
case 1324:
case 778: /* optional_attributes : attribute_list '::' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 333; {
# line 1061 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1325: /* attribute_list : ',' attr_spec .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 334; {
# line 1065 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [2-1].Tree, NoTree); 
} break;
case 1326:
case 928: /* attribute_list : ',' attr_spec attribute_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 334; {
# line 1069 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1327:
case 763: /* attr_spec : PARAMETER1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 335; {
# line 1073 "fortran.lalr"
 yySynAttribute.Tree = mPARAMETER_DECL (DefaultId(), 0, mDUMMY_EXP()); 
} break;
case 1328:
case 929: /* attr_spec : access_spec .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 335; {
# line 1077 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1329:
case 772: /* attr_spec : ALLOCATABLE1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 335; {
# line 1081 "fortran.lalr"
 yySynAttribute.Tree = mALLOCATABLE_DECL (DefaultId(), 0); 
} break;
case 1330:
case 762: /* attr_spec : DIMENSION1 '(' DimIndexes ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 335; {
# line 1085 "fortran.lalr"
 yySynAttribute.Tree = mDIMENSION_DECL (DefaultId(), 0, yyAttrStackPtr [3-1].Tree); 
} break;
case 1331:
case 773: /* attr_spec : ARRAY1 '(' DimIndexes ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 335; {
# line 1089 "fortran.lalr"
 yySynAttribute.Tree = mDIMENSION_DECL (DefaultId(), 0, yyAttrStackPtr [3-1].Tree); 
} break;
case 1332:
case 764: /* attr_spec : INTENT1 '(' intent_spec ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 335; {
# line 1093 "fortran.lalr"
 yySynAttribute.Tree = mINTENT_DECL (DefaultId(), 0, yyAttrStackPtr [3-1].Label); 
} break;
case 1333:
case 765: /* attr_spec : EXTERNAL1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 335; {
# line 1097 "fortran.lalr"
 yySynAttribute.Tree = mEXTERNAL_DECL (DefaultId(), 0); 
} break;
case 1334:
case 766: /* attr_spec : INTRINSIC1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 335; {
# line 1101 "fortran.lalr"
 yySynAttribute.Tree = mINTRINSIC_DECL (DefaultId(), 0); 
} break;
case 1335:
case 767: /* attr_spec : OPTIONAL1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 335; {
# line 1105 "fortran.lalr"
 yySynAttribute.Tree = mOPTIONAL_DECL (DefaultId(), 0); 
} break;
case 1336:
case 768: /* attr_spec : POINTER1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 335; {
# line 1109 "fortran.lalr"
 yySynAttribute.Tree = mPOINTER_DECL (DefaultId(), 0); 
} break;
case 1337:
case 769: /* attr_spec : SAVE1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 335; {
# line 1113 "fortran.lalr"
 yySynAttribute.Tree = mSAVE_DECL (DefaultId(), 0); 
} break;
case 1338:
case 770: /* attr_spec : TARGET1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 335; {
# line 1117 "fortran.lalr"
 yySynAttribute.Tree = mTARGET_DECL (DefaultId(), 0); 
} break;
case 1339:
case 771: /* attr_spec : DATA1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 335; {
# line 1121 "fortran.lalr"
 yySynAttribute.Tree = mINIT_DATA_DECL (DefaultId(), 0, mDUMMY_EXP()); 
} break;
case 1340:
case 759: /* access_spec : PUBLIC1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 336; {
# line 1125 "fortran.lalr"
 yySynAttribute.Tree = mPUBLIC_DECL (DefaultId(), 0); 
} break;
case 1341:
case 760: /* access_spec : PRIVATE1 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 336; {
# line 1129 "fortran.lalr"
 yySynAttribute.Tree = mPRIVATE_DECL (DefaultId(), 0); 
} break;
case 1342:
case 906: /* dimension_definition : DIMENSION opt_dcolon ArraySpecList .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 313; {
# line 1139 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1343: /* ArraySpecList : ArraySpec .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 338; {
# line 1143 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1344:
case 907: /* ArraySpecList : ArraySpec ',' ArraySpecList .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 338; {
# line 1147 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1345:
case 905: /* ArraySpec : PIdent DimSpec .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 339; {
# line 1151 "fortran.lalr"
 yySynAttribute.Tree = mDIMENSION_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, yyAttrStackPtr [2-1].Tree); 
} break;
case 1346:
case 915: /* equivalence_definition : EQUIVALENCE eqvblocks .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 314; {
# line 1161 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1347: /* eqvblocks : eqvblock .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 340; {
# line 1165 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1348:
case 916: /* eqvblocks : eqvblock ',' eqvblocks .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 340; {
# line 1169 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1349:
case 752: /* eqvblock : '(' variable ',' variable more_eqvs ')' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 341; {
# line 1173 "fortran.lalr"
 yySynAttribute.Tree = mEQV_DECL (DefaultId(), NPos (yyAttrStackPtr [6-1]), 
                  mBTV_LIST (yyAttrStackPtr [2-1].Tree, mBTV_LIST (yyAttrStackPtr [4-1].Tree, yyAttrStackPtr [5-1].Tree))); 
} break;
case 1350: /* more_eqvs : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 343; {
# line 1178 "fortran.lalr"
 yySynAttribute.Tree = mBTV_EMPTY (); 
} break;
case 1351:
case 914: /* more_eqvs : ',' variable more_eqvs .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 343; {
# line 1182 "fortran.lalr"
 yySynAttribute.Tree = mBTV_LIST (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1352:
case 912: /* common_definition : COMMON blank_common common_object common_cont .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 311; {
# line 1192 "fortran.lalr"
 global_objects = mDECL_LIST (yyAttrStackPtr [3-1].Tree, global_objects);
       yyAttrStackPtr [2-1].Tree->COMMON_DECL.IDS = global_objects;
       yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [2-1].Tree, global_groups);         
     
} break;
case 1353:
case 913: /* common_definition : COMMON named_common common_object common_cont .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 311; {
# line 1198 "fortran.lalr"
 global_objects = mDECL_LIST (yyAttrStackPtr [3-1].Tree, global_objects);
       yyAttrStackPtr [2-1].Tree->COMMON_DECL.IDS = global_objects;
       yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [2-1].Tree, global_groups);         
     
} break;
case 1354: /* common_object : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 345; {
# line 1204 "fortran.lalr"
 yySynAttribute.Tree = mVAR_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, mDUMMY_TYPE()); 
     
} break;
case 1355:
case 909: /* common_object : PIdent DimSpec .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 345; {
# line 1208 "fortran.lalr"
 yySynAttribute.Tree = mVAR_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label,
                   mARRAY_TYPE (yyAttrStackPtr [2-1].Tree, mDUMMY_TYPE()));  
     
} break;
case 1356: /* common_cont : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 346; {
# line 1213 "fortran.lalr"
 global_objects = mDECL_EMPTY   (); 
       global_groups  = mDECL_EMPTY ();
     
} break;
case 1357:
case 910: /* common_cont : ',' common_object common_cont .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 346; {
# line 1218 "fortran.lalr"
 global_objects = mDECL_LIST (yyAttrStackPtr [2-1].Tree, global_objects); 
} break;
case 1358:
case 911: /* common_cont : ',' named_common common_object common_cont .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 346; {
# line 1222 "fortran.lalr"
 global_objects = mDECL_LIST (yyAttrStackPtr [3-1].Tree, global_objects);
       yyAttrStackPtr [2-1].Tree->COMMON_DECL.IDS = global_objects;
       global_groups  = mDECL_LIST (yyAttrStackPtr [2-1].Tree, global_groups); 
       global_objects = mDECL_EMPTY ();                         
} break;
case 1359:
case 751: /* named_common : '/' PIdent '/' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 347; {
# line 1229 "fortran.lalr"
  yySynAttribute.Tree = mCOMMON_DECL (yyAttrStackPtr [2-1].Scan.Ident, yyAttrStackPtr [2-1].Label, mDECL_EMPTY () ); 
} break;
case 1360:
case 750: /* blank_common : '/' '/' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 344; {
# line 1233 "fortran.lalr"
 yySynAttribute.Tree = mCOMMON_DECL (DefaultId(), NPos (yyAttrStackPtr [1-1]), mDECL_EMPTY () ); 
} break;
case 1361: /* blank_common : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 344; {
# line 1237 "fortran.lalr"
 yySynAttribute.Tree = mCOMMON_DECL (DefaultId(), 0, mDECL_EMPTY () );   
} break;
case 1362:
case 956: /* use_stmt : USE PIdent rename_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 302; {
# line 1247 "fortran.lalr"
 yySynAttribute.Tree = mUSE_DECL (DefaultId(), 0, yyAttrStackPtr [2-1].Scan.Ident, yyAttrStackPtr [3-1].Tree);
       yySynAttribute.Tree = mDECL_LIST (yySynAttribute.Tree, NoTree);                       
} break;
case 1363:
case 952: /* use_stmt : USE PIdent ',' ONLY '::' only_list .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 302; {
# line 1251 "fortran.lalr"
 yySynAttribute.Tree = mONLY_USE_DECL (DefaultId(), 0, yyAttrStackPtr [2-1].Scan.Ident, yyAttrStackPtr [6-1].Tree);
       yySynAttribute.Tree = mDECL_LIST (yySynAttribute.Tree, NoTree);                       
} break;
case 1364: /* rename_list : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 348; {
# line 1255 "fortran.lalr"
 yySynAttribute.Tree = mDECL_EMPTY (); 
} break;
case 1365:
case 955: /* rename_list : ',' rename rename_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 348; {
# line 1258 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1366:
case 951: /* rename : PIdent '=>' PIdent .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 350; {
# line 1261 "fortran.lalr"
 yySynAttribute.Tree = mRENAME_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, yyAttrStackPtr [3-1].Scan.Ident); 
} break;
case 1367: /* only_list : only .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 349; {
# line 1264 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, mDECL_EMPTY ()); 
} break;
case 1368:
case 954: /* only_list : only ',' only_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 349; {
# line 1267 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1369:
case 783: /* only : PRIVATE .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 351; {
# line 1270 "fortran.lalr"
 yySynAttribute.Tree = mPRIVATE_DECL (DefaultId(), 0); 
} break;
case 1370:
case 782: /* only : PUBLIC .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 351; {
# line 1273 "fortran.lalr"
 yySynAttribute.Tree = mPRIVATE_DECL (DefaultId(), 0); 
} break;
case 1371: /* only : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 351; {
# line 1276 "fortran.lalr"
 yySynAttribute.Tree = mNAME_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label); 
} break;
case 1372:
case 953: /* only : rename .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 351; {
# line 1279 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1373:
case 741: /* implicit_definition : IMPLICIT Ident .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 308; {
# line 1289 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (mIMPLICIT_DECL (MakeIdent (" ",1), NPos (yyAttrStackPtr [1-1]),
                            MakeIdent ("A",1), MakeIdent ("Z",1),
                            mDUMMY_TYPE ()),
             NoTree ); 
} break;
case 1374:
case 892: /* implicit_definition : IMPLICIT implicit_decl more_implicit_decl .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 308; {
# line 1294 "fortran.lalr"
 yySynAttribute.Tree = ConcatDecls (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1375: /* more_implicit_decl : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 353; {
# line 1296 "fortran.lalr"
 yySynAttribute.Tree = NoTree; 
} break;
case 1376:
case 891: /* more_implicit_decl : ',' implicit_decl more_implicit_decl .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 353; {
# line 1299 "fortran.lalr"
 yySynAttribute.Tree = ConcatDecls (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1377:
case 744: /* implicit_decl : type_spec '(' letter_list ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 352; {
# line 1303 "fortran.lalr"
 SetImplicitType (yyAttrStackPtr [3-1].Tree, yyAttrStackPtr [1-1].Tree); 
      yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree;                    
} break;
case 1378: /* letter_list : letter_spec .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 354; {
# line 1308 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1379:
case 890: /* letter_list : letter_spec ',' letter_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 354; {
# line 1312 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1380:
case 889: /* letter_spec : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 355; {
# line 1316 "fortran.lalr"
 yySynAttribute.Tree = mIMPLICIT_DECL (MakeIdent (" ",1), yyAttrStackPtr [1-1].Label, 
                  yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Scan.Ident, NoTree); 
} break;
case 1381:
case 743: /* letter_spec : Ident '-' Ident .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 355; {
# line 1321 "fortran.lalr"
 yySynAttribute.Tree = mIMPLICIT_DECL (MakeIdent (" ",1), NPos (yyAttrStackPtr [1-1]),
                  yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [3-1].Scan.Ident, NoTree); 
} break;
case 1382:
case 894: /* external_definition : EXTERNAL ExtIdentList .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 315; {
# line 1332 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1383: /* ExtIdentList : ExtIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 356; {
# line 1335 "fortran.lalr"
 yySynAttribute.Tree=mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1384:
case 895: /* ExtIdentList : ExtIdent ',' ExtIdentList .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 356; {
# line 1339 "fortran.lalr"
 yySynAttribute.Tree=mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1385:
case 893: /* ExtIdent : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 357; {
# line 1343 "fortran.lalr"
 yySynAttribute.Tree= mEXTERNAL_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label); 
} break;
case 1386:
case 884: /* intrinsic_definition : INTRINSIC IntIdentList .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 317; {
# line 1347 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1387: /* IntIdentList : Intrinsic_Ident .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 358; {
# line 1351 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1388:
case 885: /* IntIdentList : Intrinsic_Ident ',' IntIdentList .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 358; {
# line 1355 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1389:
case 883: /* Intrinsic_Ident : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 359; {
# line 1359 "fortran.lalr"
 yySynAttribute.Tree = mINTRINSIC_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label); 
} break;
case 1390:
case 970: /* access_definition : PUBLIC opt_dcolon public_id_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 309; {
# line 1369 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1391:
case 973: /* access_definition : PRIVATE opt_dcolon private_id_list1 .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 309; {
# line 1372 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1392: /* public_id_list : public_id .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 360; {
# line 1375 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1393:
case 971: /* public_id_list : public_id ',' public_id_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 360; {
# line 1378 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1394: /* private_id_list1 : private_id .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 361; {
# line 1381 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1395:
case 974: /* private_id_list1 : private_id ',' private_id_list1 .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 361; {
# line 1384 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1396:
case 969: /* public_id : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 362; {
# line 1387 "fortran.lalr"
 yySynAttribute.Tree = mPUBLIC_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label); 
} break;
case 1397:
case 972: /* private_id : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 363; {
# line 1390 "fortran.lalr"
 yySynAttribute.Tree = mPRIVATE_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label); 
} break;
case 1398:
case 961: /* optional_definition : OPTIONAL opt_dcolon optional_id_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 319; {
# line 1399 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1399: /* optional_id_list : optional_ident .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 364; {
# line 1402 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1400:
case 962: /* optional_id_list : optional_ident ',' optional_id_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 364; {
# line 1405 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1401:
case 960: /* optional_ident : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 365; {
# line 1408 "fortran.lalr"
 yySynAttribute.Tree = mOPTIONAL_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label); 
} break;
case 1402:
case 978: /* namelist_definition : NAMELIST namelist_groupid namelist_object namelist_cont .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 318; {
# line 1417 "fortran.lalr"
 global_objects = mDECL_LIST (yyAttrStackPtr [3-1].Tree, global_objects);
       yyAttrStackPtr [2-1].Tree->COMMON_DECL.IDS = global_objects;
       global_groups = mDECL_LIST (yyAttrStackPtr [2-1].Tree, global_groups); 
       yySynAttribute.Tree = global_groups;                               
} break;
case 1403: /* namelist_cont : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 368; {
# line 1423 "fortran.lalr"
 global_objects = mDECL_EMPTY();
       global_groups  = mDECL_EMPTY();  
} break;
case 1404:
case 977: /* namelist_cont : ',' namelist_object namelist_cont .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 368; {
# line 1427 "fortran.lalr"
 global_objects = mDECL_LIST (yyAttrStackPtr [2-1].Tree, global_objects); 
} break;
case 1405:
case 976: /* namelist_cont : opt_comma namelist_groupid namelist_object namelist_cont .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 368; {
# line 1430 "fortran.lalr"
 global_objects = mDECL_LIST (yyAttrStackPtr [3-1].Tree, global_objects);
       yyAttrStackPtr [2-1].Tree->NAMELIST_DECL.IDS = global_objects;
       global_groups   = mDECL_LIST (yyAttrStackPtr [2-1].Tree, global_groups); 
       global_objects  = mDECL_EMPTY ();                         
} break;
case 1406:
case 784: /* namelist_groupid : '/' PIdent '/' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 366; {
# line 1436 "fortran.lalr"
 yySynAttribute.Tree = mNAMELIST_DECL (yyAttrStackPtr [2-1].Scan.Ident, yyAttrStackPtr [2-1].Label, NoTree); 
} break;
case 1407:
case 975: /* namelist_object : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 367; {
# line 1439 "fortran.lalr"
 yySynAttribute.Tree = mVAR_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, mDUMMY_TYPE()); 
} break;
case 1408: /* save_definition : SAVE .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 321; {
# line 1448 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (mSAVE_DECL (DefaultId(), yyAttrStackPtr [1-1].Label), 
                             NoTree); 
} break;
case 1409:
case 887: /* save_definition : SAVE opt_dcolon save_var_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 321; {
# line 1453 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1410: /* save_var_list : save_var .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 369; {
# line 1457 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1411:
case 888: /* save_var_list : save_var ',' save_var_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 369; {
# line 1461 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree);  
} break;
case 1412:
case 886: /* save_var : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 370; {
# line 1465 "fortran.lalr"
 yySynAttribute.Tree = mSAVE_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label); 
} break;
case 1413:
case 740: /* save_var : '/' PIdent '/' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 370; {
# line 1469 "fortran.lalr"
 yySynAttribute.Tree = mSAVE_DECL (yyAttrStackPtr [2-1].Scan.Ident, yyAttrStackPtr [2-1].Label); 
} break;
case 1414: /* sequ_definition : SEQUENCE .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 322; {
# line 1479 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (mSEQUENCE_DECL (DefaultId(), yyAttrStackPtr [1-1].Label), 
                             NoTree); 
} break;
case 1415:
case 1014: /* sequ_definition : SEQUENCE opt_dcolon sequ_var_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 322; {
# line 1484 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1416: /* sequ_var_list : sequ_var .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 371; {
# line 1488 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1417:
case 1015: /* sequ_var_list : sequ_var ',' sequ_var_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 371; {
# line 1492 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree);  
} break;
case 1418:
case 1013: /* sequ_var : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 372; {
# line 1496 "fortran.lalr"
 yySynAttribute.Tree = mSEQUENCE_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label); 
} break;
case 1419:
case 800: /* sequ_var : '/' PIdent '/' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 372; {
# line 1500 "fortran.lalr"
 yySynAttribute.Tree = mSEQUENCE_DECL (yyAttrStackPtr [2-1].Scan.Ident, yyAttrStackPtr [2-1].Label); 
} break;
case 1420: /* nsequ_definition : NOSEQUENCE .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 323; {
# line 1510 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (mNOSEQUENCE_DECL (DefaultId(), yyAttrStackPtr [1-1].Label), 
                             NoTree); 
} break;
case 1421:
case 1011: /* nsequ_definition : NOSEQUENCE opt_dcolon nsequ_var_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 323; {
# line 1515 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1422: /* nsequ_var_list : nsequ_var .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 373; {
# line 1519 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1423:
case 1012: /* nsequ_var_list : nsequ_var ',' nsequ_var_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 373; {
# line 1523 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree);  
} break;
case 1424:
case 1010: /* nsequ_var : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 374; {
# line 1527 "fortran.lalr"
 yySynAttribute.Tree = mNOSEQUENCE_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label); 
} break;
case 1425:
case 799: /* nsequ_var : '/' PIdent '/' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 374; {
# line 1531 "fortran.lalr"
 yySynAttribute.Tree = mNOSEQUENCE_DECL (yyAttrStackPtr [2-1].Scan.Ident, yyAttrStackPtr [2-1].Label); 
} break;
case 1426:
case 958: /* allocatable_definition : ALLOCATABLE opt_dcolon allocatable_var_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 310; {
# line 1541 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1427: /* allocatable_var_list : allocatable_var .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 375; {
# line 1545 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1428:
case 959: /* allocatable_var_list : allocatable_var ',' allocatable_var_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 375; {
# line 1549 "fortran.lalr"
 yySynAttribute.Tree = ConcatDecls (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree);  
} break;
case 1429: /* allocatable_var : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 376; {
# line 1553 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (
                    mALLOCATABLE_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label),
                    NoTree); 
} break;
case 1430:
case 957: /* allocatable_var : PIdent DimSpec .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 376; {
# line 1559 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (
                    mDIMENSION_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, yyAttrStackPtr [2-1].Tree),
                    mDECL_LIST (mALLOCATABLE_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label),
                                NoTree)); 
} break;
case 1431:
case 967: /* target_definition : TARGET opt_dcolon target_var_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 324; {
# line 1572 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1432: /* target_var_list : target_var .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 377; {
# line 1576 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1433:
case 968: /* target_var_list : target_var ',' target_var_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 377; {
# line 1580 "fortran.lalr"
 yySynAttribute.Tree = ConcatDecls (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree);  
} break;
case 1434: /* target_var : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 378; {
# line 1584 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (
                    mTARGET_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label),
                    NoTree); 
} break;
case 1435:
case 966: /* target_var : PIdent DimSpec .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 378; {
# line 1590 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (
                  mDIMENSION_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, yyAttrStackPtr [2-1].Tree),
                   mDECL_LIST( mPOINTER_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label),
                               NoTree)); 
} break;
case 1436:
case 964: /* pointer_definition : POINTER opt_dcolon pointer_var_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 320; {
# line 1603 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1437: /* pointer_var_list : pointer_var .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 379; {
# line 1607 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1438:
case 965: /* pointer_var_list : pointer_var ',' pointer_var_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 379; {
# line 1611 "fortran.lalr"
 yySynAttribute.Tree = ConcatDecls (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree);  
} break;
case 1439: /* pointer_var : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 380; {
# line 1615 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (
                    mPOINTER_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label),
                    NoTree); 
} break;
case 1440:
case 963: /* pointer_var : PIdent DimSpec .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 380; {
# line 1621 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (
                  mDIMENSION_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, yyAttrStackPtr [2-1].Tree),
                   mDECL_LIST( mPOINTER_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label),
                               NoTree)); 
} break;
case 1441:
case 873: /* data_definition : DATA data_defs .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 312; {
# line 1634 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1442: /* data_defs : data_def .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 381; {
# line 1638 "fortran.lalr"
 yySynAttribute.Tree=mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree);  
} break;
case 1443:
case 874: /* data_defs : data_def opt_comma data_defs .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 381; {
# line 1642 "fortran.lalr"
 yySynAttribute.Tree=mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree);  
} break;
case 1444:
case 728: /* data_def : data_liste '/' data_values '/' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 382; {
# line 1646 "fortran.lalr"
 yySynAttribute.Tree = mDATA_DECL (DefaultId(), NPos (yyAttrStackPtr [4-1]), yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1445: /* data_liste : data_elem .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 383; {
# line 1650 "fortran.lalr"
 yySynAttribute.Tree = mBTV_LIST (yyAttrStackPtr [1-1].Tree, mBTV_EMPTY()); 
} break;
case 1446:
case 882: /* data_liste : data_elem ',' data_liste .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 383; {
# line 1654 "fortran.lalr"
 yySynAttribute.Tree = mBTV_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1447: /* data_elem : variable .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 385; {
# line 1658 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1448:
case 726: /* data_elem : '(' data_elem ',' impl_do_var ')' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 385; {
# line 1662 "fortran.lalr"
 yyAttrStackPtr [4-1].Tree->DO_VAR.BODY = 
         mBTV_LIST (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [4-1].Tree->DO_VAR.BODY); 
       yySynAttribute.Tree = yyAttrStackPtr [4-1].Tree; 
} break;
case 1449:
case 871: /* impl_do_var : data_elem ',' impl_do_var .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 386; {
# line 1668 "fortran.lalr"
 yyAttrStackPtr [3-1].Tree->DO_VAR.BODY = 
         mBTV_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree->DO_VAR.BODY); 
       yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1450:
case 872: /* impl_do_var : Laufvariable '=' DoRange .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 386; {
# line 1674 "fortran.lalr"
 yySynAttribute.Tree = mDO_VAR (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree, mBTV_EMPTY()); 
} break;
case 1451: /* data_values : data_value .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 384; {
# line 1678 "fortran.lalr"
 yySynAttribute.Tree = mBTE_LIST (yyAttrStackPtr [1-1].Tree, mBTE_EMPTY()); 
} break;
case 1452:
case 880: /* data_values : data_value ',' data_values .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 384; {
# line 1682 "fortran.lalr"
 yySynAttribute.Tree = mBTE_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1453: /* data_value : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 389; {
# line 1686 "fortran.lalr"
 yySynAttribute.Tree = mVAR_EXP (mUSED_VAR (
                               mVAR_OBJ (yyAttrStackPtr [1-1].Label, yyAttrStackPtr [1-1].Scan.Ident))); 
} break;
case 1454:
case 881: /* data_value : SignedKonstante .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 389; {
# line 1691 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1455:
case 877: /* data_value : IntConst '*' SignedKonstante .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 389; {
# line 1695 "fortran.lalr"
 yySynAttribute.Tree = mOP_EXP (mOP_TIMES(), 
                           mCONST_EXP (mINT_CONSTANT (yyAttrStackPtr [1-1].Scan.IntConst)),
                           yyAttrStackPtr [3-1].Tree); 
} break;
case 1456:
case 879: /* data_value : PIdent '*' SignedKonstante .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 389; {
# line 1700 "fortran.lalr"
 yySynAttribute.Tree = mOP_EXP (mOP_TIMES(), 
                           mVAR_EXP (mUSED_VAR (
                               mVAR_OBJ (yyAttrStackPtr [1-1].Label, yyAttrStackPtr [1-1].Scan.Ident))),
                           yyAttrStackPtr [3-1].Tree); 
} break;
case 1457:
case 745: /* parameter_definition : PARAMETER '(' named_constant_def_list ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 307; {
# line 1712 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1458: /* named_constant_def_list : named_constant_def .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 391; {
# line 1716 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1459:
case 896: /* named_constant_def_list : named_constant_def ',' named_constant_def_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 391; {
# line 1720 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1460: /* named_constant_def : PIdent '=' expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 392; {
# line 1724 "fortran.lalr"
 yySynAttribute.Tree = mPARAMETER_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, yyAttrStackPtr [3-1].Tree); 
} break;
case 1461:
case 936: /* derived_type_def : TYPE opt_access_spec PIdent CR1 derived_type_components ENDTYPE optional_id .*/
  yyStateStackPtr -=7; yyAttrStackPtr -=7; yyNonterminal = 303; {
# line 1738 "fortran.lalr"
 yySynAttribute.Tree = mRECORD_TYPE (yyAttrStackPtr [3-1].Scan.Ident, CompleteDecls (yyAttrStackPtr [5-1].Tree));
        yySynAttribute.Tree = mTYPE_DECL (yyAttrStackPtr [3-1].Scan.Ident, yyAttrStackPtr [3-1].Label, yySynAttribute.Tree);
        yySynAttribute.Tree = mDECL_LIST (yySynAttribute.Tree, NoTree);            
} break;
case 1462: /* optional_id : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 395; {

} break;
case 1463:
case 935: /* optional_id : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 395; {

} break;
case 1464: /* opt_access_spec : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 393; {

} break;
case 1465:
case 761: /* opt_access_spec : ',' access_spec '::' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 393; {

} break;
case 1466: /* derived_type_components : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 394; {
# line 1750 "fortran.lalr"
 yySynAttribute.Tree = NoTree; 
} break;
case 1467:
case 937: /* derived_type_components : component_def_stmt derived_type_components .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 394; {
# line 1754 "fortran.lalr"
 yySynAttribute.Tree = ConcatDecls (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [2-1].Tree); 
} break;
case 1468:
case 934: /* component_def_stmt : type_declaration_stmt CR1 .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 396; {
# line 1758 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1469:
case 843: /* interface_block : INTERFACE generic_spec CR1 interface_body_list module_procedure_stmt_list ENDINTERFACE .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 304; {
# line 1771 "fortran.lalr"
 yySynAttribute.Tree = mINTERFACE_DECL  (DefaultId(), NPos (yyAttrStackPtr [6-1]), yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [4-1].Tree); 
       yySynAttribute.Tree = mDECL_LIST (yySynAttribute.Tree, NoTree);                      
} break;
case 1470: /* interface_body_list : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 398; {
# line 1776 "fortran.lalr"
 yySynAttribute.Tree = mDECL_EMPTY(); 
} break;
case 1471:
case 1156: /* interface_body_list : interface_body interface_body_list .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 398; {
# line 1780 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [2-1].Tree); 
} break;
case 1472:
case 949: /* interface_body : subroutine_subprogram .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 400; {
# line 1784 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1473:
case 950: /* interface_body : function_subprogram .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 400; {
# line 1788 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1474: /* module_procedure_stmt_list : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 399; {
# line 1792 "fortran.lalr"
 yySynAttribute.Tree = mDECL_EMPTY(); 
} break;
case 1475:
case 1155: /* module_procedure_stmt_list : module_procedure_stmt module_procedure_stmt_list .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 399; {
# line 1796 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [2-1].Tree); 
} break;
case 1476:
case 1153: /* module_procedure_stmt : MODULE PROCEDURE procedure_name_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 401; {

} break;
case 1477: /* procedure_name_list : procedure_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 402; {

} break;
case 1478:
case 1154: /* procedure_name_list : procedure_name ',' procedure_name_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 402; {

} break;
case 1479:
case 1152: /* procedure_name : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 403; {

} break;
case 1480: /* generic_spec : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 397; {
# line 1806 "fortran.lalr"
 yySynAttribute.Tree = mNO_GENERIC_SPEC (); 
} break;
case 1481:
case 948: /* generic_spec : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 397; {
# line 1809 "fortran.lalr"
 yySynAttribute.Tree = mID_GENERIC_SPEC (yyAttrStackPtr [1-1].Scan.Ident); 
} break;
case 1482:
case 780: /* generic_spec : OPERATOR '(' defined_operator ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 397; {
# line 1812 "fortran.lalr"
 yySynAttribute.Tree = mOP_GENERIC_SPEC (yyAttrStackPtr [3-1].Tree); 
} break;
case 1483:
case 781: /* generic_spec : ASSIGNMENT '(' '=' ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 397; {
# line 1815 "fortran.lalr"
 yySynAttribute.Tree = mASSIGN_GENERIC_SPEC (); 
} break;
case 1484:
case 779: /* defined_operator : UserOp .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 404; {
# line 1818 "fortran.lalr"
 yySynAttribute.Tree = mOP_DEFINED (yyAttrStackPtr [1-1].Scan.Ident); 
} break;
case 1485:
case 938: /* defined_operator : intrinsic_operator .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 404; {
# line 1821 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1486:
case 939: /* intrinsic_operator : power_op .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 405; {
# line 1823 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1487:
case 940: /* intrinsic_operator : mult_op .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 405; {
# line 1824 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1488:
case 941: /* intrinsic_operator : add_op .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 405; {
# line 1825 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1489:
case 942: /* intrinsic_operator : concat_op .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 405; {
# line 1826 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1490:
case 943: /* intrinsic_operator : rel_op .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 405; {
# line 1827 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1491:
case 944: /* intrinsic_operator : not_op .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 405; {
# line 1828 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1492:
case 945: /* intrinsic_operator : and_op .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 405; {
# line 1829 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1493:
case 946: /* intrinsic_operator : or_op .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 405; {
# line 1830 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1494:
case 947: /* intrinsic_operator : equiv_op .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 405; {
# line 1831 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1495:
case 981: /* layout_definition : LAYOUT layout_list .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 325; {
# line 1840 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1496:
case 982: /* layout_list : layout_item ',' layout_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 415; {
# line 1844 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1497: /* layout_list : layout_item .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 415; {
# line 1848 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1498:
case 790: /* layout_item : PIdent '(' layout_specs ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 416; {
# line 1852 "fortran.lalr"
 yySynAttribute.Tree = mDISTRIBUTE_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, 
                                    yyAttrStackPtr [3-1].Tree, DefaultId()); 
} break;
case 1499:
case 789: /* layout_specs : HOST .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 417; {
# line 1857 "fortran.lalr"
 yySynAttribute.Tree = mHOST_DISTRIBUTION (); 
} break;
case 1500:
case 788: /* layout_specs : REPLICATED .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 417; {
# line 1861 "fortran.lalr"
 yySynAttribute.Tree = mREPL_DISTRIBUTION (); 
} break;
case 1501:
case 979: /* layout_specs : layout_spec_list .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 417; {
# line 1865 "fortran.lalr"
 yySynAttribute.Tree = mNODE_DISTRIBUTION (yyAttrStackPtr [1-1].Tree); 
} break;
case 1502: /* layout_spec_list : layout_spec .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 418; {
# line 1869 "fortran.lalr"
 yySynAttribute.Tree = mDIST_LIST (yyAttrStackPtr [1-1].Tree, mDIST_EMPTY()); 
} break;
case 1503:
case 980: /* layout_spec_list : layout_spec ',' layout_spec_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 418; {
# line 1873 "fortran.lalr"
 yySynAttribute.Tree = mDIST_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1504:
case 785: /* layout_spec : SERIAL .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 419; {
# line 1877 "fortran.lalr"
 yySynAttribute.Tree = mSERIAL_DISTRIBUTION (); 
} break;
case 1505:
case 786: /* layout_spec : NEWS .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 419; {
# line 1881 "fortran.lalr"
 yySynAttribute.Tree = mBLOCK_DISTRIBUTION (mDUMMY_EXP()); 
} break;
case 1506:
case 787: /* layout_spec : SEND .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 419; {
# line 1885 "fortran.lalr"
 yySynAttribute.Tree = mBLOCK_DISTRIBUTION (mDUMMY_EXP()); 
} break;
case 1507: /* layout_spec : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 419; {
# line 1889 "fortran.lalr"
 yySynAttribute.Tree = mBLOCK_DISTRIBUTION (mDUMMY_EXP()); 
} break;
case 1508:
case 926: /* intent_definition : INTENT '(' intent_spec ')' '::' intent_list .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 316; {
# line 1899 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [6-1].Tree; 
        SetIntent (yySynAttribute.Tree, yyAttrStackPtr [3-1].Label); 
} break;
case 1509:
case 756: /* intent_spec : IN .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 337; {
# line 1904 "fortran.lalr"
 yySynAttribute.Label = 0; 
} break;
case 1510:
case 757: /* intent_spec : OUT .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 337; {
# line 1908 "fortran.lalr"
 yySynAttribute.Label = 1; 
} break;
case 1511:
case 758: /* intent_spec : INOUT .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 337; {
# line 1912 "fortran.lalr"
 yySynAttribute.Label = 2; 
} break;
case 1512: /* intent_list : intent_item .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 420; {
# line 1916 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1513:
case 927: /* intent_list : intent_item ',' intent_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 420; {
# line 1920 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1514:
case 925: /* intent_item : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 421; {
# line 1924 "fortran.lalr"
 yySynAttribute.Tree = mINTENT_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, 0); 
} break;
case 1515:
case 1139: /* hpf_directive : template_directive .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 326; {
# line 1934 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1516:
case 1140: /* hpf_directive : processors_directive .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 326; {
# line 1938 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1517:
case 1141: /* hpf_directive : align_directive .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 326; {
# line 1942 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1518:
case 1142: /* hpf_directive : distribute_directive .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 326; {
# line 1946 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1519:
case 1143: /* hpf_directive : dynamic_directive .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 326; {
# line 1950 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1520:
case 1144: /* hpf_directive : combined_directive .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 326; {
# line 1954 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1521:
case 1145: /* hpf_directive : inherit_directive .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 326; {
# line 1958 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1522:
case 1005: /* template_directive : TEMPLATE template_decl_list .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 422; {
# line 1968 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1523: /* template_decl_list : template_decl .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 429; {
# line 1972 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1524:
case 1006: /* template_decl_list : template_decl ',' template_decl_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 429; {
# line 1976 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1525: /* template_decl : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 430; {
# line 1980 "fortran.lalr"
 yySynAttribute.Tree = mTEMPLATE_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, mTYPE_EMPTY()); 
} break;
case 1526:
case 1004: /* template_decl : PIdent DimSpec .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 430; {
# line 1984 "fortran.lalr"
 yySynAttribute.Tree = mTEMPLATE_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, yyAttrStackPtr [2-1].Tree); 
} break;
case 1527:
case 1002: /* processors_directive : PROCESSORS processors_decl_list .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 423; {
# line 1994 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1528: /* processors_decl_list : processors_decl .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 431; {
# line 1998 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1529:
case 1003: /* processors_decl_list : processors_decl ',' processors_decl_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 431; {
# line 2002 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1530: /* processors_decl : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 432; {
# line 2006 "fortran.lalr"
 yySynAttribute.Tree = mPROCESSORS_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, mTYPE_EMPTY()); 
} break;
case 1531:
case 1001: /* processors_decl : PIdent DimSpec .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 432; {
# line 2010 "fortran.lalr"
 yySynAttribute.Tree = mPROCESSORS_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, yyAttrStackPtr [2-1].Tree); 
} break;
case 1532:
case 1017: /* inherit_directive : INHERIT inherit_decl_list .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 428; {
# line 2020 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1533: /* inherit_decl_list : inherit_decl .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 433; {
# line 2024 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1534:
case 1018: /* inherit_decl_list : inherit_decl ',' inherit_decl_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 433; {
# line 2028 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1535:
case 1016: /* inherit_decl : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 434; {
# line 2032 "fortran.lalr"
 yySynAttribute.Tree = mINHERIT_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label); 
} break;
case 1536:
case 993: /* align_directive : ALIGN single_align_stuff .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 424; {
# line 2042 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [2-1].Tree, NoTree); 
} break;
case 1537:
case 991: /* single_align_stuff : PIdent '(' align_source_list ')' WITH align_spec .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 435; {
# line 2046 "fortran.lalr"
 yySynAttribute.Tree = mALIGN_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, yyAttrStackPtr [3-1].Tree, yyAttrStackPtr [6-1].Tree); 
} break;
case 1538:
case 992: /* single_align_stuff : PIdent WITH align_spec .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 435; {
# line 2050 "fortran.lalr"
 yySynAttribute.Tree = mALIGN_DECL (yyAttrStackPtr [1-1].Scan.Ident,yyAttrStackPtr [1-1].Label,mBTE_EMPTY(),yyAttrStackPtr [3-1].Tree); 
} break;
case 1539: /* align_source_list : align_source .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 436; {
# line 2054 "fortran.lalr"
 yySynAttribute.Tree = mBTE_LIST (yyAttrStackPtr [1-1].Tree, mBTE_EMPTY()); 
} break;
case 1540:
case 989: /* align_source_list : align_source ',' align_source_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 436; {
# line 2058 "fortran.lalr"
 yySynAttribute.Tree = mBTE_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1541:
case 792: /* align_source : ':' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 438; {
# line 2062 "fortran.lalr"
 yySynAttribute.Tree = mSLICE_EXP (mDUMMY_EXP(), mDUMMY_EXP(), mDUMMY_EXP()); 
} break;
case 1542:
case 791: /* align_source : '*' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 438; {
# line 2066 "fortran.lalr"
 yySynAttribute.Tree = mDUMMY_EXP (); 
} break;
case 1543:
case 983: /* align_source : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 438; {
# line 2070 "fortran.lalr"
 yySynAttribute.Tree = mVAR_EXP (mUSED_VAR (mVAR_OBJ (yyAttrStackPtr [1-1].Label, yyAttrStackPtr [1-1].Scan.Ident))); 
} break;
case 1544: /* align_spec : '*' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 437; {
# line 2078 "fortran.lalr"
 yySynAttribute.Tree = mDUMMY_VAR (); 
} break;
case 1545: /* align_spec : align_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 437; {
# line 2082 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1546:
case 794: /* align_spec : align_name '(' align_subscript_list ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 437; {
# line 2085 "fortran.lalr"
 yySynAttribute.Tree = mINDEXED_VAR (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1547:
case 985: /* align_name : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 439; {
# line 2089 "fortran.lalr"
 yySynAttribute.Tree = mUSED_VAR (mVAR_OBJ (yyAttrStackPtr [1-1].Label, yyAttrStackPtr [1-1].Scan.Ident)); 
} break;
case 1548:
case 984: /* align_name : '*' PIdent .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 439; {
# line 2092 "fortran.lalr"
 yySynAttribute.Tree = mUSED_VAR (mVAR_OBJ (yyAttrStackPtr [1-1].Label, yyAttrStackPtr [1-1].Scan.Ident)); 
         yySynAttribute.Tree = mINDEXED_VAR (mTYPE_EMPTY(), yySynAttribute.Tree);          
} break;
case 1549: /* align_subscript_list : align_subscript .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 440; {
# line 2096 "fortran.lalr"
 yySynAttribute.Tree = mBTE_LIST (yyAttrStackPtr [1-1].Tree, mBTE_EMPTY()); 
} break;
case 1550:
case 987: /* align_subscript_list : align_subscript ',' align_subscript_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 440; {
# line 2100 "fortran.lalr"
 yySynAttribute.Tree = mBTE_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1551:
case 793: /* align_subscript : '*' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 441; {
# line 2104 "fortran.lalr"
 yySynAttribute.Tree = mDUMMY_EXP (); 
} break;
case 1552:
case 988: /* align_subscript : Index_Elem .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 441; {
# line 2108 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1553:
case 1008: /* dynamic_directive : DYNAMIC realignee_list .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 426; {
# line 2120 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1554: /* realignee_list : realignee .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 443; {
# line 2124 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1555:
case 1009: /* realignee_list : realignee ',' realignee_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 443; {
# line 2128 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1556:
case 1007: /* realignee : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 444; {
# line 2132 "fortran.lalr"
 yySynAttribute.Tree = mDYNAMIC_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label); 
} break;
case 1557:
case 998: /* distribute_directive : DISTRIBUTE single_dist_stuff .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 425; {
# line 2142 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [2-1].Tree, NoTree); 
} break;
case 1558:
case 997: /* single_dist_stuff : PIdent '(' dist_format_list ')' opt_onto .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 445; {
# line 2146 "fortran.lalr"
 yySynAttribute.Tree = mDISTRIBUTE_DECL(yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label,
                      mNODE_DISTRIBUTION (yyAttrStackPtr [3-1].Tree), yyAttrStackPtr [5-1].Label); 
} break;
case 1559: /* opt_dist_format_list : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 448; {
# line 2151 "fortran.lalr"
 yySynAttribute.Tree = mNODE_DISTRIBUTION (mDIST_EMPTY()); 
} break;
case 1560:
case 798: /* opt_dist_format_list : '(' dist_format_list ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 448; {
# line 2155 "fortran.lalr"
 yySynAttribute.Tree = mNODE_DISTRIBUTION (yyAttrStackPtr [2-1].Tree); 
} break;
case 1561: /* opt_onto : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 447; {
# line 2159 "fortran.lalr"
 yySynAttribute.Label = DefaultId(); 
} break;
case 1562:
case 996: /* opt_onto : ONTO PIdent .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 447; {
# line 2163 "fortran.lalr"
 yySynAttribute.Label = yyAttrStackPtr [2-1].Scan.Ident; 
} break;
case 1563: /* dist_format_list : dist_format .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 446; {
# line 2173 "fortran.lalr"
 yySynAttribute.Tree = mDIST_LIST (yyAttrStackPtr [1-1].Tree, mDIST_EMPTY()); 
} break;
case 1564:
case 995: /* dist_format_list : dist_format ',' dist_format_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 446; {
# line 2177 "fortran.lalr"
 yySynAttribute.Tree = mDIST_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1565: /* dist_format : BLOCK .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 449; {
# line 2181 "fortran.lalr"
 yySynAttribute.Tree = mBLOCK_DISTRIBUTION (mDUMMY_EXP ()); 
} break;
case 1566:
case 796: /* dist_format : BLOCK '(' expression ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 449; {
# line 2185 "fortran.lalr"
 yySynAttribute.Tree = mBLOCK_DISTRIBUTION (yyAttrStackPtr [3-1].Tree); 
} break;
case 1567: /* dist_format : CYCLIC .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 449; {
# line 2189 "fortran.lalr"
 yySynAttribute.Tree = mCYCLIC_DISTRIBUTION (mDUMMY_EXP ()); 
} break;
case 1568:
case 797: /* dist_format : CYCLIC '(' expression ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 449; {
# line 2193 "fortran.lalr"
 yySynAttribute.Tree = mCYCLIC_DISTRIBUTION (yyAttrStackPtr [3-1].Tree); 
} break;
case 1569:
case 795: /* dist_format : '*' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 449; {
# line 2197 "fortran.lalr"
 yySynAttribute.Tree = mSERIAL_DISTRIBUTION (); 
} break;
case 1570:
case 1147: /* combined_directive : combined_att_list '::' object_name_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 427; {
# line 2207 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree;
       /* set all Attributes to Entity Declaration Attributes */
       SetAttributes (yyAttrStackPtr [1-1].Tree, yySynAttribute.Tree); 
} break;
case 1571: /* object_name_list : object_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 451; {
# line 2213 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1572:
case 1148: /* object_name_list : object_name ',' object_name_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 451; {
# line 2217 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1573:
case 1146: /* object_name : PIdent opt_array_spec .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 452; {
# line 2221 "fortran.lalr"
 yySynAttribute.Tree = mDECL_EMPTY ();
      if (yyAttrStackPtr [2-1].Tree != NoTree)
         yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [2-1].Tree, yySynAttribute.Tree);
      yySynAttribute.Tree = mENTITY_DECL (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [1-1].Label, yySynAttribute.Tree); 
} break;
case 1574: /* combined_att_list : combined_att .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 450; {
# line 2228 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, NoTree); 
} break;
case 1575:
case 1149: /* combined_att_list : combined_att ',' combined_att_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 450; {
# line 2232 "fortran.lalr"
 yySynAttribute.Tree = mDECL_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1576:
case 994: /* combined_att : ALIGN align_attribute_stuff .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 453; {
# line 2236 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1577:
case 990: /* align_attribute_stuff : WITH align_spec .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 454; {
# line 2240 "fortran.lalr"
 yySynAttribute.Tree = mALIGN_DECL (DefaultId(), 0, mBTE_EMPTY(), yyAttrStackPtr [2-1].Tree); 
} break;
case 1578:
case 986: /* align_attribute_stuff : '(' align_source_list ')' WITH align_spec .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 454; {
# line 2244 "fortran.lalr"
 yySynAttribute.Tree = mALIGN_DECL (DefaultId(), 0, yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [5-1].Tree); 
} break;
case 1579:
case 1000: /* combined_att : DISTRIBUTE dist_attribute_stuff .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 453; {
# line 2248 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1580:
case 999: /* dist_attribute_stuff : opt_dist_format_list opt_onto .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 455; {
# line 2252 "fortran.lalr"
 yySynAttribute.Tree = mDISTRIBUTE_DECL (DefaultId(), 0, yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [2-1].Label); 
} break;
case 1581:
case 840: /* combined_att : DYNAMIC .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 453; {
# line 2256 "fortran.lalr"
 yySynAttribute.Tree = mDYNAMIC_DECL (DefaultId(), 0); 
} break;
case 1582:
case 841: /* combined_att : INHERIT .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 453; {
# line 2260 "fortran.lalr"
 yySynAttribute.Tree = mINHERIT_DECL (DefaultId(), 0); 
} break;
case 1583:
case 839: /* combined_att : TEMPLATE .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 453; {
# line 2264 "fortran.lalr"
 yySynAttribute.Tree = mTEMPLATE_DECL (DefaultId(), 0, mTYPE_EMPTY()); 
} break;
case 1584:
case 838: /* combined_att : PROCESSORS .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 453; {
# line 2268 "fortran.lalr"
 yySynAttribute.Tree = mPROCESSORS_DECL (DefaultId(), 0, mTYPE_EMPTY()); 
} break;
case 1585:
case 908: /* combined_att : DIMENSION DimSpec .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 453; {
# line 2272 "fortran.lalr"
 yySynAttribute.Tree = mDIMENSION_DECL (DefaultId(), 0, yyAttrStackPtr [2-1].Tree); 
} break;
case 1586:
case 1020: /* execution_part : labelstat CR1 execution_part .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 286; {
# line 2282 "fortran.lalr"
 yySynAttribute.Tree = mACF_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1587: /* execution_part : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 286; {
# line 2286 "fortran.lalr"
 yySynAttribute.Tree = mACF_EMPTY (); 
} break;
case 1588: /* execution_part : LABEL .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 286; {
# line 2290 "fortran.lalr"
 yyAttrStackPtr [1-1].Tree = mACF_DUMMY();
       yyAttrStackPtr [1-1].Tree->ACF_NODE.Label = LabelDefine (yyAttrStackPtr [1-1].Scan.IntConst);
       yyAttrStackPtr [1-1].Tree->ACF_NODE.Line  = yyAttrStackPtr [1-1].Scan.Position.Line;
       yySynAttribute.Tree = mACF_LIST (yyAttrStackPtr [1-1].Tree, mACF_EMPTY());
     
} break;
case 1589:
case 1096: /* labelstat : opt_label statement .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 456; {
# line 2298 "fortran.lalr"
  yyAttrStackPtr [2-1].Tree->ACF_NODE.Label = yyAttrStackPtr [1-1].Label;
        yyAttrStackPtr [2-1].Tree->ACF_NODE.Line  = yyAttrStackPtr [2-1].Line;
        yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
     
} break;
case 1590:
case 1097: /* statement : basic_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 457; {
# line 2305 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree;
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line; 
} break;
case 1591:
case 1054: /* basic_statement : assignment_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 458; {
# line 2310 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree);
       /* attention: Label and Line have to be set here as a 
          basic_statement is not only in a labelstat         */
       yySynAttribute.Tree->ACF_NODE.Label = 0;
       yySynAttribute.Tree->ACF_NODE.Line = yyAttrStackPtr [1-1].Line;
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;                
} break;
case 1592:
case 1055: /* basic_statement : goto_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 458; {
# line 2319 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree;
       /* attention: Label and Line have to be set here as a 
          basic_statement is not only in a labelstat         */
       yySynAttribute.Tree->ACF_NODE.Label = 0;
       yySynAttribute.Tree->ACF_NODE.Line = yyAttrStackPtr [1-1].Line;
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;  
} break;
case 1593:
case 1098: /* statement : allocate_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 457; {
# line 2328 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;             
} break;
case 1594:
case 1099: /* statement : reduce_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 457; {
# line 2333 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;             
} break;
case 1595:
case 1100: /* statement : deallocate_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 457; {
# line 2338 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;            
} break;
case 1596:
case 1101: /* statement : entry_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 457; {
# line 2343 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;             
} break;
case 1597:
case 1102: /* statement : nullify_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 457; {
# line 2348 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;             
} break;
case 1598:
case 1103: /* statement : hpf_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 457; {
# line 2353 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1599:
case 1056: /* basic_statement : stop_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 458; {
# line 2356 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       /* attention: Label and Line have to be set here as a 
          basic_statement is not only in a labelstat         */
       yySynAttribute.Tree->ACF_NODE.Label = 0;
       yySynAttribute.Tree->ACF_NODE.Line = yyAttrStackPtr [1-1].Line;
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;             
} break;
case 1600:
case 1057: /* basic_statement : call_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 458; {
# line 2365 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       /* attention: Label and Line have to be set here as a 
          basic_statement is not only in a labelstat         */
       yySynAttribute.Tree->ACF_NODE.Label = 0;
       yySynAttribute.Tree->ACF_NODE.Line = yyAttrStackPtr [1-1].Line;
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;             
} break;
case 1601:
case 1104: /* statement : format_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 457; {
# line 2374 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree);
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;              
} break;
case 1602:
case 1058: /* basic_statement : io_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 458; {
# line 2379 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
       /* attention: Label and Line have to be set here as a 
          basic_statement is not only in a labelstat         */
       yySynAttribute.Tree->ACF_NODE.Label = 0;
       yySynAttribute.Tree->ACF_NODE.Line = yyAttrStackPtr [1-1].Line;
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;             
} break;
case 1603:
case 1105: /* statement : structured_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 457; {
# line 2388 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;             
} break;
case 1604:
case 1059: /* basic_statement : return_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 458; {
# line 2393 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC (yyAttrStackPtr [1-1].Tree); 
       /* attention: Label and Line have to be set here as a 
          basic_statement is not only in a labelstat         */
       yySynAttribute.Tree->ACF_NODE.Label = 0;
       yySynAttribute.Tree->ACF_NODE.Line = yyAttrStackPtr [1-1].Line;
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;             
} break;
case 1605:
case 1060: /* basic_statement : continue_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 458; {
# line 2402 "fortran.lalr"
 yySynAttribute.Tree = mACF_DUMMY (); 
       /* attention: Label and Line have to be set here as a 
          basic_statement is not only in a labelstat         */
       yySynAttribute.Tree->ACF_NODE.Label = 0;
       yySynAttribute.Tree->ACF_NODE.Line = yyAttrStackPtr [1-1].Line;
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;             
} break;
case 1606:
case 1061: /* basic_statement : exit_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 458; {
# line 2411 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC (yyAttrStackPtr [1-1].Tree);
       /* attention: Label and Line have to be set here as a 
          basic_statement is not only in a labelstat         */
       yySynAttribute.Tree->ACF_NODE.Label = 0;
       yySynAttribute.Tree->ACF_NODE.Line = yyAttrStackPtr [1-1].Line;
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;             
} break;
case 1607:
case 1062: /* basic_statement : cycle_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 458; {
# line 2420 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC (yyAttrStackPtr [1-1].Tree);
       /* attention: Label and Line have to be set here as a 
          basic_statement is not only in a labelstat         */
       yySynAttribute.Tree->ACF_NODE.Label = 0;
       yySynAttribute.Tree->ACF_NODE.Line = yyAttrStackPtr [1-1].Line;
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;             
} break;
case 1608:
case 806: /* used_label : IntConst .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 476; {
# line 2429 "fortran.lalr"
 yySynAttribute.Label = LabelUse (yyAttrStackPtr [1-1].Scan.IntConst); 
} break;
case 1609:
case 1029: /* goto_statement : GOTO used_label .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 460; {
# line 2432 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(mGOTO_STMT ( yyAttrStackPtr [2-1].Label )); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;                                
} break;
case 1610:
case 1028: /* goto_statement : GOTO PIdent assigned_labels .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 460; {
# line 2437 "fortran.lalr"
 yyAttrStackPtr [2-1].Tree = mUSED_VAR (mVAR_OBJ (yyAttrStackPtr [2-1].Label, yyAttrStackPtr [2-1].Scan.Ident));
       yySynAttribute.Tree = mACF_BASIC(mASS_GOTO_STMT (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [3-1].Tree)); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;                                
} break;
case 1611: /* assigned_labels : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 477; {
# line 2443 "fortran.lalr"
 yySynAttribute.Tree = mLABEL_EMPTY (); 
} break;
case 1612:
case 811: /* assigned_labels : opt_comma '(' label_list ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 477; {
# line 2446 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1613: /* label_list : used_label .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 478; {
# line 2449 "fortran.lalr"
 yySynAttribute.Tree = mLABEL_LIST (yyAttrStackPtr [1-1].Label, mLABEL_EMPTY ()); 
} break;
case 1614:
case 1027: /* label_list : used_label ',' label_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 478; {
# line 2452 "fortran.lalr"
 yySynAttribute.Tree = mLABEL_LIST (yyAttrStackPtr [1-1].Label, yyAttrStackPtr [3-1].Tree); 
} break;
case 1615: /* goto_statement : GOTO '(' label_list ')' opt_comma expression .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 460; {
# line 2455 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC (mCOMP_GOTO_STMT(yyAttrStackPtr [3-1].Tree, yyAttrStackPtr [6-1].Tree)); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;
     
} break;
case 1616: /* assignment_statement : variable '=' expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 459; {
# line 2460 "fortran.lalr"
 yySynAttribute.Tree = mASSIGN_STMT (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [2-1].Scan.Position.Line;            
} break;
case 1617: /* assignment_statement : variable '=>' expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 459; {
# line 2465 "fortran.lalr"
 yySynAttribute.Tree = mPTR_ASSIGN_STMT (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [2-1].Scan.Position.Line;            
} break;
case 1618:
case 1024: /* assignment_statement : ASSIGN used_label TO PIdent .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 459; {
# line 2470 "fortran.lalr"
 yyAttrStackPtr [4-1].Tree = mUSED_VAR (mVAR_OBJ (yyAttrStackPtr [4-1].Label, yyAttrStackPtr [4-1].Scan.Ident)); 
       yySynAttribute.Tree = mLABEL_ASSIGN_STMT (yyAttrStackPtr [2-1].Label, yyAttrStackPtr [4-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;            
} break;
case 1619: /* stop_statement : STOP .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 467; {
# line 2476 "fortran.lalr"
 yySynAttribute.Tree = mSTOP_STMT (mDUMMY_EXP()); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;     
} break;
case 1620: /* stop_statement : STOP expression .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 467; {
# line 2481 "fortran.lalr"
 yySynAttribute.Tree = mSTOP_STMT (yyAttrStackPtr [2-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;  
} break;
case 1621:
case 810: /* continue_statement : CONTINUE .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 473; {
# line 2486 "fortran.lalr"
 yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line; 
} break;
case 1622: /* return_statement : RETURN .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 472; {
# line 2490 "fortran.lalr"
 yySynAttribute.Tree = mRETURN_STMT (mDUMMY_EXP()); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;         
} break;
case 1623: /* return_statement : RETURN expression .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 472; {
# line 2495 "fortran.lalr"
 yySynAttribute.Tree = mRETURN_STMT (yyAttrStackPtr [2-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;         
} break;
case 1624:
case 819: /* exit_statement : EXIT .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 474; {
# line 2500 "fortran.lalr"
 yySynAttribute.Tree = mEXIT_STMT (DefaultId());
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;         
} break;
case 1625:
case 818: /* cycle_statement : CYCLE .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 475; {
# line 2505 "fortran.lalr"
 yySynAttribute.Tree = mCYCLE_STMT (DefaultId());
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;         
} break;
case 1626:
case 821: /* allocate_statement : ALLOCATE '(' index_var_list ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 461; {
# line 2510 "fortran.lalr"
 yySynAttribute.Tree = mALLOCATE_STMT (yyAttrStackPtr [3-1].Tree, mDUMMY_VAR()); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;                   
} break;
case 1627:
case 822: /* deallocate_statement : DEALLOCATE '(' index_var_list ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 463; {
# line 2515 "fortran.lalr"
 yySynAttribute.Tree = mDEALLOCATE_STMT (yyAttrStackPtr [3-1].Tree, mDUMMY_VAR()); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;                     
} break;
case 1628:
case 832: /* nullify_statement : NULLIFY '(' index_var_list ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 465; {
# line 2520 "fortran.lalr"
 yySynAttribute.Tree = mNULLIFY_STMT (yyAttrStackPtr [3-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;         
} break;
case 1629:
case 831: /* reduce_statement : REDUCE '(' reduce_func ',' reduce_params ')' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 462; {
# line 2525 "fortran.lalr"
 yySynAttribute.Tree = mREDUCE_STMT (yyAttrStackPtr [3-1].Tree, yyAttrStackPtr [5-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;
     
} break;
case 1630: /* reduce_params : reduce_var ',' reduce_exp .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 481; {
# line 2531 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (yyAttrStackPtr [1-1].Tree, mBTP_LIST (yyAttrStackPtr [3-1].Tree, mBTP_EMPTY())); 
} break;
case 1631:
case 1087: /* reduce_params : reduce_var ',' reduce_exp ',' reduce_params .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 481; {
# line 2535 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (yyAttrStackPtr [1-1].Tree, mBTP_LIST (yyAttrStackPtr [3-1].Tree, yyAttrStackPtr [5-1].Tree )); 
} break;
case 1632:
case 830: /* reduce_func : Ident .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 480; {
# line 2539 "fortran.lalr"
 yySynAttribute.Tree = mPROC_OBJ (yyAttrStackPtr [1-1].Scan.Ident); 
} break;
case 1633: /* reduce_var : variable .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 482; {
# line 2543 "fortran.lalr"
 yySynAttribute.Tree = mVALUE_PARAM (mVAR_EXP(yyAttrStackPtr [1-1].Tree)); 
} break;
case 1634: /* reduce_exp : expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 483; {
# line 2547 "fortran.lalr"
 yySynAttribute.Tree = mVALUE_PARAM (yyAttrStackPtr [1-1].Tree); 
} break;
case 1635: /* index_var_list : variable .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 479; {
# line 2551 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (mVAR_PARAM (yyAttrStackPtr [1-1].Tree), mBTP_EMPTY ()); 
} break;
case 1636:
case 1076: /* index_var_list : variable ',' index_var_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 479; {
# line 2555 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (mVAR_PARAM (yyAttrStackPtr [1-1].Tree), yyAttrStackPtr [3-1].Tree); 
} break;
case 1637: /* call_statement : CALL Ident .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 468; {
# line 2559 "fortran.lalr"
 yySynAttribute.Tree = mCALL_STMT (mPROC_OBJ (yyAttrStackPtr [2-1].Scan.Ident), mBTP_EMPTY()); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1638:
case 808: /* call_statement : CALL Ident '(' ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 468; {
# line 2563 "fortran.lalr"
 yySynAttribute.Tree = mCALL_STMT (mPROC_OBJ (yyAttrStackPtr [2-1].Scan.Ident), mBTP_EMPTY()); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1639:
case 809: /* call_statement : CALL Ident '(' params ')' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 468; {
# line 2567 "fortran.lalr"
 yySynAttribute.Tree = mCALL_STMT (mPROC_OBJ (yyAttrStackPtr [2-1].Scan.Ident), yyAttrStackPtr [4-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1640: /* params : param .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 484; {
# line 2572 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (yyAttrStackPtr [1-1].Tree, mBTP_EMPTY()); 
} break;
case 1641:
case 1026: /* params : param ',' params .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 484; {
# line 2575 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1642: /* param : PIdent '=' expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 485; {
# line 2578 "fortran.lalr"
 yySynAttribute.Tree = mNAMED_PARAM (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [3-1].Tree); 
} break;
case 1643: /* param : expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 485; {
# line 2581 "fortran.lalr"
 yySynAttribute.Tree = mVALUE_PARAM (yyAttrStackPtr [1-1].Tree); 
} break;
case 1644:
case 1025: /* param : '*' used_label .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 485; {
# line 2584 "fortran.lalr"
 yySynAttribute.Tree = mRETURN_PARAM (yyAttrStackPtr [2-1].Label); 
} break;
case 1645:
case 1064: /* io_statement : print_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 470; {
# line 2593 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;              
} break;
case 1646:
case 1065: /* io_statement : read_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 470; {
# line 2598 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;              
} break;
case 1647:
case 1066: /* io_statement : write_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 470; {
# line 2603 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;              
} break;
case 1648:
case 1067: /* io_statement : open_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 470; {
# line 2608 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;              
} break;
case 1649:
case 1068: /* io_statement : close_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 470; {
# line 2613 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;              
} break;
case 1650:
case 1069: /* io_statement : rewind_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 470; {
# line 2618 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;              
} break;
case 1651:
case 1070: /* io_statement : backspace_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 470; {
# line 2623 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;              
} break;
case 1652:
case 1071: /* io_statement : endfile_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 470; {
# line 2628 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;              
} break;
case 1653:
case 1072: /* io_statement : inquire_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 470; {
# line 2633 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC(yyAttrStackPtr [1-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Line;              
} break;
case 1654: /* write_statement : WRITE rw_specification .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 488; {
# line 2638 "fortran.lalr"
 yySynAttribute.Tree = mIO_STMT (mPROC_OBJ (MakeIdent("WRITE", 5)),
                           yyAttrStackPtr [2-1].Tree, mBTP_EMPTY ()    );   
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1655:
case 1043: /* write_statement : WRITE rw_specification io_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 488; {
# line 2644 "fortran.lalr"
 yySynAttribute.Tree = mIO_STMT (mPROC_OBJ (MakeIdent("WRITE", 5)),
                           yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [3-1].Tree);                 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1656: /* print_statement : PRINT format_identifier .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 486; {
# line 2650 "fortran.lalr"
 yySynAttribute.Tree = mIO_STMT (mPROC_OBJ (MakeIdent("PRINT", 5)),
                           mBTP_LIST(yyAttrStackPtr [2-1].Tree, mBTP_EMPTY ()), 
                           mBTP_EMPTY ()     );
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1657:
case 1044: /* print_statement : PRINT format_identifier ',' io_list .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 486; {
# line 2657 "fortran.lalr"
 yySynAttribute.Tree = mIO_STMT (mPROC_OBJ (MakeIdent("PRINT", 5)),
                           mBTP_LIST(yyAttrStackPtr [2-1].Tree, mBTP_EMPTY ()), 
                           yyAttrStackPtr [4-1].Tree     );    
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1658: /* read_statement : READ format_identifier .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 487; {
# line 2664 "fortran.lalr"
 yySynAttribute.Tree = mIO_STMT (mPROC_OBJ (MakeIdent("READ",4)),
                           mBTP_LIST(yyAttrStackPtr [2-1].Tree, mBTP_EMPTY ()), 
                           mBTP_EMPTY ()     );    
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1659:
case 1042: /* read_statement : READ format_identifier ',' io_list .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 487; {
# line 2671 "fortran.lalr"
 yySynAttribute.Tree = mIO_STMT (mPROC_OBJ (MakeIdent("READ", 4)),
                           mBTP_LIST(yyAttrStackPtr [2-1].Tree, mBTP_EMPTY ()), 
                           yyAttrStackPtr [4-1].Tree     );    
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1660: /* read_statement : READ rw_specification .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 487; {
# line 2678 "fortran.lalr"
 yySynAttribute.Tree = mIO_STMT (mPROC_OBJ (MakeIdent("READ", 4)),
                           yyAttrStackPtr [2-1].Tree, mBTP_EMPTY ()    );    
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1661:
case 1040: /* read_statement : READ rw_specification io_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 487; {
# line 2684 "fortran.lalr"
 yySynAttribute.Tree = mIO_STMT (mPROC_OBJ (MakeIdent("READ", 4)),
                           yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [3-1].Tree);
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1662:
case 1047: /* open_statement : OPEN io_specification .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 489; {
# line 2690 "fortran.lalr"
 yySynAttribute.Tree = mIO_STMT (mPROC_OBJ (MakeIdent("OPEN", 4)),
                           yyAttrStackPtr [2-1].Tree, mBTP_EMPTY());
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1663:
case 1048: /* close_statement : CLOSE io_specification .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 490; {
# line 2696 "fortran.lalr"
 yySynAttribute.Tree = mIO_STMT (mPROC_OBJ (MakeIdent("CLOSE", 5)),
                           yyAttrStackPtr [2-1].Tree, mBTP_EMPTY());
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1664:
case 1052: /* rewind_statement : REWIND io_spec .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 491; {
# line 2702 "fortran.lalr"
 yySynAttribute.Tree = mIO_STMT (mPROC_OBJ (MakeIdent("REWIND", 6)),
                           mBTP_LIST (yyAttrStackPtr [2-1].Tree, mBTP_EMPTY()),
                           mBTP_EMPTY ())   ;
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1665:
case 1050: /* backspace_statement : BACKSPACE io_spec .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 492; {
# line 2709 "fortran.lalr"
 yySynAttribute.Tree = mIO_STMT (mPROC_OBJ (MakeIdent("BACKSPACE", 9)),
                           mBTP_LIST (yyAttrStackPtr [2-1].Tree, mBTP_EMPTY()),
                           mBTP_EMPTY ())   ;
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1666:
case 1051: /* endfile_statement : ENDFILE io_spec .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 493; {
# line 2716 "fortran.lalr"
 yySynAttribute.Tree = mIO_STMT (mPROC_OBJ (MakeIdent("ENDFILE", 7)),
                           mBTP_LIST (yyAttrStackPtr [2-1].Tree, mBTP_EMPTY()),
                           mBTP_EMPTY ())   ;
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1667:
case 1049: /* inquire_statement : INQUIRE io_specification .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 494; {
# line 2723 "fortran.lalr"
 yySynAttribute.Tree = mIO_STMT (mPROC_OBJ (MakeIdent("INQUIRE", 7)),
                           yyAttrStackPtr [2-1].Tree, mBTP_EMPTY());
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
} break;
case 1668:
case 816: /* rw_specification : '(' unit_spec more_rw_specs ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 495; {
# line 2739 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1669: /* more_rw_specs : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 501; {
# line 2743 "fortran.lalr"
 yySynAttribute.Tree = mBTP_EMPTY() ; 
} break;
case 1670:
case 1036: /* more_rw_specs : ',' format_spec more_rw_specs .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 501; {
# line 2747 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1671:
case 1037: /* more_rw_specs : ',' end_spec more_rw_specs .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 501; {
# line 2751 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1672:
case 1038: /* more_rw_specs : ',' err_spec more_rw_specs .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 501; {
# line 2755 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1673:
case 1039: /* unit_spec : dummy_rw_spec .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 500; {
# line 2759 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1674: /* unit_spec : expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 500; {
# line 2763 "fortran.lalr"
 yySynAttribute.Tree = mVALUE_PARAM (yyAttrStackPtr [1-1].Tree); 
} break;
case 1675: /* unit_spec : Ident '=' expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 500; {
# line 2767 "fortran.lalr"
 yySynAttribute.Tree = mNAMED_PARAM (yyAttrStackPtr [1-1].Scan.Ident, mVALUE_PARAM (yyAttrStackPtr [3-1].Tree)); 
} break;
case 1676:
case 1035: /* format_spec : format_identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 502; {
# line 2771 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1677:
case 1032: /* format_spec : Ident '=' format_identifier .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 502; {
# line 2775 "fortran.lalr"
 yySynAttribute.Tree = mNAMED_PARAM (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [3-1].Tree); 
} break;
case 1678:
case 1033: /* end_spec : END '=' used_label .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 503; {
# line 2780 "fortran.lalr"
 yyAttrStackPtr [3-1].Tree = mCONST_EXP (mINT_CONSTANT (yyAttrStackPtr [3-1].Label));
       yySynAttribute.Tree = mNAMED_PARAM (MakeIdent("END",3), mVALUE_PARAM (yyAttrStackPtr [3-1].Tree)); 
} break;
case 1679:
case 1034: /* err_spec : ERR '=' used_label .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 504; {
# line 2785 "fortran.lalr"
 yyAttrStackPtr [3-1].Tree = mCONST_EXP (mINT_CONSTANT (yyAttrStackPtr [3-1].Label));
       yySynAttribute.Tree = mNAMED_PARAM (MakeIdent("ERR",3), mVALUE_PARAM (yyAttrStackPtr [3-1].Tree)); 
} break;
case 1680:
case 814: /* dummy_rw_spec : '*' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 505; {
# line 2789 "fortran.lalr"
 yySynAttribute.Tree = mVALUE_PARAM (mDUMMY_EXP()); 
} break;
case 1681:
case 813: /* dummy_rw_spec : Ident '=' '*' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 505; {
# line 2793 "fortran.lalr"
 yySynAttribute.Tree = mVALUE_PARAM (mDUMMY_EXP()); 
} break;
case 1682:
case 817: /* io_specification : '(' io_spec_list ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 498; {
# line 2797 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1683: /* io_spec_list : io_spec .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 506; {
# line 2801 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (yyAttrStackPtr [1-1].Tree, mBTP_EMPTY ()); 
} break;
case 1684:
case 1046: /* io_spec_list : io_spec ',' io_spec_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 506; {
# line 2805 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1685: /* io_spec : expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 499; {
# line 2809 "fortran.lalr"
 yySynAttribute.Tree = mVALUE_PARAM (yyAttrStackPtr [1-1].Tree); 
} break;
case 1686: /* io_spec : Ident '=' expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 499; {
# line 2813 "fortran.lalr"
 yySynAttribute.Tree = mNAMED_PARAM (yyAttrStackPtr [1-1].Scan.Ident, mVALUE_PARAM (yyAttrStackPtr [3-1].Tree)); 
} break;
case 1687:
case 1045: /* io_spec : err_spec .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 499; {
# line 2817 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1688:
case 1031: /* format_identifier : used_label .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 497; {
# line 2821 "fortran.lalr"
 yyAttrStackPtr [1-1].Tree = mCONST_EXP (mINT_CONSTANT (yyAttrStackPtr [1-1].Label));
       yySynAttribute.Tree = mVALUE_PARAM (yyAttrStackPtr [1-1].Tree); 
} break;
case 1689:
case 815: /* format_identifier : '*' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 497; {
# line 2826 "fortran.lalr"
 yySynAttribute.Tree = mVALUE_PARAM (mDUMMY_EXP()); 
} break;
case 1690:
case 812: /* format_identifier : StringConst .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 497; {
# line 2830 "fortran.lalr"
 yyAttrStackPtr [1-1].Tree = mCONST_EXP (mSTRING_CONSTANT (yyAttrStackPtr [1-1].Scan.StringConst)); 
       yySynAttribute.Tree = mVALUE_PARAM (yyAttrStackPtr [1-1].Tree); 
} break;
case 1691:
case 1030: /* format_identifier : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 497; {
# line 2835 "fortran.lalr"
 yyAttrStackPtr [1-1].Tree = mUSED_VAR (mVAR_OBJ (yyAttrStackPtr [1-1].Label, yyAttrStackPtr [1-1].Scan.Ident)); 
       yySynAttribute.Tree = mVALUE_PARAM (mVAR_EXP(yyAttrStackPtr [1-1].Tree)); 
} break;
case 1692: /* io_list : io_item .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 496; {
# line 2840 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (yyAttrStackPtr [1-1].Tree, mBTP_EMPTY ()); 
} break;
case 1693:
case 1041: /* io_list : io_item ',' io_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 496; {
# line 2844 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree);  
} break;
case 1694: /* io_item : expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 507; {
# line 2848 "fortran.lalr"
 yySynAttribute.Tree = mVALUE_PARAM (yyAttrStackPtr [1-1].Tree); 
} break;
case 1695:
case 1074: /* format_statement : FORMAT format_list .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 469; {
# line 2858 "fortran.lalr"
 yySynAttribute.Tree = mFORMAT_STMT (yyAttrStackPtr [2-1].Tree);    
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;    
} break;
case 1696:
case 1073: /* format_list : FORMAT_ARG format_list .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 508; {
# line 2863 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (mFORMAT_PARAM (yyAttrStackPtr [1-1].Scan.StringConst),
                              yyAttrStackPtr [2-1].Tree); 
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;    
} break;
case 1697: /* format_list : FORMAT_ARG .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 508; {
# line 2869 "fortran.lalr"
 yySynAttribute.Tree = mBTP_LIST (mFORMAT_PARAM (yyAttrStackPtr [1-1].Scan.StringConst),
                              mBTP_EMPTY());
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;    
} break;
case 1698:
case 1075: /* entry_statement : ENTRY PIdent dummy_arguments function_result .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 464; {
# line 2881 "fortran.lalr"
 yySynAttribute.Tree = mFUNC_DECL (yyAttrStackPtr [2-1].Scan.Ident, yyAttrStackPtr [2-1].Label, 
                             yyAttrStackPtr [3-1].Tree,       /* formals */
                             mBODY_NODE( mDECL_EMPTY(),
                                         mACF_EMPTY(),
                                         mDECL_EMPTY() ),
                             mDUMMY_TYPE(), /* result_type   */
                             yyAttrStackPtr [4-1].Label);      /* result_id     */
       yySynAttribute.Tree = mACF_ENTRY (yySynAttribute.Tree);
       yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;   
     
} break;
case 1699:
case 1106: /* structured_statement : loop_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 471; {
# line 2899 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1700:
case 1094: /* structured_statement : PIdent ':' loop_statement .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 471; {
# line 2903 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1701:
case 803: /* loop_statement : DO WHILE '(' expression ')' CR1 execution_part ENDDO .*/
  yyStateStackPtr -=8; yyAttrStackPtr -=8; yyNonterminal = 509; {
# line 2908 "fortran.lalr"
 yySynAttribute.Tree = mACF_WHILE (yyAttrStackPtr [4-1].Tree, yyAttrStackPtr [7-1].Tree); 
        yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;    
} break;
case 1702:
case 805: /* loop_statement : DO ForLabel opt_comma Laufvariable '=' DoRange CR1 execution_part ENDDO .*/
  yyStateStackPtr -=9; yyAttrStackPtr -=9; yyNonterminal = 509; {
# line 2914 "fortran.lalr"
 yySynAttribute.Tree = mACF_DO (yyAttrStackPtr [4-1].Tree, yyAttrStackPtr [6-1].Tree, yyAttrStackPtr [8-1].Tree); 
        yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;    
} break;
case 1703:
case 835: /* loop_statement : local_independent DO ForLabel opt_comma Laufvariable '=' DoRange CR1 execution_part ENDDO .*/
  yyStateStackPtr -=10; yyAttrStackPtr -=10; yyNonterminal = 509; {
# line 2921 "fortran.lalr"
 yySynAttribute.Tree = mACF_DOLOCAL (yyAttrStackPtr [5-1].Tree, yyAttrStackPtr [7-1].Tree, yyAttrStackPtr [9-1].Tree); 
        yySynAttribute.Line = yyAttrStackPtr [4-1].Scan.Position.Line;    
} break;
case 1704:
case 1090: /* local_independent : INDEPENDENT ',' LOCAL_ACCESS CR1 .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 511; {

} break;
case 1705:
case 1093: /* local_independent : LOCAL_ACCESS ',' INDEPENDENT CR1 .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 511; {

} break;
case 1706:
case 836: /* loop_statement : new_independent DO ForLabel opt_comma Laufvariable '=' DoRange CR1 execution_part ENDDO .*/
  yyStateStackPtr -=10; yyAttrStackPtr -=10; yyNonterminal = 509; {
# line 2931 "fortran.lalr"
 yySynAttribute.Tree = mACF_DOALL (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [5-1].Tree, yyAttrStackPtr [7-1].Tree, yyAttrStackPtr [9-1].Tree); 
        yySynAttribute.Line = yyAttrStackPtr [4-1].Scan.Position.Line;    
} break;
case 1707:
case 1092: /* new_independent : INDEPENDENT new_clause CR1 .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 512; {
# line 2936 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1708: /* new_clause : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 513; {
# line 2940 "fortran.lalr"
 yySynAttribute.Tree = mBTV_EMPTY (); 
} break;
case 1709:
case 834: /* new_clause : ',' NEW '(' new_var_list ')' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 513; {
# line 2944 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [4-1].Tree; 
} break;
case 1710: /* new_var_list : variable .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 514; {
# line 2948 "fortran.lalr"
 yySynAttribute.Tree = mBTV_LIST (yyAttrStackPtr [1-1].Tree, mBTV_EMPTY ()); 
} break;
case 1711:
case 1091: /* new_var_list : variable ',' new_var_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 514; {
# line 2952 "fortran.lalr"
 yySynAttribute.Tree = mBTV_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1712:
case 804: /* loop_statement : DO ForLabel CR1 execution_part ENDDO .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 509; {
# line 2957 "fortran.lalr"
 yySynAttribute.Tree = mACF_LOOP (yyAttrStackPtr [4-1].Tree); 
        yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;    
} break;
case 1713: /* ForLabel : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 510; {

} break;
case 1714:
case 802: /* ForLabel : IntConst .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 510; {
# line 2964 "fortran.lalr"
 LabelDo (yyAttrStackPtr [1-1].Scan.IntConst); 
} break;
case 1715:
case 1021: /* Laufvariable : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 387; {
# line 2968 "fortran.lalr"
 yySynAttribute.Tree = mLOOP_VAR (mVAR_OBJ (yyAttrStackPtr [1-1].Label, yyAttrStackPtr [1-1].Scan.Ident)); 
} break;
case 1716: /* DoRange : expression ',' expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 388; {
# line 2972 "fortran.lalr"
 yySynAttribute.Tree = mSLICE_EXP (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree, mDUMMY_EXP()); 
} break;
case 1717: /* DoRange : expression ',' expression ',' expression .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 388; {
# line 2976 "fortran.lalr"
 yySynAttribute.Tree = mSLICE_EXP (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree, yyAttrStackPtr [5-1].Tree); 
} break;
case 1718:
case 1086: /* loop_statement : FORALL '(' forall_cont .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 509; {
# line 2986 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
        yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;    
} break;
case 1719:
case 1095: /* loop_statement : new_independent FORALL '(' forall_cont .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 509; {
# line 2992 "fortran.lalr"
 yySynAttribute.Tree = IndependentForall (yyAttrStackPtr [4-1].Tree); 
        yySynAttribute.Line = yyAttrStackPtr [2-1].Scan.Position.Line;
      
} break;
case 1720:
case 1084: /* forall_cont : Laufvariable '=' Slice ',' forall_cont .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 515; {
# line 2999 "fortran.lalr"
 yySynAttribute.Tree = mACF_FORALL (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree,  mACF_LIST (yyAttrStackPtr [5-1].Tree,
                                          mACF_EMPTY()));  
        yySynAttribute.Tree->ACF_NODE.Line = yyAttrStackPtr [2-1].Scan.Position.Line; 
} break;
case 1721:
case 1085: /* forall_cont : Laufvariable '=' Slice forall_end .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 515; {
# line 3005 "fortran.lalr"
 yySynAttribute.Tree = mACF_FORALL (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree, yyAttrStackPtr [4-1].Tree); 
        yySynAttribute.Tree->ACF_NODE.Line = yyAttrStackPtr [2-1].Scan.Position.Line; 
} break;
case 1722:
case 1083: /* forall_cont : expression forall_end .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 515; {
# line 3011 "fortran.lalr"
 yySynAttribute.Tree = mACF_IF (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [2-1].Tree, mACF_EMPTY ());
        yySynAttribute.Tree->ACF_NODE.Line = yyAttrStackPtr [2-1].Line; /* from ')' */ 
      
} break;
case 1723:
case 1082: /* forall_end : ')' assignment_statement .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 517; {
# line 3017 "fortran.lalr"
 yyAttrStackPtr [2-1].Tree = mACF_BASIC (yyAttrStackPtr [2-1].Tree);
        yyAttrStackPtr [2-1].Tree->ACF_NODE.Line = yyAttrStackPtr [1-1].Scan.Position.Line;
        yySynAttribute.Tree = mACF_LIST ( yyAttrStackPtr [2-1].Tree, mACF_EMPTY() );  
        yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;               
} break;
case 1724:
case 829: /* forall_end : ')' CR1 execution_part ENDFORALL .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 517; {
# line 3024 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
        yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;          
} break;
case 1725:
case 1063: /* structured_statement : IF '(' expression ')' used_label ',' used_label ',' used_label .*/
  yyStateStackPtr -=9; yyAttrStackPtr -=9; yyNonterminal = 471; {
# line 3036 "fortran.lalr"
 yySynAttribute.Tree = mACF_BASIC( mCOMP_IF_STMT (yyAttrStackPtr [3-1].Tree, 
                           yyAttrStackPtr [5-1].Label, yyAttrStackPtr [7-1].Label, yyAttrStackPtr [9-1].Label));
        yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;  
} break;
case 1726:
case 1053: /* structured_statement : IF '(' expression ')' basic_statement .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 471; {
# line 3042 "fortran.lalr"
 yySynAttribute.Tree = mACF_IF (yyAttrStackPtr [3-1].Tree, 
                           mACF_LIST (yyAttrStackPtr [5-1].Tree, mACF_EMPTY()),
                           mACF_EMPTY()); 
        yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;  
} break;
case 1727:
case 807: /* structured_statement : IF '(' expression ')' THEN CR1 execution_part else_part ENDIF .*/
  yyStateStackPtr -=9; yyAttrStackPtr -=9; yyNonterminal = 471; {
# line 3053 "fortran.lalr"
 yySynAttribute.Tree = mACF_IF (yyAttrStackPtr [3-1].Tree, yyAttrStackPtr [7-1].Tree, yyAttrStackPtr [8-1].Tree); 
        yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;  
} break;
case 1728: /* else_part : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 518; {
# line 3057 "fortran.lalr"
 yySynAttribute.Tree = mACF_EMPTY (); 
} break;
case 1729:
case 1023: /* else_part : ELSEIF '(' expression ')' THEN CR1 execution_part else_part .*/
  yyStateStackPtr -=8; yyAttrStackPtr -=8; yyNonterminal = 518; {
# line 3061 "fortran.lalr"
 yySynAttribute.Tree = mACF_LIST (mACF_IF (yyAttrStackPtr [3-1].Tree,yyAttrStackPtr [7-1].Tree,yyAttrStackPtr [8-1].Tree),
                             mACF_EMPTY());                      
} break;
case 1730:
case 1022: /* else_part : ELSE CR1 execution_part .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 518; {
# line 3066 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1731:
case 1078: /* structured_statement : WHERE '(' expression ')' basic_statement .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 471; {
# line 3070 "fortran.lalr"
 yySynAttribute.Tree = mACF_WHERE (yyAttrStackPtr [3-1].Tree,
                           mACF_LIST (yyAttrStackPtr [5-1].Tree, mACF_EMPTY()),
                           mACF_EMPTY()); 
        yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;  
} break;
case 1732:
case 823: /* structured_statement : WHERE '(' expression ')' CR1 execution_part elsewhere_part ENDWHERE .*/
  yyStateStackPtr -=8; yyAttrStackPtr -=8; yyNonterminal = 471; {
# line 3080 "fortran.lalr"
 yySynAttribute.Tree = mACF_WHERE (yyAttrStackPtr [3-1].Tree, yyAttrStackPtr [6-1].Tree, yyAttrStackPtr [7-1].Tree); 
        yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;  
} break;
case 1733: /* elsewhere_part : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 519; {
# line 3084 "fortran.lalr"
 yySynAttribute.Tree = mACF_EMPTY (); 
} break;
case 1734:
case 1077: /* elsewhere_part : ELSEWHERE CR1 execution_part .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 519; {
# line 3087 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1735:
case 828: /* structured_statement : SELECT CASE '(' expression ')' CR1 case_list default END SELECT .*/
  yyStateStackPtr -=10; yyAttrStackPtr -=10; yyNonterminal = 471; {
# line 3099 "fortran.lalr"
 yySynAttribute.Tree = mACF_CASE (yyAttrStackPtr [4-1].Tree, yyAttrStackPtr [7-1].Tree, yyAttrStackPtr [8-1].Tree); 
      yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;  
} break;
case 1736: /* case_list : case_item .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 520; {
# line 3104 "fortran.lalr"
 yySynAttribute.Tree = mSELECTED_ACF_LIST (yyAttrStackPtr [1-1].Tree, mSELECTED_ACF_EMPTY ()); 
} break;
case 1737:
case 1081: /* case_list : case_item case_list .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 520; {
# line 3108 "fortran.lalr"
 yySynAttribute.Tree = mSELECTED_ACF_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [2-1].Tree); 
} break;
case 1738:
case 1079: /* case_item : CASE case_exp CR1 execution_part .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 522; {
# line 3112 "fortran.lalr"
 yySynAttribute.Tree = mSELECTED_ACF_NODE (mBTE_LIST (yyAttrStackPtr [2-1].Tree, mBTE_EMPTY()),
                      yyAttrStackPtr [4-1].Tree);                                      
} break;
case 1739:
case 1080: /* default : DEFAULT CR1 execution_part .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 521; {
# line 3117 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1740: /* default : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 521; {
# line 3120 "fortran.lalr"
 yySynAttribute.Tree = mACF_EMPTY (); 
} break;
case 1741:
case 825: /* case_exp : '(' expression ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 523; {
# line 3123 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1742:
case 826: /* case_exp : '(' expression ':' ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 523; {
# line 3127 "fortran.lalr"
 yySynAttribute.Tree = mSLICE_EXP (yyAttrStackPtr [2-1].Tree, mDUMMY_EXP (), mDUMMY_EXP ()); 
} break;
case 1743:
case 824: /* case_exp : '(' ':' expression ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 523; {
# line 3131 "fortran.lalr"
 yySynAttribute.Tree = mSLICE_EXP (mDUMMY_EXP (), yyAttrStackPtr [3-1].Tree, mDUMMY_EXP ()); 
} break;
case 1744:
case 827: /* case_exp : '(' expression ':' expression ')' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 523; {
# line 3135 "fortran.lalr"
 yySynAttribute.Tree = mSLICE_EXP (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [4-1].Tree, mDUMMY_EXP ()); 
} break;
case 1745:
case 1088: /* hpf_statement : REALIGN realign_var WITH align_spec .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 466; {
# line 3147 "fortran.lalr"
 yySynAttribute.Tree = mALIGN_STMT (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [4-1].Tree); 
         yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;           
} break;
case 1746: /* realign_var : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 524; {
# line 3151 "fortran.lalr"
 yySynAttribute.Tree = mUSED_VAR (mVAR_OBJ (yyAttrStackPtr [1-1].Label, yyAttrStackPtr [1-1].Scan.Ident));
       
} break;
case 1747:
case 833: /* realign_var : PIdent '(' align_source_list ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 524; {
# line 3155 "fortran.lalr"
 yyAttrStackPtr [1-1].Tree = mUSED_VAR (mVAR_OBJ (yyAttrStackPtr [1-1].Label, yyAttrStackPtr [1-1].Scan.Ident));
         yySynAttribute.Tree = mINDEXED_VAR (yySynAttribute.Tree, yyAttrStackPtr [3-1].Tree); 
       
} break;
case 1748:
case 1089: /* hpf_statement : REDISTRIBUTE PIdent '(' dist_format_list ')' opt_onto .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 466; {
# line 3160 "fortran.lalr"
 yyAttrStackPtr [1-1].Tree = mUSED_VAR (mVAR_OBJ (yyAttrStackPtr [1-1].Label, yyAttrStackPtr [1-1].Scan.Ident));
         yySynAttribute.Tree = mDISTRIBUTE_STMT (yyAttrStackPtr [2-1].Tree, 
                     mNODE_DISTRIBUTION (yyAttrStackPtr [4-1].Tree), yyAttrStackPtr [6-1].Label);
         yySynAttribute.Line = yyAttrStackPtr [1-1].Scan.Position.Line;                         
} break;
case 1749:
case 850: /* variable : PIdent .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 342; {
# line 3172 "fortran.lalr"
 yySynAttribute.Tree = mUSED_VAR (mVAR_OBJ (yyAttrStackPtr [1-1].Label, yyAttrStackPtr [1-1].Scan.Ident)); 
} break;
case 1750:
case 852: /* variable : index_var .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 342; {
# line 3176 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree ; 
} break;
case 1751:
case 853: /* variable : structure_component .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 342; {
# line 3180 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1752:
case 851: /* structure_component : variable '%' PIdent .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 526; {
# line 3184 "fortran.lalr"
 yySynAttribute.Tree = mSELECTED_VAR (yyAttrStackPtr [1-1].Tree, mREC_COMP (yyAttrStackPtr [3-1].Scan.Ident)); 
} break;
case 1753:
case 724: /* index_var : variable '(' ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 525; {
# line 3188 "fortran.lalr"
 yySynAttribute.Tree = mINDEXED_VAR ( yyAttrStackPtr [1-1].Tree, mBTE_EMPTY() ); 
} break;
case 1754:
case 725: /* index_var : variable '(' Index_Liste ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 525; {
# line 3192 "fortran.lalr"
 yySynAttribute.Tree = mINDEXED_VAR ( yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree ); 
} break;
case 1755: /* Index_Liste : Index_Elem .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 527; {
# line 3196 "fortran.lalr"
 yySynAttribute.Tree = mBTE_LIST (yyAttrStackPtr [1-1].Tree, mBTE_EMPTY ()); 
} break;
case 1756:
case 866: /* Index_Liste : Index_Elem ',' Index_Liste .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 527; {
# line 3200 "fortran.lalr"
 yySynAttribute.Tree = mBTE_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1757: /* Index_Elem : expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 442; {
# line 3204 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1758: /* Index_Elem : PIdent '=' expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 442; {
# line 3210 "fortran.lalr"
 yySynAttribute.Tree = mNAMED_EXP (yyAttrStackPtr [1-1].Scan.Ident, yyAttrStackPtr [3-1].Tree); 
} break;
case 1759:
case 865: /* Index_Elem : Slice .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 442; {
# line 3214 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1760: /* Slice : dumexpression ':' dumexpression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 516; {
# line 3218 "fortran.lalr"
 yySynAttribute.Tree = mSLICE_EXP (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree, mDUMMY_EXP ()); 
} break;
case 1761:
case 867: /* Slice : dumexpression ':' dumexpression ':' dumexpression .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 516; {
# line 3222 "fortran.lalr"
 yySynAttribute.Tree = mSLICE_EXP (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree, yyAttrStackPtr [5-1].Tree); 
} break;
case 1762:
case 868: /* Slice : dumexpression '::' dumexpression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 516; {
# line 3226 "fortran.lalr"
 yySynAttribute.Tree = mSLICE_EXP (yyAttrStackPtr [1-1].Tree, mDUMMY_EXP(), yyAttrStackPtr [3-1].Tree); 
} break;
case 1763: /* dumexpression : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 528; {
# line 3230 "fortran.lalr"
 yySynAttribute.Tree = mDUMMY_EXP (); 
} break;
case 1764: /* dumexpression : expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 528; {
# line 3234 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1765:
case 721: /* primary : '(' expression ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 529; {
# line 3244 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1766:
case 722: /* primary : '(' expression ',' impl_do_exp ')' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 529; {
# line 3248 "fortran.lalr"
 yyAttrStackPtr [4-1].Tree->DO_EXP.BODY = 
         mBTE_LIST (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [4-1].Tree->DO_EXP.BODY); 
       yySynAttribute.Tree = yyAttrStackPtr [4-1].Tree; 
} break;
case 1767:
case 870: /* impl_do_exp : expression ',' impl_do_exp .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 530; {
# line 3254 "fortran.lalr"
 yyAttrStackPtr [3-1].Tree->DO_EXP.BODY = 
         mBTE_LIST (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree->DO_EXP.BODY); 
       yySynAttribute.Tree = yyAttrStackPtr [3-1].Tree; 
} break;
case 1768:
case 869: /* impl_do_exp : Laufvariable '=' DoRange .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 530; {
# line 3260 "fortran.lalr"
 yySynAttribute.Tree = mDO_EXP (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree, mBTE_EMPTY()); 
} break;
case 1769: /* expression : expression defined_binary_op level5_expr .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 299; {
# line 3268 "fortran.lalr"
 yySynAttribute.Tree = mOP_EXP (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1770:
case 704: /* defined_binary_op : UserOp .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 531; {
# line 3272 "fortran.lalr"
 yySynAttribute.Tree = mOP_DEFINED (yyAttrStackPtr [1-1].Scan.Ident); 
} break;
case 1771: /* expression : level5_expr .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 299; {
# line 3275 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1772: /* level5_expr : equiv_operand .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 532; {
# line 3279 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1773: /* level5_expr : level5_expr equiv_op equiv_operand .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 532; {
# line 3283 "fortran.lalr"
 yySynAttribute.Tree = mOP_EXP (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1774:
case 715: /* equiv_op : EQV .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 414; {
# line 3286 "fortran.lalr"
 yySynAttribute.Tree = mOP_EQV(); 
} break;
case 1775:
case 716: /* equiv_op : NEQV .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 414; {
# line 3287 "fortran.lalr"
 yySynAttribute.Tree = mOP_NEQV(); 
} break;
case 1776: /* equiv_operand : or_operand .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 533; {
# line 3290 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1777: /* equiv_operand : equiv_operand or_op or_operand .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 533; {
# line 3294 "fortran.lalr"
 yySynAttribute.Tree = mOP_EXP (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1778:
case 717: /* or_op : OR .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 413; {
# line 3297 "fortran.lalr"
 yySynAttribute.Tree = mOP_OR(); 
} break;
case 1779:
case 718: /* or_op : XOR .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 413; {
# line 3298 "fortran.lalr"
 yySynAttribute.Tree = mOP_XOR(); 
} break;
case 1780:
case 864: /* or_operand : and_operand .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 534; {
# line 3301 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1781:
case 862: /* or_operand : or_operand and_op and_operand .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 534; {
# line 3305 "fortran.lalr"
 yySynAttribute.Tree = mOP_EXP (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1782:
case 719: /* and_op : AND .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 412; {
# line 3308 "fortran.lalr"
 yySynAttribute.Tree = mOP_AND(); 
} break;
case 1783:
case 863: /* and_operand : level4_expr .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 535; {
# line 3311 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1784:
case 859: /* and_operand : not_op level4_expr .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 535; {
# line 3315 "fortran.lalr"
 yySynAttribute.Tree = mOP1_EXP (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [2-1].Tree); 
} break;
case 1785:
case 703: /* not_op : NOT .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 411; {
# line 3318 "fortran.lalr"
 yySynAttribute.Tree = mOP1_NOT(); 
} break;
case 1786: /* level4_expr : level3_expr .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 536; {
# line 3321 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1787: /* level4_expr : level3_expr rel_op level3_expr .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 536; {
# line 3325 "fortran.lalr"
 yySynAttribute.Tree = mOP_EXP (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1788:
case 708: /* rel_op : '==' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 410; {
# line 3327 "fortran.lalr"
 yySynAttribute.Tree = mOP_EQ(); 
} break;
case 1789:
case 712: /* rel_op : '<=' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 410; {
# line 3328 "fortran.lalr"
 yySynAttribute.Tree = mOP_LE(); 
} break;
case 1790:
case 710: /* rel_op : '>=' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 410; {
# line 3329 "fortran.lalr"
 yySynAttribute.Tree = mOP_GE(); 
} break;
case 1791:
case 707: /* rel_op : '<>' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 410; {
# line 3330 "fortran.lalr"
 yySynAttribute.Tree = mOP_NE(); 
} break;
case 1792:
case 711: /* rel_op : '<' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 410; {
# line 3331 "fortran.lalr"
 yySynAttribute.Tree = mOP_LT(); 
} break;
case 1793:
case 709: /* rel_op : '>' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 410; {
# line 3332 "fortran.lalr"
 yySynAttribute.Tree = mOP_GT(); 
} break;
case 1794: /* level3_expr : level2_expr .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 537; {
# line 3335 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1795: /* level3_expr : level3_expr concat_op level2_expr .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 537; {
# line 3339 "fortran.lalr"
 yySynAttribute.Tree = mOP_EXP (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1796:
case 706: /* concat_op : '//' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 409; {
# line 3342 "fortran.lalr"
 yySynAttribute.Tree = mOP_CONCAT (); 
} break;
case 1797: /* level2_expr : add_operand .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 538; {
# line 3345 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1798: /* level2_expr : level2_expr add_op add_operand .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 538; {
# line 3349 "fortran.lalr"
 yySynAttribute.Tree = mOP_EXP (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1799: /* level2_expr : '+' add_operand .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 538; {
# line 3351 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1800: /* level2_expr : '-' add_operand .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 538; {
# line 3353 "fortran.lalr"
 yySynAttribute.Tree = mOP1_EXP (mOP1_SIGN(), yyAttrStackPtr [2-1].Tree); 
} break;
case 1801:
case 713: /* add_op : '+' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 408; {
# line 3355 "fortran.lalr"
 yySynAttribute.Tree = mOP_PLUS();  
} break;
case 1802:
case 714: /* add_op : '-' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 408; {
# line 3356 "fortran.lalr"
 yySynAttribute.Tree = mOP_MINUS();  
} break;
case 1803:
case 860: /* add_operand : mult_operand .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 539; {
# line 3359 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1804:
case 855: /* add_operand : add_operand mult_op mult_operand .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 539; {
# line 3361 "fortran.lalr"
 yySynAttribute.Tree = mOP_EXP (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1805:
case 700: /* mult_op : '*' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 407; {
# line 3363 "fortran.lalr"
 yySynAttribute.Tree = mOP_TIMES();  
} break;
case 1806:
case 701: /* mult_op : '/' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 407; {
# line 3364 "fortran.lalr"
 yySynAttribute.Tree = mOP_DIVIDE(); 
} break;
case 1807: /* mult_operand : level1_expr .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 540; {
# line 3367 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1808:
case 856: /* mult_operand : level1_expr power_op mult_operand .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 540; {
# line 3369 "fortran.lalr"
 yySynAttribute.Tree = mOP_EXP (yyAttrStackPtr [2-1].Tree, yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [3-1].Tree); 
} break;
case 1809:
case 702: /* power_op : '**' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 406; {
# line 3371 "fortran.lalr"
 yySynAttribute.Tree = mOP_EXPO(); 
} break;
case 1810:
case 857: /* level1_expr : defined_unary_op primary .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 541; {
# line 3374 "fortran.lalr"
 yySynAttribute.Tree = mOP1_EXP (yyAttrStackPtr [1-1].Tree, yyAttrStackPtr [2-1].Tree); 
} break;
case 1811:
case 696: /* defined_unary_op : UserOp .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 542; {
# line 3377 "fortran.lalr"
 yySynAttribute.Tree = mOP_DEFINED (yyAttrStackPtr [1-1].Scan.Ident); 
} break;
case 1812:
case 854: /* level1_expr : primary .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 541; {
# line 3380 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1813: /* primary : variable .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 529; {
# line 3383 "fortran.lalr"
 yySynAttribute.Tree = mVAR_EXP (yyAttrStackPtr [1-1].Tree); 
} break;
case 1814:
case 858: /* primary : Konstante .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 529; {
# line 3386 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1815:
case 720: /* primary : '[' Index_Liste ']' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 529; {
# line 3389 "fortran.lalr"
 yySynAttribute.Tree = mARRAY_EXP (yyAttrStackPtr [2-1].Tree); 
} break;
case 1816:
case 705: /* primary : PReal '(' expression ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 529; {
# line 3392 "fortran.lalr"
 yySynAttribute.Tree = mVAR_EXP ( mINDEXED_VAR (
                        mUSED_VAR (mVAR_OBJ(yyAttrStackPtr [1-1].Label, yyAttrStackPtr [1-1].Scan.Ident)),
                        mBTE_LIST (yyAttrStackPtr [3-1].Tree, mBTE_EMPTY ()))); 
} break;
case 1817:
case 699: /* PReal : REAL .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 544; {
# line 3397 "fortran.lalr"
 yySynAttribute.Scan.Ident = MakeIdent ("REAL",4);
       yySynAttribute.Label = NPos (yyAttrStackPtr [1-1]); 
} break;
case 1818: /* Konstante : IntConst .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 543; {
# line 3408 "fortran.lalr"
 yySynAttribute.Tree = mCONST_EXP (mINT_CONSTANT (yyAttrStackPtr [1-1].Scan.IntConst)); 
} break;
case 1819:
case 861: /* Konstante : RealKonstante .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 543; {
# line 3411 "fortran.lalr"
 yySynAttribute.Tree = mCONST_EXP (yyAttrStackPtr [1-1].Tree); 
} break;
case 1820:
case 723: /* Konstante : '(' expression ',' RealKonstante ')' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 543; {
# line 3418 "fortran.lalr"
 if (yyAttrStackPtr [2-1].Tree->Kind == kCONST_EXP)
           yyAttrStackPtr [2-1].Tree = yyAttrStackPtr [2-1].Tree->CONST_EXP.C;
        if (yyAttrStackPtr [2-1].Tree->Kind != kREAL_CONSTANT)
           { printf ("Illegal Complex Constant\\n");
             yyAttrStackPtr [2-1].Tree = mREAL_CONSTANT (PutString("1.0",3));       }
        yySynAttribute.Tree = mCONST_EXP (
                  mCOMPLEX_CONSTANT (yyAttrStackPtr [2-1].Tree->REAL_CONSTANT.value, 
                                     yyAttrStackPtr [4-1].Tree->REAL_CONSTANT.value)); 
} break;
case 1821:
case 692: /* RealKonstante : IntConst '.' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 545; {
# line 3425 "fortran.lalr"
 yySynAttribute.Tree = mREAL_CONSTANT (MakeIntToReal (yyAttrStackPtr [1-1].Scan.IntConst)); 
} break;
case 1822:
case 693: /* RealKonstante : RealConst .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 545; {
# line 3428 "fortran.lalr"
 yySynAttribute.Tree = mREAL_CONSTANT (yyAttrStackPtr [1-1].Scan.StringConst); 
} break;
case 1823:
case 694: /* RealKonstante : DRealConst .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 545; {
# line 3431 "fortran.lalr"
 yySynAttribute.Tree = mDREAL_CONSTANT (yyAttrStackPtr [1-1].Scan.StringConst); 
} break;
case 1824:
case 695: /* Konstante : StringConst .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 543; {
# line 3434 "fortran.lalr"
 yySynAttribute.Tree = mCONST_EXP (mSTRING_CONSTANT (yyAttrStackPtr [1-1].Scan.StringConst)); 
} break;
case 1825:
case 697: /* Konstante : TRUE .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 543; {
# line 3437 "fortran.lalr"
 yySynAttribute.Tree = mCONST_EXP (mBOOL_CONSTANT (1)); 
} break;
case 1826:
case 698: /* Konstante : FALSE .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 543; {
# line 3440 "fortran.lalr"
 yySynAttribute.Tree = mCONST_EXP (mBOOL_CONSTANT (0)); 
} break;
case 1827:
case 878: /* SignedKonstante : Konstante .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 390; {
# line 3445 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [1-1].Tree; 
} break;
case 1828:
case 875: /* SignedKonstante : '+' Konstante .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 390; {
# line 3448 "fortran.lalr"
 yySynAttribute.Tree = yyAttrStackPtr [2-1].Tree; 
} break;
case 1829: /* SignedKonstante : '-' IntConst .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 390; {
# line 3451 "fortran.lalr"
 yySynAttribute.Tree = mCONST_EXP (mINT_CONSTANT (- yyAttrStackPtr [2-1].Scan.IntConst)); 
} break;
case 1830:
case 876: /* SignedKonstante : '-' RealKonstante .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 390; {
# line 3454 "fortran.lalr"
 yySynAttribute.Tree = mOP1_EXP (mOP1_SIGN(), mCONST_EXP (yyAttrStackPtr [2-1].Tree)); 
} break;
}

           /* SPEC State = Next (Top (), Nonterminal); nonterminal transition */
           yyState = * (yyNBasePtr [* yyStateStackPtr ++] + yyNonterminal);
           * yyAttrStackPtr ++ = yySynAttribute;
           if (yyState < yyFirstFinalState) goto ParseLoop; /* read nonterminal reduce ? */
        } 

     } else {                    /* read */
        yyStateStackPtr ++;
        yyGetAttribute (yyAttrStackPtr ++, Attribute);
        yyTerminal = GetToken ();
        yyIsRepairing = false;
     }
      }
   }

static void yyErrorRecovery
# if defined __STDC__ | defined __cplusplus
   (yySymbolRange * yyTerminal, yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr)
# else
   (yyTerminal, yyStateStack, yyStackSize, yyStackPtr)
   yySymbolRange *    yyTerminal    ;
   yyStateRange *    yyStateStack    ;
   unsigned long    yyStackSize    ;
   short        yyStackPtr    ;
# endif
   {
      bool    yyTokensSkipped    ;
      tSet    yyContinueSet    ;
      tSet    yyRestartSet    ;

   /* 1. report an error */
      ErrorMessage (yySyntaxError, yyError, Attribute.Position);

   /* 2. report the set of expected terminal symbols */
      MakeSet (& yyContinueSet, (short) yyLastTerminal);
      yyComputeContinuation (yyStateStack, yyStackSize, yyStackPtr, & yyContinueSet);
      ErrorMessageI (yyExpectedTokens, yyInformation, Attribute.Position,
     yyTokenSet, (char *) & yyContinueSet);
      ReleaseSet (& yyContinueSet);

   /* 3. compute the set of terminal symbols for restart of the parse */
      MakeSet (& yyRestartSet, (short) yyLastTerminal);
      yyComputeRestartPoints (yyStateStack, yyStackSize, yyStackPtr, & yyRestartSet);

   /* 4. skip terminal symbols until a restart point is reached */
      yyTokensSkipped = false;
      while (! IsElement (* yyTerminal, & yyRestartSet)) {
     * yyTerminal = GetToken ();
     yyTokensSkipped = true;
      }
      ReleaseSet (& yyRestartSet);

   /* 5. report the restart point */
      if (yyTokensSkipped) {
     ErrorMessage (yyRestartPoint, yyInformation, Attribute.Position);
      }
   }

/*
   compute the set of terminal symbols that can be accepted (read)
   in a given stack configuration (eventually after reduce actions)
*/

static void yyComputeContinuation
# if defined __STDC__ | defined __cplusplus
   (yyStateRange * yyStack, unsigned long yyStackSize, short yyStackPtr, tSet * yyContinueSet)
# else
   (yyStack, yyStackSize, yyStackPtr, yyContinueSet)
   yyStateRange *    yyStack        ;
   unsigned long    yyStackSize    ;
   short        yyStackPtr    ;
   tSet *        yyContinueSet    ;
# endif
   {
      register yySymbolRange    yyTerminal;
      register yyStateRange    yyState = yyStack [yyStackPtr];

      AssignEmpty (yyContinueSet);
      for (yyTerminal = yyFirstTerminal; yyTerminal <= yyLastTerminal; yyTerminal ++) {
     if (yyNext (yyState, yyTerminal) != yyNoState &&
        yyIsContinuation (yyTerminal, yyStack, yyStackSize, yyStackPtr)) {
        Include (yyContinueSet, (short) yyTerminal);
     }
      }
   }

/*
   check whether a given terminal symbol can be accepted (read)
   in a certain stack configuration (eventually after reduce actions)
*/

static bool yyIsContinuation
# if defined __STDC__ | defined __cplusplus
   (yySymbolRange yyTerminal, yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr)
# else
   (yyTerminal, yyStateStack, yyStackSize, yyStackPtr)
   yySymbolRange    yyTerminal    ;
   yyStateRange *    yyStateStack    ;
   unsigned long    yyStackSize    ;
   short        yyStackPtr    ;
# endif
   {
      register yyStateRange    yState        ;
      register yySymbolRange    yyNonterminal    ;
           yyStateRange *    yyStack        ;
   
      MakeArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));    /* pass Stack by value */
# ifdef BCOPY
      bcopy ((char *) yyStateStack, (char *) yyStack, (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# else
      (void) memcpy ((char *) yyStack, (char *) yyStateStack, (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# endif

      yState = yyStack [yyStackPtr];
      for (;;) {
     yyStack [yyStackPtr] = yState;
     yState = yyNext (yState, yyTerminal);
     if (yState == yyNoState) {
        ReleaseArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
        return false;
     }
     if (yState <= yyLastReadTermState) {        /* read or read terminal reduce ? */
        ReleaseArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
        return true;
     }

     for (;;) {                    /* reduce */
        if (yState == yyStopState) {
           ReleaseArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
           return true;
        } else { 
           yyStackPtr -= yyLength [yState - yyFirstReduceState];
           yyNonterminal = yyLeftHandSide [yState - yyFirstReduceState];
        }

        yState = yyNext (yyStack [yyStackPtr], yyNonterminal);
        if (yyStackPtr >= yyStackSize) {
           ExtendArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
        }
        yyStackPtr ++;
        if (yState < yyFirstFinalState) break;    /* read nonterminal ? */
        yState = yyFinalToProd [yState - yyFirstReadTermState];    /* read nonterminal reduce */
     }
      }
   }

/*
   compute a set of terminal symbols that can be used to restart
   parsing in a given stack configuration. we simulate parsing until
   end of file using a suffix program synthesized by the function
   Continuation. All symbols acceptable in the states reached during
   the simulation can be used to restart parsing.
*/

static void yyComputeRestartPoints
# if defined __STDC__ | defined __cplusplus
   (yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr, tSet * yyRestartSet)
# else
   (yyStateStack, yyStackSize, yyStackPtr, yyRestartSet)
   yyStateRange *    yyStateStack    ;
   unsigned long    yyStackSize    ;
   short        yyStackPtr    ;
   tSet *        yyRestartSet    ;
# endif
   {
      register yyStateRange    yState        ;
      register yySymbolRange    yyNonterminal    ;
           yyStateRange *    yyStack        ;
           tSet        yyContinueSet    ;
   
      MakeArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange)); /* pass Stack by value */
# ifdef BCOPY
      bcopy ((char *) yyStateStack, (char *) yyStack, (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# else
      (void) memcpy ((char *) yyStack, (char *) yyStateStack, (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# endif

      MakeSet (& yyContinueSet, (short) yyLastTerminal);
      AssignEmpty (yyRestartSet);
      yState = yyStack [yyStackPtr];

      for (;;) {
     if (yyStackPtr >= yyStackSize) {
        ExtendArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
     }
     yyStack [yyStackPtr] = yState;
     yyComputeContinuation (yyStack, yyStackSize, yyStackPtr, & yyContinueSet);
     Union (yyRestartSet, & yyContinueSet);
     yState = yyNext (yState, yyContinuation [yState]);

     if (yState >= yyFirstFinalState) {        /* final state ? */
        if (yState <= yyLastReadTermState) {    /* read terminal reduce ? */
           yyStackPtr ++;
           yState = yyFinalToProd [yState - yyFirstReadTermState];
        }

        for (;;) {                    /* reduce */
           if (yState == yyStopState) {
          ReleaseSet (& yyContinueSet);
          ReleaseArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
          return;
           } else { 
          yyStackPtr -= yyLength [yState - yyFirstReduceState];
          yyNonterminal = yyLeftHandSide [yState - yyFirstReduceState];
           }

           yState = yyNext (yyStack [yyStackPtr], yyNonterminal);
           yyStackPtr ++;
           if (yState < yyFirstFinalState) break;    /* read nonterminal ? */
           yState = yyFinalToProd [yState - yyFirstReadTermState]; /* read nonterminal reduce */
        }
     } else {                    /* read */
        yyStackPtr ++;
     }
      }
   }

/* access the parse table:   Next : State x Symbol -> Action */

static yyStateRange yyNext
# if defined __STDC__ | defined __cplusplus
   (yyStateRange yyState, yySymbolRange yySymbol)
# else
   (yyState, yySymbol) yyStateRange yyState; yySymbolRange yySymbol;
# endif
   {
      register yyTCombType * yyTCombPtr;

      if (yySymbol <= yyLastTerminal) {
     for (;;) {
        yyTCombPtr = yyTBasePtr [yyState] + yySymbol;
        if (yyTCombPtr->Check != yyState) {
           if ((yyState = yyDefault [yyState]) == yyNoState) return yyNoState;
        } else {
           return yyTCombPtr->Next;
        }
     }
      } else {
    return * (yyNBasePtr [yyState] + yySymbol);
      }
   }

static void BeginParser ()
   {
# line 164 "fortran.lalr"

  BeginScanner ();
  ParsePosErrors = 0;

   }

void CloseParser ()
   {

   }
