# include "SemExp.h"
# include "yySExp.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 46 "SemExp.puma"

# include "Idents.h"
# include "StringMe.h"
# include "protocol.h"

# include "Types.h"
# include "ShowDefs.h"

bool IsAllocated (); /* global used from Semantic.puma */
void SemanticCall (); /* global used from Semantic.puma */

int   Nesting;          /* actual nesting depth */
tTree Nest[MAXLoops];   /* actual loops of loop nesting */



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemExp, routine %s failed\n", yyFunction);
 exit (1);
}

void SemExp ARGS((tTree t, int * ResultRank));
static void SemIndexList ARGS((tTree t, int * ResultRank));
void SemExpList ARGS((tTree t));
static void SemIntrParamList ARGS((tTree t, int * ResultRank));
void SemParamList ARGS((tTree t));
static void AnalIntrinsicFunction ARGS((tIdent name, tTree params, int * ResultRank));
static void CheckMerge ARGS((tTree params, int * ResultRank));
static void CheckCShift ARGS((tTree params, int * ResultRank));
static void CheckTranspose ARGS((tTree params, int * ResultRank));
static void CheckSpread ARGS((tTree params, int * ResultRank));
static void CheckRed ARGS((tTree params, int * ResultRank));
static bool IsCurrentLoopVar ARGS((tTree t));
static tTree CheckNamedParameters ARGS((tTree t));
static void DefineNamedParameters ARGS((tTree t));
static tTree GetUnnamedParameters ARGS((tTree t));

void SemExp
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int * ResultRank)
# else
(t, ResultRank)
 register tTree t;
 register int * ResultRank;
# endif
{
  if (t == NoTree) return;

  switch (t->Kind) {
  case kUSED_VAR:
# line 81 "SemExp.puma"
 {
  int yyV1;
  {
# line 83 "SemExp.puma"
 if (IsCurrentLoopVar (t))
         t->Kind = kLOOP_VAR;

# line 87 "SemExp.puma"
   SemExp (t->USED_VAR.VARNAME, & yyV1);
  }
   * ResultRank = yyV1;
   return;
 }

  case kLOOP_VAR:
# line 90 "SemExp.puma"
 {
  int yyV1;
  {
# line 91 "SemExp.puma"
   SemExp (t->LOOP_VAR.LOOP_VARNAME, & yyV1);
  }
   * ResultRank = yyV1;
   return;
 }

  case kSELECTED_VAR:
# line 94 "SemExp.puma"
 {
  int yyV1;
  {
# line 95 "SemExp.puma"
   SemExp (t->SELECTED_VAR.SELEC_VAR, & yyV1);
  }
   * ResultRank = yyV1 + VarRank (t->SELECTED_VAR.SELECTOR->REC_COMP.Object);
   return;
 }

  case kSUBSTRING_VAR:
# line 98 "SemExp.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 100 "SemExp.puma"
   SemExp (t->SUBSTRING_VAR.IND_VAR, & yyV1);
# line 101 "SemExp.puma"
 if (yyV1 != 0)
        { error_protocol ("rank of string variable > 0");
          tree_protocol ("string variable is ", t);
        }

# line 106 "SemExp.puma"
   SemExp (t->SUBSTRING_VAR.IND_EXP, & yyV2);
  }
   * ResultRank = 0;
   return;
 }

  case kINDEXED_VAR:
# line 109 "SemExp.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 111 "SemExp.puma"
   SemExp (t->INDEXED_VAR.IND_VAR, & yyV1);
# line 112 "SemExp.puma"
 if (yyV1 != TreeListLength (t->INDEXED_VAR.IND_EXPS))
        { error_protocol ("Illegal number of indexes");
          tree_protocol ("Indexed variable is ", t);
        }

# line 117 "SemExp.puma"
   SemIndexList (t->INDEXED_VAR.IND_EXPS, & yyV2);
  }
   * ResultRank = yyV2;
   return;
 }

  case kVAR_OBJ:
# line 120 "SemExp.puma"
 {
  int rank;
  {
# line 122 "SemExp.puma"

# line 124 "SemExp.puma"
 if (t->VAR_OBJ.Object == NoObject)
        { error_protocol ("No object for use of variable found");
          tree_protocol ("Variable is ", t);
          rank = 0;
        }
      else if (t->VAR_OBJ.Object != GetGlobalDecl (t->VAR_OBJ.Ident))
        { error_protocol ("var name has become a function name");
          obj_error_protocol ("var has obj = ", t->VAR_OBJ.Object);
          obj_error_protocol ("table has obj = ", GetGlobalDecl(t->VAR_OBJ.Ident));
          rank = 0;
        }
       else
        { rank = VarRank (t->VAR_OBJ.Object);


          if (IsVarAllocatable (t->VAR_OBJ.Object))
           { if (!IsAllocated (t->VAR_OBJ.Ident))
              { error_protocol ("Allocatable Variable used before allocate");
                tree_protocol ("Variable is ", t);
              }
           }
        }

  }
   * ResultRank = rank;
   return;
 }

  case kDUMMY_EXP:
# line 156 "SemExp.puma"
   * ResultRank = 0;
   return;

  case kCONST_EXP:
# line 159 "SemExp.puma"
   * ResultRank = 0;
   return;

  case kARRAY_EXP:
# line 162 "SemExp.puma"
  {
# line 163 "SemExp.puma"
   SemExpList (t->ARRAY_EXP.ELEMENTS);
  }
   * ResultRank = 1;
   return;

  case kSLICE_EXP:
# line 166 "SemExp.puma"
 {
  int yyV1;
  int yyV2;
  int yyV3;
  {
# line 168 "SemExp.puma"
   SemExp (t->SLICE_EXP.START, & yyV1);
# line 169 "SemExp.puma"
 if (yyV1 != 0)
        { error_protocol ("Start in Slice has illegal rank");
          tree_protocol  ("Expression is ", t->SLICE_EXP.START);
        }

# line 175 "SemExp.puma"
   SemExp (t->SLICE_EXP.STOP, & yyV2);
# line 176 "SemExp.puma"
 if (yyV2 != 0)
        { error_protocol ("Stop in Slice has illegal rank");
          tree_protocol  ("Expression is ", t->SLICE_EXP.STOP);
        }

# line 182 "SemExp.puma"
   SemExp (t->SLICE_EXP.INC, & yyV3);
# line 183 "SemExp.puma"
 if (yyV3 != 0)
        { error_protocol ("Increment in Slice has illegal rank");
          tree_protocol  ("Expression is ", t->SLICE_EXP.INC);
        }

  }
   * ResultRank = 1;
   return;
 }

  case kOP_EXP:
# line 190 "SemExp.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 192 "SemExp.puma"
   SemExp (t->OP_EXP.OPND1, & yyV1);
# line 193 "SemExp.puma"
   SemExp (t->OP_EXP.OPND2, & yyV2);
# line 195 "SemExp.puma"
 if (yyV1 == 0)
        yyV1 = yyV2;
      else if (yyV2 == 0)
        yyV1 = yyV1;
      else if (yyV1 != yyV2)
        { error_protocol ("Rank Error for binary expression");
          tree_protocol ("Expression is : ", t);
        }

  }
   * ResultRank = yyV1;
   return;
 }

  case kOP1_EXP:
# line 206 "SemExp.puma"
 {
  int yyV1;
  {
# line 207 "SemExp.puma"
   SemExp (t->OP1_EXP.OPND, & yyV1);
  }
   * ResultRank = yyV1;
   return;
 }

  case kTYPE_EXP:
# line 210 "SemExp.puma"
  {
# line 211 "SemExp.puma"
   SemExpList (t->TYPE_EXP.ELEMENTS);
  }
   * ResultRank = 0;
   return;

  case kVAR_EXP:
# line 214 "SemExp.puma"
 {
  int yyV1;
  {
# line 215 "SemExp.puma"
   SemExp (t->VAR_EXP.V, & yyV1);
  }
   * ResultRank = yyV1;
   return;
 }

  case kDO_EXP:
# line 218 "SemExp.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 219 "SemExp.puma"
   SemExp (t->DO_EXP.DO_ID, & yyV1);
# line 220 "SemExp.puma"
   SemExp (t->DO_EXP.RANGE, & yyV2);
# line 221 "SemExp.puma"
   SemExpList (t->DO_EXP.BODY);
  }
   * ResultRank = 1;
   return;
 }

  case kFUNC_CALL_EXP:
# line 224 "SemExp.puma"
 {
  int rank;
  int len;
  {
# line 226 "SemExp.puma"
   if (! (IsIntrFunc (t) == true)) goto yyL16;
  {
# line 228 "SemExp.puma"

# line 229 "SemExp.puma"

# line 231 "SemExp.puma"
   len = TreeListLength (t->FUNC_CALL_EXP.FUNC_PARAMS);
# line 232 "SemExp.puma"
 if (IntrFuncKind1 (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))
       { if (len != 1)
         { error_protocol ("One parameter for function call is required");
           tree_protocol ("Function call is : ", t);
         }
         SemIntrParamList (t->FUNC_CALL_EXP.FUNC_PARAMS, &rank);
       }
     else if (IntrFuncKind2 (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))
       { if (len != 2)
         { error_protocol ("Two parameters for function call are required");
           tree_protocol ("Function call is : ", t);
         }
         SemIntrParamList (t->FUNC_CALL_EXP.FUNC_PARAMS, &rank);
       }
     else if (IntrFuncKindn (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))
       { if (len < 1)
         { error_protocol ("No parameter in intrinsic function");
           tree_protocol ("Function call is : ", t);
         }
         SemIntrParamList (t->FUNC_CALL_EXP.FUNC_PARAMS, &rank);
       }
     else
       { t->FUNC_CALL_EXP.FUNC_PARAMS = GetUnnamedParameters (t->FUNC_CALL_EXP.FUNC_PARAMS);
         AnalIntrinsicFunction (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, t->FUNC_CALL_EXP.FUNC_PARAMS, &rank);
       }

  }
  }
   * ResultRank = rank;
   return;
 }
yyL16:;

# line 260 "SemExp.puma"
  {
# line 263 "SemExp.puma"
   SemanticCall (t, t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object);
  }
   * ResultRank = 0;
   return;

  case kVAR_PARAM:
# line 272 "SemExp.puma"
 {
  int yyV1;
  {
# line 274 "SemExp.puma"
   SemExp (t->VAR_PARAM.V, & yyV1);
  }
   * ResultRank = yyV1;
   return;
 }

  case kNAMED_PARAM:
# line 277 "SemExp.puma"
 {
  int yyV1;
  {
# line 279 "SemExp.puma"
   SemExp (t->NAMED_PARAM.VAL, & yyV1);
  }
   * ResultRank = yyV1;
   return;
 }

  case kPROC_PARAM:
# line 282 "SemExp.puma"
   * ResultRank = 0;
   return;

  case kADDR:
# line 285 "SemExp.puma"
 {
  int yyV1;
  {
# line 286 "SemExp.puma"
   SemExp (t->ADDR.E, & yyV1);
  }
   * ResultRank = yyV1;
   return;
 }

  }

# line 289 "SemExp.puma"
  {
# line 290 "SemExp.puma"
 error_protocol ("Unknown Tree Node for SemExp");
     printf ("Unknown Tree Node in SemExp");
     FileUnparse (stdout, t);
     WriteTree (stdout, t);
     kill_in_protocol ();

  }
   * ResultRank = 0;
   return;

;
}

static void SemIndexList
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int * ResultRank)
# else
(t, ResultRank)
 register tTree t;
 register int * ResultRank;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBTE_LIST) {
# line 315 "SemExp.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 317 "SemExp.puma"
   SemExp (t->BTE_LIST.Elem, & yyV1);
# line 318 "SemExp.puma"
 if (yyV1 > 1)
       { error_protocol ("Illegal Rank of an Index");
         tree_protocol  ("Index is : ", t->BTE_LIST.Elem);
       }

# line 323 "SemExp.puma"
   SemIndexList (t->BTE_LIST.Next, & yyV2);
  }
   * ResultRank = yyV2 + yyV1;
   return;
 }

  }
  if (t->Kind == kBTE_EMPTY) {
# line 326 "SemExp.puma"
   * ResultRank = 0;
   return;

  }
# line 329 "SemExp.puma"
  {
# line 330 "SemExp.puma"
   error_protocol ("Illegal Call of SemIndexList");
# line 331 "SemExp.puma"
   printf ("Illegal Call of SemIndexList, Tree : ");
# line 332 "SemExp.puma"
   FileUnparse (stdout, t);
# line 333 "SemExp.puma"
   WriteTree (stdout, t);
# line 334 "SemExp.puma"
   kill_in_protocol ();
  }
   * ResultRank = 0;
   return;

;
}

void SemExpList
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBTE_LIST) {
# line 347 "SemExp.puma"
 {
  int yyV1;
  {
# line 349 "SemExp.puma"
   SemExp (t->BTE_LIST.Elem, & yyV1);
# line 350 "SemExp.puma"
   SemExpList (t->BTE_LIST.Next);
  }
   return;
 }

  }
  if (t->Kind == kBTE_EMPTY) {
# line 353 "SemExp.puma"
   return;

  }
# line 356 "SemExp.puma"
  {
# line 357 "SemExp.puma"
   error_protocol ("Illegal Call of SemExpList");
# line 358 "SemExp.puma"
   printf ("Illegal Call of SemExpList, Tree : ");
# line 359 "SemExp.puma"
   FileUnparse (stdout, t);
# line 360 "SemExp.puma"
   WriteTree (stdout, t);
# line 361 "SemExp.puma"
   kill_in_protocol ();
  }
   return;

;
}

static void SemIntrParamList
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int * ResultRank)
# else
(t, ResultRank)
 register tTree t;
 register int * ResultRank;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBTP_LIST) {
# line 372 "SemExp.puma"
 {
  int rank;
  int yyV1;
  int yyV2;
  {
# line 374 "SemExp.puma"

# line 376 "SemExp.puma"
   SemExp (t->BTP_LIST.Elem, & yyV1);
# line 377 "SemExp.puma"
   SemIntrParamList (t->BTP_LIST.Next, & yyV2);
# line 379 "SemExp.puma"
 if (yyV1 == 0)
        rank = yyV2;
     else if (yyV2 == 0)
        rank = yyV1;
     else if (yyV1 == yyV2)
        rank = yyV1;
     else
        { error_protocol ("Illegal Rank combination in Parameter List");
          tree_protocol ("parameter list is ", t);
        };

  }
   * ResultRank = rank;
   return;
 }

  }
  if (t->Kind == kBTP_EMPTY) {
# line 392 "SemExp.puma"
   * ResultRank = 0;
   return;

  }
# line 395 "SemExp.puma"
  {
# line 396 "SemExp.puma"
   error_protocol ("Illegal Call of SemIntrParamList");
# line 397 "SemExp.puma"
   printf ("Illegal Call of SemIntrParamList, Tree : ");
# line 398 "SemExp.puma"
   FileUnparse (stdout, t);
# line 399 "SemExp.puma"
   WriteTree (stdout, t);
# line 400 "SemExp.puma"
   kill_in_protocol ();
  }
   * ResultRank = 0;
   return;

;
}

void SemParamList
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBTP_LIST) {
# line 405 "SemExp.puma"
 {
  int yyV1;
  {
# line 407 "SemExp.puma"
   SemExp (t->BTP_LIST.Elem, & yyV1);
# line 408 "SemExp.puma"
   SemParamList (t->BTP_LIST.Next);
  }
   return;
 }

  }
  if (t->Kind == kBTP_EMPTY) {
# line 411 "SemExp.puma"
   return;

  }
# line 414 "SemExp.puma"
  {
# line 415 "SemExp.puma"
   error_protocol ("Illegal Call of SemParamList");
# line 416 "SemExp.puma"
   printf ("Illegal Call of SemParamList, Tree : ");
# line 417 "SemExp.puma"
   FileUnparse (stdout, t);
# line 418 "SemExp.puma"
   WriteTree (stdout, t);
# line 419 "SemExp.puma"
   kill_in_protocol ();
  }
   return;

;
}

static void AnalIntrinsicFunction
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params, register int * ResultRank)
# else
(name, params, ResultRank)
 register tIdent name;
 register tTree params;
 register int * ResultRank;
# endif
{
# line 431 "SemExp.puma"

int no;

  if (params == NoTree) return;
# line 437 "SemExp.puma"
 {
  int yyV1;
  {
# line 439 "SemExp.puma"
   if (! (IntrFuncRed (name) == true)) goto yyL1;
  {
# line 441 "SemExp.puma"
   SemParamList (params);
# line 442 "SemExp.puma"
   CheckRed (params, & yyV1);
  }
  }
   * ResultRank = yyV1;
   return;
 }
yyL1:;

  if (equaltIdent (name, MakeIdent ("MINLOC", 6))) {
# line 445 "SemExp.puma"
  {
# line 446 "SemExp.puma"
   SemParamList (params);
# line 447 "SemExp.puma"
   error_protocol ("MINLOC is not supported until now");
  }
   * ResultRank = 0;
   return;

  }
  if (equaltIdent (name, MakeIdent ("MAXLOC", 6))) {
# line 450 "SemExp.puma"
  {
# line 451 "SemExp.puma"
   SemParamList (params);
# line 452 "SemExp.puma"
   error_protocol ("MAXLOC is not supported until now");
  }
   * ResultRank = 0;
   return;

  }
 {
  int len;
  int rank;
  if (equaltIdent (name, MakeIdent ("SPREAD", 6))) {
# line 455 "SemExp.puma"
  {
# line 457 "SemExp.puma"

# line 458 "SemExp.puma"

# line 460 "SemExp.puma"
   SemParamList (params);
# line 461 "SemExp.puma"
 len = TreeListLength (params);
      if (len != 3)
        error_protocol ("SPREAD has not three parameters");
      if (len >= 1)
        rank = TreeRank (params->BTP_LIST.Elem) + 1;
       else
        rank = 0;

  }
   * ResultRank = rank;
   return;

  }
 }
 {
  int yyV1;
  if (equaltIdent (name, MakeIdent ("CSHIFT", 6))) {
# line 471 "SemExp.puma"
  {
# line 472 "SemExp.puma"
   CheckCShift (params, & yyV1);
  }
   * ResultRank = yyV1;
   return;

  }
 }
 {
  int yyV1;
  if (equaltIdent (name, MakeIdent ("TRANSPOSE", 9))) {
# line 475 "SemExp.puma"
  {
# line 476 "SemExp.puma"
   CheckTranspose (params, & yyV1);
  }
   * ResultRank = yyV1;
   return;

  }
 }
  if (equaltIdent (name, MakeIdent ("DOTPRODUCT", 10))) {
# line 479 "SemExp.puma"
  {
# line 480 "SemExp.puma"
   SemParamList (params);
# line 481 "SemExp.puma"
   error_protocol ("DOTPRODUCT is not supported until now");
  }
   * ResultRank = 0;
   return;

  }
  if (equaltIdent (name, MakeIdent ("MATMUL", 6))) {
# line 484 "SemExp.puma"
  {
# line 485 "SemExp.puma"
   SemParamList (params);
# line 486 "SemExp.puma"
   error_protocol ("MATMUL is not supported until now");
  }
   * ResultRank = 0;
   return;

  }
 {
  int yyV1;
  if (equaltIdent (name, MakeIdent ("MERGE", 5))) {
# line 489 "SemExp.puma"
  {
# line 490 "SemExp.puma"
   CheckMerge (params, & yyV1);
  }
   * ResultRank = yyV1;
   return;

  }
 }
  if (equaltIdent (name, MakeIdent ("EOSHIFT", 7))) {
# line 493 "SemExp.puma"
  {
# line 494 "SemExp.puma"
   SemParamList (params);
# line 495 "SemExp.puma"
   error_protocol ("EOSHIFT is not supported until now");
  }
   * ResultRank = 0;
   return;

  }
  if (equaltIdent (name, MakeIdent ("DIAGONAL", 8))) {
# line 498 "SemExp.puma"
  {
# line 499 "SemExp.puma"
   SemParamList (params);
# line 500 "SemExp.puma"
   error_protocol ("DIAGONAL ist not supported until now");
  }
   * ResultRank = 0;
   return;

  }
  if (equaltIdent (name, MakeIdent ("PACK", 4))) {
# line 503 "SemExp.puma"
  {
# line 504 "SemExp.puma"
   SemParamList (params);
# line 505 "SemExp.puma"
   error_protocol ("PACK ist not supported until now");
  }
   * ResultRank = 0;
   return;

  }
  if (equaltIdent (name, MakeIdent ("UNPACK", 6))) {
# line 508 "SemExp.puma"
  {
# line 509 "SemExp.puma"
   SemParamList (params);
# line 510 "SemExp.puma"
   error_protocol ("UNPACK ist not supported until now");
  }
   * ResultRank = 0;
   return;

  }
# line 513 "SemExp.puma"
  {
# line 514 "SemExp.puma"
   SemParamList (params);
# line 515 "SemExp.puma"
   error_protocol ("Unknown intrinsic Function in Semantic Analysis");
  }
   * ResultRank = 0;
   return;

;
}

static void CheckMerge
# if defined __STDC__ | defined __cplusplus
(register tTree params, register int * ResultRank)
# else
(params, ResultRank)
 register tTree params;
 register int * ResultRank;
# endif
{
  if (params == NoTree) return;
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 526 "SemExp.puma"
 {
  int yyV1;
  int yyV2;
  int yyV3;
  {
# line 528 "SemExp.puma"
   SemExp (params->BTP_LIST.Elem, & yyV1);
# line 529 "SemExp.puma"
   SemExp (params->BTP_LIST.Next->BTP_LIST.Elem, & yyV2);
# line 530 "SemExp.puma"
 if (yyV1 != yyV2)
       error_protocol ("Parameters in MERGE have different rank");

# line 533 "SemExp.puma"
   SemExp (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, & yyV3);
# line 534 "SemExp.puma"
 if (yyV1 != yyV3)
       error_protocol ("Mask in MERGE has wrong rank");

  }
   * ResultRank = yyV1;
   return;
 }

  }
  }
  }
  }
# line 539 "SemExp.puma"
  {
# line 540 "SemExp.puma"
   error_protocol ("MERGE has not three Parameters");
  }
   * ResultRank = 0;
   return;

;
}

static void CheckCShift
# if defined __STDC__ | defined __cplusplus
(register tTree params, register int * ResultRank)
# else
(params, ResultRank)
 register tTree params;
 register int * ResultRank;
# endif
{
  if (params == NoTree) return;
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 551 "SemExp.puma"
 {
  int yyV1;
  int yyV2;
  int yyV3;
  {
# line 553 "SemExp.puma"
   SemExp (params->BTP_LIST.Elem, & yyV1);
# line 554 "SemExp.puma"
   SemExp (params->BTP_LIST.Next->BTP_LIST.Elem, & yyV2);
# line 555 "SemExp.puma"
 if (yyV2 != 0)
       error_protocol ("Dim Parameter in CSHIFT is not a scalar");

# line 558 "SemExp.puma"
   SemExp (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, & yyV3);
# line 559 "SemExp.puma"
 if (yyV3 != 0)
       error_protocol ("Shift Parameter in CSHIFT is not a scalar");

  }
   * ResultRank = yyV1;
   return;
 }

  }
  }
  }
  }
# line 564 "SemExp.puma"
  {
# line 565 "SemExp.puma"
   error_protocol ("CSHIFT has not three Parameters");
  }
   * ResultRank = 0;
   return;

;
}

static void CheckTranspose
# if defined __STDC__ | defined __cplusplus
(register tTree params, register int * ResultRank)
# else
(params, ResultRank)
 register tTree params;
 register int * ResultRank;
# endif
{
  if (params == NoTree) return;
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 576 "SemExp.puma"
 {
  int yyV1;
  {
# line 578 "SemExp.puma"
   SemExp (params->BTP_LIST.Elem, & yyV1);
# line 579 "SemExp.puma"
 if (yyV1 != 2)
       error_protocol ("Array in transpose must be two-dimensional");

  }
   * ResultRank = yyV1;
   return;
 }

  }
  }
# line 584 "SemExp.puma"
  {
# line 585 "SemExp.puma"
   error_protocol ("TRANSPOSE has not one Parameter");
  }
   * ResultRank = 0;
   return;

;
}

static void CheckSpread
# if defined __STDC__ | defined __cplusplus
(register tTree params, register int * ResultRank)
# else
(params, ResultRank)
 register tTree params;
 register int * ResultRank;
# endif
{
  if (params == NoTree) return;
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 596 "SemExp.puma"
 {
  int yyV1;
  int yyV2;
  int yyV3;
  {
# line 598 "SemExp.puma"
   SemExp (params->BTP_LIST.Elem, & yyV1);
# line 599 "SemExp.puma"
   SemExp (params->BTP_LIST.Next->BTP_LIST.Elem, & yyV2);
# line 600 "SemExp.puma"
 if (yyV2 != 0)
       error_protocol ("Dim Parameter in CSHIFT is not a scalar");

# line 603 "SemExp.puma"
   SemExp (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, & yyV3);
# line 604 "SemExp.puma"
 if (yyV3 != 0)
       error_protocol ("Shift Parameter in CSHIFT is not a scalar");

  }
   * ResultRank = yyV1 + 1;
   return;
 }

  }
  }
  }
  }
# line 609 "SemExp.puma"
  {
# line 610 "SemExp.puma"
   error_protocol ("SPREAD has not three Parameters");
  }
   * ResultRank = 0;
   return;

;
}

static void CheckRed
# if defined __STDC__ | defined __cplusplus
(register tTree params, register int * ResultRank)
# else
(params, ResultRank)
 register tTree params;
 register int * ResultRank;
# endif
{
  if (params == NoTree) return;
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 624 "SemExp.puma"
 {
  int yyV1;
  {
# line 625 "SemExp.puma"
   SemExp (params->BTP_LIST.Elem, & yyV1);
# line 626 "SemExp.puma"
 if (yyV1 <= 0)
        error_protocol ("reduction: first parameter must be an array");

  }
   * ResultRank = 0;
   return;
 }

  }
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 631 "SemExp.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 632 "SemExp.puma"
   SemExp (params->BTP_LIST.Elem, & yyV1);
# line 633 "SemExp.puma"
   SemExp (params->BTP_LIST.Next->BTP_LIST.Elem, & yyV2);
# line 634 "SemExp.puma"
 if (yyV1 <= 0)
        error_protocol ("reduction: first parameter must be an array");

# line 637 "SemExp.puma"
   if (! (yyV2 == 0)) goto yyL2;
  }
   * ResultRank = yyV1 - 1;
   return;
 }
yyL2:;

# line 640 "SemExp.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 641 "SemExp.puma"
   SemExp (params->BTP_LIST.Elem, & yyV1);
# line 642 "SemExp.puma"
   SemExp (params->BTP_LIST.Next->BTP_LIST.Elem, & yyV2);
# line 643 "SemExp.puma"
 if (yyV1 <= 0)
        error_protocol ("reduction: first parameter must be an array");
     if (yyV2 != yyV1)
       error_protocol ("reduction: mask has not same rank as array");

  }
   * ResultRank = 0;
   return;
 }

  }
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 650 "SemExp.puma"
 {
  int yyV1;
  int yyV2;
  int yyV3;
  {
# line 651 "SemExp.puma"
   SemExp (params->BTP_LIST.Elem, & yyV1);
# line 652 "SemExp.puma"
   SemExp (params->BTP_LIST.Next->BTP_LIST.Elem, & yyV2);
# line 653 "SemExp.puma"
   SemExp (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, & yyV3);
# line 654 "SemExp.puma"
 if (yyV1 <= 0)
        error_protocol ("reduction: first parameter must be an array");
     if (yyV2 != 0)
       error_protocol ("reduction: dim is not a scalar");
     if (yyV3 != yyV1)
       error_protocol ("reduction: mask has not same rank as array");

  }
   * ResultRank = yyV1 - 1;
   return;
 }

  }
  }
  }
  }
# line 663 "SemExp.puma"
  {
# line 664 "SemExp.puma"
   error_protocol ("reduction: has not one - three Parameters");
  }
   * ResultRank = 0;
   return;

;
}

static bool IsCurrentLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return false;
  if (t->Kind == kUSED_VAR) {
# line 676 "SemExp.puma"
 {
  bool found;
  int i;
  tTree lv;
  {
# line 678 "SemExp.puma"

# line 679 "SemExp.puma"

# line 680 "SemExp.puma"

# line 682 "SemExp.puma"

      found = false;
      i     = 0;
      while ((!found) && (i < Nesting))
         { if (Nest[i]->Kind == kACF_DOALL)
              lv = Nest[i]->ACF_DOALL.DOALL_ID;
            else if (Nest[i]->Kind == kACF_FORALL)
              lv = Nest[i]->ACF_FORALL.FORALL_ID;
            else if (Nest[i]->Kind == kACF_DOLOCAL)
              lv = Nest[i]->ACF_DOLOCAL.DOLOCAL_ID;
            else
              lv = Nest[i]->ACF_DO.DO_ID;
           lv = lv->LOOP_VAR.LOOP_VARNAME;
           found = EqualExpression (t->USED_VAR.VARNAME, lv);
           i += 1;
         }

# line 699 "SemExp.puma"
   if (! (found)) goto yyL1;
  }
   return true;
 }
yyL1:;

  }
  if (t->Kind == kLOOP_VAR) {
# line 702 "SemExp.puma"
   return true;

  }
  return false;
}

static tTree CheckNamedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 721 "SemExp.puma"
  {
# line 722 "SemExp.puma"
   DefineNamedParameters (t);
  }
   return GetUnnamedParameters (t);

}

static void DefineNamedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
# line 728 "SemExp.puma"
  {
# line 729 "SemExp.puma"
   DefineNamedParameters (t->BTP_LIST.Next);
  }
   return;

  }
# line 732 "SemExp.puma"
  {
# line 734 "SemExp.puma"
   DefineNamedParameters (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->Kind == kBTP_EMPTY) {
# line 737 "SemExp.puma"
   return;

  }
# line 740 "SemExp.puma"
  {
# line 741 "SemExp.puma"
   printf ("Illegal Call of DefineNamedParameters\n");
# line 742 "SemExp.puma"
   WriteTree (stdout, t);
# line 743 "SemExp.puma"
   kill_in_protocol ();
  }
   return;

;
}

static tTree GetUnnamedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
# line 748 "SemExp.puma"
  {
# line 749 "SemExp.puma"
 t->BTP_LIST.Elem = t->BTP_LIST.Elem->NAMED_PARAM.VAL;
     t->BTP_LIST.Next = GetUnnamedParameters (t->BTP_LIST.Next);

  }
   return t;

  }
# line 755 "SemExp.puma"
  {
# line 757 "SemExp.puma"
 t->BTP_LIST.Next = GetUnnamedParameters (t->BTP_LIST.Next);
  }
   return t;

  }
  if (t->Kind == kBTP_EMPTY) {
# line 761 "SemExp.puma"
   return t;

  }
 yyAbort ("GetUnnamedParameters");
}

void BeginSemExp ()
{
}

void CloseSemExp ()
{
}
