# include "Analysi.h"
# include "yyAAnaly.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 65 "AdaptAnalysis.puma"


# include "Idents.h"
# include "StringMe.h"

# include "protocol.h"

# include "ShowDefs.h"
# include "Types.h"

# include "Globals.h"  /* AdaptAnalSend/GetParams */

# include "Shapes.h"        /* make normal shapes */
# include "IndexSha.h"

static int distributed_arrays;
static int host_arrays;

       /*************************************************
       *                                                *
       *  error_analysis (string, tree)                 *
       *                                                *
       *   - aborts for serious, internal errors        *
       *                                                *
       *************************************************/

void error_analysis (s, t)
char s[];
tTree t;

{ error_protocol (s);
  printf ("Error in AdaptAnalysis : %s\n", s);
  WriteTree (stdout, t);
  kill_in_protocol ();
}



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module AdaptAnalysis, routine %s failed\n", yyFunction);
 exit (1);
}

void AdaptAnalysis ARGS((tTree t));
static void DeclAnalysis ARGS((tTree t));
static void CheckReplicatedVars ARGS((tTree t, tTree decl));
static void CheckNameListVars ARGS((tTree t, tTree nl));
static void ACFAnalysis ARGS((tTree t));
static void AnalExpression ARGS((tTree t));
static void AdaptAnalForall ARGS((tTree t, int conditions));
static void AnalWhereBody ARGS((tTree t));
static void AdaptAnalDistributions ARGS((tDefinitions t));
static void CheckObjKind ARGS((tDefinitions obj));
static void SetDistributionId ARGS((tDefinitions d, tDefinitions Obj));
static int CountDistributedDims ARGS((tDefinitions dist));
static void AdaptIOAnalysis ARGS((tTree t));
static void AdaptAnalCall ARGS((tTree t, tDefinitions p));
static void AdaptAnalCallParams ARGS((tTree a, tTree f, tDefinitions d));
static void AdaptAnalMatchParam ARGS((tTree actual, tDefinitions formal));
static void MatchDistributions ARGS((tTree actual, tDefinitions formal));
static void AnalIntrinsicFunction ARGS((tIdent name, tTree params));
static void AnalReductionParameters ARGS((tTree params));
static void AnalIntrinsicSubroutine ARGS((tIdent name, tTree params));
static void AdaptAnalReduceParams ARGS((tTree t));
static void AdaptAnalTimerParams ARGS((tTree t));
static void AdaptAnalRandomParams ARGS((tTree t));
static void AdaptAnalGlobalGetParams ARGS((tTree parameter_list));
static void AdaptAnalGlobalSendParams ARGS((tTree parameter_list));
static bool DistributedParameters ARGS((tTree plist));
static bool ReplicatedParameters ARGS((tTree plist));
static void CheckAlignedIndexes ARGS((tTree a, tTree indexlist, int n));
static void CheckAlignedMask ARGS((tTree a, tTree mask));
static void CheckCommons ARGS((tDefinitions t));

void AdaptAnalysis
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;

  switch (t->Kind) {
  case kCOMP_UNIT:
# line 111 "AdaptAnalysis.puma"
  {
# line 112 "AdaptAnalysis.puma"
   open_protocol ("adaptor.anl");
# line 113 "AdaptAnalysis.puma"
   AdaptAnalysis (t->COMP_UNIT.COMP_ELEMENTS);
# line 114 "AdaptAnalysis.puma"
   CheckCommons (GetCommonEntries ());
# line 115 "AdaptAnalysis.puma"
   close_protocol ();
  }
   return;

  case kDECL_EMPTY:
# line 120 "AdaptAnalysis.puma"
   return;

  case kDECL_LIST:
# line 123 "AdaptAnalysis.puma"
  {
# line 124 "AdaptAnalysis.puma"
   AdaptAnalysis (t->DECL_LIST.Elem);
# line 125 "AdaptAnalysis.puma"
   AdaptAnalysis (t->DECL_LIST.Next);
  }
   return;

  case kPROGRAM_DECL:
# line 137 "AdaptAnalysis.puma"
 {
  tDefinitions Obj;
  {
# line 138 "AdaptAnalysis.puma"
   set_protocol_unit (t);
# line 139 "AdaptAnalysis.puma"

# line 140 "AdaptAnalysis.puma"
   Obj = GetDeclEntry (t->PROGRAM_DECL.Name, GetUnitEntries ());
# line 141 "AdaptAnalysis.puma"
   OpenScope (Obj->ProcObject.Declarations);
# line 142 "AdaptAnalysis.puma"
   AdaptAnalysis (t->PROGRAM_DECL.PROGRAM_BODY);
# line 143 "AdaptAnalysis.puma"
   CloseScope ();
  }
   return;
 }

  case kPROC_DECL:
# line 146 "AdaptAnalysis.puma"
 {
  tDefinitions Obj;
  {
# line 147 "AdaptAnalysis.puma"
   set_protocol_unit (t);
# line 148 "AdaptAnalysis.puma"

# line 149 "AdaptAnalysis.puma"
   Obj = GetDeclEntry (t->PROC_DECL.Name, GetUnitEntries ());
# line 150 "AdaptAnalysis.puma"
   OpenScope (Obj->ProcObject.Declarations);
# line 151 "AdaptAnalysis.puma"
   DeclAnalysis (t->PROC_DECL.FORMALS);
# line 152 "AdaptAnalysis.puma"
   AdaptAnalysis (t->PROC_DECL.PROC_BODY);
# line 153 "AdaptAnalysis.puma"
   CloseScope ();
  }
   return;
 }

  case kFUNC_DECL:
# line 156 "AdaptAnalysis.puma"
 {
  tDefinitions Obj;
  {
# line 157 "AdaptAnalysis.puma"
   set_protocol_unit (t);
# line 158 "AdaptAnalysis.puma"

# line 159 "AdaptAnalysis.puma"
   Obj = GetDeclEntry (t->FUNC_DECL.Name, GetUnitEntries ());
# line 160 "AdaptAnalysis.puma"
   OpenScope (Obj->FuncObject.Declarations);
# line 161 "AdaptAnalysis.puma"
   DeclAnalysis (t->FUNC_DECL.FORMALS);
# line 162 "AdaptAnalysis.puma"
   AdaptAnalysis (t->FUNC_DECL.FUNC_BODY);
# line 163 "AdaptAnalysis.puma"
 if (host_arrays > 0)
        simple_error_protocol ("FUNCTION has host arrays");
      if (distributed_arrays > 0)
        simple_error_protocol ("FUNCTION has distrubted arrays");

# line 168 "AdaptAnalysis.puma"
   CloseScope ();
  }
   return;
 }

  case kMODULE_DECL:
# line 171 "AdaptAnalysis.puma"
  {
# line 172 "AdaptAnalysis.puma"
   tree_error_protocol ("MODULE not supported", t);
  }
   return;

  case kBLOCK_DATA_DECL:
# line 175 "AdaptAnalysis.puma"
 {
  tDefinitions Obj;
  {
# line 176 "AdaptAnalysis.puma"
   set_protocol_unit (t);
# line 177 "AdaptAnalysis.puma"

# line 178 "AdaptAnalysis.puma"
   Obj = GetDeclEntry (t->BLOCK_DATA_DECL.Name, GetUnitEntries ());
# line 179 "AdaptAnalysis.puma"
   OpenScope (Obj->BlockObject.Declarations);
# line 180 "AdaptAnalysis.puma"
   AdaptAnalysis (t->BLOCK_DATA_DECL.DATA_BODY);
# line 181 "AdaptAnalysis.puma"
   CloseScope ();
  }
   return;
 }

  case kBODY_NODE:
  if (t->BODY_NODE.INTERNALS->Kind == kDECL_EMPTY) {
# line 194 "AdaptAnalysis.puma"
  {
# line 196 "AdaptAnalysis.puma"
   host_arrays = 0;
# line 197 "AdaptAnalysis.puma"
   distributed_arrays = 0;
# line 199 "AdaptAnalysis.puma"
   DeclAnalysis (t->BODY_NODE.DECLS);
# line 201 "AdaptAnalysis.puma"
   AdaptAnalDistributions (GetCurrentScope ());
# line 204 "AdaptAnalysis.puma"
   ACFAnalysis (t->BODY_NODE.STATS);
# line 206 "AdaptAnalysis.puma"
 if ((target_model != HOST_NODE) && (host_arrays > 0))
        simple_error_protocol
           ("Model ONLY_NODE/UNIPROC: no host arrays are allowed");

  }
   return;

  }
# line 212 "AdaptAnalysis.puma"
  {
# line 213 "AdaptAnalysis.puma"
   tree_error_protocol ("internal subroutines/functions are not supported", t);
  }
   return;

  }

# line 216 "AdaptAnalysis.puma"
  {
# line 217 "AdaptAnalysis.puma"
   error_analysis ("unknown tree node AdaptAnalysis", t);
  }
   return;

;
}

static void DeclAnalysis
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;

  switch (t->Kind) {
  case kDECL_EMPTY:
# line 228 "AdaptAnalysis.puma"
   return;

  case kDECL_LIST:
# line 231 "AdaptAnalysis.puma"
  {
# line 232 "AdaptAnalysis.puma"
   DeclAnalysis (t->DECL_LIST.Elem);
# line 233 "AdaptAnalysis.puma"
   DeclAnalysis (t->DECL_LIST.Next);
  }
   return;

  case kVAR_DECL:
# line 236 "AdaptAnalysis.puma"
   return;

  case kTEMPLATE_DECL:
# line 239 "AdaptAnalysis.puma"
   return;

  case kPARAMETER_DECL:
# line 242 "AdaptAnalysis.puma"
   return;

  case kEXTERNAL_DECL:
# line 245 "AdaptAnalysis.puma"
   return;

  case kINTRINSIC_DECL:
# line 248 "AdaptAnalysis.puma"
   return;

  case kDIMENSION_DECL:
# line 251 "AdaptAnalysis.puma"
   return;

  case kSAVE_DECL:
# line 254 "AdaptAnalysis.puma"
   return;

  case kSEQUENCE_DECL:
# line 257 "AdaptAnalysis.puma"
   return;

  case kNOSEQUENCE_DECL:
# line 260 "AdaptAnalysis.puma"
   return;

  case kINIT_DATA_DECL:
# line 263 "AdaptAnalysis.puma"
  {
# line 264 "AdaptAnalysis.puma"
   tree_error_protocol ("make initial values to initial statements", t);
  }
   return;

  case kALLOCATABLE_DECL:
# line 267 "AdaptAnalysis.puma"
  {
# line 268 "AdaptAnalysis.puma"
   tree_error_protocol ("use of this attribute unnecessary", t);
  }
   return;

  case kOPTIONAL_DECL:
# line 271 "AdaptAnalysis.puma"
  {
# line 272 "AdaptAnalysis.puma"
   tree_error_protocol ("optional arguments not supported", t);
  }
   return;

  case kINTENT_DECL:
# line 275 "AdaptAnalysis.puma"
   return;

  case kTARGET_DECL:
# line 279 "AdaptAnalysis.puma"
  {
# line 280 "AdaptAnalysis.puma"
   tree_error_protocol ("target attribute is not supported", t);
  }
   return;

  case kPOINTER_DECL:
# line 283 "AdaptAnalysis.puma"
  {
# line 284 "AdaptAnalysis.puma"
   tree_error_protocol ("pointer attribute is not supported", t);
  }
   return;

  case kPUBLIC_DECL:
# line 287 "AdaptAnalysis.puma"
  {
# line 288 "AdaptAnalysis.puma"
   tree_error_protocol ("public attribute is not supported", t);
  }
   return;

  case kPRIVATE_DECL:
# line 291 "AdaptAnalysis.puma"
  {
# line 292 "AdaptAnalysis.puma"
   tree_error_protocol ("private attribute is not supported", t);
  }
   return;

  case kALIGN_DECL:
# line 295 "AdaptAnalysis.puma"
   return;

  case kDISTRIBUTE_DECL:
# line 299 "AdaptAnalysis.puma"
   return;

  case kNAMELIST_DECL:
# line 303 "AdaptAnalysis.puma"
  {
# line 305 "AdaptAnalysis.puma"
   CheckNameListVars (t->NAMELIST_DECL.IDS, t);
  }
   return;

  case kCOMMON_DECL:
# line 308 "AdaptAnalysis.puma"
   return;

  case kEQV_DECL:
# line 313 "AdaptAnalysis.puma"
  {
# line 314 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->EQV_DECL.VARS, t);
  }
   return;

  case kDATA_DECL:
# line 317 "AdaptAnalysis.puma"
  {
# line 318 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->DATA_DECL.VARS, t);
  }
   return;

  case kIMPLICIT_DECL:
# line 321 "AdaptAnalysis.puma"
   return;

  case kVAR_PARAM_DECL:
# line 325 "AdaptAnalysis.puma"
   return;

  case kSTMT_FUNC_DECL:
# line 328 "AdaptAnalysis.puma"
   return;

  case kINTERFACE_DECL:
# line 332 "AdaptAnalysis.puma"
   return;

  }

# line 336 "AdaptAnalysis.puma"
  {
# line 337 "AdaptAnalysis.puma"
   error_analysis ("unknown tree node DeclAnalysis", t);
  }
   return;

;
}

static void CheckReplicatedVars
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree decl)
# else
(t, decl)
 register tTree t;
 register tTree decl;
# endif
{
  if (t == NoTree) return;
  if (decl == NoTree) return;
  if (t->Kind == kBTV_LIST) {
# line 350 "AdaptAnalysis.puma"
  {
# line 351 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->BTV_LIST.Elem, decl);
# line 352 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->BTV_LIST.Next, decl);
  }
   return;

  }
  if (t->Kind == kBTV_EMPTY) {
# line 355 "AdaptAnalysis.puma"
   return;

  }
  if (t->Kind == kUSED_VAR) {
# line 358 "AdaptAnalysis.puma"
  {
# line 359 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->USED_VAR.VARNAME, decl);
  }
   return;

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 362 "AdaptAnalysis.puma"
  {
# line 363 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME, decl);
  }
   return;

  }
  }
  if (t->Kind == kVAR_OBJ) {
# line 366 "AdaptAnalysis.puma"
  {
# line 367 "AdaptAnalysis.puma"
   if (! ((TreeDistribution (t) != 0))) goto yyL5;
  {
# line 368 "AdaptAnalysis.puma"
   simple_error_protocol ("only replicated variables in DATA, EQUIVALENCE");
# line 369 "AdaptAnalysis.puma"
   tree_protocol ("Illegal declaration is : \n", decl);
# line 370 "AdaptAnalysis.puma"
   tree_protocol ("Illegal variable is : ", t);
  }
  }
   return;
yyL5:;

# line 373 "AdaptAnalysis.puma"
   return;

  }
  if (t->Kind == kDO_VAR) {
# line 376 "AdaptAnalysis.puma"
  {
# line 377 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->DO_VAR.BODY, decl);
  }
   return;

  }
# line 380 "AdaptAnalysis.puma"
  {
# line 381 "AdaptAnalysis.puma"
   error_analysis ("unknown tree node CheckReplicatedVars", t);
  }
   return;

;
}

static void CheckNameListVars
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree nl)
# else
(t, nl)
 register tTree t;
 register tTree nl;
# endif
{
  if (t == NoTree) return;
  if (nl == NoTree) return;
  if (t->Kind == kDECL_LIST) {
# line 394 "AdaptAnalysis.puma"
  {
# line 395 "AdaptAnalysis.puma"
   CheckNameListVars (t->DECL_LIST.Elem, nl);
# line 396 "AdaptAnalysis.puma"
   CheckNameListVars (t->DECL_LIST.Next, nl);
  }
   return;

  }
  if (t->Kind == kVAR_DECL) {
# line 399 "AdaptAnalysis.puma"
 {
  tDefinitions Obj;
  {
# line 400 "AdaptAnalysis.puma"

# line 401 "AdaptAnalysis.puma"
   Obj = GetLocalDecl (t->VAR_DECL.Name);
# line 402 "AdaptAnalysis.puma"
 if (VarDistribution (Obj) == 1)
         { error_protocol ("Distributed variable in NAMELIST");
           tree_protocol  ("namelist        : ", nl);
           tree_protocol  ("distributed var : ", t);
         }

  }
   return;
 }

  }
;
}

static void ACFAnalysis
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;

  switch (t->Kind) {
  case kACF_LIST:
# line 418 "AdaptAnalysis.puma"
  {
# line 419 "AdaptAnalysis.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 420 "AdaptAnalysis.puma"
   ACFAnalysis (t->ACF_LIST.Elem);
# line 421 "AdaptAnalysis.puma"
   ACFAnalysis (t->ACF_LIST.Next);
  }
   return;

  case kACF_EMPTY:
# line 424 "AdaptAnalysis.puma"
   return;

  case kACF_DUMMY:
# line 427 "AdaptAnalysis.puma"
   return;

  case kACF_BASIC:
# line 430 "AdaptAnalysis.puma"
  {
# line 431 "AdaptAnalysis.puma"
   ACFAnalysis (t->ACF_BASIC.BASIC_STMT);
  }
   return;

  case kACF_IF:
# line 434 "AdaptAnalysis.puma"
  {
# line 435 "AdaptAnalysis.puma"
 t->ACF_IF.IF_EXP = NormalArrayIndexes (t->ACF_IF.IF_EXP);
# line 436 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_IF.IF_EXP);
# line 437 "AdaptAnalysis.puma"
   ACFAnalysis (t->ACF_IF.THEN_PART);
# line 438 "AdaptAnalysis.puma"
   ACFAnalysis (t->ACF_IF.ELSE_PART);
  }
   return;

  case kACF_WHERE:
# line 441 "AdaptAnalysis.puma"
  {
# line 442 "AdaptAnalysis.puma"
 t->ACF_WHERE.WHERE_EXP = NormalArrayIndexes (t->ACF_WHERE.WHERE_EXP);
# line 443 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_WHERE.WHERE_EXP);
# line 444 "AdaptAnalysis.puma"
   AnalWhereBody (t->ACF_WHERE.TRUE_PART);
# line 445 "AdaptAnalysis.puma"
   AnalWhereBody (t->ACF_WHERE.FALSE_PART);
  }
   return;

  case kACF_CASE:
# line 448 "AdaptAnalysis.puma"
  {
# line 449 "AdaptAnalysis.puma"
 t->ACF_CASE.CASE_EXP = NormalArrayIndexes (t->ACF_CASE.CASE_EXP);
# line 450 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_CASE.CASE_EXP);
# line 451 "AdaptAnalysis.puma"
   ACFAnalysis (t->ACF_CASE.CASE_ALTS);
# line 452 "AdaptAnalysis.puma"
   ACFAnalysis (t->ACF_CASE.CASE_OTHERWISE);
  }
   return;

  case kACF_WHILE:
# line 455 "AdaptAnalysis.puma"
  {
# line 456 "AdaptAnalysis.puma"
 t->ACF_WHILE.WHILE_EXP = NormalArrayIndexes (t->ACF_WHILE.WHILE_EXP);
# line 457 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_WHILE.WHILE_EXP);
# line 458 "AdaptAnalysis.puma"
   ACFAnalysis (t->ACF_WHILE.WHILE_BODY);
  }
   return;

  case kACF_DOALL:
# line 461 "AdaptAnalysis.puma"
  {
# line 462 "AdaptAnalysis.puma"
 t->ACF_DOALL.DOALL_ID = NormalArrayIndexes (t->ACF_DOALL.DOALL_ID);
# line 463 "AdaptAnalysis.puma"
 t->ACF_DOALL.DOALL_RANGE = NormalArrayIndexes (t->ACF_DOALL.DOALL_RANGE);
# line 464 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_DOALL.DOALL_ID);
# line 465 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_DOALL.DOALL_RANGE);
# line 466 "AdaptAnalysis.puma"
   error_protocol ("only independent with local access is supported");
# line 467 "AdaptAnalysis.puma"
   ACFAnalysis (t->ACF_DOALL.DOALL_BODY);
  }
   return;

  case kACF_FORALL:
# line 471 "AdaptAnalysis.puma"
  {
# line 472 "AdaptAnalysis.puma"
 t->ACF_FORALL.FORALL_ID = NormalArrayIndexes (t->ACF_FORALL.FORALL_ID);
# line 473 "AdaptAnalysis.puma"
 t->ACF_FORALL.FORALL_RANGE = NormalArrayIndexes (t->ACF_FORALL.FORALL_RANGE);
# line 474 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_FORALL.FORALL_ID);
# line 475 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_FORALL.FORALL_RANGE);
# line 476 "AdaptAnalysis.puma"
   AdaptAnalForall (t->ACF_FORALL.FORALL_BODY, 0);
  }
   return;

  case kACF_DOLOCAL:
# line 479 "AdaptAnalysis.puma"
  {
# line 480 "AdaptAnalysis.puma"
 t->ACF_DOLOCAL.DOLOCAL_ID = NormalArrayIndexes (t->ACF_DOLOCAL.DOLOCAL_ID);
# line 481 "AdaptAnalysis.puma"
 t->ACF_DOLOCAL.DOLOCAL_RANGE = NormalArrayIndexes (t->ACF_DOLOCAL.DOLOCAL_RANGE);
# line 482 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_DOLOCAL.DOLOCAL_ID);
# line 483 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_DOLOCAL.DOLOCAL_RANGE);
# line 484 "AdaptAnalysis.puma"
   ACFAnalysis (t->ACF_DOLOCAL.DOLOCAL_BODY);
  }
   return;

  case kACF_DO:
# line 491 "AdaptAnalysis.puma"
  {
# line 492 "AdaptAnalysis.puma"
 t->ACF_DO.DO_ID = NormalArrayIndexes (t->ACF_DO.DO_ID);
# line 493 "AdaptAnalysis.puma"
 t->ACF_DO.DO_RANGE = NormalArrayIndexes (t->ACF_DO.DO_RANGE);
# line 494 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_DO.DO_ID);
# line 495 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_DO.DO_RANGE);
# line 496 "AdaptAnalysis.puma"
   ACFAnalysis (t->ACF_DO.DO_BODY);
  }
   return;

  case kASSIGN_STMT:
# line 499 "AdaptAnalysis.puma"
  {
# line 500 "AdaptAnalysis.puma"
 t->ASSIGN_STMT.ASSIGN_VAR = NormalArrayIndexes (t->ASSIGN_STMT.ASSIGN_VAR);
     t->ASSIGN_STMT.ASSIGN_EXP = NormalArrayIndexes (t->ASSIGN_STMT.ASSIGN_EXP);

# line 503 "AdaptAnalysis.puma"
   AnalExpression (t->ASSIGN_STMT.ASSIGN_VAR);
# line 504 "AdaptAnalysis.puma"
   AnalExpression (t->ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  case kFORMAT_STMT:
# line 507 "AdaptAnalysis.puma"
   return;

  case kIO_STMT:
# line 510 "AdaptAnalysis.puma"
  {
# line 511 "AdaptAnalysis.puma"
   AdaptIOAnalysis (t);
  }
   return;

  case kCALL_STMT:
# line 514 "AdaptAnalysis.puma"
  {
# line 516 "AdaptAnalysis.puma"
   if (! (t->CALL_STMT.CALL_ID->PROC_OBJ.Object == GetDeclEntry (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, GetIntrinsicEntries ()))) goto yyL16;
  {
# line 520 "AdaptAnalysis.puma"
   AnalIntrinsicSubroutine (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, t->CALL_STMT.CALL_PARAMS);
  }
  }
   return;
yyL16:;

# line 523 "AdaptAnalysis.puma"
 {
  int dist;
  {
# line 525 "AdaptAnalysis.puma"
   if (! (t->CALL_STMT.CALL_ID->PROC_OBJ.Object == GetDeclEntry (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, GetExternalEntries ()))) goto yyL17;
  {
# line 529 "AdaptAnalysis.puma"

# line 531 "AdaptAnalysis.puma"
 dist = TreeDistribution (t->CALL_STMT.CALL_PARAMS);
     if ((dist < -1) || (dist > 0) )
      {
        error_protocol ("Node variables in external call");
      }

  }
  }
   return;
 }
yyL17:;

# line 539 "AdaptAnalysis.puma"
  {
# line 543 "AdaptAnalysis.puma"
   AdaptAnalCall (t, t->CALL_STMT.CALL_ID->PROC_OBJ.Object);
  }
   return;

  case kREDUCE_STMT:
# line 546 "AdaptAnalysis.puma"
  {
# line 547 "AdaptAnalysis.puma"
   AdaptAnalReduceParams (t->REDUCE_STMT.RED_PARAMS);
  }
   return;

  case kALLOCATE_STMT:
# line 550 "AdaptAnalysis.puma"
  {
# line 552 "AdaptAnalysis.puma"
   SetAllocateShapes (t->ALLOCATE_STMT.PARAMS);
  }
   return;

  case kDEALLOCATE_STMT:
# line 555 "AdaptAnalysis.puma"
  {
# line 557 "AdaptAnalysis.puma"
   ResetDeallocateShapes (t->DEALLOCATE_STMT.PARAMS);
  }
   return;

  case kNULLIFY_STMT:
# line 560 "AdaptAnalysis.puma"
  {
# line 561 "AdaptAnalysis.puma"
   error_protocol ("nullify not supported within ADAPTOR");
  }
   return;

  case kGOTO_STMT:
# line 564 "AdaptAnalysis.puma"
   return;

  case kCOMP_GOTO_STMT:
# line 567 "AdaptAnalysis.puma"
  {
# line 568 "AdaptAnalysis.puma"
 t->COMP_GOTO_STMT.GOTO_EXP = NormalArrayIndexes (t->COMP_GOTO_STMT.GOTO_EXP);
# line 569 "AdaptAnalysis.puma"
   AnalExpression (t->COMP_GOTO_STMT.GOTO_EXP);
  }
   return;

  case kCOMP_IF_STMT:
# line 572 "AdaptAnalysis.puma"
  {
# line 573 "AdaptAnalysis.puma"
 t->COMP_IF_STMT.IF_EXP = NormalArrayIndexes (t->COMP_IF_STMT.IF_EXP);
# line 574 "AdaptAnalysis.puma"
   AnalExpression (t->COMP_IF_STMT.IF_EXP);
  }
   return;

  case kSTOP_STMT:
# line 577 "AdaptAnalysis.puma"
  {
# line 578 "AdaptAnalysis.puma"
 t->STOP_STMT.STOP_CONST = NormalArrayIndexes (t->STOP_STMT.STOP_CONST);
  }
   return;

  case kRETURN_STMT:
# line 581 "AdaptAnalysis.puma"
  {
# line 582 "AdaptAnalysis.puma"
 t->RETURN_STMT.RETURN_EXP = NormalArrayIndexes (t->RETURN_STMT.RETURN_EXP);
# line 583 "AdaptAnalysis.puma"
   error_protocol ("Remove RETURN, jump to END of subroutine/function");
  }
   return;

  }

# line 586 "AdaptAnalysis.puma"
  {
# line 587 "AdaptAnalysis.puma"
   error_analysis ("unknown tree node ACFAnalysis", t);
  }
   return;

;
}

static void AnalExpression
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;

  switch (t->Kind) {
  case kUSED_VAR:
# line 609 "AdaptAnalysis.puma"
  {
# line 610 "AdaptAnalysis.puma"
   AnalExpression (t->USED_VAR.VARNAME);
  }
   return;

  case kLOOP_VAR:
# line 613 "AdaptAnalysis.puma"
  {
# line 614 "AdaptAnalysis.puma"
   AnalExpression (t->LOOP_VAR.LOOP_VARNAME);
  }
   return;

  case kINDEXED_VAR:
# line 617 "AdaptAnalysis.puma"
  {
# line 618 "AdaptAnalysis.puma"
   AnalExpression (t->INDEXED_VAR.IND_VAR);
# line 619 "AdaptAnalysis.puma"
   AnalExpression (t->INDEXED_VAR.IND_EXPS);
  }
   return;

  case kSUBSTRING_VAR:
# line 622 "AdaptAnalysis.puma"
  {
# line 623 "AdaptAnalysis.puma"
   AnalExpression (t->SUBSTRING_VAR.IND_VAR);
# line 624 "AdaptAnalysis.puma"
   AnalExpression (t->SUBSTRING_VAR.IND_EXP);
  }
   return;

  case kVAR_OBJ:
# line 627 "AdaptAnalysis.puma"
   return;

  case kDUMMY_EXP:
# line 637 "AdaptAnalysis.puma"
   return;

  case kCONST_EXP:
# line 640 "AdaptAnalysis.puma"
   return;

  case kARRAY_EXP:
# line 643 "AdaptAnalysis.puma"
  {
# line 644 "AdaptAnalysis.puma"
   AnalExpression (t->ARRAY_EXP.ELEMENTS);
  }
   return;

  case kSLICE_EXP:
# line 647 "AdaptAnalysis.puma"
  {
# line 648 "AdaptAnalysis.puma"
   AnalExpression (t->SLICE_EXP.START);
# line 649 "AdaptAnalysis.puma"
   AnalExpression (t->SLICE_EXP.STOP);
# line 650 "AdaptAnalysis.puma"
   AnalExpression (t->SLICE_EXP.INC);
  }
   return;

  case kOP_EXP:
# line 653 "AdaptAnalysis.puma"
  {
# line 654 "AdaptAnalysis.puma"
   AnalExpression (t->OP_EXP.OPND1);
# line 655 "AdaptAnalysis.puma"
   AnalExpression (t->OP_EXP.OPND2);
  }
   return;

  case kOP1_EXP:
# line 658 "AdaptAnalysis.puma"
  {
# line 659 "AdaptAnalysis.puma"
   AnalExpression (t->OP1_EXP.OPND);
  }
   return;

  case kVAR_EXP:
# line 662 "AdaptAnalysis.puma"
  {
# line 663 "AdaptAnalysis.puma"
   AnalExpression (t->VAR_EXP.V);
  }
   return;

  case kFUNC_CALL_EXP:
# line 672 "AdaptAnalysis.puma"
  {
# line 674 "AdaptAnalysis.puma"
   if (! (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object == GetDeclEntry (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, GetIntrinsicEntries ()))) goto yyL13;
  {
# line 675 "AdaptAnalysis.puma"
   AnalExpression (t->FUNC_CALL_EXP.FUNC_PARAMS);
# line 676 "AdaptAnalysis.puma"
 if (IntrFuncKind1 (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))
         {}
       else if (IntrFuncKind2 (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))
         {}
       else if (IntrFuncKindn (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))
         {}
       else
         AnalIntrinsicFunction (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, t->FUNC_CALL_EXP.FUNC_PARAMS);

  }
  }
   return;
yyL13:;

# line 687 "AdaptAnalysis.puma"
  {
# line 689 "AdaptAnalysis.puma"
   if (! (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object == GetDeclEntry (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, GetUnitEntries ()))) goto yyL14;
  {
# line 691 "AdaptAnalysis.puma"
   AnalExpression (t->FUNC_CALL_EXP.FUNC_PARAMS);
  }
  }
   return;
yyL14:;

# line 694 "AdaptAnalysis.puma"
  {
# line 696 "AdaptAnalysis.puma"
   if (! (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object == GetDeclEntry (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, GetExternalEntries ()))) goto yyL15;
  {
# line 698 "AdaptAnalysis.puma"
   AnalExpression (t->FUNC_CALL_EXP.FUNC_PARAMS);
# line 699 "AdaptAnalysis.puma"
 if (target_model != UNI_PROC)
        error_protocol ("external function call will not adapted");

  }
  }
   return;
yyL15:;

# line 704 "AdaptAnalysis.puma"
  {
# line 706 "AdaptAnalysis.puma"
   if (! (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object == GetLocalDecl (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))) goto yyL16;
  {
# line 707 "AdaptAnalysis.puma"
   if (! (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object->FuncObject.decl->Kind == kSTMT_FUNC_DECL)) goto yyL16;
  {
# line 709 "AdaptAnalysis.puma"
   AnalExpression (t->FUNC_CALL_EXP.FUNC_PARAMS);
  }
  }
  }
   return;
yyL16:;

# line 712 "AdaptAnalysis.puma"
  {
# line 714 "AdaptAnalysis.puma"
   if (! (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object == GetLocalDecl (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))) goto yyL17;
  {
# line 716 "AdaptAnalysis.puma"
   AnalExpression (t->FUNC_CALL_EXP.FUNC_PARAMS);
# line 717 "AdaptAnalysis.puma"
   error_protocol ("this function call will not adapted");
  }
  }
   return;
yyL17:;

  break;
  case kBTE_LIST:
# line 726 "AdaptAnalysis.puma"
  {
# line 727 "AdaptAnalysis.puma"
   AnalExpression (t->BTE_LIST.Elem);
# line 728 "AdaptAnalysis.puma"
   AnalExpression (t->BTE_LIST.Next);
  }
   return;

  case kBTE_EMPTY:
# line 731 "AdaptAnalysis.puma"
   return;

  case kBTP_LIST:
# line 740 "AdaptAnalysis.puma"
  {
# line 741 "AdaptAnalysis.puma"
   AnalExpression (t->BTP_LIST.Elem);
# line 742 "AdaptAnalysis.puma"
   AnalExpression (t->BTP_LIST.Next);
  }
   return;

  case kBTP_EMPTY:
# line 745 "AdaptAnalysis.puma"
   return;

  case kVAR_PARAM:
# line 754 "AdaptAnalysis.puma"
  {
# line 755 "AdaptAnalysis.puma"
   AnalExpression (t->VAR_PARAM.V);
  }
   return;

  case kADDR:
# line 758 "AdaptAnalysis.puma"
  {
# line 759 "AdaptAnalysis.puma"
   AnalExpression (t->ADDR.E);
  }
   return;

  }

# line 762 "AdaptAnalysis.puma"
  {
# line 763 "AdaptAnalysis.puma"
   error_analysis ("unknown tree in AnalExpression", t);
  }
   return;

;
}

static void AdaptAnalForall
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int conditions)
# else
(t, conditions)
 register tTree t;
 register int conditions;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kACF_LIST) {
  if (t->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 778 "AdaptAnalysis.puma"
  {
# line 779 "AdaptAnalysis.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 780 "AdaptAnalysis.puma"
   AdaptAnalForall (t->ACF_LIST.Elem, conditions);
  }
   return;

  }
# line 783 "AdaptAnalysis.puma"
  {
# line 784 "AdaptAnalysis.puma"
   error_protocol ("only one statement allowed in FORALL");
# line 786 "AdaptAnalysis.puma"
   AdaptAnalForall (t->ACF_LIST.Elem, conditions);
# line 787 "AdaptAnalysis.puma"
   AdaptAnalForall (t->ACF_LIST.Next, conditions);
  }
   return;

  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 790 "AdaptAnalysis.puma"
  {
# line 791 "AdaptAnalysis.puma"
 t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR = NormalArrayIndexes (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
     t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP = NormalArrayIndexes (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);

# line 795 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
# line 796 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  }
  }
  if (t->Kind == kACF_FORALL) {
# line 799 "AdaptAnalysis.puma"
  {
# line 800 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_FORALL.FORALL_ID);
# line 801 "AdaptAnalysis.puma"
   AnalExpression (t->ACF_FORALL.FORALL_RANGE);
# line 802 "AdaptAnalysis.puma"
   AdaptAnalForall (t->ACF_FORALL.FORALL_BODY, conditions);
  }
   return;

  }
  if (t->Kind == kACF_IF) {
  if (t->ACF_IF.ELSE_PART->Kind == kACF_EMPTY) {
# line 805 "AdaptAnalysis.puma"
  {
# line 806 "AdaptAnalysis.puma"
   set_protocol_stmt (t);
# line 807 "AdaptAnalysis.puma"
 if (conditions > 0)
        error_protocol ("only one condition allowed in FORALL");

# line 810 "AdaptAnalysis.puma"
   AdaptAnalForall (t->ACF_IF.THEN_PART, conditions + 1);
  }
   return;

  }
# line 813 "AdaptAnalysis.puma"
  {
# line 814 "AdaptAnalysis.puma"
   error_protocol ("ELSE part in FORALL not allowed for ADAPTOR");
  }
   return;

  }
  if (t->Kind == kACF_WHERE) {
# line 817 "AdaptAnalysis.puma"
  {
# line 818 "AdaptAnalysis.puma"
   error_protocol ("WHERE in FORALL not allowed for ADAPTOR");
  }
   return;

  }
# line 821 "AdaptAnalysis.puma"
  {
# line 822 "AdaptAnalysis.puma"
   error_analysis ("unknown tree in AnalForall", t);
  }
   return;

;
}

static void AnalWhereBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kACF_LIST) {
# line 836 "AdaptAnalysis.puma"
  {
# line 837 "AdaptAnalysis.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 838 "AdaptAnalysis.puma"
   AnalWhereBody (t->ACF_LIST.Elem);
# line 839 "AdaptAnalysis.puma"
   AnalWhereBody (t->ACF_LIST.Next);
  }
   return;

  }
  if (t->Kind == kACF_EMPTY) {
# line 842 "AdaptAnalysis.puma"
   return;

  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 845 "AdaptAnalysis.puma"
  {
# line 846 "AdaptAnalysis.puma"
 t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR = NormalArrayIndexes (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
     t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP = NormalArrayIndexes (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);

  }
   return;

  }
  }
  if (t->Kind == kACF_WHERE) {
# line 853 "AdaptAnalysis.puma"
  {
# line 854 "AdaptAnalysis.puma"
   error_protocol ("Nesting of WHERE not allowed until now");
  }
   return;

  }
# line 857 "AdaptAnalysis.puma"
  {
# line 858 "AdaptAnalysis.puma"
   error_protocol ("Illegal Statement in WHERE");
  }
   return;

;
}

static void AdaptAnalDistributions
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
# line 871 "AdaptAnalysis.puma"

int rank;

  if (t == NoDefinitions) return;
  if (t->Kind == kENTRY_LIST) {
# line 875 "AdaptAnalysis.puma"
  {
# line 876 "AdaptAnalysis.puma"
   CheckObjKind (t->ENTRY_LIST.Elem);
# line 877 "AdaptAnalysis.puma"
   AdaptAnalDistributions (t->ENTRY_LIST.Elem);
# line 878 "AdaptAnalysis.puma"
   AdaptAnalDistributions (t->ENTRY_LIST.Next);
  }
   return;

  }
  if (t->Kind == kENTRY_EMPTY) {
# line 881 "AdaptAnalysis.puma"
   return;

  }
  if (t->Kind == kVarObject) {
  if (t->VarObject.Dist->Kind == kDefaultDistribution) {
# line 890 "AdaptAnalysis.puma"
  {
# line 891 "AdaptAnalysis.puma"
   obj_error_protocol ("Default Distribution should not happen", t);
  }
   return;

  }
  if (t->VarObject.Dist->Kind == kAlignDistribution) {
# line 894 "AdaptAnalysis.puma"
  {
# line 895 "AdaptAnalysis.puma"
   obj_error_protocol ("Align Distribution should not happen", t);
  }
   return;

  }
  if (t->VarObject.Dist->Kind == kSerialDistribution) {
# line 898 "AdaptAnalysis.puma"
   return;

  }
  if (t->VarObject.Kind->Kind == kVarCommon) {
  if (t->VarObject.Dist->Kind == kHostDistribution) {
# line 902 "AdaptAnalysis.puma"
  {
# line 903 "AdaptAnalysis.puma"
   obj_error_protocol ("Host arrays not allowed in COMMON", t);
  }
   return;

  }
  }
  if (t->VarObject.Dist->Kind == kHostDistribution) {
# line 906 "AdaptAnalysis.puma"
  {
# line 907 "AdaptAnalysis.puma"
   SetDistributionId (t->VarObject.Dist, t);
  }
   return;

  }
  if (t->VarObject.Dist->Kind == kNodeDistribution) {
# line 910 "AdaptAnalysis.puma"
  {
# line 911 "AdaptAnalysis.puma"
   SetDistributionId (t->VarObject.Dist, t);
  }
   return;

  }
  }
  if (t->Kind == kTemplateObject) {
  if (t->TemplateObject.Dist->Kind == kNodeDistribution) {
# line 914 "AdaptAnalysis.puma"
  {
# line 915 "AdaptAnalysis.puma"
 if (CountDistributedDims (t->TemplateObject.Dist) != 1)
       tree_warning_protocol (
         "only one dimension of template will be distributed : \n", t->TemplateObject.decl);

  }
   return;

  }
  }
;
}

static void CheckObjKind
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj == NoDefinitions) return;
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
  if (obj->VarObject.Dist->Kind == kNodeDistribution) {
# line 929 "AdaptAnalysis.puma"
  {
# line 930 "AdaptAnalysis.puma"
   if (! ((obj->VarObject.Kind->VarLocal.IsSave == true))) goto yyL1;
  {
# line 931 "AdaptAnalysis.puma"
   obj_error_protocol ("distributed node arrays cannot be save", obj);
  }
  }
   return;
yyL1:;

  }
# line 934 "AdaptAnalysis.puma"
  {
# line 935 "AdaptAnalysis.puma"
   if (! (obj->VarObject.Kind->VarLocal.dynamic == 3)) goto yyL2;
  {
# line 936 "AdaptAnalysis.puma"
   obj_error_protocol ("assumed size not allowed for local variables", obj);
  }
  }
   return;
yyL2:;

  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 939 "AdaptAnalysis.puma"
  {
# line 940 "AdaptAnalysis.puma"
   if (! (obj->VarObject.Kind->VarDummy.dynamic == 2)) goto yyL3;
  {
# line 941 "AdaptAnalysis.puma"
   obj_error_protocol ("assumed-shaped dummy arrays not supported", obj);
  }
  }
   return;
yyL3:;

  if (obj->VarObject.Dist->Kind == kNodeDistribution) {
# line 944 "AdaptAnalysis.puma"
  {
# line 946 "AdaptAnalysis.puma"
   if (! (obj->VarObject.Kind->VarDummy.dynamic == 3)) goto yyL4;
  {
# line 947 "AdaptAnalysis.puma"
   obj_error_protocol ("assumed size arrays must not be distributed", obj);
  }
  }
   return;
yyL4:;

  }
  }
  }
# line 950 "AdaptAnalysis.puma"
   return;

;
}

static void SetDistributionId
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, register tDefinitions Obj)
# else
(d, Obj)
 register tDefinitions d;
 register tDefinitions Obj;
# endif
{
# line 961 "AdaptAnalysis.puma"

int rank;
char msg[100];

  if (d == NoDefinitions) return;
  if (Obj == NoDefinitions) return;
  if (d->Kind == kDefaultDistribution) {
# line 966 "AdaptAnalysis.puma"
  {
# line 967 "AdaptAnalysis.puma"
   obj_error_protocol ("object has still default distribution", Obj);
  }
   return;

  }
  if (d->Kind == kAlignDistribution) {
# line 970 "AdaptAnalysis.puma"
  {
# line 971 "AdaptAnalysis.puma"
   obj_error_protocol ("alignment not supported", Obj);
  }
   return;

  }
  if (d->Kind == kSerialDistribution) {
# line 974 "AdaptAnalysis.puma"
   return;

  }
  if (d->Kind == kHostDistribution) {
# line 977 "AdaptAnalysis.puma"
  {
# line 978 "AdaptAnalysis.puma"

     host_arrays += 1;
     rank   = VarRank(Obj);
     if (rank > MAX_DIMENSIONS)
        { sprintf (msg, "host array has rank %d, maximal rank is %d",
                   rank, MAX_DIMENSIONS);
          obj_error_protocol (msg, Obj);
        }

  }
   return;

  }
  if (d->Kind == kNodeDistribution) {
# line 989 "AdaptAnalysis.puma"
  {
# line 990 "AdaptAnalysis.puma"

     distributed_arrays += 1;
     if (CountDistributedDims (d) != 1)
       tree_warning_protocol
         ("only one dimension will be distributed : \n", Obj->Object.decl);
     rank   = VarRank(Obj);
     if (rank > MAX_DIMENSIONS)
        { sprintf (msg, "distributed array has rank %d, maximal rank is %d",
                   rank, MAX_DIMENSIONS);
          obj_error_protocol (msg, Obj);
        }

  }
   return;

  }
# line 1004 "AdaptAnalysis.puma"
  {
# line 1005 "AdaptAnalysis.puma"
   obj_error_protocol ("not supported distribution", Obj);
  }
   return;

;
}

static int CountDistributedDims
# if defined __STDC__ | defined __cplusplus
(register tDefinitions dist)
# else
(dist)
 register tDefinitions dist;
# endif
{
# line 1016 "AdaptAnalysis.puma"

int i, rank, no;

  if (dist->Kind == kNodeDistribution) {
# line 1020 "AdaptAnalysis.puma"
  {
# line 1021 "AdaptAnalysis.puma"
 no = 0;
     rank = dist->NodeDistribution.dims.no_dims;
     for (i=0; i < rank; i++)
        if (dist->NodeDistribution.dims.DimsArray[i] > 0) no += 1;

  }
   return no;

  }
 yyAbort ("CountDistributedDims");
}

static void AdaptIOAnalysis
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 1037 "AdaptAnalysis.puma"

unsigned char string[256];
tObject Obj;
int dist;

  if (t == NoTree) return;
  if (t->Kind == kIO_STMT) {
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("PRINT", 5))) {
# line 1043 "AdaptAnalysis.puma"
  {
# line 1045 "AdaptAnalysis.puma"
   AdaptIOAnalysis (t->IO_STMT.IO_ITEMS);
  }
   return;

  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("READ", 4))) {
# line 1048 "AdaptAnalysis.puma"
  {
# line 1050 "AdaptAnalysis.puma"
   AdaptIOAnalysis (t->IO_STMT.IO_ITEMS);
  }
   return;

  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("WRITE", 5))) {
# line 1053 "AdaptAnalysis.puma"
  {
# line 1055 "AdaptAnalysis.puma"
   AdaptIOAnalysis (t->IO_STMT.IO_ITEMS);
  }
   return;

  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("OPEN", 4))) {
# line 1058 "AdaptAnalysis.puma"
   return;

  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("CLOSE", 5))) {
# line 1061 "AdaptAnalysis.puma"
   return;

  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("REWIND", 6))) {
# line 1064 "AdaptAnalysis.puma"
   return;

  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("BACKSPACE", 9))) {
# line 1067 "AdaptAnalysis.puma"
   return;

  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("INQUIRE", 7))) {
# line 1070 "AdaptAnalysis.puma"
   return;

  }
# line 1073 "AdaptAnalysis.puma"
  {
# line 1074 "AdaptAnalysis.puma"
   GetString (t->IO_STMT.ID->PROC_OBJ.Ident, string);
# line 1075 "AdaptAnalysis.puma"
 printf ("%s in I/O\n",string);
      error_protocol ("Unknown name in I/O");

  }
   return;

  }
  if (t->Kind == kBTP_LIST) {
# line 1080 "AdaptAnalysis.puma"
  {
# line 1081 "AdaptAnalysis.puma"
   AdaptIOAnalysis (t->BTP_LIST.Elem);
# line 1082 "AdaptAnalysis.puma"
   AdaptIOAnalysis (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->Kind == kBTP_EMPTY) {
# line 1085 "AdaptAnalysis.puma"
   return;

  }
  if (t->Kind == kVAR_PARAM) {
# line 1088 "AdaptAnalysis.puma"
  {
# line 1090 "AdaptAnalysis.puma"
 dist = TreeDistribution (t->VAR_PARAM.V);
      if ( (dist == 1) && (TreeRank (t->VAR_PARAM.V) != 0) )
       {
         error_protocol ("distributed array expression in I/O not allowed\n");
         tree_protocol ("array parameter is ", t->VAR_PARAM.V);
       }
      if (dist == -2)
       {
         error_protocol ("illegal distribution for I/O parameter");
         tree_protocol ("parameter is ", t->VAR_PARAM.V);
       }

  }
   return;

  }
# line 1104 "AdaptAnalysis.puma"
  {
# line 1105 "AdaptAnalysis.puma"
   error_analysis ("unknown tree in AdaptIO", t);
  }
   return;

;
}

static void AdaptAnalCall
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions p)
# else
(t, p)
 register tTree t;
 register tDefinitions p;
# endif
{
# line 1118 "AdaptAnalysis.puma"

int len1, len2;
char string[250];

  if (t == NoTree) return;
  if (p == NoDefinitions) return;
  if (t->Kind == kCALL_STMT) {
  if (Definitions_IsType (t->CALL_STMT.CALL_ID->PROC_OBJ.Object, kObject)) {
  if (p->Kind == kProcObject) {
  if (p->ProcObject.decl->Kind == kPROC_DECL) {
# line 1123 "AdaptAnalysis.puma"
  {
# line 1127 "AdaptAnalysis.puma"
   AdaptAnalCallParams (t->CALL_STMT.CALL_PARAMS, p->ProcObject.decl->PROC_DECL.FORMALS, p->ProcObject.Declarations);
  }
   return;

  }
  if (p->ProcObject.decl->Kind == kPROC_PARAM_DECL) {
# line 1130 "AdaptAnalysis.puma"
  {
# line 1133 "AdaptAnalysis.puma"
   AdaptAnalCallParams (t->CALL_STMT.CALL_PARAMS, p->ProcObject.decl->PROC_PARAM_DECL.FORMAL, p->ProcObject.Declarations);
  }
   return;

  }
  if (p->ProcObject.decl->Kind == kEXT_PROC_DECL) {
# line 1136 "AdaptAnalysis.puma"
  {
# line 1139 "AdaptAnalysis.puma"
   AdaptAnalCallParams (t->CALL_STMT.CALL_PARAMS, p->ProcObject.decl->EXT_PROC_DECL.FORMALS, p->ProcObject.Declarations);
  }
   return;

  }
  }
  }
  }
  if (t->Kind == kFUNC_CALL_EXP) {
  if (Definitions_IsType (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object, kObject)) {
  if (p->Kind == kFuncObject) {
  if (p->FuncObject.decl->Kind == kFUNC_DECL) {
# line 1142 "AdaptAnalysis.puma"
  {
# line 1146 "AdaptAnalysis.puma"
   AdaptAnalCallParams (t->FUNC_CALL_EXP.FUNC_PARAMS, p->FuncObject.decl->FUNC_DECL.FORMALS, p->FuncObject.Declarations);
  }
   return;

  }
  }
  }
  }
# line 1149 "AdaptAnalysis.puma"
  {
# line 1150 "AdaptAnalysis.puma"
   obj_error_protocol ("mismatch with formal object", p);
# line 1151 "AdaptAnalysis.puma"
   error_analysis ("illegal tree in AdaptAnalCall", t);
  }
   return;

;
}

static void AdaptAnalCallParams
# if defined __STDC__ | defined __cplusplus
(register tTree a, register tTree f, register tDefinitions d)
# else
(a, f, d)
 register tTree a;
 register tTree f;
 register tDefinitions d;
# endif
{
# line 1162 "AdaptAnalysis.puma"

tObject Obj;

  if (a == NoTree) return;
  if (f == NoTree) return;
  if (d == NoDefinitions) return;
  if (a->Kind == kBTP_LIST) {
  if (f->Kind == kDECL_LIST) {
  if (f->DECL_LIST.Elem->Kind == kVAR_PARAM_DECL) {
# line 1166 "AdaptAnalysis.puma"
  {
# line 1168 "AdaptAnalysis.puma"
   AdaptAnalMatchParam (a->BTP_LIST.Elem, GetDeclEntry (f->DECL_LIST.Elem->VAR_PARAM_DECL.Name, d));
# line 1169 "AdaptAnalysis.puma"
   AdaptAnalCallParams (a->BTP_LIST.Next, f->DECL_LIST.Next, d);
  }
   return;

  }
  }
  }
  if (a->Kind == kBTP_EMPTY) {
  if (f->Kind == kDECL_EMPTY) {
# line 1172 "AdaptAnalysis.puma"
   return;

  }
  }
# line 1175 "AdaptAnalysis.puma"
  {
# line 1176 "AdaptAnalysis.puma"
   error_analysis ("Cannot compare actual and formal parameters", a);
  }
   return;

;
}

static void AdaptAnalMatchParam
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tDefinitions formal)
# else
(actual, formal)
 register tTree actual;
 register tDefinitions formal;
# endif
{
# line 1189 "AdaptAnalysis.puma"

char msg[100];

  if (actual == NoTree) return;
  if (formal == NoDefinitions) return;
  if (actual->Kind == kVAR_PARAM) {
# line 1193 "AdaptAnalysis.puma"
 {
  int dist1;
  int dist2;
  {
# line 1195 "AdaptAnalysis.puma"

# line 1196 "AdaptAnalysis.puma"

# line 1198 "AdaptAnalysis.puma"
   dist1 = TreeDistribution (actual);
# line 1199 "AdaptAnalysis.puma"
   dist2 = VarDistribution (formal);
# line 1201 "AdaptAnalysis.puma"


      if (dist1 != dist2)
         { error_protocol ("Mismatch of Distribution in parameter");
           sprintf (msg, "Distribution of actual parameter = %d : ", dist1);
           tree_protocol (msg, actual);
           sprintf (msg, "Distribution of formal parameter = %d : ", dist2);
           print_protocol (msg);
         }
      else if (dist1 == 1)
         MatchDistributions (actual->VAR_PARAM.V, formal);

  }
   return;
 }

  }
  if (actual->Kind == kFUNC_PARAM) {
# line 1215 "AdaptAnalysis.puma"
  {
# line 1216 "AdaptAnalysis.puma"
   tree_warning_protocol ("function parameters not checked : ", actual);
  }
   return;

  }
  if (actual->Kind == kPROC_PARAM) {
# line 1220 "AdaptAnalysis.puma"
  {
# line 1221 "AdaptAnalysis.puma"
   tree_warning_protocol ("subroutine parameters not checked : ", actual);
  }
   return;

  }
# line 1225 "AdaptAnalysis.puma"
  {
# line 1226 "AdaptAnalysis.puma"
   error_analysis ("illegal tree in AdaptAnalMatchParam", actual);
  }
   return;

;
}

static void MatchDistributions
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tDefinitions formal)
# else
(actual, formal)
 register tTree actual;
 register tDefinitions formal;
# endif
{
# line 1237 "AdaptAnalysis.puma"

int i, rank;
bool ok;
DistributedDimensions dim1, dim2;

  if (actual == NoTree) return;
  if (formal == NoDefinitions) return;
  if (actual->Kind == kUSED_VAR) {
  if (actual->USED_VAR.VARNAME->VAR_OBJ.Object->Kind == kVarObject) {
  if (actual->USED_VAR.VARNAME->VAR_OBJ.Object->VarObject.Dist->Kind == kNodeDistribution) {
  if (formal->Kind == kVarObject) {
  if (formal->VarObject.Dist->Kind == kNodeDistribution) {
# line 1243 "AdaptAnalysis.puma"
  {
# line 1249 "AdaptAnalysis.puma"
 dim1 = actual->USED_VAR.VARNAME->VAR_OBJ.Object->VarObject.Dist->NodeDistribution.dims;
     dim2 = formal->VarObject.Dist->NodeDistribution.dims;
     rank = dim1.no_dims;
     ok   = (rank == dim2.no_dims);
     if (ok)
       { for (i = 0; i < rank; i++)
            ok = ok && (dim1.DimsArray[i] == dim2.DimsArray[i]);
       }
     if (!ok)
       { error_protocol ("different distributions of actual and formal");
         obj_protocol ("actual is ", actual->USED_VAR.VARNAME->VAR_OBJ.Object);
         obj_protocol ("formal is ", formal);
       }

  }
   return;

  }
  }
  }
  }
  }
  if (formal->Kind == kVarObject) {
# line 1265 "AdaptAnalysis.puma"
  {
# line 1266 "AdaptAnalysis.puma"
   error_protocol ("Distributed parameter is not whole array");
# line 1267 "AdaptAnalysis.puma"
   obj_error_protocol ("formal parameter is ", formal);
# line 1268 "AdaptAnalysis.puma"
   tree_protocol ("actual parameter is ", actual);
  }
   return;

  }
# line 1271 "AdaptAnalysis.puma"
  {
# line 1272 "AdaptAnalysis.puma"
   error_protocol ("something is wrong in MatchDistributions");
  }
   return;

;
}

static void AnalIntrinsicFunction
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
# line 1283 "AdaptAnalysis.puma"

int no;

  if (params == NoTree) return;
# line 1289 "AdaptAnalysis.puma"
  {
# line 1290 "AdaptAnalysis.puma"
   if (! (IntrFuncRed (name) == true)) goto yyL1;
  {
# line 1291 "AdaptAnalysis.puma"
   AnalReductionParameters (params);
  }
  }
   return;
yyL1:;

  if (equaltIdent (name, MakeIdent ("MINLOC", 6))) {
# line 1294 "AdaptAnalysis.puma"
  {
# line 1295 "AdaptAnalysis.puma"
   error_protocol ("MINLOC is not supported until now");
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("MAXLOC", 6))) {
# line 1298 "AdaptAnalysis.puma"
  {
# line 1299 "AdaptAnalysis.puma"
   error_protocol ("MAXLOC is not supported until now");
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("SPREAD", 6))) {
# line 1302 "AdaptAnalysis.puma"
  {
# line 1303 "AdaptAnalysis.puma"
 if (TreeListLength (params) != 3)
         error_protocol ("SPREAD has not three parameters");

  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("CSHIFT", 6))) {
# line 1308 "AdaptAnalysis.puma"
   return;

  }
  if (equaltIdent (name, MakeIdent ("TRANSPOSE", 9))) {
# line 1312 "AdaptAnalysis.puma"
   return;

  }
  if (equaltIdent (name, MakeIdent ("DOTPRODUCT", 10))) {
# line 1316 "AdaptAnalysis.puma"
  {
# line 1317 "AdaptAnalysis.puma"
   error_protocol ("DOTPRODUCT is not supported until now");
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("MATMUL", 6))) {
# line 1320 "AdaptAnalysis.puma"
  {
# line 1321 "AdaptAnalysis.puma"
   error_protocol ("MATMUL is not supported until now");
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("MERGE", 6))) {
# line 1324 "AdaptAnalysis.puma"
   return;

  }
  if (equaltIdent (name, MakeIdent ("EOSHIFT", 7))) {
# line 1328 "AdaptAnalysis.puma"
  {
# line 1329 "AdaptAnalysis.puma"
   error_protocol ("EOSHIFT is not supported until now");
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("DIAGONAL", 8))) {
# line 1332 "AdaptAnalysis.puma"
  {
# line 1333 "AdaptAnalysis.puma"
   error_protocol ("DIAGONAL ist not supported until now");
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("PACK", 4))) {
# line 1336 "AdaptAnalysis.puma"
  {
# line 1337 "AdaptAnalysis.puma"
   error_protocol ("PACK ist not supported until now");
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("UNPACK", 6))) {
# line 1340 "AdaptAnalysis.puma"
  {
# line 1341 "AdaptAnalysis.puma"
   error_protocol ("UNPACK ist not supported until now");
  }
   return;

  }
# line 1344 "AdaptAnalysis.puma"
  {
# line 1345 "AdaptAnalysis.puma"
   error_protocol ("Unknown intrinsic Function in Analysis");
  }
   return;

;
}

static void AnalReductionParameters
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params == NoTree) return;
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1350 "AdaptAnalysis.puma"
   return;

  }
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1353 "AdaptAnalysis.puma"
 {
  bool found;
  int idim;
  {
# line 1355 "AdaptAnalysis.puma"
   if (! (TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) == 0)) goto yyL2;
  {
# line 1357 "AdaptAnalysis.puma"

# line 1358 "AdaptAnalysis.puma"

# line 1360 "AdaptAnalysis.puma"
 GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Elem, &found, &idim);
      if (!found)
         error_protocol ("dim of reduction must be known at compile time");
      if ((idim < 1) || (idim > TreeRank (params->BTP_LIST.Elem)) )
         error_protocol ("dim of reduction is illegal");

  }
  }
   return;
 }
yyL2:;

  }
  }
  }
# line 1368 "AdaptAnalysis.puma"
  {
# line 1369 "AdaptAnalysis.puma"
   error_protocol ("not supported use of reduction");
# line 1370 "AdaptAnalysis.puma"
   print_protocol ("mask is not allowed, dim must be known at compile time");
  }
   return;

;
}

static void AnalIntrinsicSubroutine
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params == NoTree) return;
  if (equaltIdent (name, MakeIdent ("CMF_RANDOM", 10))) {
# line 1383 "AdaptAnalysis.puma"
  {
# line 1384 "AdaptAnalysis.puma"
   AdaptAnalRandomParams (params);
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("CMF_RANDOMIZE", 13))) {
# line 1387 "AdaptAnalysis.puma"
  {
# line 1388 "AdaptAnalysis.puma"
   AdaptAnalTimerParams (params);
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("WALLTIME", 8))) {
# line 1391 "AdaptAnalysis.puma"
  {
# line 1392 "AdaptAnalysis.puma"
   AdaptAnalTimerParams (params);
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("CM_TIMER_CLEAR", 14))) {
# line 1395 "AdaptAnalysis.puma"
  {
# line 1396 "AdaptAnalysis.puma"
   AdaptAnalTimerParams (params);
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("CM_TIMER_PRINT", 14))) {
# line 1399 "AdaptAnalysis.puma"
  {
# line 1400 "AdaptAnalysis.puma"
   AdaptAnalTimerParams (params);
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("CM_TIMER_START", 14))) {
# line 1403 "AdaptAnalysis.puma"
  {
# line 1404 "AdaptAnalysis.puma"
   AdaptAnalTimerParams (params);
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("CM_TIMER_STOP", 13))) {
# line 1407 "AdaptAnalysis.puma"
  {
# line 1408 "AdaptAnalysis.puma"
   AdaptAnalTimerParams (params);
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("GLOBAL_GET", 10))) {
# line 1411 "AdaptAnalysis.puma"
  {
# line 1412 "AdaptAnalysis.puma"
   AdaptAnalGlobalGetParams (params);
  }
   return;

  }
  if (equaltIdent (name, MakeIdent ("GLOBAL_SEND", 11))) {
# line 1415 "AdaptAnalysis.puma"
  {
# line 1416 "AdaptAnalysis.puma"
   AdaptAnalGlobalSendParams (params);
  }
   return;

  }
# line 1419 "AdaptAnalysis.puma"
  {
# line 1420 "AdaptAnalysis.puma"
   error_protocol ("Unknown intrinsic Subroutine in Analysis");
  }
   return;

;
}

static void AdaptAnalReduceParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBTP_EMPTY) {
# line 1431 "AdaptAnalysis.puma"
   return;

  }
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 1434 "AdaptAnalysis.puma"
  {
# line 1435 "AdaptAnalysis.puma"
 if (TreeDistribution (t->BTP_LIST.Elem) != 0)
       { error_protocol ("REDUCE variable must be replicated");
         tree_protocol ("REDUCE variable is : ", t->BTP_LIST.Elem);
       }

# line 1440 "AdaptAnalysis.puma"
   AdaptAnalReduceParams (t->BTP_LIST.Next->BTP_LIST.Next);
  }
   return;

  }
  }
;
}

static void AdaptAnalTimerParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1453 "AdaptAnalysis.puma"
  {
# line 1455 "AdaptAnalysis.puma"
 if (TreeDistribution (t->BTP_LIST.Elem) != 0)
       error_protocol ("Timer Parameter must be replicated");

  }
   return;

  }
  }
  }
;
}

static void AdaptAnalRandomParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 1470 "AdaptAnalysis.puma"
  {
# line 1471 "AdaptAnalysis.puma"
 t->BTP_LIST.Elem->VAR_PARAM.V = MakeFullShape (t->BTP_LIST.Elem->VAR_PARAM.V);
# line 1472 "AdaptAnalysis.puma"
   if (! ((IsContiguousSection (t->BTP_LIST.Elem->VAR_PARAM.V) == false))) goto yyL1;
  {
# line 1473 "AdaptAnalysis.puma"
   error_protocol ("CMF_RANDOM: array must be contiguous");
  }
  }
   return;
yyL1:;

  }
  }
;
}

static void AdaptAnalGlobalGetParams
# if defined __STDC__ | defined __cplusplus
(register tTree parameter_list)
# else
(parameter_list)
 register tTree parameter_list;
# endif
{
  if (parameter_list == NoTree) return;
# line 1492 "AdaptAnalysis.puma"
  {
# line 1493 "AdaptAnalysis.puma"
   if (! ((DistributedParameters (parameter_list) == false))) goto yyL1;
  {
# line 1494 "AdaptAnalysis.puma"
   if (! ((ReplicatedParameters (parameter_list) == false))) goto yyL1;
  {
# line 1496 "AdaptAnalysis.puma"
   error_protocol ("all parameters of global get must be distributed or replicated");
  }
  }
  }
   return;
yyL1:;

# line 1499 "AdaptAnalysis.puma"
 {
  int b_rank;
  tTree A;
  tTree B;
  tTree indexes;
  tTree M;
  {
# line 1501 "AdaptAnalysis.puma"

# line 1502 "AdaptAnalysis.puma"

# line 1503 "AdaptAnalysis.puma"

# line 1504 "AdaptAnalysis.puma"

# line 1505 "AdaptAnalysis.puma"

# line 1507 "AdaptAnalysis.puma"
 SplitGet (parameter_list,&b_rank, &A, &B, &indexes, &M);



     CheckAlignedIndexes (A, indexes, b_rank);



     if (M != NoTree)
        CheckAlignedMask (A, M);

  }
   return;
 }

;
}

static void AdaptAnalGlobalSendParams
# if defined __STDC__ | defined __cplusplus
(register tTree parameter_list)
# else
(parameter_list)
 register tTree parameter_list;
# endif
{
  if (parameter_list == NoTree) return;
# line 1522 "AdaptAnalysis.puma"
  {
# line 1523 "AdaptAnalysis.puma"
   if (! ((DistributedParameters (parameter_list) == false))) goto yyL1;
  {
# line 1524 "AdaptAnalysis.puma"
   if (! ((ReplicatedParameters (parameter_list) == false))) goto yyL1;
  {
# line 1526 "AdaptAnalysis.puma"
   error_protocol ("all parameters of global send must be distributed or replicated");
  }
  }
  }
   return;
yyL1:;

# line 1529 "AdaptAnalysis.puma"
 {
  int b_rank;
  tTree A;
  tTree B;
  tTree indexes;
  tTree M;
  tTree op;
  {
# line 1531 "AdaptAnalysis.puma"

# line 1532 "AdaptAnalysis.puma"

# line 1533 "AdaptAnalysis.puma"

# line 1534 "AdaptAnalysis.puma"

# line 1535 "AdaptAnalysis.puma"

# line 1536 "AdaptAnalysis.puma"

# line 1538 "AdaptAnalysis.puma"
 SplitSend (parameter_list, &b_rank, &A, &B, &indexes, &M, &op);



     CheckAlignedIndexes (A, indexes, b_rank);


     if (M != NoTree)
        CheckAlignedMask (A, M);

  }
   return;
 }

;
}

static bool DistributedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree plist)
# else
(plist)
 register tTree plist;
# endif
{
  if (plist == NoTree) return false;
  if (plist->Kind == kBTP_LIST) {
  if (plist->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (plist->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 1560 "AdaptAnalysis.puma"
  {
# line 1561 "AdaptAnalysis.puma"
   if (! (TreeDistribution (plist->BTP_LIST.Elem->VAR_PARAM.V->USED_VAR.VARNAME) == 1)) goto yyL1;
  {
# line 1562 "AdaptAnalysis.puma"
   if (! (DistributedParameters (plist->BTP_LIST.Next))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  }
  if (plist->BTP_LIST.Elem->Kind == kFUNC_PARAM) {
  if (plist->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1565 "AdaptAnalysis.puma"
   return true;

  }
  }
  }
  if (plist->Kind == kBTP_EMPTY) {
# line 1569 "AdaptAnalysis.puma"
   return true;

  }
  return false;
}

static bool ReplicatedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree plist)
# else
(plist)
 register tTree plist;
# endif
{
  if (plist == NoTree) return false;
  if (plist->Kind == kBTP_LIST) {
  if (plist->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (plist->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 1582 "AdaptAnalysis.puma"
  {
# line 1583 "AdaptAnalysis.puma"
   if (! (TreeDistribution (plist->BTP_LIST.Elem->VAR_PARAM.V->USED_VAR.VARNAME) == 0)) goto yyL1;
  {
# line 1584 "AdaptAnalysis.puma"
   if (! (ReplicatedParameters (plist->BTP_LIST.Next))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  }
  if (plist->BTP_LIST.Elem->Kind == kFUNC_PARAM) {
  if (plist->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1587 "AdaptAnalysis.puma"
   return true;

  }
  }
  }
  if (plist->Kind == kBTP_EMPTY) {
# line 1591 "AdaptAnalysis.puma"
   return true;

  }
  return false;
}

static void CheckAlignedIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree a, register tTree indexlist, register int n)
# else
(a, indexlist, n)
 register tTree a;
 register tTree indexlist;
 register int n;
# endif
{
  if (a == NoTree) return;
  if (indexlist == NoTree) return;
  if (equalint (n, 0)) {
# line 1603 "AdaptAnalysis.puma"
   return;

  }
  if (indexlist->Kind == kBTP_LIST) {
  if (indexlist->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 1606 "AdaptAnalysis.puma"
  {
# line 1607 "AdaptAnalysis.puma"
 if (CountMovements (a, indexlist->BTP_LIST.Elem->VAR_PARAM.V) > 0)
        { error_protocol ("index must be local/aligned to A");
          tree_protocol ("index is ", indexlist->BTP_LIST.Elem->VAR_PARAM.V);
          tree_protocol ("must be aligned to ", a);
        }

# line 1613 "AdaptAnalysis.puma"
   CheckAlignedIndexes (a, indexlist->BTP_LIST.Next, n - 1);
  }
   return;

  }
  }
;
}

static void CheckAlignedMask
# if defined __STDC__ | defined __cplusplus
(register tTree a, register tTree mask)
# else
(a, mask)
 register tTree a;
 register tTree mask;
# endif
{
  if (a == NoTree) return;
  if (mask == NoTree) return;
# line 1618 "AdaptAnalysis.puma"
  {
# line 1619 "AdaptAnalysis.puma"
 if (CountMovements (a, mask) > 0)
        { error_protocol ("mask is not local/aligned to A");
          tree_protocol ("mask is ", mask);
        }

  }
   return;

;
}

static void CheckCommons
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t == NoDefinitions) return;
  if (t->Kind == kENTRY_LIST) {
# line 1638 "AdaptAnalysis.puma"
  {
# line 1639 "AdaptAnalysis.puma"
   CheckCommons (t->ENTRY_LIST.Next);
# line 1640 "AdaptAnalysis.puma"
   CheckCommons (t->ENTRY_LIST.Elem);
  }
   return;

  }
  if (t->Kind == kENTRY_EMPTY) {
# line 1643 "AdaptAnalysis.puma"
   return;

  }
  if (t->Kind == kCommonObject) {
# line 1646 "AdaptAnalysis.puma"
  {
# line 1647 "AdaptAnalysis.puma"
   if (! ((t->CommonObject.sequence == 1))) goto yyL3;
  {
# line 1648 "AdaptAnalysis.puma"
   if (! ((t->CommonObject.distributed_vars > 0))) goto yyL3;
  {
# line 1650 "AdaptAnalysis.puma"
   tree_error_protocol ("SEQUENCE association for COMMON with distributed vars", t->CommonObject.decl);
  }
  }
  }
   return;
yyL3:;

# line 1653 "AdaptAnalysis.puma"
  {
# line 1655 "AdaptAnalysis.puma"
   if (! ((t->CommonObject.main != true))) goto yyL4;
  {
# line 1659 "AdaptAnalysis.puma"
   if (! ((t->CommonObject.distributed_vars > 0))) goto yyL4;
  {
# line 1661 "AdaptAnalysis.puma"
   tree_error_protocol ("COMMON with distributed variables not defined in main", t->CommonObject.decl);
  }
  }
  }
   return;
yyL4:;

  }
;
}

void BeginAdaptAnalysis ()
{
}

void CloseAdaptAnalysis ()
{
}
