/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, I1.HR                           *
*  Date        : Nov 92                                                   *
*  Last Update : April 92                                                 *
*                                                                         *
*  Module      : xvars                                                    *
*                                                                         *
*  Function    : Athena Widgets for handling unit items of the            *
*                whole program                                            *
*                                                                         *
*  Export :                                                               *
*                                                                         *
*                                                                         *
**************************************************************************/

/****************************************************************************
*                                                                           *
*    list :  units                                                          *
*                                                                           *
****************************************************************************/

#include "xglobal.h"  /* import units, UnitCount */
#include "Definitions.h"  /* import units, UnitCount */
#include "ShowDefs.h"     /* imports SemFile, ShowDeclarations () */
#include <Idents.h>

extern char * malloc();    /* no include file specified */

Widget units_popup, units_menu;

/****************************************************************************
*                                                                           *
*   UnitButton: is called when button is released                           *
*               pops units_popup up if it is button3                        *
*                                                                           *
****************************************************************************/

void UnitButton (w, client_data, event)
Widget w;
XtPointer client_data;
XEvent *event;
{
  if (event->xbutton.button == Button3)
    {   XtVaSetValues (units_popup, XtNx, event->xbutton.x_root, 
                                    XtNy, event->xbutton.y_root, NULL); 

        /***************************************
        *  Pop Up the Commands for Units       *
        ***************************************/

        XtPopup (units_popup, XtGrabNonexclusive);
    }
}

/****************************************************************************
*                                                                           *
*   For a given declaration tree the position in the source                 *
*   will be hightlighted (called by Unit- and Var-select                    *
*                                                                           *
****************************************************************************/

void show_selected_decl (t)
tTree t;
{ int l, length;
  char s[100];
  GetString (t->DECL_NODE.Name, s);
  length = strlen (s);
  l = t->DECL_NODE.Pos;
  XawTextSetSelection (mytext, l-1, l+length-1);
  XawTextSetInsertionPoint (mytext, l-1);
}

/****************************************************************************
*                                                                           *
*   SetSelectedUnitItems:  Called when selecting a unit item                *
*                                                                           *
****************************************************************************/

void SetSelectedUnitItems (call_data)
XawListReturnStruct *call_data;

/* returns local declaration table of current selected unit */

{ tIdent  Ident;

  /* Searching the Entry for the unit */

  Ident = MakeIdent (call_data->string, strlen (call_data->string));
  UnitDecl = GetDeclEntry (Ident, GetUnitEntries () );

  /* set global values for selected unit */

  if (UnitDecl == NoObject)
    { printf ("Unit %s not found in Table \n", call_data->string);
      UnitTree = NoTree;
      UnitDeclarations = NoDefinitions; 
    }
   else 
    { UnitTree = UnitDecl->Object.decl;
      show_selected_decl (UnitTree);
      if (UnitDecl->Kind == kProcObject)
          UnitDeclarations = UnitDecl->ProcObject.Declarations;
      else if (UnitDecl->Kind == kFuncObject)
          UnitDeclarations = UnitDecl->FuncObject.Declarations;
      else if (UnitDecl->Kind == kBlockObject)
          UnitDeclarations = UnitDecl->BlockObject.Declarations;
      else { printf ("Illegal Declaration for a unit\n");
             UnitDeclarations = NoDefinitions;
           }
    }
}

/****************************************************************************
*                                                                           *
*   UnitSelect: This function is called after selecting a unit item         *
*                                                                           *
****************************************************************************/

void UnitSelect (w, client_data, call_data)
Widget w;
XtPointer  client_data;
XawListReturnStruct *call_data;
{ printf ("Unit %s = item %d has been selected\n",
           call_data->string, call_data->list_index);

  if (call_data->list_index >= UnitCount)
      printf ("No function \n");
   else
      { SetSelectedUnitItems (call_data);
        show_vars (UnitDeclarations);
      }

} /* UnitSelect */

/* predefined list of unit items : must not be empty  */

static String unit_items [] = { "<list_of_units>" };

/****************************************************************************
*                                                                           *
*   UnitMenuSelect: Called after selecting a unit command                   *
*                                                                           *
****************************************************************************/

void UnitMenuSelect (w, client_data, garbage)
Widget w;
XtPointer client_data;
XtPointer garbage;  /* call_data */
{   Widget menu, father;
    char *name;
    FILE *myfile;
    int i = (int) client_data;

    /* find the current unit */

    if (UnitDecl != NoObject)
      {  if (i==1)  /* Unparse Unit */
            { BeginUnparse ();
              Unparse (UnitTree);
              CloseUnparse ();
              xshowfile (w, unparse_file);
            }
         if (i==2)  /* Write Unit */
            { myfile = fopen ("test.out","w");
              WriteTree (myfile, UnitTree);
              fclose (myfile);
              xshowfile (w, "test.out");
            }
         if (i==3)  /* Show Declarations */
            { SemFile = fopen ("test.sem","w");
              ShowDeclarations (UnitDeclarations);
              fclose (SemFile);
              xshowfile (w, "test.sem");
            }
      }
    XtPopdown (units_popup);
}

/****************************************************************************
*                                                                           *
*    init_units : creates list widget (exported)                            *
*                                                                           *
****************************************************************************/

void init_units (parent)
Widget parent;
{ int n;
  Arg args[10];
  Widget entry;
  int x, y;

  n = 0;
  XtSetArg (args[n], XtNnumberStrings, 1);  n++;
  XtSetArg (args[n], XtNlist, unit_items);  n++;
  XtSetArg (args[n], XtNdefaultColumns, 1);  n++;
  XtSetArg (args[n], XtNcolumnSpacing, 15);  n++;

  units = XtCreateManagedWidget(
          "units",                         /* widget name */
          listWidgetClass,                 /* widget class */
          parent,                          /* parent widget*/
          args, n);                        /* varargs list */

  UnitCount = 0;
  UnitTree  = NoTree;
  UnitDecl  = NoObject;
  UnitDeclarations = NoDefinitions;

  XtAddCallback(units, XtNcallback, UnitSelect, 0);

  XtAddEventHandler (units, ButtonReleaseMask, FALSE, UnitButton, 0);

  units_popup =  XtCreatePopupShell ("UnitMenu", transientShellWidgetClass,
                            units, NULL, 0);

  /***************************************
  *  Create the Commands for units       *
  ***************************************/

  units_menu =  XtCreateManagedWidget ("unitmenu", boxWidgetClass,
                            units_popup, NULL, 0);

  entry = XtCreateManagedWidget ("Unparse Unit",
                  commandWidgetClass, units_menu, NULL, 0);
  XtAddCallback (entry, XtNcallback, UnitMenuSelect, (XtPointer) 1);
  entry = XtCreateManagedWidget ("Write Unit",
                  commandWidgetClass, units_menu, NULL, 0);
  XtAddCallback (entry, XtNcallback, UnitMenuSelect, (XtPointer) 2);
  entry = XtCreateManagedWidget ("Show Declarations",
                  commandWidgetClass, units_menu, NULL, 0);
  XtAddCallback (entry, XtNcallback, UnitMenuSelect, (XtPointer) 3);
  entry = XtCreateManagedWidget ("Quit",
                  commandWidgetClass, units_menu, NULL, 0);
  XtAddCallback (entry, XtNcallback, UnitMenuSelect, (XtPointer) 4);

}

/****************************************************************************
*                                                                           *
*    show_units : updates list widget (exported)                            *
*                                                                           *
****************************************************************************/

void show_units ()
{  char Item[250];
   tDefinitions Entries, Elem;
   int i;
   String H;

   /* set the unit names in the unit-widget */

   Entries = GetUnitEntries () ;  /* imported from Definitions.h */
   UnitCount = 0;
   while (Entries->Kind != kENTRY_EMPTY)
      { Elem = Entries->ENTRY_LIST.Elem;
        GetString (Elem->Object.ident, Item);
        if (UnitCount == MaxUnitItems)
           printf ("ERROR: maximal number of Unit Items reached\n");
        UnitItems[UnitCount] =  malloc (strlen (Item) + 1);
        strcpy (UnitItems[UnitCount],Item);
        UnitCount += 1;
        Entries = Entries->ENTRY_LIST.Next;
      }

   /* reverse the list: 0 <-> N-1, 1 <-> N-2, ... */
   
   for (i=0;i<UnitCount/2;i++)
     { H = UnitItems[i];
       UnitItems[i] = UnitItems[UnitCount-1-i];
       UnitItems[UnitCount-1-i] = H;
     }

   XawListChange (units, UnitItems, UnitCount, -1, TRUE);

   /* no selected unit */
   UnitTree = NoTree;
   UnitDecl = NoObject;
   UnitDeclarations = NoDefinitions;

}
