//
// $Header: d:\\32bits\\ext2-os2\\microfsd\\rcs\\start.c,v 1.3 1997/03/15 22:24:42 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOSDEVIOCTL
#define INCL_NOPMAPI
#include <os2.h>

#include <string.h>

#include <os2/types.h>
#include <os2/magic.h>
#include <microfsd.h>
#include <linux/ext2_fs.h>
#include <mfs.h>

#define OS2LDRSEG    0x1000 /* OS2LDR seems to be loaded at 1000:0000 and relocate at 9400:0000 */
#define MINIFSDSEG   0x007C /* HPFS seems to load its mini FSD at 007C:0000                     */
#define INITSEG      0x9000 /* LILO loads us here                                               */
#define MICROFSDSEG  0x8C20 /* we relocate ourself here                                         */
#define LILODATASEG  0x8C00 /* we relocate LILO data here                                       */

extern unsigned short image_length;

/*
 * Standard data structure to be passed to OS2LDR (defined in the IFS document)
 */
struct FileTable os2ldr_data = {
    3,
    OS2LDRSEG, 0,
    MICROFSDSEG, 0,
    MINIFSDSEG, 0,
    0, 0,
    stub_mu_Open, MICROFSDSEG,
    stub_mu_Read, MICROFSDSEG,
    stub_mu_Close, MICROFSDSEG,
    stub_mu_Terminate, MICROFSDSEG
};
void far *os2ldr_data_ptr;

/*
 * BIOS parameter block to be passed to OS2LDR
 */
BIOSPARAMETERBLOCK bpb = {0, 1, 1, 2, 224, 0, 0, 9, 0, };

void far *bpb_ptr;
unsigned long os2ldr;

unsigned short far *lilo_cmd_line_magic = (unsigned short far *)0x8C000020;	/* CL_MAGIC at 8C00:0020 in lilo.h */
unsigned short far *lilo_cmd_line       = (unsigned short far *)0x8C000022;

#define CL_MAGIC 0xa33f

#define MAJOR(dev)	((dev)>>8)
#define MINOR(dev)	((dev) & 0xff)
#define MKDEV(ma,mi)	((ma)<<8 | (mi))

/*
 * major number definitions in linux/major.h
 */
#define IDE0_MAJOR 3
#define SCSI_DISK_MAJOR 8
#define IDE1_MAJOR 22
#define IDE2_MAJOR 33
#define IDE3_MAJOR 34
#define FLOPPY_MAJOR 2

/*
 * Current segment register
 */
extern unsigned short current_seg;

/*
 * Registers passed to us by LILO
 */
unsigned short parm_cs;
unsigned short parm_ds;
unsigned short parm_es;
unsigned short parm_ss;

char banner[]   = "Linux ext2fs IFS for OS/2 - MICROFSD - Copyright (C) 1996 Matthieu WILLM";

char name_microfsd[] = "MICROFSD.FSD";
char name_minifsd[]  = "MINIFSD.FSD";
char name_os2ldr[]   = "OS2LDR";

extern char disk_table[];	/* BIOS floppy drive parameters */


#define BOOTFLAG_NOVOLIO   0x0100
#define BOOTFLAG_RIPL      0x0200
#define BOOTFLAG_MINIFSD   0x0400
#define BOOTFLAG_RESERVED3 0x0800
#define BOOTFLAG_MICROFSD  0x1000
#define BOOTFLAG_RESERVED5 0x2000
#define BOOTFLAG_RESERVED6 0x4000
#define BOOTFLAG_RESERVED7 0x8000

/*
 * Main micro FSD entry point
 */
void mu_Start(void) {
    int bios_device_ok = 0;
    int hidden_ok      = 0;
    int bsize_ok       = 0;
    int sect_ok        = 0;
    int head_ok        = 0;
    int csect_ok       = 0;
    int bootdrv_ok     = 0;
    ULONG  csect;
    USHORT bootdrive;
    dev_t dev = 0;
    unsigned long  s;
    long sz;
    unsigned short mem;
    struct ext2_super_block *es;
    struct buffer_head      *bh;
    void (far *x)();
    unsigned short flags;
    char msg[1024];

    /*
     * prints the banner
     */
    printk("%s", banner);


    /*
     * prints the segment registers passed to microfsd.fsd
     */
    printk("CS = 0x%04X, DS = 0x%04X, ES = 0x%04X, SS = 0x%04X", parm_cs, parm_ds, parm_es, parm_ss);


    /*
     * Tests LILO command line parameter
     */
    if (*lilo_cmd_line_magic == CL_MAGIC) {
        USHORT ofs = *lilo_cmd_line;
	char *tmp;
        char far *cmd = (char far *)MAKEP(INITSEG, ofs);
        printk("LILO command line found - Offset = 0x%04X", *lilo_cmd_line);
        _fstrcpy(msg, cmd);
        printk("cmd line : %s", msg);

       for (tmp = strtok(msg, " ") ; tmp != NULL ; tmp = strtok(NULL, " ")) {
           if (tmp) {
                char *line = tmp;
#define OS2_BIOS_DRV_STR "os2_bios_device="
#define OS2_BIOS_DRV_LEN (sizeof(OS2_BIOS_DRV_STR) - 1)
                if (!strncmp(line, OS2_BIOS_DRV_STR, OS2_BIOS_DRV_LEN)) {
		    line += OS2_BIOS_DRV_LEN;
                    bios_device    = (dev_t)simple_strtoul(line,0,0);
                    bios_device_ok = 1;
                    continue;
                }
#define OS2_HIDDEN_STR "os2_hidden_sectors="
#define OS2_HIDDEN_LEN (sizeof(OS2_HIDDEN_STR) - 1)
                if (!strncmp(line, OS2_HIDDEN_STR, OS2_HIDDEN_LEN)) {
		    line += OS2_HIDDEN_LEN;
                    bpb.cHiddenSectors    = (blk_t)simple_strtoul(line,0,0);
                    hidden_ok             = 1;
                    continue;
                }
#define OS2_BSIZE_STR "os2_bytes_per_sector="
#define OS2_BSIZE_LEN (sizeof(OS2_BSIZE_STR) - 1)
                if (!strncmp(line, OS2_BSIZE_STR, OS2_BSIZE_LEN)) {
		    line += OS2_BSIZE_LEN;
                    bpb.usBytesPerSector  = (USHORT)simple_strtoul(line,0,0);
                    bsize_ok              = 1;
                    continue;
                }
#define OS2_SECT_STR "os2_sect="
#define OS2_SECT_LEN (sizeof(OS2_SECT_STR) - 1)
                if (!strncmp(line, OS2_SECT_STR, OS2_SECT_LEN)) {
		    line += OS2_SECT_LEN;
                    bpb.usSectorsPerTrack = (USHORT)simple_strtoul(line,0,0);
                    sect_ok               = 1;
                    continue;
                }
#define OS2_HEAD_STR "os2_head="
#define OS2_HEAD_LEN (sizeof(OS2_HEAD_STR) - 1)
                if (!strncmp(line, OS2_HEAD_STR, OS2_HEAD_LEN)) {
		    line += OS2_HEAD_LEN;
                    bpb.cHeads            = (USHORT)simple_strtoul(line,0,0);
                    head_ok               = 1;
                    continue;
                }
#define OS2_BOOTDRV_STR "os2_bootdrive="
#define OS2_BOOTDRV_LEN (sizeof(OS2_BOOTDRV_STR) - 1)
                if (!strncmp(line, OS2_BOOTDRV_STR, OS2_BOOTDRV_LEN)) {
		    line += OS2_BOOTDRV_LEN;
                    bootdrive             = (USHORT)simple_strtoul(line,0,0);
                    if (bootdrive > 25)
                        microfsd_panic("os2_bootdrive %u out of range", bootdrive);
                    bootdrv_ok            = 1;
                    continue;
                }

#define OS2_CSECT_STR "os2_total_sectors="
#define OS2_CSECT_LEN (sizeof(OS2_CSECT_STR) - 1)
                if (!strncmp(line, OS2_CSECT_STR, OS2_CSECT_LEN)) {
		    line += OS2_CSECT_LEN;                    
                    csect = (ULONG)simple_strtoul(line,0,0);
                    if (csect < 65536UL) {
                        bpb.cSectors      = (USHORT)csect;
                        bpb.cLargeSectors = 0;
                    } else {
                        bpb.cSectors      = 0;
                        bpb.cLargeSectors = csect;
                    }
                    csect_ok   = 1;
                    continue;
                }
           }
       }
       if (!bios_device_ok)
	    microfsd_panic("os2_bios_device not set in lilo.conf");
       if (!hidden_ok)
	    microfsd_panic("os2_hidden_sectors not set in lilo.conf");
       if (!bsize_ok)
	    microfsd_panic("os2_bytes_per_sector not set in lilo.conf");
       if (!sect_ok)
	    microfsd_panic("os2_sect not set in lilo.conf");
       if (!head_ok)
	    microfsd_panic("os2_head not set in lilo.conf");
       if (!csect_ok)
	    microfsd_panic("os2_total_sectors not set in lilo.conf");
       if (!bootdrv_ok)
	    microfsd_panic("os2_bootdrive not set in lilo.conf");

    } else {
        microfsd_panic("Could not find LILO command line parameters");
    }

    /*
     * Updates the sector size in BIOS floppy drive parameter table
     */ 
    switch (bpb.usBytesPerSector) {
	case 512:
	    disk_table[3] = 2;
	    break;
	default:
	    microfsd_panic("sector size %d invalid", bpb.usBytesPerSector);
    }

    /*
     * Updates the sector per track count in floppy drive parameter table
     */ 
    disk_table[4] = (unsigned char)(bpb.usSectorsPerTrack);

    /*
     * Mounts the partition
     */
    ext2_read_super(); /* failure in ext2_read_super = panic */
    printk("ext2fs partition mounted successfuly");

    /*
     * Loads MINIFSD into memory
     */
    mu_Open((char far *)name_minifsd, &sz);
    mu_Read(0, MAKEP(MINIFSDSEG, 0), sz);
    mu_Close();
    os2ldr_data.ft_mfslen = sz;

    /*
     * Loads OS2LDR into memory
     */
    mu_Open((char far *)name_os2ldr, &sz);
    mu_Read(0, MAKEP(OS2LDRSEG, 0), sz);
    mu_Close();
    os2ldr_data.ft_ldrlen = sz;


    /*
     * base/length of micro-fsd
     */
    os2ldr_data.ft_mulen  = image_length;

    /*
     * base/length of boot data to pass to mini FSD
     */
    os2ldr_data.ft_ripseg  = 0;
    os2ldr_data.ft_riplen  = 0;

    /*
     * HACK !!!!
     */
//    bpb.usReservedSectors  = BOOTDATA_MAGIC;
//    bpb.usSectorsPerFAT    = bootdrive;
    bpb.abReserved[0] = bootdrive;
    bpb.abReserved[1] = BOOTDATA_MAGIC_LO;
    bpb.abReserved[2] = BOOTDATA_MAGIC_HI;


    /*
     * Media descriptor
     */
    if ((bios_device >=0) && (bios_device <= 26))
        bpb.bMedia = 0xF0;
    else if ((bios_device >=0x80) && (bios_device <= 0x96))
        bpb.bMedia = 0xF8;
    else 
	microfsd_panic("Media type");

    /*
     * prints the file table
     */
    printk("MICROFSD address %04X:0000 length %u", os2ldr_data.ft_museg, os2ldr_data.ft_mulen);
    printk("MINIFSD  address %04X:0000 length %u", os2ldr_data.ft_mfsseg, os2ldr_data.ft_mfslen);
    printk("OS2LDR   address %04X:0000 length %u", os2ldr_data.ft_ldrseg, os2ldr_data.ft_ldrlen);
    printk("RIPLDATA address %04X:0000 length %u", os2ldr_data.ft_ripseg, os2ldr_data.ft_riplen);

    /*
     * Boot flags
     */
    flags = bios_device | BOOTFLAG_MICROFSD | BOOTFLAG_MINIFSD;

    /*
     * Calls OS2LDR
     */
    os2ldr_data_ptr = &os2ldr_data;
    bpb_ptr         = &bpb;
    printk("bpb             = %04X:%04X", (__segment)bpb_ptr, OFFSETOF(bpb_ptr));
    printk("os2ldr_data_ptr = %04X:%04X", (__segment)os2ldr_data_ptr, OFFSETOF(os2ldr_data_ptr));

    __asm {
        mov dx, flags
        lds si, bpb_ptr
        les di, os2ldr_data_ptr
        push os2ldr_data.ft_ldrseg
        push 0
        retf
    }

}

