/*
 * Copyright 2009 Vasilkin Andrew <digi@os2.snc.ru>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. The name of the author may not be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "debug.h"

static FILE		*pfDebug = NULL;

void debug_init(char *pszFName)
{
  char	*pcNDFSDir;
  char	acBuf[260];

  if ( pfDebug != NULL )
    return;

  pcNDFSDir = getenv( "NDFSDIR" ); 
  if ( pcNDFSDir == NULL )
    pcNDFSDir = "C:";

  sprintf( acBuf, "%s\\%s", pcNDFSDir, pszFName );

  pfDebug = fopen( &acBuf, "a" );
  if ( pfDebug == NULL )
    printf( "Cannot open %s\n", pszFName );
  else
    printf( "%s opened\n", pszFName );

  debug_write( "--- Start ---\n" );
}

void debug_done()
{
  if ( pfDebug != NULL )
  {
    fclose( pfDebug );
    pfDebug = NULL;
  }
}

void debug_write(char *pcFormat, ...)
{
  va_list	arglist;
  time_t	t;
  char		acBuf[32];

  if ( pfDebug == NULL )
    return;

  t = time( NULL );
  strftime( &acBuf, sizeof(acBuf)-1, "%T", localtime( &t ) );
  fprintf( pfDebug, "[%s] ", &acBuf );

  va_start( arglist, pcFormat ); 
  vfprintf( pfDebug, pcFormat, arglist );
  va_end( arglist );
  fflush(NULL);
}
