/***************************************************/

/*****************************************
 * Intialize Rexxutil Functions
 ******************************************/

  call RxFuncAdd 'SysLoadFuncs' , 'REXXUTIL', 'SysLoadFuncs'
  signal on syntax name MsgExit
  call SysLoadFuncs



/******************************************
 * Define message ids from *mid*.h
 *******************************************/
  MSG_SYSINIT_BOOT_NOT_FD    = 1475
  MSG_INCORRECT_DOSVER       = 1210
  MSG_NO_META_MATCH          =  257
  MSG_PRINT_FILE_NOT_FOUND   = 1533
  MSG_COMP_INVALID_PATH      = 1171
  MSG_BOOT_MUST_RESTART      = 1716
  MSG_INSTALL_UNSUCCESSFUL   = 1975
  MSG_INSTALL_HY_HDR         = 1976
  MSG_PROC_NOT_FOUND         =  127
  MSG_REP_SOUR_PATH_REQ      = 1137
  MSG_SYS_INV_DRIVE          = 1461
  MSG_CHCP_INVALID_PARAMETER = 1761
  MSG_UNP_INSERT_PI          = 1218
  MSG_ERR_PROC_ARG           = 1249
  MSG_MBS_INVALID_COMMAND    =  872
  SPTReboot                  = x2d('FE00',4)
  SPTRebootErr               = x2d('FE08',4)
  SPTWithErr                 = x2d('0008',4)


/*****************************************
 * Initialized globals
 ******************************************/
  cidInst = ''

/*****************************************
 * Set up Source and Target Paths
 ******************************************/
  parse source one two me
  srcPath = filespec('Drive', me) || filespec('Path', me)
  srcName = filespec('Name', me)


  os2bootPath = SysSearchPath('PATH', 'os2boot')
  if os2bootpath \= ''
   then bootDrive = filespec('drive', os2bootPath)
   else call MsgExit SysGetMessage(MSG_SYSINIT_BOOT_NOT_FD)

dscFile = 'm6432.dsc'

/*****************************************
 * Start logging
 ******************************************/
  os2Help = bootDrive || '\os2\help'
  os2Dir = bootDrive || '\os2'
  installDir = bootDrive || '\os2\install'
  call SysFileTree installDir, 'file', 'D'
  if file.0 == 0 then call MsgExit MyGetMsg(SysGetMessage(MSG_COMP_INVALID_PATH, ,'"' || installDir || '"'))
  logFile = installDir || '\display.log'
  call SysFileTree logFile, 'file', 'F', ,'-----'
  startmsg = MyGetMsg(SysGetMessage(MSG_UNP_INSERT_PI,, SubStr(dscFile,1, pos('.', dscFile)-1 ) ))
  cmd = 'parse value(startmsg) with . '''D2c(10)''' installmsg '''D2c(13)''' junk'
  interpret cmd
  installmsg = strip(installmsg)
  call LogIt '======================================================================'
  say installmsg
  call LogIt installmsg ' - ' Date('L')  Time()
  '@if exist 'srcPath || 'build.lvl type 'srcPath || 'build.lvl >>'logFile

/*******************************************************
 * Copy dspinstl.exe into the OS2\INSTALL directory for OS/2 Warp 3
 * only.
 ********************************************************/
  parse value(SysOS2Ver()) with major '.' os2Ver
/*
  if os2Ver = 30 
    then 'copy 'srcPath || 'dspins30.exe 'installDir'\dspinstl.exe'
*/

  copy svga.exe os2Dir

/*******************************************************
 * Setup path and Copy required files to \os2\install
 ********************************************************/

  oldPath = value('PATH', , 'OS2ENVIRONMENT')
  newPath = value('PATH', srcPath || ';' || oldPath, 'OS2ENVIRONMENT')

  rc = 0
  
/********************************************************
 * Obtain .DSC file
 *********************************************************/

  call SysFileTree srcPath || dscFile, 'file', 'F'
  if file.0 == 0 then call MsgExit MyGetMsg(SysGetMessage(MSG_PRINT_FILE_NOT_FOUND,, '"' || srcPath || '*.dsc' || '"')),
                                   || MyGetMsg(SysGetMessage(MSG_NO_META_MATCH))
                 else parse value(file.1) with . . . . dscFile

  cmd = 'copy 'dscFile installDir
  dscFile = installDir || '\' || FileSpec('Name', dscFile)
  call LogIt cmd
  '@' || cmd || ' >> 'logfile ' 2>&1'
  if rc \= 0 then call MsgExit ""

  if SysFileTree(bootDrive || '\os2\video.cfg','file','F',,'+****') == 0
    then call SysFileDelete bootDrive || '\os2\video.cfg'

  dspInstall = bootDrive || '\os2\install\dspinstl.exe'
  if filespec('Drive', srcPath) \= strip(srcPath, 'T', '\')
    then srcPath = strip(srcPath, 'T', '\')
  '@' || dspInstall '/s:' || srcPath || ' /t:' || bootDrive,
              || ' /pd:' || strip(dscFile) || ' /l:' || logFile || cidInst

/******************************************************
 * check if need to install vdm driver
 *******************************************************/
  if (rc = 0 & os2Ver = 30) then
    call CheckVDMSupport

  if ( (rc == 0) | ((cidInst \= '') & ( rc == SPTReboot)) )
    then call MsgExit MyGetMsg(SysGetMessage(MSG_BOOT_MUST_RESTART))
    else call MsgExit MyGetMsg(SysGetMessage(MSG_ERR_PROC_ARG,,dscFile))

/******************************************************
 * Error message processing and exit
 *******************************************************/
MsgExit:

   parse arg errmsg

   if rc == 43
    then do
        say sigl'  +++      'SourceLine(sigl)
        say 'REX0043: 'ErrorText(43)
    end
    else do
      if errmsg == '' then errmsg = 'REXX' || right(rc,4,'0') || ': 'ErrorText(rc)
      say errmsg
      if ( (rc \= 0) & ((cidInst \= '') & ( rc \= SPTReboot)) )
        then do
           exitmsg = MyGetMsg(SysGetMessage(MSG_INSTALL_UNSUCCESSFUL))
           say exitmsg
        end

      if symbol('logfile') == 'VAR'
        then do
           if symbol('exitmsg') == 'VAR'
             then do
               call LogIt errmsg
               call LogIt exitmsg
               say MyGetMsg(SysGetMessage(MSG_INSTALL_HY_HDR)) || ' ' || logfile
             end
        end
    end

   if symbol('oldPath') == 'VAR' then call value 'PATH' , oldPath, 'OS2ENVIRONMENT'
   exit rc

/******************************************************
 * Safely write to logfile
 *******************************************************/
LogIt: Procedure expose logfile

  parse arg message
  call lineout logfile, message
  call stream logfile, 'c', 'close'
  return

/******************************************************
 * Remove SYSXXXX: from messages
 *******************************************************/
MyGetMsg: Procedure
  parse arg message

  if pos('SYS', word(message, 1)) == 1
    then parse arg . message

  return message

/*****************************************************
 * Print usage and exit
 ******************************************************/
Usage:

  msg = MyGetMsg(SysGetMessage(734,,srcName))
  cmd = 'parse value(msg) with msg '''srcName''' .'
  interpret cmd
  indent = copies(' ',30)
  say msg me || ' xxx [' || srcPath || '] [' || bootDrive || '] [/u]'
  say ''
  say '                          xxx:'
  say indent || '"RAGE"  -   ATI Rage/Mach 64'
  say ''
  exit 1


/*
 * CheckVDMSupport
 *
 * OS/2 versions prior to Warp 3.0 fixpack 30 did not have
 * mini-vdm support.  Check the internal version level and
 * update CONFIG.SYS and SVGADATA.PMI to include vdm support
 * if necessary:
 *
 *      VPRPMI.SYS is added to CONFIG.SYS
 *      INT10SETMODE = FULLVDM is added to [Hardware] section of .PMI file
 *
 * Build revision levels:
 *   8.200 Warp 3.0 with no client
 *   8.254 Warp 3.0 with fp 30 had 1st vdm support
 *   8.259 Warp 3.0 with fp 35
 *   9.029 Warp 4.0 with fp 50
 */
CheckVDMSupport:
    majorBld = 0
    minorBld = 0
    '@ver /r | rxqueue'
    do until (queued() = 0)
        parse pull arg1 arg2 arg3
        if (datatype(arg2) = "NUM") then
        do
            parse var arg2 majorBld '.' minorBld
        end
    end

    if (majorBld < 8 | (majorBld = 8 & minorBld < 254)) then
    do
        ConfigFile = bootDrive || "\config.sys"
        PmiFile = bootDrive || "\os2\svgadata.pmi"
        VdmFile = bootDrive || "\os2\mdos\vprpmi.sys"
        ConfigInsert = "device=" || VdmFile

        Signal On HALT NAME SignalHandler

        /* backup config.sys and add vdm device line */

        ConfigBak = GetBackupName(ConfigFile)
        'copy' ConfigFile ConfigBak
        if rc = 0 then
        do
            call LogIt ConfigFile "backed up to" ConfigBak
            rc = InsertLine(ConfigBak, ConfigFile, "VSVGA.SYS", ConfigInsert)
            if rc = 0 then
                call LogIt ConfigFile "modified for VDM support"
        end

        /* backup .pmi file and add vdm statement */

        PmiBak = GetBackupName(PmiFile)
        'copy' PmiFile PmiBak
        if rc = 0 then
        do
            call LogIt PmiFile "backed up to" PmiBak
            rc = InsertLine(PmiBak, PmiFile, "[Hardware]", "INT10SETMODE    = FULLVDM" )
            if rc = 0 then 
                call LogIt PmiFile "modified for VDM support"
        end

    end
    exit 0

/*
 * MakeBackup
 *
 * Creates a backup filename
 */
GetBackupName: procedure
parse arg srcFile
    parse var srcFile srcName '.' extText
    count = 0
    do while (count < 1.0)
        count = count + 0.001
        extText = format(count,1,3)
        dstFile = srcName || right(extText,4)
        rc = stream(dstFile,'C','Q EXISTS')
        if rc = "" then leave
    end
    return dstFile

/*
 * InsertLine
 *
 * Modifies specified file to include given line after line
 * including specified keyword
 */
InsertLine: procedure
parse arg srcFile, dstFile, searchText, insertText

    rc = stream(srcFile,'C','OPEN READ')
    if (rc = "ERROR") then
        return 1
    rc = stream(dstFile,'C','OPEN WRITE')
    if (rc = "ERROR") then
    do
        rc = stream(srcFile,'C','CLOSE')
        return 2
    end

    call lineout dstFile,,1
    rcFound = 3

    do until (lines(srcFile) = 0)

        currLine = linein(srcFile)

        /* if this line doesn't match what we're inserting,
         * then copy it to new file
         */
        rc = WhitespaceCompare(currLine, insertText)
        if rc <> 0 then
        do
            rc = lineout(dstFile, currLine)
        end

        /* if this line contains the search text, add the
         * insert text to new file
         */
        rc = FindText(currLine, searchText)
        if rc <> 0 then
        do
            rc = lineout(dstFile, insertText)
            rcFound = 0
        end

    end

    rc = stream(srcFile, 'C', 'CLOSE')
    rc = stream(dstFile, 'C', 'CLOSE')

    return rcFound

/*
 * Returns zero if text are equal
 */
WhitespaceCompare: procedure
parse upper arg inputText, matchText
    inputText = StripSpace(inputText)
    matchText = StripSpace(matchText)
    return Compare(inputText, matchText)

/*
 * Returns position if search text found
 */
FindText: procedure
parse upper arg inputText, searchText
    inputText = StripSpace(inputText)
    searchText = StripSpace(searchText)
    return pos(searchText, inputText)

/*
 * Strips all whitespace out of line
 */
StripSpace: procedure
parse arg currText
    do until (endText = "")
        parse var currText beginText ' ' endText
        currText = beginText || endText
    end
    return currText

/*
 * Signal Handler
 */
SignalHandler:
    say "Ctrl-Break disabled"
    return

