#!/bin/sh

sdl_base="/usr/local"

# oops...
CC="gcc.exe -Wall -pedantic -Zexe -DUSE_AOUT_AS_DEFAULT"
CXX="g++.exe -Wall -Zexe"
export ac_cv_prog_CC="$CC"
export ac_cv_prog_CXX="$CXX"

CPPFLAGS="-Zmt"
# gcc 3.3.5
CXXFLAGS="-Wall -O3 -mcpu=pentium4 -march=pentium -fno-strict-aliasing -fexceptions -fno-omit-frame-pointer"
CFLAGS="$CXXFLAGS"

#
LDFLAGS="-s -Zmt -Zstack 16384 -Zomf -Zno-high-mem -Zmap"

NASM="nasm"
#NASM="nasm098"
NASM_FMT="aout"

export CC
export CXX
export CPPFLAGS
export CFLAGS
export CXXFLAGS
export LDFLAGS
export LIBS
export EXAMPLES
export NASM
export NASM_FMT

export LN="cp -p"
export AWK="awk"
export SED="sed"
export ac_cv_path_SED="$SED"
export lt_cv_path_NM="nm -B"
export lt_cv_sys_max_cmd_len="8192"
export lt_cv_path_SED="$SED"

export ac_cv_prog_NASM="$NASM"

export ac_cv_func_SDL_WM_ToggleFullScreen="yes"


#platform='i586-pc-os2-emx'
# kludge (Yes, you should be better to `autoreconf' the package...)
platform='i586-pc-linux-gnuaout'

./configure ${platform} \
  --cache-file=config.cache-gcc335 \
  --prefix=/usr/local \
  --with-sdl-prefix=${sdl_base} \
  --with-nasm \
  --with-mmx \
  --without-opengl \
  --without-musa \
  --with-star

rm -f star/star star/star.exe
rm -f mz80/makez80 mz80/makez80.exe
rm -f sdl/pbm2df sdl/pbm2df.exe sdl/pbm2df.map

