// ---------------------------------------------------------------------------
//	Virtual Bus Implementation
//	Copyright (c) cisc 1999.
// ---------------------------------------------------------------------------
//	$Id: device.cpp,v 1.9 1999/07/15 12:33:53 cisc Exp $

#include "headers.h"
#pragma hdrstop

#include "device.h"
#include "device_i.h"

//#define LOGNAME "membus"
#include "diag.h"

// ---------------------------------------------------------------------------
//	Memory Bus
//	\zEp
//
MemoryBus::MemoryBus()
: pages(0), ownpages(false)
{
}

MemoryBus::~MemoryBus()
{
	if (ownpages)
		delete[] pages;
}

// ---------------------------------------------------------------------------
//	
//	arg:	npages	oN
//			_pages	Page \̂ array (Oŗpӂꍇ)
//					ȗ MemoryBus ŗp
//
bool MemoryBus::Init(uint npages, Page* _pages)
{
	if (pages && ownpages)
		delete[] pages;

	if (_pages)
	{
		pages = _pages;
		ownpages = false;
	}
	else
	{
		pages = new Page[npages];
		if (!pages)
			return false;
		ownpages = true;
	}
	
	for (Page* b=pages; npages>0; npages--, b++)
	{
		b->read  = (void*)(uint(rddummy) | idbit);
		b->write = (void*)(uint(wrdummy) | idbit);
		b->inst = 0;
		b->wait = 0;
	}
	return true;
}


// ---------------------------------------------------------------------------
//	_~[o͊֐
//
uint MEMCALL MemoryBus::rddummy(void*, uint addr)
{
	LOG2("bus: Read on undefined memory page 0x%x. (addr:0x%.4x)\n",
			addr >> pagebits, addr);
	return 0xff;
}

void MEMCALL MemoryBus::wrdummy(void*, uint addr, uint data)
{
	LOG3("bus: Write on undefined memory page 0x%x, (addr:0x%.4x data:0x%.2x)\n",
			addr >> pagebits, addr, data);
}

// ---------------------------------------------------------------------------
//	IO Bus
//
IOBus::DummyIO IOBus::dummyio;

IOBus::IOBus()
: ins(0), outs(0), flags(0), banksize(0)
{
}

IOBus::~IOBus()
{
	delete[] ins;
	delete[] outs;
	delete[] flags;
}

//	
bool IOBus::Init(uint nbanks)
{
	delete[] ins;
	delete[] outs;
	delete[] flags;
	
	banksize = nbanks;
	ins = new InBank[nbanks];
	outs = new OutBank[nbanks];
	flags = new uint8[nbanks];
	if (!ins || !outs || !flags)
		return false;
	
	memset(flags, 0, nbanks);

	for (int i=0; i<nbanks; i++)
	{
		ins[i].device = &dummyio;
		ins[i].func = static_cast<InFuncPtr> (&DummyIO::dummyin);
		ins[i].next = 0;
		outs[i].device = &dummyio;
		outs[i].func = static_cast<OutFuncPtr> (&DummyIO::dummyout);
		outs[i].next = 0;
	}
	
	return true;
}

//	foCXڑ
bool IOBus::Connect(Device* device, const Connector* connector)
{
	const Device::Descriptor* desc = device->GetDesc();

	for (; connector->rule; connector++)
	{
		switch (connector->rule & 3)
		{
		case portin:
			if (!ConnectIn(connector->bank, device, desc->indef[connector->id]))
				return false;
			break;

		case portout:
			if (!ConnectOut(connector->bank, device, desc->outdef[connector->id]))
				return false;
			break;
		}
		if (connector->rule & sync)
			flags[connector->bank] = 1;
	}
	return true;
}

bool IOBus::ConnectIn(uint bank, Device* device, InFuncPtr func)
{
	InBank* i = &ins[bank];
	if (i->func == &DummyIO::dummyin)
	{
		// ŏ̐ڑ
		i->device = device;
		i->func = func;
	}
	else
	{
		// 2ڈȍ~̐ڑ
		InBank* j = new InBank;
		if (!j)
			return false;
		j->device = device;
		j->func = func;
		j->next = i->next;
		i->next = j;
	}
	return true;
}

bool IOBus::ConnectOut(uint bank, Device* device, OutFuncPtr func)
{
	OutBank* i = &outs[bank];
	if (i->func == &DummyIO::dummyout)
	{
		// ŏ̐ڑ
		i->device = device;
		i->func = func;
	}
	else
	{
		// 2ڈȍ~̐ڑ
		OutBank* j = new OutBank;
		if (!j)
			return false;
		j->device = device;
		j->func = func;
		j->next = i->next;
		i->next = j;
	}
	return true;
}

bool IOBus::Disconnect(Device* device)
{
	int i;
  	for (i=0; i<banksize; i++)
	{
		InBank* current = &ins[i];
		InBank* referer = 0;
		while (current)
		{
			InBank* next = current->next;
			if (current->device == device)
			{
				if (referer)
				{
					referer->next = next;
					delete current;
				}
				else
				{
					// 폜ׂACeŏɂꍇ
					if (next)
					{
						// ̃ACe̓e𕡎ʂč폜
						*current = *next;
						referer = 0;
						delete next;
						continue;
					}
					else
					{
						// ̃ACeB̃ACeꍇ
						current->func = static_cast<InFuncPtr> (&DummyIO::dummyin);
					}
				}
			}
			current = next;
		}
	}

  	for (i=0; i<banksize; i++)
	{
		OutBank* current = &outs[i];
		OutBank* referer = 0;
		while (current)
		{
			OutBank* next = current->next;
			if (current->device == device)
			{
				if (referer)
				{
					referer->next = next;
					delete current;
				}
				else
				{
					// 폜ׂACeŏɂꍇ
					if (next)
					{
						// ̃ACe̓e𕡎ʂč폜
						*current = *next;
						referer = 0;
						delete next;
						continue;
					}
					else
					{
						// ̃ACeB̃ACeꍇ
						current->func = static_cast<OutFuncPtr> (&DummyIO::dummyout);
					}
				}
			}
			current = next;
		}
	}
	return true;
}

uint IOBus::In(uint port)
{
	InBank* list = &ins[port >> iobankbits];

	uint data = 0xff;
	do
	{
		data &= (list->device->*list->func)(port);
		list = list->next;
	} while (list);
	return data;
}

void IOBus::Out(uint port, uint data)
{
	OutBank* list = &outs[port >> iobankbits];
	do
	{
		(list->device->*list->func)(port, data);
		list = list->next;
	} while (list);
}

uint IOBus::DummyIO::dummyin(uint)
{
	return IOBus::Active(0xff, 0xff);
}

void IOBus::DummyIO::dummyout(uint, uint)
{
	return;
}

// ---------------------------------------------------------------------------
//	Bus
//
bool Bus::Init(uint nports, uint npages, Page* pages)
{
	if (!IOBus::Init(nports))
		return false;

	if (!MemoryBus::Init(npages, pages))
		return false;

	return true;
}

