// ---------------------------------------------------------------------------
//  Scheduling class
//  Copyright (C) cisc 1999.
// ---------------------------------------------------------------------------
//  $Id: schedule.cpp,v 1.9 1999/07/04 08:47:37 cisc Exp $

#include "headers.h"
#include "schedule.h"
#include "misc.h"

#ifndef __OS2__
using namespace std;
#else
#endif

#define LOGNAME "schedule"
#include "diag.h"

/*
#define EVITEM  \
    {for(int i=evlast;i>=0;i--){if(events[i].inst) \
    {uint id=BSwap(events[i].inst->GetID());LOG1("<%.4s>",(char*)&id);}}LOG0("\n");}
*/

// ---------------------------------------------------------------------------

Scheduler::Scheduler()
{
    events = 0;
    evmax = evlast = 0;
}

Scheduler::~Scheduler()
{
}

// ---------------------------------------------------------------------------

bool Scheduler::Init(int mevents)
{
    delete[] events;

    evmax = mevents;
    evlast = -1;
    events = new Event[mevents];

    time = 0;
    return events != 0;
}

// ---------------------------------------------------------------------------
//  ԃCxgǉ
//
Scheduler::Event* Scheduler::AddEvent
(int count, Device* inst, Device::TimeFunc func, int arg, bool repeat)
{
//    assert(inst && func);
//    assert(count > 0);

    int i;
    // 󂢂Ă Event T
    for (i=0; i<=evlast; i++)
        if (!events[i].inst)
            break;
    if (i>=evmax)
        return 0;
    if (i>evlast)
        evlast = i;

    Event& ev = events[i];
    ev.count = GetTime() + count;
    ev.inst = inst, ev.func = func, ev.arg = arg;
    ev.time = repeat ? count : 0;

//  uint id = BSwap(inst->GetID());
//  LOG4("%.8d: %.8d %.4s count=%.8d\n", ev.count - count, ev.count, (char*)&id, count);
//  LOG0("Addevent:");
//  EVITEM;

    // ŒZCxgXVH
    if ((etime - ev.count) > 0)
    {
        Shorten(etime - ev.count);
        etime = ev.count;
    }
    return &ev;
}

// ---------------------------------------------------------------------------
//  ԃCxg̑ύX
//
void Scheduler::SetEvent
(Event* ev, int count, Device* inst, Device::TimeFunc func, int arg, bool repeat)
{
//    assert(inst && func);
//    assert(count > 0);

    ev->count = GetTime() + count;
    ev->inst = inst, ev->func = func, ev->arg = arg;
    ev->time = repeat ? count : 0;

    // ŒZCxgXVH
    if ((etime - ev->count) > 0)
    {
        Shorten(etime - ev->count);
        etime = ev->count;
    }
}


// ---------------------------------------------------------------------------
//  ԃCxg폜
//
bool Scheduler::DelEvent(Device* inst)
{
    Event* ev = &events[evlast];
    for (int i=evlast; i>=0; i--, ev--)
    {
        if (ev->inst == inst)
        {
            ev->inst = 0;
            if (evlast == i)
                evlast--;
        }
    }
    return true;
}

bool Scheduler::DelEvent(Event* ev)
{
    ev->inst = 0;
    if (ev - events == evlast)
        evlast--;
    return true;
}

// ---------------------------------------------------------------------------
//  Ԃi߂
//
int Scheduler::Proceed(int ticks)
{
    int t;
    for (t=ticks; t>0; )
    {
        int i;
        int ptime = t;
        for (i=0; i<=evlast; i++)
        {
            Event& ev = events[i];
            if (ev.inst)
            {
                int l = ev.count - time;
                if (l < ptime)
                    ptime = l;
            }
        }

        etime = time + ptime;

        executing = true;
        int xtime = Execute(ptime);
        etime = time += xtime;
        t -= xtime;
        executing = false;

        // Cxg쓮
//      LOG0("Proceed1:");
//      EVITEM;
        for (i=evlast; i>=0; i--)
        {
            Event& ev = events[i];

            if (ev.inst && (ev.count - time <= 0))
            {
//              uint id = BSwap(events[i].inst->GetID());
//              LOG1("%.4s: timer\n", (char*)&id);
                Device* inst = ev.inst;
                if (ev.time)
                    ev.count += ev.time;
                else
                {
                    ev.inst = 0;
                    if (evlast == i)
                        evlast--;
                }
                (inst->*ev.func)(ev.arg);
            }
        }
//      LOG0("Proceed2:");
//      EVITEM;
    }
    return ticks - t;
}
