// ---------------------------------------------------------------------------
//	PC-8801 emulator
//	Copyright (C) cisc 1999.
// ---------------------------------------------------------------------------
//	荞݃Rg[(PD8214)
// ---------------------------------------------------------------------------
//	$Id: intc.h,v 1.4 1999/03/24 23:27:12 cisc Exp $

#ifndef pc88_intc_h
#define pc88_intc_h

#include "device.h"

namespace PC8801
{

// ---------------------------------------------------------------------------

class INTC : public Device
{
public:
	enum
	{
		reset=0, request, setmask, setreg,
		intack=0
	};

public:
	INTC(const ID& id);
	~INTC();
	bool Init(IOBus* bus, uint irqport);
	void Reset(uint=0, uint=0);
	void Request(uint port, uint en);
	void SetMask(uint, uint data);
	void SetRegister(uint, uint data);
	uint IntAck(uint);

	void* GetInst() { return this; }
	const Descriptor* GetDesc() const { return &descriptor; } 

private:
	void IRQ(bool);
	
	IOBus* bus;
	uint mask;
	uint mask2;
	uint irq;
	uint irqport;

	static const Descriptor descriptor;
	static const InFuncPtr  indef[];
	static const OutFuncPtr outdef[];
};

}

#endif // pc88_intc_h
