// ---------------------------------------------------------------------------
//  M88 - PC-88 Emulator.
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//   ROM
// ---------------------------------------------------------------------------
//  $Id: kanjirom.cpp,v 1.3 1999/03/21 01:41:26 cisc Exp $

#include "headers.h"
#include "file.h"
#include "pc88/kanjirom.h"

using namespace PC8801;

// ---------------------------------------------------------------------------
//  \z/
// ---------------------------------------------------------------------------

KanjiROM::KanjiROM(const ID& id) : Device(id)
{
    image = 0;
    adr = 0;
}

KanjiROM::~KanjiROM()
{
    delete[] image;
}

// ---------------------------------------------------------------------------
//  
//
bool KanjiROM::Init(const char* filename)
{
    delete[] image;
    image = new uint8[0x20000];
    if (!image)
        return false;
    memset(image, 0xff, 0x20000);

    FileIO file(filename, FileIO::readonly);
    if (file.GetFlags() & FileIO::open)
    {
        file.Seek(0, FileIO::begin);
        file.Read(image, 0x20000);
    }
    return true;
}

// ---------------------------------------------------------------------------
//  I/O
//
void KanjiROM::SetL(uint, uint d)
{
    adr = (adr & ~0xff) | d;
}

void KanjiROM::SetH(uint, uint d)
{
    adr = (adr & 0xff) | (d * 0x100);
}

uint KanjiROM::ReadL(uint)
{
    return image[adr * 2 + 1];
}

uint KanjiROM::ReadH(uint)
{
    return image[adr * 2];
}

// ---------------------------------------------------------------------------
//  device description
//
const Device::Descriptor KanjiROM::descriptor =
{
    KanjiROM::indef, KanjiROM::outdef
};

const Device::OutFuncPtr KanjiROM::outdef[] =
{
#ifndef __OS2__
    static_cast<OutFuncPtr> (SetL),
    static_cast<OutFuncPtr> (SetH),
#else
    (Device::OutFuncPtr) (SetL),
    (Device::OutFuncPtr) (SetH),
#endif
};

const Device::InFuncPtr KanjiROM::indef[]  =
{
#ifndef __OS2__
    static_cast<InFuncPtr> (ReadL),
    static_cast<InFuncPtr> (ReadH),
#else
    (Device::InFuncPtr) (ReadL),
    (Device::InFuncPtr) (ReadH),
#endif
};
