// ----------------------------------------------------------------------------
//	M88 - PC-8801 series emulator
//	Copyright (C) cisc 1999.
// ----------------------------------------------------------------------------
//	Main (ALU)̎
// ----------------------------------------------------------------------------
//	$Id: memory.h,v 1.16 1999/07/22 15:55:13 cisc Exp $

#ifndef pc88_memory_h
#define pc88_memory_h

#include "device.h"
#include "config.h"

namespace PC8801
{
class CRTC;

class Memory : public Device
{
public:
	enum IDOut
	{
		reset=0, out31, out32, out34, out35, out40,
		  out5x, out70, out71, out78, out99, oute2,
		  oute3, outf0, outf1, vrtc
	};
	enum IDIn
	{
		in32=0, in5c, in70, in71, ine2, ine3
	};
	union quadbyte
	{
		uint32 pack;
		uint8 byte[4];
	};
	enum ROM { n88 = 0, n88e = 0x8000, n80 = 0x10000, romsize = 0x18000 };
	
public:
	Memory(const ID& id);
	~Memory();
	const Descriptor* GetDesc() const { return &descriptor; } 
	
	void ApplyConfig(const Config* cfg);
	uint8* GetRAM() { return ram; }
	uint8* GetTVRAM() { return tvram; }
	quadbyte* GetGVRAM() { return gvram; }
	uint8* GetROM() { return rom; }
	uint8* GetDirtyFlag() { return dirty; }

	bool Init(Bus* bus, CRTC* crtc);
	void Reset(uint, uint);
	void Out31(uint, uint data);
	void Out32(uint, uint data);
	void Out34(uint, uint data);
	void Out35(uint, uint data);
	void Out40(uint, uint data);
	void Out5x(uint port, uint);
	void Out70(uint, uint data);
	void Out71(uint, uint data);
	void Out78(uint, uint data);
	void Out99(uint, uint data);
	void Oute2(uint, uint data);
	void Oute3(uint, uint data);
	void Outf0(uint, uint data);
	void Outf1(uint, uint data);
	uint In32(uint);
	uint In5c(uint);
	uint In70(uint);
	uint In71(uint);
	uint Ine2(uint);
	uint Ine3(uint);
	void VRTC(uint, uint data);
	
private:
	struct WaitDesc
	{
		uint b0, bc, bf;
	};

	bool InitMemory();
	bool LoadROM();
	bool LoadROMImage(uint8* at, const char* file, int length);
	void LoadOptROM(const char* file, uint8*& rom, int length);
	void SetWait();
	void SelectJisyo();

	void Update00R();
	void Update60R();
	void Update00W();
	void Update80();
	void UpdateC0();
	void UpdateF0();
	void UpdateN80W();
	void UpdateN80R();
	void UpdateN80G();
	void SelectGVRAM();
	void SelectALU();
	void SetRAMPattern(uint8* ram, uint length);
	
	Bus* bus;
	CRTC* crtc;
	uint8* rom;
	uint8* ram;
	uint8* eram;
	uint8* tvram;
	uint8* dicrom;		// ROM
	uint8* cdbios;		// CD-ROM BIOS ROM
	uint8* n80rom;		// N80-BASIC ROM

	uint port31, port32, port34, port35, port40, port99;
	uint port5x, txtwnd, port71, porte2, porte3, portf0;
	uint sw31;
	uint waitmode;
	uint waittype;	// b0 = disp/vrtc, 
	bool selgvram;
	bool seldic;
	bool enablewait;
	bool n80mode;
	Config::BASICMode newmode;
	uint erambanks;
	uint8* r00;
	uint8* r60;
	uint8* w00;
	uint8* rc0;
	quadbyte alureg;
	quadbyte maskr, maski, masks, aluread;
	
	quadbyte gvram[0x4000];
	uint8 dirty[0x400];
	
	static const WaitDesc waittable[48];

	static void MEMCALL WrWindow(void* inst, uint addr, uint data);
	static uint MEMCALL RdWindow(void* inst, uint addr);

	static void MEMCALL WrGVRAM0(void* inst, uint addr, uint data);
	static void MEMCALL WrGVRAM1(void* inst, uint addr, uint data);
	static void MEMCALL WrGVRAM2(void* inst, uint addr, uint data);
	static uint MEMCALL RdGVRAM0(void* inst, uint addr);
	static uint MEMCALL RdGVRAM1(void* inst, uint addr);
	static uint MEMCALL RdGVRAM2(void* inst, uint addr);

	static void MEMCALL WrALUSet(void* inst, uint addr, uint data);
	static void MEMCALL WrALURGB(void* inst, uint addr, uint data);
	static void MEMCALL WrALUR(void* inst, uint addr, uint data);
	static void MEMCALL WrALUB(void* inst, uint addr, uint data);
	static uint MEMCALL RdALU(void* inst, uint addr);

	static const Descriptor descriptor;
	static const InFuncPtr indef[];
	static const OutFuncPtr outdef[];
};

}; // namespace PC8801

#endif 