// ---------------------------------------------------------------------------
//	M88 - PC-88 Emulator.
//	Copyright (C) cisc 1997, 1999.
// ---------------------------------------------------------------------------
//  ʐƃOtBbNXʍ
// ---------------------------------------------------------------------------
//	$Id: screen.h,v 1.10 1999/07/22 15:55:13 cisc Exp $

#if !defined(pc88_screen_h)
#define pc88_screen_h

#include "types.h"
#include "device.h"
#include "draw.h"
#include "config.h"

// ---------------------------------------------------------------------------
//	color mode
//	BITMAP BIT zu		-- GG GR GB TE TG TR TB 
//	ATTR BIT zu		G  R  B  CG UL OL SE RE
//
//	b/w mode
//	BITMAP BIT zu		-- -- G  RE TE TG TB TR
//	ATTR BIT zu		G  R  B  CG UL OL SE RE
//
namespace PC8801
{

class Memory;
class CRTC;

// ---------------------------------------------------------------------------
//	88 ̉ʂɊւNX
//
class Screen : public Device
{
public:
	enum IDOut
	{
		reset=0, out30, out31, out32, out52, out53, out54, out55to5b
	};

public:
	Screen(const ID& id);
	~Screen();
	
	bool Init(Bus* bus, Memory* memory, CRTC* crtc);
	void Reset(uint=0, uint=0);
	bool UpdatePalette(Draw* draw);
	void UpdateScreen(uint8* image, int bpl, Draw::Region& region);
	void ApplyConfig(const Config* config);
	
	const Descriptor* GetDesc() const { return &descriptor; } 

private:
	struct Pal
	{
		uint8 red, blue, green, _pad;
	};

	void CreateTable();
	
	void ClearScreen(uint8* image, int bpl);
	void UpdateScreen200c(uint8* image, int bpl, Draw::Region& region);
	void UpdateScreen200b(uint8* image, int bpl, Draw::Region& region);
	void UpdateScreen400b(uint8* image, int bpl, Draw::Region& region);
	
	void UpdateScreen80c(uint8* image, int bpl, Draw::Region& region);
	void UpdateScreen80b(uint8* image, int bpl, Draw::Region& region);
	
	void Out30(uint port, uint data);
	void Out31(uint port, uint data);
	void Out32(uint port, uint data);
	void Out52(uint port, uint data);
	void Out53(uint port, uint data);
	void Out54(uint port, uint data);
	void Out55to5b(uint port, uint data);
	
	Bus* bus;
	Memory* memory;
	CRTC* crtc;
	
	Pal pal[8];
	Pal bgpal;
	int prevgmode;
	int prevpmode;

	static const Draw::Palette palcolor[8];

	const uint8* pex;

	uint8 port30;
	uint8 port31;
	uint8 port32;
	uint8 port53;
	
	bool fullline;
	bool fv15k;
	bool line400;	
	bool line320;		// 320x200 mode
	uint8 displayplane;
	bool displaytext;
	bool palettechanged;
	bool modechanged;
	bool color;
	bool displaygraphics;
	bool texttp;
	bool n80mode;
	Config::BASICMode newmode;
	
	static packed BETable0[1 << sizeof(packed)];
	static packed BETable1[1 << sizeof(packed)];
	static packed BETable2[1 << sizeof(packed)];
	static packed E80Table[1 << sizeof(packed)];
	static const uint8 palextable[2][8];

private:
	static const Descriptor descriptor;
//	static const InFuncPtr indef[];
	static const OutFuncPtr outdef[];
};

}

#endif // !defined(pc88_screen_h)
