// ---------------------------------------------------------------------------
//	M88 - PC-8801 Series Emulator
//	Copyright (C) cisc 1999.
// ---------------------------------------------------------------------------
//	Implementation of USART(uPD8251AF)
// ---------------------------------------------------------------------------
//	$Id: sio.h,v 1.1 1999/04/02 13:32:26 cisc Exp $

#ifndef pc88_sio_h
#define pc88_sio_h

#include "device.h"

class Scheduler;

namespace PC8801
{

class SIO : public Device
{
public:
	enum
	{
		reset=0, setcontrol, setdata,
		getstatus=0, getdata,
	};

public:
	SIO(const ID& id);
	~SIO();
	bool Init(Bus* bus, uint prxrdy, Scheduler* scheduler);

	void Reset(uint=0, uint=0);
	void SetControl(uint, uint d);
	void SetData(uint, uint d);
	uint GetStatus(uint=0);
	uint GetData(uint=0);

	const Descriptor* GetDesc() const { return &descriptor; }

private:
	enum Mode { clear=0, async, sync1, sync2, sync };
	enum Parity { none='N', odd='O', even='E' };
	
	Bus* bus;
	uint prxrdy;
	Scheduler* scheduler;
	uint baseclock;
	uint clock;
	uint datalen;
	uint stop;
	uint status;
	Mode mode;
	Parity parity;
	bool rxen;
	bool txen;

private:
	enum Status
	{
		TXRDY	= 0x01,
		RXRDY	= 0x02,
		TXE		= 0x04,
		PE		= 0x08,
		OE		= 0x10,
		FE		= 0x20,
		SYNDET	= 0x40,
		DSR		= 0x80,
	};

private:
	static const Descriptor descriptor;
	static const InFuncPtr  indef[];
	static const OutFuncPtr outdef[];
};

}

#endif // pc88_sio_h

