// ---------------------------------------------------------------------------
//  M88 - PC88 emulator
//  Copyright (c) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  PC88 Keyboard Interface Emulation for Win32/106 key (Rev. 3)
// ---------------------------------------------------------------------------
//  $Id: WinKeyIF.h,v 1.2 1999/07/22 15:57:28 cisc Exp $

#ifndef WIN32_WINKEYIF_H
#define WIN32_WINKEYIF_H

#include "device.h"
#include "CritSect.h"

// ---------------------------------------------------------------------------
namespace PC8801
{

class Config;

class WinKeyIF : public Device
{
public:
    enum
    {
        reset = 0, vsync,
        in = 0,
    };

public:
    WinKeyIF();
    ~WinKeyIF();
    bool Init(HWND);
    void ApplyConfig(const Config* config);

    uint In(uint port);
    void VSync(uint, uint data);
    void Reset(uint=0, uint=0);

    void Activate(bool);
    void Disable(bool);
    void KeyDown(uint, uint32);
    void KeyUp(uint, uint32);

    const Descriptor* GetDesc() const { return &descriptor; }

private:
    enum KeyState
    {
        locked = 1,
        down   = 2,
        downex = 4,
    };
    enum KeyFlags
    {
        none = 0, lock, nex, ext, arrowten, keyb, noarrowten, noarrowtenex,
        pc80sft, pc80key,
    };
    struct Key
    {
        uint8 k, f;
    };

    uint GetKey(const Key* key);

    static const Key KeyTable98[16 * 8][8];
    static const Key KeyTable106[16 * 8][8];

    const Key* keytable;
    int keyboardtype;
    bool active;
    bool disable;
    bool usearrow;
    bool pc80mode;
    HWND hwnd;
#ifdef __OS2__
#else
    HANDLE hevent;
#endif
    uint basicmode;
    int keyport[16];
    uint8 keyboard[256];
    uint8 keystate[512];

private:
    static const Descriptor descriptor;
    static const InFuncPtr  indef[];
    static const OutFuncPtr outdef[];
};

}

#endif // WIN32_WINKEYIF_H
