// ---------------------------------------------------------------------------
//  M88 - PC-8801 emulator
//  Copyright (C) cisc 1999.
// ---------------------------------------------------------------------------
//  $Id: soundmon.cpp,v 1.3 1999/06/26 08:17:08 cisc Exp $

#include "headers.h"
#include "resource.h"
#include "soundmon.h"
#include "misc.h"

// ---------------------------------------------------------------------------
//  \z/
//
OPNMonitor::OPNMonitor()
{
    hwnd = 0;
    fontheight = 12;
#ifndef __OS2__
    dlgproc.SetDestination(DlgProcGate, this);
#endif
    w = 600;
    h = 200;
}

OPNMonitor::~OPNMonitor()
{
}

bool OPNMonitor::Init(const uint8* reg)
{
    regs = reg;
    return true;
}

// ---------------------------------------------------------------------------
//  _CAO\
//
#ifdef __OS2__
void OPNMonitor::Show(HWND hwndparent, bool show)
{
}
#else
void OPNMonitor::Show(HINSTANCE hinst, HWND hwndparent, bool show)
{
    if (show)
    {
        if (!hwnd)
        {
            hwnd = CreateDialog(hinst, MAKEINTRESOURCE(IDD_SOUNDMON),
                                hwndparent, DLGPROC((void*)dlgproc));
            RECT rect;
            rect.left = 0;  rect.right =  w;
            rect.top  = 0;  rect.bottom = h;

            AdjustWindowRectEx(&rect, WS_POPUP | WS_CAPTION | WS_SYSMENU | WS_THICKFRAME, false, 0);

            SetWindowPos(hwnd, 0, 0, 0,
                    rect.right-rect.left, rect.bottom - rect.top,
                    SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE);
            SetFocus(hwndparent);
        }
        else
        {
            SetFocus(hwnd);
        }
    }
    else
    {
        if (hwnd)
            SendMessage(hwnd, WM_CLOSE, 0, 0);
    }
}
#endif

// ---------------------------------------------------------------------------
//  _CAO
//
#ifdef __OS2__
#else
BOOL OPNMonitor::DlgProc(HWND hdlg, UINT msg, WPARAM wp, LPARAM lp)
{
    switch (msg)
    {
    case WM_INITDIALOG:
        SetTimer(hdlg, 1, 50, 0);
        return 0;

    case WM_CLOSE:
        KillTimer(hdlg, 1);
        EndDialog(hdlg, false);
        hwnd = 0;
        return true;

    case WM_PAINT:
        Paint(hdlg);
        return true;

    case WM_TIMER:
        Update();
        return true;

    case WM_SIZE:
        w = LOWORD(lp); h = HIWORD(lp);
        fontheight = Limit(h / 12, 24, 8);
        InvalidateRect(hwnd, 0, true);
        return true;

    default:
        return false;
    }
    return false;
}
#endif

#ifdef __OS2__
#else
BOOL _cdecl OPNMonitor::DlgProcGate
(OPNMonitor* about, HWND hwnd, UINT m, WPARAM w, LPARAM l)
{
    return about->DlgProc(hwnd, m, w, l);
}
#endif

// ---------------------------------------------------------------------------
//  Ps\itj
//
void OPNMonitor::PutLine(const char* msg, ...)
{
#ifdef __OS2__
#else
    char buf[256];
    va_list marker;
    va_start(marker, msg);
    int len = wvsprintf(buf, msg, marker);
    va_end(marker);
    TextOut(hdc, 0, y, buf, len);
    y += fontheight;
#endif
}

// ---------------------------------------------------------------------------
//  PoCg̐l16iLqɕϊ
//
static void ToHex(char** p, uint d)
{
    static const char hex[] = "0123456789abcdef";

    *(*p)++ = hex[d >> 4];
    *(*p)++ = hex[d & 15];
}

// ---------------------------------------------------------------------------
//  FN/BLK  F-number ɕϊ
//
static inline uint ToFnum(uint f)
{
    return (f & 2047) << ((f >> 11) & 7);
}

// ---------------------------------------------------------------------------
//  $bx n̒lϊ
//
static inline uint ToFB(uint f)
{
    return (f & 0xff00) | ((f & 0x38) << 1) | (f & 7);
}

// ---------------------------------------------------------------------------
//  Ԃ\
//
void OPNMonitor::DrawMain(HDC _hdc)
{
#ifdef __OS2__
#else
    hdc = _hdc;
    y = 0;
    char buf[128];
    int y;
    for (y=0; y<3; y++)
    {
        int x;
        char* ptr = buf;
        for (x=0; x<16; x++)
            ToHex(&ptr, regs[x + y * 16]);
        for (x=0; x<16; x++)
            ToHex(&ptr, regs[x + y * 16 + 0x100]);

        PutLine("%.32s %.32s", buf, buf+32);
    }
    for (y=3; y<10; y++)
    {
        char* ptr = buf;
        for (int z=0; z<2; z++)
        {
            for (int c=0; c<3; c++)
            {
                for (int s=0; s<4; s++)
                {
                    const static sct[4] = { 0*4, 2*4, 1*4, 3*4 };
                    ToHex(&ptr, regs[z*0x100 + y*0x10 + sct[s] + c]);
                }
                *ptr++ = ' ';
            }
        }
        *ptr=0;
        PutLine("%x: %.26s    %x: %.26s", y, buf, y, buf+27);
    }
    if (regs[0x27] & 0xc0)
    {
        PutLine("a: %.5x    %.5x    %.5x %.5x a: %.5x    %.5x    %.5x %.5x",
                ToFnum(regs[0x0a4]*0x100+regs[0x0a0]), ToFnum(regs[0x0a5]*0x100+regs[0x0a1]), ToFnum(regs[0x0ad]*0x100+regs[0x0a9]), ToFnum(regs[0x0ae]*0x100+regs[0x0aa]),
                ToFnum(regs[0x1a4]*0x100+regs[0x1a0]), ToFnum(regs[0x1a5]*0x100+regs[0x1a1]), ToFnum(regs[0x1ad]*0x100+regs[0x1a9]), ToFnum(regs[0x1ae]*0x100+regs[0x1aa]));
        PutLine("b: %.4x  %.4x  %.4x  %.5x %.5x b: %.4x  %.4x  %.4x  %.5x %.5x",
                ToFB  (regs[0x0b4]*0x100+regs[0x0b0]), ToFB  (regs[0x0b5]*0x100+regs[0x0b1]), ToFB(regs[0x0b6]*0x100+regs[0x0b2]),
                ToFnum(regs[0x0ac]*0x100+regs[0x0a8]), ToFnum(regs[0x0a6]*0x100+regs[0x0a2]),
                ToFB  (regs[0x1b4]*0x100+regs[0x1b0]), ToFB  (regs[0x1b5]*0x100+regs[0x1b1]), ToFB(regs[0x1b6]*0x100+regs[0x1b2]),
                ToFnum(regs[0x1ac]*0x100+regs[0x1a8]), ToFnum(regs[0x1a6]*0x100+regs[0x1a2]));
    }
    else
    {
        PutLine("a: %.5x    %.5x    %.5x       a: %.5x    %.5x    %.5x",
                ToFnum(regs[0x0a4]*0x100+regs[0x0a0]), ToFnum(regs[0x0a5]*0x100+regs[0x0a1]), ToFnum(regs[0x0a6]*0x100+regs[0x0a2]),
                ToFnum(regs[0x1a4]*0x100+regs[0x1a0]), ToFnum(regs[0x1a5]*0x100+regs[0x1a1]), ToFnum(regs[0x1a6]*0x100+regs[0x1a2]));
        PutLine("b: %.4x     %.4x     %.4x        b: %.4x     %.4x     %.4x",
                ToFB(regs[0x0b4]*0x100+regs[0x0b0]), ToFB(regs[0x0b5]*0x100+regs[0x0b1]), ToFB(regs[0x0b6]*0x100+regs[0x0b2]),
                ToFB(regs[0x1b4]*0x100+regs[0x1b0]), ToFB(regs[0x1b5]*0x100+regs[0x1b1]), ToFB(regs[0x1b6]*0x100+regs[0x1b2]));
    }
#endif
}


void OPNMonitor::Draw(HWND hwnd, HDC hdc)
{
#ifdef __OS2__
#else
    RECT rect;
    GetClientRect(hwnd, &rect);

    HDC hmemdc = CreateCompatibleDC(hdc);
    HBITMAP hbitmap = CreateCompatibleBitmap(hdc, rect.right, rect.bottom);

    hbitmap = (HBITMAP) SelectObject(hmemdc, hbitmap);
    HBRUSH hbrush = (HBRUSH) SelectObject(hmemdc, CreateSolidBrush(bkcol));
    PatBlt(hmemdc, 0, 0, rect.right, rect.bottom, PATCOPY);
    DeleteObject(SelectObject(hmemdc, hbrush));

    HFONT hfont = CreateFont(fontheight, 0, 0, 0, 0, 0, 0, 0,
                    ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
                    DEFAULT_QUALITY, FIXED_PITCH, "Terminal");

    SetTextColor(hmemdc, 0xffffff);
    SetBkColor(hmemdc, bkcol);
//  SetBkMode(hmemdc, TRANSPARENT);
    hfont = (HFONT) SelectObject(hmemdc, hfont);
    DrawMain(hmemdc);
    DeleteObject(SelectObject(hmemdc, hfont));

    BitBlt(hdc, 0, 0, rect.right, rect.bottom, hmemdc, 0, 0, SRCCOPY);

    DeleteObject(SelectObject(hmemdc, hbitmap));
    DeleteDC(hmemdc);
#endif
}

void OPNMonitor::Paint(HWND hwnd)
{
#ifdef __OS2__
#else
    PAINTSTRUCT ps;
    HDC hdc = BeginPaint(hwnd, &ps);
    Draw(hwnd, hdc);
    EndPaint(hwnd, &ps);
#endif
}

void OPNMonitor::Update()
{
#ifdef __OS2__
#else
    if (hwnd)
    {
        HDC hdc = GetDC(hwnd);
        Draw(hwnd, hdc);
        ReleaseDC(hwnd, hdc);
    }
#endif
}
