/*
 * SYSTEM 16 ARCADE EMULATOR SOURCE CODE
 * 
 * Copyright 1996/97 Thierry Lescot
 */

#include "shinobi.h"
#include "cpudefs.h"
#include <allegro.h>

extern char game, game_basename[9], game_name[20];
extern UBYTE *SpritesROM, *TilesROM1;

Load_ROM(char *fn, void *p, ULONG taille) {
   PACKFILE *f;
   if ((f=pack_fopen(fn, F_READ))==NULL) {
      printf("Error, I can't open %s !!!\n", fn);
      exit(1);
   }
   pack_fread(p, taille, f);
   pack_fclose(f);

}

MergeBanks(char *fn1, char *fn2, UBYTE *p) {
   UBYTE *work;
   ULONG i;
   work=(unsigned char *)malloc(0x10000);
   Load_ROM(fn1, work, 0x10000);
   for (i=0;i!=0x10000;i++) p[(i<<1)+1]=work[i];
   Load_ROM(fn2, work, 0x10000);
   for (i=0;i!=0x10000;i++) p[(i<<1)]=work[i];
   free(work);
}

MergeBanks256k(char *fn1, char *fn2) {
   UBYTE *work;
   ULONG i, p;
   work=(unsigned char *)malloc(0x40000);
   Load_ROM(fn1, work, 0x40000);
   for (p=0;p!=8;p++)
   for (i=0;i!=0x8000;i++) RAM[p][(i<<1)+1]=work[(0x8000*p)+i];
   Load_ROM(fn2, work, 0x40000);
   for (p=0;p!=8;p++)
   for (i=0;i!=0x8000;i++) RAM[p][i<<1]=work[(0x8000*p)+i];
   free(work);
}

MergeBanks128k(char *fn1, char *fn2) {
   UBYTE *work;
   ULONG i, p;
   work=(unsigned char *)malloc(0x20000);
   Load_ROM(fn1, work, 0x20000);
   for (p=0;p!=4;p++)
   for (i=0;i!=0x8000;i++) RAM[p][(i<<1)+1]=work[(0x8000*p)+i];
   Load_ROM(fn2, work, 0x20000);
   for (p=0;p!=4;p++)
   for (i=0;i!=0x8000;i++) RAM[p][i<<1]=work[(0x8000*p)+i];
   free(work);
}

MergeBanks256kSPR(char *fn1, char *fn2, UBYTE *p) {
   UBYTE *work;
   ULONG i;
   work=(unsigned char *)malloc(0x40000);
   Load_ROM(fn1, work, 0x40000);
   for (i=0;i!=0x40000;i++) p[(i<<1)+1]=work[i];
   Load_ROM(fn2, work, 0x40000);
   for (i=0;i!=0x40000;i++) p[i<<1]=work[i];
   free(work);
}

MergeBanks64k(char *fn1, char *fn2, UBYTE *p1, UBYTE *p2) {
   UBYTE *work;
   ULONG i;
   work=(unsigned char *)malloc(0x10000);
   Load_ROM(fn1, work, 0x10000);
   for (i=0;i!=0x8000;i++) p1[(i<<1)+1]=work[i];
   for (i=0;i!=0x8000;i++) p2[(i<<1)+1]=work[0x8000+i];
   Load_ROM(fn2, work, 0x10000);
   for (i=0;i!=0x8000;i++) p1[(i<<1)]=work[i];
   for (i=0;i!=0x8000;i++) p2[(i<<1)]=work[0x8000+i];
   free(work);
}

MergeBanks32k(char *fn1, char *fn2, UBYTE *p1) {
   UBYTE *work;
   ULONG i;
   work=(unsigned char *)malloc(0x8000);
   Load_ROM(fn1, work, 0x8000);
   for (i=0;i!=0x8000;i++) p1[(i<<1)+1]=work[i];
   Load_ROM(fn2, work, 0x8000);
   for (i=0;i!=0x8000;i++) p1[(i<<1)]=work[i];
   free(work);
}

Load_GameROM() {
   int i;
   for (i=0;i!=4;i++) RAM[i]=(UBYTE *)malloc(0x10000);
	printf("Loading CPU code[");
   switch (game) {
    case 1:
      MergeBanks64k("shinobi.a1", "shinobi.a4", 
		    (UBYTE *)&RAM[0x00][0], (UBYTE *)&RAM[0x01][0]);
      MergeBanks64k("shinobi.a2", "shinobi.a5", 
		    (UBYTE *)&RAM[0x02][0], (UBYTE *)&RAM[0x03][0]);
      break;
    case 2:
      MergeBanks128k("ab11739.bin", "ab11740.bin");
	printf(".]\n");
      break;
    case 3:
      for (i=4;i!=8;i++) RAM[i]=(UBYTE *)malloc(0x10000);
      MergeBanks256k("ga12544.bin", 
		     "ga12545.bin");
      break;
    case 4:
      MergeBanks32k("ts10850.bin",
		    "ts10853.bin", RAM[0x00]);
      MergeBanks32k("ts10851.bin",
		    "ts10854.bin", RAM[0x01]);
      MergeBanks32k("ts10852.bin",
		    "ts10855.bin", RAM[0x02]);
      break;
    case 5:
      MergeBanks32k("quartet2.a1", "quartet2.a4", RAM[0x00]);
      MergeBanks32k("quartet2.a2", "quartet2.a5", RAM[0x01]);
      MergeBanks32k("quartet2.a3", "quartet2.a6", RAM[0x02]);
      break;
    case 6:
      for (i=4;i!=8;i++) RAM[i]=(UBYTE *)malloc(0x10000);
      MergeBanks256k("sd12721b.bin", "sd12722b.bin");
      break;
   }
}

Load_SpritesROM() {
printf("Loading SPRITE ROMS:[");
   switch (game) {
    case 1:
      SpritesROM=(UBYTE *)malloc(0x80000);
      MergeBanks("shinobi.b1", "shinobi.b5", 
		 (UBYTE *)&SpritesROM[0x00000]);
      MergeBanks("shinobi.b2", "shinobi.b6",
		 (UBYTE *)&SpritesROM[0x20000]);
      MergeBanks("shinobi.b3", "shinobi.b7",
		 (UBYTE *)&SpritesROM[0x40000]);
      MergeBanks("shinobi.b4", "shinobi.b8",
		 (UBYTE *)&SpritesROM[0x60000]);
      break;
    case 2:
      SpritesROM=(UBYTE *)malloc(0xF0000);
      MergeBanks("ab11677.bin", "ab11681.bin", 
		 (UBYTE *)&SpritesROM[0x00000]);
	printf(".");
      MergeBanks("ab11678.bin", "ab11682.bin",
		 (UBYTE *)&SpritesROM[0x40000]);
	printf(".");
      MergeBanks("ab11679.bin", "ab11683.bin",
		 (UBYTE *)&SpritesROM[0x80000]);
	printf(".");
      MergeBanks("ab11680.bin", "ab11684.bin",
		 (UBYTE *)&SpritesROM[0xC0000]);
	printf(".");
      MergeBanks("ab11728.bin", "ab11732.bin",
		 (UBYTE *)&SpritesROM[0x60000]);
	printf(".");
      MergeBanks("ab11726.bin", "ab11730.bin",
		 (UBYTE *)&SpritesROM[0x20000]);
	printf(".");
      MergeBanks("ab11718.bin", "ab11734.bin",
		 (UBYTE *)&SpritesROM[0xA0000]);
	printf(".]\n");
      break;
    case 3:
      SpritesROM=(UBYTE *)malloc(0x180000);
      MergeBanks256kSPR("ga12378.bin", "ga12379.bin", &SpritesROM[0x000000]);
      MergeBanks256kSPR("ga12380.bin", "ga12381.bin", &SpritesROM[0x080000]);
      MergeBanks256kSPR("ga12382.bin", "ga12383.bin", &SpritesROM[0x100000]);
      break;
    case 4:
      SpritesROM=(UBYTE *)malloc(0x40000);
      MergeBanks32k("ts10548.bin", "ts10552.bin", 
		    (UBYTE *)&SpritesROM[0x00000]);
      MergeBanks32k("ts10549.bin", "ts10553.bin",
		    (UBYTE *)&SpritesROM[0x10000]);
      MergeBanks32k("ts10550.bin", "ts10554.bin",
		    (UBYTE *)&SpritesROM[0x20000]);
      MergeBanks32k("ts10551.bin", "ts10555.bin",
		    (UBYTE *)&SpritesROM[0x30000]);
      break;
    case 6:
      SpritesROM=(UBYTE *)malloc(0x200000);
      MergeBanks256kSPR("sd12719.bin", "sd12726.bin", &SpritesROM[0x000000]);
      MergeBanks256kSPR("sd12718.bin", "sd12725.bin", &SpritesROM[0x080000]);
      MergeBanks256kSPR("sd12717.bin", "sd12724.bin", &SpritesROM[0x100000]);
      MergeBanks256kSPR("sd12716.bin", "sd12723.bin", &SpritesROM[0x180000]);
      break;
   }
}

Load_TilesROM() {
   PACKFILE *f;
   UBYTE *work, t;
   UBYTE b;
   ULONG pw, pr;
   ULONG tailles[6] = {0x10000,0x20000,0x20000,0x8000,0x8000,0x40000};
   ULONG taille=tailles[game-1];
   ULONG taille2=taille*8;
   char fn[15], filtre[15];
   int rom_number[6] = {9,11674,12385,10543,0,12712};
   int rom_num = rom_number[game-1];
   TilesROM1=(UBYTE *)malloc(taille2);
   work=(UBYTE *)malloc(taille);
   memset(TilesROM1, 0, taille2);

   switch (game) {
    case 1: strcpy(filtre, "shinobi.b%d"); break;
    case 2: strcpy(filtre, "ab%d.bin"); break;
    case 3: strcpy(filtre, "ga%d.bin"); break;
    case 4: strcpy(filtre, "ts%d.bin"); break;
    case 5: strcpy(filtre, "quartet2.b%d"); break;
    case 6: strcpy(filtre, "sd%d.bin"); break;
   };
   
   sprintf(fn, filtre, rom_num); rom_num++;
   if (!file_exists(fn, 0, NULL)){
	printf("Tile: couldn't find %s\n",fn);
     sprintf(fn, "%s.b9", game_basename);
   Load_ROM(fn, work, taille);
	}
   pr=0;
   for (pw=0;pw!=taille;pw++) 
     for (b=0;b!=8;b++)
     TilesROM1[pr++]=((work[pw]&(0x01<<(7-b)))>>(7-b));

   sprintf(fn, filtre, rom_num); rom_num++;
   if (!file_exists(fn, 0, NULL)){
	printf("Tile: couldn't find %s\n",fn);
	sprintf(fn, "%s.b10", game_basename);
	Load_ROM(fn, work, taille);
	}
   pr=0;
   for (pw=0;pw!=taille;pw++) 
     for (b=0;b!=8;b++)
     TilesROM1[pr++]|=(((work[pw]&(0x01<<(7-b)))>>(7-b))<<1);

   sprintf(fn, filtre, rom_num); rom_num++;
   if (!file_exists(fn, 0, NULL)){
	printf("Tile: couldn't find %s\n",fn);
	sprintf(fn, "%s.b11", game_basename);
	Load_ROM(fn, work, taille);
	}
   pr=0;
   for (pw=0;pw!=taille;pw++) 
     for (b=0;b!=8;b++) 
     TilesROM1[pr++]|=(((work[pw]&(0x01<<(7-b)))>>(7-b))<<2);
   for (pw=0;pw!=taille2;pw++) TilesROM1[pw]=(TilesROM1[pw]<<1);
   free(work);
}

void LoadAllROMS() {
   char fn[15];
   PACKFILE *f;
   int i;
   unsigned char nombre_roms, t;
   long taille;
   sprintf(fn, "%s.ROM",  game_basename);
printf("trying to load 'pack file' %s\n",fn);
exit(0);
   if (file_exists(fn, 0, NULL)) {
      printf("Packed roms found !\n");
      f=pack_fopen(fn, F_READ_PACKED);
      pack_fread(game_name, 20, f);
      do {
	 t=pack_getc(f);
	 switch (t) {
	  case 1:
	    nombre_roms=pack_getc(f);
	    printf("Loading program roms ... %dK\n", nombre_roms*64);
	    for (i=0;i!=nombre_roms;i++) {
	       RAM[i]=(UBYTE *)malloc(0x10000);
	       pack_fread(RAM[i], 0x10000, f);
	    }
	    break;
	  case 2:
	    taille=pack_igetl(f);
	    printf("Loading sprites roms ... %dK\n", taille/1024);
	    SpritesROM=(UBYTE *)malloc(taille);
	    pack_fread(SpritesROM, taille, f);
	    break;
	  case 3:
	    taille=pack_igetl(f);
	    printf("Loading tiles roms ... %dK\n", taille/1024);
	    TilesROM1=(UBYTE *)malloc(taille);
	    pack_fread(TilesROM1, taille, f);
	    break;
	 }
      } while (t!=0xFF);
      pack_fclose(f);
   } else {
      printf("Loading %s's roms in progress...\n", game_name);
      Load_GameROM();
      Load_SpritesROM();
      Load_TilesROM();
   }
}
