volatile int valin __attribute__ ((section("uncached"))) = 0;
volatile int valout __attribute__ ((section("uncached"))) = 0;

#include "sega_xpt.h"
#include <stdlib.h>
#include <machine/machine.h>

#define VBR   0x06000000

#define SETSINT   ((Sint32 (*)()) *((Uint32*)(VBR+0x310)))

volatile Uint8 *SMPC_COM = (Uint8 *)0x2010001F;   /* SMPC command register */
volatile Uint8 *SMPC_SF  = (Uint8 *)0x20100063;   /* SMPC status flag */

const Uint8 SMPC_SSHON  = 0x02;          /* SMPC slave SH on command */
const Uint8 SMPC_SSHOFF = 0x03;          /* SMPC slave SH off command */

void SlaveSHmain ()
{
	while (1)
	{
		while (valin == 0)
			;

		valout = (valin + 5) * valin + 7;

		valin = 0;
	}
}

void InitSlaveSH(void)
{
	volatile int i;

	while((*SMPC_SF & 0x01) == 0x01)
		;

	*SMPC_SF = 1;
	*SMPC_COM = SMPC_SSHOFF;

	while((*SMPC_SF & 0x01) == 0x01)
		;

	for(i = 0 ; i < 1000; i++)
		;   /* slave reset assert length */

	SETSINT(0x94,(void *)&SlaveSHmain);

	*SMPC_SF = 1;                 /* --- SMPC StatusFlag SET */
	*SMPC_COM = SMPC_SSHON;       /* --- Slave SH ON SET */
	while((*SMPC_SF & 0x01) == 0x01)
		;
}

void MasterSHmain ()
{
	int i = 1;

	while (1)
	{
		valin = i;

		while (valin != 0)
			;

		i = valout;
	}
}

void main ()
{
	InitSlaveSH();

	MasterSHmain();
}

