/*
**            SETTING YOUR PROGRAM'S STACK using _stackinit
**            =============================================
**
** Note: by default SNMAIN start-up module does not initialise an
** extra stack. By default your program will use the already existing
** system stack which is 4Kbytes big.
**
** If you need more stack you should set the _stackinit variable
** in your C source code.
**
** eg: put these 2 lines in your main C source file where you have your
** global data (usually near the beginning, before any functions) :-

int mystack[4096];
void *_stackinit=&mystack[4096];

** In this case the stack pointer is initialised to the top
** of a 16Kbyte area of your BSS.
** Alternatively you can just initialise _stackinit to point to a label
** in another section (grouped at start of BSS) of your program and let
** the PSYLINK linker fix it up.
*/


/*
** pollhost() implemented as a macro so it doesn't destroy
**            local variable scope.
**
** You need one of these in your code (e.g. game main loop)
** if you do not use NMI support but still wish to be able to
** examine target memory whilst your game is running.
*/
#define pollhost() asm("trapa #33")

#define enable_nmis(i) asm("mov #1,r0; mov %0,r4; trapa #36" : : "i"(i) : "r0", "r4")

#define disable_nmis(i) asm("mov #2,r0; mov %0,r4; trapa #36" : : "i"(i) : "r0", "r4")

#define PSYQ_NMI_MASTER 1
#define PSYQ_NMI_SLAVE 2
#define PSYQ_NMI_68K 4

/*
** init_cd (void)Initialise Saturn CD system & perform security check
**
** You must perform this if you booted with a Psy-Q Cart
** plugged into your Saturn if you wish use CD-ROM functions
** If you use this function you must also ensure that your link
** stage includes ** the CDC library> (e.g. add it to stdlib in PSYQ.INI)
** (When you run it you should also ensure that there is a CD
**  in the drive and the door is closed!)
**
** passed:   void
**
** function: init CD. Perform security check. Wait for completion.
**
** returns: int = CD status (see CDC_ST_ etc in SEGA_CDC.H)
*/
int	PSYQcdinit (void);


/*
** FILESERVER FUNCTIONS:
**
** NOTE: For PCread and PCwrite do not load files by passing extreme
** values for count as you might on UNIX as this will cause the full
** amount specified to be transferred - the file will be padded to
** that length with zeroes which may over-write memory beyond the
** end of the file.
**
** If you are unsure of the length of a file which you are about
** to read into memory then perform a
** 	len = PClseek( fd, 0, 2);
** This will set len to the length of the file which you can then
** pass to a PCread() function call.
**
*/

/*
** re-initialise PC filing system, close open files etc
**
** passed: void
**
** return: error code (0 if no error)
*/
int	PCinit (void);

/*
** open a file on PC host
**
** passed:	PC file pathname, open mode, permission flags
**
** return:	file-handle or -1 if error
**
** note: perms should be zero (it is ignored)
**
** open mode:	0 => read only
** 				1 => write only
**					2 => read/write
*/
int	PCopen (char *name, int flags, int perms);

/*
** create (and open) a file on PC host
**
** passed:	PC file pathname, open mode, permission flags
**
** return:	file-handle or -1 if error
**
** note: perms should be zero (it is ignored)
*/
int	PCcreat (char *name, int perms);

/*
** seek file pointer to new position in file
**
** passed: file-handle, seek offset, seek mode
**
** return: absolute value of new file pointer position
**
** (mode 0 = rel to start, mode 1 = rel to current fp, mode 2 = rel to end)
*/
int	PClseek (int fd, int offset, int mode);

/*
** read bytes from file on PC
**
** passed: file-handle, buffer address, count
**
** return: count of number of bytes actually read
**
** note: unlike assembler function this provides for full 32 bit count
*/
int	PCread (int fd, char *buff, int len);

/*
** write bytes to file on PC
**
** passed: file-handle, buffer address, count
**
** return: count of number of bytes actually written
**
** note: unlike assembler function this provides for full 32 bit count
*/
int	PCwrite (int fd, char *buff, int len);

/*
** close an open file on PC
**
** passed: file-handle
**
** return: negative if error
**
*/
int	PCclose (int fd);

