{$IFC UNDEFINED doNVRAMtest}
	{$SETC doNVRAMtest := 0}
{$ENDC}

{$IFC UNDEFINED doNVRAMclear}
	{$SETC doNVRAMclear := 0}
{$ENDC}

{$IFC UNDEFINED doNVRAMconvert}
	{$SETC doNVRAMconvert := 0}
{$ENDC}

{$IFC UNDEFINED doDiskConvert}
	{$SETC doDiskConvert := 0}
{$ENDC}

{$IFC UNDEFINED IsSetR2AD}
	{$SETC IsSetR2AD := 0}
{$ENDC}

{$IFC UNDEFINED IsSetGPRF}
	{$SETC IsSetGPRF := 0}
{$ENDC}





PROGRAM DumpNameRegistry;

USES
	Types, QuickDraw, Events, GestaltEqu, TextUtils, Sound, NameRegistry, Script, Traps, MixedMode,
	ResourcesU;

CONST
	kIndent = 4;
	kPropertyColumnWidth = 33;
	kTabColumn = kPropertyColumnWidth + kIndent;
	kMaxBytesPerLine = 32;


PROCEDURE memset(dst:Ptr; val:INTEGER; len:LongInt); C; { :Ptr }
FUNCTION memchr(CONST src:Ptr; val:INTEGER; len:LongInt):Ptr; C;
FUNCTION memcmp(CONST src1:Ptr; CONST src2:Ptr; len:LongInt):INTEGER; C;


FUNCTION ErrS (err: OsErr): Str255;
VAR
	s: Str255;
BEGIN
	CASE err OF
		noErr							:	s := 'noErr - No error';
		nrLockedErr						:	s := 'nrLockedErr';
		nrNotEnoughMemoryErr			:	s := 'nrNotEnoughMemoryErr';
		nrInvalidNodeErr				:	s := 'nrInvalidNodeErr';
		nrNotFoundErr					:	s := 'nrNotFoundErr';
		nrNotCreatedErr					:	s := 'nrNotCreatedErr';
		nrNameErr						:	s := 'nrNameErr';
		nrNotSlotDeviceErr				:	s := 'nrNotSlotDeviceErr';
		nrDataTruncatedErr				:	s := 'nrDataTruncatedErr';
		nrPowerErr						:	s := 'nrPowerErr';
		nrPowerSwitchAbortErr			:	s := 'nrPowerSwitchAbortErr';
		nrTypeMismatchErr				:	s := 'nrTypeMismatchErr';
		nrNotModifiedErr				:	s := 'nrNotModifiedErr';
		nrOverrunErr					:	s := 'nrOverrunErr';
		nrResultCodeBase				:	s := 'nrResultCodeBase';
		nrPathNotFound					:	s := 'nrPathNotFound';
		nrPathBufferTooSmall			:	s := 'nrPathBufferTooSmall';
		nrInvalidEntryIterationOp		:	s := 'nrInvalidEntryIterationOp';
		nrPropertyAlreadyExists			:	s := 'nrPropertyAlreadyExists';
		nrIterationDone					:	s := 'nrIterationDone';
		nrExitedIteratorScope			:	s := 'nrExitedIteratorScope';
		nrTransactionAborted			:	s := 'nrTransactionAborted';
		paramErr						:	s := 'paramErr - error in user parameter list';
		statusErr						:	s := 'statusErr - I/O System Errors';
		OTHERWISE							s := 'unknown err ???';
	END;
	ErrS := StringOf(err : 0, ' = ', s);
END; { ErrS }


PROCEDURE DoErr (msg: Str255;
								err: OSStatus);
	BEGIN
		IF err <> noErr THEN
			WriteLn(' Error occured. ', ErrS(err), ' in ', msg);
	END;


PROCEDURE WriteHex( hexPtr : UNIV Ptr; siz : LongInt; maxBytesPerLine: Integer; doWriteText: Boolean );
FORWARD;


PROCEDURE WriteChars(p : UNIV LongInt; siz : LongInt; offset:Integer );
VAR
	ch				:	CHAR;
	i				:	Integer;
	curPtr			:	LongInt;
	lineCharPtr		:	LongInt;
	lineStartNdx	:	Integer;
	lineStopNdx		:	Integer;
	lineLength		:	Integer;
	lastCharNdx		:	Integer;
	blankChars		:	Integer;
BEGIN
	curPtr := p;
	lastCharNdx := siz - 1;

	IF offset > 0 THEN
		BEGIN
			curPtr := curPtr + offset;
			lastCharNdx := lastCharNdx - offset;
		END;
		
	IF offset < 0 THEN
		BEGIN
			lastCharNdx := lastCharNdx + offset;
		END;

	IF lastCharNdx < -1 THEN
		WriteLn( ' less than zero ???' );

	i := 0;
	WHILE i <= lastCharNdx DO
		BEGIN
			lineCharPtr := curPtr;
			lineStartNdx := i;
			lineStopNdx := -1;
			lineLength := 0;
			WHILE ( i <= lastCharNdx ) & ( lineLength < 72 ) DO
				BEGIN
					ch := Chr(length(StringPtr(lineCharPtr)^));
					CASE ch OF
						CHR(0),
						CHR(13):
							BEGIN
								lineStopNdx := i;
								Leave;
							END;
						' ':
							lineStopNdx := i - 1;
					END; { CASE }

					IF i = lastCharNdx THEN
						BEGIN
							lineStopNdx := lastCharNdx;
							Leave;
						END;

					i := i + 1;
					lineLength := lineLength + 1;
					lineCharPtr := lineCharPtr + 1;
				END;

			IF lineStopNdx = -1 THEN
				lineStopNdx := i - 1;

			lineCharPtr := curPtr;
			i := lineStartNdx;
			
			blankChars := 0;
			WHILE i <= lineStopNdx DO
				BEGIN
					ch := Chr(length(StringPtr(lineCharPtr)^));
					CASE ch OF
						CHR(0),
						CHR(13):
							blankChars := blankChars + 1;
						CHR(1)..CHR(12),CHR(14)..CHR(31),CHR($7E)..CHR($7F):
							Write( '.' )
						OTHERWISE
							Write( ch );
					END;
					lineCharPtr := lineCharPtr + 1;
					i := i + 1;
				END;

			Write( '' : ( kMaxBytesPerLine * 9 DIV 4 + 2 - lineStopNdx + lineStartNdx + blankChars) );

			IF lineStartNdx = 0 THEN
				IF offset > 0 THEN
					BEGIN
						lineStartNdx := lineStartNdx - offset;
						curPtr := curPtr - offset;
					END;
			
			IF lineStopNdx = lastCharNdx THEN
				IF offset < 0 THEN
					lineStopNdx := lineStopNdx - offset;
			
			WriteHex( curPtr, lineStopNdx - lineStartNdx + 1, -1, FALSE );
			curPtr := lineCharPtr;

			IF i < lastCharNdx THEN
				BEGIN
					WriteLn;
					Write( '':kTabColumn );
				END;
		END; { WHILE }
END; { WriteChars }



PROCEDURE WriteText( start, stop: UNIV UInt32 );
VAR
	ch	:	Char;
BEGIN
	WHILE start < stop DO
		BEGIN
			ch := Chr(length(StringPtr(start)^));
			CASE ch OF
				CHR(0)..CHR(31),CHR($7F):
					Write( '.' )
				OTHERWISE
					Write( ch );
			END;
			start := start + 1;
		END;
END; { WriteText }



FUNCTION IsAnyText( start, stop: UNIV UInt32 ): Boolean;
VAR
	ch	:	Char;
BEGIN
	IsAnyText := FALSE;
	WHILE start < stop DO
		BEGIN
			ch := Chr(length(StringPtr(start)^));
			CASE ch OF
				CHR(0)..CHR(31),CHR($7F):
					;
				OTHERWISE
					BEGIN
						IsAnyText := TRUE;
						Leave;
					END
			END;
			start := start + 1;
		END;
END; { IsAnyText }



PROCEDURE WriteHex2( hexPtr : UNIV Ptr; siz : LongInt; maxBytesPerLine: Integer; doWriteText: Boolean; tabColumn: Integer; kMaxDumpBytes : LongInt );
CONST
	hexs = '0123456789ABCDEF';
VAR
	i			:	LongInt;
	startLine	:	Ptr;
	trunc		:	LongInt;
	spaces		:	LongInt;
BEGIN
	IF maxBytesPerLine < 0 THEN
		maxBytesPerLine := 1024; { bignum }
	trunc := 0;

	IF siz > kMaxDumpBytes THEN
		BEGIN
			trunc := siz;
			siz := kMaxDumpBytes;
		END;

	startLine := hexPtr;
	FOR i := 0 TO siz - 1 DO
		BEGIN
			IF ( i > 1 ) & ( i MOD 4 = 0 ) THEN
				IF i MOD maxBytesPerLine = 0 THEN
					BEGIN
						IF doWriteText & IsAnyText( startLine, hexPtr ) THEN
							BEGIN
								Write( '    "' );
								WriteText( startLine, hexPtr );
								Writeln( '"' );
							END
						ELSE
							WriteLn;
						Write( '':tabColumn );
						startLine := hexPtr;
					END
				ELSE
					Write( ' ' );
			Write( hexs[bsr(band(hexPtr^, $0F0), 4) + 1]);
			Write( hexs[band(hexPtr^, $0F) + 1]);
			hexPtr := Ptr(Ord4(hexPtr) + 1);
		END;

	IF doWriteText & IsAnyText( startLine, hexPtr ) THEN
		BEGIN
			Write( '"' : ( (maxBytesPerLine - UInt32(hexPtr) + UInt32(startLine)) * 9 DIV 4 + 5) );
			WriteText( startLine, hexPtr );
			Write( '"' );

			spaces := maxBytesPerLine - UInt32(hexPtr) + UInt32(startLine);
		END
	ELSE
		BEGIN
			spaces := maxBytesPerLine + 1 + ( (maxBytesPerLine - UInt32(hexPtr) + UInt32(startLine)) * 9 DIV 4 + 5)
		END;


	IF trunc <> 0 THEN
		BEGIN
			Write('' : spaces, '  total size = ', trunc : 0 );
		END;
END; { WriteHex }



PROCEDURE WriteHex( hexPtr : UNIV Ptr; siz : LongInt; maxBytesPerLine: Integer; doWriteText: Boolean );
BEGIN
	WriteHex2( hexPtr, siz, maxBytesPerLine, doWriteText, kTabColumn, 512 );
END; { WriteHex }



FUNCTION Hex( hexPtr: Ptr; numBytes: Integer ): Str255;
CONST
	hexs = '0123456789ABCDEF';
VAR
	i: Integer;
	s: Str255;
BEGIN
	s := '';
	FOR i := 1 TO numBytes DO
		BEGIN
			s := concat(s, hexs[bsr(band(hexPtr^, $0F0), 4) + 1]);
			s := concat(s, hexs[band(hexPtr^, $0F) + 1]);
			hexPtr := Ptr(Ord4(hexPtr) + 1);
		END;
	hex := s;
END;



PROCEDURE ConvertToPString( VAR s : Str255 );
VAR
	i	:	Integer;
BEGIN
	s[0] := CHR(255);
	FOR i := 1 TO 255 DO
		IF s[i] = CHR(0) THEN
			BEGIN
				s[0] := CHR(i - 1);
				Leave;
			END;
END;



{$PRAGMAC MARK -}
CONST
	_ExpansionManager			= $AAF3;

{$DEFINEC SIZE_CODE(size)
	ORD((size) = 4) * kFourByteCode + ORD((size) = 2) * kTwoByteCode + ORD((size) = 1) * kOneByteCode
}

{$DEFINEC RESULT_SIZE(sizeCode)
	BSL(sizeCode, kResultSizePhase)
}

{$DEFINEC STACK_ROUTINE_PARAMETER(whichParam, sizeCode)
	BSL( sizeCode, kStackParameterPhase + ((whichParam) - 1) * kStackParameterWidth )
}


CONST
	uppReadNVRAMProcInfo = kD0DispatchedPascalStackBased
		 + RESULT_SIZE(SIZE_CODE(sizeof(SignedByte)))
		 + STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Integer)))
		 + STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(LongInt)));


	uppWriteNVRAMProcInfo = kD0DispatchedPascalStackBased
		 + STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Integer)))
		 + STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(LongInt)))
		 + STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(SignedByte)));


	kReadNVRAMSelector			=	$022E;
	kWriteNVRAMSelector 		=	$032F;


FUNCTION ReadNVRAMByte(offset: LongInt): SignedByte;
{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
INLINE $303C, $022E, $AAF3;
{$ELSEC}
BEGIN
	ReadNVRAMByte := CallUniversalProc( GetToolboxTrapAddress( _ExpansionManager ), uppReadNVRAMProcInfo, kReadNVRAMSelector, offset);
END;
{$ENDC}

PROCEDURE WriteNVRAMByte(offset: LongInt; value: SignedByte);
{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
INLINE $303C, $032F, $AAF3;
{$ELSEC}
BEGIN
	IF CallUniversalProc( GetToolboxTrapAddress( _ExpansionManager ), uppWriteNVRAMProcInfo, kWriteNVRAMSelector, offset, value ) = 0 THEN;
END;
{$ENDC}



PROCEDURE ReadNVRAM( start: LongInt; numBytes: LongInt; dest:Ptr );
VAR
	i			:	LongInt;
BEGIN
	FOR i := start TO start + numBytes - 1 DO
		BEGIN
			dest^ := ReadNVRAMByte( i );
			dest := Ptr( ORD4( dest ) + 1 );
		END;
END; { ReadNVRAM }



PROCEDURE WriteNVRAM( start: LongInt; numBytes: LongInt; src:Ptr );
VAR
	i			:	LongInt;
BEGIN
	FOR i := start TO start + numBytes - 1 DO
		BEGIN
			WriteNVRAMByte( i, src^ );
			src := Ptr( ORD4( src ) + 1 );
		END;
END; { WriteNVRAM }



PROCEDURE ClearNVRAM( start: LongInt; numBytes: LongInt );
VAR
	i			:	LongInt;
BEGIN
	FOR i := start TO start + numBytes - 1 DO
			WriteNVRAMByte( i, 0 );
END; { ClearNVRAM }



CONST
	kNVRAMPropertiesPartitionSize = $400;
	kNVRAMPropertiesPartitionStart = $1400;


		
TYPE
	LocationArr		=	ARRAY[0..5] OF SignedByte; { signedbyte, longint, signed bytes }
	PropertyRec = RECORD
{0}			Location		:	LocationArr;
{6}			Name			:	String[3];
			Name4			:	SignedByte;
{11}		Value			:	SignedByte;
			Value1			:	ARRAY [0..7] OF SignedByte;
		END;

CONST
	kPropSize = SizeOf( PropertyRec );
	kMaxNumProps = ( kNVRAMPropertiesPartitionSize - 2 ) DIV kPropSize;

TYPE
	NVRAMPropertiesRec = RECORD
		offsetToEnd		:	Integer;
		properties		:	Array[0..kMaxNumProps - 1] OF PropertyRec;
		unknown			:	Integer;
	END;


	



FUNCTION NumVRAMProps( VAR nvramProps: NVRAMPropertiesRec ): Integer;
BEGIN
	WITH nvramProps DO
		NumVRAMProps := ( offsetToEnd - 2 - kNVRAMPropertiesPartitionStart ) DIV kPropSize;
END; { NumVRAMProps }



PROCEDURE SetNumVRAMProps( numPropsNew: Integer; VAR nvramProps: NVRAMPropertiesRec );
BEGIN
	WITH nvramProps DO
		offsetToEnd := numPropsNew * kPropSize + kNVRAMPropertiesPartitionStart + 2;
END; { SetNumVRAMProps }



PROCEDURE FixNVRAMEnd( VAR nvramProps: NVRAMPropertiesRec );
BEGIN
	IF nvramProps.offsetToEnd < kNVRAMPropertiesPartitionStart + 2 THEN
		nvramProps.offsetToEnd := kNVRAMPropertiesPartitionStart + 2;
END; { FixNVRAMEnd }



PROCEDURE FindNVRAMProperty( CONST property : Str255; CONST val: Str255; VAR nvramProps: NVRAMPropertiesRec; VAR index: Integer );
VAR
	i			:	Integer;
	numProps	:	Integer;
BEGIN
	index := -1;
	WITH nvramProps DO
		BEGIN
			numProps := NumVRAMProps( nvramProps );
			FOR i := 0 TO numProps - 1 DO
				WITH properties[i] DO
					IF BAND( location[0], $10 ) <> 0 THEN
						IF name = property THEN
							IF StringPtr( @Value )^ = val THEN
								BEGIN
									index := i;
									Leave;
								END;
		END; { WITH nvramProps }
END; { FindNVRAMProperty }



FUNCTION BadNameChars( CONST name: Str255 ): Boolean;
VAR
	i	:	Integer;
BEGIN
	BadNameChars := FALSE;
	FOR i := 1 TO Length( name ) DO
		IF name[i] IN [ CHR(0)..CHR(31), CHR($7E)..CHR(255) ] THEN
			BEGIN
				BadNameChars := TRUE;
				Leave;
			END;
END; { BadNameChars }



PROCEDURE CompressNVRAM( VAR nvramProps: NVRAMPropertiesRec; treatLongValuesAsValid: Boolean );
VAR
	srcNdx		:	Integer;
	dstNdx		:	Integer;
	numProps	:	Integer;
	numDeleted	:	Integer;
	numSkip		:	Integer;
	fillPtr		:	Ptr;
BEGIN
	dstNdx := 0;
	srcNdx := 0;

	WITH nvramProps DO
		BEGIN
			numProps := NumVRAMProps( nvramProps );
			
			WHILE srcNdx < numProps DO
				WITH properties[srcNdx] DO
					BEGIN
						numSkip := 1;
						IF
							( BAND( location[0], $10 ) <> 0 )
						 	&
						 	( Length( name ) > 0 ) & ( Length( name ) < 5 ) & ( NOT BadNameChars( name ) )
						 	&
						 	( Length( StringPtr( @value )^ ) >= 0 )
						 THEN
						 	IF ( Length( StringPtr( @value )^ ) < 9 ) | treatLongValuesAsValid THEN
								BEGIN
									numSkip := ( kPropSize - 8 + Length( StringPtr( @value )^ ) + kPropSize - 1 ) DIV kPropSize;

									IF srcNdx + numSkip <= numProps THEN
										BEGIN
											fillPtr := @name[Length(name) + 1];
											memset( fillPtr, 0, ORD4( @value ) - ORD4( fillPtr ) );

											fillPtr := @value1[Length( StringPtr( @value )^ )];
											memset( fillPtr, 0, ORD4( @properties[srcNdx + numSkip] ) - ORD4( fillPtr ) );

											IF srcNdx <> dstNdx THEN
												BlockMoveData( @properties[srcNdx], @properties[dstNdx], numSkip * kPropSize );
											dstNdx := dstNdx + numSkip;
										END;
								END;
						srcNdx := srcNdx + numSkip;
					END;
			numDeleted := numProps - dstNdx;
			memset( @properties[dstNdx], 0, numDeleted * kPropSize );
			SetNumVRAMProps( dstNdx, nvramProps );
		END;

	WriteLn( 'Deleted ', numDeleted:0, ' nvram properties during compressing.' );
END; { CompressNVRAM }



PROCEDURE CleanNVRAM( treatLongValuesAsValid: Boolean );
VAR
	nvramProps	:	NVRAMPropertiesRec;
BEGIN
	ReadNVRAM( kNVRAMPropertiesPartitionStart, kNVRAMPropertiesPartitionSize, @nvramProps );
	FixNVRAMEnd( nvramProps );
	CompressNVRAM( nvramProps, treatLongValuesAsValid );
	WriteNVRAM( kNVRAMPropertiesPartitionStart, kNVRAMPropertiesPartitionSize, @nvramProps );
END; { CleanNVRAM }



VAR
	gAppResFile		:	Integer;


PROCEDURE DumpNVRAM( start: LongInt; numBytes : LongInt; saveResource: Boolean; theResType: ResType );
CONST
	kResFileName	= 'NVRAM.z';

VAR
	i			:	LongInt;
	err			:	OSErr;

	cur			:	Integer;
	
	secs		:	LongInt;

	didCreate	:	Boolean;
	resSpec		:	FSSpec;
	resRef		:	Integer;


	NVRAMBuffer	:	Handle;
	resCount		:	Integer;

	tmpl			:	Handle;
	tmplType	:	ResType;
	tmplID		:	Integer;
	tmplName	:	Str255;

BEGIN
	NVRAMBuffer := NewHandle( numBytes );
	IF NVRAMBuffer <> NIL THEN
		BEGIN
			HLock( NVRAMBuffer );
			ReadNVRAM( start, numBytes, NVRAMBuffer^ );
			HUnlock( NVRAMBuffer );

			IF saveResource THEN
				BEGIN
					cur := CurResFile;

					resRef := -1;
					didCreate := FALSE;
					
					err := FSMakeFSSpec( 0, 0, kResFileName, resSpec );
					IF err = fnfErr THEN
						BEGIN
							FSpCreateResFile( resSpec, 'Doug', 'RSRC', smSystemScript );
							didCreate := TRUE;
							err := ResError();
						END;
					
					IF err = noErr THEN
						BEGIN
							resRef := FSpOpenResFile( resSpec, fsRdWrPerm );
					
							IF resRef >= 0 THEN
								BEGIN
									IF didCreate THEN
										BEGIN
											UseResFile( gAppResFile );
											
											resCount := Count1Resources( 'TMPL' );
											
											FOR i := 1 TO resCount DO
												BEGIN
													tmpl := Get1IndResource( 'TMPL', resCount );
													GetResInfo( tmpl, tmplID, tmplType, tmplName);
													
													IF tmpl <> NIL THEN
														BEGIN
															DetachResource( tmpl );
															err := AddRes( resRef, tmpl, 'TMPL', tmplID, 0, tmplName );
															ReleaseResource( tmpl );
														END;
												END;
										END;

									GetDateTime( secs );
									err := AddRes( resRef, NVRAMBuffer, theResType, Unique1ID( theResType ), 0, StringOf( 'NVRAM ', PTR(secs) ) );
									DetachResource( NVRAMBuffer );
									CloseResFile( resRef );
								END;
						END;

					UseResFile( cur );
				END;

			HLock( NVRAMBuffer );
			WriteHex2( NVRAMBuffer^, GetHandleSize( NVRAMBuffer ), 32, TRUE, 0, MaxLongInt );
			HUnlock( NVRAMBuffer );
			
			DisposeHandle( NVRAMBuffer );
		END
	ELSE
		WriteLn( '  Error - Not enough memory for NVRAMBuffer' );
	
	WriteLn;
	
END; { DumpNVRAM }



FUNCTION RegistryPropertyFix( VAR entry : RegEntryID;
						VAR property : Str255; val : Ptr; siz : RegPropertyValueSize ): OSErr;
VAR
	err					:	OSErr;
		
	nvramProps			:	NVRAMPropertiesRec;
	numProps			:	Integer;
	numNeeded			:	Integer;
	numPropsNew			:	Integer;
	foundNdx			:	Integer;
	
	mynvramprop			:	String[9];
	
	ignorErr			:	OSErr;
BEGIN
	IF siz > 255 THEN
		err := nrOverrunErr
	ELSE
		BEGIN
			mynvramprop := 'Hello!!!';

			err := RegistryPropertySet( entry, RegPropertyNamePtr(@property[1])^, @mynvramprop[1], Length( mynvramprop ) );
			IF err = noErr THEN
				BEGIN
					ReadNVRAM( kNVRAMPropertiesPartitionStart, kNVRAMPropertiesPartitionSize, @nvramProps );

					ignorErr := RegistryPropertySet( entry, RegPropertyNamePtr(@property[1])^, val, siz ); // restore the value and ignore the nrOverrunErr

					FixNVRAMEnd( nvramProps );
					CompressNVRAM( nvramProps, TRUE );
					
					WITH nvramProps DO
						BEGIN
							numProps := NumVRAMProps( nvramProps );
							numNeeded := ( kPropSize - 8 + siz + kPropSize - 1 ) DIV kPropSize - 1; { subtract 1 for the one we just created }
							numPropsNew := numProps + numNeeded;
							
							IF numPropsNew <= kMaxNumProps THEN
								BEGIN
									FindNVRAMProperty( property, mynvramprop, nvramProps, foundNdx );
									IF foundNdx < 0 THEN
										DoErr( 'FindNVRAMProperty', foundNdx )
									ELSE
										BEGIN
											SetNumVRAMProps( numPropsNew, nvramProps );

											BlockMoveData( @properties[foundNdx + 1], @properties[foundNdx + 1 + numNeeded], ( numProps - foundNdx - 1 ) * kPropSize );
											WITH properties[foundNdx] DO
												BEGIN
													value := siz;
													BlockMoveData( val, @value1, siz );
												END;

											WriteNVRAM( kNVRAMPropertiesPartitionStart, kNVRAMPropertiesPartitionSize, @nvramProps );
										END; { ELSE }
								END; { IF }
						END; { WITH }
				END; { IF err }
		END; { ELSE }
	RegistryPropertyFix := err;
END; { RegistryPropertyFix }



{$PRAGMAC MARK -}



FUNCTION GetName( VAR s : Str255 ) : Str255;
VAR
	i	:	Integer;
BEGIN
	i := Length( s );
	WHILE ( s[i] <> ':' ) & ( i > 0 ) DO
		i := i - 1;
	GetName := Copy( s, i + 1, Length( s ) - i );
END; { FindFirstCharOfName }


FUNCTION CountColons( VAR s : Str255 ) : Integer;
VAR
	i	:	Integer;
	c	:	Integer;
BEGIN
	c := 0;
	FOR i := 1 TO Length( s ) DO
		IF s[i] = ':' THEN
			c := c + 1;
	CountColons := c;
END; { CountColons }



TYPE
	RegPropertyRec	=	RECORD
		long1	:	LongInt;
		long2	:	LongInt;
		long3	:	LongInt;
		long4	:	LongInt;
		long5	:	LongInt;
	END;
	RegPropertyRecArr	=	ARRAY[0..7] OF RegPropertyRec; { UltraTek133 has 8 }
	
	RegPropertyRecPtr = ^RegPropertyRec;
	RegPropertyRecArrPtr = ^RegPropertyRecArr;
	
	

PROCEDURE CalculateLocation( VAR entry : RegEntryID; VAR location : LocationArr; VAR result : OSErr );
CONST
	nilEntry : RegEntryIDPtr = NIL;

VAR
	level				:	Integer;
	Parents				:	LongInt;
	err					:	OSErr;
	regSize				:	RegPropertyValueSize;
	regPtr				:	RegPropertyRecArrPtr;
	propName			:	String[4];
	numRegEntries		:	Integer;
	regNdx				:	Integer;
	regLong				:	LongInt;

	twoBits				:	LongInt;
	threeBits			:	LongInt;
	fiveBits			:	LongInt;
	cookie				:	regEntryIter;
	done				:	Boolean;
	parentEntry			:	RegEntryID;
	haveParentEntry		:	Boolean;
	haveCookie			:	Boolean;
	
	deviceTreeName		:	Str255;
	deviceTreeEntry		:	RegEntryID;
	havedeviceTreeEntry	:	Boolean;
	
	
	PROCEDURE Return( err: OSErr );
	BEGIN
		result := err;

		IF regPtr <> NIL THEN
			DisposePtr( Ptr( regPtr ) );
		
		IF haveParentEntry THEN
			BEGIN
				err := RegistryEntryIDDispose( parentEntry );
				DoErr( 'RegistryEntryIDDispose', err );
			END;
		IF haveDeviceTreeEntry THEN
			BEGIN
				err := RegistryEntryIDDispose( deviceTreeEntry );
				DoErr( 'RegistryEntryIDDispose', err );
			END;
		IF haveCookie THEN
			BEGIN
				err := RegistryEntryIterateDispose( cookie );
				DoErr( 'RegistryEntryIterateDispose', err );
			END;

		location[0] := BOR( level, $10 );
		location[5] := BOR( BSL(threeBits, 5), fiveBits );
		LongIntPtr( @location[1] )^ := BOR( BSL(twoBits, 30), Parents );

		Exit( CalculateLocation );
	END; { Return }



	PROCEDURE ExitOnErr( err: OSErr );
	BEGIN
		IF err <> noErr THEN
			BEGIN
				IF err = -1 THEN
					BEGIN
						err := MemError();
						IF err = noErr THEN
							err := -1;
					END;
				Return( err );
			END;
	END; { ExitOnErr }


BEGIN { CalculateLocation }
	regPtr := NIL;
	haveParentEntry := FALSE;
	haveCookie := FALSE;
	haveDeviceTreeEntry := FALSE;
	
	level := 0;
	Parents := 0;

	propName := 'reg';
	propName[ Length( propName ) + 1 ] := CHR(0);

	err := RegistryPropertyGetSize( entry, RegPropertyNamePtr(@propName[1])^, regSize );
	IF err = nrNotFoundErr THEN
		err := nrTypeMismatchErr;
	ExitOnErr( err );

	regPtr := RegPropertyRecArrPtr( NewPtr( regSize ) );
	IF regPtr = NIL THEN
		ExitOnErr( -1 );

	err := RegistryPropertyGet( entry, RegPropertyNamePtr(@propName[1])^, regPtr, regSize );
	IF err <> noErr THEN
		ExitOnErr( err );

	IF regSize > 20 THEN
		numRegEntries := regSize DIV 20
	ELSE
		numRegEntries := 1;

	FOR regNdx := 0 TO numRegEntries - 1 DO
		BEGIN
			regLong := regPtr^[regNdx].long1;
			IF BAND( regLong, $F0000000 ) = $F0000000 THEN
				BEGIN
					twoBits := 3;
					threeBits := 0;
					fiveBits := BSR( BAND( regLong, $1F000000 ), 24 );
					Leave;
				END;

			IF BAND( regLong, $03000000 ) = 0 THEN
				BEGIN
					twoBits := BSR( BAND( regLong, $00030000 ), 16 );
					threeBits := BSR( BAND( regLong, $00000700 ),  8 );
					fiveBits := BSR( BAND( regLong, $0000F800 ), 11 );
					Leave;
				END;
		END; { FOR }

	DisposePtr( Ptr( regPtr ) );
	regPtr := NIL;


{ get device-tree entry }
	deviceTreeName := 'Devices:device-tree';
	deviceTreeName[ Length( deviceTreeName ) + 1 ] := CHR(0);

	err := RegistryCStrEntryLookup( nilEntry^, RegCStrEntryNamePtr(@deviceTreeName[1])^, deviceTreeEntry );
	DoErr( 'RegistryCStrEntryLookup', err );
	haveDeviceTreeEntry := TRUE;

{ iterate through parent entries until we come across the device-tree entry }

	ExitOnErr( RegistryEntryIterateCreate( cookie ) );
	haveCookie := TRUE;

	err := RegistryEntryIterateSet( cookie, entry );
	DoErr( 'RegistryEntryIterateSet', err );

	REPEAT
		err := RegistryEntryIterate( cookie, kRegIterParents, parentEntry, done );
		DoErr( 'RegistryEntryIterate', err );
		IF done = FALSE THEN
			BEGIN
				haveParentEntry := TRUE;

				IF RegistryEntryIDCompare( deviceTreeEntry, parentEntry ) THEN
					done := TRUE
				ELSE
					BEGIN
						ExitOnErr( RegistryPropertyGetSize( parentEntry, RegPropertyNamePtr(@propName[1])^, regSize ) );

						regPtr := RegPropertyRecArrPtr( NewPtr( regSize ) );
						IF regPtr = NIL THEN
							ExitOnErr( -1 );

						err := RegistryPropertyGet( parentEntry, RegPropertyNamePtr(@propName[1])^, regPtr, regSize );
						IF err <> noErr THEN
							ExitOnErr( err );

						IF regSize > 20 THEN
							numRegEntries := regSize DIV 20
						ELSE
							numRegEntries := 1;

						FOR regNdx := 0 TO numRegEntries - 1 DO
							BEGIN
								regLong := regPtr^[regNdx].long1;
								IF BAND( regLong, $F0000000 ) = $F0000000 THEN
									BEGIN
										Parents := BOR( Parents, BSL( BSR( BAND( regLong, $1F000000 ), 24 ), level * 5 ) );
										level := level + 1;
										Leave;
									END;
								IF BAND( regLong, $03000000 ) = 0 THEN
									BEGIN
										Parents := BOR( Parents, BSL( BSR( BAND( regLong, $0000F800 ), 11 ), level * 5 ) );
										level := level + 1;
										Leave;
									END;
							END; { FOR }

						DisposePtr( Ptr( regPtr ) );
						regPtr := NIL;
					END; { IF NOT device-tree }

				err := RegistryEntryIDDispose( parentEntry );
				DoErr( 'RegistryEntryIDDispose', err );
				haveParentEntry := FALSE;
			END; { IF NOT done }

		IF level >= 6 THEN
			Leave;
	UNTIL done;

	Return( noErr );
END; { CalculateLocation }





VAR
	gRegArr				:	RegPropertyRecArr;

PROCEDURE IterateChildren( VAR parentEntry : RegEntryID; location : LocationArr );
VAR
	err					:	OSErr;
	regSize				:	RegPropertyValueSize;
	propName			:	String[4];
	numRegEntries		:	Integer;
	regNdx				:	Integer;
	regLong				:	LongInt;

	cookie				:	regEntryIter;
	done				:	Boolean;
	childEntry			:	RegEntryID;

	name				:	Str255;
	s					:	Str255;
	len					:	RegPathNameSize;
	op					:	RegEntryIterationOp;
BEGIN
	IF RegistryEntryIterateCreate( cookie ) = noErr THEN
		IF RegistryEntryIterateSet( cookie, parentEntry ) = noErr THEN
			BEGIN
				propName := 'reg';
				propName[ Length( propName ) + 1 ] := CHR(0);

				LongIntPtr( @location[1] )^ := BSL( LongIntPtr( @location[1] )^, 5 ) + BAND( location[5], $1F );
				location[0] := location[0] + 1;
				op := kRegIterChildren;
				WHILE ( RegistryEntryIterate( cookie, op, childEntry, done ) = noErr ) & ( done = FALSE ) DO
					BEGIN
						op := kRegIterContinue;
						IF RegistryEntryToPathSize( childEntry, len ) = noErr THEN
							IF RegistryCStrEntryToPath( childEntry, RegCStrEntryNamePtr(@name[1])^, 255 ) = noErr THEN
								BEGIN
									IF len > 256 THEN
										BEGIN
											WriteLn( '??? len > 255' );
											len := 256;
										END;
									name[0] := CHR(len - 1);
								END;

						s := StringOf( '' : CountColons( name ) * 2, '/', GetName( name ) );
						Write( s, '' : 40 - Length(s) );

						regSize := SizeOf( gRegArr );
						IF RegistryPropertyGet( childEntry, RegPropertyNamePtr(@propName[1])^, @gRegArr, regSize ) = noErr THEN
							BEGIN
								IF regSize > 20 THEN
									numRegEntries := regSize DIV 20
								ELSE
									numRegEntries := 1;

								FOR regNdx := 0 TO numRegEntries - 1 DO
									BEGIN
										regLong := gRegArr[regNdx].long1;
										IF BAND( regLong, $F0000000 ) = $F0000000 THEN
											BEGIN
												location[5] := BAND( BSR( regLong, 24 ), $1F );
												location[1] := $C0 + BAND( location[1], $3F );
												Leave;
											END;
										IF BAND( regLong, $03000000 ) = 0 THEN
											BEGIN
												location[5] := BOR( BAND( BSR( regLong,  8 - 5 ), $E0 ), BAND( BSR( regLong, 11 ), $1F ) );
												location[1] := BOR( BAND( BSR( regLong, 16 - 6 ), $C0 ), BAND( location[1], $3F ) );
												Leave;
											END;
									END; { FOR }

								Write( '  location: ' );
								WriteHex2( @location, SizeOf(location), 32, FALSE, 0, 32 );
								Write( '                         ' );
								Write('    reg: ' );
								WriteHex2( @gRegArr, regSize, 1024, FALSE, 72, 512 );
								WriteLn;

								IF location[0] < $16 THEN
									IterateChildren( childEntry, location );
							END { IF RegistryPropertyGet }
						ELSE
							WriteLn;
						

						err := RegistryEntryIDDispose( childEntry );

					END; { WHILE RegistryEntryIterate }

			END; { IF RegistryEntryIterateSet }
END; { IterateChildren }



PROCEDURE CalculateLocationTopDown;
CONST
	nilEntry : RegEntryIDPtr = NIL;
VAR
	location			:	LocationArr;
	deviceTreeName		:	Str255;
	deviceTreeEntry		:	RegEntryID;
	err					:	OSErr;
BEGIN
	deviceTreeName := 'Devices:device-tree';
	deviceTreeName[ Length( deviceTreeName ) + 1 ] := CHR(0);

	IF RegistryCStrEntryLookup( nilEntry^, RegCStrEntryNamePtr(@deviceTreeName[1])^, deviceTreeEntry ) = noErr THEN
		BEGIN
			location[0] := $0F;
			location[1] := 0;
			location[2] := 0;
			location[3] := 0;
			location[4] := 0;
			location[5] := 0;
			
			IterateChildren( deviceTreeEntry, location );
			err := RegistryEntryIDDispose( deviceTreeEntry );
		END;
END; { CalculateLocationTopDown }



PROCEDURE ListAsTree( VAR name : Str255; VAR entry : RegEntryID );
BEGIN
	{$UNUSED entry}
	WriteLn( '' : CountColons( name ) * 2,'/', GetName( name ) );
END; { ListAsTree }



PROCEDURE ListAsTreeWithLocation( VAR name : Str255; VAR entry : RegEntryID );
VAR
	propName			:	String[5];
	propValue			:	String[8];
	nvramProps			:	NVRAMPropertiesRec;
	foundNdx			:	Integer;
	siz					:	RegPropertyValueSize;
	val					:	Ptr;
	err					:	OSErr;
	s					:	Str255;
	calcLocation		:	LocationArr;
	modErr				:	OSErr;
BEGIN
	{$UNUSED entry}
	propName := 'JOEV';
	propName[ Length( propName ) + 1 ] := CHR(0);
	propValue := 'Hello!!!';
	foundNdx := -1;
	val := NIL;

	s := StringOf( '' : CountColons( name ) * 2, '/', GetName( name ) );
	Write( s, '' : 40 - Length(s) );

	err := RegistryPropertyDelete( entry, RegPropertyNamePtr( @propName[1] )^ );
	err := RegistryPropertyCreate( entry, RegPropertyNamePtr( @propName[1] )^, @propValue[1], Length( propValue ) );
	DoErr( 'RegistryPropertyCreate', err );
	IF err = noErr THEN
		BEGIN
			modErr := RegistryPropertySetMod( entry, RegPropertyNamePtr( @propName[1] )^, kRegPropertyValueIsSavedToNVRAM );
			IF modErr = noErr THEN
				BEGIN
					ReadNVRAM( kNVRAMPropertiesPartitionStart, kNVRAMPropertiesPartitionSize, @nvramProps );
					FixNVRAMEnd( nvramProps );
					FindNVRAMProperty( propName, propValue, nvramProps, foundNdx );
					IF foundNdx < 0 THEN
						Write( '  Could not find property  ' );
				END
			ELSE IF modErr <> nrTypeMismatchErr THEN
				DoErr( 'RegistryPropertySetMod', modErr );

			err := RegistryPropertyDelete( entry, RegPropertyNamePtr( @propName[1] )^ );
			DoErr( 'RegistryPropertyDelete', err );
		END;

	IF foundNdx >= 0 THEN
		BEGIN
			// nvramProps.properties[foundNdx].location[4] := BAND( nvramProps.properties[foundNdx].location[4], $0EF ); { testing }
			Write( '  location: ' );
			WriteHex2( @nvramProps.properties[foundNdx].location, SizeOf(nvramProps.properties[foundNdx].location), 32, FALSE, 0, 32 );
		END
	ELSE
		Write( '                         ' );

	CalculateLocation( entry, calcLocation, err );

	IF (( foundNdx < 0 ) & ( err = noErr )) |
	   (( foundNdx >= 0 ) & ( memcmp( @calcLocation, @nvramProps.properties[foundNdx].location, sizeof( calcLocation ) ) <> 0 )) THEN
		BEGIN
			Write( '    calced: ' );
			WriteHex2( @calcLocation, SizeOf(calcLocation), 32, FALSE, 0, 32 );
		END
	ELSE IF err = nrNotFoundErr THEN
		Write( '    parent missing reg   ' )
	ELSE IF err <> modErr THEN
		Write( '    err:', err:5,'          ' )
	ELSE
		Write( '                         ' );

	propName := 'reg';
	propName[ Length( propName ) + 1 ] := CHR(0);

	err := RegistryPropertyGetSize( entry, RegPropertyNamePtr(@propName[1])^, siz );
	IF err = noErr THEN
		BEGIN
			val := NewPtr( siz );
			DoErr( 'NewPtr', MemError );
			IF val <> NIL THEN
				BEGIN
					err := RegistryPropertyGet( entry, RegPropertyNamePtr(@propName[1])^, val, siz );
					DoErr( 'RegistryPropertyGet', err );
					IF err = noErr THEN
						BEGIN
							Write('    reg: ' );
							WriteHex2( val, siz, 1024, FALSE, 72, 512 );
						END;
				END;
			DisposePtr( val );
		END
	ELSE IF err <> nrNotFoundErr THEN
		DoErr( StringOf( 'RegistryPropertyGetSize of ', propName ), err );
	WriteLn;
END; { ListAsTreeWithLocation }



{$PRAGMAC MARK -}


{$IFC doNVRAMTest}
CONST
	saveType = kRegPropertyValueIsSavedToNVRAM;
//	saveType = kRegPropertyValueIsSavedToDisk;
//	saveType = kRegPropertyValueIsSavedToNVRAM + kRegPropertyValueIsSavedToDisk; // setting both results in nrInvalidNodeErr

VAR
	propSizes		:	Integer;
	propNum			:	Integer;
	propVal	  		:	LongInt;
	propSecs		:	LongInt;
	propTriedLong	:	Integer;
{$ENDC}

PROCEDURE PropertiesDump( VAR name : Str255; VAR entry : RegEntryID;
							PROCEDURE PropertyCallBack ( VAR name : str255; VAR entry : RegEntryID; VAR property : Str255; val : Ptr; siz : RegPropertyValueSize ) );
VAR
{$IFC doNVRAMTest}
	propName			:	Str255;
	propertyValue		:	ARRAY[0..30] OF LongInt; { 128-4 bytes}
	i					:	Integer;
	numChars			:	Integer;
{$ENDC}

	err			:	OSErr;
	cookie		:	RegPropertyIter;
	done		:	Boolean;
	property	:	Str255;
	val			:	Ptr;
	siz			:	RegPropertyValueSize;
BEGIN
	{$IFC doNVRAMTest}


(*

2		0	1
12		0	2
J12		1	2
JO12	2	2

*)
	IF Pos( 'ATY,RV100Parent', name ) > 0 THEN
		BEGIN
			WriteLn(' Not messing with ATY,RV100Parent' );
		END
	ELSE
	IF propNum < 100 THEN	{ 10 }
		BEGIN
			numChars := BAND( BSR( propSizes, 2 ), $03 );
			
			propName := StringOf( Copy( 'JO', 1, ORD( numChars > 1 ) + ORD( numChars > 2 ) ), Copy( StringOf( Ptr( ORD4(propNum) ) ), 8 - ORD( numChars > 0 ), 1 + ORD( numChars > 0 ) ) );
			propName[ Length( propName ) + 1 ] := CHR(0);
			err := RegistryPropertyDelete( entry, RegPropertyNamePtr( @propName[1] )^ );

			propertyValue[0] := propSecs;
			propertyValue[1] := propVal;
			propVal := propVal + 1;
			propNum := propNum + 1;

			err := RegistryPropertyCreate( entry, RegPropertyNamePtr( @propName[1] )^, @propertyValue, BAND( propSizes, $3 ) + 5 );
			IF err = noErr THEN
				BEGIN
					err := RegistryPropertySetMod( entry, RegPropertyNamePtr( @propName[1] )^, saveType );
					DoErr( 'RegistryPropertySetMod', err );
					IF err = noErr THEN
						BEGIN
							propSizes := propSizes + 1;

							IF ( ( propTriedLong < 1 ) & ( propNum > 5 ) ) | ( ( propTriedLong < 2 ) & ( propNum > 25 ) ) THEN
								BEGIN
									propTriedLong := propTriedLong + 1;
									memset( @propertyValue, 0, SizeOf( propertyValue ) );
									propertyValue[0] := propSecs;
									propertyValue[1] := propVal;
									
									FOR i := 9 TO SizeOf( propertyValue ) DO
										BEGIN
											memset( @propertyValue[2], {$00}i, i-8 );
											
											err := RegistryPropertyDelete( entry, RegPropertyNamePtr( @propName[1] )^ );
											DoErr( StringOf( 'RegistryPropertyDelete len:', i:0 ), err );
											
											err := RegistryPropertyCreate( entry, RegPropertyNamePtr( @propName[1] )^, @propertyValue, i );
											DoErr( StringOf( 'RegistryPropertyCreate len:', i:0 ), err );
		
											err := RegistryPropertySetMod( entry, RegPropertyNamePtr( @propName[1] )^, saveType );
											DoErr( StringOf( 'RegistryPropertySetMod len:', i:0 ), err );

											IF err = nrOverrunErr THEN
												BEGIN
													err := RegistryPropertyFix( entry, propName, @propertyValue, i );
													DoErr( StringOf( 'RegistryPropertyFix len:', i:0 ), err );
												END;
		(*
											err := RegistryPropertySet( entry, RegPropertyNamePtr( @propName[1] )^, @propertyValue, i );
											DoErr( StringOf( 'RegistryPropertySet len:', i:0 ), err );
		*)
											IF err <> noErr THEN
												Leave;
										END; { FOR }
								END; { IF }

						END; { IF err }
				END
			ELSE
				DoErr( StringOf( 'RegistryPropertyCreate name:', propName, '' ), err );
		END;

	{$ENDC}

	err := RegistryPropertyIterateCreate( entry, cookie );
	DoErr( 'RegistryPropertyIterateCreate', err );
	property[33] := CHR(0); // because RegistryPropertyIterate does not add this terminating null if the property name is 32 characters
	IF err = noErr THEN
		REPEAT
			err := RegistryPropertyIterate( cookie, RegPropertyNamePtr(@property[1])^, done );
			ConvertToPString( property );
			DoErr( 'RegistryPropertyIterate', err );
			IF done = FALSE THEN
				BEGIN
					err := RegistryPropertyGetSize( entry, RegPropertyNamePtr(@property[1])^, siz );
					DoErr( StringOf( 'RegistryPropertyGetSize of ', property ), err );
					IF err = noErr THEN
						BEGIN
							val := NewPtr( siz );
							DoErr( 'NewPtr', MemError );
							IF val <> NIL THEN
								BEGIN
									err := RegistryPropertyGet( entry, RegPropertyNamePtr(@property[1])^, val, siz );
									DoErr( 'RegistryPropertyGet', err );
									IF err = noErr THEN
											PropertyCallBack( name, entry, property, val, siz )
								END;
							DisposePtr( val );
						END;
				END;
		UNTIL done;
	err := RegistryPropertyIterateDispose( cookie );
	DoErr( 'RegistryPropertyIterateDispose', err );
END; { PropertiesDump }


FUNCTION ConvertColonsToSlashes( s : Str255 ) : Str255;
VAR
	i	:	Integer;
BEGIN
	FOR i := 1 TO Length( s ) DO
		IF s[i] = ':' THEN
			s[i] := '/';
	ConvertColonsToSlashes := s;
END; { ConvertColonsToSlashes }


FUNCTION ValIsString( val : UNIV LongInt; siz : LongInt ) : Boolean;
VAR
	numDigit	:	LongInt;
	numLetter	:	LongInt;
	numOther	:	LongInt;
	numLine		:	LongInt;
	ch			:	Char;
BEGIN
	IF Ptr( val )^ = 0 THEN
		BEGIN
			ValIsString := FALSE;
			Exit(ValIsString);
		END;

	numDigit := 0;
	numLetter := 0;
	numOther := 0;
	numLine := 0;

	WHILE siz > 0 DO
		BEGIN
			ch := Chr( Length(StringPtr( val )^) );
			CASE ch OF
				CHR(0),CHR(13):
					numLine := numLine + 1;
				'0'..'9':
					numDigit := numDigit + 1;
				'A'..'Z','a'..'z':
					numLetter := numLetter + 1;
				CHR(1)..CHR(12),CHR(14)..CHR(31),CHR($7E)..CHR($FF):
					BEGIN
						ValIsString := FALSE;
						Exit(ValIsString);
					END;
				OTHERWISE
					numOther := numOther + 1;
			END; { CASE } 
			val := val + 1;
			siz := siz - 1;
		END;

	ValIsString := numLetter + numDigit > 0;
END; { ValIsString }



FUNCTION ValIsCString( val : UNIV LongInt; siz : LongInt ) : Boolean;
BEGIN
	siz := siz - 1;
	ValIsCString := ( siz > 0 ) & ( Ptr( val + siz )^ = 0 ) & ValIsString( val, siz );
END; { ValIsCString }



FUNCTION ValIsPString( val : UNIV LongInt; siz : LongInt ) : Boolean;
BEGIN
	siz := siz - 1;
	ValIsPString := ( siz > 0 ) & ( Length( StringPtr( val )^ ) = siz ) & ValIsString( val + 1, siz );
END; { ValIsPString }


(*
FUNCTION ValIsNames( val : UNIV LongInt; siz : LongInt ) : Boolean;
BEGIN
	ValIsNames := ( siz > 5 ) & ......... & ValIsString( val + 1, siz );
END; { ValIsPString }
*)


PROCEDURE WriteProperty( VAR name : str255; VAR entry : RegEntryID;
						VAR property : Str255; val : Ptr; siz : RegPropertyValueSize );
VAR
	modifiers		:	RegPropertyModifiers;
	propertyString	:	Str255;
BEGIN
	{$UNUSED name}

	DoErr( 'RegistryPropertyGetMod', RegistryPropertyGetMod( entry, RegPropertyNamePtr(@property[1])^, modifiers ) );
	IF modifiers <> 0 THEN
		propertyString := StringOf( property, '    mods:', Hex( @modifiers, SizeOf( modifiers ) ), ' ' )
	ELSE
		propertyString := property;

	Write( '    ', propertyString, '' : kPropertyColumnWidth - Length( propertyString ));

	{$IFC doNVRAMclear}
	IF modifiers <> 0 THEN
			DoErr( 'RegistryPropertySetMod', RegistryPropertySetMod( entry, RegPropertyNamePtr(@property[1])^, 0 ) );
	{$ENDC}
	
	
	{$IFC doNVRAMconvert}
	IF modifiers = kRegPropertyValueIsSavedToNVRAM THEN
		IF siz > 8 THEN { maximimum size on Old World Mac}
			BEGIN
				{$IFC doDiskConvert}
					DoErr( 'RegistryPropertySetMod', RegistryPropertySetMod( entry, RegPropertyNamePtr(@property[1])^, kRegPropertyValueIsSavedToDisk ) );
				{$ELSE }
					// DoErr( RegistryPropertySet( entry, RegPropertyNamePtr(@property[1])^, val, 8 ); // truncate to 8 which will make it save to NVRAM
					DoErr( 'RegistryPropertyFix', RegistryPropertyFix( entry, property, val, siz ) );
				{$ENDC}
			END;
	{$ENDC}

	IF property = 'driver-descriptor' THEN
		BEGIN
			WriteHex( val, siz, kMaxBytesPerLine, TRUE );
(*			WriteLn;
			Write( '':kTabColumn );
			WriteChars( val, siz );
*)		END

	ELSE IF ( property = 'slot-names' ) | ( property = 'built-in-names' ) THEN
		BEGIN
			WriteHex( val, 4, kMaxBytesPerLine, FALSE );
			WriteLn;
			Write( '':kTabColumn );
			WriteChars( ORD4(val) + 4, siz - 4, 0 );
		END
	ELSE IF POS('-frequency', property ) > 0 THEN
		BEGIN
			WriteHex( val, siz, kMaxBytesPerLine, FALSE );
			Write( ' = ', LongIntPtr( val )^ / 1000000.0 : 0 : 6, ' MHz' );
		END
	ELSE IF ValIsCString( val, siz ) THEN
		BEGIN
			WriteChars( val, siz, -1 );
		END
	ELSE IF ValIsPString( val, siz ) THEN
		BEGIN
			WriteChars( val, siz, +1 );
		END
	ELSE IF ( siz > 1 ) & ValIsString( val, siz ) THEN
		BEGIN
			WriteChars( val, siz, 0 );
		END
(*
	ELSE IF ValIsNames( val, siz ) THEN
		BEGIN
			WriteHex( val, 4, kMaxBytesPerLine, FALSE );
			WriteLn;
			Write( '':kTabColumn );
			WriteChars( ORD4(val) + 4, siz - 4 );
		END
*)
	ELSE
		BEGIN
			WriteHex( val, siz, kMaxBytesPerLine, TRUE );
		END;
		WriteLn;
END; { WriteProperty }


PROCEDURE ListWithProperties( VAR name : Str255; VAR entry : RegEntryID );
VAR
	modifiers: RegEntryModifiers;
BEGIN
	DoErr( 'RegistryEntryGetMod', RegistryEntryGetMod( entry, modifiers ) );
	IF modifiers <> 0 THEN
		Write( 'mods:', Hex( @modifiers, SizeOf( modifiers ) ), ' ' );

	WriteLn( '/', ConvertColonstoSlashes( name ) );
	PropertiesDump( name, entry, WriteProperty );
	WriteLn;
END; { ListWithProperties }


PROCEDURE NameRegistryDump( PROCEDURE NameCallBack ( VAR name : Str255; VAR entry : RegEntryID ) );
VAR
	err		:	OSErr;
	cookie	:	regEntryIter;
	done	:	Boolean;
	entry	:	RegEntryID;
	name	:	Str255;
	len		:	RegPathNameSize;
BEGIN
	err := RegistryEntryIterateCreate( cookie );
	DoErr( 'RegistryEntryIterateCreate', err );
	IF err = noErr THEN
		REPEAT
			err := RegistryEntryIterate( cookie, kRegIterContinue, entry, done );
			DoErr( 'RegistryEntryIterate', err );
			IF done = FALSE THEN
				BEGIN
					err := RegistryEntryToPathSize( entry, len );
					DoErr( 'RegistryEntryToPathSize', err );
					IF err = noErr THEN
						BEGIN
							err := RegistryCStrEntryToPath( entry, RegCStrEntryNamePtr(@name[1])^, 255 );
							DoErr( 'RegistryEntryToPathSize', err );
							IF err = noErr THEN
								BEGIN
									IF len > 256 THEN
										BEGIN
											WriteLn( '??? len > 255' );
											len := 256;
										END;
									name[0] := CHR(len - 1);
									NameCallBack( name, entry );
								END;
						END;
					err := RegistryEntryIDDispose( entry );
					DoErr( 'RegistryEntryIDDispose', err );
				END; { IF NOT done }
		UNTIL done;
	err := RegistryEntryIterateDispose( cookie );
	DoErr( 'RegistryEntryIterateDispose', err );
END; { NameRegistryDump }



FUNCTION StringPtrOf( CONST s: Str255 ): StringPtr;
BEGIN
	StringPtrOf := @s;
END; { StringPtrOf }



PROCEDURE ResetGPRF;
CONST
	zero = 0;
TYPE
	MyGPRF = ARRAY [0..1] OF LongInt;
CONST
	nilPath : RegEntryIDPtr = NIL;
	pathName = 'Devices:device-tree:chaos:control';
	GPRF: MyGPRF = ($00070101, $00000000);
VAR
	foundEntry: RegEntryID;
BEGIN
	IF RegistryCStrEntryLookup( nilPath^, RegCStrEntryNamePtr( p2cstr( StringPtrOf( pathName ) ) )^, foundEntry ) = noErr THEN
		BEGIN
			WriteLn( 'good' );

			DoErr( 'RegistryPropertySet', RegistryPropertySet( foundEntry, RegCStrEntryNamePtr( p2cstr( StringPtrOf( 'gprf' ) ) )^, @GPRF, 8) );
			
			DoErr( 'RegistryEntryIDDispose( foundEntry )', RegistryEntryIDDispose( foundEntry ) );
		END
	ELSE
		WriteLn( 'Error' );
END; { ResetGPRF }



PROCEDURE ResetR2AD;
CONST
	zero = 0;
CONST
	nilPath : RegEntryIDPtr = NIL;
	pathName = 'Devices:device-tree:bandit:ATY,RV100Parent';
VAR
	foundEntry: RegEntryID;
BEGIN
	IF RegistryCStrEntryLookup( nilPath^, RegCStrEntryNamePtr( p2cstr( StringPtrOf( pathName ) ) )^, foundEntry ) = noErr THEN
		BEGIN
			WriteLn( 'good' );
			
			DoErr( 'RegistryPropertyDelete', RegistryPropertyDelete( foundEntry, RegCStrEntryNamePtr( p2cstr( StringPtrOf( 'R2AD' ) ) )^ ) );
(*
			DoErr( 'RegistryPropertySetMod', RegistryPropertySetMod( foundEntry, RegCStrEntryNamePtr( p2cstr( StringPtrOf( 'R2AD' ) ) )^, kRegPropertyValueIsSavedToNVRAM) );
*)
			DoErr( 'RegistryEntryIDDispose( foundEntry )', RegistryEntryIDDispose( foundEntry ) );
		END
	ELSE
		WriteLn( 'Error' );
END; { ResetGPRF }




PROCEDURE DumpNameRegistryVersion;
VAR
	nameRegVersion	:	LongInt;
	err				:	OSErr;
BEGIN
	err := Gestalt( gestaltNameRegistryVersion, nameRegVersion );
	WriteLn( 'Name Registry Version: ', Copy( StringOf( Ptr( nameRegVersion ) ), 1, 8 ) );
	Writeln;
END; { DumpNameRegVersion }
	


CONST
	kNVRAMSize = 8192;

TYPE
	ThreeLongs = ARRAY[0..2] OF LongInt;
CONST
	powerLogixBytes:  ThreeLongs = ( $4E436E66, $01010000, $0001093C );



BEGIN { Main }

{$IFC doNVRAMTest}
	propNum := 0;
	propSizes := 0;
	propVal := 0;
	GetDateTime( propSecs );
	propTriedLong := 0;
{$ENDC}


	gAppResFile := CurResFile;

{$IFC IsSetGPRF}
	ResetGPRF;
{$ELIFC IsSetR2AD}
	ResetR2AD;
{$ELSEC}
	
	DumpNameRegistryVersion;
	
//	Rewrite( output, "test output" );


{$IFC doNVRAMTest}
	WriteLn('Cleaning NVRAM');
	WriteLn('==============');
	WriteLn;

	CleanNVRAM( FALSE );
	WriteLn;
	WriteLn;
{$ENDC}


	WriteLn('Device Tree');
	WriteLn('===========');
	WriteLn;

{$IFC doNVRAMTest}
	NameRegistryDump( ListAsTreeWithLocation );
{$ELSEC}
	NameRegistryDump( ListAsTree );
	WriteLn;
	WriteLn;
{$ENDC}
	CalculateLocationTopDown;
	WriteLn;
	WriteLn;

//{$IFC 0}
{$IFC doNVRAMTest}
	WriteLn('Cleaning NVRAM');
	WriteLn('==============');
	WriteLn;

	CleanNVRAM( FALSE );
	WriteLn;
	WriteLn;
{$ENDC}


	WriteLn('Device Properties');
	WriteLn('=================');
	WriteLn;
	NameRegistryDump( ListWithProperties );
	WriteLn;
	WriteLn;

	WriteLn('Device Properties');
	WriteLn('=================');
	WriteLn;
	
	WriteLn( 'NVRAM' );
	WriteLn( '=====' );
	WriteLn;
	DumpNVRAM( 0, kNVRAMSize, TRUE, 'NVRM' );


{$IFC doClearOSPartition}

	WriteLn;
	WriteLn ('Clearing NVRAM OS Partition...');


	ClearNVRAM( $10, $800 ); // $1000

{
	ClearNVRAM( 0, $800 ); // $1000
	WriteNVRAM( 0, sizeof( powerLogixBytes ), @powerLogixBytes );
}
{$ENDC}

{$IFC doNVRAMClear}

	WriteLn;
	WriteLn ('Clearing NVRAM...');

	WriteNVRAMByte( kNVRAMPropertiesPartitionStart, $14 );
	WriteNVRAMByte( kNVRAMPropertiesPartitionStart + 1, $02 );
	ClearNVRAM( kNVRAMPropertiesPartitionStart + 2, kNVRAMPropertiesPartitionSize - 2 ); { name registry properties }
	WriteLn('Result:');
	WriteLn;
	DumpNVRAM( kNVRAMPropertiesPartitionStart, kNVRAMPropertiesPartitionSize, FALSE, 'PROP' );

{$ELSEC}

	WriteLn;
	WriteLn( 'NVRAM Properties' );
	WriteLn( '================' );
	WriteLn;
	DumpNVRAM( kNVRAMPropertiesPartitionStart, kNVRAMPropertiesPartitionSize, TRUE, 'PROP' );
	WriteLn;
	WriteLn;

{$IFC doNVRAMTest}
	WriteLn('Cleaning NVRAM');
	WriteLn('==============');
	WriteLn;

	CleanNVRAM( TRUE );
	WriteLn;
	WriteLn;


	WriteLn;
	WriteLn( 'NVRAM Properties' );
	WriteLn( '================' );
	WriteLn;
	DumpNVRAM( kNVRAMPropertiesPartitionStart, kNVRAMPropertiesPartitionSize, TRUE, 'PROP' );
	WriteLn;
	WriteLn;
{$ENDC}  // doNVRAMTest

{$ENDC} // ELSE NOT doNVRAMClear


// {$ENDC} { IFC 0 }
	
	SysBeep(1);
{$ENDC} { ELSE IsSetGPRF }
END.
