/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.TypeParameterMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageToByteEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private final boolean preferDirect;

    protected MessageToByteEncoder() {
        this(true);
    }

    protected MessageToByteEncoder(Class<? extends I> outboundMessageType) {
        this(outboundMessageType, true);
    }

    protected MessageToByteEncoder(boolean preferDirect) {
        this.matcher = TypeParameterMatcher.find((Object)((Object)this), MessageToByteEncoder.class, (String)"I");
        this.preferDirect = preferDirect;
    }

    protected MessageToByteEncoder(Class<? extends I> outboundMessageType, boolean preferDirect) {
        this.matcher = TypeParameterMatcher.get(outboundMessageType);
        this.preferDirect = preferDirect;
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        block14: {
            ByteBuf buf = null;
            try {
                if (this.acceptOutboundMessage(msg)) {
                    Object cast = msg;
                    buf = this.preferDirect ? ctx.alloc().ioBuffer() : ctx.alloc().heapBuffer();
                    try {
                        this.encode(ctx, cast, buf);
                    }
                    finally {
                        ReferenceCountUtil.release((Object)cast);
                    }
                    if (buf.isReadable()) {
                        ctx.write((Object)buf, promise);
                    } else {
                        buf.release();
                        ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
                    }
                    buf = null;
                    break block14;
                }
                ctx.write(msg, promise);
            }
            catch (EncoderException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new EncoderException(e);
            }
            finally {
                if (buf != null) {
                    buf.release();
                }
            }
        }
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, ByteBuf var3) throws Exception;
}

