/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.optifine.ConnectedProperties;
import net.optifine.config.INameGetter;
import net.optifine.config.MatchBlock;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeInt;
import net.optifine.config.RangeListInt;
import net.optifine.config.VillagerProfession;
import net.optifine.config.Weather;
import net.optifine.util.EntityUtils;

public class ConnectedParser {
    private String context = null;
    public static final VillagerProfession[] PROFESSIONS_INVALID = new VillagerProfession[0];
    public static final zd[] DYE_COLORS_INVALID = new zd[0];
    private static final INameGetter<Enum> NAME_GETTER_ENUM = new INameGetter<Enum>(){

        @Override
        public String getName(Enum en2) {
            return en2.name();
        }
    };
    private static final INameGetter<zd> NAME_GETTER_DYE_COLOR = new INameGetter<zd>(){

        @Override
        public String getName(zd col) {
            return col.l();
        }
    };

    public ConnectedParser(String context) {
        this.context = context;
    }

    public String parseName(String path) {
        int pos2;
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        return str;
    }

    public String parseBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public MatchBlock[] parseMatchBlocks(String propMatchBlocks) {
        if (propMatchBlocks == null) {
            return null;
        }
        ArrayList<MatchBlock> list = new ArrayList<MatchBlock>();
        String[] blockStrs = Config.tokenize(propMatchBlocks, " ");
        for (int i2 = 0; i2 < blockStrs.length; ++i2) {
            String blockStr = blockStrs[i2];
            MatchBlock[] mbs = this.parseMatchBlock(blockStr);
            if (mbs == null) continue;
            list.addAll(Arrays.asList(mbs));
        }
        MatchBlock[] mbs = list.toArray(new MatchBlock[list.size()]);
        return mbs;
    }

    public alz parseBlockState(String str, alz def) {
        MatchBlock[] mbs = this.parseMatchBlock(str);
        if (mbs == null) {
            return def;
        }
        if (mbs.length != 1) {
            return def;
        }
        MatchBlock mb2 = mbs[0];
        int blockId = mb2.getBlockId();
        afh block = afh.c(blockId);
        return block.Q();
    }

    public MatchBlock[] parseMatchBlock(String blockStr) {
        if (blockStr == null) {
            return null;
        }
        if ((blockStr = blockStr.trim()).length() <= 0) {
            return null;
        }
        String[] parts = Config.tokenize(blockStr, ":");
        String domain = "minecraft";
        int blockIndex = 0;
        if (parts.length > 1 && this.isFullBlockName(parts)) {
            domain = parts[0];
            blockIndex = 1;
        } else {
            domain = "minecraft";
            blockIndex = 0;
        }
        String blockPart = parts[blockIndex];
        String[] params = Arrays.copyOfRange(parts, blockIndex + 1, parts.length);
        afh[] blocks = this.parseBlockPart(domain, blockPart);
        if (blocks == null) {
            return null;
        }
        MatchBlock[] datas = new MatchBlock[blocks.length];
        for (int i2 = 0; i2 < blocks.length; ++i2) {
            MatchBlock bd2;
            afh block = blocks[i2];
            int blockId = afh.a(block);
            int[] metadatas = null;
            if (params.length > 0 && (metadatas = this.parseBlockMetadatas(block, params)) == null) {
                return null;
            }
            datas[i2] = bd2 = new MatchBlock(blockId, metadatas);
        }
        return datas;
    }

    public boolean isFullBlockName(String[] parts) {
        if (parts.length < 2) {
            return false;
        }
        String part1 = parts[1];
        if (part1.length() < 1) {
            return false;
        }
        if (this.startsWithDigit(part1)) {
            return false;
        }
        return !part1.contains("=");
    }

    public boolean startsWithDigit(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() < 1) {
            return false;
        }
        char ch = str.charAt(0);
        return Character.isDigit(ch);
    }

    public afh[] parseBlockPart(String domain, String blockPart) {
        if (this.startsWithDigit(blockPart)) {
            int[] ids = this.parseIntList(blockPart);
            if (ids == null) {
                return null;
            }
            afh[] blocks = new afh[ids.length];
            for (int i2 = 0; i2 < ids.length; ++i2) {
                int id2 = ids[i2];
                afh block = afh.c(id2);
                if (block == null) {
                    this.warn("Block not found for id: " + id2);
                    return null;
                }
                blocks[i2] = block;
            }
            return blocks;
        }
        String fullName = domain + ":" + blockPart;
        afh block = afh.b(fullName);
        if (block == null) {
            this.warn("Block not found for name: " + fullName);
            return null;
        }
        afh[] blocks = new afh[]{block};
        return blocks;
    }

    public int[] parseBlockMetadatas(afh block, String[] params) {
        if (params.length <= 0) {
            return null;
        }
        String param0 = params[0];
        if (this.startsWithDigit(param0)) {
            int[] mds = this.parseIntList(param0);
            return mds;
        }
        alz stateDefault = block.Q();
        Collection<amo> properties = stateDefault.a();
        HashMap<amo, List<Comparable>> mapPropValues = new HashMap<amo, List<Comparable>>();
        for (int i2 = 0; i2 < params.length; ++i2) {
            String param = params[i2];
            if (param.length() <= 0) continue;
            String[] parts = Config.tokenize(param, "=");
            if (parts.length != 2) {
                this.warn("Invalid block property: " + param);
                return null;
            }
            String key = parts[0];
            String valStr = parts[1];
            amo prop = ConnectedProperties.getProperty(key, properties);
            if (prop == null) {
                this.warn("Property not found: " + key + ", block: " + block);
                return null;
            }
            ArrayList<Comparable> list = (ArrayList<Comparable>)mapPropValues.get(key);
            if (list == null) {
                list = new ArrayList<Comparable>();
                mapPropValues.put(prop, list);
            }
            String[] vals = Config.tokenize(valStr, ",");
            for (int v2 = 0; v2 < vals.length; ++v2) {
                String val = vals[v2];
                Comparable propVal = ConnectedParser.parsePropertyValue(prop, val);
                if (propVal == null) {
                    this.warn("Property value not found: " + val + ", property: " + key + ", block: " + block);
                    return null;
                }
                list.add(propVal);
            }
        }
        if (mapPropValues.isEmpty()) {
            return null;
        }
        ArrayList<Integer> listMetadatas = new ArrayList<Integer>();
        for (int i3 = 0; i3 < 16; ++i3) {
            int md2 = i3;
            try {
                alz bs2 = this.getStateFromMeta(block, md2);
                if (!this.matchState(bs2, mapPropValues)) continue;
                listMetadatas.add(md2);
                continue;
            }
            catch (IllegalArgumentException e2) {
                // empty catch block
            }
        }
        if (listMetadatas.size() == 16) {
            return null;
        }
        int[] metadatas = new int[listMetadatas.size()];
        for (int i4 = 0; i4 < metadatas.length; ++i4) {
            metadatas[i4] = (Integer)listMetadatas.get(i4);
        }
        return metadatas;
    }

    private alz getStateFromMeta(afh block, int md2) {
        try {
            alz bs2 = block.a(md2);
            if (block == afi.cF && md2 > 7) {
                alz bsLow = block.a(md2 & 7);
                bs2 = bs2.a(agi.a, bsLow.b(agi.a));
            }
            return bs2;
        }
        catch (IllegalArgumentException e2) {
            return block.Q();
        }
    }

    public static Comparable parsePropertyValue(amo prop, String valStr) {
        Class valueClass = prop.b();
        Comparable valueObj = ConnectedParser.parseValue(valStr, valueClass);
        if (valueObj == null) {
            Collection propertyValues = prop.c();
            valueObj = ConnectedParser.getPropertyValue(valStr, propertyValues);
        }
        return valueObj;
    }

    public static Comparable getPropertyValue(String value, Collection propertyValues) {
        for (Comparable obj : propertyValues) {
            if (!ConnectedParser.getValueName(obj).equals(value)) continue;
            return obj;
        }
        return null;
    }

    private static Object getValueName(Comparable obj) {
        if (obj instanceof nw) {
            nw iss = (nw)((Object)obj);
            return iss.l();
        }
        return obj.toString();
    }

    public static Comparable parseValue(String str, Class cls) {
        if (cls == String.class) {
            return str;
        }
        if (cls == Boolean.class) {
            return Boolean.valueOf(str);
        }
        if (cls == Float.class) {
            return Float.valueOf(str);
        }
        if (cls == Double.class) {
            return Double.valueOf(str);
        }
        if (cls == Integer.class) {
            return Integer.valueOf(str);
        }
        if (cls == Long.class) {
            return Long.valueOf(str);
        }
        return null;
    }

    public boolean matchState(alz bs2, Map<amo, List<Comparable>> mapPropValues) {
        Set<amo> keys = mapPropValues.keySet();
        for (amo prop : keys) {
            List<Comparable> vals = mapPropValues.get(prop);
            Object bsVal = bs2.b(prop);
            if (bsVal == null) {
                return false;
            }
            if (vals.contains(bsVal)) continue;
            return false;
        }
        return true;
    }

    public ady[] parseBiomes(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        boolean negative = false;
        if (str.startsWith("!")) {
            negative = true;
            str = str.substring(1);
        }
        String[] biomeNames = Config.tokenize(str, " ");
        ArrayList<ady> list = new ArrayList<ady>();
        for (int i2 = 0; i2 < biomeNames.length; ++i2) {
            String biomeName = biomeNames[i2];
            ady biome = this.findBiome(biomeName);
            if (biome == null) {
                this.warn("Biome not found: " + biomeName);
                continue;
            }
            list.add(biome);
        }
        if (negative) {
            ArrayList<ady> listAllBiomes = new ArrayList<ady>(Arrays.asList(ady.n()));
            listAllBiomes.removeAll(list);
            list = listAllBiomes;
        }
        ady[] biomeArr = list.toArray(new ady[list.size()]);
        return biomeArr;
    }

    public ady findBiome(String biomeName) {
        if ((biomeName = biomeName.toLowerCase()).equals("nether")) {
            return ady.x;
        }
        ady[] biomeList = ady.n();
        for (int i2 = 0; i2 < biomeList.length; ++i2) {
            String name;
            ady biome = biomeList[i2];
            if (biome == null || !(name = biome.ah.replace(" ", "").toLowerCase()).equals(biomeName)) continue;
            return biome;
        }
        return null;
    }

    public int parseInt(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        int num = Config.parseInt(str = str.trim(), -1);
        if (num < 0) {
            this.warn("Invalid number: " + str);
            return defVal;
        }
        return num;
    }

    public int[] parseIntList(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] intStrs = Config.tokenize(str, " ,");
        for (int i2 = 0; i2 < intStrs.length; ++i2) {
            String intStr = intStrs[i2];
            if (intStr.contains("-")) {
                String[] subStrs = Config.tokenize(intStr, "-");
                if (subStrs.length != 2) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                int min = Config.parseInt(subStrs[0], -1);
                int max = Config.parseInt(subStrs[1], -1);
                if (min < 0 || max < 0 || min > max) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                for (int n2 = min; n2 <= max; ++n2) {
                    list.add(n2);
                }
                continue;
            }
            int val = Config.parseInt(intStr, -1);
            if (val < 0) {
                this.warn("Invalid number: " + intStr + ", when parsing: " + str);
                continue;
            }
            list.add(val);
        }
        int[] ints = new int[list.size()];
        for (int i3 = 0; i3 < ints.length; ++i3) {
            ints[i3] = (Integer)list.get(i3);
        }
        return ints;
    }

    public boolean[] parseFaces(String str, boolean[] defVal) {
        if (str == null) {
            return defVal;
        }
        EnumSet<cq> setFaces = EnumSet.allOf(cq.class);
        String[] faceStrs = Config.tokenize(str, " ,");
        for (int i2 = 0; i2 < faceStrs.length; ++i2) {
            String faceStr = faceStrs[i2];
            if (faceStr.equals("sides")) {
                setFaces.add(cq.c);
                setFaces.add(cq.d);
                setFaces.add(cq.e);
                setFaces.add(cq.f);
                continue;
            }
            if (faceStr.equals("all")) {
                setFaces.addAll(Arrays.asList(cq.n));
                continue;
            }
            cq face = this.parseFace(faceStr);
            if (face == null) continue;
            setFaces.add(face);
        }
        boolean[] faces = new boolean[cq.n.length];
        for (int i3 = 0; i3 < faces.length; ++i3) {
            faces[i3] = setFaces.contains(cq.n[i3]);
        }
        return faces;
    }

    public cq parseFace(String str) {
        if ((str = str.toLowerCase()).equals("bottom") || str.equals("down")) {
            return cq.a;
        }
        if (str.equals("top") || str.equals("up")) {
            return cq.b;
        }
        if (str.equals("north")) {
            return cq.c;
        }
        if (str.equals("south")) {
            return cq.d;
        }
        if (str.equals("east")) {
            return cq.f;
        }
        if (str.equals("west")) {
            return cq.e;
        }
        Config.warn("Unknown face: " + str);
        return null;
    }

    public void dbg(String str) {
        Config.dbg("" + this.context + ": " + str);
    }

    public void warn(String str) {
        Config.warn("" + this.context + ": " + str);
    }

    public RangeListInt parseRangeListInt(String str) {
        if (str == null) {
            return null;
        }
        RangeListInt list = new RangeListInt();
        String[] parts = Config.tokenize(str, " ,");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            RangeInt ri2 = this.parseRangeInt(part);
            if (ri2 == null) {
                return null;
            }
            list.addRange(ri2);
        }
        return list;
    }

    private RangeInt parseRangeInt(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(45) >= 0) {
            String[] parts = Config.tokenize(str, "-");
            if (parts.length != 2) {
                this.warn("Invalid range: " + str);
                return null;
            }
            int min = Config.parseInt(parts[0], -1);
            int max = Config.parseInt(parts[1], -1);
            if (min < 0 || max < 0) {
                this.warn("Invalid range: " + str);
                return null;
            }
            return new RangeInt(min, max);
        }
        int val = Config.parseInt(str, -1);
        if (val < 0) {
            this.warn("Invalid integer: " + str);
            return null;
        }
        return new RangeInt(val, val);
    }

    public boolean parseBoolean(String str, boolean defVal) {
        if (str == null) {
            return defVal;
        }
        String strLower = str.toLowerCase().trim();
        if (strLower.equals("true")) {
            return true;
        }
        if (strLower.equals("false")) {
            return false;
        }
        this.warn("Invalid boolean: " + str);
        return defVal;
    }

    public Boolean parseBooleanObject(String str) {
        if (str == null) {
            return null;
        }
        String strLower = str.toLowerCase().trim();
        if (strLower.equals("true")) {
            return Boolean.TRUE;
        }
        if (strLower.equals("false")) {
            return Boolean.FALSE;
        }
        this.warn("Invalid boolean: " + str);
        return null;
    }

    public static int parseColor(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e2) {
            return defVal;
        }
    }

    public static int parseColor4(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        str = str.trim();
        try {
            int val = (int)(Long.parseLong(str, 16) & 0xFFFFFFFFFFFFFFFFL);
            return val;
        }
        catch (NumberFormatException e2) {
            return defVal;
        }
    }

    public adf parseBlockRenderLayer(String str, adf def) {
        if (str == null) {
            return def;
        }
        str = str.toLowerCase().trim();
        adf[] layers = adf.values();
        for (int i2 = 0; i2 < layers.length; ++i2) {
            adf layer = layers[i2];
            if (!str.equals(layer.name().toLowerCase())) continue;
            return layer;
        }
        return def;
    }

    public <T> T parseObject(String str, T[] objs, INameGetter nameGetter, String property) {
        if (str == null) {
            return null;
        }
        String strLower = str.toLowerCase().trim();
        for (int i2 = 0; i2 < objs.length; ++i2) {
            T obj = objs[i2];
            String name = nameGetter.getName(obj);
            if (name == null || !name.toLowerCase().equals(strLower)) continue;
            return obj;
        }
        this.warn("Invalid " + property + ": " + str);
        return null;
    }

    public <T> T[] parseObjects(String str, T[] objs, INameGetter nameGetter, String property, T[] errValue) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase().trim();
        String[] parts = Config.tokenize(str, " ");
        Object[] arr2 = (Object[])Array.newInstance(objs.getClass().getComponentType(), parts.length);
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            T obj = this.parseObject(part, objs, nameGetter, property);
            if (obj == null) {
                return errValue;
            }
            arr2[i2] = obj;
        }
        return arr2;
    }

    public Enum parseEnum(String str, Enum[] enums, String property) {
        return this.parseObject(str, enums, NAME_GETTER_ENUM, property);
    }

    public Enum[] parseEnums(String str, Enum[] enums, String property, Enum[] errValue) {
        return this.parseObjects(str, enums, NAME_GETTER_ENUM, property, errValue);
    }

    public zd[] parseDyeColors(String str, String property, zd[] errValue) {
        return this.parseObjects(str, zd.values(), NAME_GETTER_DYE_COLOR, property, errValue);
    }

    public Weather[] parseWeather(String str, String property, Weather[] errValue) {
        return this.parseObjects(str, Weather.values(), NAME_GETTER_ENUM, property, errValue);
    }

    public NbtTagValue parseNbtTagValue(String path, String value) {
        if (path == null || value == null) {
            return null;
        }
        return new NbtTagValue(path, value);
    }

    public VillagerProfession[] parseProfessions(String profStr) {
        if (profStr == null) {
            return null;
        }
        ArrayList<VillagerProfession> list = new ArrayList<VillagerProfession>();
        String[] tokens = Config.tokenize(profStr, " ");
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String str = tokens[i2];
            VillagerProfession prof = this.parseProfession(str);
            if (prof == null) {
                this.warn("Invalid profession: " + str);
                return PROFESSIONS_INVALID;
            }
            list.add(prof);
        }
        if (list.isEmpty()) {
            return null;
        }
        VillagerProfession[] arr2 = list.toArray(new VillagerProfession[list.size()]);
        return arr2;
    }

    private VillagerProfession parseProfession(String str) {
        int prof;
        String[] parts = Config.tokenize(str = str.toLowerCase(), ":");
        if (parts.length > 2) {
            return null;
        }
        String profStr = parts[0];
        String carStr = null;
        if (parts.length > 1) {
            carStr = parts[1];
        }
        if ((prof = ConnectedParser.parseProfessionId(profStr)) < 0) {
            return null;
        }
        int[] cars = null;
        if (carStr != null && (cars = ConnectedParser.parseCareerIds(prof, carStr)) == null) {
            return null;
        }
        return new VillagerProfession(prof, cars);
    }

    private static int parseProfessionId(String str) {
        int id2 = Config.parseInt(str, -1);
        if (id2 >= 0) {
            return id2;
        }
        if (str.equals("farmer")) {
            return 0;
        }
        if (str.equals("librarian")) {
            return 1;
        }
        if (str.equals("priest")) {
            return 2;
        }
        if (str.equals("blacksmith")) {
            return 3;
        }
        if (str.equals("butcher")) {
            return 4;
        }
        if (str.equals("nitwit")) {
            return 5;
        }
        return -1;
    }

    private static int[] parseCareerIds(int prof, String str) {
        HashSet<Integer> set = new HashSet<Integer>();
        String[] parts = Config.tokenize(str, ",");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            int id2 = ConnectedParser.parseCareerId(prof, part);
            if (id2 < 0) {
                return null;
            }
            set.add(id2);
        }
        Integer[] integerArr = set.toArray(new Integer[set.size()]);
        int[] arr2 = new int[integerArr.length];
        for (int i3 = 0; i3 < arr2.length; ++i3) {
            arr2[i3] = integerArr[i3];
        }
        return arr2;
    }

    private static int parseCareerId(int prof, String str) {
        int id2 = Config.parseInt(str, -1);
        if (id2 >= 0) {
            return id2;
        }
        if (prof == 0) {
            if (str.equals("farmer")) {
                return 1;
            }
            if (str.equals("fisherman")) {
                return 2;
            }
            if (str.equals("shepherd")) {
                return 3;
            }
            if (str.equals("fletcher")) {
                return 4;
            }
        }
        if (prof == 1) {
            if (str.equals("librarian")) {
                return 1;
            }
            if (str.equals("cartographer")) {
                return 2;
            }
        }
        if (prof == 2 && str.equals("cleric")) {
            return 1;
        }
        if (prof == 3) {
            if (str.equals("armor")) {
                return 1;
            }
            if (str.equals("weapon")) {
                return 2;
            }
            if (str.equals("tool")) {
                return 3;
            }
        }
        if (prof == 4) {
            if (str.equals("butcher")) {
                return 1;
            }
            if (str.equals("leather")) {
                return 2;
            }
        }
        if (prof == 5 && str.equals("nitwit")) {
            return 1;
        }
        return -1;
    }

    public int[] parseItems(String str) {
        str = str.trim();
        TreeSet<Integer> setIds = new TreeSet<Integer>();
        String[] tokens = Config.tokenize(str, " ");
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            jy loc = new jy(token);
            zw item = zw.e.a(loc);
            if (item == null) {
                this.warn("Item not found: " + token);
                continue;
            }
            int id2 = zw.b(item);
            if (id2 < 0) {
                this.warn("Item has no ID: " + item + ", name: " + token);
                continue;
            }
            setIds.add(new Integer(id2));
        }
        Integer[] integers = setIds.toArray(new Integer[setIds.size()]);
        int[] ints = Config.toPrimitive(integers);
        return ints;
    }

    public int[] parseEntities(String str) {
        str = str.trim();
        TreeSet<Integer> setIds = new TreeSet<Integer>();
        String[] tokens = Config.tokenize(str, " ");
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            int id2 = EntityUtils.getEntityIdByName(token);
            if (id2 < 0) {
                this.warn("Entity not found: " + token);
                continue;
            }
            setIds.add(new Integer(id2));
        }
        Integer[] integers = setIds.toArray(new Integer[setIds.size()]);
        int[] ints = Config.toPrimitive(integers);
        return ints;
    }
}

