/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import net.optifine.gui.GuiScreenOF;
import net.optifine.gui.TooltipProvider;

public class TooltipManager {
    private axu guiScreen;
    private TooltipProvider tooltipProvider;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private long mouseStillTime = 0L;

    public TooltipManager(axu guiScreen, TooltipProvider tooltipProvider) {
        this.guiScreen = guiScreen;
        this.tooltipProvider = tooltipProvider;
    }

    public void drawTooltips(int x2, int y2, List buttonList) {
        if (Math.abs(x2 - this.lastMouseX) > 5 || Math.abs(y2 - this.lastMouseY) > 5) {
            this.lastMouseX = x2;
            this.lastMouseY = y2;
            this.mouseStillTime = System.currentTimeMillis();
            return;
        }
        int activateDelay = 700;
        if (System.currentTimeMillis() < this.mouseStillTime + (long)activateDelay) {
            return;
        }
        avs btn = GuiScreenOF.getSelectedButton(x2, y2, buttonList);
        if (btn == null) {
            return;
        }
        Rectangle rect = this.tooltipProvider.getTooltipBounds(this.guiScreen, x2, y2);
        String[] lines = this.tooltipProvider.getTooltipLines(btn, rect.width);
        if (lines == null) {
            return;
        }
        if (lines.length > 8) {
            lines = Arrays.copyOf(lines, 8);
            int n2 = lines.length - 1;
            lines[n2] = lines[n2] + " ...";
        }
        if (this.tooltipProvider.isRenderBorder()) {
            int colBorder = -528449408;
            this.drawRectBorder(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, colBorder);
        }
        avp.a(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, -536870912);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2];
            int col = 0xDDDDDD;
            if (line.endsWith("!")) {
                col = 0xFF2020;
            }
            avn fontRenderer = ave.A().k;
            fontRenderer.a(line, (float)(rect.x + 5), (float)(rect.y + 5 + i2 * 11), col);
        }
    }

    private void drawRectBorder(int x1, int y1, int x2, int y2, int col) {
        avp.a(x1, y1 - 1, x2, y1, col);
        avp.a(x1, y2, x2, y2 + 1, col);
        avp.a(x1 - 1, y1, x1, y2, col);
        avp.a(x2, y1, x2 + 1, y2, col);
    }
}

