/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.optifine.Lang;
import net.optifine.gui.TooltipProviderOptions;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.gui.GuiButtonShaderOption;
import net.optifine.util.StrUtils;

public class TooltipProviderShaderOptions
extends TooltipProviderOptions {
    @Override
    public String[] getTooltipLines(avs btn, int width) {
        if (!(btn instanceof GuiButtonShaderOption)) {
            return null;
        }
        GuiButtonShaderOption btnSo = (GuiButtonShaderOption)btn;
        ShaderOption so2 = btnSo.getShaderOption();
        String[] lines = this.makeTooltipLines(so2, width);
        return lines;
    }

    private String[] makeTooltipLines(ShaderOption so2, int width) {
        String name = so2.getNameText();
        String desc = Config.normalize(so2.getDescriptionText()).trim();
        String[] descs = this.splitDescription(desc);
        avh settings = Config.getGameSettings();
        String id2 = null;
        if (!name.equals(so2.getName()) && settings.y) {
            id2 = "\u00a78" + Lang.get("of.general.id") + ": " + so2.getName();
        }
        String source = null;
        if (so2.getPaths() != null && settings.y) {
            source = "\u00a78" + Lang.get("of.general.from") + ": " + Config.arrayToString(so2.getPaths());
        }
        String def = null;
        if (so2.getValueDefault() != null && settings.y) {
            String defVal = so2.isEnabled() ? so2.getValueText(so2.getValueDefault()) : Lang.get("of.general.ambiguous");
            def = "\u00a78" + Lang.getDefault() + ": " + defVal;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(name);
        list.addAll(Arrays.asList(descs));
        if (id2 != null) {
            list.add(id2);
        }
        if (source != null) {
            list.add(source);
        }
        if (def != null) {
            list.add(def);
        }
        String[] lines = this.makeTooltipLines(width, list);
        return lines;
    }

    private String[] splitDescription(String desc) {
        if (desc.length() <= 0) {
            return new String[0];
        }
        desc = StrUtils.removePrefix(desc, "//");
        String[] descs = desc.split("\\. ");
        for (int i2 = 0; i2 < descs.length; ++i2) {
            descs[i2] = "- " + descs[i2].trim();
            descs[i2] = StrUtils.removeSuffix(descs[i2], ".");
        }
        return descs;
    }

    private String[] makeTooltipLines(int width, List<String> args) {
        avn fr2 = Config.getMinecraft().k;
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < args.size(); ++i2) {
            String arg2 = args.get(i2);
            if (arg2 == null || arg2.length() <= 0) continue;
            List<String> parts = fr2.c(arg2, width);
            for (String part : parts) {
                list.add(part);
            }
        }
        String[] lines = list.toArray(new String[list.size()]);
        return lines;
    }
}

