/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.optifine.BetterGrass;
import net.optifine.BlockDir;
import net.optifine.ConnectedProperties;
import net.optifine.ConnectedTexturesCompact;
import net.optifine.config.Matches;
import net.optifine.model.BlockModelUtils;
import net.optifine.model.ListQuadsOverlay;
import net.optifine.reflect.Reflector;
import net.optifine.render.RenderEnv;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.TileEntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedTextures {
    private static Map[] spriteQuadMaps = null;
    private static Map[] spriteQuadFullMaps = null;
    private static Map[][] spriteQuadCompactMaps = null;
    private static ConnectedProperties[][] blockProperties = null;
    private static ConnectedProperties[][] tileProperties = null;
    private static boolean multipass = false;
    protected static final int UNKNOWN = -1;
    protected static final int Y_NEG_DOWN = 0;
    protected static final int Y_POS_UP = 1;
    protected static final int Z_NEG_NORTH = 2;
    protected static final int Z_POS_SOUTH = 3;
    protected static final int X_NEG_WEST = 4;
    protected static final int X_POS_EAST = 5;
    private static final int Y_AXIS = 0;
    private static final int Z_AXIS = 1;
    private static final int X_AXIS = 2;
    public static final alz AIR_DEFAULT_STATE = afi.a.Q();
    private static bmi emptySprite = null;
    private static final BlockDir[] SIDES_Y_NEG_DOWN = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.NORTH, BlockDir.SOUTH};
    private static final BlockDir[] SIDES_Y_POS_UP = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.SOUTH, BlockDir.NORTH};
    private static final BlockDir[] SIDES_Z_NEG_NORTH = new BlockDir[]{BlockDir.EAST, BlockDir.WEST, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_Z_POS_SOUTH = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_X_NEG_WEST = new BlockDir[]{BlockDir.NORTH, BlockDir.SOUTH, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_X_POS_EAST = new BlockDir[]{BlockDir.SOUTH, BlockDir.NORTH, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_Z_NEG_NORTH_Z_AXIS = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.UP, BlockDir.DOWN};
    private static final BlockDir[] SIDES_X_POS_EAST_X_AXIS = new BlockDir[]{BlockDir.NORTH, BlockDir.SOUTH, BlockDir.UP, BlockDir.DOWN};
    private static final BlockDir[] EDGES_Y_NEG_DOWN = new BlockDir[]{BlockDir.NORTH_EAST, BlockDir.NORTH_WEST, BlockDir.SOUTH_EAST, BlockDir.SOUTH_WEST};
    private static final BlockDir[] EDGES_Y_POS_UP = new BlockDir[]{BlockDir.SOUTH_EAST, BlockDir.SOUTH_WEST, BlockDir.NORTH_EAST, BlockDir.NORTH_WEST};
    private static final BlockDir[] EDGES_Z_NEG_NORTH = new BlockDir[]{BlockDir.DOWN_WEST, BlockDir.DOWN_EAST, BlockDir.UP_WEST, BlockDir.UP_EAST};
    private static final BlockDir[] EDGES_Z_POS_SOUTH = new BlockDir[]{BlockDir.DOWN_EAST, BlockDir.DOWN_WEST, BlockDir.UP_EAST, BlockDir.UP_WEST};
    private static final BlockDir[] EDGES_X_NEG_WEST = new BlockDir[]{BlockDir.DOWN_SOUTH, BlockDir.DOWN_NORTH, BlockDir.UP_SOUTH, BlockDir.UP_NORTH};
    private static final BlockDir[] EDGES_X_POS_EAST = new BlockDir[]{BlockDir.DOWN_NORTH, BlockDir.DOWN_SOUTH, BlockDir.UP_NORTH, BlockDir.UP_SOUTH};
    private static final BlockDir[] EDGES_Z_NEG_NORTH_Z_AXIS = new BlockDir[]{BlockDir.UP_EAST, BlockDir.UP_WEST, BlockDir.DOWN_EAST, BlockDir.DOWN_WEST};
    private static final BlockDir[] EDGES_X_POS_EAST_X_AXIS = new BlockDir[]{BlockDir.UP_SOUTH, BlockDir.UP_NORTH, BlockDir.DOWN_SOUTH, BlockDir.DOWN_NORTH};
    public static final bmi SPRITE_DEFAULT = new bmi("<default>");

    public static bgg[] getConnectedTexture(adq blockAccess, alz blockState, cj blockPos, bgg quad, RenderEnv renderEnv) {
        bmi textureatlassprite = quad.getSprite();
        if (textureatlassprite == null) {
            return renderEnv.getArrayQuadsCtm(quad);
        }
        afh block = blockState.c();
        if (ConnectedTextures.skipConnectedTexture(blockAccess, blockState, blockPos, quad, renderEnv)) {
            quad = ConnectedTextures.getQuad(emptySprite, quad);
            return renderEnv.getArrayQuadsCtm(quad);
        }
        cq enumfacing = quad.d();
        bgg[] abakedquad = ConnectedTextures.getConnectedTextureMultiPass(blockAccess, blockState, blockPos, enumfacing, quad, renderEnv);
        return abakedquad;
    }

    private static boolean skipConnectedTexture(adq blockAccess, alz blockState, cj blockPos, bgg quad, RenderEnv renderEnv) {
        bmi textureatlassprite;
        afh block = blockState.c();
        if (block instanceof akd && (textureatlassprite = quad.getSprite()).i().startsWith("minecraft:blocks/glass_pane_top")) {
            alz iblockstate1 = blockAccess.p(blockPos.a(quad.d()));
            return iblockstate1 == blockState;
        }
        if (block instanceof akd) {
            cq enumfacing = quad.d();
            if (enumfacing != cq.b && enumfacing != cq.a) {
                return false;
            }
            if (!quad.isFaceQuad()) {
                return false;
            }
            cj blockpos = blockPos.a(quad.d());
            alz iblockstate = blockAccess.p(blockpos);
            if (iblockstate.c() != block) {
                return false;
            }
            if (block == afi.cH && iblockstate.b(ajt.a) != blockState.b(ajt.a)) {
                return false;
            }
            iblockstate = iblockstate.c().a(iblockstate, blockAccess, blockpos);
            double d0 = quad.getMidX();
            if (d0 < 0.4) {
                if (iblockstate.b(akd.P).booleanValue()) {
                    return true;
                }
            } else if (d0 > 0.6) {
                if (iblockstate.b(akd.N).booleanValue()) {
                    return true;
                }
            } else {
                double d1 = quad.getMidZ();
                if (d1 < 0.4) {
                    if (iblockstate.b(akd.b).booleanValue()) {
                        return true;
                    }
                } else {
                    if (d1 <= 0.6) {
                        return true;
                    }
                    if (iblockstate.b(akd.O).booleanValue()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected static bgg[] getQuads(bmi sprite, bgg quadIn, RenderEnv renderEnv) {
        if (sprite == null) {
            return null;
        }
        if (sprite == SPRITE_DEFAULT) {
            return renderEnv.getArrayQuadsCtm(quadIn);
        }
        bgg bakedquad = ConnectedTextures.getQuad(sprite, quadIn);
        bgg[] abakedquad = renderEnv.getArrayQuadsCtm(bakedquad);
        return abakedquad;
    }

    private static synchronized bgg getQuad(bmi sprite, bgg quadIn) {
        if (spriteQuadMaps == null) {
            return quadIn;
        }
        int i2 = sprite.getIndexInMap();
        if (i2 >= 0 && i2 < spriteQuadMaps.length) {
            bgg bakedquad;
            IdentityHashMap<bgg, bgg> map = spriteQuadMaps[i2];
            if (map == null) {
                ConnectedTextures.spriteQuadMaps[i2] = map = new IdentityHashMap<bgg, bgg>(1);
            }
            if ((bakedquad = (bgg)map.get(quadIn)) == null) {
                bakedquad = ConnectedTextures.makeSpriteQuad(quadIn, sprite);
                map.put(quadIn, bakedquad);
            }
            return bakedquad;
        }
        return quadIn;
    }

    private static synchronized bgg getQuadFull(bmi sprite, bgg quadIn, int tintIndex) {
        if (spriteQuadFullMaps == null) {
            return null;
        }
        if (sprite == null) {
            return null;
        }
        int i2 = sprite.getIndexInMap();
        if (i2 >= 0 && i2 < spriteQuadFullMaps.length) {
            cq enumfacing;
            bgg bakedquad;
            EnumMap<cq, bgg> map = spriteQuadFullMaps[i2];
            if (map == null) {
                ConnectedTextures.spriteQuadFullMaps[i2] = map = new EnumMap<cq, bgg>(cq.class);
            }
            if ((bakedquad = (bgg)map.get(enumfacing = quadIn.d())) == null) {
                bakedquad = BlockModelUtils.makeBakedQuad(enumfacing, sprite, tintIndex);
                map.put(enumfacing, bakedquad);
            }
            return bakedquad;
        }
        return null;
    }

    private static bgg makeSpriteQuad(bgg quad, bmi sprite) {
        int[] aint = (int[])quad.a().clone();
        bmi textureatlassprite = quad.getSprite();
        for (int i2 = 0; i2 < 4; ++i2) {
            ConnectedTextures.fixVertex(aint, i2, textureatlassprite, sprite);
        }
        bgg bakedquad = new bgg(aint, quad.c(), quad.d(), sprite);
        return bakedquad;
    }

    private static void fixVertex(int[] data, int vertex, bmi spriteFrom, bmi spriteTo) {
        int i2 = data.length / 4;
        int j2 = i2 * vertex;
        float f2 = Float.intBitsToFloat(data[j2 + 4]);
        float f1 = Float.intBitsToFloat(data[j2 + 4 + 1]);
        double d0 = spriteFrom.getSpriteU16(f2);
        double d1 = spriteFrom.getSpriteV16(f1);
        data[j2 + 4] = Float.floatToRawIntBits(spriteTo.a(d0));
        data[j2 + 4 + 1] = Float.floatToRawIntBits(spriteTo.b(d1));
    }

    private static bgg[] getConnectedTextureMultiPass(adq blockAccess, alz blockState, cj blockPos, cq side, bgg quad, RenderEnv renderEnv) {
        bgg[] abakedquad = ConnectedTextures.getConnectedTextureSingle(blockAccess, blockState, blockPos, side, quad, true, 0, renderEnv);
        if (!multipass) {
            return abakedquad;
        }
        if (abakedquad.length == 1 && abakedquad[0] == quad) {
            return abakedquad;
        }
        List<bgg> list = renderEnv.getListQuadsCtmMultipass(abakedquad);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            bgg[] abakedquad1;
            bgg bakedquad;
            bgg bakedquad1 = bakedquad = list.get(i2);
            for (int j2 = 0; j2 < 3 && (abakedquad1 = ConnectedTextures.getConnectedTextureSingle(blockAccess, blockState, blockPos, side, bakedquad1, false, j2 + 1, renderEnv)).length == 1 && abakedquad1[0] != bakedquad1; ++j2) {
                bakedquad1 = abakedquad1[0];
            }
            list.set(i2, bakedquad1);
        }
        for (int k2 = 0; k2 < abakedquad.length; ++k2) {
            abakedquad[k2] = list.get(k2);
        }
        return abakedquad;
    }

    public static bgg[] getConnectedTextureSingle(adq blockAccess, alz blockState, cj blockPos, cq facing, bgg quad, boolean checkBlocks, int pass, RenderEnv renderEnv) {
        ConnectedProperties[] aconnectedproperties1;
        int l2;
        ConnectedProperties[] aconnectedproperties;
        int i2;
        afh block = blockState.c();
        if (!(blockState instanceof aly)) {
            return renderEnv.getArrayQuadsCtm(quad);
        }
        aly blockstatebase = (aly)blockState;
        bmi textureatlassprite = quad.getSprite();
        if (tileProperties != null && (i2 = textureatlassprite.getIndexInMap()) >= 0 && i2 < tileProperties.length && (aconnectedproperties = tileProperties[i2]) != null) {
            int j2 = ConnectedTextures.getSide(facing);
            for (int k2 = 0; k2 < aconnectedproperties.length; ++k2) {
                bgg[] abakedquad;
                ConnectedProperties connectedproperties = aconnectedproperties[k2];
                if (connectedproperties == null || !connectedproperties.matchesBlockId(blockstatebase.getBlockId()) || (abakedquad = ConnectedTextures.getConnectedTexture(connectedproperties, blockAccess, blockstatebase, blockPos, j2, quad, pass, renderEnv)) == null) continue;
                return abakedquad;
            }
        }
        if (blockProperties != null && checkBlocks && (l2 = renderEnv.getBlockId()) >= 0 && l2 < blockProperties.length && (aconnectedproperties1 = blockProperties[l2]) != null) {
            int i1 = ConnectedTextures.getSide(facing);
            for (int j1 = 0; j1 < aconnectedproperties1.length; ++j1) {
                bgg[] abakedquad1;
                ConnectedProperties connectedproperties1 = aconnectedproperties1[j1];
                if (connectedproperties1 == null || !connectedproperties1.matchesIcon(textureatlassprite) || (abakedquad1 = ConnectedTextures.getConnectedTexture(connectedproperties1, blockAccess, blockstatebase, blockPos, i1, quad, pass, renderEnv)) == null) continue;
                return abakedquad1;
            }
        }
        return renderEnv.getArrayQuadsCtm(quad);
    }

    public static int getSide(cq facing) {
        if (facing == null) {
            return -1;
        }
        switch (facing) {
            case a: {
                return 0;
            }
            case b: {
                return 1;
            }
            case f: {
                return 5;
            }
            case e: {
                return 4;
            }
            case c: {
                return 2;
            }
            case d: {
                return 3;
            }
        }
        return -1;
    }

    private static cq getFacing(int side) {
        switch (side) {
            case 0: {
                return cq.a;
            }
            case 1: {
                return cq.b;
            }
            case 2: {
                return cq.c;
            }
            case 3: {
                return cq.d;
            }
            case 4: {
                return cq.e;
            }
            case 5: {
                return cq.f;
            }
        }
        return cq.b;
    }

    private static bgg[] getConnectedTexture(ConnectedProperties cp2, adq blockAccess, aly blockState, cj blockPos, int side, bgg quad, int pass, RenderEnv renderEnv) {
        String s2;
        ady biomegenbase;
        int j2;
        int i2 = 0;
        int k2 = j2 = blockState.getMetadata();
        afh block = blockState.c();
        if (block instanceof ajg) {
            i2 = ConnectedTextures.getWoodAxis(side, j2);
            if (cp2.getMetadataMax() <= 3) {
                k2 = j2 & 3;
            }
        }
        if (block instanceof aiw) {
            i2 = ConnectedTextures.getQuartzAxis(side, j2);
            if (cp2.getMetadataMax() <= 2 && k2 > 2) {
                k2 = 2;
            }
        }
        if (!cp2.matchesBlock(blockState.getBlockId(), k2)) {
            return null;
        }
        if (side >= 0 && cp2.faces != 63) {
            int l2 = side;
            if (i2 != 0) {
                l2 = ConnectedTextures.fixSideByAxis(side, i2);
            }
            if ((1 << l2 & cp2.faces) == 0) {
                return null;
            }
        }
        int i1 = blockPos.o();
        if (cp2.heights != null && !cp2.heights.isInRange(i1)) {
            return null;
        }
        if (cp2.biomes != null && !cp2.matchesBiome(biomegenbase = blockAccess.b(blockPos))) {
            return null;
        }
        if (cp2.nbtName != null && !cp2.nbtName.matchesValue(s2 = TileEntityUtils.getTileEntityName(blockAccess, blockPos))) {
            return null;
        }
        bmi textureatlassprite = quad.getSprite();
        switch (cp2.method) {
            case 1: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureCtm(cp2, blockAccess, blockState, blockPos, i2, side, textureatlassprite, j2, renderEnv), quad, renderEnv);
            }
            case 2: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureHorizontal(cp2, blockAccess, blockState, blockPos, i2, side, textureatlassprite, j2), quad, renderEnv);
            }
            case 3: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureTop(cp2, blockAccess, blockState, blockPos, i2, side, textureatlassprite, j2), quad, renderEnv);
            }
            case 4: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureRandom(cp2, blockAccess, blockState, blockPos, side), quad, renderEnv);
            }
            case 5: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureRepeat(cp2, blockPos, side), quad, renderEnv);
            }
            case 6: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureVertical(cp2, blockAccess, blockState, blockPos, i2, side, textureatlassprite, j2), quad, renderEnv);
            }
            case 7: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureFixed(cp2), quad, renderEnv);
            }
            case 8: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureHorizontalVertical(cp2, blockAccess, blockState, blockPos, i2, side, textureatlassprite, j2), quad, renderEnv);
            }
            case 9: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureVerticalHorizontal(cp2, blockAccess, blockState, blockPos, i2, side, textureatlassprite, j2), quad, renderEnv);
            }
            case 10: {
                if (pass == 0) {
                    return ConnectedTextures.getConnectedTextureCtmCompact(cp2, blockAccess, blockState, blockPos, i2, side, quad, j2, renderEnv);
                }
            }
            default: {
                return null;
            }
            case 11: {
                return ConnectedTextures.getConnectedTextureOverlay(cp2, blockAccess, blockState, blockPos, i2, side, quad, j2, renderEnv);
            }
            case 12: {
                return ConnectedTextures.getConnectedTextureOverlayFixed(cp2, quad, renderEnv);
            }
            case 13: {
                return ConnectedTextures.getConnectedTextureOverlayRandom(cp2, blockAccess, blockState, blockPos, side, quad, renderEnv);
            }
            case 14: {
                return ConnectedTextures.getConnectedTextureOverlayRepeat(cp2, blockPos, side, quad, renderEnv);
            }
            case 15: 
        }
        return ConnectedTextures.getConnectedTextureOverlayCtm(cp2, blockAccess, blockState, blockPos, i2, side, quad, j2, renderEnv);
    }

    private static int fixSideByAxis(int side, int vertAxis) {
        switch (vertAxis) {
            case 0: {
                return side;
            }
            case 1: {
                switch (side) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return side;
            }
            case 2: {
                switch (side) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 5;
                    }
                    default: {
                        return side;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: 
                }
                return 0;
            }
        }
        return side;
    }

    private static int getWoodAxis(int side, int metadata) {
        int i2 = (metadata & 0xC) >> 2;
        switch (i2) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    private static int getQuartzAxis(int side, int metadata) {
        switch (metadata) {
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    private static bmi getConnectedTextureRandom(ConnectedProperties cp2, adq blockAccess, aly blockState, cj blockPos, int side) {
        if (cp2.tileIcons.length == 1) {
            return cp2.tileIcons[0];
        }
        int i2 = side / cp2.symmetry * cp2.symmetry;
        if (cp2.linked) {
            cj blockpos = blockPos.b();
            alz iblockstate = blockAccess.p(blockpos);
            while (iblockstate.c() == blockState.c()) {
                blockPos = blockpos;
                if ((blockpos = blockpos.b()).o() < 0) break;
                iblockstate = blockAccess.p(blockpos);
            }
        }
        int l2 = Config.getRandom(blockPos, i2) & Integer.MAX_VALUE;
        for (int i1 = 0; i1 < cp2.randomLoops; ++i1) {
            l2 = Config.intHash(l2);
        }
        int j1 = 0;
        if (cp2.weights == null) {
            j1 = l2 % cp2.tileIcons.length;
        } else {
            int j2 = l2 % cp2.sumAllWeights;
            int[] aint = cp2.sumWeights;
            for (int k2 = 0; k2 < aint.length; ++k2) {
                if (j2 >= aint[k2]) continue;
                j1 = k2;
                break;
            }
        }
        return cp2.tileIcons[j1];
    }

    private static bmi getConnectedTextureFixed(ConnectedProperties cp2) {
        return cp2.tileIcons[0];
    }

    private static bmi getConnectedTextureRepeat(ConnectedProperties cp2, cj blockPos, int side) {
        if (cp2.tileIcons.length == 1) {
            return cp2.tileIcons[0];
        }
        int i2 = blockPos.n();
        int j2 = blockPos.o();
        int k2 = blockPos.p();
        int l2 = 0;
        int i1 = 0;
        switch (side) {
            case 0: {
                l2 = i2;
                i1 = -k2 - 1;
                break;
            }
            case 1: {
                l2 = i2;
                i1 = k2;
                break;
            }
            case 2: {
                l2 = -i2 - 1;
                i1 = -j2;
                break;
            }
            case 3: {
                l2 = i2;
                i1 = -j2;
                break;
            }
            case 4: {
                l2 = k2;
                i1 = -j2;
                break;
            }
            case 5: {
                l2 = -k2 - 1;
                i1 = -j2;
            }
        }
        i1 %= cp2.height;
        if ((l2 %= cp2.width) < 0) {
            l2 += cp2.width;
        }
        if (i1 < 0) {
            i1 += cp2.height;
        }
        int j1 = i1 * cp2.width + l2;
        return cp2.tileIcons[j1];
    }

    private static bmi getConnectedTextureCtm(ConnectedProperties cp2, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bmi icon, int metadata, RenderEnv renderEnv) {
        int i2 = ConnectedTextures.getConnectedTextureCtmIndex(cp2, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata, renderEnv);
        return cp2.tileIcons[i2];
    }

    private static synchronized bgg[] getConnectedTextureCtmCompact(ConnectedProperties cp2, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bgg quad, int metadata, RenderEnv renderEnv) {
        bmi textureatlassprite = quad.getSprite();
        int i2 = ConnectedTextures.getConnectedTextureCtmIndex(cp2, blockAccess, blockState, blockPos, vertAxis, side, textureatlassprite, metadata, renderEnv);
        return ConnectedTexturesCompact.getConnectedTextureCtmCompact(i2, cp2, side, quad, renderEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static bgg[] getConnectedTextureOverlay(ConnectedProperties cp2, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bgg quad, int metadata, RenderEnv renderEnv) {
        Object dirEdges;
        if (!quad.isFullQuad()) {
            return null;
        }
        bmi textureatlassprite = quad.getSprite();
        BlockDir[] ablockdir = ConnectedTextures.getSideDirections(side, vertAxis);
        boolean[] aboolean = renderEnv.getBorderFlags();
        for (int i2 = 0; i2 < 4; ++i2) {
            aboolean[i2] = ConnectedTextures.isNeighbourOverlay(cp2, blockAccess, blockState, ablockdir[i2].offset(blockPos), side, textureatlassprite, metadata);
        }
        ListQuadsOverlay listquadsoverlay = renderEnv.getListQuadsOverlay(cp2.layer);
        try {
            if (!(aboolean[0] && aboolean[1] && aboolean[2] && aboolean[3])) {
                if (aboolean[0] && aboolean[1] && aboolean[2]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[5], quad, cp2.tintIndex), cp2.tintBlockState);
                    Object dirEdges2 = null;
                    bgg[] bggArray = dirEdges2;
                    return bggArray;
                }
                if (aboolean[0] && aboolean[2] && aboolean[3]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[6], quad, cp2.tintIndex), cp2.tintBlockState);
                    Object dirEdges3 = null;
                    bgg[] bggArray = dirEdges3;
                    return bggArray;
                }
                if (aboolean[1] && aboolean[2] && aboolean[3]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[12], quad, cp2.tintIndex), cp2.tintBlockState);
                    Object dirEdges4 = null;
                    bgg[] bggArray = dirEdges4;
                    return bggArray;
                }
                if (aboolean[0] && aboolean[1] && aboolean[3]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[13], quad, cp2.tintIndex), cp2.tintBlockState);
                    Object dirEdges5 = null;
                    bgg[] bggArray = dirEdges5;
                    return bggArray;
                }
                BlockDir[] ablockdir1 = ConnectedTextures.getEdgeDirections(side, vertAxis);
                boolean[] aboolean1 = renderEnv.getBorderFlags2();
                for (int j2 = 0; j2 < 4; ++j2) {
                    aboolean1[j2] = ConnectedTextures.isNeighbourOverlay(cp2, blockAccess, blockState, ablockdir1[j2].offset(blockPos), side, textureatlassprite, metadata);
                }
                if (aboolean[1] && aboolean[2]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[3], quad, cp2.tintIndex), cp2.tintBlockState);
                    if (aboolean1[3]) {
                        listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[16], quad, cp2.tintIndex), cp2.tintBlockState);
                    }
                    Object object4 = null;
                    bgg[] bggArray = object4;
                    return bggArray;
                }
                if (aboolean[0] && aboolean[2]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[4], quad, cp2.tintIndex), cp2.tintBlockState);
                    if (aboolean1[2]) {
                        listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[14], quad, cp2.tintIndex), cp2.tintBlockState);
                    }
                    Object object3 = null;
                    bgg[] bggArray = object3;
                    return bggArray;
                }
                if (aboolean[1] && aboolean[3]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[10], quad, cp2.tintIndex), cp2.tintBlockState);
                    if (aboolean1[1]) {
                        listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[2], quad, cp2.tintIndex), cp2.tintBlockState);
                    }
                    Object object2 = null;
                    bgg[] bggArray = object2;
                    return bggArray;
                }
                if (aboolean[0] && aboolean[3]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[11], quad, cp2.tintIndex), cp2.tintBlockState);
                    if (aboolean1[0]) {
                        listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[0], quad, cp2.tintIndex), cp2.tintBlockState);
                    }
                    Object object1 = null;
                    bgg[] bggArray = object1;
                    return bggArray;
                }
                boolean[] aboolean2 = renderEnv.getBorderFlags3();
                for (int k2 = 0; k2 < 4; ++k2) {
                    aboolean2[k2] = ConnectedTextures.isNeighbourMatching(cp2, blockAccess, blockState, ablockdir[k2].offset(blockPos), side, textureatlassprite, metadata);
                }
                if (aboolean[0]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[9], quad, cp2.tintIndex), cp2.tintBlockState);
                }
                if (aboolean[1]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[7], quad, cp2.tintIndex), cp2.tintBlockState);
                }
                if (aboolean[2]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[1], quad, cp2.tintIndex), cp2.tintBlockState);
                }
                if (aboolean[3]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[15], quad, cp2.tintIndex), cp2.tintBlockState);
                }
                if (aboolean1[0] && (aboolean2[1] || aboolean2[2]) && !aboolean[1] && !aboolean[2]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[0], quad, cp2.tintIndex), cp2.tintBlockState);
                }
                if (aboolean1[1] && (aboolean2[0] || aboolean2[2]) && !aboolean[0] && !aboolean[2]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[2], quad, cp2.tintIndex), cp2.tintBlockState);
                }
                if (aboolean1[2] && (aboolean2[1] || aboolean2[3]) && !aboolean[1] && !aboolean[3]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[14], quad, cp2.tintIndex), cp2.tintBlockState);
                }
                if (aboolean1[3] && (aboolean2[0] || aboolean2[3]) && !aboolean[0] && !aboolean[3]) {
                    listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[16], quad, cp2.tintIndex), cp2.tintBlockState);
                }
                Object object5 = null;
                bgg[] bggArray = object5;
                return bggArray;
            }
            listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(cp2.tileIcons[8], quad, cp2.tintIndex), cp2.tintBlockState);
            dirEdges = null;
        }
        finally {
            if (listquadsoverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
        return dirEdges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static bgg[] getConnectedTextureOverlayFixed(ConnectedProperties cp2, bgg quad, RenderEnv renderEnv) {
        Object object;
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listquadsoverlay = renderEnv.getListQuadsOverlay(cp2.layer);
        try {
            bmi textureatlassprite = ConnectedTextures.getConnectedTextureFixed(cp2);
            if (textureatlassprite != null) {
                listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(textureatlassprite, quad, cp2.tintIndex), cp2.tintBlockState);
            }
            object = null;
        }
        finally {
            if (listquadsoverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static bgg[] getConnectedTextureOverlayRandom(ConnectedProperties cp2, adq blockAccess, aly blockState, cj blockPos, int side, bgg quad, RenderEnv renderEnv) {
        Object object;
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listquadsoverlay = renderEnv.getListQuadsOverlay(cp2.layer);
        try {
            bmi textureatlassprite = ConnectedTextures.getConnectedTextureRandom(cp2, blockAccess, blockState, blockPos, side);
            if (textureatlassprite != null) {
                listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(textureatlassprite, quad, cp2.tintIndex), cp2.tintBlockState);
            }
            object = null;
        }
        finally {
            if (listquadsoverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static bgg[] getConnectedTextureOverlayRepeat(ConnectedProperties cp2, cj blockPos, int side, bgg quad, RenderEnv renderEnv) {
        Object object;
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listquadsoverlay = renderEnv.getListQuadsOverlay(cp2.layer);
        try {
            bmi textureatlassprite = ConnectedTextures.getConnectedTextureRepeat(cp2, blockPos, side);
            if (textureatlassprite != null) {
                listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(textureatlassprite, quad, cp2.tintIndex), cp2.tintBlockState);
            }
            object = null;
        }
        finally {
            if (listquadsoverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static bgg[] getConnectedTextureOverlayCtm(ConnectedProperties cp2, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bgg quad, int metadata, RenderEnv renderEnv) {
        Object object;
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listquadsoverlay = renderEnv.getListQuadsOverlay(cp2.layer);
        try {
            bmi textureatlassprite = ConnectedTextures.getConnectedTextureCtm(cp2, blockAccess, blockState, blockPos, vertAxis, side, quad.getSprite(), metadata, renderEnv);
            if (textureatlassprite != null) {
                listquadsoverlay.addQuad(ConnectedTextures.getQuadFull(textureatlassprite, quad, cp2.tintIndex), cp2.tintBlockState);
            }
            object = null;
        }
        finally {
            if (listquadsoverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
        return object;
    }

    private static BlockDir[] getSideDirections(int side, int vertAxis) {
        switch (side) {
            case 0: {
                return SIDES_Y_NEG_DOWN;
            }
            case 1: {
                return SIDES_Y_POS_UP;
            }
            case 2: {
                if (vertAxis == 1) {
                    return SIDES_Z_NEG_NORTH_Z_AXIS;
                }
                return SIDES_Z_NEG_NORTH;
            }
            case 3: {
                return SIDES_Z_POS_SOUTH;
            }
            case 4: {
                return SIDES_X_NEG_WEST;
            }
            case 5: {
                if (vertAxis == 2) {
                    return SIDES_X_POS_EAST_X_AXIS;
                }
                return SIDES_X_POS_EAST;
            }
        }
        throw new IllegalArgumentException("Unknown side: " + side);
    }

    private static BlockDir[] getEdgeDirections(int side, int vertAxis) {
        switch (side) {
            case 0: {
                return EDGES_Y_NEG_DOWN;
            }
            case 1: {
                return EDGES_Y_POS_UP;
            }
            case 2: {
                if (vertAxis == 1) {
                    return EDGES_Z_NEG_NORTH_Z_AXIS;
                }
                return EDGES_Z_NEG_NORTH;
            }
            case 3: {
                return EDGES_Z_POS_SOUTH;
            }
            case 4: {
                return EDGES_X_NEG_WEST;
            }
            case 5: {
                if (vertAxis == 2) {
                    return EDGES_X_POS_EAST_X_AXIS;
                }
                return EDGES_X_POS_EAST;
            }
        }
        throw new IllegalArgumentException("Unknown side: " + side);
    }

    protected static Map[][] getSpriteQuadCompactMaps() {
        return spriteQuadCompactMaps;
    }

    private static int getConnectedTextureCtmIndex(ConnectedProperties cp2, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bmi icon, int metadata, RenderEnv renderEnv) {
        boolean[] aboolean = renderEnv.getBorderFlags();
        switch (side) {
            case 0: {
                aboolean[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                aboolean[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                aboolean[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                aboolean[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                if (!cp2.innerSeams) break;
                cj blockpos6 = blockPos.b();
                aboolean[0] = aboolean[0] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos6.e(), side, icon, metadata);
                aboolean[1] = aboolean[1] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos6.f(), side, icon, metadata);
                aboolean[2] = aboolean[2] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos6.c(), side, icon, metadata);
                aboolean[3] = aboolean[3] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos6.d(), side, icon, metadata);
                break;
            }
            case 1: {
                aboolean[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                aboolean[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                aboolean[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                aboolean[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                if (!cp2.innerSeams) break;
                cj blockpos5 = blockPos.a();
                aboolean[0] = aboolean[0] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos5.e(), side, icon, metadata);
                aboolean[1] = aboolean[1] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos5.f(), side, icon, metadata);
                aboolean[2] = aboolean[2] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos5.d(), side, icon, metadata);
                aboolean[3] = aboolean[3] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos5.c(), side, icon, metadata);
                break;
            }
            case 2: {
                aboolean[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                aboolean[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                aboolean[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                aboolean[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                if (cp2.innerSeams) {
                    cj blockpos4 = blockPos.c();
                    aboolean[0] = aboolean[0] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos4.f(), side, icon, metadata);
                    aboolean[1] = aboolean[1] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos4.e(), side, icon, metadata);
                    aboolean[2] = aboolean[2] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos4.b(), side, icon, metadata);
                    boolean bl2 = aboolean[3] = aboolean[3] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos4.a(), side, icon, metadata);
                }
                if (vertAxis != 1) break;
                ConnectedTextures.switchValues(0, 1, aboolean);
                ConnectedTextures.switchValues(2, 3, aboolean);
                break;
            }
            case 3: {
                aboolean[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                aboolean[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                aboolean[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                aboolean[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                if (!cp2.innerSeams) break;
                cj blockpos3 = blockPos.d();
                aboolean[0] = aboolean[0] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos3.e(), side, icon, metadata);
                aboolean[1] = aboolean[1] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos3.f(), side, icon, metadata);
                aboolean[2] = aboolean[2] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos3.b(), side, icon, metadata);
                aboolean[3] = aboolean[3] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos3.a(), side, icon, metadata);
                break;
            }
            case 4: {
                aboolean[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                aboolean[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                aboolean[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                aboolean[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                if (!cp2.innerSeams) break;
                cj blockpos2 = blockPos.e();
                aboolean[0] = aboolean[0] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos2.c(), side, icon, metadata);
                aboolean[1] = aboolean[1] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos2.d(), side, icon, metadata);
                aboolean[2] = aboolean[2] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos2.b(), side, icon, metadata);
                aboolean[3] = aboolean[3] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos2.a(), side, icon, metadata);
                break;
            }
            case 5: {
                aboolean[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                aboolean[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                aboolean[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                aboolean[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                if (cp2.innerSeams) {
                    cj blockpos = blockPos.f();
                    aboolean[0] = aboolean[0] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos.d(), side, icon, metadata);
                    aboolean[1] = aboolean[1] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos.c(), side, icon, metadata);
                    aboolean[2] = aboolean[2] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos.b(), side, icon, metadata);
                    boolean bl3 = aboolean[3] = aboolean[3] && !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos.a(), side, icon, metadata);
                }
                if (vertAxis != 2) break;
                ConnectedTextures.switchValues(0, 1, aboolean);
                ConnectedTextures.switchValues(2, 3, aboolean);
            }
        }
        int i2 = 0;
        if (aboolean[0] & !aboolean[1] & !aboolean[2] & !aboolean[3]) {
            i2 = 3;
        } else if (!aboolean[0] & aboolean[1] & !aboolean[2] & !aboolean[3]) {
            i2 = 1;
        } else if (!aboolean[0] & !aboolean[1] & aboolean[2] & !aboolean[3]) {
            i2 = 12;
        } else if (!aboolean[0] & !aboolean[1] & !aboolean[2] & aboolean[3]) {
            i2 = 36;
        } else if (aboolean[0] & aboolean[1] & !aboolean[2] & !aboolean[3]) {
            i2 = 2;
        } else if (!aboolean[0] & !aboolean[1] & aboolean[2] & aboolean[3]) {
            i2 = 24;
        } else if (aboolean[0] & !aboolean[1] & aboolean[2] & !aboolean[3]) {
            i2 = 15;
        } else if (aboolean[0] & !aboolean[1] & !aboolean[2] & aboolean[3]) {
            i2 = 39;
        } else if (!aboolean[0] & aboolean[1] & aboolean[2] & !aboolean[3]) {
            i2 = 13;
        } else if (!aboolean[0] & aboolean[1] & !aboolean[2] & aboolean[3]) {
            i2 = 37;
        } else if (!aboolean[0] & aboolean[1] & aboolean[2] & aboolean[3]) {
            i2 = 25;
        } else if (aboolean[0] & !aboolean[1] & aboolean[2] & aboolean[3]) {
            i2 = 27;
        } else if (aboolean[0] & aboolean[1] & !aboolean[2] & aboolean[3]) {
            i2 = 38;
        } else if (aboolean[0] & aboolean[1] & aboolean[2] & !aboolean[3]) {
            i2 = 14;
        } else if (aboolean[0] & aboolean[1] & aboolean[2] & aboolean[3]) {
            i2 = 26;
        }
        if (i2 == 0) {
            return i2;
        }
        if (!Config.isConnectedTexturesFancy()) {
            return i2;
        }
        switch (side) {
            case 0: {
                aboolean[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f().c(), side, icon, metadata);
                aboolean[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e().c(), side, icon, metadata);
                aboolean[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f().d(), side, icon, metadata);
                boolean bl4 = aboolean[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e().d(), side, icon, metadata);
                if (!cp2.innerSeams) break;
                cj blockpos11 = blockPos.b();
                aboolean[0] = aboolean[0] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos11.f().c(), side, icon, metadata);
                aboolean[1] = aboolean[1] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos11.e().c(), side, icon, metadata);
                aboolean[2] = aboolean[2] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos11.f().d(), side, icon, metadata);
                aboolean[3] = aboolean[3] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos11.e().d(), side, icon, metadata);
                break;
            }
            case 1: {
                aboolean[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f().d(), side, icon, metadata);
                aboolean[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e().d(), side, icon, metadata);
                aboolean[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f().c(), side, icon, metadata);
                boolean bl5 = aboolean[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e().c(), side, icon, metadata);
                if (!cp2.innerSeams) break;
                cj blockpos10 = blockPos.a();
                aboolean[0] = aboolean[0] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos10.f().d(), side, icon, metadata);
                aboolean[1] = aboolean[1] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos10.e().d(), side, icon, metadata);
                aboolean[2] = aboolean[2] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos10.f().c(), side, icon, metadata);
                aboolean[3] = aboolean[3] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos10.e().c(), side, icon, metadata);
                break;
            }
            case 2: {
                aboolean[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e().b(), side, icon, metadata);
                aboolean[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f().b(), side, icon, metadata);
                aboolean[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e().a(), side, icon, metadata);
                boolean bl6 = aboolean[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f().a(), side, icon, metadata);
                if (cp2.innerSeams) {
                    cj blockpos9 = blockPos.c();
                    aboolean[0] = aboolean[0] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos9.e().b(), side, icon, metadata);
                    aboolean[1] = aboolean[1] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos9.f().b(), side, icon, metadata);
                    aboolean[2] = aboolean[2] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos9.e().a(), side, icon, metadata);
                    boolean bl7 = aboolean[3] = aboolean[3] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos9.f().a(), side, icon, metadata);
                }
                if (vertAxis != 1) break;
                ConnectedTextures.switchValues(0, 3, aboolean);
                ConnectedTextures.switchValues(1, 2, aboolean);
                break;
            }
            case 3: {
                aboolean[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f().b(), side, icon, metadata);
                aboolean[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e().b(), side, icon, metadata);
                aboolean[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f().a(), side, icon, metadata);
                boolean bl8 = aboolean[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e().a(), side, icon, metadata);
                if (!cp2.innerSeams) break;
                cj blockpos8 = blockPos.d();
                aboolean[0] = aboolean[0] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos8.f().b(), side, icon, metadata);
                aboolean[1] = aboolean[1] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos8.e().b(), side, icon, metadata);
                aboolean[2] = aboolean[2] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos8.f().a(), side, icon, metadata);
                aboolean[3] = aboolean[3] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos8.e().a(), side, icon, metadata);
                break;
            }
            case 4: {
                aboolean[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b().d(), side, icon, metadata);
                aboolean[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b().c(), side, icon, metadata);
                aboolean[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a().d(), side, icon, metadata);
                boolean bl9 = aboolean[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a().c(), side, icon, metadata);
                if (!cp2.innerSeams) break;
                cj blockpos7 = blockPos.e();
                aboolean[0] = aboolean[0] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos7.b().d(), side, icon, metadata);
                aboolean[1] = aboolean[1] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos7.b().c(), side, icon, metadata);
                aboolean[2] = aboolean[2] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos7.a().d(), side, icon, metadata);
                aboolean[3] = aboolean[3] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos7.a().c(), side, icon, metadata);
                break;
            }
            case 5: {
                aboolean[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b().c(), side, icon, metadata);
                aboolean[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b().d(), side, icon, metadata);
                aboolean[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a().c(), side, icon, metadata);
                boolean bl10 = aboolean[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a().d(), side, icon, metadata);
                if (cp2.innerSeams) {
                    cj blockpos1 = blockPos.f();
                    aboolean[0] = aboolean[0] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos1.b().c(), side, icon, metadata);
                    aboolean[1] = aboolean[1] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos1.b().d(), side, icon, metadata);
                    aboolean[2] = aboolean[2] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos1.a().c(), side, icon, metadata);
                    boolean bl11 = aboolean[3] = aboolean[3] || ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockpos1.a().d(), side, icon, metadata);
                }
                if (vertAxis != 2) break;
                ConnectedTextures.switchValues(0, 3, aboolean);
                ConnectedTextures.switchValues(1, 2, aboolean);
            }
        }
        if (i2 == 13 && aboolean[0]) {
            i2 = 4;
        } else if (i2 == 15 && aboolean[1]) {
            i2 = 5;
        } else if (i2 == 37 && aboolean[2]) {
            i2 = 16;
        } else if (i2 == 39 && aboolean[3]) {
            i2 = 17;
        } else if (i2 == 14 && aboolean[0] && aboolean[1]) {
            i2 = 7;
        } else if (i2 == 25 && aboolean[0] && aboolean[2]) {
            i2 = 6;
        } else if (i2 == 27 && aboolean[3] && aboolean[1]) {
            i2 = 19;
        } else if (i2 == 38 && aboolean[3] && aboolean[2]) {
            i2 = 18;
        } else if (i2 == 14 && !aboolean[0] && aboolean[1]) {
            i2 = 31;
        } else if (i2 == 25 && aboolean[0] && !aboolean[2]) {
            i2 = 30;
        } else if (i2 == 27 && !aboolean[3] && aboolean[1]) {
            i2 = 41;
        } else if (i2 == 38 && aboolean[3] && !aboolean[2]) {
            i2 = 40;
        } else if (i2 == 14 && aboolean[0] && !aboolean[1]) {
            i2 = 29;
        } else if (i2 == 25 && !aboolean[0] && aboolean[2]) {
            i2 = 28;
        } else if (i2 == 27 && aboolean[3] && !aboolean[1]) {
            i2 = 43;
        } else if (i2 == 38 && !aboolean[3] && aboolean[2]) {
            i2 = 42;
        } else if (i2 == 26 && aboolean[0] && aboolean[1] && aboolean[2] && aboolean[3]) {
            i2 = 46;
        } else if (i2 == 26 && !aboolean[0] && aboolean[1] && aboolean[2] && aboolean[3]) {
            i2 = 9;
        } else if (i2 == 26 && aboolean[0] && !aboolean[1] && aboolean[2] && aboolean[3]) {
            i2 = 21;
        } else if (i2 == 26 && aboolean[0] && aboolean[1] && !aboolean[2] && aboolean[3]) {
            i2 = 8;
        } else if (i2 == 26 && aboolean[0] && aboolean[1] && aboolean[2] && !aboolean[3]) {
            i2 = 20;
        } else if (i2 == 26 && aboolean[0] && aboolean[1] && !aboolean[2] && !aboolean[3]) {
            i2 = 11;
        } else if (i2 == 26 && !aboolean[0] && !aboolean[1] && aboolean[2] && aboolean[3]) {
            i2 = 22;
        } else if (i2 == 26 && !aboolean[0] && aboolean[1] && !aboolean[2] && aboolean[3]) {
            i2 = 23;
        } else if (i2 == 26 && aboolean[0] && !aboolean[1] && aboolean[2] && !aboolean[3]) {
            i2 = 10;
        } else if (i2 == 26 && aboolean[0] && !aboolean[1] && !aboolean[2] && aboolean[3]) {
            i2 = 34;
        } else if (i2 == 26 && !aboolean[0] && aboolean[1] && aboolean[2] && !aboolean[3]) {
            i2 = 35;
        } else if (i2 == 26 && aboolean[0] && !aboolean[1] && !aboolean[2] && !aboolean[3]) {
            i2 = 32;
        } else if (i2 == 26 && !aboolean[0] && aboolean[1] && !aboolean[2] && !aboolean[3]) {
            i2 = 33;
        } else if (i2 == 26 && !aboolean[0] && !aboolean[1] && aboolean[2] && !aboolean[3]) {
            i2 = 44;
        } else if (i2 == 26 && !aboolean[0] && !aboolean[1] && !aboolean[2] && aboolean[3]) {
            i2 = 45;
        }
        return i2;
    }

    private static void switchValues(int ix1, int ix2, boolean[] arr2) {
        boolean flag = arr2[ix1];
        arr2[ix1] = arr2[ix2];
        arr2[ix2] = flag;
    }

    private static boolean isNeighbourOverlay(ConnectedProperties cp2, adq iblockaccess, alz blockState, cj blockPos, int side, bmi icon, int metadata) {
        bmi textureatlassprite;
        aly blockstatebase;
        alz iblockstate = iblockaccess.p(blockPos);
        if (!ConnectedTextures.isFullCubeModel(iblockstate)) {
            return false;
        }
        if (cp2.connectBlocks != null && !Matches.block((blockstatebase = (aly)iblockstate).getBlockId(), blockstatebase.getMetadata(), cp2.connectBlocks)) {
            return false;
        }
        if (cp2.connectTileIcons != null && !Config.isSameOne(textureatlassprite = ConnectedTextures.getNeighbourIcon(iblockaccess, blockState, blockPos, iblockstate, side), cp2.connectTileIcons)) {
            return false;
        }
        alz iblockstate1 = iblockaccess.p(blockPos.a(ConnectedTextures.getFacing(side)));
        return iblockstate1.c().c() ? false : (side == 1 && iblockstate1.c() == afi.aH ? false : !ConnectedTextures.isNeighbour(cp2, iblockaccess, blockState, blockPos, iblockstate, side, icon, metadata));
    }

    private static boolean isFullCubeModel(alz state) {
        if (state.c().d()) {
            return true;
        }
        afh block = state.c();
        return block instanceof ahc ? true : block instanceof ajs;
    }

    private static boolean isNeighbourMatching(ConnectedProperties cp2, adq iblockaccess, alz blockState, cj blockPos, int side, bmi icon, int metadata) {
        bmi textureatlassprite;
        aly blockstatebase;
        alz iblockstate = iblockaccess.p(blockPos);
        if (iblockstate == AIR_DEFAULT_STATE) {
            return false;
        }
        if (cp2.matchBlocks != null && iblockstate instanceof aly && !cp2.matchesBlock((blockstatebase = (aly)iblockstate).getBlockId(), blockstatebase.getMetadata())) {
            return false;
        }
        if (cp2.matchTileIcons != null && (textureatlassprite = ConnectedTextures.getNeighbourIcon(iblockaccess, blockState, blockPos, iblockstate, side)) != icon) {
            return false;
        }
        alz iblockstate1 = iblockaccess.p(blockPos.a(ConnectedTextures.getFacing(side)));
        return iblockstate1.c().c() ? false : side != 1 || iblockstate1.c() != afi.aH;
    }

    private static boolean isNeighbour(ConnectedProperties cp2, adq iblockaccess, alz blockState, cj blockPos, int side, bmi icon, int metadata) {
        alz iblockstate = iblockaccess.p(blockPos);
        return ConnectedTextures.isNeighbour(cp2, iblockaccess, blockState, blockPos, iblockstate, side, icon, metadata);
    }

    private static boolean isNeighbour(ConnectedProperties cp2, adq iblockaccess, alz blockState, cj blockPos, alz neighbourState, int side, bmi icon, int metadata) {
        if (blockState == neighbourState) {
            return true;
        }
        if (cp2.connect == 2) {
            if (neighbourState == null) {
                return false;
            }
            if (neighbourState == AIR_DEFAULT_STATE) {
                return false;
            }
            bmi textureatlassprite = ConnectedTextures.getNeighbourIcon(iblockaccess, blockState, blockPos, neighbourState, side);
            return textureatlassprite == icon;
        }
        if (cp2.connect == 3) {
            return neighbourState == null ? false : (neighbourState == AIR_DEFAULT_STATE ? false : neighbourState.c().t() == blockState.c().t());
        }
        if (!(neighbourState instanceof aly)) {
            return false;
        }
        aly blockstatebase = (aly)neighbourState;
        afh block = blockstatebase.c();
        int i2 = blockstatebase.getMetadata();
        return block == blockState.c() && i2 == metadata;
    }

    private static bmi getNeighbourIcon(adq iblockaccess, alz blockState, cj blockPos, alz neighbourState, int side) {
        cq enumfacing;
        List list;
        neighbourState = neighbourState.c().a(neighbourState, iblockaccess, blockPos);
        boq ibakedmodel = ave.A().ae().a().b(neighbourState);
        if (ibakedmodel == null) {
            return null;
        }
        if (Reflector.ForgeBlock_getExtendedState.exists()) {
            neighbourState = (alz)Reflector.call(neighbourState.c(), Reflector.ForgeBlock_getExtendedState, neighbourState, iblockaccess, blockPos);
        }
        if ((list = ibakedmodel.a(enumfacing = ConnectedTextures.getFacing(side))) == null) {
            return null;
        }
        if (Config.isBetterGrass()) {
            list = BetterGrass.getFaceQuads(iblockaccess, neighbourState, blockPos, enumfacing, list);
        }
        if (list.size() > 0) {
            bgg bakedquad1 = list.get(0);
            return bakedquad1.getSprite();
        }
        List<bgg> list1 = ibakedmodel.a();
        if (list1 == null) {
            return null;
        }
        for (int i2 = 0; i2 < list1.size(); ++i2) {
            bgg bakedquad = list1.get(i2);
            if (bakedquad.d() != enumfacing) continue;
            return bakedquad.getSprite();
        }
        return null;
    }

    private static bmi getConnectedTextureHorizontal(ConnectedProperties cp2, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bmi icon, int metadata) {
        boolean flag = false;
        boolean flag1 = false;
        block0 : switch (vertAxis) {
            case 0: {
                switch (side) {
                    case 0: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 1: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 2: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        break;
                    }
                    case 3: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 4: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        break;
                    }
                    case 5: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    }
                }
                break;
            }
            case 1: {
                switch (side) {
                    case 0: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        break;
                    }
                    case 1: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 2: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 3: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 4: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                        break;
                    }
                    case 5: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    }
                }
                break;
            }
            case 2: {
                switch (side) {
                    case 0: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        break block0;
                    }
                    case 1: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        break block0;
                    }
                    case 2: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                        break block0;
                    }
                    case 3: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        break block0;
                    }
                    case 4: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        break block0;
                    }
                    case 5: {
                        flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                    }
                }
            }
        }
        int i2 = 3;
        i2 = flag ? (flag1 ? 1 : 2) : (flag1 ? 0 : 3);
        return cp2.tileIcons[i2];
    }

    private static bmi getConnectedTextureVertical(ConnectedProperties cp2, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bmi icon, int metadata) {
        boolean flag = false;
        boolean flag1 = false;
        switch (vertAxis) {
            case 0: {
                if (side == 1) {
                    flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                    flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    break;
                }
                if (side == 0) {
                    flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                    break;
                }
                flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                break;
            }
            case 1: {
                if (side == 3) {
                    flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                    break;
                }
                if (side == 2) {
                    flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                    flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    break;
                }
                flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                break;
            }
            case 2: {
                if (side == 5) {
                    flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                    flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    break;
                }
                if (side == 4) {
                    flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                    break;
                }
                flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                flag1 = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f(), side, icon, metadata);
            }
        }
        int i2 = 3;
        i2 = flag ? (flag1 ? 1 : 2) : (flag1 ? 0 : 3);
        return cp2.tileIcons[i2];
    }

    private static bmi getConnectedTextureHorizontalVertical(ConnectedProperties cp2, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bmi icon, int metadata) {
        bmi[] atextureatlassprite = cp2.tileIcons;
        bmi textureatlassprite = ConnectedTextures.getConnectedTextureHorizontal(cp2, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (textureatlassprite != null && textureatlassprite != icon && textureatlassprite != atextureatlassprite[3]) {
            return textureatlassprite;
        }
        bmi textureatlassprite1 = ConnectedTextures.getConnectedTextureVertical(cp2, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        return textureatlassprite1 == atextureatlassprite[0] ? atextureatlassprite[4] : (textureatlassprite1 == atextureatlassprite[1] ? atextureatlassprite[5] : (textureatlassprite1 == atextureatlassprite[2] ? atextureatlassprite[6] : textureatlassprite1));
    }

    private static bmi getConnectedTextureVerticalHorizontal(ConnectedProperties cp2, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bmi icon, int metadata) {
        bmi[] atextureatlassprite = cp2.tileIcons;
        bmi textureatlassprite = ConnectedTextures.getConnectedTextureVertical(cp2, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (textureatlassprite != null && textureatlassprite != icon && textureatlassprite != atextureatlassprite[3]) {
            return textureatlassprite;
        }
        bmi textureatlassprite1 = ConnectedTextures.getConnectedTextureHorizontal(cp2, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        return textureatlassprite1 == atextureatlassprite[0] ? atextureatlassprite[4] : (textureatlassprite1 == atextureatlassprite[1] ? atextureatlassprite[5] : (textureatlassprite1 == atextureatlassprite[2] ? atextureatlassprite[6] : textureatlassprite1));
    }

    private static bmi getConnectedTextureTop(ConnectedProperties cp2, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bmi icon, int metadata) {
        boolean flag = false;
        switch (vertAxis) {
            case 0: {
                if (side == 1 || side == 0) {
                    return null;
                }
                flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                break;
            }
            case 1: {
                if (side == 3 || side == 2) {
                    return null;
                }
                flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                break;
            }
            case 2: {
                if (side == 5 || side == 4) {
                    return null;
                }
                flag = ConnectedTextures.isNeighbour(cp2, blockAccess, blockState, blockPos.f(), side, icon, metadata);
            }
        }
        if (flag) {
            return cp2.tileIcons[0];
        }
        return null;
    }

    public static void updateIcons(bmh textureMap) {
        blockProperties = null;
        tileProperties = null;
        spriteQuadMaps = null;
        spriteQuadCompactMaps = null;
        if (Config.isConnectedTextures()) {
            bnk[] airesourcepack = Config.getResourcePacks();
            for (int i2 = airesourcepack.length - 1; i2 >= 0; --i2) {
                bnk iresourcepack = airesourcepack[i2];
                ConnectedTextures.updateIcons(textureMap, iresourcepack);
            }
            ConnectedTextures.updateIcons(textureMap, Config.getDefaultResourcePack());
            jy resourcelocation = new jy("mcpatcher/ctm/default/empty");
            emptySprite = textureMap.a(resourcelocation);
            spriteQuadMaps = new Map[textureMap.getCountRegisteredSprites() + 1];
            spriteQuadFullMaps = new Map[textureMap.getCountRegisteredSprites() + 1];
            spriteQuadCompactMaps = new Map[textureMap.getCountRegisteredSprites() + 1][];
            if (blockProperties.length <= 0) {
                blockProperties = null;
            }
            if (tileProperties.length <= 0) {
                tileProperties = null;
            }
        }
    }

    private static void updateIconEmpty(bmh textureMap) {
    }

    public static void updateIcons(bmh textureMap, bnk rp2) {
        String[] astring = ResUtils.collectFiles(rp2, "mcpatcher/ctm/", ".properties", ConnectedTextures.getDefaultCtmPaths());
        Arrays.sort(astring);
        List list = ConnectedTextures.makePropertyList(tileProperties);
        List list1 = ConnectedTextures.makePropertyList(blockProperties);
        for (int i2 = 0; i2 < astring.length; ++i2) {
            String s2 = astring[i2];
            Config.dbg("ConnectedTextures: " + s2);
            try {
                jy resourcelocation = new jy(s2);
                InputStream inputstream = rp2.a(resourcelocation);
                if (inputstream == null) {
                    Config.warn("ConnectedTextures file not found: " + s2);
                    continue;
                }
                PropertiesOrdered properties = new PropertiesOrdered();
                properties.load(inputstream);
                inputstream.close();
                ConnectedProperties connectedproperties = new ConnectedProperties(properties, s2);
                if (!connectedproperties.isValid(s2)) continue;
                connectedproperties.updateIcons(textureMap);
                ConnectedTextures.addToTileList(connectedproperties, list);
                ConnectedTextures.addToBlockList(connectedproperties, list1);
                continue;
            }
            catch (FileNotFoundException var11) {
                Config.warn("ConnectedTextures file not found: " + s2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        blockProperties = ConnectedTextures.propertyListToArray(list1);
        tileProperties = ConnectedTextures.propertyListToArray(list);
        multipass = ConnectedTextures.detectMultipass();
        Config.dbg("Multipass connected textures: " + multipass);
    }

    private static List makePropertyList(ConnectedProperties[][] propsArr) {
        ArrayList<ArrayList<ConnectedProperties>> list = new ArrayList<ArrayList<ConnectedProperties>>();
        if (propsArr != null) {
            for (int i2 = 0; i2 < propsArr.length; ++i2) {
                ConnectedProperties[] aconnectedproperties = propsArr[i2];
                ArrayList<ConnectedProperties> list1 = null;
                if (aconnectedproperties != null) {
                    list1 = new ArrayList<ConnectedProperties>(Arrays.asList(aconnectedproperties));
                }
                list.add(list1);
            }
        }
        return list;
    }

    private static boolean detectMultipass() {
        ArrayList<ConnectedProperties> list = new ArrayList<ConnectedProperties>();
        for (int i2 = 0; i2 < tileProperties.length; ++i2) {
            ConnectedProperties[] aconnectedproperties = tileProperties[i2];
            if (aconnectedproperties == null) continue;
            list.addAll(Arrays.asList(aconnectedproperties));
        }
        for (int k2 = 0; k2 < blockProperties.length; ++k2) {
            ConnectedProperties[] aconnectedproperties2 = blockProperties[k2];
            if (aconnectedproperties2 == null) continue;
            list.addAll(Arrays.asList(aconnectedproperties2));
        }
        ConnectedProperties[] aconnectedproperties1 = list.toArray(new ConnectedProperties[list.size()]);
        HashSet<bmi> set1 = new HashSet<bmi>();
        HashSet<bmi> set = new HashSet<bmi>();
        for (int j2 = 0; j2 < aconnectedproperties1.length; ++j2) {
            ConnectedProperties connectedproperties = aconnectedproperties1[j2];
            if (connectedproperties.matchTileIcons != null) {
                set1.addAll(Arrays.asList(connectedproperties.matchTileIcons));
            }
            if (connectedproperties.tileIcons == null) continue;
            set.addAll(Arrays.asList(connectedproperties.tileIcons));
        }
        set1.retainAll(set);
        return !set1.isEmpty();
    }

    private static ConnectedProperties[][] propertyListToArray(List<List<ConnectedProperties>> list) {
        ConnectedProperties[][] aconnectedproperties = new ConnectedProperties[list.size()][];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List<ConnectedProperties> list2 = list.get(i2);
            if (list2 == null) continue;
            ConnectedProperties[] aconnectedproperties1 = list2.toArray(new ConnectedProperties[list2.size()]);
            aconnectedproperties[i2] = aconnectedproperties1;
        }
        return aconnectedproperties;
    }

    private static void addToTileList(ConnectedProperties cp2, List tileList) {
        if (cp2.matchTileIcons != null) {
            for (int i2 = 0; i2 < cp2.matchTileIcons.length; ++i2) {
                bmi textureatlassprite = cp2.matchTileIcons[i2];
                if (!(textureatlassprite instanceof bmi)) {
                    Config.warn("TextureAtlasSprite is not TextureAtlasSprite: " + textureatlassprite + ", name: " + textureatlassprite.i());
                    continue;
                }
                int j2 = textureatlassprite.getIndexInMap();
                if (j2 < 0) {
                    Config.warn("Invalid tile ID: " + j2 + ", icon: " + textureatlassprite.i());
                    continue;
                }
                ConnectedTextures.addToList(cp2, tileList, j2);
            }
        }
    }

    private static void addToBlockList(ConnectedProperties cp2, List blockList) {
        if (cp2.matchBlocks != null) {
            for (int i2 = 0; i2 < cp2.matchBlocks.length; ++i2) {
                int j2 = cp2.matchBlocks[i2].getBlockId();
                if (j2 < 0) {
                    Config.warn("Invalid block ID: " + j2);
                    continue;
                }
                ConnectedTextures.addToList(cp2, blockList, j2);
            }
        }
    }

    private static void addToList(ConnectedProperties cp2, List list, int id2) {
        while (id2 >= list.size()) {
            list.add(null);
        }
        ArrayList<ConnectedProperties> list2 = (ArrayList<ConnectedProperties>)list.get(id2);
        if (list2 == null) {
            list2 = new ArrayList<ConnectedProperties>();
            list.set(id2, list2);
        }
        list2.add(cp2);
    }

    private static String[] getDefaultCtmPaths() {
        ArrayList<String> list = new ArrayList<String>();
        String s2 = "mcpatcher/ctm/default/";
        if (Config.isFromDefaultResourcePack(new jy("textures/blocks/glass.png"))) {
            list.add(s2 + "glass.properties");
            list.add(s2 + "glasspane.properties");
        }
        if (Config.isFromDefaultResourcePack(new jy("textures/blocks/bookshelf.png"))) {
            list.add(s2 + "bookshelf.properties");
        }
        if (Config.isFromDefaultResourcePack(new jy("textures/blocks/sandstone_normal.png"))) {
            list.add(s2 + "sandstone.properties");
        }
        String[] astring = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};
        for (int i2 = 0; i2 < astring.length; ++i2) {
            String s1 = astring[i2];
            if (!Config.isFromDefaultResourcePack(new jy("textures/blocks/glass_" + s1 + ".png"))) continue;
            list.add(s2 + i2 + "_glass_" + s1 + "/glass_" + s1 + ".properties");
            list.add(s2 + i2 + "_glass_" + s1 + "/glass_pane_" + s1 + ".properties");
        }
        String[] astring1 = list.toArray(new String[list.size()]);
        return astring1;
    }
}

