/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import net.optifine.CustomPanoramaProperties;
import net.optifine.util.MathUtils;
import net.optifine.util.PropertiesOrdered;

public class CustomPanorama {
    private static CustomPanoramaProperties customPanoramaProperties = null;
    private static final Random random = new Random();

    public static CustomPanoramaProperties getCustomPanoramaProperties() {
        return customPanoramaProperties;
    }

    public static void update() {
        customPanoramaProperties = null;
        String[] astring = CustomPanorama.getPanoramaFolders();
        if (astring.length > 1) {
            CustomPanoramaProperties custompanoramaproperties;
            Properties[] aproperties = CustomPanorama.getPanoramaProperties(astring);
            int[] aint = CustomPanorama.getWeights(aproperties);
            int i2 = CustomPanorama.getRandomIndex(aint);
            String s2 = astring[i2];
            Properties properties = aproperties[i2];
            if (properties == null) {
                properties = aproperties[0];
            }
            if (properties == null) {
                properties = new PropertiesOrdered();
            }
            customPanoramaProperties = custompanoramaproperties = new CustomPanoramaProperties(s2, properties);
        }
    }

    private static String[] getPanoramaFolders() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("textures/gui/title/background");
        for (int i2 = 0; i2 < 100; ++i2) {
            String s2 = "optifine/gui/background" + i2;
            String s1 = s2 + "/panorama_0.png";
            jy resourcelocation = new jy(s1);
            if (!Config.hasResource(resourcelocation)) continue;
            list.add(s2);
        }
        String[] astring = list.toArray(new String[list.size()]);
        return astring;
    }

    private static Properties[] getPanoramaProperties(String[] folders) {
        Properties[] aproperties = new Properties[folders.length];
        for (int i2 = 0; i2 < folders.length; ++i2) {
            String s2 = folders[i2];
            if (i2 == 0) {
                s2 = "optifine/gui";
            } else {
                Config.dbg("CustomPanorama: " + s2);
            }
            jy resourcelocation = new jy(s2 + "/background.properties");
            try {
                InputStream inputstream = Config.getResourceStream(resourcelocation);
                if (inputstream == null) continue;
                PropertiesOrdered properties = new PropertiesOrdered();
                properties.load(inputstream);
                Config.dbg("CustomPanorama: " + resourcelocation.a());
                aproperties[i2] = properties;
                inputstream.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return aproperties;
    }

    private static int[] getWeights(Properties[] properties) {
        int[] aint = new int[properties.length];
        for (int i2 = 0; i2 < aint.length; ++i2) {
            Properties properties2 = properties[i2];
            if (properties2 == null) {
                properties2 = properties[0];
            }
            if (properties2 == null) {
                aint[i2] = 1;
                continue;
            }
            String s2 = properties2.getProperty("weight", null);
            aint[i2] = Config.parseInt(s2, 1);
        }
        return aint;
    }

    private static int getRandomIndex(int[] weights) {
        int i2 = MathUtils.getSum(weights);
        int j2 = random.nextInt(i2);
        int k2 = 0;
        for (int l2 = 0; l2 < weights.length; ++l2) {
            if ((k2 += weights[l2]) <= j2) continue;
            return l2;
        }
        return weights.length - 1;
    }
}

