/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.DynamicLights;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicLight {
    private pk entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private boolean underwater = false;
    private long timeCheckMs = 0L;
    private Set<cj> setLitChunkPos = new HashSet<cj>();
    private cj.a blockPosMutable = new cj.a();

    public DynamicLight(pk entity) {
        this.entity = entity;
        this.offsetY = entity.aS();
    }

    public void update(bfr renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long i2 = System.currentTimeMillis();
            if (i2 < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = i2;
        }
        double d6 = this.entity.s - 0.5;
        double d0 = this.entity.t - 0.5 + this.offsetY;
        double d1 = this.entity.u - 0.5;
        int j2 = DynamicLights.getLightLevel(this.entity);
        double d2 = d6 - this.lastPosX;
        double d3 = d0 - this.lastPosY;
        double d4 = d1 - this.lastPosZ;
        double d5 = 0.1;
        if (Math.abs(d2) > d5 || Math.abs(d3) > d5 || Math.abs(d4) > d5 || this.lastLightLevel != j2) {
            this.lastPosX = d6;
            this.lastPosY = d0;
            this.lastPosZ = d1;
            this.lastLightLevel = j2;
            this.underwater = false;
            bdb world = renderGlobal.getWorld();
            if (world != null) {
                this.blockPosMutable.c(ns.c(d6), ns.c(d0), ns.c(d1));
                alz iblockstate = world.p(this.blockPosMutable);
                afh block = iblockstate.c();
                this.underwater = block == afi.j;
            }
            HashSet<cj> set = new HashSet<cj>();
            if (j2 > 0) {
                cq enumfacing2 = (ns.c(d6) & 0xF) >= 8 ? cq.f : cq.e;
                cq enumfacing = (ns.c(d0) & 0xF) >= 8 ? cq.b : cq.a;
                cq enumfacing1 = (ns.c(d1) & 0xF) >= 8 ? cq.d : cq.c;
                cj blockpos = new cj(d6, d0, d1);
                bht renderchunk = renderGlobal.getRenderChunk(blockpos);
                cj blockpos1 = this.getChunkPos(renderchunk, blockpos, enumfacing2);
                bht renderchunk1 = renderGlobal.getRenderChunk(blockpos1);
                cj blockpos2 = this.getChunkPos(renderchunk, blockpos, enumfacing1);
                bht renderchunk2 = renderGlobal.getRenderChunk(blockpos2);
                cj blockpos3 = this.getChunkPos(renderchunk1, blockpos1, enumfacing1);
                bht renderchunk3 = renderGlobal.getRenderChunk(blockpos3);
                cj blockpos4 = this.getChunkPos(renderchunk, blockpos, enumfacing);
                bht renderchunk4 = renderGlobal.getRenderChunk(blockpos4);
                cj blockpos5 = this.getChunkPos(renderchunk4, blockpos4, enumfacing2);
                bht renderchunk5 = renderGlobal.getRenderChunk(blockpos5);
                cj blockpos6 = this.getChunkPos(renderchunk4, blockpos4, enumfacing1);
                bht renderchunk6 = renderGlobal.getRenderChunk(blockpos6);
                cj blockpos7 = this.getChunkPos(renderchunk5, blockpos5, enumfacing1);
                bht renderchunk7 = renderGlobal.getRenderChunk(blockpos7);
                this.updateChunkLight(renderchunk, this.setLitChunkPos, set);
                this.updateChunkLight(renderchunk1, this.setLitChunkPos, set);
                this.updateChunkLight(renderchunk2, this.setLitChunkPos, set);
                this.updateChunkLight(renderchunk3, this.setLitChunkPos, set);
                this.updateChunkLight(renderchunk4, this.setLitChunkPos, set);
                this.updateChunkLight(renderchunk5, this.setLitChunkPos, set);
                this.updateChunkLight(renderchunk6, this.setLitChunkPos, set);
                this.updateChunkLight(renderchunk7, this.setLitChunkPos, set);
            }
            this.updateLitChunks(renderGlobal);
            this.setLitChunkPos = set;
        }
    }

    private cj getChunkPos(bht renderChunk, cj pos, cq facing) {
        return renderChunk != null ? renderChunk.a(facing) : pos.a(facing, 16);
    }

    private void updateChunkLight(bht renderChunk, Set<cj> setPrevPos, Set<cj> setNewPos) {
        if (renderChunk != null) {
            bhq compiledchunk = renderChunk.g();
            if (compiledchunk != null && !compiledchunk.a()) {
                renderChunk.a(true);
            }
            cj blockpos = renderChunk.j();
            if (setPrevPos != null) {
                setPrevPos.remove(blockpos);
            }
            if (setNewPos != null) {
                setNewPos.add(blockpos);
            }
        }
    }

    public void updateLitChunks(bfr renderGlobal) {
        for (cj blockpos : this.setLitChunkPos) {
            bht renderchunk = renderGlobal.getRenderChunk(blockpos);
            this.updateChunkLight(renderchunk, null, null);
        }
    }

    public pk getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public boolean isUnderwater() {
        return this.underwater;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

