/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.optifine.util.PropertiesOrdered;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmissiveTextures {
    private static String suffixEmissive = null;
    private static String suffixEmissivePng = null;
    private static boolean active = false;
    private static boolean render = false;
    private static boolean hasEmissive = false;
    private static boolean renderEmissive = false;
    private static float lightMapX;
    private static float lightMapY;
    private static final String SUFFIX_PNG = ".png";
    private static final jy LOCATION_EMPTY;

    public static boolean isActive() {
        return active;
    }

    public static String getSuffixEmissive() {
        return suffixEmissive;
    }

    public static void beginRender() {
        render = true;
        hasEmissive = false;
    }

    public static bmk getEmissiveTexture(bmk texture, Map<jy, bmk> mapTextures) {
        bmk itextureobject;
        if (!render) {
            return texture;
        }
        if (!(texture instanceof bme)) {
            return texture;
        }
        bme simpletexture = (bme)texture;
        jy resourcelocation = simpletexture.locationEmissive;
        if (!renderEmissive) {
            if (resourcelocation != null) {
                hasEmissive = true;
            }
            return texture;
        }
        if (resourcelocation == null) {
            resourcelocation = LOCATION_EMPTY;
        }
        if ((itextureobject = mapTextures.get(resourcelocation)) == null) {
            itextureobject = new bme(resourcelocation);
            bmj texturemanager = Config.getTextureManager();
            texturemanager.a(resourcelocation, itextureobject);
        }
        return itextureobject;
    }

    public static boolean hasEmissive() {
        return hasEmissive;
    }

    public static void beginRenderEmissive() {
        lightMapX = bqs.lastBrightnessX;
        lightMapY = bqs.lastBrightnessY;
        bqs.a(bqs.r, 240.0f, lightMapY);
        renderEmissive = true;
    }

    public static void endRenderEmissive() {
        renderEmissive = false;
        bqs.a(bqs.r, lightMapX, lightMapY);
    }

    public static void endRender() {
        render = false;
        hasEmissive = false;
    }

    public static void update() {
        active = false;
        suffixEmissive = null;
        suffixEmissivePng = null;
        if (Config.isEmissiveTextures()) {
            try {
                String s2 = "optifine/emissive.properties";
                jy resourcelocation = new jy(s2);
                InputStream inputstream = Config.getResourceStream(resourcelocation);
                if (inputstream == null) {
                    return;
                }
                EmissiveTextures.dbg("Loading " + s2);
                PropertiesOrdered properties = new PropertiesOrdered();
                properties.load(inputstream);
                inputstream.close();
                suffixEmissive = properties.getProperty("suffix.emissive");
                if (suffixEmissive != null) {
                    suffixEmissivePng = suffixEmissive + SUFFIX_PNG;
                }
                active = suffixEmissive != null;
            }
            catch (FileNotFoundException var4) {
                return;
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
    }

    private static void dbg(String str) {
        Config.dbg("EmissiveTextures: " + str);
    }

    private static void warn(String str) {
        Config.warn("EmissiveTextures: " + str);
    }

    public static boolean isEmissive(jy loc) {
        return suffixEmissivePng == null ? false : loc.a().endsWith(suffixEmissivePng);
    }

    public static void loadTexture(jy loc, bme tex) {
        if (loc != null && tex != null) {
            String s2;
            tex.isEmissive = false;
            tex.locationEmissive = null;
            if (suffixEmissivePng != null && (s2 = loc.a()).endsWith(SUFFIX_PNG)) {
                if (s2.endsWith(suffixEmissivePng)) {
                    tex.isEmissive = true;
                } else {
                    String s1 = s2.substring(0, s2.length() - SUFFIX_PNG.length()) + suffixEmissivePng;
                    jy resourcelocation = new jy(loc.b(), s1);
                    if (Config.hasResource(resourcelocation)) {
                        tex.locationEmissive = resourcelocation;
                    }
                }
            }
        }
    }

    static {
        LOCATION_EMPTY = new jy("mcpatcher/ctm/default/empty.png");
    }
}

