/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomEntityModels {
    private static boolean active = false;
    private static Map<Class<? extends pk>, biv<? extends pk>> originalEntityRenderMap = null;
    private static Map<Class<? extends akw>, bhd<? extends akw>> originalTileEntityRenderMap = null;

    public static void update() {
        Map<Class<? extends pk>, biv<? extends pk>> map = CustomEntityModels.getEntityRenderMap();
        Map<Class<? extends akw>, bhd<? extends akw>> map1 = CustomEntityModels.getTileEntityRenderMap();
        if (map == null) {
            Config.warn("Entity render map not found, custom entity models are DISABLED.");
        } else if (map1 == null) {
            Config.warn("Tile entity render map not found, custom entity models are DISABLED.");
        } else {
            active = false;
            map.clear();
            map1.clear();
            map.putAll(originalEntityRenderMap);
            map1.putAll(originalTileEntityRenderMap);
            if (Config.isCustomEntityModels()) {
                jy[] aresourcelocation = CustomEntityModels.getModelLocations();
                for (int i2 = 0; i2 < aresourcelocation.length; ++i2) {
                    Class oclass;
                    jy resourcelocation = aresourcelocation[i2];
                    Config.dbg("CustomEntityModel: " + resourcelocation.a());
                    IEntityRenderer ientityrenderer = CustomEntityModels.parseEntityRender(resourcelocation);
                    if (ientityrenderer == null || (oclass = ientityrenderer.getEntityClass()) == null) continue;
                    if (ientityrenderer instanceof biv) {
                        map.put(oclass, (biv)ientityrenderer);
                    } else if (ientityrenderer instanceof bhd) {
                        map1.put(oclass, (bhd)ientityrenderer);
                    } else {
                        Config.warn("Unknown renderer type: " + ientityrenderer.getClass().getName());
                    }
                    active = true;
                }
            }
        }
    }

    private static Map<Class<? extends pk>, biv<? extends pk>> getEntityRenderMap() {
        biu rendermanager = ave.A().af();
        Map<Class<? extends pk>, biv<? extends pk>> map = rendermanager.getEntityRenderMap();
        if (map == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap<Class<? extends pk>, biv<? extends pk>>(map);
        }
        return map;
    }

    private static Map<Class<? extends akw>, bhd<? extends akw>> getTileEntityRenderMap() {
        Map<Class<? extends akw>, bhd<? extends akw>> map = bhc.a.m;
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap<Class<? extends akw>, bhd<? extends akw>>(map);
        }
        return map;
    }

    private static jy[] getModelLocations() {
        String s2 = "optifine/cem/";
        String s1 = ".jem";
        ArrayList<jy> list = new ArrayList<jy>();
        String[] astring = CustomModelRegistry.getModelNames();
        for (int i2 = 0; i2 < astring.length; ++i2) {
            String s22 = astring[i2];
            String s3 = s2 + s22 + s1;
            jy resourcelocation = new jy(s3);
            if (!Config.hasResource(resourcelocation)) continue;
            list.add(resourcelocation);
        }
        jy[] aresourcelocation = list.toArray(new jy[list.size()]);
        return aresourcelocation;
    }

    private static IEntityRenderer parseEntityRender(jy location) {
        try {
            JsonObject jsonobject = CustomEntityModelParser.loadJson(location);
            IEntityRenderer ientityrenderer = CustomEntityModels.parseEntityRender(jsonobject, location.a());
            return ientityrenderer;
        }
        catch (IOException ioexception) {
            Config.error("" + ioexception.getClass().getName() + ": " + ioexception.getMessage());
            return null;
        }
        catch (JsonParseException jsonparseexception) {
            Config.error("" + ((Object)((Object)jsonparseexception)).getClass().getName() + ": " + jsonparseexception.getMessage());
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path) {
        CustomEntityRenderer customentityrenderer = CustomEntityModelParser.parseEntityRender(obj, path);
        String s2 = customentityrenderer.getName();
        ModelAdapter modeladapter = CustomModelRegistry.getModelAdapter(s2);
        CustomEntityModels.checkNull(modeladapter, "Entity not found: " + s2);
        Class oclass = modeladapter.getEntityClass();
        CustomEntityModels.checkNull(oclass, "Entity class not found: " + s2);
        IEntityRenderer ientityrenderer = CustomEntityModels.makeEntityRender(modeladapter, customentityrenderer);
        if (ientityrenderer == null) {
            return null;
        }
        ientityrenderer.setEntityClass(oclass);
        return ientityrenderer;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer) {
        bbo modelbase;
        jy resourcelocation = cer.getTextureLocation();
        CustomModelRenderer[] acustommodelrenderer = cer.getCustomModelRenderers();
        float f2 = cer.getShadowSize();
        if (f2 < 0.0f) {
            f2 = modelAdapter.getShadowSize();
        }
        if ((modelbase = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver modelresolver = new ModelResolver(modelAdapter, modelbase, acustommodelrenderer);
        if (!CustomEntityModels.modifyModel(modelAdapter, modelbase, acustommodelrenderer, modelresolver)) {
            return null;
        }
        IEntityRenderer ientityrenderer = modelAdapter.makeEntityRender(modelbase, f2);
        if (ientityrenderer == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (resourcelocation != null) {
            ientityrenderer.setLocationTextureCustom(resourcelocation);
        }
        return ientityrenderer;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, bbo model, CustomModelRenderer[] modelRenderers, ModelResolver mr2) {
        for (int i2 = 0; i2 < modelRenderers.length; ++i2) {
            CustomModelRenderer custommodelrenderer = modelRenderers[i2];
            if (CustomEntityModels.modifyModel(modelAdapter, model, custommodelrenderer, mr2)) continue;
            return false;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, bbo model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String s2 = customModelRenderer.getModelPart();
        bct modelrenderer = modelAdapter.getModelRenderer(model, s2);
        if (modelrenderer == null) {
            Config.warn("Model part not found: " + s2 + ", model: " + model);
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (modelrenderer.l != null) {
                modelrenderer.l.clear();
            }
            if (modelrenderer.spriteList != null) {
                modelrenderer.spriteList.clear();
            }
            if (modelrenderer.m != null) {
                bct[] amodelrenderer = modelAdapter.getModelRenderers(model);
                Set set = PlatformDependent.newSetFromMap(new IdentityHashMap());
                set.addAll(Arrays.asList(amodelrenderer));
                List<bct> list = modelrenderer.m;
                Iterator<bct> iterator = list.iterator();
                while (iterator.hasNext()) {
                    bct modelrenderer1 = iterator.next();
                    if (set.contains(modelrenderer1)) continue;
                    iterator.remove();
                }
            }
        }
        modelrenderer.a(customModelRenderer.getModelRenderer());
        ModelUpdater modelupdater = customModelRenderer.getModelUpdater();
        if (modelupdater != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(modelrenderer);
            if (!modelupdater.initialize(modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(modelupdater);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }
}

