/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.uniform;

import java.util.ArrayList;
import java.util.Map;
import net.optifine.expr.IExpression;
import net.optifine.expr.IExpressionCached;
import net.optifine.shaders.uniform.CustomUniform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomUniforms {
    private CustomUniform[] uniforms;
    private IExpressionCached[] expressionsCached;

    public CustomUniforms(CustomUniform[] uniforms, Map<String, IExpression> mapExpressions) {
        this.uniforms = uniforms;
        ArrayList<IExpressionCached> list = new ArrayList<IExpressionCached>();
        for (String s2 : mapExpressions.keySet()) {
            IExpression iexpression = mapExpressions.get(s2);
            if (!(iexpression instanceof IExpressionCached)) continue;
            IExpressionCached iexpressioncached = (IExpressionCached)((Object)iexpression);
            list.add(iexpressioncached);
        }
        this.expressionsCached = list.toArray(new IExpressionCached[list.size()]);
    }

    public void setProgram(int program) {
        for (int i2 = 0; i2 < this.uniforms.length; ++i2) {
            CustomUniform customuniform = this.uniforms[i2];
            customuniform.setProgram(program);
        }
    }

    public void update() {
        this.resetCache();
        for (int i2 = 0; i2 < this.uniforms.length; ++i2) {
            CustomUniform customuniform = this.uniforms[i2];
            customuniform.update();
        }
    }

    private void resetCache() {
        for (int i2 = 0; i2 < this.expressionsCached.length; ++i2) {
            IExpressionCached iexpressioncached = this.expressionsCached[i2];
            iexpressioncached.reset();
        }
    }

    public void reset() {
        for (int i2 = 0; i2 < this.uniforms.length; ++i2) {
            CustomUniform customuniform = this.uniforms[i2];
            customuniform.reset();
        }
    }
}

