/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import io.netty.util.internal.deque.ArrayDequeV6;
import java.lang.reflect.Array;

public class ArrayCache {
    private Class elementClass = null;
    private int maxCacheSize = 0;
    private final ArrayDequeV6<Object> cache = new ArrayDequeV6();

    public ArrayCache(Class elementClass, int maxCacheSize) {
        this.elementClass = elementClass;
        this.maxCacheSize = maxCacheSize;
    }

    public synchronized Object allocate(int size) {
        Object object = this.cache.pollLast();
        if (object == null || Array.getLength(object) < size) {
            object = Array.newInstance(this.elementClass, size);
        }
        return object;
    }

    public synchronized void free(Object arr2) {
        if (arr2 != null) {
            Class<?> oclass = arr2.getClass();
            if (oclass.getComponentType() != this.elementClass) {
                throw new IllegalArgumentException("Wrong component type");
            }
            if (this.cache.size() < this.maxCacheSize) {
                this.cache.add(arr2);
            }
        }
    }
}

