/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import net.optifine.util.LongSupplier;

public class NativeMemory {
    private static LongSupplier bufferAllocatedSupplier = NativeMemory.makeLongSupplier(new String[][]{{"sun.misc.SharedSecrets", "getJavaNioAccess", "getDirectBufferPool", "getMemoryUsed"}, {"jdk.internal.misc.SharedSecrets", "getJavaNioAccess", "getDirectBufferPool", "getMemoryUsed"}});
    private static LongSupplier bufferMaximumSupplier = NativeMemory.makeLongSupplier(new String[][]{{"sun.misc.VM", "maxDirectMemory"}, {"jdk.internal.misc.VM", "maxDirectMemory"}});

    public static long getBufferAllocated() {
        return bufferAllocatedSupplier == null ? -1L : bufferAllocatedSupplier.getAsLong();
    }

    public static long getBufferMaximum() {
        return bufferMaximumSupplier == null ? -1L : bufferMaximumSupplier.getAsLong();
    }

    private static LongSupplier makeLongSupplier(String[][] paths) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        for (int i2 = 0; i2 < paths.length; ++i2) {
            String[] astring = paths[i2];
            try {
                LongSupplier longsupplier = NativeMemory.makeLongSupplier(astring);
                return longsupplier;
            }
            catch (Throwable throwable) {
                list.add(throwable);
                continue;
            }
        }
        for (Throwable throwable1 : list) {
            Config.warn("" + throwable1.getClass().getName() + ": " + throwable1.getMessage());
        }
        return null;
    }

    private static LongSupplier makeLongSupplier(String[] path) throws Exception {
        if (path.length < 2) {
            return null;
        }
        Class<?> oclass = Class.forName(path[0]);
        final Method method = oclass.getMethod(path[1], new Class[0]);
        method.setAccessible(true);
        final Object object = null;
        for (int i2 = 2; i2 < path.length; ++i2) {
            String s2 = path[i2];
            Object object2 = method.invoke(object, new Object[0]);
            Method method2 = object2.getClass().getMethod(s2, new Class[0]);
            method2.setAccessible(true);
        }
        LongSupplier longsupplier = new LongSupplier(){
            private boolean disabled = false;

            public long getAsLong() {
                if (this.disabled) {
                    return -1L;
                }
                try {
                    return (Long)method.invoke(object, new Object[0]);
                }
                catch (Throwable throwable) {
                    Config.warn("" + throwable.getClass().getName() + ": " + throwable.getMessage());
                    this.disabled = true;
                    return -1L;
                }
            }
        };
        return longsupplier;
    }
}

