#import "Window.h"

@implementation Window

- (BOOL)canBecomeKeyWindow {
	return NO;
}

- (BOOL)canBecomeMainWindow {
	return NO;
}

- (BOOL)ignoresMouseEvents {
	return YES;
}

- (void)setSticky:(BOOL)flag {
	CGSConnectionID cid;
	CGSWindowID wid;
	
	wid = [self windowNumber];
	cid = _CGSDefaultConnection();
	int tags[2] = {0, 0};
	
	if (!CGSGetWindowTags(cid, wid, tags, 32)) {
		if (flag)
			tags[0] = tags[0] | 0x00000800;
		else
			tags[0] = tags[0] & ~0x00000800;
		CGSSetWindowTags(cid, wid, tags, 32);
	}
}

- (id)initWithContentRect:(NSRect)contentRect styleMask:(unsigned int)aStyle backing:(NSBackingStoreType)bufferingType defer:(BOOL)flag {
	NSWindow *result = [super initWithContentRect:NSMakeRect(-1, -1, 1, 1)
										styleMask:NSBorderlessWindowMask
										  backing:NSBackingStoreBuffered
											defer:NO];
	[result setBackgroundColor:[NSColor clearColor]];
	[result setHasShadow:NO];
//	[result setLevel:NSMainMenuWindowLevel-4];	// between exposé and dock icons
	[result setLevel:NSModalPanelWindowLevel];	// under dock
	[result setOpaque:NO];
	[self setSticky:YES];
	
	return result;
}

@end
