/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.tester;

import component.FolderInfo;
import component.SetupUI;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import main.Nickname;
import main.Oscar;
import module.rendezvous.Rendezvous;
import module.rendezvous.tester.TestUI;
import snac.TLV;
import tool.BlockEvent;
import tool.EvilEvent;
import tool.ToolStatusEvent;
import tool.ToolStatusListener;
import tool.icbm.IcbmChannel;
import tool.icbm.IcbmSubModule;
import tool.icbm.RendezvousConstants;
import tool.icbm.RendezvousEvent;
import tool.icbm.RendezvousListener;
import uiutil.ErrorMgr;
import uiutil.PropertySheet;
import uiutil.UIPack;
import util.EventBus;
import util.EventBusEvent;
import util.JUtil;

public class Tester
implements IcbmSubModule,
RendezvousConstants,
RendezvousListener,
ToolStatusListener,
UIPack,
ActionListener {
    private static final String MODULE = "RendezvousTester";
    private static final String MODULE_NAME = "rendezvous.tester";
    private static final String[] UIPACK_NAMES = new String[]{"rendezvous.tester", "icbm.rendezvous", "tool.icbm"};
    private static final String DISPLAY_NAME = "Rendezvous Tester";
    private Hashtable uis = new Hashtable();
    EventBus eventBus;
    EventBus systemBus;
    private byte[] myService = this.uuidFromString("09461342-4C7F-11D1-8222-444553540000");
    private MenuItem menuItem;
    static /* synthetic */ Class class$tool$ToolStatusEvent;
    static /* synthetic */ Class class$tool$icbm$RendezvousEvent;

    public Tester() {
        this.systemBus = EventBus.joinBus((String)EventBus.SYSTEM_BUS);
        this.systemBus.addListenerFor((EventListener)this, class$tool$ToolStatusEvent != null ? class$tool$ToolStatusEvent : (class$tool$ToolStatusEvent = Tester.class$("tool.ToolStatusEvent")));
        if (Oscar.config.getValue("debug.rendezvousTest") != null) {
            this.menuItem = new MenuItem("Rendezvous");
            this.menuItem.addActionListener(this);
            Oscar.addMenuItem((String)"People", (MenuItem)this.menuItem);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.menuItem) {
            Rendezvous.initService = "09461342-4C7F-11D1-8222-444553540000";
            Oscar.mainTool.rendezvousAction(Oscar.mainTool.getSelectedNickname());
        }
    }

    public void initiate(IcbmChannel icbmChannel, String string) {
        System.out.println("Rendezvous Tester.initiate on channel " + icbmChannel + " bus=" + string);
        this.eventBus = EventBus.joinBus((String)string);
        this.eventBus.addListenerFor((EventListener)this, class$tool$icbm$RendezvousEvent != null ? class$tool$icbm$RendezvousEvent : (class$tool$icbm$RendezvousEvent = Tester.class$("tool.icbm.RendezvousEvent")));
    }

    void sendEvil(String string, boolean bl) {
        EvilEvent evilEvent = new EvilEvent((Object)this, 1110, new Nickname(string), bl);
        this.systemBus.postEvent((EventBusEvent)evilEvent);
    }

    void block(String string) {
        BlockEvent blockEvent = new BlockEvent((Object)this, 1120, new Nickname(string));
        this.systemBus.postEvent((EventBusEvent)blockEvent);
    }

    void sendRequest(byte[] byArray, String string, String string2, String string3, String string4, int n) {
        byte[] byArray2 = this.uuidFromString(string2);
        TLV tLV = new TLV(2);
        tLV.addTlvU16(0, 1);
        tLV.addTlvU16(10000, 7);
        tLV.addTlv(2, string4);
        tLV.addTlv(3, "156.142.123.123");
        tLV.addTlvU16(5, n);
        tLV.addTlvU16(1, 2);
        tLV.addTlv(6, string3);
        tLV.addTlv(7, "http://www.aol.com");
        RendezvousEvent rendezvousEvent = new RendezvousEvent((Object)this, 1101, 2, new Nickname(string), Oscar.bosCore.getCookie(), false, tLV, byArray2, 0, byArray, 0);
        this.eventBus.postEvent((EventBusEvent)rendezvousEvent);
    }

    void sendAccept(byte[] byArray, String string, byte[] byArray2) {
        RendezvousEvent rendezvousEvent = new RendezvousEvent((Object)this, 1101, 2, new Nickname(string), null, false, null, byArray2, 0, byArray, 2);
        this.eventBus.postEvent((EventBusEvent)rendezvousEvent);
    }

    void sendCancel(byte[] byArray, String string, String string2) {
        byte[] byArray2 = this.uuidFromString(string2);
        RendezvousEvent rendezvousEvent = new RendezvousEvent((Object)this, 1101, 2, new Nickname(string), null, false, null, byArray2, 1, byArray, 1);
        this.eventBus.postEvent((EventBusEvent)rendezvousEvent);
    }

    void sendError(byte[] byArray, byte[] byArray2, String string, byte[] byArray3, int n) {
        TLV tLV = new TLV(2);
        tLV.addTlv(n, byArray2);
        RendezvousEvent rendezvousEvent = new RendezvousEvent((Object)this, 1106, 2, new Nickname(string), byArray, false, tLV, byArray3, 0, byArray2, 100);
        this.eventBus.postEvent((EventBusEvent)rendezvousEvent);
    }

    private byte[] uuidFromString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != '-') {
                stringBuffer.append(c);
            }
            ++n2;
        }
        String string2 = stringBuffer.toString();
        byte[] byArray = null;
        try {
            byArray = JUtil.bytesFromHexString((String)string2);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMgr.warn((String)MODULE, (String)("UUID caused number format exception. Id=" + string2));
        }
        return byArray;
    }

    private final boolean isMyService(byte[] byArray) {
        if (byArray == null || this.myService.length != byArray.length) {
            return false;
        }
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.myService[n2] != byArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        return null;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        return null;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }

    public void receiveMessage(RendezvousEvent rendezvousEvent) {
        if (!this.isMyService(rendezvousEvent.getRendezvousService())) {
            return;
        }
        String string = new String(rendezvousEvent.getRendezvousCookie());
        TestUI testUI = (TestUI)((Object)this.uis.get(string));
        if (testUI == null) {
            testUI = new TestUI(this, rendezvousEvent);
            this.uis.put(string, testUI);
        }
        testUI.update(rendezvousEvent);
    }

    public void sendMessage(RendezvousEvent rendezvousEvent) {
    }

    public void initiateMessage(RendezvousEvent rendezvousEvent) {
        if (!this.isMyService(rendezvousEvent.getRendezvousService())) {
            return;
        }
        String string = new String(rendezvousEvent.getRendezvousCookie());
        TestUI testUI = (TestUI)((Object)this.uis.get(string));
        if (testUI == null) {
            testUI = new TestUI(this, rendezvousEvent);
        }
        this.uis.put(string, testUI);
    }

    public void payloadError(RendezvousEvent rendezvousEvent) {
    }

    public void channelError(RendezvousEvent rendezvousEvent) {
        if (!this.isMyService(rendezvousEvent.getRendezvousService())) {
            return;
        }
        if (rendezvousEvent.getId() == 1105) {
            TestUI.displayChannelError(rendezvousEvent);
        }
    }

    public void connect(ToolStatusEvent toolStatusEvent) {
    }

    public void disconnect(ToolStatusEvent toolStatusEvent) {
    }

    public void enableUI(ToolStatusEvent toolStatusEvent) {
        if (toolStatusEvent.getToolName().equals("ICBM")) {
            Enumeration enumeration = this.uis.keys();
            while (enumeration.hasMoreElements()) {
                TestUI testUI = (TestUI)((Object)this.uis.get(enumeration.nextElement()));
                ((Component)((Object)testUI)).setEnabled(true);
            }
        }
    }

    public void disableUI(ToolStatusEvent toolStatusEvent) {
        if (toolStatusEvent.getToolName().equals("ICBM")) {
            Enumeration enumeration = this.uis.keys();
            while (enumeration.hasMoreElements()) {
                TestUI testUI = (TestUI)((Object)this.uis.get(enumeration.nextElement()));
                ((Component)((Object)testUI)).setEnabled(false);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

