/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.AdminTool;
import component.AdminUI;
import component.AdminUIListener;
import component.StatusFrame;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import main.Oscar;
import uiutil.ChoiceUI;
import uiutil.IUtil;
import uiutil.ImageLabel;
import uiutil.PasswordField;
import uiutil.TransparentPanel;

public class AdminPasswordUI
extends AdminUI
implements ActionListener,
AdminUIListener,
TextListener {
    private AdminTool admin;
    private PasswordField oldPasswordField;
    private PasswordField newPasswordField;
    private PasswordField dupPasswordField;
    private boolean dismiss = false;

    public AdminPasswordUI(AdminTool adminTool) {
        super("Password", IUtil.format("This form enables you to change your password for " + Oscar.FULL_NAME + ". You will " + "need to enter your current password once for security and " + "your new password twice for confirmation.", 60));
        this.admin = adminTool;
        TransparentPanel transparentPanel = new TransparentPanel(new GridLayout(0, 1));
        TransparentPanel transparentPanel2 = new TransparentPanel(new FlowLayout(2));
        transparentPanel.add(transparentPanel2);
        transparentPanel2.add(new ImageLabel("Current Password:"));
        this.oldPasswordField = new PasswordField(24);
        transparentPanel2.add(this.oldPasswordField);
        this.oldPasswordField.setEchoChar('*');
        this.oldPasswordField.addActionListener(this);
        this.oldPasswordField.addTextListener(this);
        transparentPanel2 = new TransparentPanel(new FlowLayout(2));
        transparentPanel.add(transparentPanel2);
        transparentPanel2.add(new ImageLabel("New Password:"));
        this.newPasswordField = new PasswordField(24);
        transparentPanel2.add(this.newPasswordField);
        this.newPasswordField.setEchoChar('*');
        this.newPasswordField.addActionListener(this);
        this.newPasswordField.addTextListener(this);
        transparentPanel2 = new TransparentPanel(new FlowLayout(2));
        transparentPanel.add(transparentPanel2);
        transparentPanel2.add(new ImageLabel("Confirm New Password:"));
        this.dupPasswordField = new PasswordField(24);
        transparentPanel2.add(this.dupPasswordField);
        this.dupPasswordField.setEchoChar('*');
        this.dupPasswordField.addActionListener(this);
        this.dupPasswordField.addTextListener(this);
        this.setContents(transparentPanel);
        this.show();
        this.admin.addAdminUIListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.oldPasswordField) {
            this.newPasswordField.requestFocus();
            return;
        }
        if (object == this.newPasswordField) {
            this.dupPasswordField.requestFocus();
            return;
        }
        if (object == this.dupPasswordField) {
            this.requestChange(true);
        }
    }

    public void setNickname(String string) {
    }

    public void setEmailAddress(String string) {
    }

    public void setRegistrationStatus(int n) {
    }

    public void error(int n, String string, String string2) {
        this.changeFailed(n, string, string2);
    }

    public void changeSuccessful(int n, Object object) {
        if (n == 1) {
            String string = this.oldPasswordField.getPassword();
            if (string != null && string.length() > 0) {
                this.oldPasswordField.setPassword((String)object);
            }
            this.setStatus(StatusFrame.STATUS_SUCCESS, "Password change successful.");
            IUtil.playSound(this.admin, "Save");
            this.setChanged(false);
            if (this.dismiss) {
                ((Component)this).setVisible(false);
                this.dispose();
            }
        }
    }

    public void changeFailed(int n, String string, String string2) {
        if (n == 1) {
            this.setStatus(StatusFrame.STATUS_FAILURE, "Error: " + string, string2);
            IUtil.playSound(this.admin, Oscar.ERROR_SOUND);
            this.dismiss = false;
            this.setChanged(false);
        }
    }

    public void removeNotify() {
        this.removeAll();
        if (this.admin != null) {
            this.admin.removeAdminUIListener(this);
            this.admin = null;
        }
        this.oldPasswordField = null;
        this.newPasswordField = null;
        this.dupPasswordField = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public void requestChange(boolean bl) {
        String string = this.oldPasswordField.getPassword();
        String string2 = this.dupPasswordField.getPassword();
        String string3 = this.newPasswordField.getPassword();
        if (string == null || string.length() == 0 || string3 == null || string3.length() == 0 || string2 == null || string2.length() == 0) {
            ChoiceUI.newChoiceUI("Change Password", "You must fill in all the password fields. Please try again.", Oscar.WARNING_SOUND);
            return;
        }
        if (!string3.equals(string2)) {
            ChoiceUI.newChoiceUI("Change Password", "The new password you provided was different from the confirmed password. Please try again.", Oscar.WARNING_SOUND);
            return;
        }
        this.setStatus(StatusFrame.STATUS_WAITING, "Contacting server to change your password...");
        this.dismiss = bl;
        this.admin.changePassword(this.oldPasswordField.getPassword(), string3);
    }

    public void textValueChanged(TextEvent textEvent) {
        this.setChanged(true);
    }
}

