/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.ChatProtoNavTool;
import component.ChatProtoNavUIListener;
import component.ChatProtoTool;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import main.ChatExchange;
import main.ChatRoom;
import main.ChatRoomDesc;
import main.ChatRoomID;
import main.Oscar;
import uiutil.ChoiceUI;
import uiutil.OFrame;
import uiutil.Spacer;

class ChatProtoGoUI
extends OFrame
implements ActionListener,
ChatProtoNavUIListener,
WindowListener {
    private static final String MODULE = "ChatProtoGoUI";
    private ChatProtoNavTool chatNavTool;
    private Tools tools;
    private TextField nameField;
    private Button goButton;
    private Vector requests;

    public ChatProtoGoUI(ChatProtoNavTool chatProtoNavTool, Tools tools, String string, int n, ChatRoom[] chatRoomArray) {
        this.chatNavTool = chatProtoNavTool;
        this.tools = tools;
        this.requests = new Vector();
        this.setTitle("Chat Proto " + string);
        ((Component)this).setBackground(Oscar.backgroundColor);
        this.setLayout(new BorderLayout());
        boolean bl = chatRoomArray != null && chatRoomArray.length > 0;
        Panel panel = new Panel();
        this.add("South", panel);
        panel.setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        panel.add("North", panel2);
        panel2.setLayout(new BorderLayout());
        panel2.add("North", new Label("Chat Room Name"));
        panel2.add("West", new Spacer());
        this.nameField = new TextField(15);
        panel2.add("Center", this.nameField);
        panel2.add("East", new Spacer());
        panel2 = new Panel();
        panel.add("South", panel2);
        this.goButton = new Button("Go Chat");
        panel2.add(this.goButton);
        this.goButton.addActionListener(this);
        this.pack();
    }

    private void shutdown() {
        this.chatNavTool.clearRequests(this.requests);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.goButton)) {
            this.goAction();
        }
    }

    public void goAction() {
        String string = this.nameField.getText();
        if (string == null || string.length() == 0) {
            ChoiceUI.newChoiceUI("Alert", "Please provide a name for the chat room.", Oscar.WARNING_SOUND);
            return;
        }
        byte[] byArray = new byte[]{106, 97, 118, 97};
        ChatRoomID chatRoomID = new ChatRoomID(1, byArray, -1);
        ChatRoomDesc chatRoomDesc = new ChatRoomDesc();
        chatRoomDesc.setName(string);
        ChatRoom chatRoom = new ChatRoom(chatRoomID, 1, chatRoomDesc, null);
        Object object = this.chatNavTool.requestRoomCreation(this, chatRoom);
        this.requests.addElement(object);
    }

    public void setChatRights(Object object, int n, ChatExchange[] chatExchangeArray) {
    }

    public void setExchangeInfo(Object object, ChatExchange chatExchange, ChatRoom[] chatRoomArray) {
    }

    public void setRoomInfo() {
    }

    public void setMoreRoomInfo() {
    }

    public void setOccupantList() {
    }

    public void setRoomSearchResults() {
    }

    public void roomCreated(Object object, ChatRoom chatRoom) {
        this.requests.removeElement(object);
        ChatProtoTool chatProtoTool = (ChatProtoTool)this.tools.get("tool.chat");
        chatProtoTool.joinRoom(chatRoom.getExchange(), chatRoom.getCookie(), chatRoom.getInstance());
        this.shutdown();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.shutdown();
    }
}

