/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.ChatProtoCreateUI;
import component.ChatProtoGoUI;
import component.ChatProtoNavTool;
import component.ChatProtoNavUIListener;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import main.ChatExchange;
import main.ChatRoom;
import main.Oscar;
import uiutil.OFrame;
import uiutil.Spacer;
import util.Log;

class ChatProtoNavUI
extends OFrame
implements ActionListener,
ChatProtoNavUIListener,
WindowListener {
    private static final String MODULE = "ChatProtoNavUI";
    private static final int STATUS_ROWS = 15;
    private static final int STATUS_COLS = 45;
    private ChatProtoNavTool chatNavTool;
    private Tools tools;
    private List rootList;
    private Choice exchangeChoice;
    private List exchangeList;
    private Button peekButton;
    private Button moreButton;
    private Button chatButton;
    private Button searchButton;
    private Button startButton;
    private Button enterButton;
    private Button schedButton;
    private Vector requests;

    public ChatProtoNavUI(ChatProtoNavTool chatProtoNavTool, Tools tools) {
        this.chatNavTool = chatProtoNavTool;
        this.tools = tools;
        this.requests = new Vector();
        this.setTitle("Chat Prototype");
        ((Component)this).setBackground(Oscar.backgroundColor);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        this.add("North", panel);
        panel.setLayout(new BorderLayout(5, 5));
        Panel panel2 = new Panel();
        panel.add("West", panel2);
        panel2.setLayout(new BorderLayout());
        panel2.add("North", new Label("   Categories"));
        panel2.add("West", new Spacer());
        this.rootList = new List(12);
        panel2.add("Center", this.rootList);
        panel2.add("South", new Spacer());
        panel2 = new Panel();
        panel.add("Center", panel2);
        panel2.setLayout(new BorderLayout());
        Panel panel3 = new Panel();
        panel2.add("North", panel3);
        panel3.setLayout(new FlowLayout(0));
        this.exchangeChoice = new Choice();
        panel3.add(this.exchangeChoice);
        this.exchangeChoice.add("Exchange Name");
        this.exchangeChoice.setEnabled(false);
        panel3.add(new Spacer());
        this.exchangeList = new List();
        panel2.add("Center", this.exchangeList);
        panel3 = new Panel();
        panel2.add("South", panel3);
        this.peekButton = new Button("Who's Chatting");
        panel3.add(this.peekButton);
        this.peekButton.setEnabled(false);
        this.moreButton = new Button("More");
        panel3.add(this.moreButton);
        this.moreButton.setEnabled(false);
        this.chatButton = new Button("Go Chat");
        panel3.add(this.chatButton);
        this.chatButton.setEnabled(false);
        panel2 = new Panel();
        panel.add("East", panel2);
        panel2.setLayout(new BorderLayout());
        panel3 = new Panel();
        panel2.add("North", panel3);
        panel3.setLayout(new GridLayout(0, 1));
        panel3.add(new Spacer());
        Panel panel4 = new Panel();
        panel3.add(panel4);
        this.searchButton = new Button("Search Exchange Chats");
        panel4.add(this.searchButton);
        this.searchButton.setEnabled(false);
        panel4 = new Panel();
        panel3.add(panel4);
        this.startButton = new Button("    Start Your Own Chat   ");
        panel4.add(this.startButton);
        this.startButton.addActionListener(this);
        panel4 = new Panel();
        panel3.add(panel4);
        this.enterButton = new Button("    Enter A Private Chat    ");
        panel4.add(this.enterButton);
        this.enterButton.addActionListener(this);
        panel4 = new Panel();
        panel3.add(panel4);
        this.schedButton = new Button("       Chats Schedule        ");
        panel4.add(this.schedButton);
        this.schedButton.setEnabled(false);
        panel2.add("Center", new Spacer());
        this.setEnabled(false);
        this.pack();
    }

    public void setEnabled(boolean bl) {
        this.exchangeChoice.setEnabled(bl);
        this.startButton.setEnabled(bl);
        this.enterButton.setEnabled(bl);
        if (bl) {
            ((Component)this).setCursor(Cursor.getDefaultCursor());
            this.updateExchangesAndRootRooms();
            return;
        }
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.startButton)) {
            this.startAction();
            return;
        }
        if (object.equals(this.enterButton)) {
            this.enterAction();
        }
    }

    private void enterAction() {
        ChatProtoGoUI chatProtoGoUI = new ChatProtoGoUI(this.chatNavTool, this.tools, "Enter Private Chat", 1, null);
        chatProtoGoUI.show();
    }

    private void startAction() {
        ChatProtoCreateUI chatProtoCreateUI = new ChatProtoCreateUI(this.chatNavTool, this.tools, null);
        chatProtoCreateUI.setEnabled(true);
        chatProtoCreateUI.show();
    }

    private void rightsAction() {
        Log.log(MODULE, Log.DEBUG, "rightsAction");
        this.chatNavTool.requestChatRights(this);
    }

    private void updateExchangesAndRootRooms() {
    }

    public void setChatRights(Object object, int n, ChatExchange[] chatExchangeArray) {
    }

    public void setExchangeInfo(Object object, ChatExchange chatExchange, ChatRoom[] chatRoomArray) {
    }

    public void setRoomInfo() {
    }

    public void setMoreRoomInfo() {
    }

    public void setOccupantList() {
    }

    public void setRoomSearchResults() {
    }

    public void roomCreated(Object object, ChatRoom chatRoom) {
        this.requests.removeElement(object);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.chatNavTool.clearRequests(this.requests);
        ((Component)this).setVisible(false);
        this.dispose();
    }
}

