/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.ChatProtoRoomUI;
import component.FolderInfo;
import component.SetupUI;
import component.Tool;
import component.Tools;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import main.ChatAPI;
import main.ChatCore;
import main.ChatServerAPI;
import main.Nickname;
import uiutil.ChoiceUI;
import uiutil.ErrorMgr;
import uiutil.PropertySheet;
import util.InputBuffer;
import util.JUtil;
import util.KeyBindings;
import util.Log;
import util.OutputBuffer;

public class ChatProtoTool
implements ActionListener,
Tool,
ChatAPI {
    private static int whisc_item_capabilities = 5;
    private static int capability_version = 1;
    private static int whisc_capability_text = 1;
    private static int whisc_item_im_text = 1;
    private static int im_text_version = 1;
    private static int intl_encode_ascii;
    private static int intl_language_english;
    private static final String MODULE = "ChatProtoTool";
    public static final String MODULE_NAME = "tool.chat";
    private static final String[] UIPACK_NAMES;
    private static final String DISPLAY_NAME = "ChatProto";
    public int MAX_EVIL;
    private static final int TEST_EXCHANGE = 1;
    private static final int TEST_INSTANCE = 0;
    private static final byte[] TEST_COOKIE;
    private ChatServerAPI chatCore;
    private Tools tools;
    private Hashtable chatUIs;
    private MenuItem menuItem;

    public ChatProtoTool(ChatCore chatCore, Tools tools) {
        Log.log(MODULE, Log.DEBUG, "registering self w/tools...");
        this.chatCore = chatCore;
        this.MAX_EVIL = 999;
        this.tools = tools;
        tools.register(this.getModuleName(), this);
        this.chatUIs = new Hashtable();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Log.log(MODULE, Log.DEBUG, "actionPerformed: People->Chat Demo chosen.");
        Object object = actionEvent.getSource();
        if (object.equals(this.menuItem)) {
            this.joinRoom(1, TEST_COOKIE, 0);
        }
    }

    public void evilRequest(Object object, String string, int n, boolean bl) {
        this.chatCore.sendEvil(object, string, n, bl);
    }

    public void joinRoom(int n, byte[] byArray, int n2) {
        this.chatCore.joinRoom(n, byArray, n2);
    }

    public void leaveRoom(Object object) {
        this.chatUIs.remove(object);
        this.chatCore.shutdown(object);
    }

    public void sendChannelMessage(Object object, int n, String string, byte[] byArray, boolean bl, boolean bl2) {
        Object object2;
        try {
            object2 = new OutputBuffer(13 + byArray.length);
            ChatProtoTool.writeAOLChannelHeader((DataOutputStream)object2, byArray);
            byArray = ((OutputBuffer)object2).bytes();
        }
        catch (IOException iOException) {
            ErrorMgr.warn(MODULE, "io exception writing AOL channel header.", iOException);
            byArray = null;
        }
        object2 = "sendChannelMessage: to ";
        object2 = string == null ? String.valueOf(object2) + "the room" : String.valueOf(object2) + string;
        object2 = String.valueOf(object2) + " (" + new String(byArray) + ") in room " + object.toString();
        Log.log(MODULE, Log.DEBUG, (String)object2);
        this.chatCore.sendMessage(object, string, n, this.getCookie(), byArray, bl, bl2);
    }

    public byte[] getCookie() {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)(Math.random() * 255.0);
            ++n;
        }
        return byArray;
    }

    public void acknowledgeEvil(Object object, int n, int n2, String string) {
        ChoiceUI.newChoiceUI("Warning Confirmation", "You Warned " + string + " with " + n + " units of Warning for a total Warning level of " + n2 + ".");
    }

    public void receiveChannelMessage(Object object, Nickname nickname, int n, byte[] byArray, byte[] byArray2, boolean bl, boolean bl2) {
        Log.log(MODULE, Log.DEBUG, "receiveChannelMessage");
        ChatProtoRoomUI chatProtoRoomUI = (ChatProtoRoomUI)this.chatUIs.get(object);
        if (chatProtoRoomUI != null) {
            String string;
            try {
                InputBuffer inputBuffer = new InputBuffer(byArray2);
                byte[] byArray3 = ChatProtoTool.readAOLChannelHeader(inputBuffer.d);
                if (byArray3 == null) {
                    ErrorMgr.warn(MODULE, "Error reading chat from " + nickname.nickname + ". Ignoring.");
                    return;
                }
                string = new String(byArray3);
            }
            catch (IOException iOException) {
                ErrorMgr.warn(MODULE, "io exception reading AOL channel header.", iOException);
                string = null;
            }
            chatProtoRoomUI.receiveMessage(nickname.nickname, string, bl, bl2);
        }
    }

    public void roomInfoUpdate(Object object, String string, Integer n, Integer n2, Integer n3, Integer n4, Integer n5) {
        Log.log(MODULE, Log.DEBUG, "roomInfoUpdate: for room " + string);
        ChatProtoRoomUI chatProtoRoomUI = (ChatProtoRoomUI)this.chatUIs.get(object);
        if (chatProtoRoomUI != null) {
            chatProtoRoomUI.updateRoomInfo(string, n, n2, n3, n4, n5);
        }
    }

    public void usersJoined(Object object, Nickname[] nicknameArray) {
        Log.log(MODULE, Log.DEBUG, "usersJoined");
        ChatProtoRoomUI chatProtoRoomUI = (ChatProtoRoomUI)this.chatUIs.get(object);
        if (chatProtoRoomUI != null) {
            chatProtoRoomUI.usersJoined(nicknameArray);
        }
    }

    public void usersLeft(Object object, Nickname[] nicknameArray) {
        Log.log(MODULE, Log.DEBUG, "usersLeft");
        ChatProtoRoomUI chatProtoRoomUI = (ChatProtoRoomUI)this.chatUIs.get(object);
        if (chatProtoRoomUI != null) {
            chatProtoRoomUI.usersLeft(nicknameArray);
        }
    }

    public void payloadError(Object object, String string, int n, byte[] byArray, String string2) {
        if (string2 == null || string2.length() == 0) {
            string2 = "of an unknown reason";
        }
        ChoiceUI.newChoiceUI("Payload Error", "Your attempt to chat with " + string + " failed because " + string2 + ".");
    }

    public void channelSpecificError(Object object, String string, int n, byte[] byArray, byte[] byArray2) {
        ChoiceUI.newChoiceUI("Channel Error", "Your attempt to chat with " + string + " on channel " + n + " failed. Error info = " + JUtil.bytesToHexString(byArray2));
    }

    public void connect(Object object) {
        Log.log(MODULE, Log.DEBUG, "connect");
        ChatProtoRoomUI chatProtoRoomUI = (ChatProtoRoomUI)this.chatUIs.get(object);
        if (chatProtoRoomUI == null) {
            chatProtoRoomUI = new ChatProtoRoomUI(object, this, this.tools, "AIM Chat Demo");
            this.chatUIs.put(object, chatProtoRoomUI);
        }
    }

    public void disconnect(Object object) {
        Log.log(MODULE, Log.DEBUG, "disconnect");
        ChatProtoRoomUI chatProtoRoomUI = (ChatProtoRoomUI)this.chatUIs.get(object);
        if (chatProtoRoomUI != null) {
            chatProtoRoomUI.setEnabled(false);
        }
    }

    public void setEnabled(Object object, boolean bl) {
        Log.log(MODULE, Log.DEBUG, "setEnabled: " + bl);
        ChatProtoRoomUI chatProtoRoomUI = (ChatProtoRoomUI)this.chatUIs.get(object);
        if (chatProtoRoomUI != null) {
            if (bl) {
                chatProtoRoomUI.show();
            }
            chatProtoRoomUI.setEnabled(bl);
        }
    }

    public void connect() {
    }

    public void disconnect() {
    }

    public void setEnabled(boolean bl) {
    }

    public void service() {
    }

    public void updateRate() {
    }

    public void updateUserInfo(Nickname nickname) {
    }

    public void updateUserEvil(String string, int n) {
    }

    public int id() {
        return 1;
    }

    public int version() {
        return 1;
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        return null;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        return null;
    }

    public void exportProperties(KeyBindings keyBindings, KeyBindings keyBindings2) {
    }

    public void importProperties(KeyBindings keyBindings, KeyBindings keyBindings2, KeyBindings keyBindings3, boolean bl) {
    }

    public boolean initiate(Vector vector, KeyBindings keyBindings) {
        return true;
    }

    public void shutdown() {
        Log.log(MODULE, Log.INFO, "ChatProtoTool got shutdown.");
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }

    private static byte[] readAOLChannelHeader(DataInputStream dataInputStream) throws IOException {
        short s;
        dataInputStream.readByte();
        dataInputStream.readByte();
        int n = dataInputStream.readShort();
        if (n < 1 || n > dataInputStream.available()) {
            return null;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            s = dataInputStream.readByte();
            if (s == whisc_capability_text) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            return null;
        }
        dataInputStream.readByte();
        dataInputStream.readByte();
        s = dataInputStream.readShort();
        if (s != dataInputStream.available()) {
            return null;
        }
        dataInputStream.readShort();
        dataInputStream.readShort();
        byte[] byArray = new byte[dataInputStream.available()];
        dataInputStream.read(byArray);
        return byArray;
    }

    private static void writeAOLChannelHeader(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        dataOutputStream.writeByte(whisc_item_capabilities);
        dataOutputStream.writeByte(capability_version);
        dataOutputStream.writeShort(1);
        dataOutputStream.writeByte(whisc_capability_text);
        dataOutputStream.writeByte(whisc_item_im_text);
        dataOutputStream.writeByte(im_text_version);
        dataOutputStream.writeShort(4 + byArray.length);
        dataOutputStream.writeShort(intl_encode_ascii);
        dataOutputStream.writeShort(intl_language_english);
        dataOutputStream.write(byArray, 0, byArray.length);
    }

    static {
        UIPACK_NAMES = new String[]{MODULE_NAME};
        TEST_COOKIE = new byte[]{116, 101, 115, 116};
    }
}

