/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.InviteUI;
import component.InviteUIListener;
import component.MainTool;
import component.OscarLabelButton;
import component.StatusFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Date;
import java.util.Vector;
import main.Oscar;
import uiutil.ChoiceUI;
import uiutil.IUtil;
import uiutil.ImageLabel;
import uiutil.TransparentPanel;

public class InviteInviteUI
extends InviteUI
implements ActionListener,
ComponentListener,
InviteUIListener,
TextListener {
    private MainTool invite;
    private TextField emailField;
    private TextArea messageArea;
    private Object userReqId;
    private int maximumMessageLength;
    private int MESSAGE_COLUMNS = 40;
    private static String ACTION_LABEL = "Send";

    public InviteInviteUI(MainTool mainTool) {
        super("Sign on a Friend", IUtil.format("To invite someone to join " + Oscar.FULL_NAME + ", enter that person's e-mail address and a " + "brief message below.", 60), ACTION_LABEL);
        this.setHelp("'Sign on a Friend' sends e-mail, including your brief, personal message, to the person you specify, inviting that person to join " + Oscar.FULL_NAME + ". If the person is already " + "a member, the e-mail will not be sent.");
        this.invite = mainTool;
        this.userReqId = null;
        TransparentPanel transparentPanel = new TransparentPanel(new FlowLayout());
        TransparentPanel transparentPanel2 = new TransparentPanel(new BorderLayout(0, 5));
        transparentPanel.add(transparentPanel2);
        TransparentPanel transparentPanel3 = new TransparentPanel(new BorderLayout());
        transparentPanel2.add("North", transparentPanel3);
        transparentPanel3.add("West", new ImageLabel("Email Address:", 3));
        this.emailField = new TextField();
        transparentPanel3.add("Center", this.emailField);
        this.emailField.addActionListener(this);
        this.emailField.addComponentListener(this);
        this.emailField.addTextListener(this);
        this.maximumMessageLength = this.invite.getMaximumInviteLength();
        this.messageArea = new TextArea("", this.maximumMessageLength / this.MESSAGE_COLUMNS, this.MESSAGE_COLUMNS, 3);
        transparentPanel2.add("Center", this.messageArea);
        this.messageArea.addTextListener(this);
        this.setContents(transparentPanel);
        this.invite.addInviteUIListener(this);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.emailField)) {
            this.messageArea.requestFocus();
        }
        if (object instanceof OscarLabelButton && ((OscarLabelButton)object).getLabel().equals(ACTION_LABEL) && this.userReqId == null) {
            this.userReqId = new Date();
            String string = this.emailField.getText();
            if (string != null && string.length() > 7 && string.indexOf(64) != -1) {
                String string2 = this.messageArea.getText();
                if (string2.length() > this.maximumMessageLength) {
                    this.userReqId = null;
                    ChoiceUI.newChoiceUI("Alert", "Your message is too long. It exceeds the maximum allowable length by " + (string2.length() - this.maximumMessageLength) + " characters. Please shorten your message.", Oscar.WARNING_SOUND);
                    return;
                }
                this.setStatus(StatusFrame.STATUS_WAITING, "Sending invitation...");
                this.invite.sendInvitation(string, string2, this.userReqId);
                return;
            }
            this.userReqId = null;
            ChoiceUI.newChoiceUI("Alert", "Please enter a valid email address.", Oscar.WARNING_SOUND);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.emailField.requestFocus();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void invitationSent(String string, Object object) {
        if (this.userReqId != null && this.userReqId.equals(object)) {
            this.userReqId = null;
            this.setStatus(StatusFrame.STATUS_SUCCESS, "Your invitation has been sent.");
            IUtil.playSound(this.invite, "Save");
        }
    }

    public void isMemberButDeclinesToRevealNickname(String string, Object object) {
        if (this.userReqId != null && this.userReqId.equals(object)) {
            this.userReqId = null;
            this.setStatus(StatusFrame.STATUS_SUCCESS, "This person is already a member.");
            IUtil.playSound(this.invite, Oscar.WARNING_SOUND);
        }
    }

    public void notAMember(String string, Object object) {
    }

    public void requestExpired(Object object) {
        if (this.userReqId != null && this.userReqId.equals(object)) {
            object = null;
            this.setStatus(StatusFrame.STATUS_FAILURE, "The server did not respond.");
            IUtil.playSound(this.invite, Oscar.ERROR_SOUND);
        }
    }

    public void setNicknamesForEmail(String string, Vector vector, Object object) {
        if (this.userReqId != null && this.userReqId.equals(object)) {
            this.userReqId = null;
            this.setStatus(StatusFrame.STATUS_SUCCESS, "This person is already a member.");
            IUtil.playSound(this.invite, Oscar.WARNING_SOUND);
        }
    }

    public void removeNotify() {
        this.removeAll();
        if (this.invite != null) {
            this.invite.removeInviteUIListener(this);
            this.invite = null;
        }
        this.emailField = null;
        this.messageArea = null;
        this.userReqId = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this.userReqId == null) {
            this.setStatus(StatusFrame.STATUS_NORMAL, "");
        }
    }
}

