/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.LocateCore;
import component.PaintedIcon;
import component.SLCommandHandler;
import component.Tool;
import component.Tools;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import main.Nickname;
import main.Oscar;
import main.Rate;
import uiutil.AolRtfArea;
import uiutil.ChoiceUI;
import uiutil.ErrorMgr;
import uiutil.IUtil;
import uiutil.IconMeter;
import uiutil.ImageLabel;
import uiutil.ImagePanel;
import uiutil.LedBar;
import uiutil.OFrame;
import uiutil.SuperLayout;
import uiutil.TransparentPanel;
import util.JUtil;

class LocateUI
extends OFrame
implements ActionListener,
KeyListener {
    private static String MODULE = "LocateUI";
    private static int WIDTH = 350;
    private static int HEIGHT = 350;
    private LocateCore core;
    private Tools tools;
    private String nickname;
    private Component sendButton;
    private Component cancelButton;
    private Component imButton;
    private TransparentPanel userInfoPanel;
    private IconMeter classIcon;
    private ImageLabel classLabel;
    private ImageLabel memberLabel;
    private PaintedIcon evilIcon;
    private ImageLabel evilLabel;
    private PaintedIcon idleIcon;
    private ImageLabel idleLabel;
    private ImageLabel logonLabel;
    private TextField nicknameField;
    private AolRtfArea dataDisplay;
    private boolean fullDataDisplay;
    private boolean firstShow;
    private String[] classStrings;
    private String[] classLabels;
    private LedBar rateIndicator;
    private boolean enabled;

    public LocateUI(LocateCore locateCore, Tools tools, String string) {
        this.classStrings = Oscar.images.CLASS_ICON_FILES;
        this.classLabels = Oscar.images.CLASS_ICON_LABELS;
        this.enabled = true;
        this.core = locateCore;
        this.tools = tools;
        this.firstShow = true;
        ImagePanel imagePanel = new ImagePanel();
        this.add("Center", imagePanel);
        SuperLayout superLayout = new SuperLayout(imagePanel, locateCore);
        imagePanel.setLayout(superLayout);
        this.rateIndicator = new LedBar();
        imagePanel.add("RateBar", this.rateIndicator);
        this.rateIndicator.setSize(170, 22);
        if (string == null) {
            this.setTitle("Info");
            this.nickname = "";
            this.fullDataDisplay = false;
            this.nicknameField = new TextField(16);
            imagePanel.add("Nickname", this.nicknameField);
            this.nicknameField.addActionListener(this);
            superLayout.loadLayout("infoquery.lay");
            this.sendButton = superLayout.getLayoutComponent("Send");
            SLCommandHandler.addActionListener(this.sendButton, this);
            this.cancelButton = superLayout.getLayoutComponent("Cancel");
            SLCommandHandler.addActionListener(this.cancelButton, this);
        } else {
            this.setTitle("Info: " + string);
            this.nickname = string;
            this.fullDataDisplay = true;
            this.evilIcon = new PaintedIcon(Oscar.images.MINI_ICON_SIZE, Oscar.images.MINI_ICON_SIZE, 1);
            imagePanel.add("Warnings", this.evilIcon);
            this.evilLabel = new ImageLabel("       ", 2, 5, 1);
            imagePanel.add("WarningsT", this.evilLabel);
            this.evilLabel.setTextStyle(0);
            this.idleIcon = new PaintedIcon(Oscar.images.MINI_ICON_SIZE, Oscar.images.MINI_ICON_SIZE, 2);
            imagePanel.add("IdleTime", this.idleIcon);
            this.idleLabel = new ImageLabel("MMMMMMM", 2, 5, 1);
            imagePanel.add("IdleTimeT", this.idleLabel);
            this.idleLabel.setTextStyle(0);
            Image[] imageArray = Oscar.images.getImages(locateCore, this.classStrings, imagePanel, true);
            this.classIcon = new IconMeter("locate-class", imageArray);
            imagePanel.add("Class", this.classIcon);
            this.classLabel = new ImageLabel("          ", 2, 5, 1);
            imagePanel.add("ClassT", this.classLabel);
            this.classLabel.setTextStyle(0);
            this.memberLabel = new ImageLabel("MM MMM MMMMM", 2, 0, 1);
            imagePanel.add("MemberSince", this.memberLabel);
            this.memberLabel.setTextStyle(0);
            this.logonLabel = new ImageLabel("MM MMM MMMMM", 2, 0, 1);
            imagePanel.add("OnSince", this.logonLabel);
            this.logonLabel.setTextStyle(0);
            this.dataDisplay = new AolRtfArea("Info", null, true, false, -1, 0);
            imagePanel.add("DisplayArea", this.dataDisplay);
            superLayout.loadLayout("infowindow.lay");
            this.imButton = superLayout.getLayoutComponent("IM");
            SLCommandHandler.addActionListener(this.imButton, this);
            this.cancelButton = superLayout.getLayoutComponent("Close");
            SLCommandHandler.addActionListener(this.cancelButton, this);
        }
        this.updateRate(locateCore.getRate());
        this.pack();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.sendButton != null) {
            this.sendButton.setEnabled(bl);
        }
        if (this.imButton != null) {
            this.imButton.setEnabled(bl);
        }
        if (bl) {
            ((Component)this).setCursor(Cursor.getDefaultCursor());
            return;
        }
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.sendButton) || object.equals(this.nicknameField)) {
            this.locateButtonAction();
            return;
        }
        if (object.equals(this.imButton)) {
            this.icbmButtonAction();
            return;
        }
        if (object.equals(this.cancelButton)) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public String getNickname() {
        return this.nickname;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c != '\u0002' && c == '\t') {
            this.icbmButtonAction();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void icbmButtonAction() {
        Tool tool = this.tools.get("tool.icbm");
        if (tool != null) {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(this.nickname);
            tool.initiate(vector, null);
            return;
        }
        ErrorMgr.warn(MODULE, "The IM service is currently unavailable.");
    }

    private void locateButtonAction() {
        String string = this.nicknameField.getText();
        if (string != null && string.length() > 0) {
            this.nickname = string;
            ((Component)this).setVisible(false);
            this.core.locate(this.nickname);
            this.dispose();
            return;
        }
        ChoiceUI.newChoiceUI("Locate Alert", "Please provide the name of the member you wish to locate.", Oscar.WARNING_SOUND);
    }

    public void removeNotify() {
        this.removeAll();
        if (this.core != null) {
            this.core.removeUI(this);
        }
        this.core = null;
        this.tools = null;
        this.nickname = null;
        this.sendButton = null;
        this.cancelButton = null;
        this.imButton = null;
        this.userInfoPanel = null;
        this.classIcon = null;
        this.classLabel = null;
        this.memberLabel = null;
        this.evilIcon = null;
        this.evilLabel = null;
        this.idleIcon = null;
        this.idleLabel = null;
        this.logonLabel = null;
        this.nicknameField = null;
        if (this.dataDisplay != null) {
            this.dataDisplay.destroy();
        }
        this.dataDisplay = null;
        this.classStrings = null;
        this.classLabels = null;
        this.rateIndicator = null;
        super.removeNotify();
    }

    public void showData(Nickname nickname, String string, byte[] byArray) {
        Object object;
        if (!this.fullDataDisplay) {
            return;
        }
        String string2 = byArray != null ? new String(byArray) : LocateCore.LOCATE_INFO;
        if (!string2.toUpperCase().startsWith("<HTML>")) {
            string2 = JUtil.htmlize(string2);
        }
        if (string == null) {
            string = LocateCore.DEFAULT_MIME_TYPE;
        }
        if (nickname.nickname == null) {
            nickname.nickname = LocateCore.BLANK_NICKNAME;
        }
        if (!(string.toLowerCase().startsWith("text/plain") || string.toLowerCase().startsWith("text/x-aolrtf") || string.toLowerCase().startsWith("text/aolrtf") || string.toLowerCase().startsWith("text/html"))) {
            object = "Unsupported MIME type \"" + string + "\".";
            ErrorMgr.warn(MODULE, String.valueOf(object) + "Will try to display as HTML.");
        }
        if (string2 != null) {
            this.dataDisplay.setHTML(string2);
        }
        if (this.firstShow) {
            this.pack();
            object = this.getBounds();
            if (((Rectangle)object).width > WIDTH) {
                WIDTH = ((Rectangle)object).width;
            }
            if (((Rectangle)object).height > HEIGHT) {
                HEIGHT = ((Rectangle)object).height;
            }
            ((Component)this).setSize(WIDTH, HEIGHT);
        }
        this.updateRate(this.core.getRate());
        this.updateUserInfo(nickname);
        ((Component)this).setVisible(true);
        if (this.firstShow) {
            IUtil.playSound(this.core, "Info");
            this.firstShow = false;
        }
    }

    public void updateRate(Rate rate) {
        if (rate != null && this.rateIndicator != null) {
            if (rate.limited) {
                this.rateIndicator.setLimits(rate.disconnect, rate.clear, rate.clear, rate.maxAve);
            } else {
                this.rateIndicator.setLimits(rate.disconnect, rate.limit, rate.alert, rate.maxAve);
            }
            this.rateIndicator.setValue(rate.rate);
        }
    }

    public void updateUserEvil(int n) {
        this.evilIcon.set(n);
        this.evilLabel.setText(String.valueOf(n));
    }

    public void updateUserInfo(Nickname nickname) {
        int n = nickname.getClassCode();
        this.classIcon.set(n + 1);
        String string = this.classLabels[n + 1];
        while (string.length() < 8) {
            string = String.valueOf(string) + "  ";
        }
        this.classLabel.setText(string);
        String string2 = nickname.memberSinceAsString();
        if (string2 == null) {
            string2 = "Unknown";
        }
        this.memberLabel.setText(string2);
        this.evilIcon.set(nickname.evil);
        this.evilLabel.setText(String.valueOf(nickname.evil));
        this.idleIcon.set(nickname.idleTime);
        this.idleLabel.setText(JUtil.timeString(nickname.idleTime));
        this.logonLabel.setText(JUtil.shortDate(nickname.signonTOD));
    }
}

