/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.BuddyCore;
import component.FolderInfo;
import component.InviteAddBuddyUI;
import component.InviteInviteUI;
import component.InviteLookupUI;
import component.InviteUIListener;
import component.MainUI;
import component.SetupUI;
import component.Tool;
import component.Tools;
import java.awt.Component;
import java.awt.MenuItem;
import java.util.Date;
import java.util.Vector;
import main.BOSCore;
import main.InviteAPI;
import main.LoginCore;
import main.MainAPI;
import main.Nickname;
import main.Oscar;
import uiutil.ChoiceListener;
import uiutil.ChoiceUI;
import uiutil.ErrorMgr;
import uiutil.IUtil;
import uiutil.PropertySheet;
import uiutil.UrlViewer;
import util.KeyBindings;
import util.Log;
import util.Timer;
import util.TimerEvent;
import util.TimerListener;

public class MainTool
implements ChoiceListener,
InviteAPI,
MainAPI,
TimerListener,
Tool {
    private static final String MODULE = "MainTool";
    public static final String MODULE_NAME = "tool.main";
    private static final String[] UIPACK_NAMES = new String[]{"tool.main"};
    private static final String DISPLAY_NAME = "Main Tool";
    private static int EXIT_CHOICE = 1;
    private static int SIGNOFF_CHOICE = 2;
    private static int INVITE_ALARM = 1;
    private static int LOOKUP_ALARM = 2;
    public static Vector menuItems = new Vector();
    private BOSCore bosCore;
    private Tools tools;
    private BuddyCore buddyTool;
    private MainUI mainUI;
    private boolean enabled = false;
    protected boolean loggingOut = false;
    private String topOfTheWorld;
    private int localEvil;
    private Vector inviteUIListeners = new Vector();
    private Vector alarms = new Vector();
    private int INVITE_TIMEOUT = 15000;
    private String SYSTEM_TIMER = "System";

    public MainTool(BOSCore bOSCore, Tools tools) {
        this.bosCore = bOSCore;
        this.tools = tools;
        this.buddyTool = (BuddyCore)tools.get("tool.buddylist");
        Oscar.mainTool = this;
    }

    public void addMenuItem(String string, MenuItem menuItem) {
        if (this.mainUI != null) {
            this.mainUI.addMenuItem(string, menuItem);
            return;
        }
        menuItems.addElement(string);
        menuItems.addElement(menuItem);
    }

    public void exitAction() {
        ChoiceUI.newChoiceUI(this, EXIT_CHOICE, null, MainUI.EXIT_TITLE, "Are you sure you want to exit\n" + Oscar.FULL_NAME + "?", "OK", "Cancel", null, null);
        this.loggingOut = true;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public String getSelectedNickname() {
        return this.buddyTool.getSelectedNickname();
    }

    public String getTopOfTheWorld() {
        return this.topOfTheWorld;
    }

    public void icbmAction(String string) {
        Tool tool = this.tools.get("tool.icbm");
        if (tool != null) {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(string);
            tool.initiate(vector, null);
            return;
        }
        ErrorMgr.warn(MODULE, "The IM service is currently unavailable.");
    }

    public void locateAction(String string) {
        Tool tool = this.tools.get("tool.locate");
        if (tool != null) {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(string);
            tool.initiate(vector, null);
            return;
        }
        ErrorMgr.warn(MODULE, "The Info service is currently unavailable.");
    }

    public void newsAction() {
        if (this.topOfTheWorld == null) {
            ErrorMgr.warn(MODULE, "News is not currently available.");
            return;
        }
        new UrlViewer(this.topOfTheWorld);
    }

    public void rendezvousAction(String string) {
        Tool tool = this.tools.get("tool.icbm");
        if (tool != null) {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(string);
            KeyBindings keyBindings = new KeyBindings();
            keyBindings.setValue("Channel", "2");
            tool.initiate(vector, keyBindings);
            return;
        }
        ErrorMgr.warn(MODULE, "The Icbm service is currently unavailable.");
    }

    public void signOffAction() {
        ChoiceUI.newChoiceUI(this, SIGNOFF_CHOICE, null, MainUI.SIGNOFF_TITLE, "Are you sure you want to sign off\n" + Oscar.FULL_NAME + "?", "OK", "Cancel", null, null);
        this.loggingOut = true;
    }

    private void waitForShutdownSound() {
        try {
            Thread.currentThread();
            Thread.sleep(2500L);
            return;
        }
        catch (InterruptedException interruptedException) {
            ErrorMgr.diag(MODULE, Log.WARNING, "Exception waiting for shutdown sound.", interruptedException);
            return;
        }
    }

    public void setLocalUserEvil(int n, Nickname nickname) {
        System.out.println("setLocalUserEvil localEvil=" + this.localEvil + " newEvil = " + n + " vilifier = " + nickname);
        if (n > this.localEvil) {
            String string = null;
            if (nickname != null) {
                string = nickname.nickname;
            }
            this.mainUI.setEvil(n, string);
        } else {
            this.mainUI.setEvil(n);
        }
        this.localEvil = n;
    }

    public void setTopOfTheWorld(String string) {
        this.topOfTheWorld = string;
    }

    public void choiceMade(int n, int n2, Object object) {
        if (n == EXIT_CHOICE) {
            if (n2 == 0) {
                IUtil.playSound(this, "Logout");
                this.waitForShutdownSound();
                Oscar.app.shutdown();
                return;
            }
            this.loggingOut = false;
            return;
        }
        if (n == SIGNOFF_CHOICE) {
            if (n2 == 0) {
                IUtil.playSound(this, "Logout");
                this.waitForShutdownSound();
                Oscar.logout();
                return;
            }
            this.loggingOut = false;
        }
    }

    public void connect() {
    }

    public void disconnect() {
        if (this.mainUI != null) {
            ((Component)this.mainUI).setVisible(false);
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.mainUI.setEnabled(bl);
    }

    public void service() {
    }

    public void updateRate() {
    }

    public void updateUserEvil(String string, int n) {
    }

    public void updateUserInfo(Nickname nickname) {
    }

    public int id() {
        return 1;
    }

    public int version() {
        return 1;
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        return null;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        return null;
    }

    public void exportProperties(KeyBindings keyBindings, KeyBindings keyBindings2) {
    }

    public void importProperties(KeyBindings keyBindings, KeyBindings keyBindings2, KeyBindings keyBindings3, boolean bl) {
    }

    public boolean initiate(Vector vector, KeyBindings keyBindings) {
        this.buddyTool.initiate(vector, keyBindings);
        if (this.mainUI == null) {
            this.mainUI = new MainUI(this, this.tools, this.buddyTool.getUI());
            int n = 0;
            int n2 = menuItems.size();
            while (n < n2) {
                String string = (String)menuItems.elementAt(n++);
                MenuItem menuItem = (MenuItem)menuItems.elementAt(n++);
                this.mainUI.addMenuItem(string, menuItem);
            }
        }
        this.mainUI.show();
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            Log.log(MODULE, Log.WARNING, "Exception showing MainUI.", interruptedException);
        }
        LoginCore loginCore = (LoginCore)this.tools.get("tool.login");
        loginCore.shutdown();
        return true;
    }

    public void shutdown() {
        Log.log(MODULE, Log.INFO, "got shutdown.");
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }

    public void invitationSent(String string, Object object) {
        this.turnOffAlarm(object);
        int n = 0;
        while (n < this.inviteUIListeners.size()) {
            ((InviteUIListener)this.inviteUIListeners.elementAt(n)).invitationSent(string, object);
            ++n;
        }
    }

    public void notAMember(String string, Object object) {
        this.turnOffAlarm(object);
        int n = 0;
        while (n < this.inviteUIListeners.size()) {
            ((InviteUIListener)this.inviteUIListeners.elementAt(n)).notAMember(string, object);
            ++n;
        }
    }

    public void isMemberButDeclinesToRevealNickname(String string, Object object) {
        this.turnOffAlarm(object);
        int n = 0;
        while (n < this.inviteUIListeners.size()) {
            ((InviteUIListener)this.inviteUIListeners.elementAt(n)).isMemberButDeclinesToRevealNickname(string, object);
            ++n;
        }
        ChoiceUI.newChoiceUI("Find A Friend", "The person with e-mail address " + string + " is a registered member of " + Oscar.FULL_NAME + ". However, this member has declined to reveal the screen " + "name(s) associated with this e-mail address. You'll need " + "to contact this person by another means (such as sending " + "e-mail) to determine this person's screen name(s).");
    }

    public void setNicknamesForEmail(String string, Vector vector, Object object) {
        this.turnOffAlarm(object);
        int n = 0;
        while (n < this.inviteUIListeners.size()) {
            ((InviteUIListener)this.inviteUIListeners.elementAt(n)).setNicknamesForEmail(string, vector, object);
            ++n;
        }
        new InviteAddBuddyUI(this, string, vector);
    }

    public void addInviteUIListener(InviteUIListener inviteUIListener) {
        if (!this.inviteUIListeners.contains(inviteUIListener)) {
            this.inviteUIListeners.addElement(inviteUIListener);
        }
    }

    public int getMaximumInviteLength() {
        return 256;
    }

    public void lookupBuddy(String string, Object object) {
        Log.log(MODULE, Log.DB0, "Lookup " + string + " ReqId: " + ((Date)object).getTime());
        this.bosCore.getNicknameByEmail(string, object);
        this.alarms.addElement(Timer.createEvent(this.SYSTEM_TIMER, this, LOOKUP_ALARM, object, this.INVITE_TIMEOUT));
    }

    public void removeInviteUIListener(InviteUIListener inviteUIListener) {
        this.inviteUIListeners.removeElement(inviteUIListener);
    }

    public void sendInvitation(String string, String string2, Object object) {
        Log.log(MODULE, Log.DB0, "Invite " + string + " ReqId: " + ((Date)object).getTime());
        this.bosCore.invite(string, string2, object);
        this.alarms.addElement(Timer.createEvent(this.SYSTEM_TIMER, this, INVITE_ALARM, object, this.INVITE_TIMEOUT));
    }

    public void startLookupBuddy() {
        new InviteLookupUI(this);
    }

    public void startInviteBuddy() {
        new InviteInviteUI(this);
    }

    public void timerEvent(String string, int n, Object object) {
        if (n == LOOKUP_ALARM || n == INVITE_ALARM) {
            Log.log(MODULE, Log.DB0, "Expire request " + ((Date)object).getTime());
            int n2 = 0;
            while (n2 < this.inviteUIListeners.size()) {
                ((InviteUIListener)this.inviteUIListeners.elementAt(n2)).requestExpired(object);
                ++n2;
            }
        }
    }

    public void turnOffAlarm(Object object) {
        Log.log(MODULE, Log.DB0, "Turn off alarm for request " + ((Date)object).getTime());
        int n = 0;
        while (n < this.alarms.size()) {
            TimerEvent timerEvent = (TimerEvent)this.alarms.elementAt(n);
            if (timerEvent.getCallback().equals(object)) {
                this.alarms.removeElement(timerEvent);
                Timer.removeEvent(timerEvent);
            }
            ++n;
        }
    }
}

