/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.AdminTool;
import component.BuddyCore;
import component.BuddyUI;
import component.MainTool;
import component.OscarMenu;
import component.PaintedIcon;
import component.SLCommandHandler;
import component.Tools;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URLEncoder;
import java.util.Properties;
import main.AdminConstants;
import main.Oscar;
import uiutil.ChoiceUI;
import uiutil.IUtil;
import uiutil.ImagePanel;
import uiutil.MultiLineLabel;
import uiutil.OFrame;
import uiutil.SuperLayout;
import uiutil.UrlViewer;
import util.JUtil;
import util.Log;

class MainUI
extends OFrame
implements ActionListener,
AdminConstants,
KeyListener,
WindowListener,
ComponentListener,
ItemListener {
    private static String MODULE = "MainUI";
    protected static String EXIT_TITLE = "Exit";
    protected static String SIGNOFF_TITLE = "Sign Off";
    private static int AD_WIDTH = 120;
    private static int AD_HEIGHT = 60;
    private static int AD_BORDER = 30;
    private MainTool mainTool;
    private Tools tools;
    private ImagePanel main;
    private Component newsButton;
    private Component locateButton;
    private Component icbmButton;
    private PaintedIcon evilIcon;
    private boolean enabled = true;
    private MenuItem setupMenu;
    private MenuItem passMenu;
    private CheckboxMenuItem dbgMenu;
    private MenuItem signoffMenu;
    private MenuItem exitMenu;
    private MenuItem signFriendMenu;
    private MenuItem byEmailMenu;
    private MenuItem byNameMenu;
    private MenuItem versionMenu;
    private MenuItem aboutMenu;
    private MenuItem bugReportMenu;
    private MenuItem quickStartMenu;
    private int windowX;
    private int windowY;
    private int windowWidth;
    private int windowHeight;
    private boolean windowChanged;

    public MainUI(MainTool mainTool, Tools tools, BuddyUI buddyUI) {
        this.mainTool = mainTool;
        this.tools = tools;
        this.addKeyListener(this);
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.setTitle(Oscar.SHORT_NAME);
        MenuBar menuBar = new MenuBar();
        OscarMenu oscarMenu = new OscarMenu("File");
        oscarMenu.setShortcut(new MenuShortcut(70));
        OscarMenu oscarMenu2 = new OscarMenu("Options");
        oscarMenu.add(oscarMenu2);
        this.setupMenu = new MenuItem("Edit Preferences");
        oscarMenu2.add(this.setupMenu);
        this.setupMenu.addActionListener(this);
        this.passMenu = new MenuItem("Change Password");
        oscarMenu2.add(this.passMenu);
        this.passMenu.addActionListener(this);
        oscarMenu2.addAd(15008216, 0);
        oscarMenu2.addAd(15008217, 0);
        oscarMenu2.addAd(15008218, 0);
        oscarMenu2.addAd(15008219, 0);
        oscarMenu2.addAd(15008220, 0);
        this.dbgMenu = new CheckboxMenuItem("Debug");
        oscarMenu2.add(this.dbgMenu);
        if (Log.getLogLevel() == Log.MAXLEVEL) {
            this.dbgMenu.setState(true);
        }
        this.dbgMenu.addItemListener(this);
        oscarMenu.addAd(15008152, 0);
        oscarMenu.addAd(15008153, 0);
        oscarMenu.addAd(15008160, 0);
        oscarMenu.addAd(15008161, 0);
        this.signoffMenu = new MenuItem("Sign Off");
        oscarMenu.add(this.signoffMenu);
        this.signoffMenu.addActionListener(this);
        this.exitMenu = new MenuItem("Exit");
        oscarMenu.add(this.exitMenu);
        this.exitMenu.addActionListener(this);
        menuBar.add(oscarMenu);
        oscarMenu = new OscarMenu("People");
        this.signFriendMenu = new MenuItem("Sign on a Friend");
        oscarMenu.add(this.signFriendMenu);
        this.signFriendMenu.addActionListener(this);
        oscarMenu.addAd(15008128, 0);
        oscarMenu.addAd(15008129, 0);
        OscarMenu oscarMenu3 = new OscarMenu("Find a Buddy");
        oscarMenu.add(oscarMenu3);
        this.byEmailMenu = new MenuItem("By E-Mail Address");
        oscarMenu3.add(this.byEmailMenu);
        this.byEmailMenu.addActionListener(this);
        this.byNameMenu = new MenuItem("By Name");
        oscarMenu3.add(this.byNameMenu);
        this.byNameMenu.addActionListener(this);
        oscarMenu3.addAd(15008201, 0);
        oscarMenu3.addAd(15008202, 0);
        oscarMenu.addAd(15008144, 0);
        oscarMenu.addAd(15008145, 0);
        oscarMenu.addAd(15008146, 0);
        menuBar.add(oscarMenu);
        oscarMenu = new OscarMenu("Help");
        this.versionMenu = new MenuItem("Version");
        oscarMenu.add(this.versionMenu);
        this.versionMenu.addActionListener(this);
        this.bugReportMenu = new MenuItem("Report a Bug");
        oscarMenu.add(this.bugReportMenu);
        this.bugReportMenu.addActionListener(this);
        this.aboutMenu = new MenuItem("About AOL Instant Messenger");
        oscarMenu.add(this.aboutMenu);
        this.aboutMenu.addActionListener(this);
        oscarMenu.addAd(15008192, 0);
        oscarMenu.addAd(15008193, 0);
        oscarMenu.addAd(15008136, 0);
        oscarMenu.addAd(15008137, 0);
        oscarMenu.addAd(15008138, 0);
        oscarMenu.addAd(15008139, 0);
        this.quickStartMenu = new MenuItem("Quick Start Help");
        oscarMenu.add(this.quickStartMenu);
        this.quickStartMenu.addActionListener(this);
        menuBar.setHelpMenu(oscarMenu);
        Font font = new Font("Dialog", 0, 12);
        menuBar.setFont(font);
        this.setMenuBar(menuBar);
        ImagePanel imagePanel = new ImagePanel();
        this.add(imagePanel);
        SuperLayout superLayout = new SuperLayout(imagePanel, mainTool);
        imagePanel.setLayout(superLayout);
        imagePanel.add("BuddyList", buddyUI);
        this.evilIcon = new PaintedIcon(Oscar.images.MINI_ICON_SIZE, Oscar.images.MINI_ICON_SIZE, 1);
        imagePanel.add("Evil", this.evilIcon);
        superLayout.loadLayout("mainwindow.lay");
        this.locateButton = superLayout.getLayoutComponent("Info");
        SLCommandHandler.addActionListener(this.locateButton, this);
        this.locateButton.addKeyListener(this);
        this.icbmButton = superLayout.getLayoutComponent("IM");
        SLCommandHandler.addActionListener(this.icbmButton, this);
        this.icbmButton.addKeyListener(this);
        this.newsButton = superLayout.getLayoutComponent("News");
        SLCommandHandler.addActionListener(this.newsButton, this);
        this.newsButton.addKeyListener(this);
        this.setWindowPos();
    }

    private void setWindowPos() {
        this.windowX = 0;
        this.windowY = 0;
        String string = Oscar.config.getValue(BuddyCore.WINDOW_X);
        if (string != null) {
            try {
                this.windowX = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        if ((string = Oscar.config.getValue(BuddyCore.WINDOW_Y)) != null) {
            try {
                this.windowY = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        this.windowWidth = AD_WIDTH + 2 * AD_BORDER;
        this.windowHeight = 2 * this.windowWidth;
        string = Oscar.config.getValue(BuddyCore.WINDOW_WIDTH);
        if (string != null) {
            try {
                this.windowWidth = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                this.windowWidth = AD_WIDTH + 2 * AD_BORDER;
            }
        }
        if ((string = Oscar.config.getValue(BuddyCore.WINDOW_HEIGHT)) != null) {
            try {
                this.windowHeight = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                this.windowHeight = 2 * this.windowWidth;
            }
        }
        ((Component)this).setLocation(this.windowX, this.windowY);
        ((Component)this).setSize(this.windowWidth, this.windowHeight);
    }

    private final void saveWindowPos() {
        Oscar.config.setValue(BuddyCore.WINDOW_WIDTH, String.valueOf(this.windowWidth));
        Oscar.config.setValue(BuddyCore.WINDOW_HEIGHT, String.valueOf(this.windowHeight));
        Oscar.config.setValue(BuddyCore.WINDOW_X, String.valueOf(this.windowX));
        Oscar.config.setValue(BuddyCore.WINDOW_Y, String.valueOf(this.windowY));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.dbgMenu)) {
            if (Log.getLogLevel() < Log.MAXLEVEL) {
                ChoiceUI.newChoiceUI("Debug", "Verbose Debugging is now on");
                Log.setLogLevel(Log.MAXLEVEL);
                this.dbgMenu.setState(true);
                return;
            }
            ChoiceUI.newChoiceUI("Debug", "Verbose Debugging is now off");
            Log.setLogLevel(Log.INFO);
            this.dbgMenu.setState(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OFrame.lastEventTime = System.currentTimeMillis();
        Object object = actionEvent.getSource();
        if (object.equals(this.locateButton)) {
            this.mainTool.locateAction(Oscar.mainTool.getSelectedNickname());
            return;
        }
        if (object.equals(this.icbmButton)) {
            this.mainTool.icbmAction(Oscar.mainTool.getSelectedNickname());
            return;
        }
        if (object.equals(this.newsButton)) {
            this.mainTool.newsAction();
            return;
        }
        if (object.equals(this.aboutMenu)) {
            Oscar.displayAbout();
            return;
        }
        if (object.equals(this.versionMenu)) {
            Oscar.displayVersion();
            return;
        }
        if (object.equals(this.setupMenu)) {
            Oscar.setup(null, 0);
            return;
        }
        if (object.equals(this.passMenu)) {
            AdminTool adminTool = (AdminTool)this.tools.get("tool.admin");
            adminTool.showUI(1, null);
            return;
        }
        if (object.equals(this.signoffMenu)) {
            this.mainTool.signOffAction();
            return;
        }
        if (object.equals(this.exitMenu)) {
            if (this.windowChanged) {
                this.saveWindowPos();
            }
            this.mainTool.exitAction();
            return;
        }
        if (object.equals(this.signFriendMenu)) {
            this.mainTool.startInviteBuddy();
            return;
        }
        if (object.equals(this.byEmailMenu)) {
            this.mainTool.startLookupBuddy();
            return;
        }
        if (object.equals(this.byNameMenu)) {
            new UrlViewer("http://www.aol.com/netfind/person.im.html");
            return;
        }
        if (object.equals(this.quickStartMenu)) {
            ChoiceUI.newChoiceUI("Quick Start Help", "   The first thing you may want to do is add screen names to your buddy list. To do so, select `File' on the menu bar, click `Options' and select `Edit Preference' in the submenu. This invokes a setup window that by default shows the buddy configuration panel. If you do not have a screen name to add, try adding your own screen name. Click on the `Help' button at the bottom of the setup screen if you want further instructions on how to add a screen name to your buddy list. When you have finished editing your list, click the `OK' button to return to the buddy list window.\n \n   If the people whose screen names you added to your list are currently online, their names will appear in the buddy display area under the group(s) in which they were added. Double-clicking on a name in the buddy display window launches an IM window that  you can use to send a message to that buddy. Clicking with the right mouse button on a name displays information about that user.\n \n   The icon at the left of the name shows the user class (e.g. the triangular AOL icon shows that a buddy is currently on AOL). The yellow icon (which may change to red vertical marks)  shows the warning level; and the blue circle (which may be partially or entirely filled) gives an indication of the duration of user inactivity. ", MultiLineLabel.BORDER_SIMPLE);
            return;
        }
        if (object.equals(this.bugReportMenu)) {
            Properties properties = null;
            try {
                properties = System.getProperties();
            }
            catch (SecurityException securityException) {
                new UrlViewer("http://www.idot.aol.com/oscar/javabugs.html");
                return;
            }
            new UrlViewer("http://www.aim.aol.com/cgi-bin/javabugs.cgi?ver=beta&num=" + Oscar.version + Oscar.build + "&plat=Java" + "&type=Java" + "&BuildNumber=" + Oscar.buildNumber + "&ScreenName=" + URLEncoder.encode(Oscar.nickname) + "&RuntimeEnv=" + URLEncoder.encode(String.valueOf(properties.getProperty("os.arch", "")) + "; " + properties.getProperty("os.name", "") + "; " + properties.getProperty("os.version", "") + "; " + properties.getProperty("java.vendor", "") + "; " + properties.getProperty("java.version", "") + ", " + properties.getProperty("java.class.version", "") + "; " + JUtil.memAvail(true)));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        OFrame.lastEventTime = System.currentTimeMillis();
    }

    public void keyReleased(KeyEvent keyEvent) {
        OFrame.lastEventTime = System.currentTimeMillis();
        char c = keyEvent.getKeyChar();
        switch (c) {
            case '\u0007': 
            case '\f': {
                this.mainTool.locateAction(Oscar.mainTool.getSelectedNickname());
                return;
            }
            case '\t': {
                if (keyEvent.getKeyCode() == 9) break;
                this.mainTool.icbmAction(Oscar.mainTool.getSelectedNickname());
                return;
            }
            case '\u000e': {
                this.mainTool.newsAction();
                return;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.newsButton.setEnabled(bl);
        this.locateButton.setEnabled(bl);
        this.icbmButton.setEnabled(bl);
        if (!bl) {
            ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
            return;
        }
        ((Component)this).setCursor(Cursor.getDefaultCursor());
    }

    public void setEvil(int n, String string) {
        IUtil.playSound(this.mainTool, "Struck");
        String string2 = string == null ? "You were just warned anonymously." : "You were just warned by " + string + ".";
        this.setEvil(n);
        ChoiceUI.newChoiceUI("Warning Notice", String.valueOf(string2) + "  When you contact another " + "member (by using the Instant Message " + "feature, for example) the other " + "member may express disapproval of your " + "contact by Warning you.  The more members " + "Warn you, the more the system slows down " + "for you.  Warnings wear off over time.");
    }

    public void setEvil(int n) {
        this.evilIcon.set(n);
    }

    public void addMenuItem(String string, MenuItem menuItem) {
        MenuBar menuBar = this.getMenuBar();
        int n = menuBar.getMenuCount();
        Menu menu = null;
        int n2 = 0;
        while (n2 < n) {
            Menu menu2 = menuBar.getMenu(n2);
            if (menu2.getLabel().equals(string)) {
                menu = menu2;
                break;
            }
            ++n2;
        }
        if (menu == null) {
            menu = new Menu(string);
            menuBar.add(menu);
        }
        menu.add(menuItem);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        Component component = (Component)componentEvent.getSource();
        Point point = component.getLocationOnScreen();
        this.windowX = point.x;
        this.windowY = point.y;
        this.windowChanged = true;
    }

    public void componentResized(ComponentEvent componentEvent) {
        Component component = (Component)componentEvent.getSource();
        Dimension dimension = component.getSize();
        this.windowWidth = dimension.width;
        this.windowHeight = dimension.height;
        this.windowChanged = true;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (!this.mainTool.loggingOut) {
            if (this.windowChanged) {
                this.saveWindowPos();
            }
            this.mainTool.exitAction();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

