/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.AolPopup;
import component.FolderInfo;
import component.PopupUI;
import component.SetupUI;
import component.Tools;
import java.util.Vector;
import main.BOSCore;
import main.Nickname;
import main.PopupAPI;
import uiutil.IUtil;
import uiutil.PropertySheet;
import util.KeyBindings;
import util.Log;
import util.Timer;
import util.TimerEvent;
import util.TimerListener;

public class PopupCore
implements PopupAPI,
TimerListener {
    private static final String MODULE = "Popup";
    private static final String MODULE_NAME = "tool.popup";
    private static final String[] UIPACK_NAMES = new String[]{"tool.popup"};
    private static final String DISPLAY_NAME = "Popup";
    private Vector popupQueue = new Vector();
    private boolean idle = false;
    private TimerEvent timerEvent;

    public PopupCore(BOSCore bOSCore, Tools tools) {
    }

    public void displayPopup(String string, String string2, int n, int n2, int n3) {
        Log.log("Popup", Log.INFO, "got popup: delay=" + n3 + "s width=" + n + " height=" + n2 + " url=" + string2 + " data=" + string);
        int n4 = IUtil.getIdleTime();
        if (n4 >= n3) {
            new PopupUI(string, string2, n, n2, this);
            return;
        }
        this.queueSortedByDelay(new AolPopup(string, string2, n, n2, n3));
        this.updateTimer(n4, this.popupQueue);
    }

    private synchronized void printQueue() {
        long l = -1L;
        if (this.timerEvent != null) {
            l = System.currentTimeMillis() - this.timerEvent.getActivationTime();
        }
        Log.log("Popup", Log.INFO, "Core: timerEvent=(" + l + "ms) " + this.timerEvent);
        int n = 0;
        while (n < this.popupQueue.size()) {
            AolPopup aolPopup = (AolPopup)this.popupQueue.elementAt(n);
            Log.log("Popup", Log.INFO, "Core: popup[" + n + "]=" + aolPopup);
            ++n;
        }
    }

    private synchronized void queueSortedByDelay(AolPopup aolPopup) {
        int n = 0;
        while (n < this.popupQueue.size()) {
            AolPopup aolPopup2 = (AolPopup)this.popupQueue.elementAt(n);
            if (aolPopup.delay < aolPopup2.delay) {
                this.popupQueue.insertElementAt(aolPopup, n);
                break;
            }
            ++n;
        }
        if (n == this.popupQueue.size()) {
            this.popupQueue.addElement(aolPopup);
        }
    }

    private synchronized void updateTimer(int n, Vector vector) {
        if (vector.size() > 0) {
            AolPopup aolPopup = (AolPopup)vector.firstElement();
            int n2 = Integer.MAX_VALUE;
            int n3 = aolPopup.delay - n;
            if (n3 < 0) {
                n3 = 0;
            }
            if (this.timerEvent != null && (n2 = (int)((System.currentTimeMillis() - this.timerEvent.getActivationTime()) / 1000L)) < 0) {
                n2 = 0;
            }
            if (n3 < n2) {
                if (this.timerEvent != null) {
                    Timer.removeEvent(this.timerEvent);
                }
                this.timerEvent = Timer.createEvent("System", this, 0, null, n3 * 1000);
            }
        }
    }

    public void timerEvent(String string, int n, Object object) {
        AolPopup aolPopup = (AolPopup)this.popupQueue.firstElement();
        int n2 = IUtil.getIdleTime();
        if (n2 >= aolPopup.delay) {
            this.popupQueue.removeElement(aolPopup);
            new PopupUI(aolPopup.data, aolPopup.url, aolPopup.widthHint, aolPopup.heightHint, this);
        }
        this.timerEvent = null;
        this.updateTimer(n2, this.popupQueue);
    }

    public void updateUserInfo(Nickname nickname) {
    }

    public void updateUserEvil(String string, int n) {
    }

    public void updateRate() {
    }

    public void setEnabled(boolean bl) {
    }

    public void connect() {
    }

    public void disconnect() {
    }

    public int id() {
        return 1;
    }

    public int version() {
        return 1;
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        return null;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        return null;
    }

    public void exportProperties(KeyBindings keyBindings, KeyBindings keyBindings2) {
    }

    public void importProperties(KeyBindings keyBindings, KeyBindings keyBindings2, KeyBindings keyBindings3, boolean bl) {
    }

    public boolean initiate(Vector vector, KeyBindings keyBindings) {
        return true;
    }

    public void shutdown() {
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getDisplayName() {
        return "Popup";
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }
}

