/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.BillBoard;
import component.LabelButton;
import component.OscarLabelButton;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Hashtable;
import main.Oscar;
import uiutil.ColorSelector;
import uiutil.HorizontalRule;
import uiutil.Icon;
import uiutil.ImageButton;
import uiutil.ImageLabel;
import uiutil.ImagePanel;
import uiutil.SLCommandListener;
import uiutil.Spacer;
import uiutil.SuperLayout;
import uiutil.UIPack;
import uiutil.UrlViewer;
import util.JUtil;
import util.Log;

public class SLCommandHandler
implements SLCommandListener,
ActionListener,
ComponentListener {
    Hashtable minSizes = new Hashtable();
    private static final String MODULE = "SLCommandHandler";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean processCommand(SuperLayout superLayout, UIPack uIPack, Container container, String string) {
        Log.log(MODULE, Log.DB3, "Processing Command: " + string);
        if (string.startsWith("*ADD_AD")) {
            Hashtable hashtable = SLCommandHandler.parseCommand(string);
            if (hashtable == null) {
                return false;
            }
            int n = SLCommandHandler.getInt(hashtable, "Width", 120);
            int n2 = SLCommandHandler.getInt(hashtable, "Height", 60);
            int n3 = SLCommandHandler.getInt(hashtable, "AdId", 0);
            if (n3 == 0) {
                return false;
            }
            int n4 = 0;
            String string2 = (String)hashtable.get("AdType");
            if (string2 != null) {
                n4 = string2.equals("BUDDY") ? 2 : SLCommandHandler.getInt(hashtable, "AdType", 0);
            }
            container.add((String)hashtable.get("COMPONENT"), new BillBoard(n, n2, n3, n4));
            return true;
        } else if (string.startsWith("*ADD_BUTTON")) {
            Hashtable hashtable = SLCommandHandler.parseCommand(string);
            if (hashtable == null) {
                return false;
            }
            String string3 = (String)hashtable.get("ButtonType");
            if (string3 == null) {
                return false;
            }
            String string4 = (String)hashtable.get("Label");
            String string5 = (String)hashtable.get("Image");
            String string6 = (String)hashtable.get("URL");
            String string7 = (String)hashtable.get("Caption");
            Color color = Color.black;
            String string8 = (String)hashtable.get("DepressedColor");
            if (string8 != null) {
                color = ColorSelector.getColor(string8.toLowerCase());
            }
            if (string3.equals("ImageButton")) {
                if (string5 == null) {
                    return false;
                }
                ImageButton imageButton = OscarLabelButton.makeImageButton(uIPack, container, string5);
                if (string7 != null) {
                    imageButton.setPopupText(string7);
                }
                if (string6 != null) {
                    imageButton.addActionListener(this);
                    imageButton.setActionCommand(string6);
                }
                container.add((String)hashtable.get("COMPONENT"), imageButton);
                return true;
            } else if (string3.equals("OscarLabelButton")) {
                if (string4 == null) {
                    return false;
                }
                OscarLabelButton oscarLabelButton = new OscarLabelButton(string4, uIPack, container);
                if (string7 != null) {
                    oscarLabelButton.setPopupText(string7);
                }
                if (string6 != null) {
                    oscarLabelButton.addActionListener(this);
                    oscarLabelButton.setActionCommand(string6);
                }
                container.add((String)hashtable.get("COMPONENT"), oscarLabelButton);
                return true;
            } else if (string3.equals("LabelButton")) {
                if (string4 == null || string5 == null) {
                    return false;
                }
                LabelButton labelButton = new LabelButton(string5, string4, color, uIPack, container);
                if (string7 != null) {
                    labelButton.setPopupText(string7);
                }
                if (string6 != null) {
                    labelButton.addActionListener(this);
                    labelButton.setActionCommand(string6);
                }
                container.add((String)hashtable.get("COMPONENT"), labelButton);
                return true;
            } else {
                if (!string3.equals("Button")) return false;
                if (string4 == null) {
                    return false;
                }
                Button button = new Button(string4);
                if (string6 != null) {
                    button.addActionListener(this);
                    button.setActionCommand(string6);
                }
                container.add((String)hashtable.get("COMPONENT"), button);
            }
            return true;
        } else if (string.startsWith("*ADD_IMAGE")) {
            Image image;
            Hashtable hashtable = SLCommandHandler.parseCommand(string);
            if (hashtable == null) {
                return false;
            }
            String string9 = (String)hashtable.get("Image");
            String string10 = (String)hashtable.get("Cache");
            if (string9 == null) {
                return false;
            }
            boolean bl = true;
            if (string10 != null) {
                bl = JUtil.isTrue(string10);
            }
            if ((image = Oscar.images.getImage(uIPack, string9, container, bl)) == null) {
                return false;
            }
            Dimension dimension = new Dimension(image.getWidth(container), image.getHeight(container));
            Icon icon = new Icon(dimension.width, dimension.height);
            icon.setImage(image);
            container.add((String)hashtable.get("COMPONENT"), icon);
            return true;
        } else if (string.startsWith("*ADD_HR")) {
            Hashtable hashtable = SLCommandHandler.parseCommand(string);
            if (hashtable == null) {
                return false;
            }
            container.add((String)hashtable.get("COMPONENT"), new HorizontalRule());
            return true;
        } else if (string.startsWith("*ADD_AWT")) {
            Hashtable hashtable = SLCommandHandler.parseCommand(string);
            if (hashtable == null) {
                return false;
            }
            String string11 = (String)hashtable.get("Label");
            if (string11 == null) {
                return false;
            }
            String string12 = (String)hashtable.get("Alignment");
            int n = 0;
            if (string12 != null) {
                if ((string12 = string12.toLowerCase()).equals("right")) {
                    n = 2;
                } else if (string12.equals("center")) {
                    n = 1;
                }
            }
            Label label = new Label(string11, n);
            container.add((String)hashtable.get("COMPONENT"), label);
            return true;
        } else if (string.startsWith("*ADD_LABEL")) {
            Hashtable hashtable = SLCommandHandler.parseCommand(string);
            if (hashtable == null) {
                return false;
            }
            String string13 = (String)hashtable.get("Label");
            if (string13 == null) {
                return false;
            }
            String string14 = (String)hashtable.get("Alignment");
            int n = SLCommandHandler.getInt(hashtable, "VPad", 5);
            int n5 = SLCommandHandler.getInt(hashtable, "HPad", 5);
            int n6 = 2;
            if (string14 != null) {
                if ((string14 = string14.toLowerCase()).equals("right")) {
                    n6 = 3;
                } else if (string14.equals("center")) {
                    n6 = 1;
                }
            }
            ImageLabel imageLabel = new ImageLabel(string13, n6, n5, n);
            container.add((String)hashtable.get("COMPONENT"), imageLabel);
            return true;
        } else if (string.startsWith("*ADD_SPACER")) {
            String[] stringArray = JUtil.smartSplit(string, ' ');
            if (stringArray.length < 2) {
                return false;
            }
            container.add(stringArray[1], new Spacer());
            return true;
        } else if (string.startsWith("*SET_BGCOLOR") || string.startsWith("*SET_FGCOLOR")) {
            String[] stringArray = JUtil.smartSplit(string, ' ');
            if (stringArray.length < 2) {
                return false;
            }
            Component component = container;
            if (stringArray.length == 3 && (component = superLayout.getLayoutComponent(stringArray[2])) == null) {
                return false;
            }
            Color color = null;
            color = ColorSelector.getColor(stringArray[1].toLowerCase());
            if (color == null) return true;
            if (string.startsWith("*SET_BGCOLOR")) {
                component.setBackground(color);
                return true;
            } else {
                component.setForeground(color);
            }
            return true;
        } else if (string.startsWith("*INCLUDE")) {
            String[] stringArray = JUtil.smartSplit(string, ' ');
            if (stringArray.length < 2) {
                return false;
            }
            superLayout.loadLayout(stringArray[1]);
            return true;
        } else if (string.startsWith("*SET_FMINSIZE")) {
            String[] stringArray = JUtil.smartSplit(string, ' ');
            if (stringArray.length < 3) {
                return false;
            }
            try {
                int n = Integer.parseInt(stringArray[1]);
                int n7 = Integer.parseInt(stringArray[2]);
                Dimension dimension = new Dimension(n, n7);
                Container container2 = container.getParent();
                while (!(container2 instanceof Frame)) {
                    container2 = container2.getParent();
                }
                this.minSizes.put(container2, dimension);
                container2.addComponentListener(this);
                superLayout.setMinHint(n, n7);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        } else if (string.startsWith("*SET_FDEFSIZE")) {
            String[] stringArray = JUtil.smartSplit(string, ' ');
            if (stringArray.length < 3) {
                return false;
            }
            try {
                int n = Integer.parseInt(stringArray[1]);
                int n8 = Integer.parseInt(stringArray[2]);
                Container container3 = container.getParent();
                while (!(container3 instanceof Frame)) {
                    container3 = container3.getParent();
                }
                superLayout.setMinHint(n, n8);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            if (!string.startsWith("*SET_TILE")) return true;
            String[] stringArray = JUtil.smartSplit(string, ' ');
            if (stringArray.length < 2) {
                return false;
            }
            Image image = Oscar.images.getImage(uIPack, stringArray[1], container, true);
            if (image == null) {
                return false;
            }
            if (!(container instanceof ImagePanel)) return true;
            ((ImagePanel)container).setTile(image);
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        new UrlViewer(string);
    }

    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        Dimension dimension = (Dimension)this.minSizes.get(component);
        Dimension dimension2 = component.getSize();
        boolean bl = false;
        if (dimension.width > dimension2.width) {
            dimension2.width = dimension.width;
            bl = true;
        }
        if (dimension.height > dimension2.height) {
            dimension2.height = dimension.height;
            bl = true;
        }
        if (bl) {
            Log.log(MODULE, Log.DB3, "Making bigger to " + dimension2);
            component.setVisible(false);
            component.setSize(dimension2.width, dimension2.height);
            component.setVisible(true);
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public static void addActionListener(Component component, ActionListener actionListener) {
        if (component instanceof Button) {
            ((Button)component).addActionListener(actionListener);
            return;
        }
        if (component instanceof ImageButton) {
            ((ImageButton)component).addActionListener(actionListener);
        }
    }

    public static int getInt(Hashtable hashtable, String string, int n) {
        String string2 = (String)hashtable.get(string);
        if (string2 == null) {
            return n;
        }
        try {
            if (string2.startsWith("0x")) {
                return Integer.parseInt(string2.substring(2), 16);
            }
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Hashtable parseCommand(String var0) {
        var1_1 = new Hashtable<String, String>();
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = var0.length();
        while (var3_3 < var4_4 && var0.charAt(var3_3) == ' ') {
            ++var3_3;
        }
        while (var3_3 < var4_4) {
            var5_5 = var3_3;
            while (var3_3 < var4_4 && var0.charAt(var3_3) != ' ' && var0.charAt(var3_3) != '=') {
                ++var3_3;
            }
            var6_6 = var3_3;
            if (var3_3 == var4_4 || var0.charAt(var3_3) == ' ') {
                if (var2_2 == 0) {
                    var1_1.put("COMMAND", var0.substring(var5_5, var6_6));
                } else if (var2_2 == 1) {
                    var1_1.put("COMPONENT", var0.substring(var5_5, var6_6));
                }
                while (var3_3 < var4_4 && var0.charAt(var3_3) == ' ') {
                    ++var3_3;
                }
                ++var2_2;
                continue;
            }
            if (++var3_3 >= var4_4) break;
            var7_7 = var0.charAt(var3_3);
            if (var7_7 != '\'' && var7_7 != '\"') {
                var7_7 = '\u0000';
            } else {
                ++var3_3;
            }
            if (var3_3 < var4_4) ** GOTO lbl37
            break;
            while (var0.charAt(var3_3) != var7_7) {
                ++var3_3;
lbl37:
                // 2 sources

                if (var3_3 < var4_4 && (var0.charAt(var3_3) != ' ' || var7_7 != '\u0000')) continue;
            }
            if (var7_7 == '\u0000') {
                var1_1.put(var0.substring(var5_5, var6_6), var0.substring(var6_6 + 1, var3_3));
            } else {
                var1_1.put(var0.substring(var5_5, var6_6), var0.substring(var6_6 + 2, var3_3));
                ++var3_3;
            }
            while (var3_3 < var4_4 && var0.charAt(var3_3) == ' ') {
                ++var3_3;
            }
        }
        if (var2_2 < 2) {
            return null;
        }
        return var1_1;
    }
}

