/*
 * Decompiled with CFR 0.152.
 */
package flap;

import flap.FLAPSockListener;
import flap.FlapError;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import proxy.ProxyBaseConnector;
import proxy.ProxyConnectorException;
import snac.SnacConstants;
import snac.TLV;
import uiutil.ErrorMgr;
import util.InputBuffer;
import util.JUtil;
import util.Log;
import util.OutputBuffer;
import util.Timer;
import util.TimerListener;

public class FLAPSock
implements Runnable,
SnacConstants,
TimerListener {
    private static String MODULE = "FLAP";
    private static final byte START_MARKER = 42;
    private boolean debugging = true;
    public static int OK;
    public static int DATA_TOO_LARGE;
    public static int CANT_WRITE;
    public static int BAD_DATA;
    public static int CONNECTION_CLOSED;
    private static int SIGNON;
    private static int DATA;
    private static int ERROR;
    private static int SIGNOFF;
    private static int PROTOCOL_VERSION_NUM;
    private static byte[] PROTOCOL_VERSION;
    private static int MAX_SEQ_NO;
    private static int FLAP_HEADER_LEN;
    private static int MAX_FLAP_DATA_SIZE;
    private static int MAX_RETRIES;
    private static int FLAP_OPEN_NEEDED;
    private static int FLAP_DISCONNECTED;
    private static int FLAP_INACTIVE;
    private static int FLAP_SIGNON;
    private static int FLAP_ERROR;
    private static int FLAP_DATA;
    private static int FLAP_SIGNOFF;
    private static int WAIT_FOR_SIGNON;
    private static int SIGNON_TIMEOUT_EVENT;
    private static int WAIT_FOR_DATA_OR_SIGNOFF;
    private static int DATA_OR_SIGNOFF_TIMEOUT_EVENT;
    private static int MIGRATE_WINDOW;
    private int state = FLAP_DISCONNECTED;
    private FLAPSockListener listener;
    private String purpose = "";
    private String host = "";
    private int port = -1;
    private String name = "";
    private Socket connection;
    private DataInputStream in;
    private DataOutputStream out;
    private Thread reader;
    private int lastSeqNoSent = -1;
    private int lastSeqNoRecieved = -1;
    private int incomingType;
    private int incomingSeqNo;
    private int incomingLen;
    public long connectTime = -1L;
    private int msgsSent;
    private int bytesSent;
    private int msgsRecieved;
    private int bytesRecieved;
    private int migrations;
    private boolean signonRecieved = false;
    public Object userData;
    private String migrationCookie;
    private boolean closeExpected = false;
    private int numRetries;
    private ProxyBaseConnector connector;

    private static void initFLAPSockClass() {
        if (PROTOCOL_VERSION == null) {
            try {
                OutputBuffer outputBuffer = new OutputBuffer(4);
                outputBuffer.writeInt(PROTOCOL_VERSION_NUM);
                PROTOCOL_VERSION = outputBuffer.bytes();
                return;
            }
            catch (Exception exception) {
                ErrorMgr.error(MODULE, "can't initialize FLAP layer");
                return;
            }
        }
    }

    public FLAPSock(FLAPSockListener fLAPSockListener, String string, String string2, int n, ProxyBaseConnector proxyBaseConnector) throws IOException {
        if (fLAPSockListener == null) {
            ErrorMgr.error(MODULE, "constructing FLAPSock with no listener");
        }
        this.listener = fLAPSockListener;
        this.connector = proxyBaseConnector;
        this.setName(string, string2, n);
        FLAPSock.initFLAPSockClass();
        this.openConnectionWithRetry();
    }

    public FLAPSock(FLAPSockListener fLAPSockListener, String string, Socket socket) throws IOException {
        if (fLAPSockListener == null) {
            ErrorMgr.error(MODULE, "constructing FLAPSock with no listener");
        }
        this.listener = fLAPSockListener;
        this.setName(string, "", -1);
        FLAPSock.initFLAPSockClass();
        this.connection = socket;
        FlapError flapError = this.setupFLAPSock();
        if (flapError != null) {
            if (flapError.exc != null) {
                throw flapError.exc;
            }
            throw new IOException("can't open connection");
        }
    }

    private synchronized void openConnectionWithRetry() {
        this.state = FLAP_OPEN_NEEDED;
        this.numRetries = 0;
        if (this.reader == null) {
            this.reader = new Thread((Runnable)this, String.valueOf(this.name) + " read Thread");
            this.reader.start();
        }
    }

    private FlapError openConnectionWithRetryInternal() {
        Log.log(MODULE, Log.DB1, "opening connection to " + this.host + ":" + this.port);
        if (this.host == null || this.host.equals("*") || this.host.equals("")) {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (IOException iOException) {
                this.host = "127.0.0.1";
            }
        }
        try {
            this.connection = this.connector.makeConnection(this.host, this.port);
            if (this.connection == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            boolean bl = true;
            if (this.listener != null) {
                bl = this.listener.FLAPConnectionRetry(this);
            }
            if (bl && this.numRetries < MAX_RETRIES) {
                ++this.numRetries;
                try {
                    Thread.sleep(5000 * this.numRetries);
                }
                catch (InterruptedException interruptedException) {}
                return this.openConnectionWithRetryInternal();
            }
            if (this.listener != null) {
                this.listener.FLAPConnectionFailed(this);
            }
            return new FlapError("error connecting to " + this.host, 12, iOException);
        }
        catch (ProxyConnectorException proxyConnectorException) {
            if (this.listener != null) {
                this.listener.FLAPConnectionFailed(this);
            }
            switch (proxyConnectorException.getErrorCode()) {
                case 2: {
                    return new FlapError("can't resolve address for " + this.host, 24);
                }
                case 0: {
                    return new FlapError("can't connect to proxy host", 24);
                }
            }
            return new FlapError(proxyConnectorException.getMessage(), 12);
        }
        return this.setupFLAPSock();
    }

    private synchronized FlapError setupFLAPSock() {
        try {
            this.connection.setTcpNoDelay(false);
        }
        catch (SocketException socketException) {}
        this.connectTime = System.currentTimeMillis();
        this.closeExpected = false;
        try {
            this.in = new DataInputStream(this.connection.getInputStream());
            this.out = new DataOutputStream(this.connection.getOutputStream());
        }
        catch (IOException iOException) {
            return new FlapError("can't open connection", 12, iOException);
        }
        if (this.reader == null) {
            this.reader = new Thread((Runnable)this, String.valueOf(this.name) + " read Thread");
            this.reader.start();
        }
        this.state = FLAP_INACTIVE;
        this.signonRecieved = false;
        if (this.listener != null) {
            this.listener.FLAPConnectionEstablished(this);
        }
        if (this.migrationCookie != null) {
            this.sendSignOn(this.migrationCookie);
            this.migrationCookie = null;
        }
        return null;
    }

    private void setName(String string, String string2, int n) {
        this.purpose = string;
        this.host = string2;
        this.port = n;
        String string3 = "";
        if (n != -1) {
            string3 = ":" + n;
        }
        String string4 = "";
        if (string2 != "") {
            string4 = "@" + string2;
        }
        this.name = String.valueOf(string) + string4 + string3;
    }

    public String toString() {
        return "FLAPSock " + this.name;
    }

    public String dbg() {
        String string = "";
        try {
            string = this.reader.toString();
        }
        catch (NullPointerException nullPointerException) {
            string = "read thread had problems printing";
        }
        return "FLAPSock " + this.name + " state " + this.state + " listener " + this.listener + " connection " + this.connection + " in " + this.in + " out " + this.out + " reader " + string + " lastSeqNoSent " + this.lastSeqNoSent + " lastSeqNoRecieved " + this.lastSeqNoRecieved + " incomingType " + this.incomingType + " incomingSeqNo " + this.incomingSeqNo + " incomingLen " + this.incomingLen + " connectTime " + this.connectTime + " msgsSent " + this.msgsSent + " bytesSent " + this.bytesSent + " msgsRecieved " + this.msgsRecieved + " bytesRecieved " + this.bytesRecieved + " migrations " + this.migrations + " signonRecieved " + this.signonRecieved + " userData " + this.userData;
    }

    public synchronized void close() {
        this.close(null, 21);
    }

    public synchronized void close(String string, int n) {
        try {
            Log.log("in FLAPSock::close " + string);
            if (this.reader != null) {
                if (this.reader != Thread.currentThread()) {
                    this.reader.interrupt();
                    this.reader.stop();
                }
                this.reader = null;
            }
            this.state = FLAP_DISCONNECTED;
            if (!this.closeExpected && this.listener != null) {
                if (string == null) {
                    this.listener.FLAPConnectionClosed(this, true, "", n);
                } else {
                    this.listener.FLAPConnectionClosed(this, false, string, n);
                }
                this.listener = null;
            }
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
                return;
            }
        }
        catch (IOException iOException) {
            ErrorMgr.error(MODULE, "close exception " + iOException.getMessage() + " in " + this.name);
        }
    }

    public synchronized void closeExpected(boolean bl) {
        this.closeExpected = bl;
    }

    public synchronized boolean migrate(String string, int n, String string2) {
        try {
            Log.log(MODULE, Log.DB1, "in FLAPSock::migrate");
            FLAPSockListener fLAPSockListener = this.listener;
            this.listener = null;
            Log.log("s1 " + this.listener);
            this.close();
            Log.log("s2 " + this.listener);
            this.listener = fLAPSockListener;
            this.lastSeqNoSent = -1;
            this.lastSeqNoRecieved = -1;
            this.setName(this.purpose, string, n);
            ++this.migrations;
            this.migrationCookie = string2;
            Log.log("s3 " + this.listener);
            this.openConnectionWithRetry();
            Log.log("s4 " + this.listener);
            return true;
        }
        catch (Exception exception) {
            ErrorMgr.diag(MODULE, "migration error", exception);
            this.close("migration error", 29);
            return false;
        }
    }

    public synchronized boolean isDisconnected() {
        return this.state == FLAP_DISCONNECTED;
    }

    public synchronized boolean isInactive() {
        return this.state == FLAP_INACTIVE;
    }

    public synchronized boolean gotSignOn() {
        return this.state == FLAP_SIGNON;
    }

    public synchronized boolean gotSignOff() {
        return this.state == FLAP_SIGNOFF;
    }

    public synchronized boolean gotData() {
        return this.state == FLAP_DATA;
    }

    public synchronized boolean gotError() {
        return this.state == FLAP_ERROR;
    }

    public boolean okToSendData() {
        return this.gotSignOn() || this.gotData();
    }

    public synchronized void setListener(FLAPSockListener fLAPSockListener) {
        if (fLAPSockListener == null) {
            ErrorMgr.error(MODULE, "setListener called with no listener");
        }
        this.listener = fLAPSockListener;
    }

    private int nextSeqNo() {
        if (this.lastSeqNoSent == -1) {
            this.lastSeqNoSent = (int)Math.floor(Math.random() * (double)MAX_SEQ_NO);
        }
        ++this.lastSeqNoSent;
        if (this.lastSeqNoSent >= MAX_SEQ_NO || this.lastSeqNoSent < 0) {
            this.lastSeqNoSent = 0;
        }
        return this.lastSeqNoSent;
    }

    private synchronized int sendFLAP(int n, int n2, byte[] byArray, byte[] byArray2, TLV tLV) throws IOException {
        if (this.isDisconnected() || this.gotError() || this.gotSignOff()) {
            ErrorMgr.diag(MODULE, "writing to bad connection " + this.state + " in " + this.name);
            return CANT_WRITE;
        }
        if (n < SIGNON || n > SIGNOFF) {
            ErrorMgr.diag(MODULE, "bad type " + n + " in " + this.name);
            return BAD_DATA;
        }
        int n3 = 0;
        if (byArray != null) {
            n3 += byArray.length;
        }
        if (byArray2 != null) {
            n3 += byArray2.length;
        }
        if (tLV != null) {
            n3 += tLV.tlvVectorLength();
        }
        if (n3 > MAX_FLAP_DATA_SIZE) {
            ErrorMgr.diag(MODULE, "msg too large " + n3 + " in " + this.name);
            return DATA_TOO_LARGE;
        }
        OutputBuffer outputBuffer = new OutputBuffer(FLAP_HEADER_LEN);
        outputBuffer.writeByte(42);
        outputBuffer.writeByte(n);
        outputBuffer.writeShort(n2);
        outputBuffer.writeShort(n3);
        if (byArray != null) {
            outputBuffer.write(byArray, 0, byArray.length);
        }
        if (byArray2 != null) {
            outputBuffer.write(byArray2, 0, byArray2.length);
        }
        if (tLV != null) {
            tLV.writeTlvVector(outputBuffer.d);
        }
        if (this.debugging) {
            Log.log(MODULE, "wrote " + (FLAP_HEADER_LEN + n3) + " bytes <including " + FLAP_HEADER_LEN + " byte flap header> " + JUtil.toHexString(outputBuffer.bytes()));
        }
        this.out.write(outputBuffer.bytes(), 0, outputBuffer.size());
        this.out.flush();
        ++this.msgsSent;
        this.bytesSent += n3 + FLAP_HEADER_LEN;
        Log.log(MODULE, "sent type " + n + " seq " + n2 + " len " + n3);
        return OK;
    }

    private int sendSignOn(String string) {
        TLV tLV = null;
        if (string != null) {
            tLV = new TLV(2);
            tLV.addTlv(6, string);
        }
        return this.sendSignOn(tLV);
    }

    public int sendSignOn(TLV tLV) {
        try {
            Timer.createEvent("System", this, SIGNON_TIMEOUT_EVENT, null, WAIT_FOR_SIGNON);
            return this.sendFLAP(SIGNON, this.nextSeqNo(), null, PROTOCOL_VERSION, tLV);
        }
        catch (IOException iOException) {
            ErrorMgr.diag(MODULE, "exception in sendSignOn", iOException);
            this.close("exception in sendSignOn " + iOException.getMessage(), 29);
            return CONNECTION_CLOSED;
        }
    }

    public int sendData(byte[] byArray, byte[] byArray2) {
        try {
            return this.sendFLAP(DATA, this.nextSeqNo(), byArray, byArray2, null);
        }
        catch (IOException iOException) {
            ErrorMgr.diag(MODULE, "exception in sendData", iOException);
            this.close("exception in sendData " + iOException.getMessage(), 29);
            return CONNECTION_CLOSED;
        }
    }

    public int sendData(byte[] byArray) {
        return this.sendData(null, byArray);
    }

    public int sendError(int n, String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(n);
            if (string != null) {
                dataOutputStream.writeBytes(string);
            }
            return this.sendFLAP(ERROR, this.nextSeqNo(), null, byteArrayOutputStream.toByteArray(), null);
        }
        catch (IOException iOException) {
            ErrorMgr.diag(MODULE, "exception in sendError", iOException);
            this.close("exception in sendError " + iOException.getMessage(), 29);
            return CONNECTION_CLOSED;
        }
    }

    public int sendSignOff(TLV tLV) {
        try {
            return this.sendFLAP(SIGNOFF, this.nextSeqNo(), null, null, tLV);
        }
        catch (IOException iOException) {
            return CONNECTION_CLOSED;
        }
    }

    private boolean updateSeqNo() {
        if (this.lastSeqNoRecieved != -1 && this.incomingSeqNo != this.lastSeqNoRecieved + 1) {
            boolean bl;
            boolean bl2 = bl = this.incomingSeqNo == 0 && this.lastSeqNoRecieved == MAX_SEQ_NO;
            if (!bl) {
                return false;
            }
        }
        this.lastSeqNoRecieved = this.incomingSeqNo;
        return true;
    }

    private FlapError readFLAPHeader() throws IOException {
        if (this.isDisconnected() || this.gotError() || this.gotSignOff()) {
            return new FlapError("reading header from bad connection " + this.state, 22);
        }
        int n = -1;
        n = this.in.readByte();
        if (n != 42) {
            this.dump();
            return new FlapError("bad start marker 0x" + Integer.toHexString(n), 22);
        }
        this.incomingType = this.in.readByte() & 0xFF;
        this.incomingSeqNo = this.in.readUnsignedShort();
        this.incomingLen = this.in.readUnsignedShort();
        Log.log(MODULE, "read header type " + this.incomingType + " seq " + this.incomingSeqNo + " len " + this.incomingLen);
        return null;
    }

    private void dump() {
        String string = "FLAP DUMP " + this.dbg();
        try {
            byte by;
            while ((by = this.in.readByte()) != -1) {
                string = String.valueOf(string) + Integer.toHexString(by & 0xFF) + " ";
            }
        }
        catch (IOException iOException) {}
        Log.log(string);
    }

    private FlapError readFLAP() {
        Object object;
        try {
            object = this.readFLAPHeader();
            if (object != null) {
                return object;
            }
        }
        catch (IOException iOException) {
            return new FlapError("dropped network connection", 22, iOException);
        }
        if (this.isDisconnected() || this.gotError() || this.gotSignOff()) {
            return new FlapError("reading from bad connection " + this.state, 29);
        }
        if (this.incomingType < SIGNON || this.incomingType > SIGNOFF) {
            return new FlapError("read bad flap type " + this.incomingType, 22);
        }
        if (!this.signonRecieved && !(this.incomingType == SIGNON || this.incomingType == SIGNOFF)) {
            this.dump();
            return new FlapError("msg " + this.incomingType + " recieved before signon", 22);
        }
        if (this.signonRecieved && this.incomingType == SIGNON) {
            return new FlapError("duplicate signon recieved", 22);
        }
        if (!this.updateSeqNo()) {
            return new FlapError("read bad sequence number " + this.incomingSeqNo, 22);
        }
        if (this.incomingLen < 0 || this.incomingLen > MAX_FLAP_DATA_SIZE) {
            return new FlapError("read bad flap length " + this.incomingLen, 22);
        }
        ++this.msgsRecieved;
        try {
            object = new byte[this.incomingLen];
            int n = 0;
            while (n < this.incomingLen) {
                int n2 = this.in.read((byte[])object, n, this.incomingLen - n);
                if (n2 == -1) {
                    return new FlapError("unexpected EOF", 22);
                }
                n += n2;
            }
            InputBuffer inputBuffer = new InputBuffer((byte[])object);
            this.bytesRecieved += FLAP_HEADER_LEN + this.incomingLen;
            if (this.debugging) {
                Log.log(MODULE, "read " + this.incomingLen + " bytes <not including " + FLAP_HEADER_LEN + " byte flap header> " + JUtil.toHexString(inputBuffer.bytes()));
            }
            if (this.incomingType == SIGNON) {
                return this.handleSignOnFLAP(inputBuffer);
            }
            if (this.incomingType == DATA) {
                return this.handleDataFLAP(inputBuffer);
            }
            if (this.incomingType == ERROR) {
                return this.handleErrorFLAP(inputBuffer);
            }
            if (this.incomingType == SIGNOFF) {
                return this.handleSignOffFLAP(inputBuffer);
            }
            return new FlapError("read bad flap type " + this.incomingType, 22);
        }
        catch (IOException iOException) {
            return new FlapError("lost connection", 29, iOException);
        }
    }

    private synchronized FlapError handleSignOnFLAP(InputBuffer inputBuffer) throws IOException {
        Log.log(MODULE, Log.DB1, "handleSignOn");
        if (inputBuffer.available() < 4) {
            return new FlapError("signon flap too small " + inputBuffer.available(), 22);
        }
        long l = JUtil.readU32(inputBuffer.d);
        Log.log(MODULE, "incoming FLAP version " + l);
        if (l > (long)PROTOCOL_VERSION_NUM) {
            return new FlapError("read bad flap version " + l, 22);
        }
        TLV tLV = new TLV();
        tLV.readTlvVector(inputBuffer.d, inputBuffer.available());
        if (inputBuffer.available() != 0) {
            return new FlapError("read too much signon data, " + inputBuffer.available(), 22);
        }
        this.state = FLAP_SIGNON;
        this.signonRecieved = true;
        Timer.createEvent("System", this, DATA_OR_SIGNOFF_TIMEOUT_EVENT, null, WAIT_FOR_DATA_OR_SIGNOFF);
        if (this.listener != null) {
            this.listener.FLAPSignOn(this, tLV);
        }
        Log.log("done");
        return null;
    }

    public void timerEvent(String string, int n, Object object) {
        FLAPSock fLAPSock = this;
        synchronized (fLAPSock) {
            if (n == SIGNON_TIMEOUT_EVENT && this.state == FLAP_INACTIVE) {
                if (this.listener != null) {
                    this.listener.FLAPSignOnTimeout(this);
                    this.close("timeout waiting for signon", 29);
                }
            } else if (n == DATA_OR_SIGNOFF_TIMEOUT_EVENT && this.state == FLAP_SIGNON && this.listener != null) {
                this.listener.FLAPDataOrSignOffTimeout(this);
                this.close("timeout waiting for data or signoff", 29);
            }
            return;
        }
    }

    private synchronized FlapError handleDataFLAP(InputBuffer inputBuffer) throws IOException {
        byte[] byArray = inputBuffer.bytes();
        this.state = FLAP_DATA;
        if (this.listener != null) {
            this.listener.FLAPData(this, byArray);
        }
        return null;
    }

    private synchronized FlapError handleErrorFLAP(InputBuffer inputBuffer) throws IOException {
        long l = -1L;
        if (inputBuffer.available() < 4) {
            return new FlapError("error flap too small " + inputBuffer.available(), 22);
        }
        l = JUtil.readU32(inputBuffer.d);
        String string = "";
        if (inputBuffer.available() > 4) {
            byte[] byArray = new byte[inputBuffer.available()];
            inputBuffer.d.read(byArray, 0, inputBuffer.available());
            string = new String(byArray);
        }
        this.state = FLAP_ERROR;
        if (this.listener != null) {
            this.listener.FLAPError(this, l, string);
        }
        return new FlapError("got error flap " + l + " " + string, 29);
    }

    private synchronized FlapError handleSignOffFLAP(InputBuffer inputBuffer) throws IOException {
        Log.log(MODULE, Log.DB1, "handle signOff");
        TLV tLV = new TLV();
        tLV.readTlvVector(inputBuffer.d, inputBuffer.available());
        if (inputBuffer.available() != 0) {
            return new FlapError("unexpected data in signoff " + inputBuffer.available(), 22);
        }
        this.sendSignOff(null);
        this.state = FLAP_SIGNOFF;
        if (!this.closeExpected && this.listener != null) {
            this.listener.FLAPSignOff(this, tLV);
        }
        this.close();
        return null;
    }

    public void run() {
        Thread thread = this.reader;
        while (thread == this.reader) {
            FlapError flapError = null;
            if (this.state == FLAP_OPEN_NEEDED) {
                flapError = this.openConnectionWithRetryInternal();
            } else {
                if (this.isDisconnected()) {
                    return;
                }
                flapError = this.readFLAP();
            }
            if (flapError == null) continue;
            if (!this.closeExpected) {
                this.close(flapError.msg, flapError.reason);
                return;
            }
            this.close();
            return;
        }
    }

    static {
        DATA_TOO_LARGE = 1;
        CANT_WRITE = 2;
        BAD_DATA = 3;
        CONNECTION_CLOSED = 4;
        SIGNON = 1;
        DATA = 2;
        ERROR = 3;
        SIGNOFF = 4;
        PROTOCOL_VERSION_NUM = 1;
        PROTOCOL_VERSION = null;
        MAX_SEQ_NO = 65535;
        FLAP_HEADER_LEN = 6;
        MAX_FLAP_DATA_SIZE = 65529;
        MAX_RETRIES = 3;
        FLAP_OPEN_NEEDED = -2;
        FLAP_DISCONNECTED = -1;
        FLAP_SIGNON = 1;
        FLAP_ERROR = 2;
        FLAP_DATA = 3;
        FLAP_SIGNOFF = 4;
        WAIT_FOR_SIGNON = 180000;
        WAIT_FOR_DATA_OR_SIGNOFF = 20000;
        MIGRATE_WINDOW = 10000;
    }
}

