/*
 * Decompiled with CFR 0.152.
 */
package main;

import component.Tools;
import flap.FLAPSock;
import java.util.Vector;
import main.AdminAPI;
import main.AdminServerAPI;
import main.CallbackData;
import main.ClientDispatcher;
import main.Oscar;
import main.SnacConnectionHandler;
import snac.AdminHandler;
import snac.AdminListener;
import snac.ReqID;
import snac.ServiceHandler;
import snac.ServiceListener;
import snac.SnacAdmininfo;
import snac.SnacConstants;
import snac.SnacNicknameWinfo;
import snac.SnacVersion;
import snac.TLV;
import uiutil.ChoiceUI;
import util.Log;

public class AdminCore
extends SnacConnectionHandler
implements AdminServerAPI,
SnacConstants,
AdminListener,
ServiceListener {
    private static String MODULE = "Admin";
    private AdminAPI adminUI;
    private ClientDispatcher dispatcher;
    private FLAPSock adminBall;
    private int[] families;
    private Vector familyVersions;
    private static String moreInfo = "more info";
    static String[] adminErrors = new String[]{null, "validate nickame", "validate password", "validate email", "service temporarily unavailable", "field change temporarily unavailable", "invalid nickname", "invalid password", "invalid email", "invalid registration preference", "invalid old password", "invalid nickname length", "invalid password length", "invalid email length", "invalid old password length", "need old password", "read only field", "write only field", "unsupported type", "all other errors", "bad snac", "invalid account", "deleted account", "expired account", "no database access", "invalid database fields", "bad database status", "migration cancel", "internal error", "pending request", "not dt status", "outstanding confirm", "no email address", "over limit", "email host fail", "dns fail"};

    AdminCore(ClientDispatcher clientDispatcher, Tools tools, boolean bl) {
        this.dispatcher = clientDispatcher;
        this.adminBall = null;
        clientDispatcher.registerListener(1, 2, this);
        clientDispatcher.registerListener(7, 1, this);
    }

    public void installUI(AdminAPI adminAPI) {
        this.adminUI = adminAPI;
    }

    private int[] getFamilies() {
        if (this.families == null) {
            this.families = new int[2];
            this.families[0] = 1;
            this.families[1] = 7;
        }
        return this.families;
    }

    private Vector getFamilyVersions() {
        if (this.familyVersions == null) {
            this.familyVersions = new Vector();
            this.familyVersions.addElement(new SnacVersion(1, 2, 1, Oscar.buildNumber));
            this.familyVersions.addElement(new SnacVersion(7, 1, this.adminUI.id(), this.adminUI.version()));
        }
        return this.familyVersions;
    }

    public String toString() {
        return MODULE;
    }

    public void requestTimedOut(Object object) {
        if (this.adminUI != null) {
            this.adminUI.disconnect();
        }
        if (object == null) {
            return;
        }
        CallbackData callbackData = (CallbackData)object;
        if (callbackData.responseExpected) {
            this.warn(object, "The admin server is not responding", null);
        }
    }

    public boolean connectionSignOff(FLAPSock fLAPSock, TLV tLV, boolean bl) {
        if (fLAPSock == this.adminBall) {
            if (this.adminUI != null) {
                this.adminUI.disconnect();
            }
            return true;
        }
        return false;
    }

    public boolean connectionClosed(FLAPSock fLAPSock, boolean bl, String string, int n, boolean bl2) {
        if (fLAPSock == this.adminBall) {
            this.adminBall = null;
            if (this.adminUI != null) {
                this.adminUI.disconnect();
            }
            return true;
        }
        return false;
    }

    public int snacError(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, TLV tLV) {
        if (fLAPSock == this.adminBall) {
            if (this.adminUI != null) {
                this.adminUI.disconnect();
            }
            String string = tLV.getTlvDataAsString(4);
            int n3 = -1;
            if (tLV.tlvTypePresent(8)) {
                n3 = tLV.getTlvDataAsU16(8);
            }
            this.warn(object, this.lookup(SnacConnectionHandler.generalErrors, n2), string);
            return 1;
        }
        return 0;
    }

    public int adminInfoReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, Vector vector) {
        if (fLAPSock != this.adminBall) {
            return 0;
        }
        if (this.adminUI == null) {
            return 1;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            SnacAdmininfo snacAdmininfo = (SnacAdmininfo)vector.elementAt(n2);
            if (snacAdmininfo.tlvData.size() == 1) {
                if (snacAdmininfo.tlvData.tlvTypePresent(1)) {
                    this.adminUI.setNickname(snacAdmininfo.tlvData.getTlvDataAsString(1));
                } else if (snacAdmininfo.tlvData.tlvTypePresent(17)) {
                    this.adminUI.setEmailAddress(snacAdmininfo.tlvData.getTlvDataAsString(17));
                } else if (snacAdmininfo.tlvData.tlvTypePresent(19)) {
                    int n3 = snacAdmininfo.tlvData.getTlvDataAsU16(19);
                    Log.log(MODULE, Log.DB0, "Registration preference is " + n3);
                    if (n3 == 1) {
                        this.adminUI.setRegistrationStatus(1);
                    } else if (n3 == 2) {
                        this.adminUI.setRegistrationStatus(2);
                    } else if (n3 == 3) {
                        this.adminUI.setRegistrationStatus(3);
                    } else {
                        this.internalError("bad disclosure value in adminInfoReply");
                    }
                } else {
                    this.internalError("bad tlv type in adminInfoReply");
                }
            } else {
                String string = null;
                if (snacAdmininfo.tlvData.tlvTypePresent(8)) {
                    string = this.lookup(adminErrors, snacAdmininfo.tlvData.getTlvDataAsU16(8));
                }
                snacAdmininfo.tlvData.getTlvDataAsU16(8);
                String string2 = snacAdmininfo.tlvData.getTlvDataAsString(4);
                int n4 = -1;
                if (snacAdmininfo.tlvData.tlvTypePresent(1)) {
                    n4 = 0;
                } else if (snacAdmininfo.tlvData.tlvTypePresent(17)) {
                    n4 = 2;
                } else if (snacAdmininfo.tlvData.tlvTypePresent(19)) {
                    n4 = 3;
                }
                if (n4 == -1) {
                    this.internalError("bad part in adminInfoReply");
                } else {
                    this.adminUI.adminInfoError(n4, string, string2);
                }
            }
            ++n2;
        }
        return 1;
    }

    public int adminInfoChangeReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, Vector vector) {
        if (fLAPSock != this.adminBall) {
            return 0;
        }
        if (this.adminUI == null) {
            return 1;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            String string;
            SnacAdmininfo snacAdmininfo = (SnacAdmininfo)vector.elementAt(n2);
            int n3 = -1;
            if (snacAdmininfo.tlvData.tlvTypePresent(1)) {
                n3 = 0;
                string = snacAdmininfo.tlvData.getTlvDataAsString(1);
                if (string != null && string.length() > 0) {
                    Oscar.nickname = string;
                }
            } else if (snacAdmininfo.tlvData.tlvTypePresent(2)) {
                n3 = 1;
            } else if (snacAdmininfo.tlvData.tlvTypePresent(17)) {
                n3 = 2;
            } else if (snacAdmininfo.tlvData.tlvTypePresent(19)) {
                n3 = 3;
            }
            if (n3 == -1) {
                this.internalError("bad part in adminInfoChangeReply");
            } else if (snacAdmininfo.tlvData.size() == 1) {
                this.adminUI.changeSuccessful(n3);
            } else {
                string = null;
                if (snacAdmininfo.tlvData.tlvTypePresent(8)) {
                    string = this.lookup(adminErrors, snacAdmininfo.tlvData.getTlvDataAsU16(8));
                }
                String string2 = snacAdmininfo.tlvData.getTlvDataAsString(4);
                this.adminUI.changeFailed(n3, string, string2);
            }
            ++n2;
        }
        return 1;
    }

    public void requestAccountConfirmation() {
        if (this.adminBall != null && this.adminBall.okToSendData()) {
            AdminHandler adminHandler = (AdminHandler)this.dispatcher.getHandler(7);
            CallbackData callbackData = new CallbackData(null, false, true, 7, 6, "request confirmation of your account", null);
            adminHandler.acctConfirmRequest(this.adminBall, this, callbackData);
            return;
        }
        Log.log("adminCore - attempt to send data to bad flap " + this.adminBall);
    }

    public int adminAcctConfirmReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, TLV tLV) {
        if (fLAPSock != this.adminBall) {
            return 0;
        }
        if (this.adminUI == null) {
            return 1;
        }
        if (n2 != 0) {
            String string = tLV.getTlvDataAsString(4);
            String string2 = "Your attempt to confirm your account failed";
            if (string != null) {
                ChoiceUI.newChoiceUI(this, SnacConnectionHandler.WARNING_CHOICE, string, "Alert", string2, "OK", moreInfo, null, Oscar.WARNING_SOUND);
            } else {
                ChoiceUI.newChoiceUI(this, SnacConnectionHandler.BORING_CHOICE, null, "Alert", string2, "OK", null, null, Oscar.WARNING_SOUND);
            }
        }
        this.adminUI.accountConfirmationSent(n2 == 0);
        return 1;
    }

    public int adminAcctDeleteReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        if (fLAPSock != this.adminBall) {
            return 0;
        }
        if (this.adminUI == null) {
            return 1;
        }
        if (tLV.size() != 0) {
            String string = tLV.getTlvDataAsString(4);
            String string2 = "Your attempt to delete your account failed";
            if (tLV.tlvTypePresent(8)) {
                string2 = String.valueOf(string2) + " because of " + this.lookup(adminErrors, tLV.getTlvDataAsU16(8));
            }
            if (string != null) {
                ChoiceUI.newChoiceUI(this, SnacConnectionHandler.WARNING_CHOICE, string, "Alert", string2, "OK", moreInfo, null, Oscar.WARNING_SOUND);
            } else {
                ChoiceUI.newChoiceUI(this, SnacConnectionHandler.BORING_CHOICE, null, "Alert", string2, "OK", null, null, Oscar.WARNING_SOUND);
            }
            this.adminUI.accountDeletionFailed();
        }
        return 1;
    }

    private void sendAdminRequest(TLV tLV, boolean bl) {
        if (this.adminBall != null && this.adminBall.okToSendData()) {
            AdminHandler adminHandler = (AdminHandler)this.dispatcher.getHandler(7);
            if (bl) {
                CallbackData callbackData = new CallbackData(null, false, true, 7, 4, "change account information", null);
                adminHandler.infoChangeRequest(this.adminBall, this, callbackData, tLV);
                return;
            }
            CallbackData callbackData = new CallbackData(null, true, true, 7, 2, "request account information", null);
            adminHandler.infoQuery(this.adminBall, this, callbackData, tLV);
            return;
        }
        Log.log("adminCore - attempt to send data to bad flap " + this.adminBall);
    }

    public void getNickname() {
        TLV tLV = new TLV(1);
        tLV.addTlv(1);
        this.sendAdminRequest(tLV, false);
    }

    public void setNickname(String string) {
        TLV tLV = new TLV(1);
        tLV.addTlv(1, string);
        this.sendAdminRequest(tLV, true);
    }

    public void setPassword(String string, String string2) {
        TLV tLV = new TLV(2);
        tLV.addTlv(2, string);
        tLV.addTlv(18, string2);
        this.sendAdminRequest(tLV, true);
    }

    public void getEmailAddress() {
        TLV tLV = new TLV(1);
        tLV.addTlv(17);
        this.sendAdminRequest(tLV, false);
    }

    public void setEmailAddress(String string) {
        TLV tLV = new TLV(1);
        tLV.addTlv(17, string);
        this.sendAdminRequest(tLV, true);
    }

    public void getRegistrationStatus() {
        TLV tLV = new TLV(1);
        tLV.addTlv(19);
        this.sendAdminRequest(tLV, false);
    }

    public void setRegistrationStatus(int n) {
        TLV tLV = new TLV(1);
        tLV.addTlvU16(19, n);
        Log.log(MODULE, Log.DB0, "Registration preference set to " + n);
        this.sendAdminRequest(tLV, true);
    }

    public void shutdown() {
        if (this.adminBall != null) {
            if (this.adminBall.okToSendData()) {
                this.adminBall.sendSignOff(null);
            }
            this.adminBall.close();
            this.adminBall = null;
            this.adminUI = null;
        }
    }

    private void internalError(String string) {
        if (this.adminUI != null) {
            this.adminUI.disconnect();
        }
        if (this.adminBall != null) {
            this.adminBall.close("admin connection dropped", 29);
        }
        this.adminUI = null;
        this.adminBall = null;
    }

    public int serviceHostOnline(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        if (this.adminBall == null && this.compareGroups(nArray, this.getFamilies()) > 0) {
            this.adminBall = fLAPSock;
            Log.log(MODULE, Log.DB0, "AdminCore::serviceHostOnline()");
            ServiceHandler serviceHandler = (ServiceHandler)this.dispatcher.getHandler(1);
            serviceHandler.clientOnline(this.adminBall, this, null, this.getFamilyVersions());
            if (this.adminUI != null) {
                this.adminUI.setEnabled(true);
            }
            return 1;
        }
        return 0;
    }

    public int serviceServiceResponse(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        return 0;
    }

    public int serviceRateParamsReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector, Vector vector2) {
        return 0;
    }

    public int serviceRateParamChange(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector) {
        return 0;
    }

    public int servicePause(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        return 0;
    }

    public int serviceResume(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        return 0;
    }

    public int serviceNickInfoUpdate(FLAPSock fLAPSock, Object object, ReqID reqID, int n, SnacNicknameWinfo snacNicknameWinfo) {
        return 0;
    }

    public int serviceEvilNotification(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector) {
        return 0;
    }

    public int serviceMigrateGroups(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, int[] nArray, TLV tLV) {
        return 0;
    }

    public int serviceMotd(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, TLV tLV) {
        return 0;
    }

    public int serviceWellKnownUrls(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        return 0;
    }

    public int serviceNoop(FLAPSock fLAPSock, Object object, ReqID reqID, int n) {
        return 1;
    }
}

