/*
 * Decompiled with CFR 0.152.
 */
package main;

import component.ChatProtoTool;
import component.Tools;
import flap.FLAPSock;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import main.CallbackData;
import main.ChatAPI;
import main.ChatServerAPI;
import main.ClientDispatcher;
import main.Nickname;
import main.Oscar;
import main.SnacConnectionHandler;
import snac.ChatHandler;
import snac.ChatListener;
import snac.ChatRoomDesc;
import snac.ReqID;
import snac.ServiceHandler;
import snac.ServiceListener;
import snac.SnacConstants;
import snac.SnacIcbmCookie;
import snac.SnacNickname;
import snac.SnacNicknameWinfo;
import snac.SnacVersion;
import snac.TLV;
import uiutil.ErrorMgr;
import util.JUtil;
import util.Log;

public class ChatCore
extends SnacConnectionHandler
implements ChatServerAPI,
SnacConstants,
ChatListener,
ServiceListener {
    private static String MODULE = "ChatCore";
    private ChatAPI chatTool;
    private ClientDispatcher dispatcher;
    private Vector chatRooms = new Vector();
    private int[] families;
    private Vector familyVersions;

    public ChatCore(ClientDispatcher clientDispatcher, Tools tools) {
        this.dispatcher = clientDispatcher;
        Log.log(MODULE, Log.DEBUG, "registering listeners...");
        clientDispatcher.registerListener(1, 2, this);
        clientDispatcher.registerListener(14, 1, this);
        Log.log(MODULE, Log.DEBUG, "creating ChatProtoTool...");
        this.chatTool = new ChatProtoTool(this, tools);
    }

    private int[] getFamilies() {
        if (this.families == null) {
            this.families = new int[2];
            this.families[0] = 1;
            this.families[1] = 14;
        }
        return this.families;
    }

    private Vector getFamilyVersions() {
        if (this.familyVersions == null) {
            this.familyVersions = new Vector();
            this.familyVersions.addElement(new SnacVersion(1, 2, 1, Oscar.buildNumber));
            this.familyVersions.addElement(new SnacVersion(14, 1, this.chatTool.id(), this.chatTool.version()));
        }
        return this.familyVersions;
    }

    private boolean notAChatRoom(FLAPSock fLAPSock) {
        if (this.chatRooms != null && fLAPSock != null) {
            int n = this.chatRooms.size();
            int n2 = 0;
            while (n2 < n) {
                if (fLAPSock.equals((FLAPSock)this.chatRooms.elementAt(n2))) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public int chatRoomInfoUpdate(FLAPSock fLAPSock, Object object, ReqID reqID, int n, ChatRoomDesc chatRoomDesc) {
        if (this.notAChatRoom(fLAPSock)) {
            return 0;
        }
        Log.log(MODULE, Log.DEBUG, "chatRoomInfoUpdate");
        String string = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        Integer n5 = null;
        Integer n6 = null;
        TLV tLV = chatRoomDesc.description.tlv;
        if (tLV.tlvTypePresent(211)) {
            string = chatRoomDesc.description.tlv.getTlvDataAsString(211);
        }
        if (tLV.tlvTypePresent(104)) {
            n3 = new Integer(tLV.getTlvDataAsS32(104));
        }
        if (tLV.tlvTypePresent(117)) {
            n4 = new Integer(tLV.getTlvDataAsS32(117));
        }
        this.chatTool.roomInfoUpdate(fLAPSock, string, n2, n3, n4, n5, n6);
        return 1;
    }

    public int chatUsersJoined(FLAPSock fLAPSock, Object object, ReqID reqID, int n, Vector vector) {
        if (this.notAChatRoom(fLAPSock)) {
            return 0;
        }
        Log.log(MODULE, Log.DEBUG, "chatUsersJoined");
        int n2 = vector.size();
        Nickname[] nicknameArray = new Nickname[n2];
        int n3 = 0;
        while (n3 < n2) {
            SnacNicknameWinfo snacNicknameWinfo = (SnacNicknameWinfo)vector.elementAt(n3);
            nicknameArray[n3] = new Nickname(snacNicknameWinfo);
            Log.log(MODULE, Log.DEBUG, "chatUsersJoined: user[" + n3 + "]=" + nicknameArray[n3].nickname);
            ++n3;
        }
        this.chatTool.usersJoined(fLAPSock, nicknameArray);
        return 1;
    }

    public int chatUsersLeft(FLAPSock fLAPSock, Object object, ReqID reqID, int n, Vector vector) {
        if (this.notAChatRoom(fLAPSock)) {
            return 0;
        }
        Log.log(MODULE, Log.DEBUG, "chatUsersLeft");
        int n2 = vector.size();
        Nickname[] nicknameArray = new Nickname[n2];
        int n3 = 0;
        while (n3 < n2) {
            SnacNicknameWinfo snacNicknameWinfo = (SnacNicknameWinfo)vector.elementAt(n3);
            nicknameArray[n3] = new Nickname(snacNicknameWinfo);
            Log.log(MODULE, Log.DEBUG, "chatUsersLeft: user[" + n3 + "]=" + nicknameArray[n3].nickname);
            ++n3;
        }
        this.chatTool.usersLeft(fLAPSock, nicknameArray);
        return 1;
    }

    public int chatChannelMsgToclient(FLAPSock fLAPSock, Object object, ReqID reqID, int n, SnacIcbmCookie snacIcbmCookie, int n2, TLV tLV) {
        Nickname nickname;
        if (this.notAChatRoom(fLAPSock)) {
            return 0;
        }
        Log.log(MODULE, Log.DEBUG, "chatChannelMsgToclient");
        byte[] byArray = tLV.getTlvData(3);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            SnacNicknameWinfo snacNicknameWinfo = new SnacNicknameWinfo(dataInputStream);
            nickname = new Nickname(snacNicknameWinfo);
        }
        catch (IOException iOException) {
            ErrorMgr.warn(MODULE, "Error reading sender nickname for CHANNEL_MSG_TOCLIENT. Message dropped.", iOException);
            return 1;
        }
        byArray = tLV.getTlvData(5);
        boolean bl = false;
        if (tLV.tlvTypePresent(2)) {
            bl = true;
        }
        boolean bl2 = false;
        if (tLV.tlvTypePresent(7)) {
            bl2 = true;
        }
        this.chatTool.receiveChannelMessage(fLAPSock, nickname, n2, snacIcbmCookie.data, byArray, bl, bl2);
        return 1;
    }

    public int chatEvilReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, int n3) {
        if (this.notAChatRoom(fLAPSock)) {
            return 0;
        }
        CallbackData callbackData = (CallbackData)object;
        String string = "unknown";
        if (callbackData != null) {
            string = callbackData.to;
        }
        this.chatTool.acknowledgeEvil(fLAPSock, n2, n3, string);
        return 1;
    }

    public int chatClientErr(FLAPSock fLAPSock, Object object, ReqID reqID, int n, SnacIcbmCookie snacIcbmCookie, int n2, SnacNickname snacNickname, int n3, byte[] byArray) {
        if (this.notAChatRoom(fLAPSock)) {
            return 0;
        }
        String string = Nickname.snacNickname(snacNickname);
        if (n3 == 1) {
            String string2 = null;
            if (byArray != null) {
                string2 = new String(byArray);
            }
            this.chatTool.payloadError(fLAPSock, string, n2, snacIcbmCookie.data, string2);
        }
        if (n3 == 2) {
            this.chatTool.channelSpecificError(fLAPSock, string, n2, snacIcbmCookie.data, byArray);
        } else {
            ErrorMgr.warn(MODULE, "Unexpected client error " + n3 + ". Ignoring.");
        }
        return 1;
    }

    public String toString() {
        return MODULE;
    }

    public void requestTimedOut(Object object) {
        if (object == null) {
            return;
        }
        CallbackData callbackData = (CallbackData)object;
        if (callbackData.responseExpected) {
            this.warn(object, "The chat server is not responding", null);
        }
    }

    public boolean connectionSignOff(FLAPSock fLAPSock, TLV tLV, boolean bl) {
        if (this.notAChatRoom(fLAPSock)) {
            return false;
        }
        if (this.chatTool != null) {
            this.chatTool.disconnect(fLAPSock);
        }
        return true;
    }

    public boolean connectionClosed(FLAPSock fLAPSock, boolean bl, String string, int n, boolean bl2) {
        if (this.notAChatRoom(fLAPSock)) {
            return false;
        }
        if (this.chatTool != null) {
            this.chatTool.disconnect(fLAPSock);
        }
        this.chatRooms.removeElement(fLAPSock);
        fLAPSock = null;
        return true;
    }

    public int snacError(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, TLV tLV) {
        if (this.notAChatRoom(fLAPSock)) {
            return 0;
        }
        String string = tLV.getTlvDataAsString(4);
        int n3 = -1;
        if (tLV.tlvTypePresent(8)) {
            n3 = tLV.getTlvDataAsU16(8);
        }
        this.warn(object, this.lookup(SnacConnectionHandler.generalErrors, n2), string);
        return 1;
    }

    public void sendEvil(Object object, String string, int n, boolean bl) {
        if (string == null) {
            Log.log(MODULE, Log.INFO, "Attempt to warn without specifying whom.");
            return;
        }
        ChatHandler chatHandler = (ChatHandler)this.dispatcher.getHandler(14);
        CallbackData callbackData = new CallbackData(string, false, true, 14, 7, "warn " + string, null);
        int n2 = 0;
        if (bl) {
            n2 |= 1;
        }
        chatHandler.evilRequest((FLAPSock)object, this, callbackData, n2, Nickname.snacNickname(string), 999, new TLV(0));
    }

    public void joinRoom(int n, byte[] byArray, int n2) {
        Log.log(MODULE, Log.DEBUG, "joinRoom: requesting connection to exchange=" + n + ", cookie=" + JUtil.toHexString(byArray) + ", instance=" + n2);
        Vector<Object> vector = new Vector<Object>(3);
        vector.addElement(new Integer(n));
        vector.addElement(byArray);
        vector.addElement(new Integer(n2));
        if (JUtil.isTrue(Oscar.config.getValue("debug.chatnoserver"))) {
            Log.log(MODULE, Log.DEBUG, "Connection to chat server disabled with setting debug.chatnoserver.");
            String string = "dummy";
            this.chatRooms.addElement(string);
            this.chatTool.connect(string);
            this.chatTool.setEnabled(string, true);
            return;
        }
        Oscar.bosCore.requestService(this.chatTool, "chat", vector);
    }

    public void sendMessage(Object object, String string, int n, byte[] byArray, byte[] byArray2, boolean bl, boolean bl2) {
        String string2 = "send a message to ";
        string2 = bl ? String.valueOf(string2) + string : String.valueOf(string2) + "chat room";
        CallbackData callbackData = new CallbackData(string, false, false, 14, 5, string2, byArray);
        TLV tLV = new TLV();
        if (bl) {
            tLV.addTlv(2, string);
        } else {
            tLV.addTlv(1);
            tLV.addTlv(6);
        }
        tLV.addTlv(5, byArray2);
        if (bl2) {
            tLV.addTlv(7);
        }
        ChatHandler chatHandler = (ChatHandler)this.dispatcher.getHandler(14);
        Log.log(MODULE, Log.DEBUG, "sendMessage: sending message");
        chatHandler.channelMsgTohost((FLAPSock)object, this, callbackData, new SnacIcbmCookie(byArray), n, tLV);
    }

    public void sendPayloadError(Object object, String string, int n, byte[] byArray, String string2) {
        CallbackData callbackData = new CallbackData(string, true, false, 14, 9, "tell " + string + " we don't understand his data.", null);
        ChatHandler chatHandler = (ChatHandler)this.dispatcher.getHandler(14);
        chatHandler.clientErr((FLAPSock)object, this, callbackData, new SnacIcbmCookie(byArray), n, Nickname.snacNickname(string), 1, string2.getBytes());
    }

    public void sendChannelError(Object object, String string, int n, byte[] byArray, byte[] byArray2) {
        String string2 = byArray2 == null ? "null" : JUtil.bytesToHexString(byArray2);
        CallbackData callbackData = new CallbackData(string, true, false, 14, 9, "tell " + string + " channel-specific error " + "for channel " + n + ". Optional info is " + string2, null);
        ChatHandler chatHandler = (ChatHandler)this.dispatcher.getHandler(14);
        chatHandler.clientErr((FLAPSock)object, this, callbackData, new SnacIcbmCookie(byArray), n, Nickname.snacNickname(string), 2, byArray2);
    }

    public void shutdown(Object object) {
        if (object != null) {
            FLAPSock fLAPSock = (FLAPSock)object;
            if (fLAPSock.okToSendData()) {
                fLAPSock.sendSignOff(null);
            }
            fLAPSock.close();
            this.chatRooms.removeElement(fLAPSock);
            fLAPSock = null;
        }
    }

    public int serviceHostOnline(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        if (this.notAChatRoom(fLAPSock) && this.compareGroups(nArray, this.getFamilies()) > 0) {
            this.chatRooms.addElement(fLAPSock);
            this.chatTool.connect(fLAPSock);
            Log.log(MODULE, Log.DEBUG, String.valueOf(MODULE) + "serviceHostOnline: " + "sending client online.");
            ServiceHandler serviceHandler = (ServiceHandler)this.dispatcher.getHandler(1);
            serviceHandler.clientOnline(fLAPSock, this, null, this.getFamilyVersions());
            this.chatTool.setEnabled(fLAPSock, true);
            return 1;
        }
        return 0;
    }

    public int serviceServiceResponse(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        return 0;
    }

    public int serviceRateParamsReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector, Vector vector2) {
        return 0;
    }

    public int serviceRateParamChange(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector) {
        return 0;
    }

    public int servicePause(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        return 0;
    }

    public int serviceResume(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        return 0;
    }

    public int serviceNickInfoUpdate(FLAPSock fLAPSock, Object object, ReqID reqID, int n, SnacNicknameWinfo snacNicknameWinfo) {
        return 0;
    }

    public int serviceEvilNotification(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector) {
        return 0;
    }

    public int serviceMigrateGroups(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, int[] nArray, TLV tLV) {
        return 0;
    }

    public int serviceMotd(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, TLV tLV) {
        return 0;
    }

    public int serviceWellKnownUrls(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        return 0;
    }

    public int serviceNoop(FLAPSock fLAPSock, Object object, ReqID reqID, int n) {
        return 1;
    }
}

